/*
 * PIMPPA - Checks filename validity
 *
 * Returns: 0 ok, 
 *          1 duplicate
 *          2 invalid
 *         -1 internal error
 *
 * All output is printed to stderr because suck doesn't
 * tolerate unnecessary output to stdout.
 *
 */
#include <ctype.h>
#include <dirent.h>
#include <getopt.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <regex.h>

#include "pimppa.h"

MYSQL *src_db;

int Verbose=0;
int Nazi=0;

int dosuck(int areaid, unsigned long options);

void usage(char *name)
{
	fprintf(stderr, "Usage: %s <options> [filename]\n\n"
					"-a <area_id>     Look from this area and descendants\n"
					"-n               Nazi mode, discard files with no known dest. area\n"
					"-s               Work as file selector for suck\n"
					"-v               Verbose execution\n", name);
}

/*
 * We use _exit() here because suck won't otherwise always 
 * understand that this program is really dead
 *
 */
int main(int argc, char *argv[])
{
	int areaid=-1,go=1, retval=-1;
	int suck=0;
	unsigned long options=0;

	while(go)
	{
		switch(getopt(argc, argv, "a:hnvs"))
		{
			case 'a':
				areaid=atoi(optarg);
				break;
			case 'v':
				options|=OPT_VERBOSE;
				Verbose=1;
				break;
			case 'n':
				options|=OPT_NAZI;
				Nazi=1;
				break;
			case 's':
				suck=1;
				break;
			case -1:
				go=0;
				break;
			case 'h':
			default:
				usage(argv[0]);
				_exit(-1);
				break;
		}
	}

	src_db=p_connect();
	if(!src_db)
		_exit(-1);

	if(suck)
		retval=dosuck(areaid, options);
	else
	{
		if(argv[optind])
		{
			retval=p_checkfile(src_db, areaid, argv[optind], options);
			if(Verbose)
				fprintf(stderr, "%s\n", Results[retval]);
		}
		else
			usage(argv[0]);
	}
	
	mysql_close(src_db);

	_exit(retval);
}

/*
 * This routine is not so good
 *
 */
int dosuck(int areaid, unsigned long options)
{
	FILE *log;
	time_t now;
	int buflen=65536;
	char *headerbuffer;
//	char *debugbuf;
	int hlen=1,i,delfile;
	char scratch[256];
	char logfile[PATH_MAX];
	char *matchloc=NULL, *fname=NULL;
	int accepted=0,skipped=0;
	regex_t preq;						// Processed regexp filetype patterns
	regmatch_t pmatch[1];				// One match location
	char *value;

	value=p_getmisc(src_db, P_FILETYPES);
	if(!value)
		value=P_FILETYPES;
		
	// Preprocess the filetype patterns to preq
	regcomp(&preq, value, REG_ICASE|REG_EXTENDED); 

	value=p_getmisc(src_db, P_KEY_TMPDIR);
	if(value)
		sprintf(logfile, "%s%ssuckdl.log", 
			value, (p_checkp(value) ? "" : "/"));
	else
		sprintf(logfile, "%s%ssuckdl.log", 
			P_TMPDIR, (p_checkp(P_TMPDIR) ? "" : "/"));
		
	log=fopen(logfile, "a");
	if(!log)
	{
		fprintf(stderr, "Unable to open %s for writing\n", scratch);
		regfree(&preq);
		_exit(1);
	}

	time(&now);
	fprintf(stderr, "Starting pchkfn for area %d at %s", areaid, ctime(&now));
	fprintf(log, "Starting pchkfn for area %d at %s", areaid, ctime(&now));
	
	headerbuffer=malloc(buflen);
//	debugbuf=malloc(buflen);
	if(!headerbuffer)
	{
		fprintf(stderr, "Urk, unable to alloc %d bytes\n", buflen);
		fprintf(log, "Urk, unable to alloc %d bytes\n", buflen);
		regfree(&preq);
		fclose(log);
		_exit(2);
	}

	while(hlen>0)
	{
		delfile=1;fname=NULL;

		// Read the header size line given by suck
		fgets(scratch, 256, stdin);
		hlen=atoi(scratch);
//		fprintf(stderr, "Set hlen to %d\n", hlen);

		if(hlen<=0)
			break;			// The end

		// If buffer is too small for this header, enlarge
		if(hlen>buflen)
		{
			buflen=2*hlen;
//			realloc(debugbuf, buflen);
			if(!realloc(headerbuffer, buflen))
			{
				fprintf(stderr, "Urk, unable to realloc %d bytes\n", buflen);
				fprintf(log, "Urk, unable to realloc %d bytes\n", buflen);
				regfree(&preq);
				fclose(log);
				_exit(0);
			}
		}

		// Read the whole header
		fread(headerbuffer, hlen, 1, stdin);
//		strcpy(debugbuf, headerbuffer);
	
		// We are interested only in the subject line
		matchloc=strstr(headerbuffer, "\nSubject:");
		if(matchloc)
		{
			int retval;

			retval=0;
			matchloc[0]=0;	// Terminate beginning of line
			matchloc++;

			for(i=0;matchloc[i]!='\n' && matchloc[i]!=0;i++);
			matchloc[i]=0;	// Terminate end of line

			if(Verbose)
				fprintf(stderr, "%s\n", matchloc);

			fprintf(log, "%s\n", matchloc);

			// Does the line match any filetype pattern? => parse fname & check
			if(!regexec(&preq, matchloc, 1, pmatch, 0))
			{
				matchloc[pmatch[0].rm_eo]=0; // Terminate fname end
				for(i=pmatch[0].rm_so;i>=0 && matchloc[i]!=' ';i--); // Term beg
			
				fname=&matchloc[i+1];
	
				retval=p_checkfile(src_db, areaid, fname, options);
				if(!retval)
					delfile=0;
			}
			
			if(Verbose)
			{
				fprintf(stderr,"  P: %s %s", 
						(delfile ? "SKIP" : "TAKE"),
						(fname ? fname : "[]"));
				if(retval)
					fprintf(stderr, " (%s)\n", Results[retval]);
				else
					fprintf(stderr, "\n");
				// Debug flush
				fflush(stderr);
			}
			
			fprintf(log, "  P: %s %s", 
					(delfile ? "SKIP" : "TAKE"),
					(fname ? fname : "[]"));
			if(retval)
				fprintf(log, " (%s)\n", Results[retval]);
			else
				fprintf(log, "\n");	
			// Debug flush
			fflush(log);
		
			if(delfile)
				skipped++;
			else
				accepted++;
		}
		
		fprintf(stdout, "%d\n", delfile);
		fflush(stdout);

		// Why just "printf" won't work?!?!?
		//sprintf(scratch, "echo %d", delfile);
		//system(scratch);
	}

	// Debug
	//fprintf(stderr, "End. Scratch: %s Hlen: %d Last hdr:\n%s\n", 
	//		scratch, hlen, debugbuf);
	//fflush(stderr);

	time(&now);
	//fprintf(log, "End. Scratch: %s Hlen: %d Last hdr:\n%s\n", 
	//		scratch, hlen, debugbuf);
	fprintf(stderr, "Ending pchkfn for area %d (accepted %d of %d) at %s\n", 
			areaid, accepted, skipped+accepted, ctime(&now));
	fflush(stderr);
	fprintf(log, "Ending pchkfn for area %d (accepted %d of %d) at %s\n", 
			areaid, accepted, skipped+accepted, ctime(&now));
	fflush(log);

	fclose(log);

	free(headerbuffer);
	regfree(&preq);

	return(0);
}
	
