/***************************************************************************
 *            pilot-todo.h
 *
 *  Sun Jan 30 16:07:47 2005
 *  Copyright  2005  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _PILOT_TODO_H
#define _PILOT_TODO_H

#include <glib.h>
#include <qof.h>
#include "pilot-qof.h"
#include "pi-todo.h"
#include "qof-main.h"

#define PQ_MOD_PILOT "pilotqof-objects"
#define PILOT_LINK_QOF_TODO  "pilot_todo"

typedef struct {
	QofInstance inst;
	char* category;
	ToDo_t wrap; // 0.12
}qof_todo;

qof_todo* todo_create(QofBook*);

gboolean ToDoRegister(void);
int todo_unpack(QofEntity *ent, gpointer user_data);
int todo_pack(QofEntity *ent, gpointer user_data);
int qof_todo_free(QofEntity *ent, gpointer user_data);
int todo_appinfo_unpack(QofEntity *ent, gpointer user_data);

#endif /* _PILOT-TODO_H */
