/***************************************************************************
 *   Copyright (C) 2008 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PROCESS_KDE_H
#define PROCESS_KDE_H

#include <qstringlist.h>
#include <qobject.h>
#include <qdir.h>
class KProcess;

#include "global.h"

namespace Process
{
class ProcessIO : public QObject
{
Q_OBJECT
public:
  ProcessIO(QObject *parent = 0);
  virtual ~ProcessIO();
  void setArguments(const QStringList &args);
  void setWorkingDirectory(const QDir &dir);
  bool start(QStringList *env = 0);
  bool isRunning() const;
  bool normalExit() const;
  int exitStatus() const;
  QByteArray readStdout();
  QByteArray readStderr();
  Q_LONG processIdentifier() const;

public slots:
  void kill() const;
  void writeToStdin(const QByteArray &buf);

private slots:
  void receivedStdout(KProcess*, char *buf, int len);
  void receivedStderr(KProcess*, char *buf, int len);

signals:
  void readyReadStdout();
  void readyReadStderr();
  void processExited();

private:
  KProcess   *_kproc;
  QByteArray  _stdout, _stderr;
};

} // namespace

#endif
