/* Generated from "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod" by precompile.pike running Pike v7.8 release 700
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 3

#undef PRECOMPILE_SUB_PIKEVARS
#define PRECOMPILE_SUB_PIKEVARS 1

#undef PRECOMPILE_DYNAMIC_TYPES
#define PRECOMPILE_DYNAMIC_TYPES 1


#line 1 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
*/

#include "global.h"
#include "fdlib.h"
#include "pike_netlib.h"
#include "object.h"
#include "interpret.h"
#include "operators.h"
#include "bignum.h"
#include "sscanf.h"
#include "builtin_functions.h"
#include "interpret.h"
#include "cyclic.h"
#include "backend.h"
#include "fd_control.h"
#include "file_machine.h"
#include "file.h"
#include "whitespace.h"
#include "pike_types.h"
#include "pike_threadlib.h"
#include "buffer.h"
#include "module_support.h"
#include "bitvector.h"

#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#undef MP_INT
#include <gmp.h>

#define DEFAULT_CMOD_STORAGE static


#ifndef PIKE_UNUSED_ATTRIBUTE
#define PIKE_UNUSED_ATTRIBUTE
#endif
#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id) PIKE_UNUSED_ATTRIBUTE;
#ifndef TYPEOF
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#endif /* !TYPEOF */
#ifndef PIKE_UNUSED
/* Compat with Pike 7.8 and earlier. */
/* NB: Not strictly correct; PIKE_UNUSED was added the
 *     day after set_program_id_to_id(), but good enough.
 */
#ifndef UNUSED
#define UNUSED(X)	X
#endif
#ifndef set_program_id_to_id
/* NB: Recent Pike 7.8 has a #define that conflicts with
 *     the following declaration.
 */
static void set_program_id_to_id(void*UNUSED(id)){}
#endif
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !PIKE_UNUSED */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_clear_fun_num_used 1
#else
#undef f_Buffer_clear_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_int_fun_num_used 1
#else
#undef f_Buffer_read_int_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_range_error_fun_num_used 1
#else
#define f_Buffer_range_error_fun_num_used 1
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_buffer_fun_num_used 1
#else
#undef f_Buffer_read_buffer_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__size_object_fun_num_used 1
#else
#undef f_Buffer_cq__size_object_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_sint_fun_num_used 1
#else
#undef f_Buffer_read_sint_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_sprintf_fun_num_used 1
#else
#undef f_Buffer_sprintf_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_consume_fun_num_used 1
#else
#undef f_Buffer_consume_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_int8_fun_num_used 1
#else
#undef f_Buffer_add_int8_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_fun_num_used 1
#else
#undef f_Buffer_add_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_hstring_fun_num_used 1
#else
#undef f_Buffer_read_hstring_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_lock_fun_num_used 1
#else
#undef f_Buffer_lock_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_hstring_fun_num_used 1
#else
#undef f_Buffer_add_hstring_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_ints_fun_num_used 1
#else
#undef f_Buffer_add_ints_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__sizeof_fun_num_used 1
#else
#undef f_Buffer_cq__sizeof_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_1_fun_num_used 1
#else
#undef f_Buffer_read_1_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_json_fun_num_used 1
#else
#undef f_Buffer_read_json_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_int16_fun_num_used 1
#else
#undef f_Buffer_read_int16_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_int8_fun_num_used 1
#else
#undef f_Buffer_read_int8_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_sscanf_fun_num_used 1
#else
#undef f_Buffer_sscanf_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_cstring_fun_num_used 1
#else
#undef f_Buffer_read_cstring_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__sprintf_fun_num_used 1
#else
#undef f_Buffer_cq__sprintf_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_set_error_mode_fun_num_used 1
#else
#undef f_Buffer_set_error_mode_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_int32_fun_num_used 1
#else
#undef f_Buffer_add_int32_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_input_from_fun_num_used 1
#else
#undef f_Buffer_input_from_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_padding_fun_num_used 1
#else
#undef f_Buffer_add_padding_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_int_fun_num_used 1
#else
#undef f_Buffer_add_int_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_set_max_waste_fun_num_used 1
#else
#undef f_Buffer_set_max_waste_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_RewindKey_destroy_fun_num_used 1
#else
#undef f_Buffer_RewindKey_destroy_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_hint_fun_num_used 1
#else
#undef f_Buffer_add_hint_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_RewindKey_release_fun_num_used 1
#else
#undef f_Buffer_RewindKey_release_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_hint_fun_num_used 1
#else
#undef f_Buffer_read_hint_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_RewindKey_create_fun_num_used 1
#else
#undef f_Buffer_RewindKey_create_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_hbuffer_fun_num_used 1
#else
#undef f_Buffer_read_hbuffer_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_try_output_fun_num_used 1
#else
#undef f_Buffer_try_output_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__backtick_5B_5D_eq_fun_num_used 1
#else
#undef f_Buffer_cq__backtick_5B_5D_eq_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_add_int16_fun_num_used 1
#else
#undef f_Buffer_add_int16_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Buffer_RewindKey_program_fun_num_used 1
#else
#undef Buffer_RewindKey_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cast_fun_num_used 1
#else
#undef f_Buffer_cast_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_RewindKey_update_fun_num_used 1
#else
#undef f_Buffer_RewindKey_update_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_output_to_fun_num_used 1
#else
#undef f_Buffer_output_to_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_RewindKey_rewind_fun_num_used 1
#else
#undef f_Buffer_RewindKey_rewind_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_unread_fun_num_used 1
#else
#undef f_Buffer_unread_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_create_fun_num_used 1
#else
#undef f_Buffer_create_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_2_fun_num_used 1
#else
#undef f_Buffer_read_2_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Buffer_program_fun_num_used 1
#else
#undef Buffer_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq___fd_set_output_fun_num_used 1
#else
#undef f_Buffer_cq___fd_set_output_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__backtick_5B_5D_fun_num_used 1
#else
#undef f_Buffer_cq__backtick_5B_5D_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_trim_fun_num_used 1
#else
#undef f_Buffer_trim_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_match_fun_num_used 1
#else
#undef f_Buffer_match_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Buffer_f_Buffer_read_fun_num_used 1
#else
#undef Buffer_f_Buffer_read_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_try_read_fun_num_used 1
#else
#undef f_Buffer_try_read_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__encode_fun_num_used 1
#else
#undef f_Buffer_cq__encode_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_int24_fun_num_used 1
#else
#undef f_Buffer_read_int24_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_int32_fun_num_used 1
#else
#undef f_Buffer_read_int32_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_cq__decode_fun_num_used 1
#else
#undef f_Buffer_cq__decode_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_rewind_key_fun_num_used 1
#else
#undef f_Buffer_rewind_key_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_rewind_on_error_fun_num_used 1
#else
#undef f_Buffer_rewind_on_error_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_ints_fun_num_used 1
#else
#undef f_Buffer_read_ints_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Buffer_read_only_fun_num_used 1
#else
#undef f_Buffer_read_only_fun_num_used
#endif
#line 39 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct sysmem {
  unsigned char *p;
  size_t size;
};

static struct program *buffer_error_program;

/*! @module Stdio
 */

/*! @class Buffer
 *!
 *! A buffer to use as input or buffering when doing I/O. It is
 *! similar to @[String.Buffer], but can only contain 8bit data and is
 *! designed for protocol parsing. It is optimized for reading from
 *! the beginning and adding to the end, and will try to minimize the
 *! amount of data copying that is done.
 *!
 *! The class maintains two separate offsets, one for reading and one
 *! for writing. The functions that add data all do so at the write
 *! offset (the end of the buffer), and reading is done from the read
 *! offset (the start of the buffer).
 *!
 *! The class can also be used to directly read from and write to
 *! filedescriptors if so desired. This eliminates at least one memory
 *! copy.
 *!
 *! @note
 *!  The "avoid copy" part means that a Buffer will never shrink
 *!  unless you call the @[trim] function.
 *!
 */

#undef class_Buffer_defined
#define class_Buffer_defined
DEFAULT_CMOD_STORAGE struct program *Buffer_program=NULL;

#ifdef Buffer_program_fun_num_used
DEFAULT_CMOD_STORAGE int Buffer_program_fun_num=-1;
#endif /* Buffer_program_fun_num_used */
#line 73 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
#ifdef PRECOMPILE_SUB_PIKEVARS
  
#undef var_b_Buffer_defined
#define var_b_Buffer_defined

#undef var_b_Buffer_defined_2
#define var_b_Buffer_defined_2
#line 76 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
#else
#warning Stdio.Buffer should be compiled with a newer precompiler
#warning for full functionality. You can achieve this by touching
#warning src/modules/_Stdio/buffer.cmod and recompiling once the
#warning compilation is done.
#endif

  
#undef extra_Buffer_defined
#define extra_Buffer_defined

#undef var_b_Buffer_defined_3
#define var_b_Buffer_defined_3

#undef THIS
#define THIS ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BUFFER
#define THIS_BUFFER ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BUFFER
#define OBJ2_BUFFER(o) ((struct Buffer_struct *)(o->storage+Buffer_storage_offset))

#undef GET_BUFFER_STORAGE
#define GET_BUFFER_STORAGE(o) ((struct Buffer_struct *)(o->storage+Buffer_storage_offset)
static ptrdiff_t Buffer_storage_offset;
struct Buffer_struct {

#ifdef var_b_Buffer_defined_3
#line 88 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
Buffer b;
#endif /* var_b_Buffer_defined_3 */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Buffer_struct *Buffer_gdb_dummy_ptr;
#endif
#line 90 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
static void io_set_error_mode( Buffer *io, struct program *m )
  {
    if( m ) add_ref(m);
    if( io->error_mode ) free_program( io->error_mode );
    io->error_mode = m;
  }

  static size_t io_len( Buffer *io )
  {
    return io->len-io->offset;
  }

  static void io_unlock( Buffer *io )
  {
    io->locked--;
  }

  static void io_lock( Buffer *io )
  {
    io->locked++;
  }

  static void io_was_locked( )
    ATTRIBUTE((noclone,noinline));

  static void io_was_locked( )
  {
      Pike_error("Can not modify the buffer right now, "
                 " there are active subbuffers.\n");
  }

  static void io_ensure_unlocked(Buffer *io)
  {
    if( io->locked )
      io_was_locked( );
  }

  static void io_trim( Buffer *io )
    ATTRIBUTE((noinline));

  static INT_TYPE io_consume( Buffer *io, int num )
  {
    io->offset += num;
    if( UNLIKELY(io->allocated > (io_len(io) * io->max_waste)) )
        io_trim(io);
    return io_len(io);
  }

  static unsigned char *io_read_pointer(Buffer *io)
  {
    return io->buffer + io->offset;
  }

  static int io_is_whitespace( Buffer *io, size_t pos )
  {
    if( pos > io_len( io ) )
      return -1;
    switch( io->buffer[io->offset+pos] )
    {
      SPACECASE8
        return 1;
    }
    return 0;
  }

  static void io_trim( Buffer *io )
  {
      if( !io->locked && io->malloced && (io->offset > 64 || io->len > 64) )
      {
          if( !io->locked_move && io->offset > 64 && io->offset > io_len(io))
          {
              memmove( io->buffer, io_read_pointer(io), io_len(io) );
              io->len -= io->offset;
              io->num_move++;
              io->offset = 0;
          }
          if( io->len > 64 && ((io->allocated > (io->len)*(1.0+io->max_waste))))
          {
              void *new_ptr = xrealloc( io->buffer, io->len );
              if( !new_ptr )
                  Pike_error(msg_out_of_mem_2, io->len);

              io->buffer = new_ptr;
              io->num_malloc++;
              io->allocated = io->len;
          }
      }
  }

  static void io_unlink_external_storage( Buffer *io )
    ATTRIBUTE((noclone,noinline));

  static void io_unlink_external_storage( Buffer *io )
  {
      if( io->sub ) {
          io_unlock( get_storage(io->sub,Buffer_program ) );
          free_object( io->sub );
      }
      if( io->source ) free_object( io->source );
      if( io->str ) free_string( io->str );
      io->source = 0;
      io->sub = 0;
      io->str = 0;
  }

  static void io_ensure_malloced( Buffer *io, size_t bytes )
  {
    if( UNLIKELY(!io->malloced) )
    {
      /* convert to malloced buffer from a shared one. */
        unsigned char *old = io->buffer;

        bytes += io->len;

        if (bytes < io->len || bytes + 100 < bytes)
            Pike_error(msg_out_of_mem_2, bytes + 100);

        bytes += 100;

        io->buffer = xalloc( bytes );
        io->malloced = 1;
        io->allocated = bytes;
        io->num_malloc++;
        memcpy( io->buffer, old, io->len );
        io_unlink_external_storage(io);
    }
  }

  static unsigned char *io_add_space_do_something( Buffer *io, size_t bytes, int force )
    ATTRIBUTE((noclone,noinline));
  static unsigned char *io_add_space_do_something( Buffer *io, size_t bytes, int force )
  {
    if( bytes && io->len+bytes < io->len )
      Pike_error("Too large buffer, can not have more than %lu bytes",
                 (size_t)-1);


    io_ensure_unlocked(io);
    io_ensure_malloced(io, bytes);

    /*
     * It is actually not certain that checking this is a good idea.
     *
     * The reason being that if the current buffer size is very small
     * (io_len(io)) and the bytes added is large and there is an
     * offset, it makes sense to move now when we do not have to copy
     * as much.
     *
     */
    if( LIKELY(!io->locked_move) )
    {
      if( UNLIKELY((force && io->offset) || (io->offset > io->len)) )
      {
        /* more than 50% of the buffer is available before the read pointer,
         * and we can discard that data. Move the data to the beginning, making
         * room for more data.
         */
        memmove( io->buffer, io_read_pointer(io), io_len(io) );
        io->num_move++;
        io->len -= io->offset;
        io->offset = 0;
      }
    }

    if( UNLIKELY(io->len + bytes > io->allocated) )
    {
      /* Actually grow the buffer. */
      void *new_ptr;
      size_t growth =
          (io->allocated>>1) +
          (io->allocated>>3);/* io->allocated * 0.625 */

      if( growth < bytes )
          growth = bytes + (bytes>>1);

      if( io->allocated + growth < io->allocated )
      {
          growth = bytes+1;
          if( io->allocated + growth < io->allocated )
              Pike_error("Overflow in buffer size calculations\n");
      }
      new_ptr = xrealloc( io->buffer, io->allocated + growth );
      if( !new_ptr )
        Pike_error(msg_out_of_mem_2, io->allocated+growth );
      io->buffer = new_ptr;
      io->num_malloc++;
      io->allocated += growth;
    }
    return io->buffer+io->len;
  }

  static unsigned char *io_add_space( Buffer *io, size_t bytes, int force )
  {
    if( io->len == io->offset )
      io->offset = io->len = 0;
    if( !force && io->malloced && !io->locked && io->len+bytes < io->allocated &&
        (!bytes || io->len+bytes > io->len))
      return io->buffer+io->len;
    return io_add_space_do_something( io, bytes, force );
  }

  /*! @decl protected bool range_error( int howmuch )
   *!
   *! This function is called when an attempt is made to read out of bounds.
   *!
   *! The default implementation simply returns @expr{0@} (zero).
   *!
   *! Override this function to change the behavior.
   *!
   *! @param howmuch
   *! The argument @[howmuch] indicates how much data is needed:
   *!
   *! @int
   *!  @value 1..
   *!   Need @[howmuch] bytes more
   *!  @value 0
   *!   The amount of data needed is not certain.
   *!   This most often happens when  @[sscanf] or @[read_json] is used
   *!  @value ..-1
   *!   Tried to @[unread] -@[howmuch] bytes. There is usually no way to satisfy
   *!   the requested range.
   *!
   *!   The only supported way is to extract the data from the buffer,
   *!   add the requested amount of "go backbuffer", add the data
   *!   back, and forward -@[howmuch] bytes.
   *! @endint
   *!
   *! @returns
   *!
   *! @[true] if the operation should be retried, @[false] otherwise.
   *!
   *! Do not return true unless you have added data to the buffer,
   *! doing so could result in an infinite loop (since no data is
   *! added, the range_error will be called again immediately).
   */
  #define f_Buffer_range_error_defined

#ifdef f_Buffer_range_error_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_range_error_fun_num = 0;

#endif /* f_Buffer_range_error_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_range_error(INT32 args) {
#line 325 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE range;
#line 325 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("range_error",args,1);
#line 325 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("range_error",1,"int");
#line 325 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
range=Pike_sp[0-1].u.integer;
#line 327 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Pike_sp[-1].u.integer = 0;
  }

  }
#line 331 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
static void io_range_error_throw( Buffer *io, int howmuch )
    ATTRIBUTE((noclone,noinline));

  static void io_range_error_throw( Buffer *io, int howmuch )
  {
    if( io->error_mode )
    {
      struct object *err;
      if( howmuch > 0 )
      {
        push_text("Trying to read %d bytes outside allowed range\n");
        push_int(howmuch);
        f_sprintf(2);
      }
      else
        push_text("Illegal arguments\n");

      if( io->error_mode != buffer_error_program )
      {
        ref_push_object( io->this );
        err = clone_object(io->error_mode,2);
      }
      else
        err = clone_object(io->error_mode,1);

      push_object(err);
      f_throw(1);
    }
  }

  static struct pike_string *io_read_string( Buffer *io, ptrdiff_t len )
    ATTRIBUTE((noclone,noinline));
  static size_t io_rewind( Buffer *io, INT_TYPE n );

  static void io_do_rewind_on_error( struct rewind_to *e )
  {
    e->io->locked_move--;
    e->io->offset = e->rewind_to;
    free( e );
  }

  static void io_rewind_on_error( Buffer *io, ONERROR *x )
  {
    struct rewind_to *rew = xalloc( sizeof( struct rewind_to ) );
    io->locked_move++;
#if defined(PIKE_DEBUG)
    rew->old_locked_move = io->locked_move;
#endif
    rew->io = io;
    rew->rewind_to = io->offset;
    SET_ONERROR( (*x), io_do_rewind_on_error, rew );
  }

  static void io_unset_rewind_on_error( Buffer *io, ONERROR *x )
  {
    struct rewind_to *rew = x->arg;
#if defined(PIKE_DEBUG)
    if( io->locked_move != rew->old_locked_move )
      Pike_fatal( "Invalid io_rewind_on_error nesting\n");
#endif
    free( rew );
    UNSET_ONERROR( (*x) );
    io->locked_move--;
  }

  static void io_do_unwrite_on_error( struct rewind_to *e )
  {
    e->io->len = e->rewind_to;
    free( e );
  }

  static void io_unwrite_on_error( Buffer *io, ONERROR *x )
  {
    struct rewind_to *rew = xalloc( sizeof( struct rewind_to ) );
    rew->io = io;
    rew->rewind_to = io->len;
    SET_ONERROR( (*x), io_do_unwrite_on_error, rew );
  }

  static void io_unset_unwrite_on_error( Buffer *UNUSED(io), ONERROR *x )
  {
    UNSET_ONERROR( (*x) );
    free( x->arg );
  }

  static ptrdiff_t io_call_write( Buffer *io, struct svalue *fun,
				  ptrdiff_t nbytes )
    ATTRIBUTE((noclone,noinline));

  static void io_set_events( Buffer *io, struct my_file *fd, int extra, int set )
    ATTRIBUTE((noclone,noinline));

  static void io_set_events( Buffer *UNUSED(io), struct my_file *fd, int extra, int set )
  {
    fd->box.revents &= ~((1<<set)|extra);
    if(!SAFE_IS_ZERO(&fd->event_cbs[set]) && fd->box.backend)
      set_fd_callback_events(&fd->box, fd->box.events|(1<<set), 0);
  }

  static ptrdiff_t io_call_write( Buffer *io, struct svalue *fun,
				  ptrdiff_t bytes )
  {
    if( bytes > 0 )
    {
      ptrdiff_t l = 0;
      struct pike_string *s;

      io->locked_move++;
      s = io_read_string( io,bytes );

      if( s )
      {
        io->output_triggered = 1;
        push_string( s );
        apply_svalue( fun, 1 );
	if (UNLIKELY(TYPEOF(Pike_sp[-1]) != PIKE_T_INT)) {
          io->locked_move--;
	  Pike_error("Invalid return value from write callback.\n");
	}
        l = Pike_sp[-1].u.integer;
        pop_stack();
        if( l < 0 )
        {
          io->locked_move--;
          io_rewind( io, bytes );
          return -1;
        }
        if( bytes > l )
        {
          io_rewind( io, bytes-l );
        }
      }
      io->locked_move--;
      return l;
    }
    return -1;
  }

  static ptrdiff_t io_actually_trigger_output( Buffer *io )
    ATTRIBUTE((noclone,noinline));

  static ptrdiff_t io_actually_trigger_output( Buffer *io )
  {
    struct program *prog;
    struct reference *ref;
    struct inherit *inh;

    if (UNLIKELY(!(prog = io->output.u.object->prog))) {
      /* Destructed object. */
      free_svalue(&io->output);
      SET_SVAL(io->output, PIKE_T_INT, NUMBER_NUMBER, integer, 0);
      return 0;
    }
    ref = PTR_FROM_INT(prog, SUBTYPEOF(io->output));
    inh = INHERIT_FROM_PTR(prog, ref);
    if ((inh->prog == file_program) &&
	(ref->identifier_offset == fd_write_identifier_offset)) {
      /* Stdio.Fd::write */
      struct my_file *fd =
	get_inherit_storage( io->output.u.object, ref->inherit_offset );
      io_set_events( io, fd, PIKE_BIT_FD_WRITE_OOB, PIKE_FD_WRITE );
      io->output_triggered = 1;
      return 0;
    }
    else
      return io_call_write( io, &io->output, MINIMUM( io_len(io), 100 ) );
  }

  static ptrdiff_t io_trigger_output( Buffer *io )
  {
    if( UNLIKELY(io->output.u.object) && UNLIKELY(!io->output_triggered) )
      return io_actually_trigger_output(io);
    return 0;
  }

  static int io_range_error( Buffer *io, ptrdiff_t howmuch )
    ATTRIBUTE((noclone,noinline));

  static int io_range_error( Buffer *io, ptrdiff_t howmuch )
  {
      int res;
      struct svalue *osp = Pike_sp;

      push_int64( howmuch );
      apply_current( f_Buffer_range_error_fun_num, 1 );
      res = Pike_sp[-1].u.integer;
      pop_n_elems( Pike_sp-osp );
      if( !res ) io_range_error_throw( io, howmuch );

      return res;
  }

  static int io_avail( Buffer *io, ptrdiff_t len )
  {
    if( len < 0 || len + io->offset > io->len )
    {
        if( len < 0 )
            io_range_error_throw( io, 0 );
        else if( io_range_error( io, len+io->len-io->offset ) )
            return io_avail(io,len);
        return 0;
    }
    return 1;
  }

  static int io_avail_mul( Buffer *io, ptrdiff_t len, ptrdiff_t each  )
  {
    /* safely check if len*each is available. */
    size_t total = io_len(io);
    if( len < 0 || each <= 0 )
    {
      io_range_error_throw( io, 0 );
      return 0;
    }

    if( (total/(size_t)each) < (size_t)len )
    {
        if( io_range_error( io, len+io->len-io->offset ) )
          return io_avail_mul(io,len,each);
        return 0;
    }
    return 1;
  }

  static void io_append( Buffer *io, const void *p, size_t bytes )
  {
    memcpy( io_add_space( io, bytes, 0 ), p, bytes );
    io->len += bytes;
    io_trigger_output( io );
  }

  static size_t io_read( Buffer *io, void *to, size_t len  )
  {
    if( !io_avail(io,len))
      return 0;
    memcpy( to, io_read_pointer(io), len );
    io_consume( io, len );
    return len;
  }

  static struct pike_string *io_read_string( Buffer *io, ptrdiff_t len )
  {
    struct pike_string *s;

    if( len > 0x7fffffff )
      Pike_error("This region is too large to convert to a string.\n");

    if( len < 0 )
      return make_shared_binary_string(NULL,0);

    if( !io_avail(io,len))
     return NULL;

    s = begin_shared_string( len );
    io_read( io, s->str, len );
    return end_shared_string(s);
  }

  static struct object *io_read_buffer( Buffer *io, size_t len, int do_copy )
  {
    struct object *b;
    Buffer *to;
    if( !io_avail(io,len))
      return NULL;

    b = low_clone( Buffer_program );
    to = get_storage(b,Buffer_program);

    io_lock( io );

    to->buffer = io_read_pointer(io);
    to->len = len;
    to->sub = Pike_fp->current_object;
    add_ref(to->sub);
    io_consume( io, len );

    if( do_copy )
      io_ensure_malloced( to, 0 );

    return b;
  }

  static int io_read_byte_uc( Buffer *io )
  {
    return io->buffer[io->offset++];
  }

  static INT_TYPE io_read_number_uc( Buffer *io, size_t len )
  {
    size_t i;
    LONGEST res = 0;
    for( i=0; i<len; i++ )
    {
      res <<= 8;
      res |= io_read_byte_uc(io);
    }
    return res;
  }

  static INT_TYPE io_read_signed_number_uc( Buffer *io, size_t len )
  {
    size_t i;
    INT_TYPE res = 0;
    if( !len ) return 0;
    len--;
    res = io_read_byte_uc(io);
    if( res & 0x80 )
      res = (-1<<8)|res;
    for( i=0; i<len; i++ )
    {
      res <<= 8;
      res |= io_read_byte_uc(io);
    }
    return res;
  }

  static LONGEST io_read_number( Buffer *io, size_t len )
  {
    LONGEST res;
    if( !io_avail(io, len) )
      return -1;
    /* ensure only leading 0:s */
    for (; UNLIKELY(len > SIZEOF_INT_TYPE); len--)
      if( UNLIKELY(io_read_byte_uc(io)) )
        Pike_error("Integer (%dbit) overflow.\n", SIZEOF_INT_TYPE*8);

    res = io_read_number_uc( io, len );

    if ( UNLIKELY(res < 0) )
      Pike_error("Signed (%dbit) overflow.\n", SIZEOF_INT_TYPE*8);
    return res;
  }

  static struct object *io_read_bignum( Buffer *io, size_t len )
  {
    struct object *o;
    MP_INT *i;
    unsigned char *p;
    LONGEST res;

    if( !io_avail(io,len) ) return NULL;
    o = fast_clone_object(get_auto_bignum_program());
    i = (void*)o->storage;
    mpz_import( i, len, 1, 1, 0, 0, io_read_pointer(io) );
    io_consume(io,len);
    return o;
  }

  static void io_add_bignum( Buffer *io, struct object *o, int width )
    ATTRIBUTE((noclone,noinline));

  static void io_add_bignum( Buffer *io, struct object *o, int width )
  {
    MP_INT *i = (void*)o->storage;
    MP_INT tmp;
    int free;
    unsigned char*d;
    struct pike_string *s;
    int pad = 0;
    ptrdiff_t bytes;
    size_t exp;

    if( mpz_sgn( i ) < 0 )
    {
      mpz_init( &tmp );
      mpz_add_ui( &tmp, i, 1);
      pad = 0xff;
      i = &tmp;
    }

    bytes = (mpz_sizeinbase( i, 2 )+7) / 8;

    if( bytes > width )
      Pike_error("Number too large to store in %d bits\n", width*8);

    d = io_add_space( io, width, 0 );
    io->len += width;

    if( width > bytes )
    {
      memset( d, pad, width-bytes );
      d += width-bytes;
    }

    mpz_export( d, &exp, 1, 1, 1, 0, i );
    if( !exp )
    {
      /* if i is 0 mpz_export will not write anything.
         Handle that by zeroing the byte that should have been written.
      */
#ifdef PIKE_DEBUG
      if( bytes != 1 )
        Pike_fatal("Oddities abound\n");
#endif
      *d = pad;
    }
    if( pad )
    {
      while(exp--)
        *d++ ^= 0xff; /* pad, but that is 0xff */
      mpz_clear(&tmp);
    }
  }

  static void io_add_int_uc( Buffer *io, ptrdiff_t i, size_t bytes )
  {
    unsigned char *x = io->buffer+io->len;
    io->len += bytes;
    while(bytes--)
    {
      x[bytes] = i;
      i>>=8;
    }
  }

  static size_t io_add_int( Buffer *io, ptrdiff_t i, size_t bytes )
  {
    io_add_space(io, bytes, 0);
    io_add_int_uc( io, i, bytes );
    io_trigger_output( io );
    return io_len( io );
  }

  static size_t io_rewind( Buffer *io, INT_TYPE n )
  {
    if( n < 0 || (io->offset < (unsigned)n) )
    {
        if( n < 0 )
            io_range_error_throw( io, 0 );
        else if( io_range_error(io,-(long)(n-io->offset)) )
          return io_rewind( io, n );
      return -1;
    }
    io->offset -= n;
    io_trigger_output( io );
    return io->offset;
  }

  static void io_append_byte_uc( Buffer *io, unsigned char byte )
  {
      io->buffer[io->len++] = byte;
  }

  static void io_append_short_uc( Buffer *io, unsigned short shrt )
  {
      io->buffer[io->len++] = shrt>>8;
      io->buffer[io->len++] = shrt;
  }

  static void io_append_int_uc( Buffer *io, unsigned INT32 i )
  {
      io->buffer[io->len++] = i>>24;
      io->buffer[io->len++] = i>>16;
      io->buffer[io->len++] = i>>8;
      io->buffer[io->len++] = i;
  }


  static size_t io_svalue_len( Buffer *io, struct svalue *p )
  {
    switch( TYPEOF(*p) ) {
      case PIKE_T_INT:
        return 1;
      case PIKE_T_STRING:
        if( !p->u.string->size_shift )
          return p->u.string->len;
        break;
      case PIKE_T_ARRAY: {
        size_t len;
        struct array *argp = p->u.array;
        INT_TYPE i;
        DECLARE_CYCLIC();

        if (BEGIN_CYCLIC(io, argp))
          Pike_error("Attempt to append a cyclic array to a buffer.\n");

        for(len=i=0; i<argp->size; i++ )
          len += io_svalue_len( io, argp->item+i );

        END_CYCLIC();
        return len;
      }
      case PIKE_T_OBJECT: {
        size_t len;
        if( get_memory_object_memory( p->u.object, NULL, &len, NULL ) )
          return len;
        break;
      }
    }
    Pike_error("Illegal argument (not an 8bit string or 8bit buffer object)\n");
  }

  /* NOTE: Can return negative integers. */
  static INT_TYPE get_small_int( struct svalue *s )
    ATTRIBUTE((noclone,noinline));

  static INT_TYPE get_small_int( struct svalue *s )
  {
    if( LIKELY(TYPEOF(*s) == PIKE_T_INT) )
      return s->u.integer;

    if( is_bignum_object_in_svalue( s ) )
    {
      INT64 i64;
      if( int64_from_bignum( &i64, s->u.object ) )
        return i64;
      Pike_error("Too big bignum, can not fit in indicated width\n");
    }
    Pike_error("Non integer argument\n");
  }

  static void io_append_svalue( Buffer *io, struct svalue *p )
    ATTRIBUTE((noinline));

  static void io_append_svalue( Buffer *io, struct svalue *p )
  {
    switch( TYPEOF(*p) )
    {
      case PIKE_T_STRING:
        {
          struct pike_string *s = p->u.string;
	  if( !s->len ) return;
          if( s->size_shift ) Pike_error("Buffer only handles 8bit data\n");
          if( !io->buffer )
          {
#ifdef PIKE_DEBUG
	    if (io->str) Pike_fatal("Buffer with string but NULL buffer.\n");
#endif
            io->str = s;
            io->buffer = (unsigned char*)s->str;
            io->len = s->len;
            add_ref(s);
            io_trigger_output( io );
          }
          else
            io_append( io, s->str, s->len );
        }
        break;
      case PIKE_T_ARRAY:
        {
          struct array *argp = p->u.array;
          INT_TYPE i;
	  DECLARE_CYCLIC();

	  if (BEGIN_CYCLIC(io, argp))
	    Pike_error("Attempt to append a cyclic array to a buffer.\n");

          for(i=0; i<argp->size; i++ )
            io_append_svalue( io, argp->item+i );

	  END_CYCLIC();
        }
        break;
      case PIKE_T_OBJECT:
        {
          size_t len;
          void *ptr;
          struct sysmem *s;
          enum memobj_type t = get_memory_object_memory( p->u.object, &ptr, &len, NULL );

          if( !io->buffer && t==MEMOBJ_SYSTEM_MEMORY )
          {
            io->buffer = ptr;
            io->len = len;

            io->source = p->u.object;
            add_ref(io->source);
            return;
          }
          if( t != MEMOBJ_NONE )
            io_append( io, ptr, len );
          else
            Pike_error("Unsupported argument type\n");
        }
        break;
      case PIKE_T_INT:
        {
          unsigned char a = p->u.integer;
          io_append( io, &a, 1 );
        }
    }
  }

#undef THIS
#define THIS (&(((struct Buffer_struct *)Pike_fp->current_storage)->b))


  /* pike functions */

  /*! @decl int(-1..) input_from( Stdio.Stream f, int|void nbytes )
   *!
   *! Read data from @[f] into this buffer. If @[nbytes] is not
   *! specified, read until there is no more data to read (currently).
   *!
   *! Returns the amount of data that was read, or @expr{-1@} on
   *! read error.
   *!
   *! @note
   *! Please note that this funcition will read all data from the
   *! filedescriptor unless it's set to be non-blocking.
   */
  #define f_Buffer_input_from_defined

#ifdef f_Buffer_input_from_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_input_from_fun_num = 0;

#endif /* f_Buffer_input_from_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_input_from(INT32 args) {
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct object * f;
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * _nbytes;
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * _once;
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("input_from",args,1);
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 3) wrong_number_of_args_error("input_from",args,3);
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_OBJECT) SIMPLE_ARG_TYPE_ERROR("input_from",1,"object");
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(f=Pike_sp[0-args].u.object);
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("input_from",2,"int|void");
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
_nbytes=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else _nbytes = NULL;
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 2) &&
    ((TYPEOF(Pike_sp[2-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[2-args]) != NUMBER_UNDEFINED))) {
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[2-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("input_from",3,"int|void");
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
_once=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else _once = NULL;
{
    Buffer *io = THIS;
    size_t sz = io_len( io );
    size_t bread = 0, nbytes = (size_t)-1;
    struct my_file *fd;
    int once = 0;

    if( _nbytes && (SUBTYPEOF(*_nbytes) == NUMBER_NUMBER) ) {
        nbytes = _nbytes->u.integer;
	if (!nbytes) do { INT_TYPE ret_=(0); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 943 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}

    if( _once )
        once = _once->u.integer;

    if( (fd = get_storage( f, file_program )) )
    {
      while( 1 )
      {
        unsigned char *ptr = io_add_space( io, 4096, 0 );
        int res;

        res = fd_read( fd->box.fd, ptr, MINIMUM(4096,nbytes) );

        if( res == -1 && errno == EINTR )
          continue;

        if( res <= 0 )
          break;

        nbytes -= res;
        io->len += res;
        bread += res;
        if( res != 4096 || once || !nbytes )
            break;
      }
      io_set_events( io, fd, PIKE_BIT_FD_READ_OOB, PIKE_FD_READ );
    }
    else
    {
      /* some other object. Just call read */
      while( nbytes )
      {
        push_int( MINIMUM(4096,nbytes) );
        safe_apply( f, "read", 1 );
        if( TYPEOF(Pike_sp[-1]) != PIKE_T_STRING || Pike_sp[-1].u.string->len == 0 )
          break;
        if( Pike_sp[-1].u.string->size_shift )
            Pike_error("Can not handle non-8bit data\n");
        io_append( io, Pike_sp[-1].u.string->str, Pike_sp[-1].u.string->len );
        nbytes -= Pike_sp[-1].u.string->len;
        pop_stack();
      }
    }

    if (!bread) do { INT_TYPE ret_=(-1); pop_n_elems(args); push_int(ret_); return; }while(0);do { INT_TYPE ret_=(
#line 990 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bread); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 991 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}

  }
/*! @decl int __fd_set_output( object|function(string:int) write_callback )
   *!
   *! This tells the buffer to trigger the write callback for the
   *! specified filedescriptor when data is added to the buffer.
   *!
   *! This is used internally by Stdio.File to handle nonblocking
   *! buffered mode, and is not really intended to be used directly.
   *!
   *! If @[write_callback] is @expr{0@} (zero) the state is cleared.
   */
  #define f_Buffer_cq___fd_set_output_defined

#ifdef f_Buffer_cq___fd_set_output_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq___fd_set_output_fun_num = 0;

#endif /* f_Buffer_cq___fd_set_output_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq___fd_set_output(INT32 args) {
#line 1003 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * f;
#line 1003 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("__fd_set_output",args,1);
#line 1003 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
f=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    Buffer *io = THIS;
    if( TYPEOF(*f) == PIKE_T_OBJECT ) {
      struct program *p = f->u.object->prog;
      if (p) {
	struct inherit *inh = p->inherits + SUBTYPEOF(*f);
	int write_fun_num;
	p = inh->prog;
	if ((write_fun_num = find_identifier("write", p)) == -1) {
	  Pike_error("Function \"write\" not available in object.\n");
	}
	SET_SVAL_TYPE_SUBTYPE(*f, PIKE_T_FUNCTION, write_fun_num);
      }
    } else if (TYPEOF(*f) != PIKE_T_FUNCTION) {
      push_int(0);
      f = Pike_sp-1;
    }
    assign_svalue(&io->output, f);
    io->output_triggered = 0;
  }

  }
/*! @decl int(-1..) output_to( Stdio.Stream|function(string:int) fun, @
   *!                            int(0..)|void nbytes )
   *!
   *! Write data from the buffer to the indicated file.
   *!
   *! @param fun
   *!   Write function. Either one of:
   *!   @mixed
   *!     @type Stdio.Stream
   *!       A file object in which the function @expr{write()@} will
   *!       be called.
   *!     @type function(string:int)
   *!       A function which will be called with a @expr{string(8bit)@}
   *!       to write and is expected to return an @expr{int@} indicating
   *!       the number of bytes successfully written or @expr{-1@} on
   *!       failure.
   *!   @endmixed
   *!
   *! @param nbytes
   *!   If @[nbytes] is not specified the whole buffer will be written
   *!   if possible.  Otherwise at most @[nbytes] will be written.
   *!
   *! @returns
   *! Will return the number of bytes that have been written successfully.
   *!
   *! If no bytes have been written successfully and @expr{fun()@} failed
   *! with an error, @expr{-1@} will be returned.
   */
  #define f_Buffer_output_to_defined

#ifdef f_Buffer_output_to_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_output_to_fun_num = 0;

#endif /* f_Buffer_output_to_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_output_to(INT32 args) {
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * f;
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * nbytes;
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("output_to",args,1);
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 2) wrong_number_of_args_error("output_to",args,2);
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
f=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("output_to",2,"int|void");
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
nbytes=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else nbytes = NULL;
{
    Buffer *io = THIS;
    ptrdiff_t written = 0;
    ptrdiff_t sz = io_len( io );
    int write_fun_num = -1;

    if( !sz )
    {
      io_range_error(io,  sz);
      sz = io_len(io);
    }
    if( nbytes && (SUBTYPEOF(*nbytes) == NUMBER_NUMBER) )
      sz = MINIMUM(nbytes->u.integer, sz);

    if( TYPEOF(*f) == PIKE_T_OBJECT ) {
      struct program *p = f->u.object->prog;
      if (LIKELY(p)) {
	struct inherit *inh = p->inherits + SUBTYPEOF(*f);
	p = inh->prog;
	if ((write_fun_num = find_identifier("write", p)) == -1) {
	  Pike_error("Function \"write\" not available in object.\n");
	}
	SET_SVAL_TYPE_SUBTYPE(*f, PIKE_T_FUNCTION, write_fun_num);
      } else {
	SIMPLE_BAD_ARG_ERROR("output_to", 1, "object|function");
      }
    } else if (UNLIKELY(TYPEOF(*f) != PIKE_T_FUNCTION)) {
      SIMPLE_BAD_ARG_ERROR("output_to", 1, "object|function");
    } else {
      write_fun_num = SUBTYPEOF(*f);
    }

    if (write_fun_num != FUNCTION_BUILTIN) {
      struct program *prog = f->u.object->prog;
      struct reference *ref = PTR_FROM_INT(prog, write_fun_num);
      struct inherit *inh = INHERIT_FROM_PTR(prog, ref);

      if( (inh->prog == file_program) &&
	  (ref->identifier_offset == fd_write_identifier_offset) ) {
	struct my_file *fd =
	  get_inherit_storage( f->u.object, ref->inherit_offset );
	while( sz > written )
	{
	  ptrdiff_t rd = MINIMUM(sz-written,4096);
	  unsigned char *ptr = io_read_pointer( io );
	  ptrdiff_t res;
	  res = fd_write( fd->box.fd, ptr, rd );
	  if( res == -1 && errno == EINTR )
	    continue;
	  if( res <= 0 ) {
	    fd->my_errno = errno;
	    if (!written) written = -1;
	    break;
	  }
	  io_consume( io, res );
	  written += res;
	  io_set_events( io, fd, PIKE_BIT_FD_WRITE_OOB, PIKE_FD_WRITE);
	}
	do { INT_TYPE ret_=(written); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1113 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}
    }

    /* Some other object or function. Just call it. */
    while( sz > written )
    {
      size_t rd = MINIMUM(sz-written,4096);
      ptrdiff_t wr = io_call_write( io, f, rd );
      if( wr <= 0 )
      {
	if (!written) written = -1;
	break;
      }
      written += wr;
      if( wr < 4096 )
	break;
    }
    do { INT_TYPE ret_=(written); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1131 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}

  }
/*! @decl int(-1..) try_output()
   *!
   *! Try to write some data from the buffer to the file
   *! registered with @[__fd_set_output()].
   *!
   *! This is typically called from backend callbacks when it
   *! seems that it is possible to write some data to the file.
   *!
   *! @returns
   *!   Returns @expr{-1@} on write error, and otherwise
   *!   the number of bytes written to the file.
   *!
   *! @seealso
   *!   @[__fd_set_output()]
   */
  #define f_Buffer_try_output_defined

#ifdef f_Buffer_try_output_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_try_output_fun_num = 0;

#endif /* f_Buffer_try_output_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_try_output(INT32 args) {
#line 1148 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("try_output",args,0);
{
    Buffer *io = THIS;
    if (LIKELY(io->output.u.object) && LIKELY(!io->output_triggered))
      do { INT_TYPE ret_=(io_actually_trigger_output(io));  push_int(ret_); return; }while(0);do { INT_TYPE ret_=(
#line 1153 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
0);  push_int(ret_); return; }while(0);
#line 1154 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}

  }
/*! @decl int read_sint( int size )
   *!
   *! Read a network byte order two:s complement signed number of size n*8 bits, then
   *! return it.
   *!
   *! Will return UNDEFINED if there is not enough buffer space
   *! available unless error mode is set to throw errors.
   */
  #define f_Buffer_read_sint_defined

#ifdef f_Buffer_read_sint_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_sint_fun_num = 0;

#endif /* f_Buffer_read_sint_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_sint(INT32 args) {
#line 1164 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE nbytes;
#line 1164 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("read_sint",args,1);
#line 1164 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_sint",1,"int");
#line 1164 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
nbytes=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    struct pike_string *tmp;
    Pike_sp--;
    if( !io_avail( io, nbytes ) )
    {
      push_undefined();
      return;
    }
    if( nbytes <= SIZEOF_INT_TYPE )
    {
      push_int( io_read_signed_number_uc( io,nbytes ) );
      return;
    }

    /* It's a bignum. */
    /* We should probably optimize this. :) */
    tmp = io_read_string( io, nbytes );
    if( tmp->str[0]&0x80 )
    {
      push_int(-1);
      push_int( nbytes * 8 );
      o_lsh();
    }
    ref_push_string( tmp );
    push_int( 256 );
    push_object( clone_object( get_auto_bignum_program(), 2 ) );
    if( tmp->str[0]&0x80 )
      o_xor();
    free_string( tmp );
  }

  }
#define f_Buffer_cq__size_object_defined

#ifdef f_Buffer_cq__size_object_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__size_object_fun_num = 0;

#endif /* f_Buffer_cq__size_object_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__size_object(INT32 args) {
#line 1197 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("_size_object",args,0);
{
      do { INT_TYPE ret_=(THIS->malloced ? THIS->allocated : 0);  push_int(ret_); return; }while(0);
#line 1200 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}

  }
/*! @decl Buffer add_padding( int(0..) nbytes, int(0..255)|void byte )
   *!
   *! Add @[nbytes] bytes of padding, if @[byte] is not specified the
   *! area will be filled with 0's, otherwise the specified byte will
   *! be repeated.
   */
  #define f_Buffer_add_padding_defined

#ifdef f_Buffer_add_padding_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_padding_fun_num = 0;

#endif /* f_Buffer_add_padding_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_padding(INT32 args) {
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE nbytes;
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * _byte;
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("add_padding",args,1);
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 2) wrong_number_of_args_error("add_padding",args,2);
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_padding",1,"int(0..)");
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
nbytes=Pike_sp[0-args].u.integer;
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_padding",2,"int|void");
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
_byte=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else _byte = NULL;
{
    Buffer *io = THIS;
    int byte = 0;
    if( _byte ) byte = _byte->u.integer;

    if( nbytes < 0 )
      Pike_error("Cannot add negative padding.\n");

    memset( io_add_space( io, nbytes,0), byte, nbytes );
    io->len += nbytes;
    Pike_sp -= args;
    ref_push_object( io->this );
  }

  }
/*! @decl Buffer add( AddArgument ... data )
   *! @code
   *!  private typedef @[System.Memory]|@[Stdio.Buffer]|@[String.Buffer] BufferObject;
   *!  private typedef BufferObject|string(8bit)|int(8bit)|array(AddArgument) AddArgument;
   *! @endcode
   *!
   *! Add the items in data to the end of the buffer.
   *!
   *! The supported argument types are:
   *!
   *! @mixed
   *!  @type string(0..255)
   *!   An eight bit string.
   *!  @type int(0..255)
   *!   A single byte
   *!  @type System.Memory
   *!   A chunk of memory. The whole memory area is added.
   *!  @type Stdio.Buffer
   *!   A chunk of memory. The whole memory area is added.
   *!  @type String.Buffer
   *!   A chunk of memory. The whole memory area is added.
   *!  @type array(AddArgument)
   *!   Add all elements in the array individually. Each element may be
   *!   any one of the types listed here.
   *! @endmixed
   *!
   *! @seealso
   *! @[sprintf], @[add_int8], @[add_int16], @[add_int32], @[add_int]
   *! and
   *! @[add_hstring]
   */
  #define f_Buffer_add_defined

#ifdef f_Buffer_add_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_fun_num = 0;

#endif /* f_Buffer_add_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add(INT32 args) {
#line 1254 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * argp;
#line 1254 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 1254 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  } while (++argcnt < args-0);
  argp=Pike_sp+0-args;
} else argp = NULL;
#line 1255 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    int i;
    Buffer *io = THIS;

    for(i=0; i<args; i++ )
      io_append_svalue( io, argp+i );

    pop_stack();
    ref_push_object(io->this);
  }

  }
/*! @decl Buffer add_int8( int(0..255) )
   *! Adds a single byte to the buffer.
   */
  #define f_Buffer_add_int8_defined

#ifdef f_Buffer_add_int8_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_int8_fun_num = 0;

#endif /* f_Buffer_add_int8_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_int8(INT32 args) {
#line 1269 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE i;
#line 1269 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("add_int8",args,1);
#line 1269 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_int8",1,"int");
#line 1269 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
i=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    *io_add_space(io,1,0)=i;
    io->len++;
    Pike_sp--;
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl Buffer add_int16( int(0..65535) )
   *!
   *! Add a 16-bit network byte order value to the buffer
   */
  #define f_Buffer_add_int16_defined

#ifdef f_Buffer_add_int16_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_int16_fun_num = 0;

#endif /* f_Buffer_add_int16_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_int16(INT32 args) {
#line 1282 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE i;
#line 1282 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("add_int16",args,1);
#line 1282 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_int16",1,"int");
#line 1282 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
i=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    unsigned char *p = io_add_space(io,2,0);
    p[0] = i>>8;
    p[1] = i;
    io->len += 2;
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl Buffer add_int32( int i )
   *! Adds a 32 bit network byte order value to the buffer
   */
  #define f_Buffer_add_int32_defined

#ifdef f_Buffer_add_int32_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_int32_fun_num = 0;

#endif /* f_Buffer_add_int32_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_int32(INT32 args) {
#line 1295 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE i;
#line 1295 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("add_int32",args,1);
#line 1295 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_int32",1,"int");
#line 1295 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
i=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    unsigned char *p = io_add_space(io,4,0);
    p[0] = i>>24;
    p[1] = i>>16;
    p[2] = i>>8;
    p[3] = i;
    io->len += 4;
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl Buffer add_hstring( string(0..255) data, int size_size )
   *! @decl Buffer add_hstring( Stdio.Buffer data, int size_size )
   *! @decl Buffer add_hstring( System.Memory data, int size_size )
   *! @decl Buffer add_hstring( String.Buffer data, int size_size )
   *! @decl Buffer add_hstring( int(0..255) data, int size_size )
   *! @decl Buffer add_hstring( array data, int size_size )
   *! @decl Buffer add_hstring( int|string(0..255)|Stdio.Buffer|System.Memory|array data, int size_size, int offset )
   *!
   *! Adds length of data followed by @[data] to the buffer.
   *!
   *! This is identical to
   *! @tt{sprintf("%"+size_size+"H",(string)Stdio.Buffer(data))@} but
   *! significantly faster.
   *!
   *! @[size_size] is the number of bytes used to represent the length of the data.
   *! It must be less than Int.NATIVE_MAX.
   *!
   *! @[offset] is added to the length of the data prior to writing out
   *! the length.  Typical usage involves adding @[size_size] to account
   *! for the room used by the size.
   *!
   *! The supported @[data] argument types are
   *!
   *! @mixed
   *!  @type int(0..255)
   *!   An eight bit character.
   *!  @type string(0..255)
   *!   An eight bit string.
   *!  @type System.Memory
   *!   A chunk of memory. The whole memory area is added.
   *!  @type Stdio.Buffer
   *!   A chunk of memory. The whole memory area is added.
   *!  @type String.Buffer
   *!   A chunk of memory. The whole memory area is added.
   *!  @type array
   *!   Add all elements in the array individually. Each element may be
   *!   any one of the types listed here.
   *! @endmixed
   */

  
#line 1347 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
/* we can not use the actual type here.

     the reason is that this class is loaded before the master is, so
     we cannot possibly use things that require the master (such as
     resolving things.)
  */
  #define f_Buffer_add_hstring_defined

#ifdef f_Buffer_add_hstring_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_hstring_fun_num = 0;

#endif /* f_Buffer_add_hstring_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_hstring(INT32 args) {
#line 1354 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * str;
INT_TYPE size_size;
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * offset;
#line 1353 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 2) wrong_number_of_args_error("add_hstring",args,2);
#line 1353 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 3) wrong_number_of_args_error("add_hstring",args,3);
str=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_hstring",2,"int");
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
size_size=Pike_sp[1-args].u.integer;
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 2) &&
    ((TYPEOF(Pike_sp[2-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[2-args]) != NUMBER_UNDEFINED))) {
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[2-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_hstring",3,"void|int");
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
offset=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
#line 1355 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else offset = NULL;
{
    Buffer *io = THIS;
    size_t len = io_svalue_len(io, str);

    if( offset )
      len += offset->u.integer;

    if( size_size < (int)sizeof(size_t) &&
        len > (((size_t)1)<<(8*size_size))-1 )
      Pike_error("Too long string, need larger size field\n");

    io_add_int( io, len, size_size );
    io_append_svalue( io, str );
    pop_n_elems(args);
    ref_push_object(io->this);
  }

  }
/*! @decl Buffer add_int( int i, int(0..) width )
   *!
   *! Adds a generic integer to the buffer as an (width*8)bit
   *! network byteorder number.
   *!
   *! @[width] must be less than Int.NATIVE_MAX.
   *!
   */
  #define f_Buffer_add_int_defined

#ifdef f_Buffer_add_int_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_int_fun_num = 0;

#endif /* f_Buffer_add_int_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_int(INT32 args) {
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * i;
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE width;
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("add_int",args,2);
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
i=Pike_sp+0-2; dmalloc_touch_svalue(Pike_sp+0-2);
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_int",2,"int");
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
width=Pike_sp[1-2].u.integer;
{
    pop_stack(); /* width */
    if( TYPEOF(*i) == PIKE_T_INT )
    {
      io_add_int( THIS, i->u.integer, width );
      Pike_sp--;
    }
    else
    {
      convert_stack_top_to_bignum();
      io_add_bignum( THIS, i->u.object, width );
      pop_stack(); /* o. */
    }
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl Buffer add_hint( int i, int(0..) size_width )
   *!
   *! First add the size of the integer when encoded to base 256 as a
   *! @[size_width] integer, then add the integer to the buffer, both
   *! in network byte order.
   *!
   *! @[size_width] must be less than Int.NATIVE_MAX.
   *!
   */
  #define f_Buffer_add_hint_defined

#ifdef f_Buffer_add_hint_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_hint_fun_num = 0;

#endif /* f_Buffer_add_hint_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_hint(INT32 args) {
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * i;
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE len_width;
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("add_hint",args,2);
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
i=Pike_sp+0-2; dmalloc_touch_svalue(Pike_sp+0-2);
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_hint",2,"int");
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
len_width=Pike_sp[1-2].u.integer;
{
    int width;
    pop_stack(); /* width */
    if( TYPEOF(*i) == PIKE_T_INT )
    {
      INT_TYPE ui = i->u.integer;
      for( width=0; width<SIZEOF_INT_TYPE; width++ )
        if( ui < (((INT_TYPE)1)<<(width*8)) &&
	    ui >= -(((INT_TYPE)1)<<(width*8-1)) )
	  break;
      io_add_int( THIS, width, len_width );
      io_add_int( THIS, i->u.integer, width );
      Pike_sp--;
    }
    else
    {
      convert_stack_top_to_bignum();
      width = (mpz_sizeinbase( (void*)i->u.object->storage, 2)+7)/8;
      io_add_int( THIS, width, len_width );
      io_add_bignum( THIS, i->u.object, width );
      pop_stack(); /* o. */
    }
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl Buffer add_ints( array(int) integers, int(0..255) len )
   *!
   *! Add the integers in the specified array, @[len] bytes per int.
   *! Equivalent to calling @[add_int] for each integer, but faster,
   *! and if an error occurs the buffer will contain no new
   *! data. Either all or none of the integers will be added.
   *!
   *! Errors can occur if one of the elements in @[integers] is not
   *! actually an integer, if sizeof(integers)*len is bigger than can
   *! be represented in a size_t, or if the buffer cannot grow due to
   *! an out of memory condition.
   */
  #define f_Buffer_add_ints_defined

#ifdef f_Buffer_add_ints_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_add_ints_fun_num = 0;

#endif /* f_Buffer_add_ints_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_add_ints(INT32 args) {
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct array * a;
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bpi;
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("add_ints",args,2);
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_ARRAY) SIMPLE_ARG_TYPE_ERROR("add_ints",1,"array(int)");
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(a=Pike_sp[0-2].u.array);
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_ints",2,"int");
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bpi=Pike_sp[1-2].u.integer;
{
    int i,l = a->size;
    struct svalue *it = a->item;
    unsigned char *ptr;
    ptrdiff_t n=0;
    ONERROR e;
    Buffer *io = THIS;

    io_unwrite_on_error(io, &e);

    if( bpi < 0 )
      Pike_error("Illegal int width\n");

#if SIZEOF_LONG == 4
      if( DO_INT32_MUL_OVERFLOW( l, bpi, &n ) )
#else
      if( DO_INT64_MUL_OVERFLOW( l, bpi, &n ) )
#endif
        Pike_error("Result size exceeds ptrdiff_t size\n");

    io_add_space( io, n, 0 );
    switch( bpi )
    {
      case 1:
        for( i=0; i<l; i++ )
          io_append_byte_uc( io, get_small_int(it+i) );
        break;
      case 2:
        for( i=0; i<l; i++ )
          io_append_short_uc( io, get_small_int(it+i) );
        break;
      case 4:
        for( i=0; i<l; i++ )
          io_append_int_uc( io, get_small_int(it+i) );
        break;
      case 3:
#if SIZEOF_INT_TYPE > 4
      case 5:
      case 6:
      case 7:
#endif
        for( i=0; i<l; i++ )
          io_add_int_uc( io, get_small_int(it+i), bpi );
        break;

      default:
        /* bignums. */
        for( i=0; i<l; i++ )
        {
          if( LIKELY(TYPEOF(it[i]) == PIKE_T_INT) )
            io_add_int_uc( io, it[i].u.integer, bpi);
          else if( LIKELY(TYPEOF(it[i]) == PIKE_T_OBJECT) )
            io_add_bignum( io, it[i].u.object, bpi );
          else
            Pike_error("Illegal argument.\n");
        }
    }
    io_unset_unwrite_on_error( io, &e );
    io_trigger_output( io );
    Pike_sp--;
    pop_stack();
    ref_push_object(io->this);
  }

  }
/*! @decl protected int `[](int off)
   *!
   *! Return the character at the specified offset.
   */
  #define f_Buffer_cq__backtick_5B_5D_defined

#ifdef f_Buffer_cq__backtick_5B_5D_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__backtick_5B_5D_fun_num = 0;

#endif /* f_Buffer_cq__backtick_5B_5D_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__backtick_5B_5D(INT32 args) {
#line 1514 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE off;
#line 1514 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 1514 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]",1,"int");
#line 1514 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
off=Pike_sp[0-1].u.integer;
#line 1516 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Buffer *io = THIS;
    if( off < 0 )
      off = io_len(io)-off;

    if( io_avail( io, off ) )
      Pike_sp[-1].u.integer = io_read_pointer(io)[off];
    else
      Pike_sp[-1].u.integer = -1;
  }

  }
/*! @decl protected int `[]=(int off, int char)
   *!
   *! Set the character at the specified offset to @[char].
   */
  #define f_Buffer_cq__backtick_5B_5D_eq_defined

#ifdef f_Buffer_cq__backtick_5B_5D_eq_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__backtick_5B_5D_eq_fun_num = 0;

#endif /* f_Buffer_cq__backtick_5B_5D_eq_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__backtick_5B_5D_eq(INT32 args) {
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE off;
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE val;
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("`[]=",args,2);
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]=",1,"int");
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
off=Pike_sp[0-2].u.integer;
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("`[]=",2,"int");
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
val=Pike_sp[1-2].u.integer;
#line 1533 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Buffer *io = THIS;

    io_ensure_malloced( io, 0 );

    if( off < 0 )  off = io_len(io)-off;
  again:
    if( io_avail( io, off ) )
    {
      io_read_pointer(io)[off]=(val&0xff);
    }
    else
    {
      /* hm, well. We could extend the buffer. Should we? */
      if( io_range_error(io, off ) )
        goto again;
      Pike_error("Writing outside buffer\n");
    }
  }

  }
/*! @decl int _sizeof()
   *!
   *! Returns the buffer size, in bytes.
   *! This is how much you can read from the buffer until it runs out of data.
   */
  #define f_Buffer_cq__sizeof_defined

#ifdef f_Buffer_cq__sizeof_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__sizeof_fun_num = 0;

#endif /* f_Buffer_cq__sizeof_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__sizeof(INT32 args) {
#line 1558 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
#line 1560 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    push_int64(io_len(THIS));
  }

  }
/*! @decl string cast(string type)
   *!
   *! Convert the buffer to a string.
   *!
   *!@note
   *! This only works for buffers whose length is less than 0x7fffffff.
   */
  #define f_Buffer_cast_defined

#ifdef f_Buffer_cast_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cast_fun_num = 0;

#endif /* f_Buffer_cast_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cast(INT32 args) {
#line 1571 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct pike_string * to;
#line 1571 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 1571 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("cast",1,"string");
#line 1571 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(to=Pike_sp[0-1].u.string);
#line 1573 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    if( to != literal_string_string )
    {
      push_undefined();
      return;
    }
    if( io_len(THIS) > 0x7fffffff )
      Pike_error("This buffer is too large to convert to a string.\n");
    push_string(make_shared_binary_string((void*)io_read_pointer(THIS),
                                          (INT32)io_len(THIS)));
  }


  }
/*! @decl Buffer set_error_mode(int m)
   *! @decl Buffer set_error_mode(program m)
   *!
   *! Set the error mode of this buffer to @[m].
   *!
   *! If true operations that would normally return 0 (like trying to
   *! read too much) will instead throw an error. If @[m] is a program
   *! a clone of it will be thrown on error.
   *!
   *! This is useful when parsing received data, you do not have to
   *! verify that each and every read operation suceeds.
   *!
   *! However, the non-error mode is more useful when checking to see
   *! if a packet/segment/whatever has arrived.
   *!
   *! The thrown error object will have the constant buffer_error set
   *! to a non-false value.
   *!
   *! @example
   *! @code
   *! void read_callback(int i, string new_data)
   *! {
   *!   inbuffer->add( new_data );
   *!
   *!   while( Buffer packet = inbuffer->read_hbuffer(2) )
   *!   {
   *!     packet->set_error_mode(Buffer.THROW_ERROR);
   *!     if( mixed e = catch( handle_packet( packet ) ) )
   *!       if( e->buffer_error )
   *!         protocol_error(); // illegal data in packet
   *!       else
   *!         throw(e); // the other code did something bad
   *!    }
   *! }
   *!
   *!
   *! void handle_packet( Buffer pack )
   *! {
   *!   switch( pack->read_int8() )
   *!   {
   *!     ...
   *!   case HEADER_FRAME:
   *!     int num_headers = pack->read_int32();
   *!     for( int i = 0; i<num_headers; i++ )
   *!      headers[pack->read_hstring(2)] = pack->read_hstring(2);
   *!     ...
   *!   }
   *! }
   *! @endcode
   */
  #define f_Buffer_set_error_mode_defined

#ifdef f_Buffer_set_error_mode_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_set_error_mode_fun_num = 0;

#endif /* f_Buffer_set_error_mode_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_set_error_mode(INT32 args) {
#line 1636 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * m;
#line 1636 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("set_error_mode",args,1);
#line 1636 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
m=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{
    if( TYPEOF(*m) == PIKE_T_INT )
      io_set_error_mode( THIS, m->u.integer ? buffer_error_program : 0 );
    else
      io_set_error_mode( THIS, program_from_svalue(m));

    pop_stack();
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl object lock()
   *!
   *! Makes this buffer read only until the returned object is released.
   *!
   *! @note
   *!  This currently simply returns a 0-length subbuffer.
   */
  #define f_Buffer_lock_defined

#ifdef f_Buffer_lock_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_lock_fun_num = 0;

#endif /* f_Buffer_lock_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_lock(INT32 args) {
#line 1654 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("lock",args,0);
{
    push_object( io_read_buffer( THIS, 0, 0 ) );
  }

  }
#define f_Buffer_cq__sprintf_defined

#ifdef f_Buffer_cq__sprintf_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__sprintf_fun_num = 0;

#endif /* f_Buffer_cq__sprintf_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__sprintf(INT32 args) {
#line 1659 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE o;
#line 1659 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 1659 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 1659 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
o=Pike_sp[0-2].u.integer;
#line 1661 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    size_t bytes;
    pop_n_elems(args-1);
    Pike_sp--;
    switch( o )
    {
      case 'O':
        {
          push_text("%O(%d bytes, read=[..%d] data=[%d..%d] free=[%d..%d] %s%s)");
          ref_push_program(Pike_fp->current_object->prog);
          /* io_len [..offset] [offset..len] [..allocated] */
          push_int(io_len(THIS));
          push_int(THIS->offset-1);
          push_int(THIS->offset);

          push_int(THIS->len-1);
          push_int(THIS->len);
          push_int(THIS->allocated);
          push_text( (THIS->str ? "string" : THIS->malloced ? "allocated" : "subbuffer" ) );
          if( THIS->locked )
            push_text(" (read only)");
          else
            push_text("");
          f_sprintf(10);
        }
        break;

      case 's':
	bytes = io_len(THIS);
        push_string( io_read_string(THIS, bytes) );
	io_rewind(THIS, bytes);
        break;

      case 'q':
        push_text("%q");
	bytes = io_len(THIS);
        push_string( io_read_string(THIS, bytes) );
	io_rewind(THIS, bytes);
        f_sprintf(2);
        break;
      default:
        push_undefined();
    }
  }

  }
/*! @decl string(8bit) read_hstring( int(0..) n, void|int offset )
   *!
   *! Identical in functionality to @[read](@[read_number](@[n])) but
   *! faster.
   *!
   *! Read a network byte order number of size n*8 bits, then return the
   *! indicated number of bytes as a string.
   *!
   *! @[offset] is substracted from the specified length prior to reading the
   *! string.  Typical usage involves substracting @[n] to account
   *! for the room used by the size.
   *!
   *! If there is not enough data available return 0.
   *!
   *! Note that pike string can not be longer than 0x7fffffff bytes (~2Gb).
   */
  #define f_Buffer_read_hstring_defined

#ifdef f_Buffer_read_hstring_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_hstring_fun_num = 0;

#endif /* f_Buffer_read_hstring_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_hstring(INT32 args) {
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * offset;
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("read_hstring",args,1);
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 2) wrong_number_of_args_error("read_hstring",args,2);
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_hstring",1,"int");
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-args].u.integer;
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_hstring",2,"void|int");
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
offset=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else offset = NULL;
{
    LONGEST len;
    Buffer *io = THIS;
    struct pike_string *s;
    ONERROR e;

    io_rewind_on_error( io, &e );
    len = io_read_number( io, bytes );

    if (offset)
      len -= offset->u.integer;

    if (len < 0) {
      /* io_avail() in io_read_number() failed. */
      CALL_AND_UNSET_ONERROR(e);
      Pike_sp[-1].u.integer = 0;
      return;
    }

    /* NB: We assume that io_avail() in io_read_string() doesn't throw. */
    s = io_read_string( io, len );

    if( s ) {
      io_unset_rewind_on_error( io, &e );
      Pike_sp--;
      push_string(s);
    } else {
      CALL_AND_UNSET_ONERROR(e);
      Pike_sp[-1].u.integer = 0;
    }
  }

  }
/*! @decl string(8bit) read_cstring( )
   *!
   *! Reads a \0 terminated C-string and returns the
   *! string excluding the terminating \0.
   *!
   *! If there is not enough data available return UNDEFINED.
   *!
   *! Note that pike string can not be longer than 0x7fffffff bytes (~2Gb).
   */
  #define f_Buffer_read_cstring_defined

#ifdef f_Buffer_read_cstring_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_cstring_fun_num = 0;

#endif /* f_Buffer_read_cstring_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_cstring(INT32 args) {
#line 1764 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_cstring",args,0);
{
    LONGEST len;
    Buffer *io = THIS;
    struct pike_string *s;
    ONERROR e;

    io_rewind_on_error( io, &e );
    len = 0;
    do {
      /* search the amount of data we know we have for each call to io_avail */
      while( io_len(io) )
      {
        if( !io_read_byte_uc(io) )
          goto found_null;
        len++;
      }
    }
    while( io_avail( io, 1 ) );
    goto fail;

  found_null:
    io_rewind( io, len+1 );
    s = io_read_string( io, len );

    if( LIKELY(s) ) {
      io_read_byte_uc(io);		  /* consume the terminating \0 byte */
      io_unset_rewind_on_error( io, &e );
      push_string(s);
    } else {
fail: CALL_AND_UNSET_ONERROR(e);
      push_undefined();
    }
  }

  }
/*! @decl Buffer read_hbuffer( int n )
   *! @decl Buffer read_hbuffer( int n, bool copy )
   *!
   *! Same as @[read_hstring], but returns the result as an Buffer.
   *!
   *! No data is copied unless @[copy] is specified and true, the new
   *! buffer points into the old one.
   *!
   *! @note
   *!  As long as the subbuffer exists no data can be added to the
   *!  main buffer.
   *!
   *!  Usually this is OK, since it often represents something that
   *!  should be parsed before the next whatever is extracted from
   *!  the buffer, but do take care.
   *!
   *!  If you need to unlink the new buffer after it has been
   *!  created, call @[trim] in it.
   */
  #define f_Buffer_read_hbuffer_defined

#ifdef f_Buffer_read_hbuffer_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_hbuffer_fun_num = 0;

#endif /* f_Buffer_read_hbuffer_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_hbuffer(INT32 args) {
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * copy;
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("read_hbuffer",args,1);
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 2) wrong_number_of_args_error("read_hbuffer",args,2);
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_hbuffer",1,"int");
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-args].u.integer;
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_hbuffer",2,"int|void");
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
copy=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else copy = NULL;
{
    LONGEST len;
    int do_copy = 0;
    Buffer *io = THIS;
    ONERROR e;

    io_rewind_on_error( io, &e );

    if( copy )  do_copy = copy->u.integer;
    Pike_sp-=args;

    len = io_read_number( io, bytes );
    if( len >= 0 && io_avail( io, len ) )
    {
      push_object( io_read_buffer( io, len, do_copy ) );
      io_unset_rewind_on_error( io, &e );
      return;
    }
    CALL_AND_UNSET_ONERROR(e);
    push_int(0);
  }

  }
/*! @decl Buffer read_buffer( int n )
   *! @decl Buffer read_buffer( int n, bool copy )
   *!
   *! Same as @[read], but returns the result as an Buffer.
   *!
   *! No data is copied unless @[copy] is specified and true, the new buffer
   *! points into the old one.
   *!
   *! @note
   *!  As long as the subbuffer exists no data can be added to the main buffer.
   *!
   *!  Usually this is OK, since it often represents something that
   *!  should be parsed before the next whatever is extracted from
   *!  the buffer, but do take care.
   */
  #define f_Buffer_read_buffer_defined

#ifdef f_Buffer_read_buffer_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_buffer_fun_num = 0;

#endif /* f_Buffer_read_buffer_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_buffer(INT32 args) {
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * copy;
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args < 1) wrong_number_of_args_error("read_buffer",args,1);
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 2) wrong_number_of_args_error("read_buffer",args,2);
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_buffer",1,"int");
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-args].u.integer;
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_buffer",2,"int|void");
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
copy=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else copy = NULL;
{
    int do_copy = 0;
    struct object *o;
    if( copy )
      do_copy = copy->u.integer;
    Pike_sp-=args;
    if( (o = io_read_buffer( THIS, bytes, do_copy )) )
      push_object(o);
    else
      push_int(0);
  }

  }
/*! @decl Buffer sprintf(strict_sprintf_format format, sprintf_args ... args)
   *!
   *! Appends the output from @[sprintf] at the end of the buffer.
   *!
   *! This is somewhat faster than add(sprintf(...)) since no
   *! intermediate string is created.
   */
  #define f_Buffer_sprintf_defined

#ifdef f_Buffer_sprintf_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_sprintf_fun_num = 0;

#endif /* f_Buffer_sprintf_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_sprintf(INT32 args) {
#line 1876 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * ignored;
#line 1876 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 1876 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  } while (++argcnt < args-0);
  ignored=Pike_sp+0-args;
} else ignored = NULL;
{
    ONERROR _e;
    struct string_builder tmp;
    init_string_builder(&tmp,0);
    SET_ONERROR(_e, free_string_builder, &tmp);
    low_f_sprintf(args, 0, &tmp );
    if( tmp.s->size_shift )
      Pike_error("Buffer only handles 8bit data\n");
    io_append( THIS, tmp.s->str, tmp.s->len );
    pop_n_elems(args);
    CALL_AND_UNSET_ONERROR(_e);
    ref_push_object(Pike_fp->current_object);
  }

  }
/*! @decl array sscanf(string(8bit) format)
   *!
   *! Reads data from the beginning of the buffer to match the
   *! specifed format, then return an array with the matches.
   *!
   *! The non-matching data will be left in the buffer.
   *!
   *! See @[array_sscanf] for more information.
   */
  #define f_Buffer_sscanf_defined

#ifdef f_Buffer_sscanf_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_sscanf_fun_num = 0;

#endif /* f_Buffer_sscanf_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_sscanf(INT32 args) {
#line 1902 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct pike_string * format;
#line 1902 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("sscanf",args,1);
#line 1902 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("sscanf",1,"string");
#line 1902 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(format=Pike_sp[0-1].u.string);
{
    INT32 i;
    ptrdiff_t num_used;
    struct svalue *start = Pike_sp;
  retry:
    i = low_sscanf_pcharp(
      MKPCHARP(io_read_pointer(THIS), 0), io_len(THIS),
      MKPCHARP(format->str,format->size_shift), format->len,
      &num_used, 0);

    if( !num_used )
    {
      if( io_range_error(THIS,0) )
          goto retry;
      pop_n_elems(Pike_sp-start);
      push_int(0);
    }
    else
    {
      io_consume( THIS, num_used );
      f_aggregate(Pike_sp-start);
    }
  }


  }
/*! @decl mixed read_json(int|void require_whitespace_separator)
   *!
   *! Read a single JSON expression from the buffer and return it.
   *!
   *! If @[require_whitespace_separator] is true there must be a whitespace
   *! after each json value (as an example, newline or space).
   *!
   *! The JSON is assumed to be utf-8 encoded.
   *!
   *! @returns
   *! UNDEFINED if no data is available to read.
   *! The read value otherwise.
   *!
   *! @note
   *! Unless whitespaces are required this function only really work correctly
   *! with objects, arrays and strings.
   *!
   *! There is really no  way to see where one value starts and the other ends
   *! for most other cases
   */
  #define f_Buffer_read_json_defined

#ifdef f_Buffer_read_json_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_json_fun_num = 0;

#endif /* f_Buffer_read_json_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_json(INT32 args) {
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * require_whitespace;
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 1) wrong_number_of_args_error("read_json",args,1);
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_json",1,"int|void");
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
require_whitespace=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else require_whitespace = NULL;
{
    int stop, whites = 0;
    static ptrdiff_t(*parse_json_pcharp)(PCHARP,size_t,int,char**);
    char *err = NULL;
    if( require_whitespace )
      whites = require_whitespace->u.integer;

    Pike_sp-=args;
    if( !parse_json_pcharp )
      parse_json_pcharp = PIKE_MODULE_IMPORT(Standards.JSON, parse_json_pcharp );
  retry:
    stop = parse_json_pcharp( MKPCHARP(io_read_pointer(THIS),0),
                              io_len(THIS), 1|8, &err ); /* json_utf8 */

    if( stop < 0 )
    {
      if( -stop == (ptrdiff_t)io_len(THIS) || (err && !strncmp(err,"Unterminated",12)))
      {
        if( io_range_error(THIS,0) )
            goto retry;
        push_undefined();
      }
      else
      {
        /* FIXME: Use real json error? */
        if( err )
          Pike_error("Syntax error in json at offset %d: %s\n", -stop, err );
        else
          Pike_error("Syntax error in json at offset %d\n", -stop );
      }
    }
    else
    {
      if( whites &&
          (io_is_whitespace(THIS,stop)<=0 && io_is_whitespace(THIS,stop-1)<=0))
      {
        if( stop == (ptrdiff_t)io_len(THIS) )
        {
          if( io_range_error(THIS,0) )
              goto retry;
          pop_stack();
          push_undefined();
        }
        else
          Pike_error("Missing whitespace between json values at offset %d\n", stop );
      }
      else
      {
        if( whites )
          while( io_is_whitespace( THIS, stop ) )
            stop++;
        io_consume( THIS, stop );
      }
    }
  }

  }
/*! @decl mixed match(string(8bit) format)
   *!
   *! Reads data from the beginning of the buffer to match the
   *! specifed format, then return the match.
   *!
   *! The non-matching data will be left in the buffer.
   *!
   *! This function is very similar to @[sscanf], but the
   *! result is the sum of the matches. Most useful to match
   *! a single value.
   *!
   *! @example
   *! @code
   *!  // get the next whitespace separated word from the buffer.
   *!  buffer->match("%*[ \t\r\n]%[^ \t\r\n]");
   *! @endcode
   */
  #define f_Buffer_match_defined

#ifdef f_Buffer_match_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_match_fun_num = 0;

#endif /* f_Buffer_match_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_match(INT32 args) {
#line 2022 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct pike_string * format;
#line 2022 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("match",args,1);
#line 2022 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("match",1,"string");
#line 2022 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(format=Pike_sp[0-1].u.string);
{
    INT32 i;
    ptrdiff_t num_used;
    struct svalue *start = Pike_sp;
  retry:
    i = low_sscanf_pcharp(
      MKPCHARP(io_read_pointer(THIS), 0), io_len(THIS),
      MKPCHARP(format->str,format->size_shift), format->len,
      &num_used,
      0);

    if( !num_used )
    {
      if( io_range_error(THIS,0) )
          goto retry;
      pop_n_elems(Pike_sp-start);
      push_int(0);
    }
    else
    {
      io_consume( THIS, num_used );
      if( Pike_sp-start > 1 )
        f_add(Pike_sp-start);
    }
  }

  }
/*! @decl void clear()
   *!
   *! Clear the buffer.
   */
  #define f_Buffer_clear_defined

#ifdef f_Buffer_clear_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_clear_fun_num = 0;

#endif /* f_Buffer_clear_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_clear(INT32 args) {
#line 2053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("clear",args,0);
{
    Buffer *io = THIS;
    io->offset = io->len = 0;
  }

  }
/*! @decl void set_max_waste(float factor)
   *!
   *! Configure how much free space should be allowed, at most, as a
   *! factor of the current buffer size.
   *!
   *! The default is 0.5, leaving at most half the buffer as waste.
   *!
   */
  #define f_Buffer_set_max_waste_defined

#ifdef f_Buffer_set_max_waste_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_set_max_waste_fun_num = 0;

#endif /* f_Buffer_set_max_waste_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_set_max_waste(INT32 args) {
#line 2067 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
FLOAT_TYPE howmuch;
#line 2067 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("set_max_waste",args,1);
#line 2067 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_FLOAT) SIMPLE_ARG_TYPE_ERROR("set_max_waste",1,"float");
#line 2067 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
howmuch=Pike_sp[0-1].u.float_number;
{
      Buffer *io = THIS;
      io->max_waste = howmuch;
      io_add_space( io, 0, 1 );
      io_consume( io, 0 );
  }

  }
/*! @decl void trim()
   *!
   *! Frees unused memory.
   *!
   *! Note that calling this function excessively will slow things
   *! down, since the data often has to be copied.
   *!
   *! @note
   *!  This function could possibly throw an out-of-memory error
   *!  if the realloc fails to find a new (smaller) memory area.
   */
  #define f_Buffer_trim_defined

#ifdef f_Buffer_trim_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_trim_fun_num = 0;

#endif /* f_Buffer_trim_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_trim(INT32 args) {
#line 2086 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("trim",args,0);
{
    Buffer *io = THIS;
    void *new_ptr;

    io_add_space( io, 0, 1 );
    io_trim(io);
  }

  }
/*! @decl int(0..)|int(-1..-1) consume( int(0..) n )
   *!
   *! Discard the first @[n] bytes from the buffer
   *!
   *! Returns -1 on error and the amount of space still left otherwise.
   */
  #define f_Buffer_consume_defined

#ifdef f_Buffer_consume_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_consume_fun_num = 0;

#endif /* f_Buffer_consume_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_consume(INT32 args) {
#line 2101 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE n;
#line 2101 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("consume",args,1);
#line 2101 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("consume",1,"int");
#line 2101 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
n=Pike_sp[0-1].u.integer;
{
    Pike_sp--;
    if( !io_avail( THIS, n ) )
      push_int(-1);
    else
      push_int64( io_consume( THIS, n ) );
  }


  }
/*! @decl int(0..)|int(-1..-1) unread( int(0..) n )
   *!
   *! Rewind the buffer @[n] bytes.
   *!
   *! @returns
   *!
   *! This function returns how many more bytes of buffer is
   *! available to rewind, or -1 on error.
   *!
   *! @note
   *!
   *! Unless you add new data to the buffer using any of the add
   *! functions you can always rewind.
   *!
   *! You can call @[unread(0)] to see how much.
   */
  #define f_Buffer_unread_defined

#ifdef f_Buffer_unread_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_unread_fun_num = 0;

#endif /* f_Buffer_unread_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_unread(INT32 args) {
#line 2127 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 2127 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("unread",args,1);
#line 2127 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("unread",1,"int");
#line 2127 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-1].u.integer;
{
    Pike_sp--;
    push_int64( io_rewind( THIS, bytes ) );
  }

  }
/*! @decl string(8bit) read( int n )
   *!
   *! Read @[bytes] bytes of data from the buffer.
   *!
   *! If there is not enough data available this returns 0.
   *!
   *! @seealso
   *!   @[try_read()]
   */
  #define f_Buffer_read_1_defined

#ifdef f_Buffer_read_1_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_1_fun_num = 0;

#endif /* f_Buffer_read_1_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_1(INT32 args) {
#line 2142 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 2142 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("read",args,1);
#line 2142 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read",1,"int");
#line 2142 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-1].u.integer;
{
    struct pike_string *s;
    Pike_sp--;
    s = io_read_string(THIS, bytes );
    if( s )
      push_string( s );
    else
      push_undefined();
  }

  }
/*! @decl string(8bit) read( )
   *!
   *! Read all data from the buffer.
   *!
   *! If there is not enough data available this returns 0.
   *!
   *! This is basically equivalent to (string)buffer, but it also
   *! removes the data from the buffer.
   *!
   *! @seealso
   *!   @[try_read()]
   */
  #define f_Buffer_read_2_defined

#ifdef f_Buffer_read_2_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_2_fun_num = 0;

#endif /* f_Buffer_read_2_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_2(INT32 args) {
#line 2165 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read",args,0);
{
    push_string( io_read_string(THIS, io_len(THIS)) );
  }

  }

#if defined(f_Buffer_read_1_defined) || defined(f_Buffer_read_2_defined)
#define f_Buffer_read_defined

#ifdef Buffer_f_Buffer_read_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t Buffer_f_Buffer_read_fun_num = 0;

#endif /* Buffer_f_Buffer_read_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read(INT32 args) {
  switch(args) {
   case 0:

#ifdef f_Buffer_read_2_defined
    f_Buffer_read_2(args);
    return;

#endif /* f_Buffer_read_2_defined */
    break;
   case 1:

#ifdef f_Buffer_read_1_defined
    f_Buffer_read_1(args);
    return;

#endif /* f_Buffer_read_1_defined */
    break;
   default:
    wrong_number_of_args_error("read",args,0);
  }
}

#endif /* f_Buffer_read_1_defined, f_Buffer_read_2_defined */
/*! @decl string(8bit) try_read(int len)
   *!
   *! Attempt to read some data from the buffer.
   *!
   *! @param len
   *!   Read at most @[len] bytes from the buffer.
   *!
   *! @returns
   *!   If the buffer contains less than @[len] bytes
   *!   of data, the entire buffer contents are returned.
   *!   Otherwise the first @[len] bytes are returned.
   *!
   *! @seealso
   *!   @[read()]
   */
  #define f_Buffer_try_read_defined

#ifdef f_Buffer_try_read_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_try_read_fun_num = 0;

#endif /* f_Buffer_try_read_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_try_read(INT32 args) {
#line 2185 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE bytes;
#line 2185 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("try_read",args,1);
#line 2185 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("try_read",1,"int");
#line 2185 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
bytes=Pike_sp[0-1].u.integer;
{
    Buffer *this = THIS;
    struct pike_string *s;
    Pike_sp--;
    /* Hm. signed/unsigned comparisons abound. */
    if( bytes > 0 && (size_t)bytes > io_len(this) )
      bytes = io_len(this);
    push_string( io_read_string(this, bytes ) );
  }

  }
/*! @decl int(8bit) read_int8()
   */
  #define f_Buffer_read_int8_defined

#ifdef f_Buffer_read_int8_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_int8_fun_num = 0;

#endif /* f_Buffer_read_int8_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_int8(INT32 args) {
#line 2198 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_int8",args,0);
{
    Buffer *io = THIS;
    if( LIKELY(io_avail( io, 1 )) )
      push_int( io_read_byte_uc(io) );
    else
      push_int(-1);
  }

  }
/*! @decl int(16bit) read_int16()
   */
  #define f_Buffer_read_int16_defined

#ifdef f_Buffer_read_int16_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_int16_fun_num = 0;

#endif /* f_Buffer_read_int16_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_int16(INT32 args) {
#line 2209 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_int16",args,0);
{
    Buffer *io = THIS;
    if( LIKELY(io_avail( io, 2 )) )
      push_int( io_read_number_uc(io,2) );
    else
      push_int(-1);
  }

  }
/*! @decl int(24bit) read_int24()
   */
  #define f_Buffer_read_int24_defined

#ifdef f_Buffer_read_int24_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_int24_fun_num = 0;

#endif /* f_Buffer_read_int24_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_int24(INT32 args) {
#line 2220 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_int24",args,0);
{
    Buffer *io = THIS;
    if( LIKELY(io_avail( io, 3 )) )
      push_int( io_read_number_uc(io,3) );
    else
      push_int(-1);
  }

  }
/*! @decl int(32bit) read_int32()
   */
  #define f_Buffer_read_int32_defined

#ifdef f_Buffer_read_int32_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_int32_fun_num = 0;

#endif /* f_Buffer_read_int32_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_int32(INT32 args) {
#line 2231 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_int32",args,0);
{
    Buffer *io = THIS;
    if( LIKELY(io_avail( io, 4 )) )
    {
      push_int( io_read_number_uc(io,4) );
#if SIZEOF_INT_TYPE < 5
      if( UNLIKELY(Pike_sp[-1].u.integer < 0) )
      {
	io_rewind( io, 4 );
	pop_stack();
	push_object( io_read_bignum(io, 4) );
      }
#endif
    }
    else
      push_int(-1);
  }

  }
/*! @decl int read_int( int n )
   *!
   *! Read a network byte order unsigned number of size n*8 bits, then
   *! return it.
   *!
   *! Will return -1 if there is not enough buffer space available
   *! unless error mode is set to throw errors.
   */
  #define f_Buffer_read_int_defined

#ifdef f_Buffer_read_int_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_int_fun_num = 0;

#endif /* f_Buffer_read_int_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_int(INT32 args) {
#line 2258 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE len;
#line 2258 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("read_int",args,1);
#line 2258 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_int",1,"int");
#line 2258 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
len=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    struct object *o;

    Pike_sp--;

    if( len < SIZEOF_INT_TYPE-1 ) /* will for sure fit. */
    {
      push_int( io_read_number( io, len ) );
      return;
    }

    if( (o = io_read_bignum(io, len )) )
    {
      push_object(o);
      reduce_stack_top_bignum();
      return;
    }
    push_int(-1);
  }

  }
/*! @decl int read_hint( int n )
   *!
   *! Read a network byte order unsigned number of size n*8 bits, then
   *! read another network byte order number of the size indicated by
   *! the first size.
   *!
   *! Will return -1 if there is not enough buffer space available
   *! unless error mode is set to throw errors.
   */
  #define f_Buffer_read_hint_defined

#ifdef f_Buffer_read_hint_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_hint_fun_num = 0;

#endif /* f_Buffer_read_hint_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_hint(INT32 args) {
#line 2289 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE size_len;
#line 2289 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("read_hint",args,1);
#line 2289 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_hint",1,"int");
#line 2289 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
size_len=Pike_sp[0-1].u.integer;
{
    Buffer *io = THIS;
    ONERROR e;
    INT_TYPE len;
    struct object *o;

    io_rewind_on_error( io, &e );

    len = io_read_number( io, size_len );
    if( len >= 0 )
    {
      if( len < SIZEOF_INT_TYPE )
      {
        if( (Pike_sp[-1].u.integer = io_read_number( io, len )) == -1 )
          goto neg_one;
      }
      else if( (o = io_read_bignum( io, len )) )
      {
        Pike_sp--;
        push_object(o);
        reduce_stack_top_bignum();
      }
      else
        goto neg_one;
      io_unset_rewind_on_error( io, &e );
      return;
    }
  neg_one:
    Pike_sp[-1].u.integer = -1;
    CALL_AND_UNSET_ONERROR(e);
  }

  }
/*! @decl array(int) read_ints( int n, int width )
   *!
   *! Read a list of @[n] network byte order unsigned numbers each of
   *! size @[width]*8 bits, then return it.
   *!
   *! Will return 0 if there is not enough buffer space available
   *! unless error mode is set to throw errors.
   */
  #define f_Buffer_read_ints_defined

#ifdef f_Buffer_read_ints_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_ints_fun_num = 0;

#endif /* f_Buffer_read_ints_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_ints(INT32 args) {
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE num;
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE len;
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 2) wrong_number_of_args_error("read_ints",args,2);
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_ints",1,"int");
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
num=Pike_sp[0-2].u.integer;
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("read_ints",2,"int");
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
len=Pike_sp[1-2].u.integer;
{
    Buffer *io = THIS;
    INT_TYPE i;
    struct object *o;
    struct array *a;

    Pike_sp-=2;

    if( !io_avail_mul( io, num, len ) )
    {
      push_int(0);
      return;
    }

    if( len < SIZEOF_INT_TYPE-1 ) /* will for sure fit. */
    {
      push_array(a = allocate_array(num));
      for( i=0;i<num;i++ )
        a->item[i].u.integer = io_read_number_uc( io, len );
      return;
    }

    for( i=0; i<num; i++ )
    {
      push_object(io_read_bignum( io, len ));
      reduce_stack_top_bignum();
    }
    f_aggregate(num);
  }

}
/*! @decl string _encode()
 *! @decl void _decode(string x)
 *!
 *! Encode and decode Stdio.Buffer objects.
 *! Only the buffer data is kept, no other state is saved.
 */
  #define f_Buffer_cq__encode_defined

#ifdef f_Buffer_cq__encode_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__encode_fun_num = 0;

#endif /* f_Buffer_cq__encode_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__encode(INT32 args) {
#line 2367 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("_encode",args,0);
{
    push_string(io_read_string(THIS, io_len(THIS)));
  }

  }
#define f_Buffer_cq__decode_defined

#ifdef f_Buffer_cq__decode_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_cq__decode_fun_num = 0;

#endif /* f_Buffer_cq__decode_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_cq__decode(INT32 args) {
#line 2372 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct pike_string * x;
#line 2372 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("_decode",args,1);
#line 2372 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_decode",1,"string(0..255)");
#line 2372 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
debug_malloc_pass(x=Pike_sp[0-1].u.string);
{
    Buffer *this = THIS;
    if( this->buffer )
      Pike_error("Can not initialize twice.\n");
    if( x->size_shift )
      Pike_error("Can not handle non-8bit data.\n");
    this->buffer = (unsigned char*)x->str;
    this->len = x->len;
    this->malloced = 0;
    this->str = x;
    add_ref(x);
  }

  }
/*! @decl void read_only()
   *!
   *! Make the buffer permanently read only.
   *! @note
   *! You can use lock() to do this temporarily.
   */
  #define f_Buffer_read_only_defined

#ifdef f_Buffer_read_only_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_read_only_fun_num = 0;

#endif /* f_Buffer_read_only_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_read_only(INT32 args) {
#line 2392 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("read_only",args,0);
{
    io_lock( THIS );
  }


  }
#line 2398 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
static struct object* io_create_rewind_key( Buffer *io, int how );

  /*! @decl RewindKey rewind_on_error()
   *! @decl RewindKey rewind_key()
   *!
   *! These functions are very similar. The @[rewind_on_error] edition
   *! will create an object that, when it goes out of scope without
   *! having been destructed explicitly, will cause the buffer to
   *! rewind to the location it had when this function is called.
   *!
   *! This will happen if you throw an error @i{or@} otherwise let the
   *! object fall out of scope.
   *!
   *! Use @[destruct(RewindKey)] or @[RewindKey.release] to stop the
   *! buffer from being rewound.
   *!
   *! The second version (@[rewind_key]) requires you to explicitly
   *! call @[RewindKey.rewind] to do the rewind.
   *!
   *! Take some care with these objects, if you create multiple ones
   *! at once the results might be somewhat confusing if you do not
   *! release them in the reverse order they were created in (then
   *! again, you almost certainly really only need one)
   *!
   *! You can call @[RewindKey.update] in the generated object to
   *! change where it will be rewound to.
   *!
   *! The typical use-case of this functionality is when parsing a
   *! packet protocol with variable length packets where the length is
   *! not immediately known. It saves you from keeping track of how
   *! much to rewind if you had not actually gotten the whole packet
   *! yet.
   *!
   *! @example
   *! @code
   *! void parse_packet( Stdio.Buffer b )
   *! {
   *!   Stdio.Buffer.RewindKey rewind = b->rewind_on_error();
   *!   b->set_error_mode(1);
   *!
   *!   switch( b->read_int8() ) // packet type
   *!   {
   *!     case DATA:
   *!       int channel = b->read_int8();
   *!       Stdio.Buffer data = b->read_hbuffer( 4 );
   *!       // we have read the whole packet, so no longer rewind on error.
   *!       rewind->release();
   *!       return handle_data_packet( channel, data );
   *!   }
   *! }
   *! @endcode
   *! @note
   *! Just calling @[rewind_on_error] without assigning the return
   *! value to something will not do anything. You need to keep the
   *! object around while the rewind-to position is still valid.
   *!
   *! Keeping the object around forbids the buffer from moving data
   *! inside itself, this means that it can only grow. So do not keep
   *! the rewind key when it is not needed.
   */
  #define f_Buffer_rewind_on_error_defined

#ifdef f_Buffer_rewind_on_error_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_rewind_on_error_fun_num = 0;

#endif /* f_Buffer_rewind_on_error_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_rewind_on_error(INT32 args) {
#line 2458 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("rewind_on_error",args,0);
{
    push_object( io_create_rewind_key( THIS, 1 ) );
  }

  }
#define f_Buffer_rewind_key_defined

#ifdef f_Buffer_rewind_key_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_rewind_key_fun_num = 0;

#endif /* f_Buffer_rewind_key_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_rewind_key(INT32 args) {
#line 2463 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("rewind_key",args,0);
{
    push_object( io_create_rewind_key( THIS, 0 ) );
  }

  }
/*! @decl void create( int|void len )
   *! @decl void create( string(8bit) contents )
   *! @decl void create( System.Memory|String.Buffer contents )
   *!
   *! If passed an integer or no argument, create a buffer of that
   *! size, or if no argument is given, 226 bytes.
   *!
   *! If @[contents] are specified a new buffer with the contents of
   *! the given string/System.Memory or String.Buffer will be created.
   *!
   *! @note
   *! In the @[String.Buffer] case the data has to be copied unless
   *! there is only one reference to the String.Buffer object, since
   *! modifications of the String.Buffer would cause the Buffer to
   *! point into invalid memory.
   *!
   *! In all other cases this will not copy the string data, instead
   *! data will be read from the source until it needs to be modified,
   *! so the buffer creation is fast regardless of the length of the
   *! string.
   *!
   *! However, as an example, if the buffer is created with a 100Gb
   *! @[System.Memory] mmap:ed file as the @[contents] and you later on
   *! try to modify the buffer using one of the @[add] functions (or
   *! @[sprintf] and similar) the old contents @b{will@} be copied.
   *!
   *! You can use @[read_only()] to avoid accidents.
   */
  #define f_Buffer_create_defined

#ifdef f_Buffer_create_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_create_fun_num = 0;

#endif /* f_Buffer_create_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_create(INT32 args) {
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct svalue * x;
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
x=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
} else x = NULL;
#line 2498 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Buffer *this = THIS;
    if( this->buffer )
      Pike_error("Can not initialize twice.\n");
    if( args == 0 )
    {
      this->buffer = xalloc(256-32);
      this->allocated = 256-32;
      this->malloced = 1;
    }
    else if( TYPEOF(*x) == PIKE_T_INT )
    {
      INT_TYPE len = x->u.integer;
      if(  len <= 0 )
        this->buffer = xalloc(1);
      else
        this->buffer = xalloc(len);
      this->allocated = MAXIMUM(len,1);
      this->malloced = 1;
    }
    else
      io_append_svalue( THIS, x );
  }

  }

#undef internal_init_Buffer_defined
#define internal_init_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void init_Buffer_struct(void)
#line 2522 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Buffer *this = THIS;
    memset( this, 0, sizeof(Buffer));
    this->max_waste = 0.615;
    this->this = Pike_fp->current_object;
  }

  
#undef Buffer_gc_live_obj
#define Buffer_gc_live_obj

#undef internal_exit_Buffer_defined
#define internal_exit_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void exit_Buffer_struct(void)
#line 2529 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    Buffer *this = THIS;
    io_unlink_external_storage( this );
    if( this->error_mode )
        free_program( this->error_mode );
    if( this->malloced )
      free( this->buffer );
  }


/*! @class RewindKey
 *!
 *! The return value of @[Buffer.rewind_on_error()] and
 *! @[Buffer.rewind_key()]
 *!
 *! This object will cause the buffer to unwind to the position it was
 *! at when the object was created either when it is released (when it
 *! falls out of scope, explicit destruct does not count) or when
 *! @[rewind] is called, depending on which function was used to
 *! create it.
 */

  
#undef class_Buffer_RewindKey_defined
#define class_Buffer_RewindKey_defined
DEFAULT_CMOD_STORAGE struct program *Buffer_RewindKey_program=NULL;

#ifdef Buffer_RewindKey_program_fun_num_used
DEFAULT_CMOD_STORAGE int Buffer_RewindKey_program_fun_num=-1;
#endif /* Buffer_RewindKey_program_fun_num_used */

#undef var_io_Buffer_RewindKey_defined
#define var_io_Buffer_RewindKey_defined

#undef var_obj_Buffer_RewindKey_defined
#define var_obj_Buffer_RewindKey_defined

#undef var_rewind_to_Buffer_RewindKey_defined
#define var_rewind_to_Buffer_RewindKey_defined

#undef var_auto_mode_Buffer_RewindKey_defined
#define var_auto_mode_Buffer_RewindKey_defined

#undef THIS
#define THIS ((struct Buffer_RewindKey_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BUFFER_REWINDKEY
#define THIS_BUFFER_REWINDKEY ((struct Buffer_RewindKey_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BUFFER_REWINDKEY
#define OBJ2_BUFFER_REWINDKEY(o) ((struct Buffer_RewindKey_struct *)(o->storage+Buffer_RewindKey_storage_offset))

#undef GET_BUFFER_REWINDKEY_STORAGE
#define GET_BUFFER_REWINDKEY_STORAGE(o) ((struct Buffer_RewindKey_struct *)(o->storage+Buffer_RewindKey_storage_offset)
static ptrdiff_t Buffer_RewindKey_storage_offset;
struct Buffer_RewindKey_struct {

#ifdef var_io_Buffer_RewindKey_defined
#line 2554 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
Buffer *io;
#endif /* var_io_Buffer_RewindKey_defined */

#ifdef var_obj_Buffer_RewindKey_defined
#line 2555 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
struct object *obj;
#endif /* var_obj_Buffer_RewindKey_defined */

#ifdef var_rewind_to_Buffer_RewindKey_defined
#line 2556 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
size_t rewind_to;
#endif /* var_rewind_to_Buffer_RewindKey_defined */

#ifdef var_auto_mode_Buffer_RewindKey_defined
#line 2557 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
int auto_mode;
#endif /* var_auto_mode_Buffer_RewindKey_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Buffer_RewindKey_struct *Buffer_RewindKey_gdb_dummy_ptr;
#endif
/*! @decl void release()
     *!  Do not rewind if the object is released.
     *! @note
     *!  This is equivalent to calling destruct() on the object
     */
    #define f_Buffer_RewindKey_release_defined

#ifdef f_Buffer_RewindKey_release_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_RewindKey_release_fun_num = 0;

#endif /* f_Buffer_RewindKey_release_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_RewindKey_release(INT32 args) {
#line 2564 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("release",args,0);
{
      destruct_object(Pike_fp->current_object, DESTRUCT_EXPLICIT);
    }

    }
/*! @decl void update()
     *!
     *! Update the location the buffer will be rewound to to the current
     *! position of the buffer.
     */
    #define f_Buffer_RewindKey_update_defined

#ifdef f_Buffer_RewindKey_update_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_RewindKey_update_fun_num = 0;

#endif /* f_Buffer_RewindKey_update_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_RewindKey_update(INT32 args) {
#line 2574 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("update",args,0);
{
      if( THIS->obj->prog && THIS->io )
        THIS->rewind_to = THIS->io->offset;
    }

    }

#undef Buffer_RewindKey_gc_live_obj
#define Buffer_RewindKey_gc_live_obj

#undef internal_exit_Buffer_RewindKey_defined
#define internal_exit_Buffer_RewindKey_defined

#undef Buffer_RewindKey_event_handler_defined
#define Buffer_RewindKey_event_handler_defined
static void exit_Buffer_RewindKey_struct(void)
#line 2580 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
      if( THIS->io && THIS->obj->prog )
        THIS->io->locked_move--;
      free_object( THIS->obj );
    }

    #define f_Buffer_RewindKey_destroy_defined

#ifdef f_Buffer_RewindKey_destroy_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_RewindKey_destroy_fun_num = 0;

#endif /* f_Buffer_RewindKey_destroy_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_RewindKey_destroy(INT32 args) {
#line 2586 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
INT_TYPE reason;
#line 2586 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 1) wrong_number_of_args_error("destroy",args,1);
#line 2586 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("destroy",1,"int");
#line 2586 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
reason=Pike_sp[0-1].u.integer;
#line 2588 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
      if( reason > 1 && THIS->auto_mode ) /* no refs or gc */
      {
        if( THIS->io && THIS->obj->prog )
          THIS->io->offset = THIS->rewind_to;
      }
    }

    }
/*! @decl void rewind()
     *! Rewinds the buffer explicitly.
     *! @note
     *!    Destructs this @[RewindKey]
     */
    #define f_Buffer_RewindKey_rewind_defined

#ifdef f_Buffer_RewindKey_rewind_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_RewindKey_rewind_fun_num = 0;

#endif /* f_Buffer_RewindKey_rewind_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_RewindKey_rewind(INT32 args) {
#line 2601 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("rewind",args,0);
#line 2601 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
      THIS->auto_mode = 1;
      destruct_object(Pike_fp->current_object, DESTRUCT_GC);
    }

    }
#define f_Buffer_RewindKey_create_defined

#ifdef f_Buffer_RewindKey_create_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Buffer_RewindKey_create_fun_num = 0;

#endif /* f_Buffer_RewindKey_create_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Buffer_RewindKey_create(INT32 args) {
#line 2606 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
#line 2608 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
      /* FIXME: The following zeroing isn't safe! */
      THIS->obj = 0;
      THIS->io = 0;
      Pike_error("Not supported\n");
    }
  }

#ifdef Buffer_RewindKey_event_handler_defined
static void Buffer_RewindKey_event_handler(int ev) {
  switch(ev) {

#ifdef internal_exit_Buffer_RewindKey_defined
  case PROG_EVENT_EXIT: exit_Buffer_RewindKey_struct(); break;

#endif /* internal_exit_Buffer_RewindKey_defined */
  default: break; 
  }
}

#endif /* Buffer_RewindKey_event_handler_defined */

#ifdef Buffer_event_handler_defined
static void Buffer_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Buffer_defined
  case PROG_EVENT_INIT: init_Buffer_struct(); break;

#endif /* internal_init_Buffer_defined */

#ifdef internal_exit_Buffer_defined
  case PROG_EVENT_EXIT: exit_Buffer_struct(); break;

#endif /* internal_exit_Buffer_defined */
  default: break; 
  }
}

#endif /* Buffer_event_handler_defined */
#line 2619 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
static struct object* io_create_rewind_key( Buffer *io, int auto_mode )
{
  struct object *o = fast_clone_object( Buffer_RewindKey_program );
  struct Buffer_RewindKey_struct *s = (void*)o->storage;
  add_ref(io->this);
  s->obj = io->this;
  s->rewind_to = io->offset;
  s->io = io;
  s->auto_mode = auto_mode;
  io->locked_move++;
  return o;
}

/*! @endclass
 * RewindKey
 */

/*! @endclass
 * Buffer
 */


/*! @endmodule
 * Stdio
 */


void init_stdio_buffer(void)
{
  
#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_Buffer_defined

#ifdef PROG_BUFFER_ID
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  START_NEW_PROGRAM_ID(BUFFER);
#else
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  start_new_program();

#endif /* PROG_BUFFER_ID */
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  Buffer_program = Pike_compiler->new_program;

#ifndef tObjImpl_BUFFER

#undef tObjIs_BUFFER
#define tObjIs_BUFFER "\3\1\177\0\0\2"

#undef tObjImpl_BUFFER
#define tObjImpl_BUFFER "\3\0\177\0\0\2"

#endif /* tObjImpl_BUFFER */

#ifdef THIS_BUFFER
  Buffer_storage_offset = ADD_STORAGE(struct Buffer_struct);
#endif /* THIS_BUFFER */

#ifdef var_b_Buffer_defined
  PIKE_MAP_VARIABLE("num_malloc", Buffer_storage_offset + OFFSETOF(Buffer_struct, b.num_malloc),
                    "\10\200\0\0\0\177\377\377\377", PIKE_T_INT, 0);
#endif /* var_b_Buffer_defined */

#ifdef var_b_Buffer_defined_2
  PIKE_MAP_VARIABLE("num_move", Buffer_storage_offset + OFFSETOF(Buffer_struct, b.num_move),
                    "\10\200\0\0\0\177\377\377\377", PIKE_T_INT, 0);
#endif /* var_b_Buffer_defined_2 */

#ifdef extra_Buffer_defined
#line 84 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
{
    PIKE_MAP_VARIABLE("__output", OFFSETOF(Buffer_struct,b.output),
		      tMix, PIKE_T_MIXED, ID_PRIVATE|ID_HIDDEN|ID_PROTECTED);
  }
  
#endif /* extra_Buffer_defined */

#ifdef class_Buffer_RewindKey_defined

#ifdef PROG_BUFFER_REWINDKEY_ID
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  START_NEW_PROGRAM_ID(BUFFER_REWINDKEY);
#else
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  start_new_program();

#endif /* PROG_BUFFER_REWINDKEY_ID */
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  Buffer_RewindKey_program = Pike_compiler->new_program;

#ifndef tObjImpl_BUFFER_REWINDKEY

#undef tObjIs_BUFFER_REWINDKEY
#define tObjIs_BUFFER_REWINDKEY "\3\1\177\0\0\3"

#undef tObjImpl_BUFFER_REWINDKEY
#define tObjImpl_BUFFER_REWINDKEY "\3\0\177\0\0\3"

#endif /* tObjImpl_BUFFER_REWINDKEY */

#ifdef THIS_BUFFER_REWINDKEY
  Buffer_RewindKey_storage_offset = ADD_STORAGE(struct Buffer_RewindKey_struct);
#endif /* THIS_BUFFER_REWINDKEY */

#ifdef Buffer_RewindKey_event_handler_defined
  pike_set_prog_event_callback(Buffer_RewindKey_event_handler);

#ifndef Buffer_RewindKey_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Buffer_RewindKey_gc_live_obj */

#endif /* Buffer_RewindKey_event_handler_defined */

#ifdef f_Buffer_RewindKey_release_defined

#ifdef f_Buffer_RewindKey_release_fun_num_used
  f_Buffer_RewindKey_release_fun_num =
#endif /* f_Buffer_RewindKey_release_fun_num_used */
#line 2564 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("release", f_Buffer_RewindKey_release, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_RewindKey_release_defined */

#ifdef f_Buffer_RewindKey_update_defined

#ifdef f_Buffer_RewindKey_update_fun_num_used
  f_Buffer_RewindKey_update_fun_num =
#endif /* f_Buffer_RewindKey_update_fun_num_used */
#line 2574 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("update", f_Buffer_RewindKey_update, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_RewindKey_update_defined */

#ifdef f_Buffer_RewindKey_destroy_defined

#ifdef f_Buffer_RewindKey_destroy_fun_num_used
  f_Buffer_RewindKey_destroy_fun_num =
#endif /* f_Buffer_RewindKey_destroy_fun_num_used */
#line 2586 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("destroy", f_Buffer_RewindKey_destroy, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), ID_PRIVATE, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_RewindKey_destroy_defined */

#ifdef f_Buffer_RewindKey_rewind_defined

#ifdef f_Buffer_RewindKey_rewind_fun_num_used
  f_Buffer_RewindKey_rewind_fun_num =
#endif /* f_Buffer_RewindKey_rewind_fun_num_used */
#line 2601 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("rewind", f_Buffer_RewindKey_rewind, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_RewindKey_rewind_defined */

#ifdef f_Buffer_RewindKey_create_defined

#ifdef f_Buffer_RewindKey_create_fun_num_used
  f_Buffer_RewindKey_create_fun_num =
#endif /* f_Buffer_RewindKey_create_fun_num_used */
#line 2606 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("create", f_Buffer_RewindKey_create, tFunc(tNone,tVoid), ID_PRIVATE, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_RewindKey_create_defined */
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  Buffer_RewindKey_program=end_program();
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
#ifdef Buffer_RewindKey_program_fun_num_used
Buffer_RewindKey_program_fun_num=
#endif
 add_program_constant("RewindKey",Buffer_RewindKey_program,PROGRAM_DESTRUCT_IMMEDIATE);

#endif /* class_Buffer_RewindKey_defined */

#ifdef Buffer_event_handler_defined
  pike_set_prog_event_callback(Buffer_event_handler);

#ifndef Buffer_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Buffer_gc_live_obj */

#endif /* Buffer_event_handler_defined */

#ifdef f_Buffer_range_error_defined

#ifdef f_Buffer_range_error_fun_num_used
  f_Buffer_range_error_fun_num =
#endif /* f_Buffer_range_error_fun_num_used */
#line 325 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("range_error", f_Buffer_range_error, tFunc("\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_range_error_defined */

#ifdef f_Buffer_input_from_defined

#ifdef f_Buffer_input_from_fun_num_used
  f_Buffer_input_from_fun_num =
#endif /* f_Buffer_input_from_fun_num_used */
#line 932 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("input_from", f_Buffer_input_from, tFunc(tObj tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr("\10\200\0\0\0\177\377\377\377",tVoid),"\10\377\377\377\377\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_input_from_defined */

#ifdef f_Buffer_cq___fd_set_output_defined

#ifdef f_Buffer_cq___fd_set_output_fun_num_used
  f_Buffer_cq___fd_set_output_fun_num =
#endif /* f_Buffer_cq___fd_set_output_fun_num_used */
#line 1003 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("__fd_set_output", f_Buffer_cq___fd_set_output, tFunc(tOr3("\10\0\0\0\0\0\0\0\0",tObj,tFuncV(tNone,tMix,tAny)),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq___fd_set_output_defined */

#ifdef f_Buffer_output_to_defined

#ifdef f_Buffer_output_to_fun_num_used
  f_Buffer_output_to_fun_num =
#endif /* f_Buffer_output_to_fun_num_used */
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("output_to", f_Buffer_output_to, tFunc(tOr(tObj,tFunc(tStr,"\10\200\0\0\0\177\377\377\377")) tOr("\10\200\0\0\0\177\377\377\377",tVoid),"\10\377\377\377\377\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_output_to_defined */

#ifdef f_Buffer_try_output_defined

#ifdef f_Buffer_try_output_fun_num_used
  f_Buffer_try_output_fun_num =
#endif /* f_Buffer_try_output_fun_num_used */
#line 1148 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("try_output", f_Buffer_try_output, tFunc(tNone,"\10\377\377\377\377\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_try_output_defined */

#ifdef f_Buffer_read_sint_defined

#ifdef f_Buffer_read_sint_fun_num_used
  f_Buffer_read_sint_fun_num =
#endif /* f_Buffer_read_sint_fun_num_used */
#line 1164 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_sint", f_Buffer_read_sint, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_sint_defined */

#ifdef f_Buffer_cq__size_object_defined

#ifdef f_Buffer_cq__size_object_fun_num_used
  f_Buffer_cq__size_object_fun_num =
#endif /* f_Buffer_cq__size_object_fun_num_used */
#line 1197 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("_size_object", f_Buffer_cq__size_object, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__size_object_defined */

#ifdef f_Buffer_add_padding_defined

#ifdef f_Buffer_add_padding_fun_num_used
  f_Buffer_add_padding_fun_num =
#endif /* f_Buffer_add_padding_fun_num_used */
#line 1208 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_padding", f_Buffer_add_padding, tFunc("\10\0\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_padding_defined */

#ifdef f_Buffer_add_defined

#ifdef f_Buffer_add_fun_num_used
  f_Buffer_add_fun_num =
#endif /* f_Buffer_add_fun_num_used */
#line 1254 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add", f_Buffer_add, tFuncV(tNone,tOr4(tObj,tStr,"\10\200\0\0\0\177\377\377\377",tArr(tOr3(tObj,tStr,"\10\200\0\0\0\177\377\377\377"))),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_defined */

#ifdef f_Buffer_add_int8_defined

#ifdef f_Buffer_add_int8_fun_num_used
  f_Buffer_add_int8_fun_num =
#endif /* f_Buffer_add_int8_fun_num_used */
#line 1269 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_int8", f_Buffer_add_int8, tFunc("\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_int8_defined */

#ifdef f_Buffer_add_int16_defined

#ifdef f_Buffer_add_int16_fun_num_used
  f_Buffer_add_int16_fun_num =
#endif /* f_Buffer_add_int16_fun_num_used */
#line 1282 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_int16", f_Buffer_add_int16, tFunc("\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_int16_defined */

#ifdef f_Buffer_add_int32_defined

#ifdef f_Buffer_add_int32_fun_num_used
  f_Buffer_add_int32_fun_num =
#endif /* f_Buffer_add_int32_fun_num_used */
#line 1295 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_int32", f_Buffer_add_int32, tFunc("\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_int32_defined */

#ifdef f_Buffer_add_hstring_defined

#ifdef f_Buffer_add_hstring_fun_num_used
  f_Buffer_add_hstring_fun_num =
#endif /* f_Buffer_add_hstring_fun_num_used */
#line 1353 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_hstring", f_Buffer_add_hstring, tFunc(tOr4("\10\200\0\0\0\177\377\377\377",tStr,tObj,tArr(tOr4("\10\200\0\0\0\177\377\377\377",tStr,tName("Buffer", tObjImpl_BUFFER),tArray))) "\10\200\0\0\0\177\377\377\377" tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_hstring_defined */

#ifdef f_Buffer_add_int_defined

#ifdef f_Buffer_add_int_fun_num_used
  f_Buffer_add_int_fun_num =
#endif /* f_Buffer_add_int_fun_num_used */
#line 1381 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_int", f_Buffer_add_int, tFunc(tOr(tObj,"\10\200\0\0\0\177\377\377\377") "\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_int_defined */

#ifdef f_Buffer_add_hint_defined

#ifdef f_Buffer_add_hint_fun_num_used
  f_Buffer_add_hint_fun_num =
#endif /* f_Buffer_add_hint_fun_num_used */
#line 1407 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_hint", f_Buffer_add_hint, tFunc(tOr(tObj,"\10\200\0\0\0\177\377\377\377") "\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_hint_defined */

#ifdef f_Buffer_add_ints_defined

#ifdef f_Buffer_add_ints_fun_num_used
  f_Buffer_add_ints_fun_num =
#endif /* f_Buffer_add_ints_fun_num_used */
#line 1445 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("add_ints", f_Buffer_add_ints, tFunc(tArr("\10\200\0\0\0\177\377\377\377") "\10\200\0\0\0\177\377\377\377",tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_ints_defined */

#ifdef f_Buffer_cq__backtick_5B_5D_defined

#ifdef f_Buffer_cq__backtick_5B_5D_fun_num_used
  f_Buffer_cq__backtick_5B_5D_fun_num =
#endif /* f_Buffer_cq__backtick_5B_5D_fun_num_used */
#line 1514 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("`[]", f_Buffer_cq__backtick_5B_5D, tFunc("\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\0\0\0\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_5B_5D_defined */

#ifdef f_Buffer_cq__backtick_5B_5D_eq_defined

#ifdef f_Buffer_cq__backtick_5B_5D_eq_fun_num_used
  f_Buffer_cq__backtick_5B_5D_eq_fun_num =
#endif /* f_Buffer_cq__backtick_5B_5D_eq_fun_num_used */
#line 1531 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("`[]=", f_Buffer_cq__backtick_5B_5D_eq, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\0\0\0\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_5B_5D_eq_defined */

#ifdef f_Buffer_cq__sizeof_defined

#ifdef f_Buffer_cq__sizeof_fun_num_used
  f_Buffer_cq__sizeof_fun_num =
#endif /* f_Buffer_cq__sizeof_fun_num_used */
#line 1558 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("_sizeof", f_Buffer_cq__sizeof, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sizeof_defined */

#ifdef f_Buffer_cast_defined

#ifdef f_Buffer_cast_fun_num_used
  f_Buffer_cast_fun_num =
#endif /* f_Buffer_cast_fun_num_used */
#line 1571 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("cast", f_Buffer_cast, tFunc(tStr,tStr8), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cast_defined */

#ifdef f_Buffer_set_error_mode_defined

#ifdef f_Buffer_set_error_mode_fun_num_used
  f_Buffer_set_error_mode_fun_num =
#endif /* f_Buffer_set_error_mode_fun_num_used */
#line 1636 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("set_error_mode", f_Buffer_set_error_mode, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tPrg(tObj)),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_set_error_mode_defined */

#ifdef f_Buffer_lock_defined

#ifdef f_Buffer_lock_fun_num_used
  f_Buffer_lock_fun_num =
#endif /* f_Buffer_lock_fun_num_used */
#line 1654 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("lock", f_Buffer_lock, tFunc(tNone,tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_lock_defined */

#ifdef f_Buffer_cq__sprintf_defined

#ifdef f_Buffer_cq__sprintf_fun_num_used
  f_Buffer_cq__sprintf_fun_num =
#endif /* f_Buffer_cq__sprintf_fun_num_used */
#line 1659 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("_sprintf", f_Buffer_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tStr8), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sprintf_defined */

#ifdef f_Buffer_read_hstring_defined

#ifdef f_Buffer_read_hstring_fun_num_used
  f_Buffer_read_hstring_fun_num =
#endif /* f_Buffer_read_hstring_fun_num_used */
#line 1722 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_hstring", f_Buffer_read_hstring, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tStr8), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_hstring_defined */

#ifdef f_Buffer_read_cstring_defined

#ifdef f_Buffer_read_cstring_fun_num_used
  f_Buffer_read_cstring_fun_num =
#endif /* f_Buffer_read_cstring_fun_num_used */
#line 1764 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_cstring", f_Buffer_read_cstring, tFunc(tNone,tStr8), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_cstring_defined */

#ifdef f_Buffer_read_hbuffer_defined

#ifdef f_Buffer_read_hbuffer_fun_num_used
  f_Buffer_read_hbuffer_fun_num =
#endif /* f_Buffer_read_hbuffer_fun_num_used */
#line 1818 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_hbuffer", f_Buffer_read_hbuffer, tFunc("\10\200\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_hbuffer_defined */

#ifdef f_Buffer_read_buffer_defined

#ifdef f_Buffer_read_buffer_fun_num_used
  f_Buffer_read_buffer_fun_num =
#endif /* f_Buffer_read_buffer_fun_num_used */
#line 1856 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_buffer", f_Buffer_read_buffer, tFunc("\10\200\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tName("Buffer", tObjImpl_BUFFER)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_buffer_defined */

#ifdef f_Buffer_sprintf_defined

#ifdef f_Buffer_sprintf_fun_num_used
  f_Buffer_sprintf_fun_num =
#endif /* f_Buffer_sprintf_fun_num_used */
#line 1876 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("sprintf", f_Buffer_sprintf, tFuncV(tAttr("strict_sprintf_format", tOr(tStr, tObj)),
                   tAttr("sprintf_args", tMix), tObjIs_BUFFER), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_sprintf_defined */

#ifdef f_Buffer_sscanf_defined

#ifdef f_Buffer_sscanf_fun_num_used
  f_Buffer_sscanf_fun_num =
#endif /* f_Buffer_sscanf_fun_num_used */
#line 1902 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("sscanf", f_Buffer_sscanf, tFunc(tStr,tArray), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_sscanf_defined */

#ifdef f_Buffer_read_json_defined

#ifdef f_Buffer_read_json_fun_num_used
  f_Buffer_read_json_fun_num =
#endif /* f_Buffer_read_json_fun_num_used */
#line 1948 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_json", f_Buffer_read_json, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_json_defined */

#ifdef f_Buffer_match_defined

#ifdef f_Buffer_match_fun_num_used
  f_Buffer_match_fun_num =
#endif /* f_Buffer_match_fun_num_used */
#line 2022 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("match", f_Buffer_match, tFunc(tStr,tOr4(tStr8,"\10\200\0\0\0\177\377\377\377",tFloat,tArray)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_match_defined */

#ifdef f_Buffer_clear_defined

#ifdef f_Buffer_clear_fun_num_used
  f_Buffer_clear_fun_num =
#endif /* f_Buffer_clear_fun_num_used */
#line 2053 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("clear", f_Buffer_clear, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_clear_defined */

#ifdef f_Buffer_set_max_waste_defined

#ifdef f_Buffer_set_max_waste_fun_num_used
  f_Buffer_set_max_waste_fun_num =
#endif /* f_Buffer_set_max_waste_fun_num_used */
#line 2067 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("set_max_waste", f_Buffer_set_max_waste, tFunc(tFloat,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_set_max_waste_defined */

#ifdef f_Buffer_trim_defined

#ifdef f_Buffer_trim_fun_num_used
  f_Buffer_trim_fun_num =
#endif /* f_Buffer_trim_fun_num_used */
#line 2086 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("trim", f_Buffer_trim, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_trim_defined */

#ifdef f_Buffer_consume_defined

#ifdef f_Buffer_consume_fun_num_used
  f_Buffer_consume_fun_num =
#endif /* f_Buffer_consume_fun_num_used */
#line 2101 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("consume", f_Buffer_consume, tFunc("\10\200\0\0\0\177\377\377\377","\10\377\377\377\377\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_consume_defined */

#ifdef f_Buffer_unread_defined

#ifdef f_Buffer_unread_fun_num_used
  f_Buffer_unread_fun_num =
#endif /* f_Buffer_unread_fun_num_used */
#line 2127 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("unread", f_Buffer_unread, tFunc("\10\200\0\0\0\177\377\377\377","\10\377\377\377\377\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_unread_defined */

#ifdef f_Buffer_read_defined

#ifdef Buffer_f_Buffer_read_fun_num_used
  Buffer_f_Buffer_read_fun_num =
#endif /* Buffer_f_Buffer_read_fun_num_used */
#line 2165 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read", f_Buffer_read, tOr(tFunc("\10\200\0\0\0\177\377\377\377",tStr8),tFunc(tNone,tStr8)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_defined */

#ifdef f_Buffer_try_read_defined

#ifdef f_Buffer_try_read_fun_num_used
  f_Buffer_try_read_fun_num =
#endif /* f_Buffer_try_read_fun_num_used */
#line 2185 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("try_read", f_Buffer_try_read, tFunc("\10\200\0\0\0\177\377\377\377",tStr8), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_try_read_defined */

#ifdef f_Buffer_read_int8_defined

#ifdef f_Buffer_read_int8_fun_num_used
  f_Buffer_read_int8_fun_num =
#endif /* f_Buffer_read_int8_fun_num_used */
#line 2198 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_int8", f_Buffer_read_int8, tFunc(tNone,"\10\0\0\0\0\0\0\0\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_int8_defined */

#ifdef f_Buffer_read_int16_defined

#ifdef f_Buffer_read_int16_fun_num_used
  f_Buffer_read_int16_fun_num =
#endif /* f_Buffer_read_int16_fun_num_used */
#line 2209 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_int16", f_Buffer_read_int16, tFunc(tNone,"\10\0\0\0\0\0\0\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_int16_defined */

#ifdef f_Buffer_read_int24_defined

#ifdef f_Buffer_read_int24_fun_num_used
  f_Buffer_read_int24_fun_num =
#endif /* f_Buffer_read_int24_fun_num_used */
#line 2220 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_int24", f_Buffer_read_int24, tFunc(tNone,"\10\0\0\0\0\0\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_int24_defined */

#ifdef f_Buffer_read_int32_defined

#ifdef f_Buffer_read_int32_fun_num_used
  f_Buffer_read_int32_fun_num =
#endif /* f_Buffer_read_int32_fun_num_used */
#line 2231 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_int32", f_Buffer_read_int32, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_int32_defined */

#ifdef f_Buffer_read_int_defined

#ifdef f_Buffer_read_int_fun_num_used
  f_Buffer_read_int_fun_num =
#endif /* f_Buffer_read_int_fun_num_used */
#line 2258 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_int", f_Buffer_read_int, tFunc("\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_int_defined */

#ifdef f_Buffer_read_hint_defined

#ifdef f_Buffer_read_hint_fun_num_used
  f_Buffer_read_hint_fun_num =
#endif /* f_Buffer_read_hint_fun_num_used */
#line 2289 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_hint", f_Buffer_read_hint, tFunc("\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_hint_defined */

#ifdef f_Buffer_read_ints_defined

#ifdef f_Buffer_read_ints_fun_num_used
  f_Buffer_read_ints_fun_num =
#endif /* f_Buffer_read_ints_fun_num_used */
#line 2330 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_ints", f_Buffer_read_ints, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tArr("\10\0\0\0\0\177\377\377\377")), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_ints_defined */

#ifdef f_Buffer_cq__encode_defined

#ifdef f_Buffer_cq__encode_fun_num_used
  f_Buffer_cq__encode_fun_num =
#endif /* f_Buffer_cq__encode_fun_num_used */
#line 2367 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("_encode", f_Buffer_cq__encode, tFunc(tNone,tStr), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__encode_defined */

#ifdef f_Buffer_cq__decode_defined

#ifdef f_Buffer_cq__decode_fun_num_used
  f_Buffer_cq__decode_fun_num =
#endif /* f_Buffer_cq__decode_fun_num_used */
#line 2372 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("_decode", f_Buffer_cq__decode, tFunc(tStr8,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__decode_defined */

#ifdef f_Buffer_read_only_defined

#ifdef f_Buffer_read_only_fun_num_used
  f_Buffer_read_only_fun_num =
#endif /* f_Buffer_read_only_fun_num_used */
#line 2392 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("read_only", f_Buffer_read_only, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_read_only_defined */

#ifdef f_Buffer_rewind_on_error_defined

#ifdef f_Buffer_rewind_on_error_fun_num_used
  f_Buffer_rewind_on_error_fun_num =
#endif /* f_Buffer_rewind_on_error_fun_num_used */
#line 2458 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("rewind_on_error", f_Buffer_rewind_on_error, tFunc(tNone,tName("Buffer.RewindKey", tObjImpl_BUFFER_REWINDKEY)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_rewind_on_error_defined */

#ifdef f_Buffer_rewind_key_defined

#ifdef f_Buffer_rewind_key_fun_num_used
  f_Buffer_rewind_key_fun_num =
#endif /* f_Buffer_rewind_key_fun_num_used */
#line 2463 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("rewind_key", f_Buffer_rewind_key, tFunc(tNone,tName("Buffer.RewindKey", tObjImpl_BUFFER_REWINDKEY)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_rewind_key_defined */

#ifdef f_Buffer_create_defined

#ifdef f_Buffer_create_fun_num_used
  f_Buffer_create_fun_num =
#endif /* f_Buffer_create_fun_num_used */
#line 2496 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    ADD_FUNCTION2("create", f_Buffer_create, tFunc(tOr5("\10\200\0\0\0\177\377\377\377",tVoid,tStr,tObj,tArray),tVoid), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_create_defined */
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
  Buffer_program=end_program();
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
#ifdef Buffer_program_fun_num_used
Buffer_program_fun_num=
#endif
 add_program_constant("Buffer",Buffer_program,0);

#endif /* class_Buffer_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 2649 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
start_new_program();
  low_inherit(generic_error_program,0,0,0,0,0);
  add_integer_constant( "buffer_error", 1, 0 );
  buffer_error_program = end_program();
}


void exit_stdio_buffer(void)
{
  free_program( buffer_error_program );
  
#ifdef class_Buffer_defined

#ifdef class_Buffer_RewindKey_defined
  if(Buffer_RewindKey_program) {
#line 2551 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    free_program(Buffer_RewindKey_program);
    Buffer_RewindKey_program=0;
  }

#endif /* class_Buffer_RewindKey_defined */
  if(Buffer_program) {
#line 71 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
    free_program(Buffer_program);
    Buffer_program=0;
  }

#endif /* class_Buffer_defined */
#line 2660 "/home/zino/hack/pike8-rel/pike/src/modules/_Stdio/buffer.cmod"
}



#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_Buffer_defined
if(id==2) return Buffer_program->id;
#endif
#ifdef class_Buffer_RewindKey_defined
if(id==3) return Buffer_RewindKey_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
