#line 1 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: builtin.cmod,v 1.156 2004/04/25 19:50:18 nilsson Exp $
*/

#include "global.h"
#include "interpret.h"
#include "svalue.h"
#include "pike_macros.h"
#include "object.h"
#include "program.h"
#include "array.h"
#include "pike_error.h"
#include "constants.h"
#include "mapping.h"
#include "stralloc.h"
#include "multiset.h"
#include "pike_types.h"
#include "pike_memory.h"
#include "threads.h"
#include <math.h>
#include <ctype.h>
#include "module_support.h"
#include "cyclic.h"
#include "bignum.h"
#include "main.h"
#include "operators.h"
#include "builtin_functions.h"
#include "fsort.h"
#include "port.h"
#include "gc.h"
#include <assert.h>

/*! @decl array(array(int|string)) describe_program(program p)
 *! @belongs Debug
 *!
 *! Debug function for showing the symbol table of a program.
 */
#define f_cq__describe_program_defined
void f_cq__describe_program(INT32 args) {
#line 41 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * x;
#line 41 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_describe_program",args,1);
#line 41 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 43 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  struct program *p;
  struct array *res;
  int i;

  if (!(p = program_from_svalue(Pike_sp - args)))
    SIMPLE_BAD_ARG_ERROR("_describe_program", 1, "program");

  for (i=0; i < (int)p->num_identifier_references;i++) {
    struct reference *ref = p->identifier_references + i;
    struct identifier *id = ID_FROM_PTR(p, ref);
    struct inherit *inh = INHERIT_FROM_PTR(p, ref);
    push_int(ref->id_flags);
    ref_push_string(id->name);
    push_int(id->identifier_flags);
    if (IDENTIFIER_IS_C_FUNCTION(id->identifier_flags)) {
      push_int(-2);
    } else {
      push_int(id->func.offset);
    }
    push_int(ref->inherit_offset);
    push_int(inh->inherit_level);
    f_aggregate(6);
  }
  f_aggregate(p->num_identifier_references);
  dmalloc_touch_svalue(Pike_sp-1);
  res = Pike_sp[-1].u.array;
  Pike_sp--;
  pop_n_elems(args);
  push_array(res);
}

}
/*! @decl string basetype(mixed x)
 *!
 *! Same as sprintf("%t",x);
 *!
 *! @seealso
 *! @[sprintf()]
 */
#define f_basetype_defined
void f_basetype(INT32 args) {
#line 82 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * x;
#line 82 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("basetype",args,1);
#line 82 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 85 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  int t=x->type;
  if(x->type == T_OBJECT && x->u.object->prog)
  {
    ptrdiff_t fun=FIND_LFUN(x->u.object->prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('t');
      f_aggregate_mapping(0);
      apply_low(x->u.object, fun, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      } else if (UNSAFE_IS_ZERO(Pike_sp-1)) {
	pop_n_elems(2);
	push_constant_text("object");
	return;
      } else {
	Pike_error("Non-string returned from _sprintf()\n");
      }
    }
  }
  pop_stack();
  switch(t)
  {
    case T_ARRAY: push_constant_text("array"); break;
    case T_FLOAT: push_constant_text("float"); break;
    case T_FUNCTION: push_constant_text("function"); break;
    case T_INT: push_constant_text("int"); break;
    case T_MAPPING: push_constant_text("mapping"); break;
    case T_MULTISET: push_constant_text("multiset"); break;
    case T_OBJECT: push_constant_text("object"); break;
    case T_PROGRAM: push_constant_text("program"); break;
    case T_STRING: push_constant_text("string"); break;
    case T_TYPE: push_constant_text("type"); break;
    case T_ZERO: push_constant_text("zero"); break;
    case T_VOID: push_constant_text("void"); break;
      /* The following are internal and shouldn't be applicable in normal use. */
    case T_SVALUE_PTR: push_constant_text("svalue_ptr"); break;
    case T_OBJ_INDEX: push_constant_text("obj_index"); break;
    case T_MAPPING_DATA: push_constant_text("mapping_data"); break;
    case T_PIKE_FRAME: push_constant_text("pike_frame"); break;
    case T_MULTISET_DATA: push_constant_text("multiset_data"); break;
    default: push_constant_text("unknown"); break;
  }
}


}
/*! @decl string int2char(int x)
 *! @appears String.int2char
 *!
 *! Same as sprintf("%c",x);
 *!
 *! @seealso
 *! @[sprintf()]
 */
#define f_int2char_defined
void f_int2char(INT32 args) {
#line 143 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * x;
#line 143 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("int2char",args,1);
#line 143 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 146 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  int c;
  if(x->type == T_OBJECT && x->u.object->prog)
  {
    ptrdiff_t fun=FIND_LFUN(x->u.object->prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('c');
      f_aggregate_mapping(0);
      apply_low(x->u.object, fun, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      }
      Pike_error("Non-string returned from _sprintf()\n");
    }
  }
  if(x->type != T_INT)
    SIMPLE_BAD_ARG_ERROR("int2char", 1, "int");

  c=x->u.integer;

  if(c>=0 && c<256)
  {
    struct pike_string *s;
    s=begin_shared_string(1);
    s->str[0]=c;
    do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 176 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}else{
    struct string_builder tmp;
    init_string_builder(&tmp,0);
    string_builder_putchar(&tmp, c);
    do { struct pike_string * ret_=(finish_string_builder(&tmp)); pop_stack(); push_string(ret_); return; }while(0);
#line 181 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
}

}
/*! @decl string int2hex(int x)
 *! @appears String.int2hex
 *!
 *! Same as @expr{sprintf("%x",x);@}, i.e. returns the integer @[x] in
 *! hexadecimal base using lower cased symbols.
 *!
 *! @seealso
 *! @[sprintf()]
 */
#define f_int2hex_defined
void f_int2hex(INT32 args) {
#line 193 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * x;
#line 193 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("int2hex",args,1);
#line 193 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
x=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 196 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  INT_TYPE c;
  unsigned INT_TYPE n;
  int len;
  struct pike_string *s;

  if(x->type == T_OBJECT && x->u.object->prog)
  {
    ptrdiff_t fun=FIND_LFUN(x->u.object->prog, LFUN__SPRINTF);
    if(fun != -1)
    {
      push_int('x');
      f_aggregate_mapping(0);
      apply_low(x->u.object, fun, 2);
      if(Pike_sp[-1].type == T_STRING)
      {
	stack_swap();
	pop_stack();
	return;
      }
      Pike_error("Non-string returned from _sprintf()\n");
    }
  }
  if(x->type != T_INT)
    SIMPLE_BAD_ARG_ERROR("int2hex", 1, "int");

  c=x->u.integer;

  len=1;
  if(c<0) {
    len++;
    n=(-c)&((unsigned INT_TYPE)(-1));
  }else{
    n=c;
  }
  while(n>65535) { n>>=16; len+=4; }
  while(n>15) { n>>=4; len++; }
  
  s=begin_shared_string(len);
  if(!c)
  {
    s->str[0]='0';
  }else{
    if(c<0)
    {
      s->str[0]='-';
      n=(-c)&((unsigned INT_TYPE)(-1));
    }else{
      n=c;
    }
    while(len && n)
    {
      s->str[--len]="0123456789abcdef"[n&0xf];
      n>>=4;
    }
  }
  do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 253 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}


}
#line 256 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
static inline int hexchar( int v )
{
  return v<10 ? v+'0' : (v-10)+'a';
}

/*! @decl string string2hex(string data)
 *! @appears String.string2hex
 *!
 *! Convert a string of binary data to a hexadecimal string.
 *!
 *! @seealso
 *!   @[hex2string()]
 */
#define f_string2hex_defined
ptrdiff_t f_string2hex_fun_num = 0;
void f_string2hex(INT32 args) {
#line 269 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 269 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.string2hex",args,1);
#line 269 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.string2hex",1,"string");
#line 269 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 272 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  struct pike_string *hex;
  unsigned char *st = s->str;
  int i;

  if (s->size_shift)
    Pike_error("Bad argument 1 to string2hex(), expected 8-bit string.\n");

  hex = begin_shared_string(2 * s->len);

  for (i=0; i<s->len; i++) {
    hex->str[i<<1] = hexchar(st[i]>>4);
    hex->str[i<<1|1] = hexchar(st[i]&15);
   }

  do { struct pike_string * ret_=(end_shared_string(hex)); pop_stack(); push_string(ret_); return; }while(0);
#line 288 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl string hex2string(string hex)
 *! @appears String.hex2string
 *!
 *! Convert a string of hexadecimal digits to binary data.
 *!
 *! @seealso
 *!   @[string2hex()]
 */
#define f_hex2string_defined
ptrdiff_t f_hex2string_fun_num = 0;
void f_hex2string(INT32 args) {
#line 298 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * hex;
#line 298 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.hex2string",args,1);
#line 298 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.hex2string",1,"string");
#line 298 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(hex=Pike_sp[0-1].u.string);
#line 301 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  struct pike_string *s;
  int i, o=0;
  unsigned char *q = hex->str;
  int l = hex->len>>1;
  if(hex->size_shift) Pike_error("Only hex digits allowed.\n");
  if(hex->len&1) Pike_error("Can't have odd number of digits.\n");

  s = begin_shared_string(l);
  for (i=0; i<l; i++)
  {
      s->str[i]  = (q[o]<='9' ? q[o]-'0' :((q[o]+9)&15))<<4; o++;
      s->str[i] |= (q[o]<='9' ? q[o]-'0': ((q[o]+9)&15));    o++;
  }
  do { struct pike_string * ret_=(end_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 316 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl array column(array data, mixed index)
 *!
 *! Extract a column from a two-dimensional array.
 *!
 *! This function is exactly equivalent to:
 *! @code
 *! map(@[data], lambda(mixed x,mixed y) { return x[y]; }, @[index])
 *! @endcode
 *!
 *! Except of course it is a lot shorter and faster.
 *! That is, it indices every index in the array data on the value of
 *! the argument index and returns an array with the results.
 *!
 *! @seealso
 *! @[rows()]
 */
#define f_column_defined
void f_column(INT32 args) {
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * data;
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * index;
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("column",args,2);
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("column",1,"array");
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(data=Pike_sp[0-2].u.array);
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
index=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
#line 337 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { struct array * ret_=(array_column (data, index, 1)); pop_n_elems(2); push_array(ret_); return; }while(0);
#line 339 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl multiset mkmultiset(array a)
 *!
 *! This function creates a multiset from an array.
 *!
 *! @seealso
 *! @[aggregate_multiset()]
 *!
 */
#define f_mkmultiset_defined
void f_mkmultiset(INT32 args) {
#line 349 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * a;
#line 349 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("mkmultiset",args,1);
#line 349 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmultiset",1,"array");
#line 349 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-1].u.array);
#line 352 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { struct multiset * ret_=(mkmultiset(a)); pop_stack(); push_multiset(ret_); return; }while(0);
#line 354 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl int trace(int level, void|string facility, void|int all_threads)
 *!
 *! This function changes the trace level for the subsystem identified
 *! by @[facility] to @[level]. If @[facility] is zero or left out, it
 *! changes the global trace level which affects all subsystems.
 *!
 *! Enabling tracing causes messages to be printed to stderr. A higher
 *! trace level includes the output from all lower levels. The lowest
 *! level is zero which disables all trace messages.
 *!
 *! See the @tt{-t@} command-line option for more information.
 *!
 *! @param level
 *!   If @[facility] is specified then there is typically only one
 *!   trace level for it, i.e. it's an on-or-off toggle. The global
 *!   trace levels, when @[facility] isn't specified, are:
 *!
 *!   @int
 *!   @value 1
 *!  	Trace calls to Pike functions and garbage collector runs.
 *!   @value 2
 *!  	Trace calls to builtin functions.
 *!   @value 3
 *!  	Trace every interpreted opcode.
 *!   @value 4
 *!  	Also trace the opcode arguments.
 *!   @endint
 *!
 *! @param facility
 *!   Valid facilities are:
 *!
 *!   @string
 *!   @value "gc"
 *!     Trace the start and end of each run of the garbage collector.
 *!     The setting is never thread local.
 *!   @endstring
 *!
 *! @param all_threads
 *!   Trace levels are normally thread local, so changes affect only
 *!   the current thread. To change the level in all threads, pass a
 *!   nonzero value in this argument.
 *!
 *! @returns
 *!   The old trace level in the current thread is returned.
 */
#define f_trace_defined
void f_trace(INT32 args) {
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE level;
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * facility;
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * all_threads;
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("trace",args,1);
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 3) wrong_number_of_args_error("trace",args,3);
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("trace",1,"int");
level=Pike_sp[0-args].u.integer;
if (args > 1) {
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
facility=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else facility=0;
if (args > 2) {
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
all_threads=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
} else all_threads=0;
#line 404 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  INT32 old_level;
  if (facility) {
    struct pike_string *gc_str;
    if (facility->type != T_STRING)
      SIMPLE_BAD_ARG_ERROR("trace", 2, "void|string");
    MAKE_CONST_STRING(gc_str, "gc");
    if (facility->u.string == gc_str) {
      old_level = gc_trace;
      gc_trace = level;
    }
    else {
      bad_arg_error("trace", Pike_sp-args, args, 2,
		   "trace facility identifier", Pike_sp-args+1,
                   "Bad argument 2 to trace(). Unknown trace facility.");
    }
  }
  else {
    old_level = Pike_interpreter.trace_level;
#ifdef PIKE_THREADS
    if (!all_threads || UNSAFE_IS_ZERO (all_threads))
      Pike_interpreter.trace_level = level;
    else {
      struct thread_state *s;
      FOR_EACH_THREAD(s, s->state.trace_level = level);
    }
#else
    Pike_interpreter.trace_level = level;
#endif
  }
  do { INT_TYPE ret_=(old_level); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 435 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl mapping(string:float) gc_parameters (void|mapping(string:mixed) params)
 *! @belongs Pike
 *!
 *! Set and get various parameters that control the operation of the
 *! garbage collector. The passed mapping contains the parameters to
 *! set. If a parameter is missing from the mapping, the current value
 *! will be filled in instead. The same mapping is returned. Thus an
 *! empty mapping, or no argument at all, causes a mapping with all
 *! current settings to be returned.
 *!
 *! The following parameters are recognized:
 *!
 *! @mapping
 *! @member int "enabled"
 *!   If this is 1 then the gc is enabled as usual. If it's 0 then all
 *!   automatically scheduled gc runs are disabled and the parameters
 *!   below have no effect, but explicit runs through the @[gc]
 *!   function still works as usual. If it's -1 then the gc is
 *!   completely disabled so that even explicit @[gc] calls won't do
 *!   anything.
 *! @member float "garbage_ratio_low"
 *!   As long as the gc time is less than gc_time_ratio, aim to run
 *!   the gc approximately every time the ratio between the garbage
 *!   and the total amount of allocated things is this.
 *! @member float "time_ratio"
 *!   When more than this fraction of the cpu time is spent in the gc,
 *!   aim for gc_garbage_ratio_high instead of gc_garbage_ratio_low.
 *! @member float "garbage_ratio_high"
 *!   Upper limit for the garbage ratio - run the gc as often as it
 *!   takes to keep it below this.
 *! @member float "average_slowness"
 *!   When predicting the next gc interval, use a decaying average
 *!   with this slowness factor. It should be a value between 0.0 and
 *!   1.0 that specifies the weight to give to the old average value.
 *!   The remaining weight up to 1.0 is given to the last reading.
 *! @endmapping
 *!
 *! @seealso
 *!   @[gc], @[Debug.gc_status]
 */
#define f_gc_parameters_defined
ptrdiff_t f_gc_parameters_fun_num = 0;
void f_gc_parameters(INT32 args) {
#line 477 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * params;
#line 477 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("gc_parameters",args,1);
if (args > 0) {
#line 477 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
params=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else params=0;
#line 480 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  struct pike_string *str;
  struct svalue *set;
  struct svalue get;

  if (!params) {
    push_mapping (allocate_mapping (5));
    params = Pike_sp - 1;
  }
  else if (params->type != T_MAPPING)
    SIMPLE_BAD_ARG_ERROR ("Pike.gc_parameters", 1, "void|mapping");

#define HANDLE_PARAM(NAME, CHECK_AND_SET, GET) do {			\
    MAKE_CONST_STRING (str, NAME);					\
    if ((set = low_mapping_string_lookup (params->u.mapping, str))) {	\
      CHECK_AND_SET;							\
    }									\
    else {								\
      GET;								\
      mapping_string_insert (params->u.mapping, str, &get);		\
    }									\
  } while (0)

#define HANDLE_FLOAT_FACTOR(NAME, VAR)					\
  HANDLE_PARAM (NAME, {							\
      if (set->type != T_FLOAT ||					\
	  set->u.float_number < 0.0 || set->u.float_number > 1.0)	\
	SIMPLE_BAD_ARG_ERROR ("Pike.gc_parameters", 1,			\
			      "float between 0.0 and 1.0 for " NAME);	\
      VAR = set->u.float_number;					\
    }, {								\
      get.type = T_FLOAT;						\
      get.u.float_number = VAR;						\
    });

  HANDLE_PARAM ("enabled", {
      if (set->type != T_INT || set->u.integer < -1 || set->u.integer > 1)
	SIMPLE_BAD_ARG_ERROR ("Pike.gc_parameters", 1,
			      "integer in the range -1..1 for 'enabled'");
      if (gc_enabled != set->u.integer) {
	if (gc_enabled > 0)
	  gc_enabled = set->u.integer;
	else {
	  gc_enabled = 1;
	  if (alloc_threshold == GC_MAX_ALLOC_THRESHOLD)
	    alloc_threshold = GC_MIN_ALLOC_THRESHOLD;
	}
      }
    }, {
      get.type = T_INT;
      get.u.integer = gc_enabled;
    });
  HANDLE_FLOAT_FACTOR ("garbage_ratio_low", gc_garbage_ratio_low);
  HANDLE_FLOAT_FACTOR ("time_ratio", gc_time_ratio);
  HANDLE_FLOAT_FACTOR ("garbage_ratio_high", gc_garbage_ratio_high);
  HANDLE_FLOAT_FACTOR ("average_slowness", gc_average_slowness);

#undef HANDLE_PARAM
#undef HANDLE_FLOAT_FACTOR

  do { struct mapping * ret_=(params->u.mapping); add_ref(ret_); pop_n_elems(args); push_mapping(ret_); return; }while(0);
#line 541 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl string ctime(int timestamp)
 *!
 *! Convert the output from a previous call to @[time()] into a readable
 *! string containing the current year, month, day and time.
 *!
 *! Like @[localtime], this function might throw an error if the
 *! ctime(2) call failed on the system. It's platform dependent what
 *! time ranges that function can handle, e.g. Windows doesn't handle
 *! a negative @[timestamp].
 *!
 *! @seealso
 *! @[time()], @[localtime()], @[mktime()], @[gmtime()]
 */
#define f_ctime_defined
void f_ctime(INT32 args) {
#line 556 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE timestamp;
#line 556 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("ctime",args,1);
#line 556 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("ctime",1,"int");
timestamp=Pike_sp[0-1].u.integer;
#line 559 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  time_t i=(time_t)timestamp;
  char *s = ctime (&i);
  if (!s) Pike_error ("ctime() on this system cannot handle "
		      "the timestamp %ld.\n", (long) i);
  do { struct pike_string * ret_=(make_shared_string(s)); pop_stack(); push_string(ret_); return; }while(0);
#line 565 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl mapping mkmapping(array ind, array val)
 *!
 *! Make a mapping from two arrays.
 *!
 *! Makes a mapping @[ind[x]]:@[val[x]], @tt{0 <= x < sizeof(ind)@}.
 *!
 *! @[ind] and @[val] must have the same size.
 *!
 *! This is the inverse operation of @[indices()] and @[values()].
 *!
 *! @seealso
 *! @[indices()], @[values()]
 */
#define f_mkmapping_defined
void f_mkmapping(INT32 args) {
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * ind;
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * val;
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("mkmapping",args,2);
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmapping",1,"array");
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(ind=Pike_sp[0-2].u.array);
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmapping",2,"array");
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(val=Pike_sp[1-2].u.array);
#line 583 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if(ind->size != val->size)
    bad_arg_error("mkmapping", Pike_sp-args, args, 2, "array", Pike_sp+1-args,
		  "mkmapping called on arrays of different sizes (%d != %d)\n",
		  ind->size, val->size);

  do { struct mapping * ret_=(mkmapping(ind, val)); pop_n_elems(2); push_mapping(ret_); return; }while(0);
#line 590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl int count(string haystack, string needle)
 *! @belongs String
 *!
 *! Count the number of non-overlapping times the string @[needle] occurrs
 *! in the string @[haystack].
 *!
 *! @seealso
 *! @[search()], @[`/()]
 */
#define f_string_count_defined
ptrdiff_t f_string_count_fun_num = 0;
void f_string_count(INT32 args) {
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * haystack;
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * needle;
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("String.count",args,2);
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.count",1,"string");
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(haystack=Pike_sp[0-2].u.string);
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.count",2,"string");
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(needle=Pike_sp[1-2].u.string);
#line 604 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
   ptrdiff_t c = 0;
   ptrdiff_t i, j;

   switch (needle->len)
   {
     case 0:
       switch (haystack->len)
       {
	 case 0: c=1; break; /* "" appears one time in "" */
	 case 1: c=0; break; /* "" doesn't appear in "x" */
	 default: c=haystack->len-1; /* one time between each character */
       }
       break;
     case 1:
       /* maybe optimize? */
     default:
       for (i=0; i<haystack->len; i++)
       {
	 j=string_search(haystack,needle,i);
	 if (j==-1) break;
	 i=j+needle->len-1;
	 c++;
       }
       break;
   }
   do { INT_TYPE ret_=(DO_NOT_WARN((INT_TYPE)c)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 631 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl string trim_whites (string s)
 *! @belongs String
 *!
 *! Trim leading and trailing spaces and tabs from the string @[s].
 */
#define f_string_trim_whites_defined
ptrdiff_t f_string_trim_whites_fun_num = 0;
void f_string_trim_whites(INT32 args) {
#line 638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.trim_whites",args,1);
#line 638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.trim_whites",1,"string");
#line 638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 641 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  ptrdiff_t start = 0, end = s->len;
  int chr;
  switch (s->size_shift) {
#define DO_IT(TYPE)							\
    {									\
      for (; start < s->len; start++) {					\
	chr = ((TYPE *) s->str)[start];					\
	if (chr != ' ' && chr != '\t') break;				\
      }									\
      while (--end > start) {						\
	chr = ((TYPE *) s->str)[end];					\
	if (chr != ' ' && chr != '\t') break;				\
      }									\
    }
    case 0: DO_IT (p_wchar0); break;
    case 1: DO_IT (p_wchar1); break;
    case 2: DO_IT (p_wchar2); break;
#undef DO_IT
  }
  do { struct pike_string * ret_=(string_slice (s, start, end + 1 - start)); pop_stack(); push_string(ret_); return; }while(0);
#line 662 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl string trim_all_whites (string s)
 *! @belongs String
 *!
 *! Trim leading and trailing white spaces characters (space, tab,
 *! newline and carriage return) from the string @[s].
 */
#define f_string_trim_all_whites_defined
ptrdiff_t f_string_trim_all_whites_fun_num = 0;
void f_string_trim_all_whites(INT32 args) {
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.trim_all_whites",args,1);
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.trim_all_whites",1,"string");
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 673 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  ptrdiff_t start = 0, end = s->len;
  int chr;
  switch (s->size_shift) {
#define DO_IT(TYPE)							\
    {									\
      for (; start < s->len; start++) {					\
	chr = ((TYPE *) s->str)[start];					\
	if (chr != ' ' && chr != '\t' && chr != '\n' && chr != '\r')	\
	  break;							\
      }									\
      while (--end > start) {						\
	chr = ((TYPE *) s->str)[end];					\
	if (chr != ' ' && chr != '\t' && chr != '\n' && chr != '\r')	\
	  break;							\
      }									\
    }
    case 0: DO_IT (p_wchar0); break;
    case 1: DO_IT (p_wchar1); break;
    case 2: DO_IT (p_wchar2); break;
#undef DO_IT
  }
  do { struct pike_string * ret_=(string_slice (s, start, end + 1 - start)); pop_stack(); push_string(ret_); return; }while(0);
#line 696 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl int implements(program prog, program api)
 *! @belongs Program
 *!
 *! Returns 1 if @[prog] implements @[api].
 */
#define f_program_implements_defined
ptrdiff_t f_program_implements_fun_num = 0;
void f_program_implements(INT32 args) {
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct program * prog;
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct program * api;
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.implements",args,2);
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(!(prog=program_from_svalue(Pike_sp+0-2))) SIMPLE_BAD_ARG_ERROR("Program.implements",1,"program");
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(!(api=program_from_svalue(Pike_sp+1-2))) SIMPLE_BAD_ARG_ERROR("Program.implements",2,"program");
#line 706 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { INT_TYPE ret_=(implements(prog, api)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 708 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl int inherits(program child, program parent)
 *! @belongs Program
 *!
 *! Returns 1 if @[child] has inherited @[parent].
 */
#define f_program_inherits_defined
ptrdiff_t f_program_inherits_fun_num = 0;
void f_program_inherits(INT32 args) {
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct program * parent;
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct program * child;
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.inherits",args,2);
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(!(parent=program_from_svalue(Pike_sp+0-2))) SIMPLE_BAD_ARG_ERROR("Program.inherits",1,"program");
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(!(child=program_from_svalue(Pike_sp+1-2))) SIMPLE_BAD_ARG_ERROR("Program.inherits",2,"program");
#line 718 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { INT_TYPE ret_=(low_get_storage(parent, child) != -1); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 720 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl string defined(program p)
 *! @belongs Program
 *!
 *! Returns a string with filename and linenumber describing where
 *! the program @[p] was defined.
 *!
 *! The returned string is of the format @expr{"filename:linenumber"@}.
 *!
 *! If it cannot be determined where the program was defined, @expr{0@}
 *! (zero) will be returned.
 */
#define f_program_defined_defined
ptrdiff_t f_program_defined_fun_num = 0;
void f_program_defined(INT32 args) {
#line 733 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct program * p;
#line 733 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("Program.defined",args,1);
#line 733 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(!(p=program_from_svalue(Pike_sp+0-1))) SIMPLE_BAD_ARG_ERROR("Program.defined",1,"program");
#line 736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  INT32 line;
  struct pike_string *tmp = low_get_program_line(p, &line);

  pop_n_elems(args);

  if (tmp) {
    push_string(tmp);
    if(line >= 1)
    {
      push_constant_text(":");
      push_int(line);
      f_add(3);
    }
  }
  else
    push_int(0);
}

}
/*! @decl int(8..8)|int(16..16)|int(32..32) width(string s)
 *! @belongs String
 *!
 *! Returns the width of a string.
 *!
 *! Three return values are possible:
 *! @int
 *!   @value 8
 *!     The string @[s] only contains characters <= 255.
 *!   @value 16
 *!     The string @[s] only contains characters <= 65535.
 *!   @value 32
 *!     The string @[s] contains characters >= 65536.
 *! @endint
 */
#define f_string_width_defined
ptrdiff_t f_string_width_fun_num = 0;
void f_string_width(INT32 args) {
#line 770 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 770 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.width",args,1);
#line 770 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.width",1,"string");
#line 770 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 773 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { INT_TYPE ret_=(8 * (1 << s->size_shift)); pop_stack(); push_int(ret_); return; }while(0);
#line 775 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl mixed m_delete(object|mapping map, mixed index)
 *!
 *! If @[map] is an object that implements @[lfun::_m_delete()],
 *! that function will be called with @[index] as its single argument.
 *!
 *! Otherwise if @[map] is a mapping the entry with index @[index]
 *! will be removed from @[map] destructively.
 *!
 *! If the mapping does not have an entry with index @[index], nothing is done.
 *!
 *! @returns
 *!   The value that was removed will be returned.
 *!
 *! @note
 *!   Note that @[m_delete()] changes @[map] destructively.
 *!
 *! @seealso
 *!   @[mappingp()]
 */
#define f_m_delete_defined
void f_m_delete(INT32 args) {
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * map;
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * index;
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("m_delete",args,2);
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
map=Pike_sp+0-2; dmalloc_touch_svalue(Pike_sp+0-2);
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
index=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
#line 799 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  /*FIXME: Should be
   *     type function(mapping(1=mixed:2=mixed),1:2)|
   *     function(object,mixed:mixed);
   *
   *     or similar
   */
  if( map->type == T_MAPPING )
  {
    struct svalue s;
    map_delete_no_free(map->u.mapping, index, &s);
    pop_n_elems(args);
    *Pike_sp=s;
    Pike_sp++;
    dmalloc_touch_svalue(Pike_sp-1);
  }
  else if (map->type == T_OBJECT && map->u.object->prog)
  {
    int id = FIND_LFUN(map->u.object->prog, LFUN__M_DELETE);

    if( id == -1 )
      SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object containing the _m_delete method");
    
    apply_low( map->u.object, id, 1 );
    stack_swap();
    pop_stack();
  } else {
    SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object|mapping");
  }
}

}
/*! @decl int get_weak_flag(array|mapping|multiset m)
 *!
 *! Returns the weak flag settings for @[m]. It's a combination of
 *! @[Pike.WEAK_INDICES] and @[Pike.WEAK_VALUES].
 */
#define f_get_weak_flag_1_defined
void f_get_weak_flag_1(INT32 args) {
#line 835 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * m;
#line 835 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 835 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"array");
#line 835 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.array);
#line 838 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  do { INT_TYPE ret_=((m->flags & ARRAY_WEAK_FLAG) ? PIKE_WEAK_VALUES : 0); pop_stack(); push_int(ret_); return; }while(0);
#line 840 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
#define f_get_weak_flag_2_defined
ptrdiff_t f_get_weak_flag_2_fun_num = 0;
void f_get_weak_flag_2(INT32 args) {
#line 842 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct mapping * m;
#line 842 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 842 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"mapping(mixed:mixed)");
#line 842 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.mapping);
{
  do { INT_TYPE ret_=(mapping_get_flags(m) & MAPPING_WEAK); pop_stack(); push_int(ret_); return; }while(0);
#line 845 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
#define f_get_weak_flag_3_defined
ptrdiff_t f_get_weak_flag_3_fun_num = 0;
void f_get_weak_flag_3(INT32 args) {
#line 847 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct multiset * m;
#line 847 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 847 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"multiset");
#line 847 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.multiset);
{
  do { INT_TYPE ret_=(multiset_get_flags(m) & MULTISET_WEAK); pop_stack(); push_int(ret_); return; }while(0);
#line 850 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}

#if defined(f_get_weak_flag_1_defined) || defined(f_get_weak_flag_2_defined) || defined(f_get_weak_flag_3_defined)
#define f_get_weak_flag_defined
void f_get_weak_flag(INT32 args) {
  if(args < 1) wrong_number_of_args_error("get_weak_flag",args,1);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_MULTISET:

#ifdef f_get_weak_flag_3_defined
    f_get_weak_flag_3(args);
    return;

#endif /* f_get_weak_flag_3_defined */
    break;
   case PIKE_T_MAPPING:

#ifdef f_get_weak_flag_2_defined
    f_get_weak_flag_2(args);
    return;

#endif /* f_get_weak_flag_2_defined */
    break;
   case PIKE_T_ARRAY:

#ifdef f_get_weak_flag_1_defined
    f_get_weak_flag_1(args);
    return;

#endif /* f_get_weak_flag_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"multiset|mapping|array");
  }
}

#endif /* f_get_weak_flag_1_defined, f_get_weak_flag_2_defined, f_get_weak_flag_3_defined */
/*! @decl program __empty_program(int|void line, string|void file)
 */
#define f_cq___empty_program_defined
void f_cq___empty_program(INT32 args) {
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * line;
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * file;
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("__empty_program",args,2);
if (args > 0) {
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
line=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else line=0;
if (args > 1) {
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
file=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else file=0;
#line 857 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if (line && line->type != T_INT)
    SIMPLE_BAD_ARG_ERROR("__empty_program", 1, "int|void");
  else if (file && file->type != T_STRING)
    SIMPLE_BAD_ARG_ERROR("__empty_program", 2, "string|void");
  else {
    struct program *prog = low_allocate_program();
    if (file) ext_store_program_line (prog, line->u.integer, file->u.string);
    do { struct program * ret_=(prog); pop_n_elems(args); push_program(ret_); return; }while(0);
#line 866 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
}

}
/*! @decl string function_name(function f)
 *!
 *! Return the name of the function @[f].
 *!
 *! If @[f] is a global function defined in the runtime @expr{0@}
 *! (zero) will be returned.
 *!
 *! @seealso
 *! @[function_object()]
 */
#define f_function_name_defined
void f_function_name(INT32 args) {
#line 879 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * func;
#line 879 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_name",args,1);
#line 879 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 882 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  switch(func->type)
  {
    default:
      SIMPLE_BAD_ARG_ERROR("function_name", 1, "function|program");
      return; /* NOTREACHED */
	
    case PIKE_T_PROGRAM:
    {
      struct program *p=func->u.program;

      if(p->parent)
      {
	int e;
	p=p->parent;
	/* search constants in parent for this
	 * program...
	 */
	
	for(e = p->num_identifier_references; e--; )
	{
	  struct identifier *id;
	  if (p->identifier_references[e].id_flags & ID_HIDDEN)
	    continue;

	  id = ID_FROM_INT(p, e);
	  if (IDENTIFIER_IS_CONSTANT(id->identifier_flags) &&
	      (id->func.offset >= 0) &&
	      is_eq( & PROG_FROM_INT(p, e)->constants[id->func.offset].sval,
		     func))
	    do { struct pike_string * ret_=(id->name); add_ref(ret_); pop_stack(); push_string(ret_); return; }while(0);
#line 913 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
#ifdef PIKE_DEBUG
	if (d_flag>5) {
	  fprintf(stderr,
		  "Failed to find symbol for program %p\n"
		  "Parent program info:\n",
		  func->u.program);
	  dump_program_tables(func->u.program->parent, 0);
	}
#endif
      }
      break;
    }

    case PIKE_T_FUNCTION:
      if(func->subtype == FUNCTION_BUILTIN) break;
      if(!func->u.object->prog)
	bad_arg_error("function_name", Pike_sp-args, args, 1,
		      "function", Pike_sp-args,
		      "Destructed object.\n");
      if(func->u.object->prog == pike_trampoline_program)
      {
	struct pike_trampoline *t;
	t=((struct pike_trampoline *)func->u.object->storage);
	if(t->frame->current_object->prog)
	  do { struct pike_string * ret_=(ID_FROM_INT(t->frame->current_object->prog,
				 t->func)->name); add_ref(ret_); pop_stack(); push_string(ret_); return; }while(0);
#line 940 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
      
      do { struct pike_string * ret_=(ID_FROM_INT(func->u.object->prog, func->subtype)->name); add_ref(ret_); pop_stack(); push_string(ret_); return; }while(0);
#line 943 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
  pop_n_elems(args);
  push_int(0);
}

}
/*! @decl object function_object(function f)
 *!
 *!   Return the object the function @[f] is in.
 *!
 *!   If @[f] is a global function defined in the runtime @expr{0@}
 *!   (zero) will be returned.
 *!
 *!   Zero will also be returned if @[f] is a constant in the
 *!   parent class. In that case @[function_program()] can be
 *!   used to get the parent program.
 *!
 *! @seealso
 *!   @[function_name()], @[function_program()]
 */
#define f_function_object_defined
void f_function_object(INT32 args) {
#line 962 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * func;
#line 962 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_object",args,1);
#line 962 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 966 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  switch(func->type)
  {
    case PIKE_T_PROGRAM:
      break;
      
    case PIKE_T_FUNCTION:
      if(func->subtype == FUNCTION_BUILTIN) break;
      if(func->u.object->prog == pike_trampoline_program)
      {
	struct object *o;
	o=((struct pike_trampoline *)func->u.object->storage)->frame->current_object;
	add_ref(o);
	pop_n_elems(args);
	push_object(o);
	return;
      }
      func->type=T_OBJECT;
      return;


    default:
      SIMPLE_BAD_ARG_ERROR("function_object",1,"function");
  }
  pop_n_elems(args);
  push_int(0);
}

}
/*! @decl program function_program(function|program f)
 *!
 *!   Return the program the function @[f] is in.
 *!
 *!   If @[f] is a global function defined in the runtime @expr{0@}
 *!   (zero) will be returned.
 *!
 *! @seealso
 *!   @[function_name()], @[function_object()]
 */
#define f_function_program_defined
void f_function_program(INT32 args) {
#line 1004 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * func;
#line 1004 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("function_program",args,1);
#line 1004 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
func=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 1007 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  switch(func->type)
  {
    case PIKE_T_PROGRAM:
    {
      struct program *p;
      if(!(p=func->u.program->parent)) break;
      add_ref(p);
      free_program(func->u.program);
      func->u.program=p;
      return;
    }
      
    case PIKE_T_FUNCTION:
      {
	struct program *p;
	if(func->subtype == FUNCTION_BUILTIN)
	  p = func->u.efun->prog;
	else
	  p = func->u.object->prog;
	if(p == pike_trampoline_program)
	{
	  p = ((struct pike_trampoline *)func->u.object->storage)->
	    frame->current_object->prog;
	}
	if (p) {
	  ref_push_program(p);
	  stack_pop_n_elems_keep_top(args);
	  return;
	}
      }
      break;

    default:
      SIMPLE_BAD_ARG_ERROR("function_program", 1, "function");
  }
  pop_n_elems(args);
  push_int(0);
}


}
/*! @decl mixed random(object o)
 *!   If random is called with an object, @[lfun::random] will be
 *!   called in the object.
 *! @seealso
 *!  @[lfun::_random]
 */

/*! @decl mixed lfun::_random()
 *!   Called by @[random]. Typical uses is when the object implements
 *!   a ADT, then a call to this lfun should return a random member of
 *!   the ADT or range implied by the ADT.
 *! @seealso
 *!   @[predef::random()]
 */

#define f_random_1_defined
void f_random_1(INT32 args) {
#line 1063 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct object * o;
#line 1063 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1063 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("random",1,"object");
#line 1063 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(o=Pike_sp[0-1].u.object);
#line 1066 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  apply(o,"_random",0);
  stack_swap();
  pop_stack();
}

}
/*! @decl int random(int max)
 *! @decl float random(float max)
 *!
 *!   This function returns a random number in the range 0 - @[max]-1.
 *!
 *! @seealso
 *!   @[random_seed()]
 */

#define f_random_2_defined
ptrdiff_t f_random_2_fun_num = 0;
void f_random_2(INT32 args) {
#line 1081 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE i;
#line 1081 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1081 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("random",1,"int");
i=Pike_sp[0-1].u.integer;
#line 1082 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if(i <= 0) do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);do { INT_TYPE ret_=(
#line 1084 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
my_rand() % i); pop_stack(); push_int(ret_); return; }while(0);
#line 1085 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}      

}
#define f_random_3_defined
ptrdiff_t f_random_3_fun_num = 0;
void f_random_3(INT32 args) {
#line 1087 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
FLOAT_TYPE f;
#line 1087 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1087 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_FLOAT) SIMPLE_BAD_ARG_ERROR("random",1,"float");
f=Pike_sp[0-1].u.float_number;
#line 1088 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if(f<=0.0) do { FLOAT_TYPE ret_=(0.0); pop_stack(); push_float(ret_); return; }while(0);
#line 1090 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
#define N 1048576
  do { FLOAT_TYPE ret_=(f * (my_rand()%N/((float)N)) +
    f * (my_rand()%N/( ((float)N) * ((float)N) ))); pop_stack(); push_float(ret_); return; }while(0);
#line 1094 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

}
/*! @decl mixed random(array|multiset x)
 *!   Returns a random element from @[x].
 */

#define f_random_4_defined
ptrdiff_t f_random_4_fun_num = 0;
void f_random_4(INT32 args) {
#line 1100 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * a;
#line 1100 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1100 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("random",1,"array");
#line 1100 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-1].u.array);
#line 1102 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if(!a->size)
    SIMPLE_BAD_ARG_ERROR("random", 1, "array with elements in it");
  push_svalue(a->item + (my_rand() % a->size));
  stack_swap();
  pop_stack();
}

}
#define f_random_5_defined
ptrdiff_t f_random_5_fun_num = 0;
void f_random_5(INT32 args) {
#line 1110 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct multiset * m;
#line 1110 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1110 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MULTISET) SIMPLE_BAD_ARG_ERROR("random",1,"multiset");
#line 1110 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.multiset);
#line 1112 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  if(multiset_is_empty (m))
    SIMPLE_BAD_ARG_ERROR("random", 1, "multiset with elements in it");
  if (multiset_indval (m)) {
    ptrdiff_t nodepos = multiset_get_nth (m, my_rand() % multiset_sizeof (m));
    push_multiset_index (m, nodepos);
    push_multiset_value (m, nodepos);
    sub_msnode_ref (m);
    f_aggregate (2);
  }
  else {
    push_multiset_index (m, multiset_get_nth (m, my_rand() %
					      multiset_sizeof (m)));
    sub_msnode_ref (m);
  }
  stack_swap();
  pop_stack();
}

}
/*! @decl array random(mapping m)
 *!   Returns a random index-value pair from the mapping.
 */

#define f_random_6_defined
ptrdiff_t f_random_6_fun_num = 0;
void f_random_6(INT32 args) {
#line 1135 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct mapping * m;
#line 1135 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("random",args,1);
#line 1135 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("random",1,"mapping(mixed:mixed)");
#line 1135 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(m=Pike_sp[0-1].u.mapping);
{
  struct mapping_data *md=m->data;
  size_t bucket, count;
  struct keypair *k;
  
  if(!m_sizeof(m))
    SIMPLE_BAD_ARG_ERROR("random", 1, "mapping with elements in it");
  
  /* Find a random, nonempty bucket */
  bucket=my_rand() % md->hashsize;
  while(! md->hash[bucket] )
    if(++bucket > (size_t)md->hashsize)
      bucket=0;
  
  /* Count entries in bucket */
  count=0;
  for(k=md->hash[bucket];k;k=k->next) count++;
  
  /* Select a random entry in this bucket */
  count = my_rand() % count;
  k=md->hash[bucket];
  while(count-- > 0) k=k->next;
  
  /* Push result and return */
  push_svalue(&k->ind);
  push_svalue(&k->val);
  f_aggregate(2);
  stack_swap();
  pop_stack();
}

}

#if defined(f_random_1_defined) || defined(f_random_2_defined) || defined(f_random_3_defined) || defined(f_random_4_defined) || defined(f_random_5_defined) || defined(f_random_6_defined)
#define f_random_defined
void f_random(INT32 args) {
  if(args < 1) wrong_number_of_args_error("random",args,1);
  switch(Pike_sp[0-args].type) {
   case PIKE_T_MAPPING:

#ifdef f_random_6_defined
    f_random_6(args);
    return;

#endif /* f_random_6_defined */
    break;
   case PIKE_T_MULTISET:

#ifdef f_random_5_defined
    f_random_5(args);
    return;

#endif /* f_random_5_defined */
    break;
   case PIKE_T_ARRAY:

#ifdef f_random_4_defined
    f_random_4(args);
    return;

#endif /* f_random_4_defined */
    break;
   case PIKE_T_FLOAT:

#ifdef f_random_3_defined
    f_random_3(args);
    return;

#endif /* f_random_3_defined */
    break;
   case PIKE_T_INT:

#ifdef f_random_2_defined
    f_random_2(args);
    return;

#endif /* f_random_2_defined */
    break;
   case PIKE_T_OBJECT:

#ifdef f_random_1_defined
    f_random_1(args);
    return;

#endif /* f_random_1_defined */
    break;
   default:
    SIMPLE_BAD_ARG_ERROR("random",1,"mapping|multiset|array|float|int|object");
  }
}

#endif /* f_random_1_defined, f_random_2_defined, f_random_3_defined, f_random_4_defined, f_random_5_defined, f_random_6_defined */
#line 1167 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
/*
 * Backtrace handling.
 */

/*! @module Pike
 */

/*! @class BacktraceFrame
 */


#undef class_backtrace_frame_defined
#define class_backtrace_frame_defined
struct program *backtrace_frame_program=0;
int backtrace_frame_program_fun_num=-1;

#undef var_fun_backtrace_frame_defined
#define var_fun_backtrace_frame_defined

#undef var_args_backtrace_frame_defined
#define var_args_backtrace_frame_defined
#line 1182 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
/* These are cleared when filename and lineno has been initialized
   * from them. */
  
#undef var_prog_backtrace_frame_defined
#define var_prog_backtrace_frame_defined

#undef var_pc_backtrace_frame_defined
#define var_pc_backtrace_frame_defined
#line 1187 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
/* These two are considered to be uninitialized from prog, pc and
   * fun as long as lineno == -1. */
  
#undef var_filename_backtrace_frame_defined
#define var_filename_backtrace_frame_defined

#undef var_lineno_backtrace_frame_defined
#define var_lineno_backtrace_frame_defined

#undef THIS
#define THIS ((struct backtrace_frame_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BACKTRACE_FRAME
#define THIS_BACKTRACE_FRAME ((struct backtrace_frame_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BACKTRACE_FRAME
#define OBJ2_BACKTRACE_FRAME(o) ((struct backtrace_frame_struct *)(o->storage+backtrace_frame_storage_offset))

#undef GET_BACKTRACE_FRAME_STORAGE
#define GET_BACKTRACE_FRAME_STORAGE ((struct backtrace_frame_struct *)(o->storage+backtrace_frame_storage_offset)
static ptrdiff_t backtrace_frame_storage_offset;
struct backtrace_frame_struct {

#ifdef var_fun_backtrace_frame_defined
  struct svalue fun;

#endif /* var_fun_backtrace_frame_defined */

#ifdef var_args_backtrace_frame_defined
  struct array * args;

#endif /* var_args_backtrace_frame_defined */

#ifdef var_prog_backtrace_frame_defined
  struct program * prog;

#endif /* var_prog_backtrace_frame_defined */

#ifdef var_pc_backtrace_frame_defined
#line 1185 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
PIKE_OPCODE_T *pc;
#endif /* var_pc_backtrace_frame_defined */

#ifdef var_filename_backtrace_frame_defined
struct pike_string *filename;
#endif /* var_filename_backtrace_frame_defined */

#ifdef var_lineno_backtrace_frame_defined
#line 1190 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT32 lineno;
#endif /* var_lineno_backtrace_frame_defined */
};

#undef internal_init_backtrace_frame_defined
#define internal_init_backtrace_frame_defined

#undef backtrace_frame_event_handler_defined
#define backtrace_frame_event_handler_defined
static void init_backtrace_frame_struct(void)
#line 1193 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    THIS->pc = NULL;
    THIS->lineno = -1;
    THIS->filename = NULL;
  }

  
#undef internal_exit_backtrace_frame_defined
#define internal_exit_backtrace_frame_defined

#undef backtrace_frame_event_handler_defined
#define backtrace_frame_event_handler_defined
static void exit_backtrace_frame_struct(void)
#line 1200 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    if (THIS->filename) {
      free_string(THIS->filename);
      THIS->filename = NULL;
    }
    THIS->pc = NULL;
    THIS->lineno = -1;
  }

  /*! @decl int(0..1) _is_type(string t)
   *! This object claims to be an array for backward compatibility.
   */
  #define f_backtrace_frame_cq__is_type_defined
ptrdiff_t f_backtrace_frame_cq__is_type_fun_num = 0;
void f_backtrace_frame_cq__is_type(INT32 args) {
#line 1212 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * t;
#line 1212 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 1212 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("_is_type",1,"string");
#line 1212 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(t=Pike_sp[0-1].u.string);
{
    INT_TYPE res = (t == findstring("array"));
    pop_n_elems(args);
    push_int(res);
  }

  }
#line 1219 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
static void fill_in_file_and_line()
  {
    struct pike_string *file = NULL;
    assert (THIS->lineno == -1);

    if (THIS->pc && THIS->prog) {
      file = low_get_line(THIS->pc, THIS->prog, &THIS->lineno);
      THIS->pc = NULL;
    }
    else if (THIS->fun.type == PIKE_T_FUNCTION)
      file = low_get_function_line (THIS->fun.u.object, THIS->fun.subtype,
				    &THIS->lineno);
    else if (THIS->prog)
      file = low_get_program_line (THIS->prog, &THIS->lineno);

    if (file) {
      if (!THIS->filename) THIS->filename = file;
      else free_string (file);
    }

    if (THIS->prog) {
      free_program(THIS->prog);
      THIS->prog = NULL;
    }
  }

  /*! @decl string _sprintf(int c, mapping|void opts)
   */
  #define f_backtrace_frame_cq__sprintf_defined
ptrdiff_t f_backtrace_frame_cq__sprintf_fun_num = 0;
void f_backtrace_frame_cq__sprintf(INT32 args) {
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE c;
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * opts;
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("_sprintf",args,1);
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("_sprintf",args,2);
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
c=Pike_sp[0-args].u.integer;
if (args > 1) {
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
opts=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else opts=0;
#line 1248 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    pop_n_elems(args);

    if (c != 'O') {
      push_undefined ();
      return;
    }

    push_text("backtrace_frame(");

    if (THIS->lineno == -1) fill_in_file_and_line();

    if (THIS->filename) {
      ref_push_string(THIS->filename);
      push_text(":");
      push_int(THIS->lineno);
      push_text(", ");
      f_add(4);
    } else {
      push_text("Unknown file, ");
    }
    if (THIS->fun.type == PIKE_T_FUNCTION) {
      if (THIS->fun.u.object->prog) {
	push_svalue(&THIS->fun);
	f_function_name(1);
	push_text("(), ");
	f_add(2);
      } else {
	free_svalue(&THIS->fun);
	THIS->fun.type = PIKE_T_INT;
	THIS->fun.u.integer = 0;
	THIS->fun.subtype = NUMBER_DESTRUCTED;
	push_text("destructed_function(), ");	
      }
    } else {
      push_text("destructed_function(), ");
    }

    if (THIS->args) {
      push_text("Args: ");
      push_int(THIS->args->size);
      f_add(2);
    } else {
      push_text("No args");
    }
    push_text(")");
    f_add(5);
  }

  }
/*! @decl int(3..) _sizeof()
   */
  #define f_backtrace_frame_cq__sizeof_defined
ptrdiff_t f_backtrace_frame_cq__sizeof_fun_num = 0;
void f_backtrace_frame_cq__sizeof(INT32 args) {
#line 1299 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    if (THIS->args) {
      push_int(THIS->args->size + 3);
    } else {
      push_int(3);
    }
  }

  }
/*! @decl mixed `[](int index, int|void end_or_none)
   *! The BacktraceFrame object can be indexed as an array.
   */
  #define f_backtrace_frame_cq__backtick_5B_5D_defined
ptrdiff_t f_backtrace_frame_cq__backtick_5B_5D_fun_num = 0;
void f_backtrace_frame_cq__backtick_5B_5D(INT32 args) {
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE index;
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * end_or_none;
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("`[]",args,1);
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("`[]",args,2);
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`[]",1,"int");
index=Pike_sp[0-args].u.integer;
if (args > 1) {
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
end_or_none=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else end_or_none=0;
#line 1312 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    INT_TYPE end = index;
    INT32 numargs = 0;
    INT32 i;

    if (THIS->args) {
      numargs = THIS->args->size;
    }

    numargs += 3;

    if (!end_or_none) {
      if (index < 0) {
	index_error("pike_frame->`[]", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Indexing with negative index (%"PRINTPIKEINT"d)\n", index);
      } else if (index >= numargs) {
	index_error("pike_frame->`[]", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Indexing with too large index (%"PRINTPIKEINT"d)\n", index);
      }
    } else {
      if (end_or_none->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("`[]",2,"int|void");
      }
      end = end_or_none->u.integer;
    }

    pop_n_elems(args);

    if (end_or_none) {
      if ((end < 0) || (end < index) || (index >= numargs)) {
	f_aggregate(0);
	return;
      }

      if (end >= numargs) {
	end = numargs-1;
      }
    }

    for (i = index; i <= end; i++) {
      switch(i) {
      case 0:	/* Filename */
	if (THIS->lineno == -1) fill_in_file_and_line();
	if (THIS->filename) {
	  ref_push_string(THIS->filename);
	} else {
	  push_int(0);
	}
	break;
      case 1:	/* Linenumber */
	if (THIS->lineno == -1) fill_in_file_and_line();
	push_int(THIS->lineno);
	break;
      case 2:	/* Function */
        push_svalue(&THIS->fun);
        break;
      default:	/* Arguments */
        {
	  if ((i > 2) && (THIS->args) && (i-3 < THIS->args->size)) {
	    push_svalue(THIS->args->item + (i - 3));
	    break;
	  }
	  bad_arg_error("backtrace_frame->`[]", Pike_sp-args, args, 1,
			"int(0..)", Pike_sp-args,
			"Bad argument 1 to backtrace_frame->`[](): "
			"Expected int(0..%d)\n",
			numargs + 2);
	}
        /* NOT_REACHED */
        break;
      }
    }
    if (end_or_none) {
      f_aggregate(1 + end - index);
    }
  }

  }
/*! @decl mixed `[]=(int index, mixed value)
   */
  #define f_backtrace_frame_cq__backtick_5B_5D_eq_defined
ptrdiff_t f_backtrace_frame_cq__backtick_5B_5D_eq_fun_num = 0;
void f_backtrace_frame_cq__backtick_5B_5D_eq(INT32 args) {
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE index;
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * value;
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("`[]=",args,2);
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("`[]=",1,"int");
index=Pike_sp[0-2].u.integer;
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
value=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
    INT32 numargs = 0;

    if (THIS->args) {
      numargs = THIS->args->size;
    }

    numargs += 3;

    if ((index < -numargs) || (index >= numargs)) {
	index_error("pike_frame->`[]=", Pike_sp-args, args, NULL, Pike_sp-args,
		    "Index %"PRINTPIKEINT"d is out of array range 0..%d,\n",
		    index, numargs-1);
    } else if (index < 0) {
      index += numargs;
    }

    if (args > 2) {
      pop_n_elems(args - 2);
      args = 2;
    }

    switch(index) {
    case 0:	/* Filename */
      if (THIS->lineno == -1) fill_in_file_and_line();
      if (value->type != PIKE_T_STRING) {
	if ((value->type != PIKE_T_INT) ||
	    (value->u.integer)) {
	  SIMPLE_BAD_ARG_ERROR("backtrace_frame->`[]=", 2,
			       "string|int(0..0)");
	}
	if (THIS->filename) {
	  free_string(THIS->filename);
	  THIS->filename = NULL;
	}
      } else {
	if (THIS->filename) {
	  free_string(THIS->filename);
	  THIS->filename = NULL;
	}
	copy_shared_string(THIS->filename, value->u.string);
      }
      break;

    case 1:	/* Linenumber */
      if (THIS->lineno == -1) fill_in_file_and_line();
      if (value->type != PIKE_T_INT) {
	SIMPLE_BAD_ARG_ERROR("backtrace_frame->`[]=", 2, "int(1..)");
      }
      THIS->lineno = value->u.integer;
      break;

    case 2:	/* Function */
      if (THIS->lineno == -1) fill_in_file_and_line();
      assign_svalue(&THIS->fun, value);
      break;
    default:	/* Arguments */
      assign_svalue(THIS->args->item + index - 3, value);
      break;
    }
    stack_swap();
    pop_stack();
  }

}

#ifdef backtrace_frame_event_handler_defined
static void backtrace_frame_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_backtrace_frame_defined
  case PROG_EVENT_INIT: init_backtrace_frame_struct(); break;

#endif /* internal_init_backtrace_frame_defined */

#ifdef internal_exit_backtrace_frame_defined
  case PROG_EVENT_EXIT: exit_backtrace_frame_struct(); break;

#endif /* internal_exit_backtrace_frame_defined */
  default: break; 
  }
}

#endif /* backtrace_frame_event_handler_defined */
#line 1456 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
;

/*! @endclass
 */

/*! @endmodule
 */

void low_backtrace(struct Pike_interpreter *i)
{
  struct svalue *stack_top = i->stack_pointer;
  struct pike_frame *f, *of = 0;
  int size = 0;
  struct array *res = NULL;

  for (f = i->frame_pointer; f; f = f->next) {
    size++;
  }

  res = allocate_array_no_init(size, 0);
  push_array(res);

  for (f = i->frame_pointer; f && size; f = (of = f)->next) {
    struct object *o = low_clone(backtrace_frame_program);
    struct backtrace_frame_struct *bf;
    struct identifier *function = NULL;

    call_c_initializers(o);

    size--;

    res->item[size].u.object = o;
    res->item[size].type = PIKE_T_OBJECT;
    res->item[size].subtype = 0;

    bf = OBJ2_BACKTRACE_FRAME(o);

    if ((bf->prog = f->context.prog)) {
      add_ref(bf->prog);
      bf->pc = f->pc;
    }

    if ((bf->fun.u.object = f->current_object) &&
	(bf->fun.u.object->prog)) {
      add_ref(bf->fun.u.object);
      bf->fun.subtype = f->fun;
      bf->fun.type = PIKE_T_FUNCTION;
      function = ID_FROM_INT(f->current_object->prog, f->fun);
    } else {
      bf->fun.u.integer = 0;
      bf->fun.subtype = NUMBER_DESTRUCTED;
      bf->fun.type = PIKE_T_INT;
    }

    if (f->locals) {
      INT32 numargs = DO_NOT_WARN((INT32) MINIMUM(f->num_args,
						  stack_top - f->locals));
      INT32 varargs = 0;

      if(of) {
	/* f->num_args can be too large, so this is necessary for some
	 * reason. I don't know why. /mast */
	numargs = DO_NOT_WARN((INT32)MINIMUM(f->num_args,of->locals - f->locals));
      }

      numargs = MAXIMUM(numargs, 0);

      /* Handle varargs... */
      if (function && (function->identifier_flags & IDENTIFIER_VARARGS) &&
	  (f->locals + numargs < stack_top) &&
	  (f->locals[numargs].type == T_ARRAY)) {
	varargs = f->locals[numargs].u.array->size;
      }

      if (numargs + varargs) {
	bf->args = allocate_array_no_init(numargs + varargs, 0);
	bf->args->type_field =
	  assign_svalues_no_free(bf->args->item, f->locals, numargs, BIT_MIXED);
	if (varargs) {
	  bf->args->type_field |=
	    assign_svalues_no_free(bf->args->item + numargs,
				   f->locals[numargs].u.array->item,
				   varargs, BIT_MIXED);
	}
      }
    }
  }
  res->type_field = BIT_OBJECT;
  /* NOTE: res has already been pushed on the stack. */
}

/*! @decl array(Pike.BacktraceFrame) backtrace()
 *!
 *!   FIXME: This documentation is not up to date!
 *!
 *!   Get a description of the current call stack.
 *!
 *!   The description is returned as an array with one entry for each call
 *!   frame on the stack.
 *!
 *!   Each entry has this format:
 *!   @array
 *!     @elem string file
 *!       A string with the filename if known, else zero.
 *!     @elem int line
 *!       An integer containing the linenumber if known, else zero.
 *!     @elem function fun
 *!       The function that was called at this level.
 *!     @elem mixed|void ... args
 *!       The arguments that the function was called with.
 *!   @endarray
 *!
 *!   The current call frame will be last in the array.
 *!
 *! @note
 *!   Please note that the frame order may be reversed in a later version
 *!   (than 7.1) of Pike to accommodate for deferred backtraces.
 *!
 *!   Note that the arguments reported in the backtrace are the current
 *!   values of the variables, and not the ones that were at call-time.
 *!   This can be used to hide sensitive information from backtraces
 *!   (eg passwords).
 *!
 *! @seealso
 *!   @[catch()], @[throw()]
 */
PMOD_EXPORT
#define f_backtrace_defined
void f_backtrace(INT32 args) {
#line 1583 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("backtrace",args,0);
#line 1586 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  low_backtrace(& Pike_interpreter);
}

}
#line 1590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
#define INITIAL_BUF_LEN 4096

/*! @module String
 */

/*! @class Buffer
 *!    A buffer, used for building strings. It's
 *!    conceptually similar to a string, but you can only @[add]
 *!    strings to it, and you can only @[get] the value from it once.
 *!
 *!    There is a reason for those seemingly rather odd limitations,
 *!    it makes it possible to do some optimizations that really speed
 *!    things up.
 *!
 *!    You do not need to use this class unless you add very many
 *!    strings together, or very large strings.
 *!
 *! @example
 *!    For the fastest possible operation, write your code like this:
 *!
 *! @code
 *! String.Buffer b = String.Buffer( );
 *!
 *! function add = b->add;
 *!
 *! .. call add several times in code ...
 *!
 *! string result = b->get(); // also clears the buffer
 *! @endcode
 */

#undef class_Buffer_defined
#define class_Buffer_defined
struct program *Buffer_program=0;
int Buffer_program_fun_num=-1;

#undef var_str_Buffer_defined
#define var_str_Buffer_defined

#undef var_initial_Buffer_defined
#define var_initial_Buffer_defined

#undef THIS
#define THIS ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BUFFER
#define THIS_BUFFER ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BUFFER
#define OBJ2_BUFFER(o) ((struct Buffer_struct *)(o->storage+Buffer_storage_offset))

#undef GET_BUFFER_STORAGE
#define GET_BUFFER_STORAGE ((struct Buffer_struct *)(o->storage+Buffer_storage_offset)
static ptrdiff_t Buffer_storage_offset;
struct Buffer_struct {

#ifdef var_str_Buffer_defined
#line 1622 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct string_builder str;
#endif /* var_str_Buffer_defined */

#ifdef var_initial_Buffer_defined
#line 1623 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
int initial;
#endif /* var_initial_Buffer_defined */
};
#line 1625 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
void f_Buffer_get_copy( INT32 args );
  void f_Buffer_get( INT32 args );
  void f_Buffer_add( INT32 args );


  /*! @decl void create(int initial_size)
   *!
   *!   Initializes a new buffer.
   *!
   *!   If no @[initial_size] is specified, 256 is used. If you
   *!   know approximately how big the buffer will be, you can optimize
   *!   the operation of @[add()] (slightly) by passing the size to this
   *!   function.
   */
  #define f_Buffer_create_defined
ptrdiff_t f_Buffer_create_fun_num = 0;
void f_Buffer_create(INT32 args) {
#line 1639 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * size;
#line 1639 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
if (args > 0) {
#line 1639 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
size=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else size=0;
#line 1640 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    if( args )
      str->initial = MAXIMUM( size->u.integer, 512 );
    else
    {
      str->initial = 256;
      push_int(0);
    }
  }

  }
/*! @decl string _sprintf( int flag, mapping flags )
   *! It is possible to @[sprintf] a String.Buffer object
   *! as @tt{%s@} just as if it was a string.
   */
  #define f_Buffer_cq__sprintf_defined
ptrdiff_t f_Buffer_cq__sprintf_fun_num = 0;
void f_Buffer_cq__sprintf(INT32 args) {
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE flag;
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct mapping * flags;
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
flag=Pike_sp[0-2].u.integer;
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
{
    switch( flag )
    {
      case 'O':
	{
	  struct pike_string *res;
	  struct Buffer_struct *str = THIS;
	  push_text( "Buffer(%d /* %d */)" );
	  if( str->str.s )
	  {
	    push_int(str->str.s->len);
	    push_int(str->str.malloced);
	  }
	  else
	  {
	    push_int( 0 );
	    push_int( 0 );
	  }
	  f_sprintf( 3 );
	  dmalloc_touch_svalue(Pike_sp-1);
	  res = Pike_sp[-1].u.string;
	  Pike_sp--;
	  do { struct pike_string * ret_=(res); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 1679 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

      case 's':
	{
	  pop_n_elems( args );
	  if( Pike_fp->current_object->refs != 1 )
	    f_Buffer_get_copy( 0 );
	  else
	    f_Buffer_get( 0 );
	}
	return;
	
      case 't':
	do { struct pike_string * ret_=(make_shared_binary_string("Buffer",6)); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 1693 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
    pop_n_elems( args );
    push_int( 0 );
    Pike_sp[-1].subtype = 1;
  }

  }
/*! @decl mixed cast( string type )
   *! It is possible to cast a String.Buffer object to
   *! a @expr{string@} and an @expr{int@}.
   */
  #define f_Buffer_cast_defined
ptrdiff_t f_Buffer_cast_fun_num = 0;
void f_Buffer_cast(INT32 args) {
#line 1703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * type;
#line 1703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 1703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 1703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(type=Pike_sp[0-1].u.string);
{
    struct pike_string *string_t;
    struct pike_string *int_t;
    MAKE_CONST_STRING( string_t, "string" );
    MAKE_CONST_STRING( int_t, "int" );

    if( type == string_t )
    {
      pop_n_elems( args );
      if( Pike_fp->current_object->refs != 1 )
	f_Buffer_get_copy( 0 );
      else
	f_Buffer_get( 0 );
      return;
    }

    if( type == int_t )
    {
      struct Buffer_struct *str = THIS;
      pop_stack();
      if( Pike_fp->current_object->refs != 1 )
	f_Buffer_get_copy( 0 );
      else
	f_Buffer_get( 0 );
      o_cast_to_int( );
      return;
    }
    Pike_error("Cannot cast to %s\n", type->str );
  }
  
  }
/*! @decl String.Buffer `+( string what )
   */
  #define f_Buffer_cq__backtick_add_defined
ptrdiff_t f_Buffer_cq__backtick_add_fun_num = 0;
void f_Buffer_cq__backtick_add(INT32 args) {
#line 1736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * what;
#line 1736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 1736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`+",1,"string");
#line 1736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(what=Pike_sp[0-1].u.string);
{
    struct Buffer_struct *str = THIS, *str2;
    struct object *res = fast_clone_object( Buffer_program );
    str2 = OBJ2_BUFFER( res );
    str2->initial = str->initial;
    if( str->str.s )
      init_string_builder_copy (&str2->str, &str->str);
    apply( res, "add", 1 );
    do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 1746 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl String.Buffer `+=( string what )
   */
  #define f_Buffer_cq__backtick_add_eq_defined
ptrdiff_t f_Buffer_cq__backtick_add_eq_fun_num = 0;
void f_Buffer_cq__backtick_add_eq(INT32 args) {
#line 1750 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * what;
#line 1750 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 1750 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`+=",1,"string");
#line 1750 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(what=Pike_sp[0-1].u.string);
{
    f_Buffer_add( 1 );
    do { struct object * ret_=(Pike_fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 1754 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl int add(string ... data)
   *!
   *!   Adds @[data] to the buffer. Returns the size of the buffer.
   *!
   */
  #define f_Buffer_add_defined
ptrdiff_t f_Buffer_add_fun_num = 0;
void f_Buffer_add(INT32 args) {
#line 1761 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * arg1;
#line 1761 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 1761 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0+argcnt-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("add",1+argcnt,"string");
#line 1761 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  } while (++argcnt < args-0);
  arg1=Pike_sp+0-args;
} else arg1=0;
#line 1762 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    int init_from_arg0 = 0, j;

    if (!str->str.s && args) {
      ptrdiff_t sum = 0;
      int shift = 0;
      for (j=0; j < args; j++) {
	struct pike_string *a = Pike_sp[j-args].u.string;
	sum += a->len;
	shift |= a->size_shift;
      }
      if (sum < str->initial) {
	sum = str->initial * 2;
      }
      shift = shift & ~(shift >> 1);

      if (shift == Pike_sp[-args].u.string->size_shift &&
	  init_string_builder_with_string (&str->str, Pike_sp[-args].u.string)) {
	Pike_sp[-args].type = T_INT;
	if (sum > str->str.s->len)
	  string_build_mkspace (&str->str, sum - str->str.s->len, shift);
	init_from_arg0 = 1;
      }
      else
	init_string_builder_alloc(&str->str, sum, shift);

      /* We know it will be a string that really is this wide. */
      str->str.known_shift = shift;
    }

    for( j = init_from_arg0; j<args; j++ )
    {
      struct pike_string *a = Pike_sp[j-args].u.string;
      string_builder_shared_strcat( &str->str, a );
    }

    if (str->str.s) {
      do { INT_TYPE ret_=(str->str.s->len); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1801 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
} else {
      do { INT_TYPE ret_=(0); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 1803 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
  }

  }
/*! @decl void putchar(int c)
   *! Appends the character @[c] at the end of the string.
   */
  #define f_Buffer_putchar_defined
ptrdiff_t f_Buffer_putchar_fun_num = 0;
void f_Buffer_putchar(INT32 args) {
#line 1809 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE c;
#line 1809 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("putchar",args,1);
#line 1809 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("putchar",1,"int");
c=Pike_sp[0-1].u.integer;
#line 1809 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    if(!str->str.s)
      init_string_builder_alloc(&str->str, str->initial, 0);
    string_builder_putchar(&str->str, c);
  }

  }
/*! @decl string get_copy()
   *!
   *!   Get the data from the buffer. Significantly slower than @[get],
   *!   but does not clear the buffer.
   */
  #define f_Buffer_get_copy_defined
ptrdiff_t f_Buffer_get_copy_fun_num = 0;
void f_Buffer_get_copy(INT32 args) {
#line 1821 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get_copy",args,0);
{
    struct pike_string *str = THIS->str.s;
    if( str )
    {
      ptrdiff_t len = str->len;
      if( len > 0 )
      {
	char *d = (char *)str->str;
	switch( str->size_shift )
	{
	  case 0:
	    do { struct pike_string * ret_=(make_shared_binary_string0((p_wchar0 *)d,len));  push_string(ret_); return; }while(0);
#line 1834 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
break;
	  case 1:
	    do { struct pike_string * ret_=(make_shared_binary_string1((p_wchar1 *)d,len));  push_string(ret_); return; }while(0);
#line 1837 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
break;
	  case 2:
	    do { struct pike_string * ret_=(make_shared_binary_string2((p_wchar2 *)d,len));  push_string(ret_); return; }while(0);
#line 1840 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
break;
	}
      }
    }
    push_text("");
    return;
  }

  }
/*! @decl string get()
   *!
   *!   Get the data from the buffer.
   *!
   *! @note
   *!   This will clear the data in the buffer
   */
  #define f_Buffer_get_defined
ptrdiff_t f_Buffer_get_fun_num = 0;
void f_Buffer_get(INT32 args) {
#line 1855 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
{
    struct Buffer_struct *str = THIS;
    if( str->str.s )
    {
      struct pike_string *s = finish_string_builder( &str->str );
      str->str.malloced = 0;
      str->str.s = 0;
      do { struct pike_string * ret_=(s);  push_string(ret_); return; }while(0);
#line 1864 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}
    pop_n_elems(args);
    push_text("");
    return;
  }

  }
/*! @decl int _sizeof()
   *!
   *!   Returns the size of the buffer.
   */
  #define f_Buffer_cq__sizeof_defined
ptrdiff_t f_Buffer_cq__sizeof_fun_num = 0;
void f_Buffer_cq__sizeof(INT32 args) {
#line 1874 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
{
    struct Buffer_struct *str = THIS;
    do { INT_TYPE ret_=(str->str.s ? str->str.s->len : 0);  push_int(ret_); return; }while(0);
#line 1878 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }

#undef internal_init_Buffer_defined
#define internal_init_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void init_Buffer_struct(void)
#line 1881 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      MEMSET( str, 0, sizeof( *str ) );
    }

  
#undef internal_exit_Buffer_defined
#define internal_exit_Buffer_defined

#undef Buffer_event_handler_defined
#define Buffer_event_handler_defined
static void exit_Buffer_struct(void)
#line 1887 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      if( str->str.s )
	free_string_builder( &str->str );
    }

#ifdef Buffer_event_handler_defined
static void Buffer_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Buffer_defined
  case PROG_EVENT_INIT: init_Buffer_struct(); break;

#endif /* internal_init_Buffer_defined */

#ifdef internal_exit_Buffer_defined
  case PROG_EVENT_EXIT: exit_Buffer_struct(); break;

#endif /* internal_exit_Buffer_defined */
  default: break; 
  }
}

#endif /* Buffer_event_handler_defined */
/*! @endclass
 */

/*! @class Replace
 */

#undef class_multi_string_replace_defined
#define class_multi_string_replace_defined
struct program *multi_string_replace_program=0;
int multi_string_replace_program_fun_num=-1;

#undef var_v_multi_string_replace_defined
#define var_v_multi_string_replace_defined

#undef var_v_sz_multi_string_replace_defined
#define var_v_sz_multi_string_replace_defined

#undef var_sz_multi_string_replace_defined
#define var_sz_multi_string_replace_defined

#undef var_set_start_multi_string_replace_defined
#define var_set_start_multi_string_replace_defined

#undef var_set_end_multi_string_replace_defined
#define var_set_end_multi_string_replace_defined

#undef THIS
#define THIS ((struct multi_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MULTI_STRING_REPLACE
#define THIS_MULTI_STRING_REPLACE ((struct multi_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MULTI_STRING_REPLACE
#define OBJ2_MULTI_STRING_REPLACE(o) ((struct multi_string_replace_struct *)(o->storage+multi_string_replace_storage_offset))

#undef GET_MULTI_STRING_REPLACE_STORAGE
#define GET_MULTI_STRING_REPLACE_STORAGE ((struct multi_string_replace_struct *)(o->storage+multi_string_replace_storage_offset)
static ptrdiff_t multi_string_replace_storage_offset;
struct multi_string_replace_struct {

#ifdef var_v_multi_string_replace_defined
#line 1901 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct tupel
  {
    int prefix;
    struct pike_string *ind;
    struct pike_string *val;
  } *v;
#endif /* var_v_multi_string_replace_defined */

#ifdef var_v_sz_multi_string_replace_defined
#line 1907 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
size_t v_sz;
#endif /* var_v_sz_multi_string_replace_defined */

#ifdef var_sz_multi_string_replace_defined
#line 1908 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
size_t sz;
#endif /* var_sz_multi_string_replace_defined */

#ifdef var_set_start_multi_string_replace_defined
#line 1909 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT32 set_start[256];
#endif /* var_set_start_multi_string_replace_defined */

#ifdef var_set_end_multi_string_replace_defined
#line 1910 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT32 set_end[256];
#endif /* var_set_end_multi_string_replace_defined */
};
#line 1912 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
static int replace_sortfun(struct tupel *a,struct tupel *b)
  {
    return DO_NOT_WARN((int)my_quick_strcmp(a->ind, b->ind));
  }

  /*! @decl void create(array(string)|void from, array(string)|void to)
   */
  #define f_multi_string_replace_create_defined
ptrdiff_t f_multi_string_replace_create_fun_num = 0;
void f_multi_string_replace_create(INT32 args) {
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * from_;
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * to_;
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
if (args > 0) {
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
from_=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else from_=0;
if (args > 1) {
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
to_=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else to_=0;
#line 1920 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    int i;
    struct array *from;
    struct array *to;
    if (!args) {
      push_int(0);
      return;
    }
    if (!from_ || !to_) {
      Pike_error("Bad number of arguments to create().\n");
    }
    from = from_->u.array;
    to = to_->u.array;
    if (from->size != to->size) {
      Pike_error("Replace must have equal-sized from and to arrays.\n");
    }
    for (i = 0; i < (int)from->size; i++) {
      if (from->item[i].type != PIKE_T_STRING) {
	Pike_error("Replace: from array is not an array(string).\n");
      }
      if (to->item[i].type != PIKE_T_STRING) {
	Pike_error("Replace: to array is not an array(string).\n");
      }
    }
    if (THIS->v) {
      for (i = 0; i < (int)THIS->v_sz; i++) {
	if (!THIS->v[i].ind) break;
	free_string(THIS->v[i].ind);
	THIS->v[i].ind = NULL;
	free_string(THIS->v[i].val);
	THIS->v[i].val = NULL;	
      }
    }
    if (THIS->v && (THIS->v_sz < (size_t)from->size)) {      
      free(THIS->v);
      THIS->v = NULL;
      THIS->v_sz = 0;
    }
    if (!THIS->v) {
      THIS->v = (struct tupel *)xalloc(sizeof(struct tupel) * from->size);
      THIS->v_sz = from->size;
    }
    for (i = 0; i < (int)from->size; i++) {
      copy_shared_string(THIS->v[i].ind, from->item[i].u.string);
      copy_shared_string(THIS->v[i].val, to->item[i].u.string);
      THIS->v[i].prefix = -2;	/* Uninitialized */
    }
    THIS->sz = from->size;
    fsort((char *)THIS->v, from->size, sizeof(struct tupel),
	  (fsortfun)replace_sortfun);

    MEMSET(THIS->set_start, 0, sizeof(INT32)*256);
    MEMSET(THIS->set_end, 0, sizeof(INT32)*256);

    for (i = 0; i < (int)from->size; i++) {
      INT32 x = index_shared_string(THIS->v[from->size-1-i].ind, 0);
      if ((x >= 0) && (x < 256))
	THIS->set_start[x] = from->size-1-i;
      x = index_shared_string(THIS->v[i].ind, 0);
      if ((x >= 0) && (x < 256))
	THIS->set_end[x] = i+1;
    }
    pop_n_elems(args);
    push_int(0);
  }

  }
#line 1986 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
static int find_longest_prefix(char *str,
				 ptrdiff_t len,
				 int size_shift,
				 struct tupel *v,
				 INT32 a,
				 INT32 b)
  {
    INT32 c,match=-1;
    ptrdiff_t tmp;

    while(a<b)
    {
      c=(a+b)/2;
      
      tmp=generic_quick_binary_strcmp(v[c].ind->str,
				      v[c].ind->len,
				      v[c].ind->size_shift,
				      str,
				      MINIMUM(len,v[c].ind->len),
				      size_shift);
      if(tmp<0)
      {
	INT32 match2=find_longest_prefix(str,
					 len,
					 size_shift,
					 v,
					 c+1,
					 b);
	if(match2!=-1) return match2;

	while(1)
	{
	  if(v[c].prefix==-2)
	  {
	    v[c].prefix=find_longest_prefix(v[c].ind->str,
					    v[c].ind->len,
					    v[c].ind->size_shift,
					    v,
					    0 /* can this be optimized? */,
					    c);
	  }
	  c=v[c].prefix;
	  if(c<a || c<match) return match;

	  if(!generic_quick_binary_strcmp(v[c].ind->str,
					  v[c].ind->len,
					  v[c].ind->size_shift,
					  str,
					  MINIMUM(len,v[c].ind->len),
					  size_shift))
	    return c;
	}
      }
      else if(tmp>0)
      {
	b=c;
      }
      else
      {
	a=c+1; /* There might still be a better match... */
	match=c;
      }
    }
    return match;
  }

  /*! @decl string `()(string str)
   */
  #define f_multi_string_replace_cq__backtick_28_29_defined
ptrdiff_t f_multi_string_replace_cq__backtick_28_29_fun_num = 0;
void f_multi_string_replace_cq__backtick_28_29(INT32 args) {
#line 2054 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * str;
#line 2054 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`()",args,1);
#line 2054 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`()",1,"string");
#line 2054 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
{
    struct string_builder ret;
    ptrdiff_t length = str->len;
    ptrdiff_t s;
    int *set_start = THIS->set_start;
    int *set_end = THIS->set_end;
    struct tupel *v = THIS->v;
    int num = THIS->sz;

    if (!num) {
      add_ref(str);
      do { struct pike_string * ret_=(str); pop_stack(); push_string(ret_); return; }while(0);
#line 2067 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

    init_string_builder(&ret,str->size_shift);

    for(s=0;length > 0;)
    {
      INT32 a,b;
      ptrdiff_t ch;

      ch = index_shared_string(str, s);
      if((ch >= 0) && (ch < 256))
	b = set_end[ch];
      else
	b = num;

      if(b)
      {
	if((ch >= 0) && (ch < 256))
	  a = set_start[ch];
	else
	  a = 0;

	a = find_longest_prefix(str->str+(s << str->size_shift),
				length,
				str->size_shift,
				v, a, b);

	if(a!=-1)
	{
	  ch = v[a].ind->len;
	  if(!ch) ch=1;
	  s += ch;
	  length -= ch;
	  string_builder_shared_strcat(&ret, v[a].val);
	  continue;
	}
      }
      string_builder_putchar(&ret,
			     DO_NOT_WARN((INT32)ch));
      s++;
      length--;
    }

    do { struct pike_string * ret_=(finish_string_builder(&ret)); pop_stack(); push_string(ret_); return; }while(0);
#line 2111 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl array(string) _encode()
   */
  #define f_multi_string_replace_cq__encode_defined
ptrdiff_t f_multi_string_replace_cq__encode_fun_num = 0;
void f_multi_string_replace_cq__encode(INT32 args) {
#line 2115 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_encode",args,0);
{
    size_t i;
    for (i=0; i < THIS->sz; i++) {
      ref_push_string(THIS->v[i].ind);
    }
    f_aggregate(DO_NOT_WARN((INT32)THIS->sz));
    for (i=0; i < THIS->sz; i++) {
      ref_push_string(THIS->v[i].val);
    }
    f_aggregate(DO_NOT_WARN((INT32)THIS->sz));
    f_aggregate(2);
  }

  }
/*! @decl void _decode(array(array(string)) encoded)
   */
  #define f_multi_string_replace_cq__decode_defined
ptrdiff_t f_multi_string_replace_cq__decode_fun_num = 0;
void f_multi_string_replace_cq__decode(INT32 args) {
#line 2131 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * encoded;
#line 2131 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_decode",args,1);
#line 2131 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("_decode",1,"array(array(string))");
#line 2131 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(encoded=Pike_sp[0-1].u.array);
{
    INT32 i;

    for (i=0; i < encoded->size; i++) {
      push_svalue(encoded->item + i);
      stack_swap();
    }
    pop_stack();

    f_multi_string_replace_create(i);
  }

  }

#undef internal_init_multi_string_replace_defined
#define internal_init_multi_string_replace_defined

#undef multi_string_replace_event_handler_defined
#define multi_string_replace_event_handler_defined
static void init_multi_string_replace_struct(void)
#line 2145 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    THIS->v = NULL;
    THIS->v_sz = 0;
    THIS->sz = 0;
  }

  
#undef internal_exit_multi_string_replace_defined
#define internal_exit_multi_string_replace_defined

#undef multi_string_replace_event_handler_defined
#define multi_string_replace_event_handler_defined
static void exit_multi_string_replace_struct(void)
#line 2152 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    if (THIS->v) {
      int i;
      for (i = 0; i < (int)THIS->v_sz; i++) {
	if (!THIS->v[i].ind) break;
	free_string(THIS->v[i].ind);
	THIS->v[i].ind = NULL;
	free_string(THIS->v[i].val);
	THIS->v[i].val = NULL;	
      }
      free(THIS->v);
    }
    THIS->v = NULL;
    THIS->v_sz = 0;
    THIS->sz = 0;
  }

#ifdef multi_string_replace_event_handler_defined
static void multi_string_replace_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_multi_string_replace_defined
  case PROG_EVENT_INIT: init_multi_string_replace_struct(); break;

#endif /* internal_init_multi_string_replace_defined */

#ifdef internal_exit_multi_string_replace_defined
  case PROG_EVENT_EXIT: exit_multi_string_replace_struct(); break;

#endif /* internal_exit_multi_string_replace_defined */
  default: break; 
  }
}

#endif /* multi_string_replace_event_handler_defined */
/*! @endclass
 */

/*! @class SingleReplace
 */

#undef class_single_string_replace_defined
#define class_single_string_replace_defined
struct program *single_string_replace_program=0;
int single_string_replace_program_fun_num=-1;

#undef var_mojt_single_string_replace_defined
#define var_mojt_single_string_replace_defined

#undef var_del_single_string_replace_defined
#define var_del_single_string_replace_defined

#undef var_to_single_string_replace_defined
#define var_to_single_string_replace_defined

#undef THIS
#define THIS ((struct single_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SINGLE_STRING_REPLACE
#define THIS_SINGLE_STRING_REPLACE ((struct single_string_replace_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SINGLE_STRING_REPLACE
#define OBJ2_SINGLE_STRING_REPLACE(o) ((struct single_string_replace_struct *)(o->storage+single_string_replace_storage_offset))

#undef GET_SINGLE_STRING_REPLACE_STORAGE
#define GET_SINGLE_STRING_REPLACE_STORAGE ((struct single_string_replace_struct *)(o->storage+single_string_replace_storage_offset)
static ptrdiff_t single_string_replace_storage_offset;
struct single_string_replace_struct {

#ifdef var_mojt_single_string_replace_defined
#line 2177 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
SearchMojt mojt;
#endif /* var_mojt_single_string_replace_defined */

#ifdef var_del_single_string_replace_defined
#line 2178 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string *del;
#endif /* var_del_single_string_replace_defined */

#ifdef var_to_single_string_replace_defined
#line 2179 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string *to;
#endif /* var_to_single_string_replace_defined */
};

#undef internal_init_single_string_replace_defined
#define internal_init_single_string_replace_defined

#undef single_string_replace_event_handler_defined
#define single_string_replace_event_handler_defined
static void init_single_string_replace_struct(void)
#line 2182 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    THIS->mojt.vtab = NULL;
    THIS->mojt.data = NULL;
    THIS->del = NULL;
    THIS->to = NULL;
  }

  
#undef internal_exit_single_string_replace_defined
#define internal_exit_single_string_replace_defined

#undef single_string_replace_event_handler_defined
#define single_string_replace_event_handler_defined
static void exit_single_string_replace_struct(void)
#line 2190 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    if (THIS->mojt.vtab) {
      THIS->mojt.vtab->freeme(THIS->mojt.data);
      THIS->mojt.vtab = NULL;
      THIS->mojt.data = NULL;
    }
    if (THIS->del) {
      free_string(THIS->del);
      THIS->del = NULL;
    }
    if (THIS->to) {
      free_string(THIS->to);
      THIS->to = NULL;
    }
  }

  /*! @decl void create(string|void del, string|void to)
   */
  #define f_single_string_replace_create_defined
ptrdiff_t f_single_string_replace_create_fun_num = 0;
void f_single_string_replace_create(INT32 args) {
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * del_;
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * to_;
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
if (args > 0) {
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
del_=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else del_=0;
if (args > 1) {
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
to_=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else to_=0;
#line 2209 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    struct pike_string *del;
    struct pike_string *to;

    /* Clean up... */
    exit_single_string_replace_struct();
    
    if (!del_) return;

    if (!to_) {
      SIMPLE_BAD_ARG_ERROR("String.SingleReplace->create", 2, "string");
    }

    if (del_->u.string == to_->u.string) {
      /* No-op... */
      return;
    }

    copy_shared_string(THIS->del, del = del_->u.string);
    copy_shared_string(THIS->to, to = to_->u.string);

    if (del->len) {
      THIS->mojt = simple_compile_memsearcher(del);
    }
  }

  }
#line 2235 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
/*** replace function ***/
  typedef char *(* replace_searchfunc)(void *,void *,size_t);

  /*! @decl string `()(string str)
   */
  #define f_single_string_replace_cq__backtick_28_29_defined
ptrdiff_t f_single_string_replace_cq__backtick_28_29_fun_num = 0;
void f_single_string_replace_cq__backtick_28_29(INT32 args) {
#line 2240 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * str;
#line 2240 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`()",args,1);
#line 2240 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`()",1,"string");
#line 2240 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
{
    int shift;
    struct pike_string *del = THIS->del;
    struct pike_string *to = THIS->to;
    struct pike_string *ret = NULL;

    if (!str->len || !del || !to) {
      /* The result is already on the stack in the correct place... */
      return;
    }

    shift = MAXIMUM(str->size_shift, to->size_shift);

    if (!del->len) {
      int e, pos;
      ret = begin_wide_shared_string(str->len + to->len * (str->len-1),
				     shift);
      low_set_index(ret, 0, index_shared_string(str, 0));
      for(pos=e=1;e<str->len;e++)
      {
	pike_string_cpy(MKPCHARP_STR_OFF(ret,pos), to);
	pos+=to->len;
	low_set_index(ret,pos++,index_shared_string(str,e));
      }
    } else {
      char *s, *end, *tmp;
      replace_searchfunc f = (replace_searchfunc)0;
      void *mojt_data = THIS->mojt.data;
      PCHARP r;

      end = str->str+(str->len<<str->size_shift);

      switch(str->size_shift)
      {
      case 0: f = (replace_searchfunc)THIS->mojt.vtab->func0; break;
      case 1: f = (replace_searchfunc)THIS->mojt.vtab->func1; break;
      case 2: f = (replace_searchfunc)THIS->mojt.vtab->func2; break;
#ifdef PIKE_DEBUG
      default: Pike_fatal("Illegal shift.\n");
#endif
      }

      if(del->len == to->len)
      {
	ret = begin_wide_shared_string(str->len, shift);
      } else {
	INT32 delimiters = 0;

	s = str->str;

	while((s = f(mojt_data, s, (end-s)>>str->size_shift)))
	{
	  delimiters++;
	  s += del->len << str->size_shift;
	}

	if (!delimiters) {
	  /* The result is already on the stack in the correct place... */
	  return;
	}

	ret = begin_wide_shared_string(str->len +
				       (to->len-del->len)*delimiters, shift);
      }

      s = str->str;
      r = MKPCHARP_STR(ret);

      while((tmp = f(mojt_data, s, (end-s)>>str->size_shift)))
      {
#ifdef PIKE_DEBUG
	if(tmp + (del->len << str->size_shift) > end)
	  Pike_fatal("SearchMojt found a match beyond end of string!\n");
#endif
	generic_memcpy(r,MKPCHARP(s,str->size_shift),(tmp-s)>>str->size_shift);
	INC_PCHARP(r,(tmp-s)>>str->size_shift);
	pike_string_cpy(r,to);
	INC_PCHARP(r,to->len);
	s=tmp+(del->len << str->size_shift);
      }
      generic_memcpy(r,MKPCHARP(s,str->size_shift),(end-s)>>str->size_shift);
    }
    do { struct pike_string * ret_=(end_shared_string(ret)); pop_stack(); push_string(ret_); return; }while(0);
#line 2324 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl array(string) _encode()
   */
  #define f_single_string_replace_cq__encode_defined
ptrdiff_t f_single_string_replace_cq__encode_fun_num = 0;
void f_single_string_replace_cq__encode(INT32 args) {
#line 2328 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_encode",args,0);
{
    if (THIS->del) {
      ref_push_string(THIS->del);
      ref_push_string(THIS->to);
      f_aggregate(2);
    } else {
      push_int(0);
    }
  }

  }
/*! @decl void _decode(array(string)|int(0..0) encoded)
   */
  #define f_single_string_replace_cq__decode_defined
ptrdiff_t f_single_string_replace_cq__decode_fun_num = 0;
void f_single_string_replace_cq__decode(INT32 args) {
#line 2341 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * encoded_;
#line 2341 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("_decode",args,1);
#line 2341 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
encoded_=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
{    
    INT32 i = 0;
    if (encoded_->type == PIKE_T_ARRAY) {
      struct array *encoded = encoded_->u.array;

      for (i=0; i < encoded->size; i++) {
	push_svalue(encoded->item + i);
	stack_swap();
      }
    }
    pop_stack();
      
    f_single_string_replace_create(i);
  }
}

#ifdef single_string_replace_event_handler_defined
static void single_string_replace_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_single_string_replace_defined
  case PROG_EVENT_INIT: init_single_string_replace_struct(); break;

#endif /* internal_init_single_string_replace_defined */

#ifdef internal_exit_single_string_replace_defined
  case PROG_EVENT_EXIT: exit_single_string_replace_struct(); break;

#endif /* internal_exit_single_string_replace_defined */
  default: break; 
  }
}

#endif /* single_string_replace_event_handler_defined */
/*! @endclass
 */

/*! @class Bootstring
 *!
 *! This class implements the "Bootstring" string transcoder described in
 *! @url{ftp://ftp.rfc-editor.org/in-notes/rfc3492.txt@}.
 */

#undef class_bootstring_defined
#define class_bootstring_defined
struct program *bootstring_program=0;
int bootstring_program_fun_num=-1;

#undef var_damp_bootstring_defined
#define var_damp_bootstring_defined

#undef var_initial_n_bootstring_defined
#define var_initial_n_bootstring_defined

#undef var_delim_bootstring_defined
#define var_delim_bootstring_defined

#undef var_digits_bootstring_defined
#define var_digits_bootstring_defined

#undef THIS
#define THIS ((struct bootstring_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BOOTSTRING
#define THIS_BOOTSTRING ((struct bootstring_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BOOTSTRING
#define OBJ2_BOOTSTRING(o) ((struct bootstring_struct *)(o->storage+bootstring_storage_offset))

#undef GET_BOOTSTRING_STORAGE
#define GET_BOOTSTRING_STORAGE ((struct bootstring_struct *)(o->storage+bootstring_storage_offset)
static ptrdiff_t bootstring_storage_offset;
struct bootstring_struct {

#ifdef var_digits_bootstring_defined
  struct pike_string * digits;

#endif /* var_digits_bootstring_defined */

#ifdef var_damp_bootstring_defined
#line 2368 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE base, tmin, tmax, skew, damp;
#endif /* var_damp_bootstring_defined */

#ifdef var_initial_n_bootstring_defined
#line 2369 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE initial_bias, initial_n;
#endif /* var_initial_n_bootstring_defined */

#ifdef var_delim_bootstring_defined
#line 2370 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
p_wchar2 delim;
#endif /* var_delim_bootstring_defined */
};
static INT_TYPE bootstring_cp_to_digit(p_wchar2 ch)
  {
    ptrdiff_t digit = THIS->digits->len;
    PCHARP digits = MKPCHARP_STR( THIS->digits );
    while (digit>=0)
      if (INDEX_PCHARP( digits, digit ) == ch)
	return digit;
      else
	--digit;
    return -1;
  }

  static INT_TYPE bootstring_adapt(INT_TYPE delta, INT_TYPE numpoints,
				   int firsttime)
  {
    struct bootstring_struct *bs = THIS;
    INT_TYPE k = 0, b = bs->base;
    INT_TYPE a = b - bs->tmin;
    INT_TYPE limit = (a * bs->tmax) >> 1;
    if (firsttime)
      delta /= bs->damp;
    else
      delta >>= 1;
    delta += delta / numpoints;
    while (delta > limit) {
      delta /= a;
      k += b;
    }
    return k + (a + 1)*delta / (delta + bs->skew);
  }

  /*! @decl string decode(string s)
   *!
   *! Decodes a Bootstring encoded string of "basic" code points back
   *! to the original string space.
   */
  #define f_bootstring_decode_defined
ptrdiff_t f_bootstring_decode_fun_num = 0;
void f_bootstring_decode(INT32 args) {
#line 2409 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 2409 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("decode",args,1);
#line 2409 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("decode",1,"string");
#line 2409 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
{
    struct bootstring_struct *bs = THIS;
    INT_TYPE n = bs->initial_n;
    INT_TYPE i = 0;
    INT_TYPE bias = bs->initial_bias;
    ptrdiff_t pos, input_left;
    PCHARP input;
    struct string_builder output;
    init_string_builder( &output,0 );
    input = MKPCHARP_STR( s );
    input_left = s->len;
    for (pos = input_left-1; pos > 0; --pos)
      if (INDEX_PCHARP( input, pos ) == bs->delim) {
	string_builder_append( &output, input, pos );
	INC_PCHARP( input, pos+1 );
	input_left -= pos+1;
	break;
      }

    while (input_left > 0) {
      INT_TYPE oldi = i;
      INT_TYPE w = 1;
      INT_TYPE k;
      for (k=bs->base; ; k+=bs->base) {
	INT_TYPE digit, t;
	if (input_left < 1 ||
	    (digit = bootstring_cp_to_digit( EXTRACT_PCHARP( input ) )) < 0) {
	  free_string_builder( &output );
	  Pike_error( "Invalid variable-length integer.\n" );
	}
	INC_PCHARP( input, 1 );
	--input_left;
	i += digit * w;	/* fail on overflow... */
	if (k <= bias + bs->tmin)
	  t = bs->tmin;
	else if (k >= bias + bs->tmax)
	  t = bs->tmax;
	else
	  t = k - bias;
	if (digit < t) break;
	w *= (bs->base - t);
      }
      bias = bootstring_adapt( i - oldi, output.s->len+1, !oldi );
      n += i / (output.s->len+1);
      i %= output.s->len+1;
      string_builder_putchar( &output, n );
      if (i != output.s->len-1)
	switch (output.s->size_shift) {
	case 0:
	  {
	    p_wchar0 *s = STR0(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = n;
	  }
	  break;
	case 1:
	  {
	    p_wchar1 *s = STR1(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = n;
	  }
	  break;
	case 2:
	  {
	    p_wchar2 *s = STR2(output.s);
	    INT_TYPE p = output.s->len;
	    while (--p>i)
	      s[p] = s[p-1];
	    s[p] = n;
	  }
	  break;
	default:
	  Pike_fatal("Illegal shift size!\n");
	}
      i++;
    }

    do { struct pike_string * ret_=(finish_string_builder( &output )); pop_stack(); push_string(ret_); return; }while(0);
#line 2492 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl string encode(string s)
   *!
   *! Encodes a string using Bootstring encoding into a string constisting
   *! only of "basic" code points (< initial_n).
   */
  #define f_bootstring_encode_defined
ptrdiff_t f_bootstring_encode_fun_num = 0;
void f_bootstring_encode(INT32 args) {
#line 2499 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * s;
#line 2499 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("encode",args,1);
#line 2499 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("encode",1,"string");
#line 2499 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
{
    struct bootstring_struct *bs = THIS;
    INT_TYPE n = bs->initial_n;
    INT_TYPE delta = 0;
    INT_TYPE bias = bs->initial_bias;
    INT_TYPE c, h, b = 0;
    ptrdiff_t pos, input_left;
    PCHARP input;
    struct string_builder output;
    init_string_builder( &output,0 );
    input = MKPCHARP_STR( s );
    input_left = s->len;
    for (pos=0; pos<input_left; pos++)
      if ((c = INDEX_PCHARP( input, pos )) < n) {
	string_builder_putchar( &output, c );
	b++;
      }
    if ((h = b))
      string_builder_putchar( &output, bs->delim );
    while (h < input_left) {
      INT_TYPE m = -1;
      for (pos=0; pos<input_left; pos++)
	if ((c = INDEX_PCHARP( input, pos )) >= n &&
	    (m < 0 || c < m))
	  m = c;
      delta = delta + (m - n) * (h + 1); /* fail on overflow... */
      n = m;
      for (pos=0; pos<input_left; pos++)
	if ((c = INDEX_PCHARP( input, pos )) < n)
	  delta++;
	else if (c == n) {
	  INT_TYPE k, q = delta;
	  for (k=bs->base; ; k+=bs->base) {
	    INT_TYPE t, bt;
	    if (k <= bias + bs->tmin)
	      t = bs->tmin;
	    else if(k >= bias + bs->tmax)
	      t = bs->tmax;
	    else
	      t = k-bias;
	    if (q < t)
	      break;
	    bt = bs->base - t;
	    string_builder_putchar( &output,
				    index_shared_string( bs->digits,
							 t + (q-t)%bt ) );
	    q = (q-t) / bt;
	  }
	  string_builder_putchar( &output,
				  index_shared_string( bs->digits, q ) );
	  bias = bootstring_adapt( delta, h+1, h==b );
	  delta = 0;
	  h++;
	}
      delta++;
      n++;
    }

    do { struct pike_string * ret_=(finish_string_builder( &output )); pop_stack(); push_string(ret_); return; }while(0);
#line 2559 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl void create(int base, int tmin, int tmax, int skew,		@
   *!                   int damp, int initial_bias, int initial_n,	@
   *!			int delim, string digits)
   *!
   *! Creates a Bootstring transcoder instance using the specified parameters.
   *!
   *! @param base
   *!   The base used by the variable-length integers.
   *! @param tmin
   *!   The minimum threshold digit value for the variable-length integers.
   *!   Must be >=0 and <= tmax.
   *! @param tmax
   *!   The maximum threshold digit value for the variable-length integers.
   *!   Must be <= base-1.
   *! @param skew
   *!   The skew term for the bias adapation.  Must be >= 1.
   *! @param damp
   *!   The damping factor for the bias adaption.  Must be >= 2.
   *! @param initial_bias
   *!   The initial bias for the variable-length integer thresholding.
   *!   initial_bias % base must be <= base - tmin.
   *! @param initial_n
   *!   The first code point outside the "basic" set of code points.
   *! @param delim
   *!   The "basic" code point used as the delimiter.
   *! @param digits
   *!   The "basic" code points used as digits.  The length of the string
   *!   should be the same as the base parameter.
   */
  #define f_bootstring_create_defined
ptrdiff_t f_bootstring_create_fun_num = 0;
void f_bootstring_create(INT32 args) {
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE base;
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE tmin;
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE tmax;
INT_TYPE skew;
#line 2591 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE damp;
INT_TYPE initial_bias;
#line 2592 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE initial_n;
INT_TYPE delim;
#line 2593 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * digits;
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 9) wrong_number_of_args_error("create",args,9);
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",1,"int");
base=Pike_sp[0-9].u.integer;
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",2,"int");
tmin=Pike_sp[1-9].u.integer;
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[2-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",3,"int");
tmax=Pike_sp[2-9].u.integer;
#line 2591 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[3-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",4,"int");
skew=Pike_sp[3-9].u.integer;
#line 2591 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[4-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",5,"int");
damp=Pike_sp[4-9].u.integer;
#line 2592 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[5-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",6,"int");
initial_bias=Pike_sp[5-9].u.integer;
#line 2592 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[6-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",7,"int");
initial_n=Pike_sp[6-9].u.integer;
#line 2593 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[7-9].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",8,"int");
delim=Pike_sp[7-9].u.integer;
#line 2593 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[8-9].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("create",9,"string");
#line 2593 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(digits=Pike_sp[8-9].u.string);
#line 2595 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    struct bootstring_struct *bs = THIS;
    if (base<2)
      Pike_error("Bogus base\n");
    if (tmin<0 || tmax<tmin || base-1<tmax)
      Pike_error("Parameters violate 0 <= tmin <= tmax <= base-1\n");
    if (skew < 1)
      Pike_error("Parameters violate skew >= 1\n");
    if (damp < 2)
      Pike_error("Parameters violate damp >= 2\n");
    if (initial_bias%base > base-tmin)
      Pike_error("Parameters violate initial_bias%%base <= base-tmin\n");
    if (digits->len != base)
      Pike_error("Length of digits string does not match base.\n");
    bs->base = base;  bs->tmin = tmin;  bs->tmax = tmax;
    bs->skew = skew;  bs->damp = damp;
    bs->initial_bias = initial_bias;  bs->initial_n = initial_n;
    bs->delim = delim;
    if (bs->digits) {
      free_string( bs->digits );
      bs->digits = NULL;
    }
    copy_shared_string( bs->digits, digits );
  }

}
/*! @endclass
 */

/*! @endmodule
 */

/*! @module System
 */

/*! @class Time
 *!
 *! The current time as a structure containing a sec and a usec
 *! member.
 */

#undef class_Time_defined
#define class_Time_defined
struct program *Time_program=0;
int Time_program_fun_num=-1;

#undef var_hard_update_Time_defined
#define var_hard_update_Time_defined

#undef THIS
#define THIS ((struct Time_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_TIME
#define THIS_TIME ((struct Time_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_TIME
#define OBJ2_TIME(o) ((struct Time_struct *)(o->storage+Time_storage_offset))

#undef GET_TIME_STORAGE
#define GET_TIME_STORAGE ((struct Time_struct *)(o->storage+Time_storage_offset)
static ptrdiff_t Time_storage_offset;
struct Time_struct {

#ifdef var_hard_update_Time_defined
#line 2638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
int hard_update;
#endif /* var_hard_update_Time_defined */
};
/*! @decl int sec;
   *! @decl int usec;
   *!
   *!   The number of seconds and microseconds since the epoch and the
   *!   last whole second, respectively. (See also @[predef::time()])
   *!
   *!   Please note that these variables will continually update when
   *!   they are requested, there is no need to create new Time()
   *!   objects.
   */

  /*! @decl int usec_full;
   *!
   *!   The number of microseconds since the epoch. Please note that
   *!   pike has to have been compiled with bignum support for this
   *!   variable to contain sensible values.
   */

  #define f_Time_cq__backtick_2D_3E_defined
ptrdiff_t f_Time_cq__backtick_2D_3E_fun_num = 0;
void f_Time_cq__backtick_2D_3E(INT32 args) {
#line 2658 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * x;
#line 2658 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`->",args,1);
#line 2658 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`->",1,"string");
#line 2658 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(x=Pike_sp[0-1].u.string);
{
    extern struct timeval current_time;
    struct pike_string *usec;
    struct pike_string *sec;

    MAKE_CONST_STRING( sec, "sec" );
    MAKE_CONST_STRING( usec, "usec" );

    if( !x )
      do { INT_TYPE ret_=(0); pop_stack(); push_int(ret_); return; }while(0);
#line 2670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );

    if( x == usec )
      do { INT_TYPE ret_=(current_time.tv_usec); pop_stack(); push_int(ret_); return; }while(0);
#line 2675 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if( x == sec )
      do { INT_TYPE ret_=(current_time.tv_sec); pop_stack(); push_int(ret_); return; }while(0);
#line 2678 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
#ifdef AUTO_BIGNUM
    pop_stack();
    push_int( current_time.tv_sec );
    push_int( 1000000 );
    f_multiply( 2 );
    push_int( current_time.tv_usec );
    f_add( 2 );
    return;
#else
    do { INT_TYPE ret_=((current_time.tv_sec * 1000000 + current_time.tv_usec)); pop_stack(); push_int(ret_); return; }while(0);
#line 2688 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
#endif
  }
  
  }
#define f_Time_cq__backtick_5B_5D_defined
ptrdiff_t f_Time_cq__backtick_5B_5D_fun_num = 0;
void f_Time_cq__backtick_5B_5D(INT32 args) {
#line 2691 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct pike_string * x;
#line 2691 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`[]",args,1);
#line 2691 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`[]",1,"string");
#line 2691 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(x=Pike_sp[0-1].u.string);
{
    f_Time_cq__backtick_2D_3E( args );
  }

  }
/*! @decl static void create( int fast );
   *!
   *! If fast is true, do not request a new time from the system,
   *! instead use the global current time variable.
   *!
   *! This will only work in callbacks, but can save significant amounts
   *! of CPU.
   */
  #define f_Time_create_defined
ptrdiff_t f_Time_create_fun_num = 0;
void f_Time_create(INT32 args) {
#line 2704 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * fast;
#line 2704 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
if (args > 0) {
#line 2704 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
fast=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else fast=0;
#line 2705 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    THIS->hard_update = !fast;
  }
}
/*! @endclass
 */

/*! @class Timer
 */

#undef class_Timer_defined
#define class_Timer_defined
struct program *Timer_program=0;
int Timer_program_fun_num=-1;

#undef var_last_time_Timer_defined
#define var_last_time_Timer_defined

#undef var_hard_update_Timer_defined
#define var_hard_update_Timer_defined

#undef THIS
#define THIS ((struct Timer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_TIMER
#define THIS_TIMER ((struct Timer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_TIMER
#define OBJ2_TIMER(o) ((struct Timer_struct *)(o->storage+Timer_storage_offset))

#undef GET_TIMER_STORAGE
#define GET_TIMER_STORAGE ((struct Timer_struct *)(o->storage+Timer_storage_offset)
static ptrdiff_t Timer_storage_offset;
struct Timer_struct {

#ifdef var_last_time_Timer_defined
#line 2717 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct timeval last_time;
#endif /* var_last_time_Timer_defined */

#ifdef var_hard_update_Timer_defined
#line 2718 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
int hard_update;
#endif /* var_hard_update_Timer_defined */
};
/*! @decl float peek()
   *!   Return the time in seconds since the last time @[get] was called.
   */
  #define f_Timer_peek_defined
ptrdiff_t f_Timer_peek_fun_num = 0;
void f_Timer_peek(INT32 args) {
#line 2723 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("peek",args,0);
{
    extern struct timeval current_time;
    FLOAT_TYPE res;
    if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );
    res = current_time.tv_sec-THIS->last_time.tv_sec +
      (current_time.tv_usec-THIS->last_time.tv_usec)/1000000.0;
    do { FLOAT_TYPE ret_=(res);  push_float(ret_); return; }while(0);
#line 2732 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

  }
/*! @decl float get()
   *!   Return the time in seconds since the last time get was called.
   *!   The first time this method is called the time since the object
   *!   was created is returned instead.
   */
  #define f_Timer_get_defined
ptrdiff_t f_Timer_get_fun_num = 0;
void f_Timer_get(INT32 args) {
#line 2739 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
{
    extern struct timeval current_time;
    f_Timer_peek( 0 );
    THIS->last_time = current_time;
    return;
  }

  }
/*! @decl static void create( int|void fast )
   *!   Create a new timer object. The timer keeps track of relative time
   *!   with sub-second precision.
   *!   
   *!   If fast is specified, the timer will not do system calls to get
   *!   the current time but instead use the one maintained by pike. This
   *!   will result in faster but somewhat more inexact timekeeping. 
   *!   Also, if your program never utilizes the pike event loop the pike
   *!   maintained current time never change.
   */
  #define f_Timer_create_defined
ptrdiff_t f_Timer_create_fun_num = 0;
void f_Timer_create(INT32 args) {
#line 2757 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * fast;
#line 2757 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
if (args > 0) {
#line 2757 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
fast=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else fast=0;
#line 2758 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
    extern struct timeval current_time;
    THIS->hard_update = !fast;
    if( THIS->hard_update )
      GETTIMEOFDAY( &current_time );
    THIS->last_time = current_time; 
  }
}
/*! @endclass
 */

/*! @endmodule
 */



#undef class_automap_marker_defined
#define class_automap_marker_defined
struct program *automap_marker_program=0;
int automap_marker_program_fun_num=-1;

#undef var_arg_automap_marker_defined
#define var_arg_automap_marker_defined

#undef var_depth_automap_marker_defined
#define var_depth_automap_marker_defined

#undef THIS
#define THIS ((struct automap_marker_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_AUTOMAP_MARKER
#define THIS_AUTOMAP_MARKER ((struct automap_marker_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_AUTOMAP_MARKER
#define OBJ2_AUTOMAP_MARKER(o) ((struct automap_marker_struct *)(o->storage+automap_marker_storage_offset))

#undef GET_AUTOMAP_MARKER_STORAGE
#define GET_AUTOMAP_MARKER_STORAGE ((struct automap_marker_struct *)(o->storage+automap_marker_storage_offset)
static ptrdiff_t automap_marker_storage_offset;
struct automap_marker_struct {

#ifdef var_arg_automap_marker_defined
  struct array * arg;

#endif /* var_arg_automap_marker_defined */

#ifdef var_depth_automap_marker_defined
  INT_TYPE depth;

#endif /* var_depth_automap_marker_defined */
};
#define f_automap_marker_create_defined
ptrdiff_t f_automap_marker_create_fun_num = 0;
void f_automap_marker_create(INT32 args) {
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct array * a;
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE d;
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("create",args,2);
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("create",1,"array");
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(a=Pike_sp[0-2].u.array);
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("create",2,"int");
d=Pike_sp[1-2].u.integer;
#line 2780 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
      if(THIS->arg) free_array(THIS->arg);
      add_ref(THIS->arg=a);
      THIS->depth=d;
    }

  }
#define f_automap_marker_cq__sprintf_defined
ptrdiff_t f_automap_marker_cq__sprintf_fun_num = 0;
void f_automap_marker_cq__sprintf(INT32 args) {
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
INT_TYPE mode;
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct mapping * flags;
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
mode=Pike_sp[0-2].u.integer;
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
{
      pop_n_elems(args);
      if (mode != 'O') {
	push_undefined ();
	return;
      }
      push_text("%O%*'[*]'n");
      if(THIS->arg)
	ref_push_array(THIS->arg);
      else
	push_int(0);
      push_int(THIS->depth*3);
      f_sprintf(3);
    }
}
#line 2804 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
static void low_automap(int d,
			int depth,
			struct svalue *fun,
			struct svalue *real_args,
			INT32 args)
{
  INT32 x,e,tmp,size=0x7fffffff;
  struct svalue *tmpargs=Pike_sp - args;
  struct array *ret;
  TYPE_FIELD types;

  for(e=0;e<args;e++)
  {
    if(real_args[e].type==T_OBJECT &&
       real_args[e].u.object->prog == automap_marker_program &&
       OBJ2_AUTOMAP_MARKER(real_args[e].u.object)->depth >= d)
    {
      if(tmpargs[e].type != T_ARRAY)
	index_error("__automap__",
		    Pike_sp-args,
		    args,
		    tmpargs,
		    NULL,
		    "Automap on non-array.\n");
      tmp=tmpargs[e].u.array->size;
      if(tmp < size)
	size=tmp;
    }
  }

#ifdef PIKE_DEBUG
   if(size == 0x7fffffff)
    Pike_fatal("No automap markers found in low_automap\n");
#endif

  push_array(ret=allocate_array(size));
  types = 0;

  for(x=0;x<size;x++)
  {
    for(e=0;e<args;e++)
    {
      if(real_args[e].type==T_OBJECT &&
	 real_args[e].u.object->prog == automap_marker_program &&
	 OBJ2_AUTOMAP_MARKER(real_args[e].u.object)->depth >= d)
      {
#ifdef PIKE_DEBUG
	if(x >= tmpargs[e].u.array->size)
	  Pike_fatal("low_automap failed to determine size!\n");
#endif
	push_svalue(ITEM(tmpargs[e].u.array)+x);
      }else{
	push_svalue(tmpargs+e);
      }
    }
    
    if(d == depth)
      apply_svalue(fun,args);
    else
      low_automap(d+1,depth,fun,real_args,args);
    stack_pop_to_no_free (ITEM(ret) + x);
    types |= 1 << ITEM(ret)[x].type;
  }
  ret->type_field = types;
  stack_unlink(args);
}


#define f_cq___automap___defined
void f_cq___automap__(INT32 args) {
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * fun;
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
struct svalue * tmpargs;
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if(args < 1) wrong_number_of_args_error("__automap__",args,1);
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
fun=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
if (args > 1) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+1+argcnt-args);
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  } while (++argcnt < args-1);
  tmpargs=Pike_sp+1-args;
} else tmpargs=0;
#line 2874 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
{
  int e,depth=-1;
  check_stack(args);

  for(e=0;e<args-1;e++)
  {
    if(tmpargs[e].type==T_OBJECT &&
       tmpargs[e].u.object->prog == automap_marker_program)
    {
      int tmp=OBJ2_AUTOMAP_MARKER(tmpargs[e].u.object)->depth;
      if(tmp > depth) depth=tmp;
      ref_push_array(OBJ2_AUTOMAP_MARKER(tmpargs[e].u.object)->arg);
    }else{
      push_svalue(tmpargs+e);
    }
  }
  check_stack(depth * (args+1));
  low_automap(1,depth,fun,tmpargs,args-1);
  stack_unlink(args);
}

}
#line 2895 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
void init_builtin(void)
{

#ifdef class_backtrace_frame_defined

#ifdef PROG_BACKTRACE_FRAME_ID
  START_NEW_PROGRAM_ID(BACKTRACE_FRAME);
#else
  start_new_program();

#endif /* PROG_BACKTRACE_FRAME_ID */

#ifndef tObjImpl_BACKTRACE_FRAME

#undef tObjImpl_BACKTRACE_FRAME
#define tObjImpl_BACKTRACE_FRAME tObj

#endif /* tObjImpl_BACKTRACE_FRAME */

#ifdef THIS_BACKTRACE_FRAME

  backtrace_frame_storage_offset=ADD_STORAGE(struct backtrace_frame_struct);

#endif /* THIS_BACKTRACE_FRAME */

#ifdef var_fun_backtrace_frame_defined
  PIKE_MAP_VARIABLE("fun", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, fun),
                    tMix, PIKE_T_MIXED, 0);
#endif /* var_fun_backtrace_frame_defined */

#ifdef var_args_backtrace_frame_defined
  PIKE_MAP_VARIABLE("args", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, args),
                    tArray, PIKE_T_ARRAY, 0);
#endif /* var_args_backtrace_frame_defined */

#ifdef var_prog_backtrace_frame_defined
  PIKE_MAP_VARIABLE("prog", backtrace_frame_storage_offset + OFFSETOF(backtrace_frame_struct, prog),
                    tPrg(tObj), PIKE_T_PROGRAM, ID_STATIC|ID_PRIVATE);
#endif /* var_prog_backtrace_frame_defined */

#ifdef backtrace_frame_event_handler_defined
  pike_set_prog_event_callback(backtrace_frame_event_handler);

#endif /* backtrace_frame_event_handler_defined */

#ifdef f_backtrace_frame_cq__is_type_defined
#line 1212 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_backtrace_frame_cq__is_type_fun_num =
    ADD_FUNCTION2("_is_type", f_backtrace_frame_cq__is_type, tFunc(tString,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__is_type_defined */

#ifdef f_backtrace_frame_cq__sprintf_defined
#line 1247 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_backtrace_frame_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_backtrace_frame_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tMapping,tVoid),tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__sprintf_defined */

#ifdef f_backtrace_frame_cq__sizeof_defined
#line 1299 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_backtrace_frame_cq__sizeof_fun_num =
    ADD_FUNCTION2("_sizeof", f_backtrace_frame_cq__sizeof, tFunc(tNone,"\10\0\0\0\3\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__sizeof_defined */

#ifdef f_backtrace_frame_cq__backtick_5B_5D_defined
#line 1311 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_backtrace_frame_cq__backtick_5B_5D_fun_num =
    ADD_FUNCTION2("`[]", f_backtrace_frame_cq__backtick_5B_5D, tFunc("\10\200\0\0\0\177\377\377\377" tOr("\10\200\0\0\0\177\377\377\377",tVoid),tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_5B_5D_defined */

#ifdef f_backtrace_frame_cq__backtick_5B_5D_eq_defined
#line 1391 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_backtrace_frame_cq__backtick_5B_5D_eq_fun_num =
    ADD_FUNCTION2("`[]=", f_backtrace_frame_cq__backtick_5B_5D_eq, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_backtrace_frame_cq__backtick_5B_5D_eq_defined */
  backtrace_frame_program=end_program();
  backtrace_frame_program_fun_num=add_program_constant("backtrace_frame",backtrace_frame_program,0);

#endif /* class_backtrace_frame_defined */

#ifdef class_Buffer_defined

#ifdef PROG_BUFFER_ID
  START_NEW_PROGRAM_ID(BUFFER);
#else
  start_new_program();

#endif /* PROG_BUFFER_ID */

#ifndef tObjImpl_BUFFER

#undef tObjImpl_BUFFER
#define tObjImpl_BUFFER tObj

#endif /* tObjImpl_BUFFER */

#ifdef THIS_BUFFER

  Buffer_storage_offset=ADD_STORAGE(struct Buffer_struct);

#endif /* THIS_BUFFER */

#ifdef Buffer_event_handler_defined
  pike_set_prog_event_callback(Buffer_event_handler);

#endif /* Buffer_event_handler_defined */

#ifdef f_Buffer_create_defined
#line 1639 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_create_fun_num =
    ADD_FUNCTION2("create", f_Buffer_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_create_defined */

#ifdef f_Buffer_cq__sprintf_defined
#line 1655 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_Buffer_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sprintf_defined */

#ifdef f_Buffer_cast_defined
#line 1703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_cast_fun_num =
    ADD_FUNCTION2("cast", f_Buffer_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cast_defined */

#ifdef f_Buffer_cq__backtick_add_defined
#line 1736 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_cq__backtick_add_fun_num =
    ADD_FUNCTION2("`+", f_Buffer_cq__backtick_add, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_defined */

#ifdef f_Buffer_cq__backtick_add_eq_defined
#line 1750 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_cq__backtick_add_eq_fun_num =
    ADD_FUNCTION2("`+=", f_Buffer_cq__backtick_add_eq, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_eq_defined */

#ifdef f_Buffer_add_defined
#line 1761 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_add_fun_num =
    ADD_FUNCTION2("add", f_Buffer_add, tFuncV(tNone,tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_defined */

#ifdef f_Buffer_putchar_defined
#line 1809 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_putchar_fun_num =
    ADD_FUNCTION2("putchar", f_Buffer_putchar, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_putchar_defined */

#ifdef f_Buffer_get_copy_defined
#line 1821 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_get_copy_fun_num =
    ADD_FUNCTION2("get_copy", f_Buffer_get_copy, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_copy_defined */

#ifdef f_Buffer_get_defined
#line 1855 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_get_fun_num =
    ADD_FUNCTION2("get", f_Buffer_get, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_defined */

#ifdef f_Buffer_cq__sizeof_defined
#line 1874 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Buffer_cq__sizeof_fun_num =
    ADD_FUNCTION2("_sizeof", f_Buffer_cq__sizeof, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sizeof_defined */
  Buffer_program=end_program();
  Buffer_program_fun_num=add_program_constant("Buffer",Buffer_program,0);

#endif /* class_Buffer_defined */

#ifdef class_multi_string_replace_defined

#ifdef PROG_MULTI_STRING_REPLACE_ID
  START_NEW_PROGRAM_ID(MULTI_STRING_REPLACE);
#else
  start_new_program();

#endif /* PROG_MULTI_STRING_REPLACE_ID */

#ifndef tObjImpl_MULTI_STRING_REPLACE

#undef tObjImpl_MULTI_STRING_REPLACE
#define tObjImpl_MULTI_STRING_REPLACE tObj

#endif /* tObjImpl_MULTI_STRING_REPLACE */

#ifdef THIS_MULTI_STRING_REPLACE

  multi_string_replace_storage_offset=ADD_STORAGE(struct multi_string_replace_struct);

#endif /* THIS_MULTI_STRING_REPLACE */

#ifdef multi_string_replace_event_handler_defined
  pike_set_prog_event_callback(multi_string_replace_event_handler);

#endif /* multi_string_replace_event_handler_defined */

#ifdef f_multi_string_replace_create_defined
#line 1919 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_multi_string_replace_create_fun_num =
    ADD_FUNCTION2("create", f_multi_string_replace_create, tFunc(tOr(tArr(tString),tVoid) tOr(tArr(tString),tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_create_defined */

#ifdef f_multi_string_replace_cq__backtick_28_29_defined
#line 2054 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_multi_string_replace_cq__backtick_28_29_fun_num =
    ADD_FUNCTION2("`()", f_multi_string_replace_cq__backtick_28_29, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__backtick_28_29_defined */

#ifdef f_multi_string_replace_cq__encode_defined
#line 2115 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_multi_string_replace_cq__encode_fun_num =
    ADD_FUNCTION2("_encode", f_multi_string_replace_cq__encode, tFunc(tNone,tArr(tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__encode_defined */

#ifdef f_multi_string_replace_cq__decode_defined
#line 2131 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_multi_string_replace_cq__decode_fun_num =
    ADD_FUNCTION2("_decode", f_multi_string_replace_cq__decode, tFunc(tArr(tArr(tString)),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_multi_string_replace_cq__decode_defined */
  multi_string_replace_program=end_program();
  multi_string_replace_program_fun_num=add_program_constant("multi_string_replace",multi_string_replace_program,0);

#endif /* class_multi_string_replace_defined */

#ifdef class_single_string_replace_defined

#ifdef PROG_SINGLE_STRING_REPLACE_ID
  START_NEW_PROGRAM_ID(SINGLE_STRING_REPLACE);
#else
  start_new_program();

#endif /* PROG_SINGLE_STRING_REPLACE_ID */

#ifndef tObjImpl_SINGLE_STRING_REPLACE

#undef tObjImpl_SINGLE_STRING_REPLACE
#define tObjImpl_SINGLE_STRING_REPLACE tObj

#endif /* tObjImpl_SINGLE_STRING_REPLACE */

#ifdef THIS_SINGLE_STRING_REPLACE

  single_string_replace_storage_offset=ADD_STORAGE(struct single_string_replace_struct);

#endif /* THIS_SINGLE_STRING_REPLACE */

#ifdef single_string_replace_event_handler_defined
  pike_set_prog_event_callback(single_string_replace_event_handler);

#endif /* single_string_replace_event_handler_defined */

#ifdef f_single_string_replace_create_defined
#line 2208 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_single_string_replace_create_fun_num =
    ADD_FUNCTION2("create", f_single_string_replace_create, tFunc(tOr(tString,tVoid) tOr(tString,tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_create_defined */

#ifdef f_single_string_replace_cq__backtick_28_29_defined
#line 2240 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_single_string_replace_cq__backtick_28_29_fun_num =
    ADD_FUNCTION2("`()", f_single_string_replace_cq__backtick_28_29, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__backtick_28_29_defined */

#ifdef f_single_string_replace_cq__encode_defined
#line 2328 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_single_string_replace_cq__encode_fun_num =
    ADD_FUNCTION2("_encode", f_single_string_replace_cq__encode, tFunc(tNone,tArr(tString)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__encode_defined */

#ifdef f_single_string_replace_cq__decode_defined
#line 2341 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_single_string_replace_cq__decode_fun_num =
    ADD_FUNCTION2("_decode", f_single_string_replace_cq__decode, tFunc(tOr(tArr(tString),"\10\0\0\0\0\0\0\0\0"),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_single_string_replace_cq__decode_defined */
  single_string_replace_program=end_program();
  single_string_replace_program_fun_num=add_program_constant("single_string_replace",single_string_replace_program,0);

#endif /* class_single_string_replace_defined */

#ifdef class_bootstring_defined

#ifdef PROG_BOOTSTRING_ID
  START_NEW_PROGRAM_ID(BOOTSTRING);
#else
  start_new_program();

#endif /* PROG_BOOTSTRING_ID */

#ifndef tObjImpl_BOOTSTRING

#undef tObjImpl_BOOTSTRING
#define tObjImpl_BOOTSTRING tObj

#endif /* tObjImpl_BOOTSTRING */

#ifdef THIS_BOOTSTRING

  bootstring_storage_offset=ADD_STORAGE(struct bootstring_struct);

#endif /* THIS_BOOTSTRING */

#ifdef var_digits_bootstring_defined
  PIKE_MAP_VARIABLE("digits", bootstring_storage_offset + OFFSETOF(bootstring_struct, digits),
                    tString, PIKE_T_STRING, ID_STATIC|ID_PRIVATE);
#endif /* var_digits_bootstring_defined */

#ifdef f_bootstring_decode_defined
#line 2409 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_bootstring_decode_fun_num =
    ADD_FUNCTION2("decode", f_bootstring_decode, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_decode_defined */

#ifdef f_bootstring_encode_defined
#line 2499 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_bootstring_encode_fun_num =
    ADD_FUNCTION2("encode", f_bootstring_encode, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_encode_defined */

#ifdef f_bootstring_create_defined
#line 2590 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_bootstring_create_fun_num =
    ADD_FUNCTION2("create", f_bootstring_create, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377" tString,tVoid), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_bootstring_create_defined */
  bootstring_program=end_program();
  bootstring_program_fun_num=add_program_constant("bootstring",bootstring_program,0);

#endif /* class_bootstring_defined */

#ifdef class_Time_defined

#ifdef PROG_TIME_ID
  START_NEW_PROGRAM_ID(TIME);
#else
  start_new_program();

#endif /* PROG_TIME_ID */

#ifndef tObjImpl_TIME

#undef tObjImpl_TIME
#define tObjImpl_TIME tObj

#endif /* tObjImpl_TIME */

#ifdef THIS_TIME

  Time_storage_offset=ADD_STORAGE(struct Time_struct);

#endif /* THIS_TIME */

#ifdef f_Time_cq__backtick_2D_3E_defined
#line 2658 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Time_cq__backtick_2D_3E_fun_num =
    ADD_FUNCTION2("`->", f_Time_cq__backtick_2D_3E, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_cq__backtick_2D_3E_defined */

#ifdef f_Time_cq__backtick_5B_5D_defined
#line 2691 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Time_cq__backtick_5B_5D_fun_num =
    ADD_FUNCTION2("`[]", f_Time_cq__backtick_5B_5D, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_cq__backtick_5B_5D_defined */

#ifdef f_Time_create_defined
#line 2704 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Time_create_fun_num =
    ADD_FUNCTION2("create", f_Time_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Time_create_defined */
  Time_program=end_program();
  Time_program_fun_num=add_program_constant("Time",Time_program,0);

#endif /* class_Time_defined */

#ifdef class_Timer_defined

#ifdef PROG_TIMER_ID
  START_NEW_PROGRAM_ID(TIMER);
#else
  start_new_program();

#endif /* PROG_TIMER_ID */

#ifndef tObjImpl_TIMER

#undef tObjImpl_TIMER
#define tObjImpl_TIMER tObj

#endif /* tObjImpl_TIMER */

#ifdef THIS_TIMER

  Timer_storage_offset=ADD_STORAGE(struct Timer_struct);

#endif /* THIS_TIMER */

#ifdef f_Timer_peek_defined
#line 2723 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Timer_peek_fun_num =
    ADD_FUNCTION2("peek", f_Timer_peek, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_peek_defined */

#ifdef f_Timer_get_defined
#line 2739 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Timer_get_fun_num =
    ADD_FUNCTION2("get", f_Timer_get, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_get_defined */

#ifdef f_Timer_create_defined
#line 2757 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_Timer_create_fun_num =
    ADD_FUNCTION2("create", f_Timer_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Timer_create_defined */
  Timer_program=end_program();
  Timer_program_fun_num=add_program_constant("Timer",Timer_program,0);

#endif /* class_Timer_defined */

#ifdef class_automap_marker_defined

#ifdef PROG_AUTOMAP_MARKER_ID
  START_NEW_PROGRAM_ID(AUTOMAP_MARKER);
#else
  start_new_program();

#endif /* PROG_AUTOMAP_MARKER_ID */

#ifndef tObjImpl_AUTOMAP_MARKER

#undef tObjImpl_AUTOMAP_MARKER
#define tObjImpl_AUTOMAP_MARKER tObj

#endif /* tObjImpl_AUTOMAP_MARKER */

#ifdef THIS_AUTOMAP_MARKER

  automap_marker_storage_offset=ADD_STORAGE(struct automap_marker_struct);

#endif /* THIS_AUTOMAP_MARKER */

#ifdef var_arg_automap_marker_defined
  PIKE_MAP_VARIABLE("arg", automap_marker_storage_offset + OFFSETOF(automap_marker_struct, arg),
                    tArray, PIKE_T_ARRAY, 0);
#endif /* var_arg_automap_marker_defined */

#ifdef var_depth_automap_marker_defined
  PIKE_MAP_VARIABLE("depth", automap_marker_storage_offset + OFFSETOF(automap_marker_struct, depth),
                    "\10\200\0\0\0\177\377\377\377", PIKE_T_INT, 0);
#endif /* var_depth_automap_marker_defined */

#ifdef f_automap_marker_create_defined
#line 2779 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_automap_marker_create_fun_num =
    ADD_FUNCTION2("create", f_automap_marker_create, tFunc(tArray "\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_automap_marker_create_defined */

#ifdef f_automap_marker_cq__sprintf_defined
#line 2786 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_automap_marker_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_automap_marker_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_automap_marker_cq__sprintf_defined */
  automap_marker_program=end_program();
  automap_marker_program_fun_num=add_program_constant("automap_marker",automap_marker_program,0);

#endif /* class_automap_marker_defined */

#ifdef f_cq__describe_program_defined
#line 41 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("_describe_program", f_cq__describe_program, tFunc(tMix,tArr(tArr(tOr("\10\200\0\0\0\177\377\377\377",tString)))), 0);

#endif /* f_cq__describe_program_defined */

#ifdef f_basetype_defined
#line 82 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("basetype", f_basetype, tFunc(tMix,tString), OPT_TRY_OPTIMIZE);

#endif /* f_basetype_defined */

#ifdef f_int2char_defined
#line 143 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("int2char", f_int2char, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tObj),tString), OPT_TRY_OPTIMIZE);

#endif /* f_int2char_defined */

#ifdef f_int2hex_defined
#line 193 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("int2hex", f_int2hex, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tObj),tString), OPT_TRY_OPTIMIZE);

#endif /* f_int2hex_defined */

#ifdef f_string2hex_defined
#line 269 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_string2hex_fun_num =
    ADD_FUNCTION2("string2hex", f_string2hex, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string2hex_defined */

#ifdef f_hex2string_defined
#line 298 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_hex2string_fun_num =
    ADD_FUNCTION2("hex2string", f_hex2string, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_hex2string_defined */

#ifdef f_column_defined
#line 334 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("column", f_column, tFunc(tArray tMix,tArray), OPT_TRY_OPTIMIZE);

#endif /* f_column_defined */

#ifdef f_mkmultiset_defined
#line 349 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("mkmultiset", f_mkmultiset, tFunc(tArr(tSetvar(1,tMix)),tSet(tVar(1))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmultiset_defined */

#ifdef f_trace_defined
#line 401 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("trace", f_trace, tFunc("\10\200\0\0\0\177\377\377\377" tOr(tVoid,tString) tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),"\10\200\0\0\0\177\377\377\377"), OPT_SIDE_EFFECT);

#endif /* f_trace_defined */

#ifdef f_gc_parameters_defined
#line 477 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_gc_parameters_fun_num =
    ADD_FUNCTION2("gc_parameters", f_gc_parameters, tFunc(tOr(tVoid,tMap(tString,tMix)),tMap(tString,tMix)), 0, OPT_SIDE_EFFECT);

#endif /* f_gc_parameters_defined */

#ifdef f_ctime_defined
#line 556 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("ctime", f_ctime, tFunc("\10\200\0\0\0\177\377\377\377",tString), OPT_TRY_OPTIMIZE);

#endif /* f_ctime_defined */

#ifdef f_mkmapping_defined
#line 580 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("mkmapping", f_mkmapping, tFunc(tArr(tSetvar(1,tMix)) tArr(tSetvar(2,tMix)),tMap(tVar(1),tVar(2))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmapping_defined */

#ifdef f_string_count_defined
#line 601 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_string_count_fun_num =
    ADD_FUNCTION2("string_count", f_string_count, tFunc(tString tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_count_defined */

#ifdef f_string_trim_whites_defined
#line 638 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_string_trim_whites_fun_num =
    ADD_FUNCTION2("string_trim_whites", f_string_trim_whites, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_trim_whites_defined */

#ifdef f_string_trim_all_whites_defined
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_string_trim_all_whites_fun_num =
    ADD_FUNCTION2("string_trim_all_whites", f_string_trim_all_whites, tFunc(tString,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_trim_all_whites_defined */

#ifdef f_program_implements_defined
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_program_implements_fun_num =
    ADD_FUNCTION2("program_implements", f_program_implements, tFunc(tPrg(tObj) tPrg(tObj),"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_implements_defined */

#ifdef f_program_inherits_defined
#line 715 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_program_inherits_fun_num =
    ADD_FUNCTION2("program_inherits", f_program_inherits, tFunc(tPrg(tObj) tPrg(tObj),"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_inherits_defined */

#ifdef f_program_defined_defined
#line 733 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_program_defined_fun_num =
    ADD_FUNCTION2("program_defined", f_program_defined, tFunc(tPrg(tObj),tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_defined_defined */

#ifdef f_string_width_defined
#line 770 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  f_string_width_fun_num =
    ADD_FUNCTION2("string_width", f_string_width, tFunc(tString,tOr3("\10\0\0\0\10\0\0\0\10","\10\0\0\0\20\0\0\0\20","\10\0\0\0\40\0\0\0\40")), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_width_defined */

#ifdef f_m_delete_defined
#line 796 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("m_delete", f_m_delete, tFunc(tOr(tObj,tMapping) tMix,tMix), OPT_SIDE_EFFECT);

#endif /* f_m_delete_defined */

#ifdef f_get_weak_flag_defined
#line 847 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("get_weak_flag", f_get_weak_flag, tOr3(tFunc(tArray,"\10\200\0\0\0\177\377\377\377"),tFunc(tMapping,"\10\200\0\0\0\177\377\377\377"),tFunc(tMultiset,"\10\200\0\0\0\177\377\377\377")), OPT_EXTERNAL_DEPEND);

#endif /* f_get_weak_flag_defined */

#ifdef f_cq___empty_program_defined
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("__empty_program", f_cq___empty_program, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid) tOr(tString,tVoid),tPrg(tObj)), OPT_EXTERNAL_DEPEND);

#endif /* f_cq___empty_program_defined */

#ifdef f_function_name_defined
#line 879 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("function_name", f_function_name, tFunc(tOr(tPrg(tObj),tFuncV(tNone,tMix,tAny)),tString), OPT_TRY_OPTIMIZE);

#endif /* f_function_name_defined */

#ifdef f_function_object_defined
#line 962 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("function_object", f_function_object, tFunc(tFuncV(tNone,tMix,tAny),tObj), OPT_TRY_OPTIMIZE);

#endif /* f_function_object_defined */

#ifdef f_function_program_defined
#line 1004 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("function_program", f_function_program, tFunc(tOr(tPrg(tObj),tFuncV(tNone,tMix,tAny)),tPrg(tObj)), OPT_TRY_OPTIMIZE);

#endif /* f_function_program_defined */

#ifdef f_random_defined
#line 1135 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("random", f_random, tOr6(tFunc(tObj,tMix),tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"),tFunc(tFloat,tFloat),tFunc(tArr(tSetvar(0,tMix)),tVar(0)),tFunc(tSet(tSetvar(1,tMix)),tVar(1)),tFunc(tMapping,tArray)), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_random_defined */

#ifdef f_backtrace_defined
#line 1583 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("backtrace", f_backtrace, tFunc(tNone,tArray), OPT_EXTERNAL_DEPEND);

#endif /* f_backtrace_defined */

#ifdef f_cq___automap___defined
#line 2872 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
  ADD_EFUN("__automap__", f_cq___automap__, tFuncV(tMix,tMix,tArray), 0);

#endif /* f_cq___automap___defined */
#line 2898 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

void exit_builtin(void)
{

#ifdef class_backtrace_frame_defined
  if(backtrace_frame_program) {
    free_program(backtrace_frame_program);
    backtrace_frame_program=0;
  }

#endif /* class_backtrace_frame_defined */

#ifdef class_Buffer_defined
  if(Buffer_program) {
    free_program(Buffer_program);
    Buffer_program=0;
  }

#endif /* class_Buffer_defined */

#ifdef class_multi_string_replace_defined
  if(multi_string_replace_program) {
    free_program(multi_string_replace_program);
    multi_string_replace_program=0;
  }

#endif /* class_multi_string_replace_defined */

#ifdef class_single_string_replace_defined
  if(single_string_replace_program) {
    free_program(single_string_replace_program);
    single_string_replace_program=0;
  }

#endif /* class_single_string_replace_defined */

#ifdef class_bootstring_defined
  if(bootstring_program) {
    free_program(bootstring_program);
    bootstring_program=0;
  }

#endif /* class_bootstring_defined */

#ifdef class_Time_defined
  if(Time_program) {
    free_program(Time_program);
    Time_program=0;
  }

#endif /* class_Time_defined */

#ifdef class_Timer_defined
  if(Timer_program) {
    free_program(Timer_program);
    Timer_program=0;
  }

#endif /* class_Timer_defined */

#ifdef class_automap_marker_defined
  if(automap_marker_program) {
    free_program(automap_marker_program);
    automap_marker_program=0;
  }

#endif /* class_automap_marker_defined */
#line 2903 "/tmp/pikedeb.ea910e171c/7.6/src/builtin.cmod"
}

