/* Generated from "Node.cmod" by precompile.pike
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 2


#line 1 "Node.cmod"
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Node.cmod,v 1.34 2005/10/19 20:03:41 hww3 Exp $
 */

/*
 * File licensing and authorship information block.
 *
 * Version: MPL 1.1/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 *
 * Bill Welliver <hww3@riverweb.com>
 *
 * Portions created by the Initial Developer are Copyright (C) Bill Welliver
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the LGPL, and not to allow others to use your version
 * of this file under the terms of the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL or the LGPL.
 *
 * Significant Contributors to this file are:
 *
 *
 */

#define THIS_IS_XML2_NODE 1

#include "xml2.h"

/*! @module Public
 */

/*! @module Parser
 */

/*! @module XML2
 */

/*! @class Node
 */


#undef class_Node_defined
#define class_Node_defined
struct program *Node_program=NULL;
static int Node_program_fun_num=-1;

#undef var_object_data_Node_defined
#define var_object_data_Node_defined

#undef THIS
#define THIS ((struct Node_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_NODE
#define THIS_NODE ((struct Node_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_NODE
#define OBJ2_NODE(o) ((struct Node_struct *)(o->storage+Node_storage_offset))

#undef GET_NODE_STORAGE
#define GET_NODE_STORAGE ((struct Node_struct *)(o->storage+Node_storage_offset)
static ptrdiff_t Node_storage_offset;
struct Node_struct {

#ifdef var_object_data_Node_defined
#line 79 "Node.cmod"
NODE_OBJECT_DATA   *object_data;
#endif /* var_object_data_Node_defined */
};
#define f_Node_cq__sprintf_defined
ptrdiff_t f_Node_cq__sprintf_fun_num = 0;
void f_Node_cq__sprintf(INT32 args) {
#line 81 "Node.cmod"
INT_TYPE type;
#line 81 "Node.cmod"
struct svalue * t;
#line 81 "Node.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 81 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
type=Pike_sp[0-2].u.integer;
#line 81 "Node.cmod"
t=Pike_sp+1-2; dmalloc_touch_svalue(Pike_sp+1-2);
{
  char * desc;

  check_node_created();
  if(MY_NODE->name == NULL)
  {
    pop_n_elems(args);
    push_text("Node(UNKNOWN)");
    return;    
  }
  desc = malloc(strlen(MY_NODE->name) + 15);

  if(desc == NULL)
    Pike_error("Unable to allocate memory!\n");

  snprintf(desc, strlen(MY_NODE->name)+15, "Node(%d, %s)", 
    MY_NODE->type, (char *)(MY_NODE->name));

  pop_n_elems(args);
  
  push_text(desc);
}

}
#define f_Node_create_defined
ptrdiff_t f_Node_create_fun_num = 0;
void f_Node_create(INT32 args) {
#line 105 "Node.cmod"
if(args != 0) wrong_number_of_args_error("create",args,0);
{
}

}
/*! @decl int get_line_no()
 *! @returns 
 *!   the line number the node is present on
 */
#define f_Node_get_line_no_defined
ptrdiff_t f_Node_get_line_no_fun_num = 0;
void f_Node_get_line_no(INT32 args) {
#line 113 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_line_no",args,0);
{
  check_node_created();

  push_int(MY_NODE->line);
}

}
/*! @decl Node set_ns(string ns_uri)
 *!
 *! sets the default namespace for a node.
 *! the namespace must be already added to the node using @[add_ns]
 */
#define f_Node_set_ns_defined
ptrdiff_t f_Node_set_ns_fun_num = 0;
void f_Node_set_ns(INT32 args) {
#line 125 "Node.cmod"
struct pike_string * ns_uri;
#line 125 "Node.cmod"
if(args != 1) wrong_number_of_args_error("set_ns",args,1);
#line 125 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_ns",1,"string");
#line 125 "Node.cmod"
debug_malloc_pass(ns_uri=Pike_sp[0-1].u.string);
{
  xmlNsPtr ans;

  f_convert_string_utf8(1);  
  
  ns_uri = Pike_sp[-1].u.string;
  ans = xmlSearchNsByHref(MY_NODE->doc, MY_NODE, (xmlChar *)ns_uri->str);
  if(ans == NULL)
  {
    Pike_error("Namespace %s does not yet exist.\n", ns_uri->str);
  }

  xmlSetNs(MY_NODE, ans);

  pop_stack();

  push_object(this_object());
}

}
/*! @decl Node set_content(string content)
 *!
 *! sets the content for a node
 *!
 */
#define f_Node_set_content_defined
ptrdiff_t f_Node_set_content_fun_num = 0;
void f_Node_set_content(INT32 args) {
#line 150 "Node.cmod"
struct pike_string * content;
#line 150 "Node.cmod"
if(args != 1) wrong_number_of_args_error("set_content",args,1);
#line 150 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_content",1,"string");
#line 150 "Node.cmod"
debug_malloc_pass(content=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  xmlNodeSetContentLen(MY_NODE, (xmlChar *)content->str, content->len);
  
  push_object(this_object());

}

}
/*! @decl Node add_content(string content)
 *!
 *! appends the content for a node
 *!
 */
#define f_Node_add_content_defined
ptrdiff_t f_Node_add_content_fun_num = 0;
void f_Node_add_content(INT32 args) {
#line 168 "Node.cmod"
struct pike_string * content;
#line 168 "Node.cmod"
if(args != 1) wrong_number_of_args_error("add_content",args,1);
#line 168 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("add_content",1,"string");
#line 168 "Node.cmod"
debug_malloc_pass(content=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  xmlNodeAddContentLen(MY_NODE, (xmlChar *)content->str, content->len);
  
  push_object(this_object());

}

}
/*! @decl string get_text()
 *!
 *! gets the contents of a text node, or the contents and children of an 
 *! element, or the value of an attribute node.
 */
#define f_Node_get_text_defined
ptrdiff_t f_Node_get_text_fun_num = 0;
void f_Node_get_text(INT32 args) {
#line 186 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_text",args,0);
{
  xmlChar * val;
  check_node_created();
  val = xmlNodeGetContent(MY_NODE);

  if(val == NULL)
    push_int(0);
  else
  {
    push_text(val);
    f_convert_utf8_string(1);
  }
}

}
/*! @decl string get_node_path()
 *!
 *! returns an XPath/XQuery based path for this Node.
 */
#define f_Node_get_node_path_defined
ptrdiff_t f_Node_get_node_path_fun_num = 0;
void f_Node_get_node_path(INT32 args) {
#line 205 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_node_path",args,0);
{
  xmlChar * val;
  check_node_created();
  val = xmlGetNodePath(MY_NODE);

  if(val == NULL)
    push_int(0);
  else
  {
    push_text(val);
    f_convert_utf8_string(1);
  }
}

}
/*! @decl string get_ns()
 *!  returns the default name space uri for the element
 */
#define f_Node_get_ns_defined
ptrdiff_t f_Node_get_ns_fun_num = 0;
void f_Node_get_ns(INT32 args) {
#line 223 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_ns",args,0);
{
  char * str;

  check_node_created();
  if(MY_NODE->ns != NULL)
  {
    str = xmlStrdup(MY_NODE->ns->href);
    push_text(str);    
    f_convert_utf8_string(1);
  }
  else push_int(0);
}

}
/*! @decl mapping get_nss()
 *!   gets a list of all known namespaces for this element.
 *! @returns
 *!    a mapping of "short" prefixes to namespace uris.
 */
#define f_Node_get_nss_defined
ptrdiff_t f_Node_get_nss_fun_num = 0;
void f_Node_get_nss(INT32 args) {
#line 242 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_nss",args,0);
{
  xmlNsPtr * list;
  xmlNsPtr  ns;
  int num_ns = 0;

  check_node_created();
  list =  xmlGetNsList(MY_NODE->doc, MY_NODE);

  if(list == NULL)
  {
    push_int(0); 
    return;
  }   

  for(ns = * list; (ns!=NULL); ns = ns->next)
  {
    if(ns->prefix==NULL)
      push_text("_default");
    else 
      push_text(ns->prefix);
    f_convert_utf8_string(1);

    push_text(ns->href);
    f_convert_utf8_string(1);

    num_ns++;
  }
  f_aggregate_mapping(num_ns*2);
}

}
/*! @decl string get_base()
 *!
 */
#define f_Node_get_base_defined
ptrdiff_t f_Node_get_base_fun_num = 0;
void f_Node_get_base(INT32 args) {
#line 276 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_base",args,0);
{
  xmlChar * val;
  check_node_created();
  val = xmlNodeGetBase(MY_NODE->doc, MY_NODE);

  if(val == NULL)
    push_int(0);
  else
  {
    push_text(val);
    f_convert_utf8_string(1);
  }
}

}
/*! @decl string get_lang()
 *!
 */
#define f_Node_get_lang_defined
ptrdiff_t f_Node_get_lang_fun_num = 0;
void f_Node_get_lang(INT32 args) {
#line 294 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_lang",args,0);
{
  xmlChar * val;
  check_node_created();
  val = xmlNodeGetLang(MY_NODE);

  if(val == NULL)
    push_int(0);
  else
  {
    push_text(val);
    f_convert_utf8_string(1);
  }
}

}
/*! @decl int get_space_preserve()
 *!
 */
#define f_Node_get_space_preserve_defined
ptrdiff_t f_Node_get_space_preserve_fun_num = 0;
void f_Node_get_space_preserve(INT32 args) {
#line 312 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_space_preserve",args,0);
{
  int i;
  check_node_created();
  i = xmlNodeGetSpacePreserve(MY_NODE);

    push_int(i);
}


}
/*! @decl mapping get_attributes()
 *!   returns all attributes, irrespective of namespace
 *! @returns
 *!   a mapping of attribute name to attribute value.
 */
#define f_Node_get_attributes_defined
ptrdiff_t f_Node_get_attributes_fun_num = 0;
void f_Node_get_attributes(INT32 args) {
#line 327 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_attributes",args,0);
{
  struct _xmlAttr * attr;
  int num_attrs = 0;

  check_node_created();
  /* only element nodes have attributes. */
  if(MY_NODE->type != XML_ELEMENT_NODE)
  {
    push_int(0);
    return;
  }
  else
  {
    attr = MY_NODE->properties;

    for(attr; attr!=NULL; attr = attr->next)
    {
      xmlChar * val = NULL;
      if(attr==NULL) break;

      val = xmlGetProp(MY_NODE, attr->name);

      if(val == NULL) val = "";

      push_text((char *)(attr->name));
      f_convert_utf8_string(1);
    
      push_text((char *)(val));
      f_convert_utf8_string(1);

      xmlFree(val);

      num_attrs ++;
    }
   
   f_aggregate_mapping(num_attrs*2);

   }
    return;
}

}
/*! @decl mapping get_no_ns_attributes()
 *!   returns all attributes not present in a namespace
 *! @returns
 *!   a mapping of attribute name to attribute value.
 */
#define f_Node_get_no_ns_attributes_defined
ptrdiff_t f_Node_get_no_ns_attributes_fun_num = 0;
void f_Node_get_no_ns_attributes(INT32 args) {
#line 374 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_no_ns_attributes",args,0);
{
  struct _xmlAttr * attr;
  int num_attrs = 0;

  check_node_created();
  /* only element nodes have attributes. */
  if(MY_NODE->type != XML_ELEMENT_NODE)
  {
    push_int(0);
    return;
  }
  else
  {
    attr = MY_NODE->properties;

    for(attr; attr!=NULL; attr = attr->next)
    {
      xmlChar * val = NULL;
      if(attr==NULL) break;
      if(attr->ns == NULL) continue;

      val = xmlGetNoNsProp(MY_NODE, attr->name);

      if(val != NULL) 
      {
        push_text((char *)(attr->name));
        f_convert_utf8_string(1);

        push_text((char *)(val));
        f_convert_utf8_string(1);
        num_attrs ++;
      }
    }
   
   f_aggregate_mapping(num_attrs*2);

   }
    return;
}

}
/*! @decl mapping get_ns_attributes(string ns_uri)
 *!   given a namespace uri, return all elements for that namespace
 *!   present in the element.
 *! @returns
 *!    a mapping of attribute names to attribute values.
 */
#define f_Node_get_ns_attributes_defined
ptrdiff_t f_Node_get_ns_attributes_fun_num = 0;
void f_Node_get_ns_attributes(INT32 args) {
#line 421 "Node.cmod"
struct pike_string * ns_uri;
#line 421 "Node.cmod"
if(args != 1) wrong_number_of_args_error("get_ns_attributes",args,1);
#line 421 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("get_ns_attributes",1,"string");
#line 421 "Node.cmod"
debug_malloc_pass(ns_uri=Pike_sp[0-1].u.string);
{
  struct _xmlAttr * attr;
  int num_attrs = 0;

  check_node_created();

  f_convert_string_utf8(1);
  ns_uri = Pike_sp[-1].u.string;

  /* only element nodes have attributes. */
  if(MY_NODE->type != XML_ELEMENT_NODE)
  {
    push_int(0);
    return;
  }
  else
  {
    attr = MY_NODE->properties;

    for(attr; attr!=NULL; attr = attr->next)
    {
      xmlChar * val = NULL;
      xmlNs * ns = NULL;
      if(attr==NULL) break;
      ns = attr->ns;
      if(ns==NULL) 
      {
        /* no namespace for this attribute. */
        continue;
      }

      if(strcmp(ns_uri->str, ns->href)!=0) continue;
      val = xmlGetProp(MY_NODE, attr->name);

      if(val == NULL) val = "";

      push_text((char *)(attr->name));
      f_convert_utf8_string(1);

      push_text((char *)(val));
      f_convert_utf8_string(1);

      xmlFree(val);
      num_attrs ++;
    }
   
   f_aggregate_mapping(num_attrs*2);

   }
    return;
}

}
/*!  @decl array children()
 *!     get all children of this node
 *!  @returns
 *!      an array of all elements with are a direct child of this element.
 */
#define f_Node_children_defined
ptrdiff_t f_Node_children_fun_num = 0;
void f_Node_children(INT32 args) {
#line 479 "Node.cmod"
if(args != 0) wrong_number_of_args_error("children",args,0);
#line 481 "Node.cmod"
{
  struct object * o;
  xmlNode *cur_node = NULL;
  int num_children=0;
  check_node_created();

  if(MY_NODE->children != NULL)
    cur_node = MY_NODE->children;

  for(cur_node; cur_node; cur_node = cur_node->next) {
    if (cur_node != NULL) {
      o = NEW_NODE();
      OBJ2_NODE(o)->object_data->node = cur_node; 
      OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
      NEW_NODE_REFS(o);
      push_object(o);
      num_children++;
    }
  }
  if(num_children>0)
    f_aggregate(num_children);
  else push_int(0);
}

}
/*!  @decl Node parent()
 *!     get the Node which is the parent of this Node.
 */
#define f_Node_parent_defined
ptrdiff_t f_Node_parent_fun_num = 0;
void f_Node_parent(INT32 args) {
#line 508 "Node.cmod"
if(args != 0) wrong_number_of_args_error("parent",args,0);
{
  struct object * o;
  check_node_created();
  if(MY_NODE->parent == NULL)
  {
    push_int(0);
    return;
  }

  else 
  {
    o=NEW_NODE();
    OBJ2_NODE(o)->object_data->node = MY_NODE->parent;
    NEW_NODE_REFS(o);
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    push_object(o);
  }
}

}
/*!  @decl Node replace()
 *!     replace this node with a different node. if the new node was 
 *!     already inserted into a document, it is first unlinked from
 *!     its original document.
 *!  @returns
 *!     the old node
 */
#define f_Node_replace_defined
ptrdiff_t f_Node_replace_fun_num = 0;
void f_Node_replace(INT32 args) {
#line 535 "Node.cmod"
struct object * newnode;
#line 535 "Node.cmod"
if(args != 1) wrong_number_of_args_error("replace",args,1);
#line 535 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("replace",1,"object");
#line 535 "Node.cmod"
debug_malloc_pass(newnode=Pike_sp[0-1].u.object);
{
  struct object * o;
  xmlNodePtr node;

  CHECK_NODE_PASSED(newnode);

  check_node_created();

  node = xmlReplaceNode(THIS->object_data->node, OBJ2_NODE(o)->object_data->node);  

  OBJ2_NODE(newnode)->object_data->unlinked = 0;

  o=NEW_NODE();
  OBJ2_NODE(o)->object_data->node = node; 
  OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
  OBJ2_NODE(o)->object_data->unlinked = 1;
  NEW_NODE_REFS(o);
  pop_stack();
  push_object(o);
}

}
/*!  @decl Node copy(void|int extended)
 *!
 *!   copy a node
 *!
 *!  @param extended
 *!    if 1 do a recursive copy (properties, namespaces and children when 
 *!    applicable) if 2 copy properties and namespaces (when applicable)
 *!
 *!  @returns
 *!    the newly copied node.
 */

#define f_Node_copy_1_defined
ptrdiff_t f_Node_copy_1_fun_num = 0;
void f_Node_copy_1(INT32 args) {
#line 569 "Node.cmod"
if(args != 0) wrong_number_of_args_error("copy",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  node = xmlCopyNode(THIS->object_data->node, 0);

  o=NEW_NODE();
  OBJ2_NODE(o)->object_data->node = node;
  OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
  OBJ2_NODE(o)->object_data->unlinked = 1;
  NEW_NODE_REFS(o);
  push_object(o);
}

}
#define f_Node_copy_2_defined
ptrdiff_t f_Node_copy_2_fun_num = 0;
void f_Node_copy_2(INT32 args) {
#line 586 "Node.cmod"
INT_TYPE extended;
#line 586 "Node.cmod"
if(args != 1) wrong_number_of_args_error("copy",args,1);
#line 586 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("copy",1,"int");
extended=Pike_sp[0-1].u.integer;
#line 587 "Node.cmod"
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  node = xmlCopyNode(THIS->object_data->node, extended); 

  o=NEW_NODE();
  OBJ2_NODE(o)->object_data->node = node;
  OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
  OBJ2_NODE(o)->object_data->unlinked = 1;
  NEW_NODE_REFS(o);
  push_object(o);
}

}

#if defined(f_Node_copy_1_defined) || defined(f_Node_copy_2_defined)
#define f_Node_copy_defined
ptrdiff_t Node_f_Node_copy_fun_num = 0;
void f_Node_copy(INT32 args) {
  switch(args) {
   case 0:

#ifdef f_Node_copy_1_defined
    f_Node_copy_1(args);
    return;

#endif /* f_Node_copy_1_defined */
    break;
   case 1:

#ifdef f_Node_copy_2_defined
    f_Node_copy_2(args);
    return;

#endif /* f_Node_copy_2_defined */
    break;
   default:
    wrong_number_of_args_error("copy",args,0);
  }
}

#endif /* f_Node_copy_1_defined, f_Node_copy_2_defined */
/*!  @decl Node copy_list()
 *!
 *!   recursively copy a node list
 *!
 *!  @returns
 *!    the newly copied node.
 */
#define f_Node_copy_list_defined
ptrdiff_t f_Node_copy_list_fun_num = 0;
void f_Node_copy_list(INT32 args) {
#line 610 "Node.cmod"
if(args != 0) wrong_number_of_args_error("copy_list",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  node = xmlCopyNodeList(THIS->object_data->node); 

  o=NEW_NODE();
  OBJ2_NODE(o)->object_data->node = node;
  OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
  OBJ2_NODE(o)->object_data->unlinked = 1;
  NEW_NODE_REFS(o);
  push_object(o);
}

}
/*!  @decl Node unlink()
 *!
 *!  unlink a node from its current context. the node not freed.
 *!  to unlink and destroy the node, use @[delete].
 *!
 *!  @returns
 *!    the unlinked node.
 */
#define f_Node_unlink_defined
ptrdiff_t f_Node_unlink_fun_num = 0;
void f_Node_unlink(INT32 args) {
#line 635 "Node.cmod"
if(args != 0) wrong_number_of_args_error("unlink",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  xmlUnlinkNode(THIS->object_data->node); 

  THIS->object_data->unlinked = 1;
  push_object(this_object());
}

}
/*!  @decl void delete()
 *!
 *!  unlink a node and remove it (and its children) from memory
 */
#define f_Node_delete_defined
ptrdiff_t f_Node_delete_fun_num = 0;
void f_Node_delete(INT32 args) {
#line 652 "Node.cmod"
if(args != 0) wrong_number_of_args_error("delete",args,0);
{
  xmlNodePtr node;

  check_node_created();

  xmlUnlinkNode(THIS->object_data->node); 
  xmlFreeNode(THIS->object_data->node);

  THIS->object_data->node = NULL;  

  pop_stack();
}

}
/*!  @decl Node get_root_node()
 *!     get the Node which is the root of this tree.
 */
#define f_Node_get_root_node_defined
ptrdiff_t f_Node_get_root_node_fun_num = 0;
void f_Node_get_root_node(INT32 args) {
#line 669 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_root_node",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();
  
  node = xmlDocGetRootElement(MY_NODE->doc);
  if(node == NULL)
  {
    push_int(0);
    return;
  }

  else 
  {
    o=NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node set_root_node()
 *!     set this Node to be the root of this tree.
 *!  @returns
 *!     the old root of the tree, if any existed.
 */
#define f_Node_set_root_node_defined
ptrdiff_t f_Node_set_root_node_fun_num = 0;
void f_Node_set_root_node(INT32 args) {
#line 698 "Node.cmod"
if(args != 0) wrong_number_of_args_error("set_root_node",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();
  
  node = xmlDocSetRootElement(MY_NODE->doc, MY_NODE);
  if(node == NULL)
  {
    push_int(0);
    return;
  }

  else 
  {
    o=NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    NEW_NODE_REFS(o);
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    push_object(o);
  }
}

}
/*!  @decl Node new_cdata_block(string contents)
 *!     returns an unlinked CDATA block.
 */
#define f_Node_new_cdata_block_defined
ptrdiff_t f_Node_new_cdata_block_fun_num = 0;
void f_Node_new_cdata_block(INT32 args) {
#line 725 "Node.cmod"
struct pike_string * contents;
#line 725 "Node.cmod"
if(args != 1) wrong_number_of_args_error("new_cdata_block",args,1);
#line 725 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_cdata_block",1,"string");
#line 725 "Node.cmod"
debug_malloc_pass(contents=Pike_sp[0-1].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  contents = Pike_sp[-1].u.string;

  node = xmlNewCDataBlock(MY_NODE->doc, contents->str, contents->len);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->unlinked = 1;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
   NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node new_pi(string name, string contents)
 *!     returns an unlinked Processing Instruction node.
 */
#define f_Node_new_pi_defined
ptrdiff_t f_Node_new_pi_fun_num = 0;
void f_Node_new_pi(INT32 args) {
#line 756 "Node.cmod"
struct pike_string * name;
#line 756 "Node.cmod"
struct pike_string * contents;
#line 756 "Node.cmod"
if(args != 2) wrong_number_of_args_error("new_pi",args,2);
#line 756 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_pi",1,"string");
#line 756 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-2].u.string);
#line 756 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_pi",2,"string");
#line 756 "Node.cmod"
debug_malloc_pass(contents=Pike_sp[1-2].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  contents = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

#ifdef HAVE_XMLNEWDOCPI
  node = xmlNewDocPI(MY_NODE->doc, name->str, contents->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 1;
    NEW_NODE_REFS(o);
    push_object(o);
  }

#else
  Pike_error("new_pi() is not available. please upgrade your libxslt.\n");
#endif /* HAVE_XMLNEWDOCPI */

}

}
/*!  @decl Node set_attribute(string name, string value)
 *!  @decl Node set_attribute(string name, string ns_uri, string value)
 *!
 *!  @param ns_uri
 *!   the namespace uri
 *!
 *!  sets a new attribute, overwriting any existing value.
 *!  if @[value] is zero, the attribute will be removed from the node.
 */
#define f_Node_set_attribute_1_defined
ptrdiff_t f_Node_set_attribute_1_fun_num = 0;
void f_Node_set_attribute_1(INT32 args) {
#line 804 "Node.cmod"
struct pike_string * name;
#line 804 "Node.cmod"
struct pike_string * ns_uri;
#line 804 "Node.cmod"
struct pike_string * value;
#line 804 "Node.cmod"
if(args != 3) wrong_number_of_args_error("set_attribute",args,3);
#line 804 "Node.cmod"
if(Pike_sp[0-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_attribute",1,"string");
#line 804 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-3].u.string);
#line 804 "Node.cmod"
if(Pike_sp[1-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_attribute",2,"string");
#line 804 "Node.cmod"
debug_malloc_pass(ns_uri=Pike_sp[1-3].u.string);
#line 804 "Node.cmod"
if(Pike_sp[2-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_attribute",3,"string");
#line 804 "Node.cmod"
debug_malloc_pass(value=Pike_sp[2-3].u.string);
{
  struct object * o;
  xmlAttrPtr attr;
  xmlNsPtr ans;

  check_node_created();

  f_convert_string_utf8(1);
  value = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  ns_uri = Pike_sp[-1].u.string;

  stack_swap_n(3);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  ans = xmlSearchNsByHref(MY_NODE->doc, MY_NODE, (xmlChar *)ns_uri->str);
  if(ans == NULL)
  {
    Pike_error("Namespace with URI %s does not exist.\n", ns_uri->str);
  }

  attr = xmlNewNsProp(MY_NODE, ans, (xmlChar *)name->str, (xmlChar *)value->str);

  if(attr == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    push_object(this_object());
  }
}

}
/*! @decl object delete_attribute(string name, string|void ns_uri)
 *!
 *! @param name
 *!   the name of the attribute to delete
 *!
 *! @param ns_uri
 *!   the URI of the namespace containing the attribute to be deleted 
 */
#define f_Node_delete_attribute_1_defined
ptrdiff_t f_Node_delete_attribute_1_fun_num = 0;
void f_Node_delete_attribute_1(INT32 args) {
#line 852 "Node.cmod"
struct pike_string * name;
#line 852 "Node.cmod"
if(args != 1) wrong_number_of_args_error("delete_attribute",args,1);
#line 852 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("delete_attribute",1,"string");
#line 852 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  xmlUnsetProp(MY_NODE, (xmlChar *)name->str);

  push_object(this_object());

}
}
#define f_Node_delete_attribute_2_defined
ptrdiff_t f_Node_delete_attribute_2_fun_num = 0;
void f_Node_delete_attribute_2(INT32 args) {
#line 864 "Node.cmod"
struct pike_string * name;
#line 864 "Node.cmod"
struct pike_string * ns_uri;
#line 864 "Node.cmod"
if(args != 2) wrong_number_of_args_error("delete_attribute",args,2);
#line 864 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("delete_attribute",1,"string");
#line 864 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-2].u.string);
#line 864 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("delete_attribute",2,"string");
#line 864 "Node.cmod"
debug_malloc_pass(ns_uri=Pike_sp[1-2].u.string);
{
  xmlNsPtr ans;

  check_node_created();

  f_convert_string_utf8(1);
  ns_uri = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  ans = xmlSearchNsByHref(MY_NODE->doc, MY_NODE, (xmlChar *)ns_uri->str);
  if(ans == NULL)
  {
    Pike_error("Namespace %s does not exist.\n", ns_uri->str);
  }

  xmlUnsetNsProp(MY_NODE, ans, (xmlChar *)name->str);

  push_object(this_object());

}

}

#if defined(f_Node_delete_attribute_1_defined) || defined(f_Node_delete_attribute_2_defined)
#define f_Node_delete_attribute_defined
ptrdiff_t Node_f_Node_delete_attribute_fun_num = 0;
void f_Node_delete_attribute(INT32 args) {
  switch(args) {
   case 1:

#ifdef f_Node_delete_attribute_1_defined
    f_Node_delete_attribute_1(args);
    return;

#endif /* f_Node_delete_attribute_1_defined */
    break;
   case 2:

#ifdef f_Node_delete_attribute_2_defined
    f_Node_delete_attribute_2(args);
    return;

#endif /* f_Node_delete_attribute_2_defined */
    break;
   default:
    wrong_number_of_args_error("delete_attribute",args,1);
  }
}

#endif /* f_Node_delete_attribute_1_defined, f_Node_delete_attribute_2_defined */
#define f_Node_set_attribute_2_defined
ptrdiff_t f_Node_set_attribute_2_fun_num = 0;
void f_Node_set_attribute_2(INT32 args) {
#line 890 "Node.cmod"
struct pike_string * name;
#line 890 "Node.cmod"
struct pike_string * value;
#line 890 "Node.cmod"
if(args != 2) wrong_number_of_args_error("set_attribute",args,2);
#line 890 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_attribute",1,"string");
#line 890 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-2].u.string);
#line 890 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_attribute",2,"string");
#line 890 "Node.cmod"
debug_malloc_pass(value=Pike_sp[1-2].u.string);
{
  struct object * o;
  xmlAttrPtr attr;
  xmlAttrPtr val;

  check_node_created();

  f_convert_string_utf8(1);
  value = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  xmlUnsetProp(MY_NODE, (xmlChar *)name->str);

  attr = xmlNewProp(MY_NODE, (xmlChar *)name->str, (xmlChar *)value->str);

  if(attr == NULL)
  {
    pop_n_elems(2);
    push_int(0);
    return;
  }
  else
  {
    pop_n_elems(2);
    push_object(this_object());
  }
}

}

#if defined(f_Node_set_attribute_1_defined) || defined(f_Node_set_attribute_2_defined)
#define f_Node_set_attribute_defined
ptrdiff_t Node_f_Node_set_attribute_fun_num = 0;
void f_Node_set_attribute(INT32 args) {
  switch(args) {
   case 2:

#ifdef f_Node_set_attribute_2_defined
    f_Node_set_attribute_2(args);
    return;

#endif /* f_Node_set_attribute_2_defined */
    break;
   case 3:

#ifdef f_Node_set_attribute_1_defined
    f_Node_set_attribute_1(args);
    return;

#endif /* f_Node_set_attribute_1_defined */
    break;
   default:
    wrong_number_of_args_error("set_attribute",args,2);
  }
}

#endif /* f_Node_set_attribute_1_defined, f_Node_set_attribute_2_defined */
/*!  @decl Node new_char_ref(string name)
 *!     returns an unlinked character reference node.
 */
#define f_Node_new_char_ref_defined
ptrdiff_t f_Node_new_char_ref_fun_num = 0;
void f_Node_new_char_ref(INT32 args) {
#line 926 "Node.cmod"
struct pike_string * name;
#line 926 "Node.cmod"
if(args != 1) wrong_number_of_args_error("new_char_ref",args,1);
#line 926 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_char_ref",1,"string");
#line 926 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-1].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  if(name->str[0] != '&' || name->str[0] != '#')
  {
    Pike_error("Invalid charater reference.\n");
  }

  node = xmlNewCharRef(MY_NODE->doc, name->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 1;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node new_comment(string content)
 *!     returns an unlinked comment node.
 */
#define f_Node_new_comment_defined
ptrdiff_t f_Node_new_comment_fun_num = 0;
void f_Node_new_comment(INT32 args) {
#line 962 "Node.cmod"
struct pike_string * content;
#line 962 "Node.cmod"
if(args != 1) wrong_number_of_args_error("new_comment",args,1);
#line 962 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_comment",1,"string");
#line 962 "Node.cmod"
debug_malloc_pass(content=Pike_sp[0-1].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  node = xmlNewComment(content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 1;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}


}
/*!  @decl Node new_doc_comment(string content)
 *!     returns an unlinked character reference node.
 */
#define f_Node_new_doc_comment_defined
ptrdiff_t f_Node_new_doc_comment_fun_num = 0;
void f_Node_new_doc_comment(INT32 args) {
#line 994 "Node.cmod"
struct pike_string * content;
#line 994 "Node.cmod"
if(args != 1) wrong_number_of_args_error("new_doc_comment",args,1);
#line 994 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_doc_comment",1,"string");
#line 994 "Node.cmod"
debug_malloc_pass(content=Pike_sp[0-1].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  node = xmlNewDocComment(MY_NODE->doc, content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 1;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}



}
/*!  @decl Node new_child(string|void ns, string name, string content)
 *!     add a new child element, added to end of children for this node.
 *! 
 *!   @param ns
 *!     the prefix of the namespace for the node (optional)
 *!   @seealso
 *!     new_text_child
 */
#define f_Node_new_child_1_defined
ptrdiff_t f_Node_new_child_1_fun_num = 0;
void f_Node_new_child_1(INT32 args) {
#line 1032 "Node.cmod"
struct pike_string * name;
#line 1032 "Node.cmod"
struct pike_string * content;
#line 1032 "Node.cmod"
if(args != 2) wrong_number_of_args_error("new_child",args,2);
#line 1032 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_child",1,"string");
#line 1032 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-2].u.string);
#line 1032 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_child",2,"string");
#line 1032 "Node.cmod"
debug_malloc_pass(content=Pike_sp[1-2].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  node = xmlNewTextChild(MY_NODE, NULL, name->str, content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
#define f_Node_new_child_2_defined
ptrdiff_t f_Node_new_child_2_fun_num = 0;
void f_Node_new_child_2(INT32 args) {
#line 1064 "Node.cmod"
struct pike_string * ns;
#line 1064 "Node.cmod"
struct pike_string * name;
#line 1064 "Node.cmod"
struct pike_string * content;
#line 1064 "Node.cmod"
if(args != 3) wrong_number_of_args_error("new_child",args,3);
#line 1064 "Node.cmod"
if(Pike_sp[0-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_child",1,"string");
#line 1064 "Node.cmod"
debug_malloc_pass(ns=Pike_sp[0-3].u.string);
#line 1064 "Node.cmod"
if(Pike_sp[1-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_child",2,"string");
#line 1064 "Node.cmod"
debug_malloc_pass(name=Pike_sp[1-3].u.string);
#line 1064 "Node.cmod"
if(Pike_sp[2-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_child",3,"string");
#line 1064 "Node.cmod"
debug_malloc_pass(content=Pike_sp[2-3].u.string);
{
  struct object * o;
  xmlNodePtr node;
  xmlNsPtr ans;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  stack_swap_n(3);

  f_convert_string_utf8(1);
  ns = Pike_sp[-1].u.string;

  ans = xmlSearchNs(MY_NODE->doc, MY_NODE, (xmlChar *)ns->str);
  if(ans == NULL)
  {
    Pike_error("Namespace with prefix %s does not yet exist.\n", ns->str);
  }

  node = xmlNewTextChild(MY_NODE, ans, name->str, content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}

#if defined(f_Node_new_child_1_defined) || defined(f_Node_new_child_2_defined)
#define f_Node_new_child_defined
ptrdiff_t Node_f_Node_new_child_fun_num = 0;
void f_Node_new_child(INT32 args) {
  switch(args) {
   case 2:

#ifdef f_Node_new_child_1_defined
    f_Node_new_child_1(args);
    return;

#endif /* f_Node_new_child_1_defined */
    break;
   case 3:

#ifdef f_Node_new_child_2_defined
    f_Node_new_child_2(args);
    return;

#endif /* f_Node_new_child_2_defined */
    break;
   default:
    wrong_number_of_args_error("new_child",args,2);
  }
}

#endif /* f_Node_new_child_1_defined, f_Node_new_child_2_defined */
/*!  @decl Node new_text_child(string|void ns, string name, string content)
 *!     add a new child element, added to end of children for this node.
 *!     differs from @[new_child] in that XML reserved entities present in
 *!     content (such as amersand, greater-than and less-than) will be 
 *!     automatically replaced by their XML escaped entity representations.
 *!   @param ns
 *!     the prefix of the namespace for the node (optional)
 *!   @seealso
 *!     new_child
 */
#define f_Node_new_text_child_1_defined
ptrdiff_t f_Node_new_text_child_1_fun_num = 0;
void f_Node_new_text_child_1(INT32 args) {
#line 1118 "Node.cmod"
struct pike_string * name;
#line 1118 "Node.cmod"
struct pike_string * content;
#line 1118 "Node.cmod"
if(args != 2) wrong_number_of_args_error("new_text_child",args,2);
#line 1118 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_text_child",1,"string");
#line 1118 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-2].u.string);
#line 1118 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_text_child",2,"string");
#line 1118 "Node.cmod"
debug_malloc_pass(content=Pike_sp[1-2].u.string);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  node = xmlNewChild(MY_NODE, NULL, name->str, content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
#define f_Node_new_text_child_2_defined
ptrdiff_t f_Node_new_text_child_2_fun_num = 0;
void f_Node_new_text_child_2(INT32 args) {
#line 1150 "Node.cmod"
struct pike_string * ns;
#line 1150 "Node.cmod"
struct pike_string * name;
#line 1150 "Node.cmod"
struct pike_string * content;
#line 1150 "Node.cmod"
if(args != 3) wrong_number_of_args_error("new_text_child",args,3);
#line 1150 "Node.cmod"
if(Pike_sp[0-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_text_child",1,"string");
#line 1150 "Node.cmod"
debug_malloc_pass(ns=Pike_sp[0-3].u.string);
#line 1150 "Node.cmod"
if(Pike_sp[1-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_text_child",2,"string");
#line 1150 "Node.cmod"
debug_malloc_pass(name=Pike_sp[1-3].u.string);
#line 1150 "Node.cmod"
if(Pike_sp[2-3].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("new_text_child",3,"string");
#line 1150 "Node.cmod"
debug_malloc_pass(content=Pike_sp[2-3].u.string);
{
  struct object * o;
  xmlNodePtr node;
  xmlNsPtr ans;

  check_node_created();

  f_convert_string_utf8(1);
  content = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  stack_swap_n(3);

  f_convert_string_utf8(1);
  ns = Pike_sp[-1].u.string;

  ans = xmlSearchNs(MY_NODE->doc, MY_NODE, (xmlChar *)ns->str);
  if(ans == NULL)
  {
    Pike_error("Namespace with prefix %s does not yet exist.\n", ns->str);
  }

  node = xmlNewChild(MY_NODE, ans, name->str, content->str);
  
  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}

#if defined(f_Node_new_text_child_1_defined) || defined(f_Node_new_text_child_2_defined)
#define f_Node_new_text_child_defined
ptrdiff_t Node_f_Node_new_text_child_fun_num = 0;
void f_Node_new_text_child(INT32 args) {
  switch(args) {
   case 2:

#ifdef f_Node_new_text_child_1_defined
    f_Node_new_text_child_1(args);
    return;

#endif /* f_Node_new_text_child_1_defined */
    break;
   case 3:

#ifdef f_Node_new_text_child_2_defined
    f_Node_new_text_child_2(args);
    return;

#endif /* f_Node_new_text_child_2_defined */
    break;
   default:
    wrong_number_of_args_error("new_text_child",args,2);
  }
}

#endif /* f_Node_new_text_child_1_defined, f_Node_new_text_child_2_defined */
/*! @decl Node add_ns(string href, string prefix)
 *!
 */
#define f_Node_add_ns_defined
ptrdiff_t f_Node_add_ns_fun_num = 0;
void f_Node_add_ns(INT32 args) {
#line 1197 "Node.cmod"
struct pike_string * href;
#line 1197 "Node.cmod"
struct pike_string * prefix;
#line 1197 "Node.cmod"
if(args != 2) wrong_number_of_args_error("add_ns",args,2);
#line 1197 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("add_ns",1,"string");
#line 1197 "Node.cmod"
debug_malloc_pass(href=Pike_sp[0-2].u.string);
#line 1197 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("add_ns",2,"string");
#line 1197 "Node.cmod"
debug_malloc_pass(prefix=Pike_sp[1-2].u.string);
{
  xmlNsPtr ns;

  check_node_created();

  f_convert_string_utf8(1);
  prefix = Pike_sp[-1].u.string;

  stack_swap_n(2);

  f_convert_string_utf8(1);
  href = Pike_sp[-1].u.string;

  ns = xmlNewNs(MY_NODE, (xmlChar *) href->str, (xmlChar *) prefix->str);

  if(ns == NULL)
  {
    Pike_error("Unable to create new namespace.\n");
  }

  push_object(this_object());
}

}
/*!  @decl Node add_child(Node child)
 *!     add a node to end of children for this node.
 */
#define f_Node_add_child_defined
ptrdiff_t f_Node_add_child_fun_num = 0;
void f_Node_add_child(INT32 args) {
#line 1224 "Node.cmod"
struct object * child;
#line 1224 "Node.cmod"
if(args != 1) wrong_number_of_args_error("add_child",args,1);
#line 1224 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("add_child",1,"object");
#line 1224 "Node.cmod"
debug_malloc_pass(child=Pike_sp[0-1].u.object);
{
  struct object * o;
  xmlNodePtr node;

  CHECK_NODE_PASSED(child);

  check_node_created();

  node = xmlAddChild(MY_NODE, OBJ2_NODE(child)->object_data->node);
  
  if(node == NULL || OBJ2_NODE(child)->object_data->node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    int refs;
    OBJ2_NODE(child)->object_data->unlinked = 0;

    /* Now, the previously unlinked node is now linked, so we
       should add the number of refs from the unlinked node to the 
       number on the node we added to (but only if the ref is not the same).
    */
    if((OBJ2_NODE(child)->object_data->refs) != (THIS->object_data->refs))
    {
      refs = (* OBJ2_NODE(child)->object_data->refs) + *(THIS->object_data->refs);
      OBJ2_NODE(child)->object_data->refs = THIS->object_data->refs;
      (*THIS->object_data->refs) = refs;
    }

    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->unlinked = 0;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node add_sibling(Node sibling)
 *!     add a node to end of siblings for this node.
 */
#define f_Node_add_sibling_defined
ptrdiff_t f_Node_add_sibling_fun_num = 0;
void f_Node_add_sibling(INT32 args) {
#line 1268 "Node.cmod"
struct object * sibling;
#line 1268 "Node.cmod"
if(args != 1) wrong_number_of_args_error("add_sibling",args,1);
#line 1268 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("add_sibling",1,"object");
#line 1268 "Node.cmod"
debug_malloc_pass(sibling=Pike_sp[0-1].u.object);
{
  struct object * o;
  xmlNodePtr node;

  CHECK_NODE_PASSED(sibling);
  check_node_created();

  node = xmlAddSibling(MY_NODE, OBJ2_NODE(sibling)->object_data->node);
  
  if(node == NULL || OBJ2_NODE(sibling)->object_data->node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    OBJ2_NODE(sibling)->object_data->unlinked = 0;
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 0;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node add_next_sibling(Node sibling)
 *!     add a sibling node after this node.
 */
#define f_Node_add_next_sibling_defined
ptrdiff_t f_Node_add_next_sibling_fun_num = 0;
void f_Node_add_next_sibling(INT32 args) {
#line 1298 "Node.cmod"
struct object * sibling;
#line 1298 "Node.cmod"
if(args != 1) wrong_number_of_args_error("add_next_sibling",args,1);
#line 1298 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("add_next_sibling",1,"object");
#line 1298 "Node.cmod"
debug_malloc_pass(sibling=Pike_sp[0-1].u.object);
{
  struct object * o;
  xmlNodePtr node;

  CHECK_NODE_PASSED(sibling);
  check_node_created();

  node = xmlAddNextSibling(MY_NODE, OBJ2_NODE(sibling)->object_data->node);
  
  if(node == NULL || OBJ2_NODE(sibling)->object_data->node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    OBJ2_NODE(sibling)->object_data->unlinked = 0;
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 0;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node add_prev_sibling(Node sibling)
 *!     add a sibling node after this node.
 */
#define f_Node_add_prev_sibling_defined
ptrdiff_t f_Node_add_prev_sibling_fun_num = 0;
void f_Node_add_prev_sibling(INT32 args) {
#line 1328 "Node.cmod"
struct object * sibling;
#line 1328 "Node.cmod"
if(args != 1) wrong_number_of_args_error("add_prev_sibling",args,1);
#line 1328 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_OBJECT) SIMPLE_BAD_ARG_ERROR("add_prev_sibling",1,"object");
#line 1328 "Node.cmod"
debug_malloc_pass(sibling=Pike_sp[0-1].u.object);
{
  struct object * o;
  xmlNodePtr node;

  CHECK_NODE_PASSED(sibling);
  check_node_created();

  node = xmlAddPrevSibling(MY_NODE, OBJ2_NODE(sibling)->object_data->node);
  
  if(node == NULL || OBJ2_NODE(sibling)->object_data->node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    OBJ2_NODE(sibling)->object_data->unlinked = 0;
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    OBJ2_NODE(o)->object_data->unlinked = 0;
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node get_last_child()
 *!     get the Node which is the last child of this Node.
 */
#define f_Node_get_last_child_defined
ptrdiff_t f_Node_get_last_child_fun_num = 0;
void f_Node_get_last_child(INT32 args) {
#line 1358 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_last_child",args,0);
{
  struct object * o;
  xmlNodePtr node;

  check_node_created();

  node = xmlGetLastChild(MY_NODE);

  if(node == NULL)
  {
    push_int(0);
    return;
  }
  else
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = node; 
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node next()
 *!  get the next sibling of this Node.
 *!  @returns
 *!    the next node which is a sibling of this node.
 */
#define f_Node_next_defined
ptrdiff_t f_Node_next_fun_num = 0;
void f_Node_next(INT32 args) {
#line 1387 "Node.cmod"
if(args != 0) wrong_number_of_args_error("next",args,0);
{
  struct object * o;
  check_node_created();
  if(MY_NODE->next == NULL)
  {
    push_int(0);
    return;
  }
	
  else 
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = MY_NODE->next;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*!  @decl Node prev()
 *!  get the previous sibling of this Node.
 *!  @returns
 *!    the previous node which is a sibling of this node.
 */
#define f_Node_prev_defined
ptrdiff_t f_Node_prev_fun_num = 0;
void f_Node_prev(INT32 args) {
#line 1412 "Node.cmod"
if(args != 0) wrong_number_of_args_error("prev",args,0);
{
  struct object * o;
    check_node_created();
  if(MY_NODE->prev == NULL)
  {
    push_int(0);
    return;
  }

  else 
  {
    o = NEW_NODE();
    OBJ2_NODE(o)->object_data->node = MY_NODE->prev;
    OBJ2_NODE(o)->object_data->parser = THIS->object_data->parser; 
    NEW_NODE_REFS(o);
    push_object(o);
  }
}

}
/*! @decl int is_blank()
 *!
 *!  is this node empty?
 */
#define f_Node_is_blank_defined
ptrdiff_t f_Node_is_blank_fun_num = 0;
void f_Node_is_blank(INT32 args) {
#line 1436 "Node.cmod"
if(args != 0) wrong_number_of_args_error("is_blank",args,0);
{
  check_node_created();

  do { INT_TYPE ret_=(xmlIsBlankNode(MY_NODE));  push_int(ret_); return; }while(0);
#line 1441 "Node.cmod"
}

}
/*! @decl int is_text()
 *! 
 *!  is this a text node?
 */
#define f_Node_is_text_defined
ptrdiff_t f_Node_is_text_fun_num = 0;
void f_Node_is_text(INT32 args) {
#line 1447 "Node.cmod"
if(args != 0) wrong_number_of_args_error("is_text",args,0);
{
  check_node_created();

  do { INT_TYPE ret_=(xmlNodeIsText(MY_NODE));  push_int(ret_); return; }while(0);
#line 1452 "Node.cmod"
}

}
/*!  @decl int get_node_type()
 *!
 *!  get the type of node.
 *!  
 *!  @returns
 *!   the integer node type. Node type constants are 
 *!   defined in @[Public.Parser.XML2.Constants].
 */
#define f_Node_get_node_type_defined
ptrdiff_t f_Node_get_node_type_fun_num = 0;
void f_Node_get_node_type(INT32 args) {
#line 1462 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_node_type",args,0);
{
  check_node_created();

  push_int((int)(MY_NODE->type));
}

}
/*! @decl string get_node_name()
 *!  gets the name of this node, if it has one.
 */
#define f_Node_get_node_name_defined
ptrdiff_t f_Node_get_node_name_fun_num = 0;
void f_Node_get_node_name(INT32 args) {
#line 1472 "Node.cmod"
if(args != 0) wrong_number_of_args_error("get_node_name",args,0);
{
  check_node_created();
  if((char *)(MY_NODE->name) != NULL)
  {
    push_text((char *)(MY_NODE->name));
    f_convert_utf8_string(1);
  }
  else push_int(0);
} 

}
/*! @decl object set_node_name(string name)
 *!  sets the name of this node.
 */
#define f_Node_set_node_name_defined
ptrdiff_t f_Node_set_node_name_fun_num = 0;
void f_Node_set_node_name(INT32 args) {
#line 1486 "Node.cmod"
struct pike_string * name;
#line 1486 "Node.cmod"
if(args != 1) wrong_number_of_args_error("set_node_name",args,1);
#line 1486 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_node_name",1,"string");
#line 1486 "Node.cmod"
debug_malloc_pass(name=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  name = Pike_sp[-1].u.string;

  xmlNodeSetName(MY_NODE, (xmlChar *)name->str);

  push_object(this_object());
} 

}
/*! @decl object set_lang(string language)
 *!  sets the language of this node.
 */
#define f_Node_set_lang_defined
ptrdiff_t f_Node_set_lang_fun_num = 0;
void f_Node_set_lang(INT32 args) {
#line 1501 "Node.cmod"
struct pike_string * language;
#line 1501 "Node.cmod"
if(args != 1) wrong_number_of_args_error("set_lang",args,1);
#line 1501 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_lang",1,"string");
#line 1501 "Node.cmod"
debug_malloc_pass(language=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  language = Pike_sp[-1].u.string;

  xmlNodeSetLang(MY_NODE, (xmlChar *)language->str);

  push_object(this_object());
} 

}
/*! @decl object set_base(string uri)
 *!  sets the base URI of this node.
 */
#define f_Node_set_base_defined
ptrdiff_t f_Node_set_base_fun_num = 0;
void f_Node_set_base(INT32 args) {
#line 1516 "Node.cmod"
struct pike_string * uri;
#line 1516 "Node.cmod"
if(args != 1) wrong_number_of_args_error("set_base",args,1);
#line 1516 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_base",1,"string");
#line 1516 "Node.cmod"
debug_malloc_pass(uri=Pike_sp[0-1].u.string);
{
  check_node_created();

  f_convert_string_utf8(1);
  uri = Pike_sp[-1].u.string;

  xmlNodeSetBase(MY_NODE, (xmlChar *)uri->str);

  push_object(this_object());
} 

}
/*! @decl string render_xml(int level, int format)
 *!
 *! renders the node and all children as xml (which will be encoded as UTF-8 by default). 
 *!
 *! @param level
 *!   the indentation level to use
 *!
 *! @param format
 *!    should the xml be formated for ease of human reading.
 *!    this setting only takes 	effect if 
 *!    Public.Parser.XML2.xmlKeepBlanksDefault(0) has been called.
 */
#define f_Node_render_xml_defined
ptrdiff_t f_Node_render_xml_fun_num = 0;
void f_Node_render_xml(INT32 args) {
#line 1540 "Node.cmod"
INT_TYPE level;
#line 1540 "Node.cmod"
INT_TYPE format;
#line 1540 "Node.cmod"
if(args != 2) wrong_number_of_args_error("render_xml",args,2);
#line 1540 "Node.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("render_xml",1,"int");
level=Pike_sp[0-2].u.integer;
#line 1540 "Node.cmod"
if(Pike_sp[1-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("render_xml",2,"int");
format=Pike_sp[1-2].u.integer;
#line 1541 "Node.cmod"
{
  int dumped;
  xmlBufferPtr buf;
  char * str;

  check_node_created();
  buf = xmlBufferCreate();
  dumped = xmlNodeDump(buf, MY_NODE->doc, MY_NODE, level, format);

  if(dumped>0)
  {
    str = (char *)xmlStrdup(buf->content);
    xmlBufferFree(buf);
    push_text(str);
  }
  
}

}
/*! @decl string render_html()
 *!
 *! renders the node and all children as html (which will be encoded as UTF-8 by default). 
 *!
 */
#define f_Node_render_html_defined
ptrdiff_t f_Node_render_html_fun_num = 0;
void f_Node_render_html(INT32 args) {
#line 1564 "Node.cmod"
if(args != 0) wrong_number_of_args_error("render_html",args,0);
{
  int dumped;
  xmlBufferPtr buf;
  char * str;

  check_node_created();
  buf = xmlBufferCreate();
  dumped = htmlNodeDump(buf, MY_NODE->doc, MY_NODE);

  if(dumped>0)
  {
    str = (char *)xmlStrdup(buf->content);
    xmlBufferFree(buf);
    push_text(str);

  }
  
}

}
#define f_Node_cast_defined
ptrdiff_t f_Node_cast_fun_num = 0;
void f_Node_cast(INT32 args) {
#line 1584 "Node.cmod"
struct pike_string * type;
#line 1584 "Node.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 1584 "Node.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 1584 "Node.cmod"
debug_malloc_pass(type=Pike_sp[0-1].u.string);
{
  if(strcmp(type->str, "string") == 0)
  { 
    pop_stack();
    push_int(1);
    push_int(1);
    f_Node_render_xml(2);
    return;
  }
  else
  {
    pop_stack();
    Pike_error("Unsupported cast type.\n");
  }
}

}
/*! @decl int is_unlinked()
 */
#define f_Node_is_unlinked_defined
ptrdiff_t f_Node_is_unlinked_fun_num = 0;
void f_Node_is_unlinked(INT32 args) {
#line 1603 "Node.cmod"
if(args != 0) wrong_number_of_args_error("is_unlinked",args,0);
{
  push_int(THIS->object_data->unlinked);
}

}
/*!  @decl int is_transient()
 */
#define f_Node_is_transient_defined
ptrdiff_t f_Node_is_transient_fun_num = 0;
void f_Node_is_transient(INT32 args) {
#line 1610 "Node.cmod"
if(args != 0) wrong_number_of_args_error("is_transient",args,0);
{
  push_int(THIS->object_data->unlinked);
}

}
/*! @decl int _refs()
 */
#define f_Node_cq__refs_defined
ptrdiff_t f_Node_cq__refs_fun_num = 0;
void f_Node_cq__refs(INT32 args) {
#line 1617 "Node.cmod"
if(args != 0) wrong_number_of_args_error("_refs",args,0);
{
  push_int(*THIS->object_data->refs);
}


}
#line 1623 "Node.cmod"
int check_node_created()
{
  if(THIS->object_data->node != NULL)
    return 1;
  Pike_error("Node not initialized.\n");
}


#undef internal_init_Node_defined
#define internal_init_Node_defined

#undef Node_event_handler_defined
#define Node_event_handler_defined
static void init_Node_struct(void)
#line 1631 "Node.cmod"
{
  NODE_OBJECT_DATA * dta;

  dta = 
	(NODE_OBJECT_DATA*)malloc(sizeof(NODE_OBJECT_DATA));
    if (!dta)
        Pike_error("init_node: Out of memory!\n");

    dta->node = NULL;
    dta->parser = NULL;
    dta->unlinked = 0;
    dta->transient = 0;
    THIS->object_data = dta;
}


#undef internal_exit_Node_defined
#define internal_exit_Node_defined

#undef Node_event_handler_defined
#define Node_event_handler_defined
static void exit_Node_struct(void)
#line 1647 "Node.cmod"
{ 
  if(THIS != NULL && THIS->object_data != NULL && 
    (* THIS->object_data->refs)==1 && THIS->object_data->transient == 0)
  {
    if(THIS->object_data->node->doc != NULL)
      xmlFreeDoc(THIS->object_data->node->doc);
  }
  else if(THIS->object_data->transient == 0)
  {
    (*( THIS->object_data->refs)) --;
  }
  /* if we're not linked to a document, we can free the node. */
  if(THIS->object_data->node != NULL && THIS->object_data->unlinked==1)
  {
    xmlFreeNode(THIS->object_data->node);
    THIS->object_data->node = NULL;
  }

  if(THIS->object_data)
  {
    free(THIS->object_data);
  }
}

#ifdef Node_event_handler_defined
static void Node_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Node_defined
  case PROG_EVENT_INIT: init_Node_struct(); break;

#endif /* internal_init_Node_defined */

#ifdef internal_exit_Node_defined
  case PROG_EVENT_EXIT: exit_Node_struct(); break;

#endif /* internal_exit_Node_defined */
  default: break; 
  }
}

#endif /* Node_event_handler_defined */
/*! @endclass
 */


/*! @endmodule
 */

/*! @endmodule
 */

/*! @endmodule
 */


#line 1685 "Node.cmod"
void pike_init_xml2_node()
{
  
#ifdef class_Node_defined

#ifdef PROG_NODE_ID
#line 75 "Node.cmod"
  START_NEW_PROGRAM_ID(NODE);
#else
#line 75 "Node.cmod"
  start_new_program();

#endif /* PROG_NODE_ID */

#ifndef tObjImpl_NODE

#undef tObjImpl_NODE
#define tObjImpl_NODE tObj

#endif /* tObjImpl_NODE */

#ifdef THIS_NODE
  Node_storage_offset = ADD_STORAGE(struct Node_struct);
#endif /* THIS_NODE */

#ifdef Node_event_handler_defined
  pike_set_prog_event_callback(Node_event_handler);

#endif /* Node_event_handler_defined */

#ifdef f_Node_cq__sprintf_defined
  f_Node_cq__sprintf_fun_num =
#line 81 "Node.cmod"
    ADD_FUNCTION2("_sprintf", f_Node_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMix,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_cq__sprintf_defined */

#ifdef f_Node_create_defined
  f_Node_create_fun_num =
#line 105 "Node.cmod"
    ADD_FUNCTION2("create", f_Node_create, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_create_defined */

#ifdef f_Node_get_line_no_defined
  f_Node_get_line_no_fun_num =
#line 113 "Node.cmod"
    ADD_FUNCTION2("get_line_no", f_Node_get_line_no, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_line_no_defined */

#ifdef f_Node_set_ns_defined
  f_Node_set_ns_fun_num =
#line 125 "Node.cmod"
    ADD_FUNCTION2("set_ns", f_Node_set_ns, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_ns_defined */

#ifdef f_Node_set_content_defined
  f_Node_set_content_fun_num =
#line 150 "Node.cmod"
    ADD_FUNCTION2("set_content", f_Node_set_content, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_content_defined */

#ifdef f_Node_add_content_defined
  f_Node_add_content_fun_num =
#line 168 "Node.cmod"
    ADD_FUNCTION2("add_content", f_Node_add_content, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_content_defined */

#ifdef f_Node_get_text_defined
  f_Node_get_text_fun_num =
#line 186 "Node.cmod"
    ADD_FUNCTION2("get_text", f_Node_get_text, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_text_defined */

#ifdef f_Node_get_node_path_defined
  f_Node_get_node_path_fun_num =
#line 205 "Node.cmod"
    ADD_FUNCTION2("get_node_path", f_Node_get_node_path, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_node_path_defined */

#ifdef f_Node_get_ns_defined
  f_Node_get_ns_fun_num =
#line 223 "Node.cmod"
    ADD_FUNCTION2("get_ns", f_Node_get_ns, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_ns_defined */

#ifdef f_Node_get_nss_defined
  f_Node_get_nss_fun_num =
#line 242 "Node.cmod"
    ADD_FUNCTION2("get_nss", f_Node_get_nss, tFunc(tNone,tMapping), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_nss_defined */

#ifdef f_Node_get_base_defined
  f_Node_get_base_fun_num =
#line 276 "Node.cmod"
    ADD_FUNCTION2("get_base", f_Node_get_base, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_base_defined */

#ifdef f_Node_get_lang_defined
  f_Node_get_lang_fun_num =
#line 294 "Node.cmod"
    ADD_FUNCTION2("get_lang", f_Node_get_lang, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_lang_defined */

#ifdef f_Node_get_space_preserve_defined
  f_Node_get_space_preserve_fun_num =
#line 312 "Node.cmod"
    ADD_FUNCTION2("get_space_preserve", f_Node_get_space_preserve, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_space_preserve_defined */

#ifdef f_Node_get_attributes_defined
  f_Node_get_attributes_fun_num =
#line 327 "Node.cmod"
    ADD_FUNCTION2("get_attributes", f_Node_get_attributes, tFunc(tNone,tMapping), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_attributes_defined */

#ifdef f_Node_get_no_ns_attributes_defined
  f_Node_get_no_ns_attributes_fun_num =
#line 374 "Node.cmod"
    ADD_FUNCTION2("get_no_ns_attributes", f_Node_get_no_ns_attributes, tFunc(tNone,tMapping), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_no_ns_attributes_defined */

#ifdef f_Node_get_ns_attributes_defined
  f_Node_get_ns_attributes_fun_num =
#line 421 "Node.cmod"
    ADD_FUNCTION2("get_ns_attributes", f_Node_get_ns_attributes, tFunc(tString,tMapping), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_ns_attributes_defined */

#ifdef f_Node_children_defined
  f_Node_children_fun_num =
#line 479 "Node.cmod"
    ADD_FUNCTION2("children", f_Node_children, tFunc(tNone,tArray), 0, OPT_SIDE_EFFECT
);

#endif /* f_Node_children_defined */

#ifdef f_Node_parent_defined
  f_Node_parent_fun_num =
#line 508 "Node.cmod"
    ADD_FUNCTION2("parent", f_Node_parent, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_parent_defined */

#ifdef f_Node_replace_defined
  f_Node_replace_fun_num =
#line 535 "Node.cmod"
    ADD_FUNCTION2("replace", f_Node_replace, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_replace_defined */

#ifdef f_Node_copy_defined
  Node_f_Node_copy_fun_num =
#line 586 "Node.cmod"
    ADD_FUNCTION2("copy", f_Node_copy, tOr(tFunc(tNone,tObj),tFunc("\10\200\0\0\0\177\377\377\377",tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_copy_defined */

#ifdef f_Node_copy_list_defined
  f_Node_copy_list_fun_num =
#line 610 "Node.cmod"
    ADD_FUNCTION2("copy_list", f_Node_copy_list, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_copy_list_defined */

#ifdef f_Node_unlink_defined
  f_Node_unlink_fun_num =
#line 635 "Node.cmod"
    ADD_FUNCTION2("unlink", f_Node_unlink, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_unlink_defined */

#ifdef f_Node_delete_defined
  f_Node_delete_fun_num =
#line 652 "Node.cmod"
    ADD_FUNCTION2("delete", f_Node_delete, tFunc(tNone,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_delete_defined */

#ifdef f_Node_get_root_node_defined
  f_Node_get_root_node_fun_num =
#line 669 "Node.cmod"
    ADD_FUNCTION2("get_root_node", f_Node_get_root_node, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_root_node_defined */

#ifdef f_Node_set_root_node_defined
  f_Node_set_root_node_fun_num =
#line 698 "Node.cmod"
    ADD_FUNCTION2("set_root_node", f_Node_set_root_node, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_root_node_defined */

#ifdef f_Node_new_cdata_block_defined
  f_Node_new_cdata_block_fun_num =
#line 725 "Node.cmod"
    ADD_FUNCTION2("new_cdata_block", f_Node_new_cdata_block, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_cdata_block_defined */

#ifdef f_Node_new_pi_defined
  f_Node_new_pi_fun_num =
#line 756 "Node.cmod"
    ADD_FUNCTION2("new_pi", f_Node_new_pi, tFunc(tString tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_pi_defined */

#ifdef f_Node_delete_attribute_defined
  Node_f_Node_delete_attribute_fun_num =
#line 864 "Node.cmod"
    ADD_FUNCTION2("delete_attribute", f_Node_delete_attribute, tOr(tFunc(tString,tObj),tFunc(tString tString,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_delete_attribute_defined */

#ifdef f_Node_set_attribute_defined
  Node_f_Node_set_attribute_fun_num =
#line 890 "Node.cmod"
    ADD_FUNCTION2("set_attribute", f_Node_set_attribute, tOr(tFunc(tString tString tString,tObj),tFunc(tString tString,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_attribute_defined */

#ifdef f_Node_new_char_ref_defined
  f_Node_new_char_ref_fun_num =
#line 926 "Node.cmod"
    ADD_FUNCTION2("new_char_ref", f_Node_new_char_ref, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_char_ref_defined */

#ifdef f_Node_new_comment_defined
  f_Node_new_comment_fun_num =
#line 962 "Node.cmod"
    ADD_FUNCTION2("new_comment", f_Node_new_comment, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_comment_defined */

#ifdef f_Node_new_doc_comment_defined
  f_Node_new_doc_comment_fun_num =
#line 994 "Node.cmod"
    ADD_FUNCTION2("new_doc_comment", f_Node_new_doc_comment, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_doc_comment_defined */

#ifdef f_Node_new_child_defined
  Node_f_Node_new_child_fun_num =
#line 1064 "Node.cmod"
    ADD_FUNCTION2("new_child", f_Node_new_child, tOr(tFunc(tString tString,tObj),tFunc(tString tString tString,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_child_defined */

#ifdef f_Node_new_text_child_defined
  Node_f_Node_new_text_child_fun_num =
#line 1150 "Node.cmod"
    ADD_FUNCTION2("new_text_child", f_Node_new_text_child, tOr(tFunc(tString tString,tObj),tFunc(tString tString tString,tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_new_text_child_defined */

#ifdef f_Node_add_ns_defined
  f_Node_add_ns_fun_num =
#line 1197 "Node.cmod"
    ADD_FUNCTION2("add_ns", f_Node_add_ns, tFunc(tString tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_ns_defined */

#ifdef f_Node_add_child_defined
  f_Node_add_child_fun_num =
#line 1224 "Node.cmod"
    ADD_FUNCTION2("add_child", f_Node_add_child, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_child_defined */

#ifdef f_Node_add_sibling_defined
  f_Node_add_sibling_fun_num =
#line 1268 "Node.cmod"
    ADD_FUNCTION2("add_sibling", f_Node_add_sibling, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_sibling_defined */

#ifdef f_Node_add_next_sibling_defined
  f_Node_add_next_sibling_fun_num =
#line 1298 "Node.cmod"
    ADD_FUNCTION2("add_next_sibling", f_Node_add_next_sibling, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_next_sibling_defined */

#ifdef f_Node_add_prev_sibling_defined
  f_Node_add_prev_sibling_fun_num =
#line 1328 "Node.cmod"
    ADD_FUNCTION2("add_prev_sibling", f_Node_add_prev_sibling, tFunc(tObj,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_add_prev_sibling_defined */

#ifdef f_Node_get_last_child_defined
  f_Node_get_last_child_fun_num =
#line 1358 "Node.cmod"
    ADD_FUNCTION2("get_last_child", f_Node_get_last_child, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_last_child_defined */

#ifdef f_Node_next_defined
  f_Node_next_fun_num =
#line 1387 "Node.cmod"
    ADD_FUNCTION2("next", f_Node_next, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_next_defined */

#ifdef f_Node_prev_defined
  f_Node_prev_fun_num =
#line 1412 "Node.cmod"
    ADD_FUNCTION2("prev", f_Node_prev, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_prev_defined */

#ifdef f_Node_is_blank_defined
  f_Node_is_blank_fun_num =
#line 1436 "Node.cmod"
    ADD_FUNCTION2("is_blank", f_Node_is_blank, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_is_blank_defined */

#ifdef f_Node_is_text_defined
  f_Node_is_text_fun_num =
#line 1447 "Node.cmod"
    ADD_FUNCTION2("is_text", f_Node_is_text, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_is_text_defined */

#ifdef f_Node_get_node_type_defined
  f_Node_get_node_type_fun_num =
#line 1462 "Node.cmod"
    ADD_FUNCTION2("get_node_type", f_Node_get_node_type, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_node_type_defined */

#ifdef f_Node_get_node_name_defined
  f_Node_get_node_name_fun_num =
#line 1472 "Node.cmod"
    ADD_FUNCTION2("get_node_name", f_Node_get_node_name, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_get_node_name_defined */

#ifdef f_Node_set_node_name_defined
  f_Node_set_node_name_fun_num =
#line 1486 "Node.cmod"
    ADD_FUNCTION2("set_node_name", f_Node_set_node_name, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_node_name_defined */

#ifdef f_Node_set_lang_defined
  f_Node_set_lang_fun_num =
#line 1501 "Node.cmod"
    ADD_FUNCTION2("set_lang", f_Node_set_lang, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_lang_defined */

#ifdef f_Node_set_base_defined
  f_Node_set_base_fun_num =
#line 1516 "Node.cmod"
    ADD_FUNCTION2("set_base", f_Node_set_base, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_set_base_defined */

#ifdef f_Node_render_xml_defined
  f_Node_render_xml_fun_num =
#line 1540 "Node.cmod"
    ADD_FUNCTION2("render_xml", f_Node_render_xml, tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_render_xml_defined */

#ifdef f_Node_render_html_defined
  f_Node_render_html_fun_num =
#line 1564 "Node.cmod"
    ADD_FUNCTION2("render_html", f_Node_render_html, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_render_html_defined */

#ifdef f_Node_cast_defined
  f_Node_cast_fun_num =
#line 1584 "Node.cmod"
    ADD_FUNCTION2("cast", f_Node_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_cast_defined */

#ifdef f_Node_is_unlinked_defined
  f_Node_is_unlinked_fun_num =
#line 1603 "Node.cmod"
    ADD_FUNCTION2("is_unlinked", f_Node_is_unlinked, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_is_unlinked_defined */

#ifdef f_Node_is_transient_defined
  f_Node_is_transient_fun_num =
#line 1610 "Node.cmod"
    ADD_FUNCTION2("is_transient", f_Node_is_transient, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_is_transient_defined */

#ifdef f_Node_cq__refs_defined
  f_Node_cq__refs_fun_num =
#line 1617 "Node.cmod"
    ADD_FUNCTION2("_refs", f_Node_cq__refs, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Node_cq__refs_defined */
#line 75 "Node.cmod"
  Node_program=end_program();
#line 75 "Node.cmod"
  Node_program_fun_num=add_program_constant("Node",Node_program,0);

#endif /* class_Node_defined */
#line 1688 "Node.cmod"
}

void pike_exit_xml2_node()
{
  
#ifdef class_Node_defined
  if(Node_program) {
#line 75 "Node.cmod"
    free_program(Node_program);
    Node_program=0;
  }

#endif /* class_Node_defined */
#line 1693 "Node.cmod"
}

