

from bases import VCSBase, DVCSMixin
from subprocess import Popen, PIPE
from os.path import abspath

def action(fn):
    action = fn.__name__
    def action_method(self, params=[], run=True):
        params = [ abspath(p)[len(self.base_path):] for p in params ]
        command = self._get_command(action,params) 
        if run:
           self._run(command)
        else:
           return self._output_pipe(command)
    action_method.__name__ = action
    action_method.__dict__ = fn.__dict__
    return action_method


class CommandBased(VCSBase):
    """
    Base class for all command based rcs's
    """
    command_map = {}

    def _output_proc(self, args=[]):
        if not args:
            raise ValueError("need a valid command")
        return Popen(args, stdout=PIPE, pwd=self.base_path, close_fds=True)
    
    def _output_str(self,args=[]):
        return self._output_proc(args).communicate()[0]

    def _output_pipe(self, args=[]):
        return self._output_proc(args).stdout

    def _output_iter(self, args=[]):
        for line in self._output_pipe(args):
            yield line
    
    def _run(self,args=[]):
        for line in self._output_pipe(args):
            print line

    def _get_command(self,action,args = []):
        action = self.command_map.get(action, action)
        action = self.getattr(action + "_cmd", action)
        if not isinstance(action, list):
            action = [action]
        return [self.CMD] + action + args

    @action
    def commit(): pass

    @action
    def diff(): pass

    @action
    def update(): pass
    
    @action
    def commit(): pass


class DCommandBased(CommandBased, DVCSMixin):
    """
    base class for all distributed command based rcs's
    """
