# -*- coding: utf-8 -*- 

# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:
#Copyright (c) 2005-2006 The PIDA Project

#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:

#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.

#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#SOFTWARE.

# system import(s)
import os

# rat
from rat import hig

# pida core import(s)
import pida.core.service as service
import pida.core.document as document
defs = service.definitions

# Kiwi component stuff for gazpacho
from kiwi.component import provide_utility, get_utility, remove_utility

# Gazpacho imports
from gazpacho.interfaces import IGazpachoApp, IPluginManager
from gazpacho.app.app import Application
from gazpacho.app.debugwindow import DebugWindow
from gazpacho.plugins import PluginManager
from gazpacho.config import config as gazpacho_config


class ExternalGazpacho(object):

    def __init__(self, service):
        self.service = service
        self.boss = service.boss
        self.gazpacho = self.launch()
        self.perform_evil_hacks()

    def launch(self):
        plugin_manager = PluginManager()
        provide_utility(IPluginManager, plugin_manager)
        gazpacho = Application()
        provide_utility(IGazpachoApp, gazpacho)
        DebugWindow.application = gazpacho
        return gazpacho

    def perform_evil_hacks(self):
        self.gazpacho._window.show_all()
        self.gazpacho._quit_cb = self._quit_cb

    def _quit_cb(self):
        self.gazpacho._window.hide()
        return True

    def open_project(self, filename):
        self.gazpacho._window.show()
        self.gazpacho._window.present()
        for project in self.gazpacho._projects:
            if project.path and project.path == filename:
                return self.gazpacho._set_project(project)
        return self.gazpacho.open_project(filename)
    



import pida.core.actions as actions



class gazpacho_service(service.service):

    display_name = 'Gazpacho'

    class glade_handler(document.document_handler):
        """The glade file handler."""

        globs = ["*.glade"]

        def init(self):
            self.service.handler = self
            document.document_handler.init(self)

        def create_document(self, filename, document_type):
            doc = gazpacho_document(filename=filename, handler=self)
            return doc

        def view_document(self, document):
            if self.service.gaz_instance is None:
                self.service.gaz_instance = ExternalGazpacho(self.service)
            self.service.gaz_instance.open_project(document.filename)
            #self.boss.call_command('terminal', 'execute',
            #    command_args=['gazpacho', document.filename])


        def close_document(self, document):
            self.service.single_view.gaz.close_current_project()
            self.service.boss.call_command('buffermanager', 'document_closed',
                                           document=document)

    def init(self):
        self.__view = None
        self.gaz_instance = None

    def cmd_open(self, filename):
        self.boss.call_command('buffermanager', 'open_file',
                                filename=filename)


    def cmd_create(self, filename):
        f = open(filename, 'w')
        f.write(empty_gazpacho_document)
        f.close()
        self.boss.call_command('buffermanager', 'open_file',
                                filename=filename)

    def cmd_goto_signal_handler(self, glade_filename, callback_filename,
                                callback_name):
        import pida.utils.tepache as tepache
        class dummyopts(object):
            pass
        def get_options_status():
            opts = dummyopts()
            opts.glade_file = glade_filename
            opts.output_file = callback_filename
            opts.use_tabs = False
            opts.no_helper = False
            return opts, True
        tepache.get_options_status = get_options_status
        tepache.main()
        f = open(callback_filename)
        fundef = 'def %s' % callback_name
        for linenumber, line in enumerate(f):
            print line, fundef
            if fundef in line:
                break
        f.close()
        self.boss.call_command('buffermanager', 'open_file_line',
                               filename=callback_filename,
                               linenumber=linenumber + 2)

    @actions.action(
       label="Add UI Form...",
    )
    def act_add_ui_form(self, action):
        """Add a user interface form to the current project."""
        proj = self.boss.call_command('projectmanager',
                                      'get_current_project')
        if proj is None:
            hig.error('Cannot create User Interface Form',
                        'There is no project selected',
                        parent=self.boss.get_main_window())
            return
        if proj.gui__uses:
            gladedir = proj.gui__location
            def callback(name):
                if not name.endswith('.glade'):
                    name = '%s.glade' % name
                filepath = os.path.join(gladedir, name)
                self.boss.call_command('gazpach', 'create',
                                       filename=filepath)
            self.boss.call_command('window', 'input',
                                        callback_function=callback,
                                        prompt='Form Name')
        else:
            hig.error('Cannot create User Interface Form',
                        'This project must be configured to use glade.',
                        parent=self.boss.get_main_window())
            
    def get_menu_definition(self):
        return """
            <menubar>
            <menu name="base_project" action="base_project_menu">
            <separator />
            <placeholder name="ProjectExtras">
            <menuitem name="addform" action="gazpach+add_ui_form" />
            </placeholder>
            <separator />
            </menu>
            </menubar>
            """
    
    def get_single_view(self):
        return self.__view
    single_view = property(get_single_view)

class gazpacho_document(document.realfile_document):

    ICON_NAME = 'gazpacho'


empty_gazpacho_document = """<?xml version="1.0" standalone="no"?>
<!--*- mode: xml -*-->
<!DOCTYPE glade-interface SYSTEM "http://gazpacho.sicem.biz/gazpacho-0.1.dtd">
<glade-interface/>
"""

Service = gazpacho_service

