/*
 * token.h
 *
 * Copyright 1995-2000 Timo Rossi, <trossi@iki.fi>
 * See the file LICENSE for license terms.
 *
 */

#define TOKSIZE 256

/*
 * token codes
 */
/**/
enum {
  TOK_INVALID,
  TOK_EOF,
  TOK_NEWLINE,
  TOK_COLON,
  TOK_PERIOD,
  TOK_DOLLAR,
  TOK_COMMA,
  TOK_LEFTPAR,
  TOK_RIGHTPAR,
  TOK_LEFTBRAK,
  TOK_RIGHTBRAK,
  TOK_EQUAL,
  TOK_EQ,
  TOK_NOT_EQ,
  TOK_LESS,
  TOK_LESS_EQ,
  TOK_GREATER,
  TOK_GT_EQ,
  TOK_PLUS,
  TOK_MINUS,
  TOK_ASTERISK,
  TOK_SLASH,
  TOK_PERCENT,
  TOK_BITAND,
  TOK_BITOR,
  TOK_BITXOR,
  TOK_BITNOT,
  TOK_LSHIFT,
  TOK_RSHIFT,
  TOK_BACKSLASH,
  TOK_IDENTIFIER,
  TOK_LOCAL_ID,
  TOK_INTCONST,
  TOK_STRCONST, /* used as file name with include, and in EDATA */

  KW_INCLUDE,
  KW_MACRO,
  KW_ENDM,
  KW_EXITM,
  KW_IF,
  KW_ELSE,
  KW_ENDIF,
  KW_EQU,
  KW_SET,
  KW_END,
  KW_ORG,
  KW_DS,
  KW_EDATA,
  KW_DT,
  KW_DATA,
  KW_CBLOCK,
  KW_ENDC,
  KW_CONFIG,
  KW_PICID,
  KW_DEVICE,
  KW_DEFINED,
  KW_HIBYTE,
  KW_STREQ,
  KW_ISSTR,
  KW_CHRVAL,
  KW_OPT,
  KW_LOCAL,
  KW_ENDLOCAL,
  KW_ERROR,

  KW_ADDLW,
  KW_ADDWF,
  KW_ANDLW,
  KW_ANDWF,
  KW_BCF,
  KW_BSF,
  KW_BTFSC,
  KW_BTFSS,
  KW_CALL,
  KW_CLRF,
  KW_CLRW,
  KW_CLRWDT,
  KW_COMF,
  KW_DECF,
  KW_DECFSZ,
  KW_GOTO,
  KW_INCF,
  KW_INCFSZ,
  KW_IORLW,
  KW_IORWF,
  KW_MOVLW,
  KW_MOVF,
  KW_MOVWF,
  KW_NOP,
  KW_OPTION,
  KW_RETFIE,
  KW_RETLW,
  KW_RETURN,
  KW_RLF,
  KW_RRF,
  KW_SLEEP,  
  KW_SUBLW,
  KW_SUBWF,
  KW_SWAPF,
  KW_TRIS,
  KW_XORLW,
  KW_XORWF,

  KW_ADDWFC,
  KW_BTG,
  KW_CPFSEQ,
  KW_CPFSGT,
  KW_CPFSLT,
  KW_DAW,
  KW_DCFSNZ,
  KW_INFSNZ,
  KW_LCALL,
  KW_MOVFP,
  KW_MOVPF,
  KW_MOVLB,
  KW_MOVLR,
  KW_MULLW,
  KW_MULWF,
  KW_NEGW,
  KW_RLCF,
  KW_RLNCF,
  KW_RRCF,
  KW_RRNCF,
  KW_SETF,
  KW_SUBWFB,
  KW_TABLRD,
  KW_TABLWT,
  KW_TLRD,
  KW_TLWT,
  KW_TSTFSZ,

  KW_END_POS /* end marker */
};

#define FIRST_KW KW_INCLUDE
#define NUM_KEYWORDS (KW_END_POS-FIRST_KW)

extern int token_type, line_buf_off;
extern char token_string[TOKSIZE];
extern long token_int_val;
extern int tok_char;
extern int ifskip_mode;

/*prototypes*/

void get_token(void), skip_eol(void);
void expand_macro(struct symbol *sym);
void begin_include(char *fname, int), end_include(void);
void read_src_char(void);
void init_includes(void), add_include_path(char *);
