# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
import sys
import general, tags, dirs, naming, lookup, encodings, language, colors, about, puid, login, proxy

class OptionsDialog(wx.Dialog):

    def __init__(self, parent, config, pageToOpen = 0):
        
        self.config = config
        size = config.persistOptionsSize.split(',')
        size = (int(size[0]), int(size[1]))
        
        wx.Dialog.__init__(self, parent, -1, _("Preferences"),
            style = wx.DEFAULT_DIALOG_STYLE | wx.RESIZE_BORDER,
            size = size)

        self.splitter = wx.SplitterWindow(self, -1, style = wx.SP_NOBORDER | wx.SP_LIVE_UPDATE)

        self.tree = wx.TreeCtrl(self.splitter, -1, style = wx.TR_DEFAULT_STYLE | wx.TR_HIDE_ROOT | wx.SUNKEN_BORDER)
     
        root = self.tree.AddRoot(_("Preferences"))
        
        pageClasses = [
            general.GeneralPage,
            puid.PuidPage,
            login.LoginPage,
            proxy.ProxyPage,
            tags.TagsPage,
            dirs.DirsPage,
            naming.NamingPage,
            lookup.LookupPage,
            language.LanguagePage,
            colors.ColorsPage,
            about.AboutPage,
        ]
        
        if sys.platform != 'win32':
            pageClasses.insert(5, encodings.EncodingsPage)

        self.pages = []
        
        if pageToOpen < 0:
            pageToOpen += len(pageClasses) 

        i = 0
        initialPage = None
        initialItem = None
        for pageClass in pageClasses:
            page = pageClass(self.splitter, config)
            item = self.tree.AppendItem(root, _(page.name), data = wx.TreeItemData(page))
            page.pageIndex = item
            if i == pageToOpen:
                initialPage = page
                initialItem = item
            i += 1                
            self.pages.append(page)
            
        self.splitter.SplitVertically(self.tree, initialPage, self.config.persistOptionsSplitterPos)
        self.splitter.SetMinimumPaneSize(50)
        self.splitter.SetAutoLayout(True)
        self.splitter.Fit()

        if initialItem:
            self.SetSelection(initialItem)
            
        self.Bind(wx.EVT_TREE_SEL_CHANGED, self.OnSwitchPage, self.tree)
        
        okButton = wx.Button(self, -1, _("Make it so!"))
        okButton.SetDefault()
        cancelButton = wx.Button(self, -1, _("Cancel"))
        
        self.Bind(wx.EVT_BUTTON, self.OnOk, okButton)
        self.Bind(wx.EVT_BUTTON, self.OnCancel, cancelButton)
        
        buttonBox = wx.BoxSizer(wx.HORIZONTAL)
        buttonBox.Add(okButton, 0, wx.ALL, 5)
        buttonBox.Add(cancelButton, 0, wx.ALL, 5)
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(self.splitter , 1, wx.EXPAND | wx.ALL, 5)
        vbox.Add(wx.StaticLine(self, -1), 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.BOTTOM, 5)
        vbox.Add(buttonBox, 0, wx.ALIGN_RIGHT)

        self.SetSizer(vbox)

    def SetSelection(self, item):
        self.tree.SelectItem(item)
        
    def OnSwitchPage(self, event):
        newpage = self.tree.GetPyData(event.GetItem())
        if newpage != None:
            oldpage = self.splitter.GetWindow2()
            if oldpage != newpage:
                oldpage.Show(False)
                self.splitter.ReplaceWindow(oldpage, newpage)
                newpage.Show(True)

    def SaveSizeAndSplitterPos(self):
        self.config.persistOptionsSplitterPos = self.splitter.GetSashPosition()
        self.config.persistOptionsSize = u"%d,%d" % self.GetSizeTuple()
        
    def OnCancel(self, event):
        self.SaveSizeAndSplitterPos();
        self.EndModal(0)
    
    def OnOk(self, event):
        for page in self.pages:
            if not page.saveOk():
                return
        
        for page in self.pages:
            page.save()
        
        self.SaveSizeAndSplitterPos();
        self.EndModal(1)

#----------------------------------------------------------------------
class MyApp(wx.App):
  def OnInit(self):
    self.frame = wx.Frame(None, -1, "title")
    button = wx.Button(self.frame, wx.ID_CLOSE, "Close")
    wx.EVT_BUTTON(self, wx.ID_CLOSE, self.OnButton)
    self.frame.Show(1)
    self.dlg = OptionsDialog(self.frame, None)
    self.dlg.Show()
    return True

  def OnButton(self, event):
    self.dlg.Destroy()
    self.frame.Close()

if __name__ == "__main__":
    myapp = MyApp(0)
    myapp.MainLoop()
