# -*- coding: utf-8 -*-
# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx, sys, os
from page import Page

class LanguagePage(Page):

    name = N_("Language")

    languages = [
        (u"", u"", N_(u"System default")),
        (u"cs", u"Čeština", N_(u"Czech")),
        (u"da", u"Dansk", N_(u"Danish")),
        (u"de", u"Deutsch", N_(u"German")),
        (u"en", u"English", N_(u"English")),
        (u"en_GB", u"English (UK)", N_(u"English (UK)")),
        (u"es", u"Español", N_(u"Spanish")),
        (u"fi", u"Suomi", N_(u"Finnish")),
        (u"fr", u"Français", N_(u"French")),
        (u"fy", u"Frysk", N_(u"Frisian")),
        (u"hu", u"Magyar", N_(u"Hungarian")),
        (u"is", u"Íslenska", N_(u"Icelandic")),
        (u"it", u"Italiano", N_(u"Italian")),
        (u"ko", u"한국어", N_(u"Korean")),
        (u"lt", u"Lietuvių", N_(u"Lithuanian")),
        (u"nl", u"Nederlands", N_(u"Dutch")),
        (u"no", u"Norsk bokmål", N_(u"Norwegian Bokmal")),
        (u"pl", u"Polski", N_(u"Polish")),
        (u"pt", u"Português", N_(u"Portuguese")),
        (u"pt_BR", u"Português do Brasil", N_(u"Brazilian Portuguese")),
        (u"ro", u"Română", N_(u"Romanian")),
        (u"ru", u"Pyccĸий", N_(u"Russian")),
        (u"sk", u"Slovenčina", N_(u"Slovak")),
        (u"sv", u"Svenska", N_(u"Swedish")),
    ]
    
    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        box = wx.StaticBox(self, -1, _("User interface language"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        self.choices = []
        for lang in self.languages:
            trans = _(lang[2])
            if lang[1] == trans:
                name = lang[1]
            elif lang[1]:
                name = u"%s [%s]" % (trans, lang[1])
            else:
                name = trans
            self.choices.append((lang[0], name))
        self.choices.sort(lambda a, b: a[1] < b[1])
        self.langChoice = wx.Choice(self)
        index = 0
        for lang in self.choices:
            self.langChoice.Append(lang[1])
            if lang[0] == self.config.settingLanguage:
                self.langChoice.SetSelection(index)
            index += 1    
        sizer.Add(self.langChoice, 0, wx.ALL, 5)
        sizer.Add(wx.StaticText(self, -1, _("Note: This setting will take effect after you restart the application.")), 0, wx.LEFT | wx.RIGHT | wx.BOTTOM, 5)
        self.content.Add(sizer, 0, wx.EXPAND)

        box = wx.StaticBox(self, -1, _("Artist translation"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        self.artistTranslation = wx.CheckBox(self, -1, _("Translate foreign artist names to English where possible."))
        self.artistTranslation.SetValue(self.config.settingArtistTranslation)
        sizer.Add(self.artistTranslation, 0, wx.ALL, 5)
        self.content.Add(sizer, 0, wx.EXPAND | wx.TOP, 5)

        self.Fit()

    def save(self):
        self.config.settingLanguage = self.choices[self.langChoice.GetSelection()][0]
        self.config.settingArtistTranslation = self.artistTranslation.GetValue()

