# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import dataobjs
from tunepimp import tunepimp

class Track(dataobjs.DataObject):

    def __init__(self, config, name, id):
        dataobjs.DataObject.__init__(self, config, name, id)
        self.duration = 0
        self.fileDuration = 0
        self.num = -1
        self.album = None
        self.artist = None
        self.fileId = -1
        self.fileName = u""

    def dumpState(self, writer):
        writer(u"track object: %s" % ( repr(self) ))
        writer = writer.nest()
        writer(u"name: %s" % ( repr(self.name) ))
        writer(u"id: %s" % ( repr(self.id) ))
        writer(u"duration: %s" % ( repr(self.duration) ))
        writer(u"fileDuration: %s" % ( repr(self.fileDuration) ))
        writer(u"num: %s" % ( repr(self.num) ))
        writer(u"album: %s" % ( repr(self.album) ))
        writer(u"artist: %s" % ( repr(self.artist) ))
        writer(u"fileId: %s" % ( repr(self.fileId) ))
        writer(u"fileName: %s" % ( repr(self.fileName) ))

    def getAlbum(self):
        return self.album

    def setAlbum(self, album):
        self.album = album

    def getArtist(self):
        return self.artist

    def setArtist(self, artist):
        self.artist = artist

    def getNum(self):
        return self.num

    def setNum(self, num):
        self.num = num

    def setDuration(self, duration):
        self.duration = duration

    def getDuration(self):
        return self.duration

    def getDurationString(self):

        dur = u"%d:%02d" % ((self.duration / 60000), ((self.duration % 60000) / 1000))
        if self.duration == 0 or self.fileDuration == 0:
            return dur

        diff = abs(self.duration - self.fileDuration)
        if diff < 3000:
            return dur

        if diff < 10000:
            return dur + u" !"
      
        return dur + u" !!"

    def getAlbum(self):
        return self.album

    def isUnmatched(self):
        return self.id == u""

    def isLinked(self):
        return self.fileId != -1

    def hasError(self):
        if self.fileId < 0: return False

        tpTrack = self.tunePimp.getTrack(self.fileId);
        tpTrack.lock()
        status = tpTrack.getStatus()
        tpTrack.unlock()
        self.tunePimp.releaseTrack(tpTrack)

        return status == tunepimp.eError

    def link(self, fileId):
        self.fileId = fileId

        tpTrack = self.tunePimp.getTrack(fileId);
        tpTrack.lock()
        mdata = tpTrack.getServerMetadata()
        tpTrack.unlock()

        #mdata.duration = self.getDuration()
        
        if self.getArtist():
            mdata.artist = self.getArtist().getName()
            mdata.artistId = self.getArtist().getId()
            mdata.sortName = self.getArtist().getSortName()
        else:
            mdata.artist = u""
            mdata.artistId = u""
            mdata.sortName = u""

        album = self.getAlbum()            
        if album:
            mdata.album = album.getName()
            mdata.albumId = album.getId()
            mdata.variousArtist = album.isVariousArtists()
            if album.getReleaseYear():
                mdata.releaseYear = album.getReleaseYear()
                mdata.releaseMonth = album.getReleaseMonth()
                mdata.releaseDay = album.getReleaseDay()
            if album.getReleaseType() or not mdata.albumType:
                mdata.albumType = mdata.convertToAlbumType(album.getReleaseType())
            if album.getReleaseStatus() or not mdata.albumStatus:
                mdata.albumStatus = mdata.convertToAlbumStatus(album.getReleaseStatus())
            if album.getReleaseCountry():
                mdata.releaseCountry = album.getReleaseCountry()
            mdata.totalInSet = album.getNumTracks()
        else:
            mdata.album = u""
            mdata.albumId = u""
            mdata.releaseYear = 0
            mdata.releaseMonth = 0
            mdata.releaseDay = 0
            mdata.releaseCountry = u""
            mdata.variousArtist = False
            mdata.totalInSet = 0

        albumArtist = album.getArtist()     
        if album and albumArtist:
            mdata.albumArtistId = albumArtist.getId()
            mdata.albumArtist = albumArtist.getName()
            mdata.albumArtistSortName = albumArtist.getSortName()
        else:
            mdata.albumArtistId = u""
            mdata.albumArtist = u""
            mdata.albumArtistSortName = u""
            
        mdata.track = self.getName()
        mdata.trackId = self.getId()
        mdata.trackNum = self.getNum()

        mdata.fileFormat = tpTrack.getLocalMetadata().fileFormat
        
        tpTrack.lock()
        tpTrack.setStatus(tunepimp.eRecognized)
        tpTrack.setServerMetadata(mdata)
        tpTrack.unlock()

        self.tunePimp.releaseTrack(tpTrack)

        self.config.getTagger().getPUIDManager().update(self.getFileId(), self.getId())
        
    def update(self):
        if self.isLinked():
            self.link(self.getFileId())
       
    def unlink(self):
        tpTrack = self.tunePimp.getTrack(self.fileId)

        tpTrack.lock()
        mdata = tpTrack.getServerMetadata()
        tpTrack.unlock()

        mdata.artist = u""
     	mdata.artistId = u""
        mdata.sortName = u""
        mdata.album = u""
     	mdata.albumId = u""
        mdata.releaseYear = 0
        mdata.releaseCountry = u""
        mdata.variousArtist = False
        mdata.track = u""
        mdata.trackId = u""
        mdata.trackNum = 0
        mdata.totalInSet = 0
        mdata.albumArtistId = u""
        mdata.albumArtist = u""
        mdata.albumArtistSortName = u""

        mdata.fileFormat = u""
        
        tpTrack.lock()
        tpTrack.setServerMetadata(mdata)
        tpTrack.unlock()

        self.tunePimp.releaseTrack(tpTrack)

        self.config.getTagger().getPUIDManager().update(self.getFileId(), None)
        
        self.fileId = -1
        self.fileDuration = 0

    def getFileId(self):
        return self.fileId

    def getFileName(self):
        return self.fileName

    def setFileName(self, fileName):
        self.fileName = fileName

    def getSimilarity(self):
        if self.isLinked():
            tpTrack = self.tunePimp.getTrack(self.getFileId())
            tpTrack.lock()
            sim = tpTrack.getSimilarity()
            tpTrack.unlock()
            self.tunePimp.releaseTrack(tpTrack)
            return sim
        else:
            return 0

    def hasChanged(self):
        if self.isLinked():
            tpTrack = self.tunePimp.getTrack(self.getFileId())
            tpTrack.lock()
            changed = tpTrack.hasChanged()
            tpTrack.unlock()
            self.tunePimp.releaseTrack(tpTrack)
            return changed
        else:
            return 0
            

