# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import wx
import urllib
import httplib
import BaseHTTPServer
from threading import Thread
from picard import events, util

PORT = 8000

class TaggerRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    def __init__(self,conn,addr,server):
        BaseHTTPServer.BaseHTTPRequestHandler.__init__(self, conn, addr, server)

    def do_POST(self):
        self.send_error(405, "POST not supported")

    def do_HEAD(self):
        self.send_error(405, "HEAD not supported")

    def do_GET(self):
        parsedArgs = {}
        [action, rest] = urllib.splitquery(self.path)
        if rest:
            args = rest.split('&');
            for kv in args:
               [key, value] = kv.split('=')
               parsedArgs[key] = unicode(value)

        if action[0] == '/':
            action = action[1:]
        self.server.getBrowserIntegrationModule().event(action, parsedArgs)
        self.send_response(200)
        self.send_header("Content-Type", "text/plain; charset=utf-8")
        self.end_headers()
        self.wfile.write('<html><head><meta http-equiv="pragma" content="no-cache"></head><body>Nothing to see here!</body></html>\n')

    def do_QUIT(self):
        self.server.getBrowserIntegrationModule().exitThread = True
        self.send_response(200)
        self.end_headers()        
        
    def log_message(self, format, *args):
        pass


class TaggerServer(BaseHTTPServer.HTTPServer):

    allow_reuse_address = False

    def __init__(self, addr, handlerClass):
        BaseHTTPServer.HTTPServer.__init__(self, addr, handlerClass)

    def setBrowserIntegrationModule(self, bim):
        self.bim = bim

    def getBrowserIntegrationModule(self):
        return self.bim 


class BrowserIntegration(Thread):
  
    def __init__(self, config):
        Thread.__init__(self)
        self.parent = config.getTagger()
        self.exitThread = False
        self.server = None
        self.port = -1
        
    def stop(self):
        if self.isAlive():
            if self.port > 0:
                conn = httplib.HTTPConnection("%s:%d" % self.server.server_address)
                conn.request("QUIT", "/")
                conn.getresponse()
            self.join()

    def event(self, action, args):
        wx.PostEvent(self.parent, events.BrowserMessageEvent(unicode(action), args))
        wx.WakeUpIdle()

    def run(self):
        port = PORT
        while True:
            try:
                self.server = TaggerServer(("127.0.0.1", port), TaggerRequestHandler)
                break
            except:
                port = port + 1

        # Report the port number back to the main app
        self.port = port
        wx.PostEvent(self.parent, events.BrowserMessageEvent("init", {"port": str(port)}))
        wx.WakeUpIdle()

        self.server.setBrowserIntegrationModule(self)
        while not self.exitThread:
            self.server.handle_request()

