<?

/**************************************************************************
 * LDAP functions.  Prefixed with myldap_ because ldap_ is already taken.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: ldap.inc,v 1.5 2002/07/12 08:54:35 mjp16 Exp $

require_once("phtml/misc.inc");

function myldap_search($query, $auth = 0, $attrs = NULL)
{
	debug("Query: [$query] connecting as ".$auth["uid"]);
	
	$ds = myldap_connect($auth);
		
	$sr = ldap_search($ds, $BASE_DN, $query, $attrs, 0, 0, 0);

	if (!$sr) {
		myldap_error($ds);
	}
	
	$ent = ldap_get_entries($ds, $sr);
	
	debug("search result:");
	dump_var($ent);
	
	return $ent;
}

function myldap_modify($dn, $attrs, $auth = 0)
{
	debug("Updating [$dn], auth as ".$auth["uid"]." Values:");
	dump_var($attrs);

	$ds = myldap_connect($auth);

	if (!ldap_modify($ds, $dn, $attrs)) {
		myldap_error($ds);
	}
}

function myldap_add($dn, $attrs, $auth = 0)
{
	debug("Adding [$dn], auth as ".$auth["uid"]." Values:");
	dump_var($attrs);

	$ds = myldap_connect($auth);

	if (!ldap_add($ds, $dn, $attrs)) {
		myldap_error($ds);
	}
}

function myldap_mod_add($dn, $attrs, $auth = 0)
{
	debug("Adding to [$dn], auth as ".$auth["uid"]." Values:");
	dump_var($attrs);

	$ds = myldap_connect($auth);

	if (!ldap_mod_add($ds, $dn, $attrs)) {
		myldap_error($ds);
	}
}

function myldap_error($ds)
{
	global $ADMIN_MAIL;

	echo "<p><b>Fatal Error: </b> ".ldap_error($ds);
	echo "<p>Please inform the administrator (<a href=\"mailto:$ADMIN_MAIL\">$ADMIN_MAIL</a>) of this problem.\n";
	exit;
}

function myldap_connect($auth)
{
	global $LDAP_SERVER_HOST, $LDAP_SERVER_PORT;
	
	$ds = ldap_connect($LDAP_SERVER_HOST, $LDAP_SERVER_PORT);
	if (!$ds) {
		myldap_error($ds);
	}
	
	if (!$auth) {
		$r = ldap_bind($ds);
	} else {
		$r = ldap_bind($ds, $auth["uid"], $auth["pass"]);
	}
	
	if (!$r) {
		myldap_error($ds);
	}
	
	return $ds;
}

?>
