<?

/* HTML functions for PHP.
 * Written by Matt Palmer.
 */
 
/* Returns a nice, properly conforming HTML header.  $title will be the
 * title shown in the title bar of the browser window, $stylesheet, if
 * given, will be the URL to a .css file to tell the browser to use. 
 * $javascript, if given, should be the URL to a file full of JavaScript
 * which the browser should use.  In a diversion from normality, $extras is
 * not parsed by misc_extraopts, but is instead supposed to be a string of
 * extra stuff to jam into the <head></head> part of the document.
 */
function html_header($title = NULL, $stylesheet = NULL, $javascript = NULL, $extras = "")
{
	$header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">
<html>
<head>
<title>$title</title>\n";
	
	if ($stylesheet !== NULL) {
		$header .= "<link rel=\"STYLESHEET\" href=\"$stylesheet\">\n";
	}

	if ($javascript !== NULL) {
		$header .= "<script language=\"javascript\" src=\"$javascript\"></script>\n";
	}

	$header .= "\n$extras\n</head>\n<body>\n";
	return $header;
}

/* A properly conforming HTML footer.
 */
function html_footer()
{
	return "</body>\n</html>\n";
}

/* A first-level header.
 */
function html_h1($header)
{
	return "<h1>$header</h1>\n";
}

function html_h2($header)
{
	return "<h2>$header</h2>\n";
}

function html_h3($header)
{
	return "<h3>$header</h3>\n";
}

function html_h4($header)
{
	return "<h4>$header</h4>\n";
}

/* The beginning of an unordered list.
 */
function html_list($ex = NULL)
{
	$ex = misc_extraopts($ex);
	return "<ul$ex>\n";
}

/* The footer for an unordered list.
 */
function html_endlist($ex = NULL)
{
	$ex = misc_extraopts($ex);
	return "</ul$ex>\n";
}

/* An item in a HTML list, of whatever type.
 */
function html_item($item, $ex = NULL)
{
	$ex = misc_extraopts($ex);
	
	return "<li$ex>$item</li>\n";
}

/* An HREF link to another document or portion of the same document.  $title
 * is the user-visible portion of the link, while $link is what we go to if
 * the link is clicked.
 */
function html_link($title, $link, $ex = NULL)
{
	$ex = misc_extraopts($ex);
	return "<a href=\"$link\"$ex>$title</a>";
}

/* A horizontal rule.
 */
function html_rule($ex = NULL)
{
	$ex = misc_extraopts($ex);
	return "<hr$ex>\n";
}

function html_image($desc, $img)
{
	return "<img alt=\"$desc\" src=\"$img\">";
}


?>
