<?php
// configuration file
// $Id: config.inc,v 1.5 2002/06/21 13:46:34 blorson Exp $
//
// My real devel database
pql_set_define("PQL_CONF_HOST","ldapi://%2fvar%2frun%2fslapd%2fldapi.main;;ou=QmailLDAP,o=Bayour.COM,c=SE");
// ou=Organization,c=Country: turbo@example.com/turbo
//pql_set_define("PQL_CONF_HOST","ldapi://%2fvar%2frun%2fslapd%2fldapi.test1;;ou=QmailLDAP,c=IT");

pql_set_define("PQL_CONF_SUBTREE_USERS", "ou=People");
pql_set_define("PQL_CONF_SUBTREE_GROUPS", "ou=Groups");

function user_generate_mailstore($ldap, $email, $dn, $entry, $type) {
  $mailstore = '';
  
  // -------------- Debugging 1:
  // If you suspect that this function isn't doing what it's supposed to do,
  // uncomment the next few lines. This can also be used in bugtracker or the
  // mailinglist for help...
  //echo "user_generate_mailstore('<i>linkid</i>', '$email', '$dn', '<i>array</i>', '$type')<br>";
  //echo "The entry array: "; printr($entry);
  
  // -------------- Template 1: domains baseMailDir/uid
  if($dn) {
	// We're called with a dn of a branch object.
	
	// ... retreive the 'baseMailDir' attribute value from the branch object.
	$mailstore = pql_get_attribute($ldap->ldap_linkid, $dn, pql_get_define("PQL_ATTR_BASEMAILDIR"));
	
	// ... retreive the 'defaultDomainName' attribute value from the branch object.
	$domain    = pql_get_attribute($ldap->ldap_linkid, $dn, pql_get_define("PQL_ATTR_DEFAULTDOMAIN"));
	
	// ... double check - do we have a home directory?
	if(!$mailstore)
	  // Nope. Maybe we have the 'virtualBaseHomeDir' attribute specified
	  // in the base object...
	  $mailstore = pql_get_define("PQL_CONF_VIRTUAL_BASEHOME");
  } else {
	// Default base directory
	$mailstore = "/var/mail";
	
	// The branch name is (should be) included in the calling of the function.
	$domain    = $entry["BRANCH_NAME"];
  }
  
  if($type == 'branch') {
	// We're creating a branch, so add the domain name to the path.
	$branch = '%d%/';
  }
  
  if(! ereg("/$", $mailstore)) {
	// The base mail directory value doesn't end with a slash, add one.
	// The '$branch' variable will be empty for users, set if a branch.
	$mailstore = $mailstore . "/" . $branch . "%u%";
  } else {
	// The base mail directory value doesn't end with a slash, add one.
	// The '$branch' variable will be empty for users, set if a branch.
	$mailstore = $mailstore . $branch . "%u%";
  }

  // Substitue the '%X%' values with real values...
  $mailstore = pql_complete_constant($mailstore, array("d" => pql_format_international($domain),
													   "u" => $entry[pql_get_define("PQL_ATTR_UID")],
													   "h" => $entry[pql_get_define("PQL_ATTR_MAILHOST")],
													   "m" => $entry[pql_get_define("PQL_ATTR_MAIL")]));
  return($mailstore);
}

function user_generate_homedir($ldap, $email, $dn, $entry, $type) {
  if($dn) {
	$homedir = pql_get_attribute($ldap, $dn, pql_get_define("PQL_ATTR_BASEHOMEDIR"));
	if(is_array($homedir))
	  $homedir = $homedir[0];
	
	$domain  = pql_get_attribute($ldap, $dn, pql_get_define("PQL_ATTR_DEFAULTDOMAIN"));
	if(is_array($domain))
	  $domain = $domain[0];
  } else {
	$homedir = "/home";
	$domain  = $entry["BRANCH_NAME"];
  }
  
  if($type == 'branch')
	// We're creating a branch, so add the domain to string
	$branch = '%d%/';
  
  if(! ereg("/$", $basemaildir)) {
	$homedir = $homedir . "/" . $branch . "%u%";
  } else {
	$homedir = $homedir . $branch . "%u%";
  }
  
  // Substitue the '%X%' values with real values...
  $homedir = pql_complete_constant($homedir, array("d" => pql_format_international($domain),
												   "u" => $entry[pql_get_define("PQL_ATTR_UID")],
												   "h" => $entry[pql_get_define("PQL_ATTR_MAILHOST")]));
  return($homedir);
}

function user_generate_uid($ldap, $surname, $name, $email, $domain, $account_type) {
	return(pql_get_next_username($ldap, $domain));		// Use prefix from branch to generate UID.
}

function user_generate_email($ldap_linkid, $surname, $lastname, $domainname, $domain, $account_type) {
	// Compose the username with first+last name with dot in between.
	if(!empty($surname))
	  $mail = $surname;
	if(!empty($lastname))
	  $mail .= ".$lastname";
	if(!empty($domainname))
	  $mail .= "@$domainname";

	return(lc($mail));
}

function user_generate_aci($ldap_linkid, $user, $type) {
	global $_SESSION;
	$i = 0;

	// Public entries
	$aci[$i] = "$i#entry#grant;r,s,c;objectClass,[entry]#public#"; $i++;
	
	// Non-public entries
	if($type == 'user') {
		$aci[$i] = "$i#entry#grant;x;userPassword,krb5PrincipalName#public#"; $i++;
		$aci[$i] = "$i#entry#grant;x;cn,mail,mailAlternateAddress#public#"; $i++;
		$aci[$i] = "$i#entry#grant;s;userPassword,krb5PrincipalName,cn,mail,mailAlternateAddress#access-id#uid=proxy,ou=System,o=Bayour.COM,c=SE"; $i++;
		$aci[$i] = "$i#entry#grant;r,s,c;uid,cn,accountStatus,uidNumber,gidNumber,gecos,homeDirectory,loginShell,trustModel,accessTo,mailMessageStore#public#"; $i++;

		# What the Qmail user have access to
		$aci[$i] = "$i#entry#grant;r,s,c;mail,mailAlternateAddress,mailHost,mailQuotaSize,mailQuotaCount,accountStatus,deliveryMode,userPassword,mailMessageStore,deliveryProgramPath#access-id#uid=qmail,ou=System,o=Bayour.COM,c=SE"; $i++;

		# What the QmailGroup user have access to
		$aci[$i] = "$i#entry#grant;r,s,c;membersOnly,senderConfirm,confirmText,moderatorText,dnModerator,dnMember,dnSender,rfc822Moderator,rfc822Member,rfc822Sender,filterMember,filterSender#access-id#uid=qmail,ou=System,o=Bayour.COM,c=SE"; $i++;

		# What authenticated users have access
		$aci[$i] = "$i#entry#grant;r,s,c;sn,givenName,homePostalAddress,mobile,homePhone,labeledURI,mailForwardingAddress,street,physicalDeliveryOfficeName,mailMessageStore,o,l,st,telephoneNumber,postalCode,title#users#"; $i++;

		# What users themselfs have access to in their own object
		$aci[$i] = "$i#entry#grant;w,r,s,c;sn,givenName,homePostalAddress,mobile,homePhone,labeledURI,mailForwardingAddress,street,physicalDeliveryOfficeName,o,l,st,telephoneNumber,postalCode,title,deliveryMode,userPassword#self#"; $i++;

		$aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#$user"; $i++;
	} elseif($type == 'group') {
		$aci[$i] = "$i#entry#grant;r,s,c;cn,gidNumber#public#"; $i++;
	} elseif($type == 'branch') {
		if(pql_get_define("PQL_CONF_REFERENCE_DOMAINS_WITH", $_REQUEST["rootdn"]) == "o") {
			$aci[$i] = "$i#entry#grant;r,s,c;o#public#"; $i++;
		} else {
			$aci[$i] = "$i#entry#grant;r,s,c;dc#public#"; $i++;
		}
	} elseif($type == 'dnszone') {
		$aci[$i] = "$i#entry#grant;r,s,c;dc#public#"; $i++;
		$aci[$i] = "$i#entry#grant;w,r,s,c;[all]#access-id#uid=bind9,ou=System,o=Bayour.COM,c=SE"; $i++;
	} elseif($type == 'websrv') {
		$aci[$i] = "$i#entry#grant;r,s,c;cn#public#"; $i++;
		$aci[$i] = "$i#entry#grant;w,r,s,c;[all]#access-id#uid=apache,ou=System,o=Bayour.COM,c=SE"; $i++;
	} elseif($type == 'qmail') {
		$aci[$i] = "$i#entry#grant;r,s;[all]#access-id#uid=qmail,ou=System,o=Bayour.COM,c=SE"; $i++;
	}

	// Add all the super admins with full access.
	$admins = pql_get_attribute($ldap_linkid, urldecode($_SESSION["BASE_DN"][0]), pql_get_define("PQL_ATTR_ADMINISTRATOR"));
	if(is_array($admins)) {
		for($j=0; $admins[$j]; $j++) {
			$aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#".$admins[$j]; $i++;
			$i++;
		}
	} elseif($admins)
	  $aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#$admins"; $i++;

	return($aci);
}

function do_exec($command, $output, &$return) {
	return(@exec($command, $output, $return));

	$return = 100;
	return(false);
}

/*
 * Local variables:
 * mode: php
 * tab-width: 4
 * End:
 */
?>
