<?php
// control attribute plugin for
// rcpthosts (blocked local addresses)
//
// $Id: attrib.control.rcpthosts.inc,v 2.21.10.2 2004/05/05 11:03:09 turbo Exp $

// {{{ rcpthosts_check(type)
function rcpthosts_check($type) {
    global $error, $LANG;

    // check validity
    if(is_array($_REQUEST["rcpthosts"])) {
		foreach($_REQUEST["rcpthosts"] as $key => $host) {
			if($host == "")
			  continue;
			
			if(!pql_check_hostaddress($host)) {
				$error[pql_get_define("PQL_ATTR_RCPTHOSTS")."_".$key] = $LANG->_('Invalid');
				$is_error = true;
			}
		} // end foreach
    } // end if is_array
	
    if($is_error)
	  return false;
    
    return true;
}
// }}}

// {{{ rcpthosts_init(host)
// init values
function rcpthosts_init($host) {
    global $_pql_control;

    // fetch data from ldap server
    $_REQUEST["rcpthosts"] = pql_control_get_attribute($_pql_control->ldap_linkid,
										   pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
										   pql_get_define("PQL_ATTR_RCPTHOSTS"));
    
    if(is_null($_REQUEST["rcpthosts"]))
	  return true;
}
// }}}


// {{{ rcpthosts_print_view(host)
function rcpthosts_print_view($host) {
    global $_pql_control, $LANG;
    
    // init data
    rcpthosts_init($host);
?>
  <table cellspacing="0" cellpadding="3" border="0">
    <th align="left"><?=pql_complete_constant($LANG->_('Allowed %attrib% for host %host%'), array('host' => $host, 'attrib' => pql_get_define("PQL_ATTR_RCPTHOSTS")))?></th>
      <tr class="title"><td><?=$LANG->_('Domain')?></td></tr>
<?php if(!is_array($_REQUEST["rcpthosts"])) { ?>
      <tr class="<?php pql_format_table(); ?>"><td><?=pql_complete_constant($LANG->_('No %attrib% defined'), array('attrib' => pql_get_define("PQL_ATTR_RCPTHOSTS")))?></td></tr>
<?php } else {
		asort($_REQUEST["rcpthosts"]);
		foreach($_REQUEST["rcpthosts"] as $rcpt) {
?>
      <tr class="<?php pql_format_table(); ?>"><td><?=pql_maybe_idna_decode($rcpt)?></td></tr>
<?php   } // end foreach
    } // end if is_array

    if(pql_get_define("PQL_CONF_CONTROL_AUTOADDRCPTHOSTS", $_REQUEST["rootdn"])) {
?>
      <tr class="subtitle">
        <td><a href="control_edit_attribute.php?rootdn=<?=$_REQUEST["rootdn"]?>&attrib=<?=pql_get_define("PQL_ATTR_RCPTHOSTS")?>&type=replicate&mxhost=<?=$host?>&submit=1"><img src="images/edit.png" width="12" height="12" border="0" alt="replicate"><?=$LANG->_('Click here to start replication manually')?></a></td>
      </tr>

      <br>

      <tr class="subtitle">
        <td>
          <table cellspacing="0" cellpadding="3" border="0">
            <tr>
              <td><img src="images/info.png" width="16" height="16" border="0"></td>
              <td>These values will be automatically generated by phpQLAdmin, and cannot be edited.<br>If you want to do it by yourself eg. to control more than one QmailLDAP server,<br>disable '<i>Automatically replicate domains to rcpthosts</i>' in the configuration.</td>
            </tr>
          </table>
        </td>
      </tr>
<?php } else { ?>
      <tr class="subtitle">
        <td><a href="control_edit_attribute.php?rootdn=<?=$_REQUEST["rootdn"]?>&attrib=<?=pql_get_define("PQL_ATTR_RCPTHOSTS")?>&mxhost=<?=$host?>&view=hosts"><img src="images/edit.png" width="12" height="12" border="0"><?=$LANG->_('Change options')?></a> (<?=$LANG->_('The automatic replication with domain is disabled')?>)</td>
      </tr>
    </th>
<?php }	?>
  </table>
<?php
}
// }}}

// {{{ rcpthosts_print_form(void)
function rcpthosts_print_form() {
    global $error, $LANG;
?>
  <form action="<?=$_SERVER["PHP_SELF"]?>" method="post">
    <table cellspacing="0" cellpadding="3" border="0">
      <th colspan="3" align="left"><?=pql_complete_constant($LANG->_('Add %what%'), array('what' => $LANG->_('domain')))?>:</th>
        <tr class="<?php pql_format_table(); ?>">
          <td><input type="text" name="set" size="30"></td>
        </tr>
      </th>
    </table>

    <input type="hidden" name="submit" value="1">
    <input type="hidden" name="attrib" value="<?=$_REQUEST["attrib"]?>">
    <input type="hidden" name="mxhost" value="<?=$_REQUEST["mxhost"]?>">
    <input type="hidden" name="rootdn" value="<?=$_REQUEST["rootdn"]?>">
    <input type="hidden" name="view"   value="<?=$_REQUEST["view"]?>">
    <br>
    <input type="submit" value="<?=$LANG->_('Save')?>">
  </form>
<?php
}
// }}}

// {{{ rcpthosts_save(type, host)
function rcpthosts_save($type, $host) {
    global $_pql_control, $LANG;

	if(!$host) {
		// Get all QmailLDAP/Controls hosts
		$hosts = pql_control_get_hosts($_pql_control->ldap_linkid, $_SESSION["USER_SEARCH_DN_CTR"]);
		if(is_array($hosts)) {
			if($type == 'add')
			  $modify_host = 1; // Add domain to host
			else
			  $modify_host = 0; // Don't remove the domain from the host

			foreach($hosts as $host) {
				// Get rcpthosts in each of the hosts
				$rcpthosts = pql_control_get_attribute($_pql_control->ldap_linkid,
													   pql_get_define("PQL_ATTR_CN") . "=" . $host . "," . $_SESSION["USER_SEARCH_DN_CTR"],
													   pql_get_define("PQL_ATTR_RCPTHOSTS"));
				if(is_array($rcpthosts)) {
					foreach($rcpthosts as $rcpt) {
						// In the RCPTHosts configured for the host, do we have what we're looking for?
						if($rcpt == $_REQUEST["set"])
						  if($type == 'add')
							$modify_host = 0; // The domain exists, don't add
						  else
							$modify_host = 1; // The domain exists, remove it
					}
				}

				if($modify_host)
				  $HOSTS[] = $host;
			}
		}
	} else
	  $HOSTS[] = $host;

	if($HOSTS[1])
	  // We have more than one host
	  $all = ' all';

    switch($type) {
      case "replicate":
		// start replication manually
		if(pql_control_update_domains($_pql_control, $_REQUEST["rootdn"],
									  pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
									  $host, '', 'rcpthosts'))
		  $msg = pql_complete_constant($LANG->_('Successfully replicated %what%'),
									   array('what' => pql_get_define("PQL_ATTR_RCPTHOSTS")));
		else
		  $msg = pql_complete_constant($LANG->_('Failed to replicate %what%'),
									   array('what' => pql_get_define("PQL_ATTR_RCPTHOSTS")))
			. ": " . pql_format_error(0);
	
		attribute_forward($msg);
		break;

      case "del":
		// delete entry
		foreach($HOSTS as $host) {
			// remove specified domain from rcpthosts in host object
			if(pql_control_remove_attribute($_pql_control->ldap_linkid,
											pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
											pql_get_define("PQL_ATTR_RCPTHOSTS"), $_REQUEST["set"]))
			  $msg = pql_complete_constant($LANG->_('Successfully removed %domain% from %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_RCPTHOSTS"),
												 'domain' => $_REQUEST["set"]));
			else
			  $msg = pql_complete_constant($LANG->_('Failed to remove %domain% from %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_RCPTHOSTS"),
												 'domain' => $_REQUEST["set"]))
				. ": " . pql_format_error(0);
		}
		break;

      case "add":
		// add entry
		foreach($HOSTS as $host) {
			// adding specified domain to rcpthosts in host object
			if(pql_control_add_attribute($_pql_control->ldap_linkid,
										 pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
										 pql_get_define("PQL_ATTR_RCPTHOSTS"), $_REQUEST["set"]))
			  $msg = pql_complete_constant($LANG->_('Successfully added %domain% to %value% %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_RCPTHOSTS"),
												 'domain' => $_REQUEST["set"],
												 'value'  => $all));
			else
			  $msg = pql_complete_constant($LANG->_('Failed adding %domain% to %value% %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_RCPTHOSTS"),
												 'domain' => $_REQUEST["set"],
												 'value'  => $all))
				. ": " . pql_format_error(0);
		}
		break;

      default:
		die(pql_complete_constant($LANG->_('Unknown save type %type% in file %file%, function save()'),
								  array('type' => $type, 'file' => __FILE__)));
    }
		
	if($msg)
	  // redirect back to host details
	  attribute_forward($msg);
}
// }}}


// {{{ rcpthosts_help(void)
function rcpthosts_help() {
	global $LANG;
?>
Allowed RCPT domains.  If rcpthosts is supplied,
qmail-smtpd will reject any envelope recipient address
with a domain not listed in rcpthosts.
<br>
Exception:  If the environment variable RELAYCLIENT is
set, qmail-smtpd will ignore rcpthosts, and will append
the value of RELAYCLIENT to each incoming recipient
address.
<br><br>
rcpthosts may include wildcards:
<br><br>
		heaven.af.mil<br>
		.heaven.af.mil<br>
<br>
Envelope recipient addresses without @ signs are always
allowed through.
<?php
}
// }}}

// {{{ rcpthosts_help_cr(void)
function rcpthosts_help_cr() {
	global $LANG;
	echo $LANG->_('Help text taken from qmail man pages');
}
// }}}

// Local variables:
// mode: php
// mode: font-lock
// tab-width: 4
// End:
?>

