<?php
/**
 * Latin American Spanish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Eduardo Cociña
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Eduardo Cociña
 * @version $Id: lang.es-ar.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access a language file directly.";
	exit;
}

$pgv_lang["qm"]	= "?";
$pgv_lang["page_help"]	= "Ayuda";
$pgv_lang["help_for_this_page"]	= "Ayuda con ésta página";
$pgv_lang["help_contents"]	= "Contenido de ayuda";
$pgv_lang["show_context_help"]	= "Mostrar ayuda contextual";
$pgv_lang["hide_context_help"]	= "Ocultar ayuda contextual";
$pgv_lang["sorry"]	= "<b>Lo siento, no se ha finalizado aún el texto de ayuda para esta página</b>";
$pgv_lang["help_not_exist"]	= "<b>Todavía no existe un texto de ayuda para esta página o ítem</b>";
$pgv_lang["resolution"]	= "Resolución de pantalla";
$pgv_lang["menu"]	= "Menú";
$pgv_lang["header"]	= "Encabezamiento";
$pgv_lang["imageview"]			= "Visualizador de imágenes";
$pgv_lang["login_head"]			= "Ingreso de usuario PhpGedView";
$pgv_lang["confirm"]	= "Confirme Contraseña:";
//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]	= "ERROR: No es posible abrir el archivo GEDCOM";
$pgv_lang["for_support"]	= "Para ayuda o información póngase en contacto con";
$pgv_lang["for_contact"]	= "Para ayuda con preguntas de genealogía por favor póngase en contacto con";
$pgv_lang["for_all_contact"]	= "Para soporte técnico o preguntas de genealogía póngase en contacto con: ";
$pgv_lang["build_title"]	= "Construyendo el Índice";
$pgv_lang["build_error"]	= "El archivo GEDCOM ha sido actualizado.";
$pgv_lang["please_wait"]	= "Por favor, espere mientras el índice se reconstruye.";
$pgv_lang["choose_gedcom"]	= "Seleccione un archivo GEDCOM";
$pgv_lang["username"]	= "Nombre de Usuario:";
$pgv_lang["invalid_username"]	= "El nombre de usuario contiene caracteres inválidos";
$pgv_lang["fullname"]	= "Nombre completo";
$pgv_lang["password"]	= "Contraseña";
$pgv_lang["login"]	= "Ingresar";
$pgv_lang["login_aut"]	= "Editar Usuario";
$pgv_lang["logout"]	= "Salir";
$pgv_lang["admin"]	= "Administrar";
$pgv_lang["logged_in_as"]	= "Registrado como";
$pgv_lang["my_pedigree"]	= "Mi Árbol";
$pgv_lang["my_indi"]	= "Mi Ficha";
$pgv_lang["yes"]	= "Sí";
$pgv_lang["no"]	= "No";
$pgv_lang["change_theme"]		= "Cambiar el Tema";
$pgv_lang["no_support"]	= "Se ha detectado que su navegador no soporta las normas utilizadas en el sitio PhpGedView. Muchos navegadores soportan estas normas en sus más recientes versiones. Por favor actualice su navegador a una versión más reciente.";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]	= "Árbol de Antepasados";
$pgv_lang["gen_ped_chart"]	= "#PEDIGREE_GENERATIONS# generaciones de Antepasados";
$pgv_lang["generations"]	= "Generaciones";
$pgv_lang["view"]	= "Ver";
$pgv_lang["fam_spouse"]	= "Familia con el cónyuge:";
$pgv_lang["root_person"]	= "<b>ID</b> de la persona base";
$pgv_lang["hide_details"]	= "Ocultar detalles";
$pgv_lang["show_details"]	= "Mostrar detalles";
$pgv_lang["person_links"]	= "Vínculos a gráficos, familias y otros familiares cercanos a esta persona. Presione este ícono para que esta página comience con esta persona.";
$pgv_lang["zoom_box"]	= "Agrandar/achicar esta caja.";
$pgv_lang["portrait"]	= "Vertical";
$pgv_lang["landscape"]	= "Apaisado";
$pgv_lang["start_at_parents"]	= "Comenzar con los padres";
$pgv_lang["charts"]	= "Gráficos";
$pgv_lang["lists"]	= "Listas";
$pgv_lang["welcome_page"]	= "Página de Bienvenida";
$pgv_lang["max_generation"]	= "El número máximo de generaciones es #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]	= "El número mínimo de generaciones es 3";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Imposible encontrar una familia con el ID";
$pgv_lang["unable_to_find_indi"]	= "Imposible encontrar una persona con el ID";
$pgv_lang["unable_to_find_record"]	= "Imposible encontrar un registro con el ID";
$pgv_lang["unable_to_find_source"]	= "Imposible encontrar una fuente con el ID";
$pgv_lang["unable_to_find_repo"]	= "Imposible encontrar la información con el ID";
$pgv_lang["repo_name"]	= "Nombre Archivo:";
$pgv_lang["address"]	= "Dirección:";
$pgv_lang["phone"]	= "Teléfono:";
$pgv_lang["source_name"]	= "Fuente:";
$pgv_lang["title"]	= "Título";
$pgv_lang["author"]	= "Autor:";
$pgv_lang["publication"]	= "Publicación:";
$pgv_lang["call_number"]	= "Número a llamar:";
$pgv_lang["living"]	= "Viva";
$pgv_lang["private"]	= "Privada";
$pgv_lang["birth"]	= "Nac.:";
$pgv_lang["death"]	= "Def.:";
$pgv_lang["descend_chart"]	= "Gráfico de Descendientes";
$pgv_lang["individual_list"]	= "Lista de Personas";
$pgv_lang["family_list"]	= "Lista de Familias";
$pgv_lang["source_list"]	= "Lista de Fuentes";
$pgv_lang["place_list"]	= "Jerarquía de Lugares";
$pgv_lang["media_list"]	= "Lista MultiMedios";
$pgv_lang["search"]	= "Buscar";
$pgv_lang["clippings_cart"]	= "Carrito Genealógico";
$pgv_lang["not_an_array"]	= "No existe en la lista";
$pgv_lang["print_preview"]	= "Impresión";
$pgv_lang["cancel_preview"]	= "Regresar a la vista normal";
$pgv_lang["change_lang"]	= "Selector de Idiomas";
$pgv_lang["print"]	= "Imprimir";
$pgv_lang["total_queries"]	= "Consultas a la Base de Datos:";
$pgv_lang["back"]	= "Regresar";
$pgv_lang["privacy_list_indi_error"]	= "Por reglas de privacidad, una o más personas están ocultas.";
$pgv_lang["privacy_list_fam_error"]	= "Por reglas de privacidad, una o más familias están ocultas.";
$pgv_lang["aka"]	= "También conocido(s) como";
//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]	= "Hombre";
$pgv_lang["female"]	= "Mujer";
$pgv_lang["temple"]	= "Templo SUD";
$pgv_lang["temple_code"]	= "Código Templo SUD:";
$pgv_lang["status"]	= "Status";
$pgv_lang["source"]	= "Fuente";
$pgv_lang["citation"]	= "Cita:";
$pgv_lang["text"]	= "Texto Fuente:";
$pgv_lang["note"]	= "Nota";
$pgv_lang["NN"]	= "Desconocido";
$pgv_lang["PN"]	= "Desconocido";
$pgv_lang["unrecognized_code"]	= "Código GEDCOM desconocido";
$pgv_lang["unrecognized_code_msg"]	= "Este es un error y desearíamos corregirlo. Por favor reporte este error a";
$pgv_lang["indi_info"]	= "Información Personal";
$pgv_lang["pedigree_chart"] 	= "Gráfico de Antepasados";
$pgv_lang["desc_chart2"]	= "Gráfico de Descendientes";
$pgv_lang["family_with"]	= "Familia con";
$pgv_lang["as_spouse"]	= "Familia con el Cónyuge";
$pgv_lang["as_child"]	= "Familia con los Padres";
$pgv_lang["view_gedcom"]	= "Ver Registro GEDCOM";
$pgv_lang["add_to_cart"]	= "Añadir al Carrito Genealógico";
$pgv_lang["still_living_error"]	= "Esta persona todavía está viva o su defunción no ha sido registrada. La información de las personas vivas no es pública.<br>Para más información contactar a";
$pgv_lang["privacy_error"]	= "Los detalles de esta persona son privados.<br />";
$pgv_lang["more_information"]	= "Para más información contactar a";
$pgv_lang["name"]	= "Nombre";
$pgv_lang["given_name"]	= "Primer nombre:";
$pgv_lang["surname"]	= "Apellido:";
$pgv_lang["suffix"]	= "Sufijo:";
$pgv_lang["object_note"]	= "Nota Objeto:";
$pgv_lang["sex"]	= "Sexo";
$pgv_lang["personal_facts"]	= "Acontecimientos y detalles personales";
$pgv_lang["type"]	= "Tipo";
$pgv_lang["place_description"]	= "Lugar/Descripción";
$pgv_lang["parents"] 	= "Padres:";
$pgv_lang["siblings"] 	= "Hermano";
$pgv_lang["father"] 	= "Padre";
$pgv_lang["mother"] 	= "Madre";
$pgv_lang["relatives"]	= "Familiares Cercanos";
$pgv_lang["child"]	= "Hijo";
$pgv_lang["spouse"]	= "Cónyuge";
$pgv_lang["surnames"]	= "Apellidos";
$pgv_lang["adopted"]	= "Adoptado";
$pgv_lang["foster"]	= "Adoptivo";
$pgv_lang["link_as"]	= "Relacione esta persona a una familia existente como un(a) ";
$pgv_lang["sealing"]	= "Sealing";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]	= "Información de la Familia";
$pgv_lang["family_group_info"]	= "Información del Grupo Familiar";
$pgv_lang["husband"]	= "Esposo";
$pgv_lang["wife"]	= "Esposa";
$pgv_lang["marriage"]	= "Matrimonio:";
$pgv_lang["lds_sealing"]	= "Sello SUD:";
$pgv_lang["marriage_license"]	= "Acta matrimonial:";
$pgv_lang["media_object"]	= "Objeto Multimedio:";
$pgv_lang["children"]	= "Hijos";
$pgv_lang["no_children"]	= "Sin Hijos";
$pgv_lang["parents_timeline"]	= "Ver a la pareja en el gráfico de Cronología";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]	= "Carrito Genealógico";
$pgv_lang["clip_explaination"]	= "El Carrito Genealógico le permite tomar 'segmentos' del árbol familiar y reunirlos en un solo archivo GEDCOM para grabarlo.<br /><br />";
$pgv_lang["item_with_id"]	= "Ítem con ID";
$pgv_lang["error_already"]	= "ya está en su carrito.";
$pgv_lang["which_links"]	= "Qué vínculos de esta familia le gustaría añadir?";
$pgv_lang["just_family"]	= "Añadir este registro familiar.";
$pgv_lang["parents_and_family"]	= "Añadir a los padres con este registro familiar.";
$pgv_lang["parents_and_child"]	= "Añadir a los padres e hijos con este registro familiar.";
$pgv_lang["parents_desc"]	= "Añadir a los padres y todos los registros de los descendientes con este registro familiar.";
$pgv_lang["continue"]	= "Continúe Añadiendo";
$pgv_lang["which_p_links"]	= "Qué vínculos de esta persona le gustaría añadir también?";
$pgv_lang["just_person"]	= "Añadir sólo esta persona.";
$pgv_lang["person_parents_sibs"]= "Añadir esta persona, sus padres y hermanos.";
$pgv_lang["person_ancestors"]	= "Añadir esta persona y su línea de antepasados directos.";
$pgv_lang["person_ancestor_fams"]= "Añadir esta persona, su línea de antepasados directos y sus familias.";
$pgv_lang["person_spouse"]	= "Añadir esta persona, su cónyuge, e hijos.";
$pgv_lang["person_desc"]	= "Añadir esta persona, su cónyuge, y todos los registros de sus descendientes.";
$pgv_lang["unable_to_open"]	= "No es posible abrir la carpeta del Carrito para escritura";
$pgv_lang["person_living"]	= "Esta persona vive. Los detalles personales no se incluyen.";
$pgv_lang["person_private"]	= "Los detalles sobre esta persona son privados. Los detalles personales no se incluyen.";
$pgv_lang["family_private"]	= "Los detalles sobre esta familia son privados. Los detalles familiares no se incluyen.";
$pgv_lang["download"]	= "Presione en el botón derecho (control-click en Macintosh) en los vínculos y presione \"Guardar como\" para grabar los archivos.";
$pgv_lang["media_files"]	= "Archivos MultiMedios referenciados en este GEDCOM";
$pgv_lang["cart_is_empty"]	= "Su carrito está vacío.";
$pgv_lang["id"]	= "ID";
$pgv_lang["name_description"]	= "Nombre/Descripción";
$pgv_lang["remove"]	= "Eliminar";
$pgv_lang["empty_cart"]	= "Vaciar Carrito";
$pgv_lang["download_now"]	= "Grabar ahora";
$pgv_lang["indi_downloaded_from"]	= "Este individuo fue obtenido de:";
$pgv_lang["family_downloaded_from"] = "Esta familia fue obtenida de:";
$pgv_lang["source_downloaded_from"] = "Esta fuente fue obtenida de:";
//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]	= "Conexiones con Lugares encontradas";
$pgv_lang["top_level"]	= "Nivel principal";
$pgv_lang["form"]	= "Los lugares se codifican en la forma: ";
$pgv_lang["default_form"]	= "Ciudad, Municipio, Provincia/Estado, País";
$pgv_lang["default_form_info"]	= "(Por omisión)";
$pgv_lang["view_records_in_place"]	= "Ver todos los registros encontrados para este lugar";
$pgv_lang["gedcom_form_info"]	= "(GEDCOM)";
$pgv_lang["unknown"]	= "Desconocido";
$pgv_lang["individuals"]	= "Individuos";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]	= "Lista de objetos MultiMedio";
$pgv_lang["media_found"]	= "Objetos MultiMedio encontrados";
$pgv_lang["view_person"]	= "Ver Persona";
$pgv_lang["view_family"]	= "Ver Familia";
$pgv_lang["view_source"]	= "Ver Fuente";
$pgv_lang["prev"]	= "&lt; Anterior";
$pgv_lang["next"]	= "Siguiente &gt;";
$pgv_lang["file_not_found"]	= "No se encontró el Archivo.";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]	= "Buscar en los archivos GEDCOM";
$pgv_lang["enter_terms"]	= "Ingrese términos de búsqueda:";
$pgv_lang["soundex_search"]	= "Búsqueda <b>Soundex</b> por Nombre:";
$pgv_lang["search_results"]	= "Resultados de la búsqueda";
$pgv_lang["sources"]	= "Fuentes";
$pgv_lang["firstname_search"]	= "Primer Nombre:";
$pgv_lang["lastname_search"]	= "Apellido:";
$pgv_lang["search_place"]	= "Lugar:";
$pgv_lang["search_year"]	= "Año:";
$pgv_lang["lastname_empty"]	= "Por favor escriba un apellido.";
$pgv_lang["no_results"]	= "No se encontraron resultados.";
$pgv_lang["soundex_results"]	= "Quizás las siguientes coincidencias Soundex le sean de ayuda.";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]	= "Fuentes encontradas";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]	= "Información de la Fuente";
$pgv_lang["other_records"]	= "Otros registros relacionados con esta fuente:";
$pgv_lang["people"]	= "Personas";
$pgv_lang["families"]	= "Familias";
$pgv_lang["invalid_gedformat"]	= "Formato GEDCOM 5.5 inválido";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]	= "Construyendo el Índice de Personas y Familias";
$pgv_lang["building_index"]	= "Construyendo el Índice";
$pgv_lang["importing_records"]	= "Importando Registros a la Base de datos";
$pgv_lang["detected_change"]	= "PhpGedView detectó un cambio en el archivo #GEDCOM#. El archivo Índice debe reconstruirse antes de continuar.";
$pgv_lang["flushing"]	= "Depurando Contenidos";
$pgv_lang["exec_time"]	= "Tiempo total de ejecución:";
$pgv_lang["unable_to_create_index"] = "No se pudo crear un archivo Índice. Asegúrese que están habilitados los permisos de escritura en el directorio de PhpGedView. Los permisos pueden cambiarse nuevamente una vez que se han grabado los archivos.";
$pgv_lang["indi_complete"]	= "Archivo Índice de individuos actualizado.";
$pgv_lang["family_complete"]	= "Archivo Índice de familias actualizado.";
$pgv_lang["source_complete"]	= "Archivo Índice de Fuentes actualizado.";
$pgv_lang["tables_exist"]	= "Ya existen tablas PhpGedView en esta base de datos";
$pgv_lang["you_may"]	= "Puede:";
$pgv_lang["drop_tables"]	= "Borrar las tablas actuales";
$pgv_lang["import_multiple"]	= "Importar y trabajar con varios GEDCOM";
$pgv_lang["explain_options"]	= "Si elige eliminar las tablas, todos los datos serán reemplazados con este GEDCOM <br>Si escoge importar y trabajar con múltiples GEDCOMs, PhpGedView borrará todos los datos que sean importados usando un GEDCOM con el mismo nombre de archivo. Esta opción le permite guardar múltiples GEDCOM en las mismas tablas y cambiar fácilmente entre ellos.";
$pgv_lang["path_to_gedcom"]	= "Ingrese la ruta de su archivo GEDCOM:";
$pgv_lang["gedcom_title"]	= "Ingrese una descripción para los datos de este archivo GEDCOM";
$pgv_lang["index_complete"]	= "Índice completo.";
$pgv_lang["updating_is_dead"]	= "La actualización está detenida para las INDI";
$pgv_lang["updating_family_names"]	= "Actualizando los nombres de las familias para las FAM";
$pgv_lang["processed_for"]	= "Archivo procesado para";
$pgv_lang["run_tools"]	= "Desea ejecutar alguna de las siguientes herramientas en su GEDCOM antes de ser importado?:";
$pgv_lang["addmedia"]	= "Agregar herramienta de MultiMedio";
$pgv_lang["dateconvert"]	= "Herramienta de conversión de fechas";
$pgv_lang["xreftorin"]	= "Convertir IDs XREF a números RIN";
$pgv_lang["tools_readme"]	= "Vea la sección herramientas del archivo #README.TXT# para mayor información.";
//-- INDIVIDUAL AND FAMILY LIST FILE MESSAGES
$pgv_lang["total_fams"]	= "Total de familias encontradas";
$pgv_lang["total_indis"]	= "Total de personas encontradas";
$pgv_lang["starts_with"]	= "Comienza con:";
$pgv_lang["person_list"]	= "Lista de Personas:";
$pgv_lang["paste_person"]	= "\"Pega\" Persona";
$pgv_lang["notes_sources_media"]	= "Notas, Fuentes, y MultiMedios";
$pgv_lang["notes"]	= "Notas";
$pgv_lang["ssourcess"]	= "Fuentes";
$pgv_lang["media"]	= "Medios";
$pgv_lang["name_contains"]	 = "Nombre Contiene:";
$pgv_lang["filter"]	= "Filtro";
$pgv_lang["find_individual"]	= "Encontrar persona con ID";
$pgv_lang["find_sourceid"]	= "Encontrar ID de la fuente";
$pgv_lang["skip_surnames"]	= "Mostrar listas de nombres completos";
$pgv_lang["show_surnames"]	= "Mostrar listas de apellidos";
$pgv_lang["all"]	= "Todos";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]	= "Edad";
$pgv_lang["timeline_title"]	= "Cronología de PhpGedView";
$pgv_lang["timeline_chart"]	= "Cronología";
$pgv_lang["remove_person"]	= "Borrar Persona";
$pgv_lang["show_age"]	= "Mostrar Edad";
$pgv_lang["add_another"]	= "Añadir otra persona al gráfico:<br>ID Persona:";
$pgv_lang["find_id"]	= "Buscar ID";
$pgv_lang["show"]	= "Mostrar";
$pgv_lang["year"]	= "Año:";
$pgv_lang["timeline_instructions"]	= "En los navegadores actuales puede seleccionar y mover las cajas en el gráfico.";
$pgv_lang["zoom_in"]	= "Agrandar";
$pgv_lang["zoom_out"]	= "Achicar";

$pgv_lang["gregorian"]            = "Gregoriano";
$pgv_lang["julian"]               = "Juliano";
$pgv_lang["french"]               = "Francés";
$pgv_lang["jewish"]               = "Judío";
$pgv_lang["hebrew"]               = "Hebreo";
$pgv_lang["jewish_and_gregorian"] = "Judío y Gregoriano";
$pgv_lang["hebrew_and_gregorian"] = "Hebreo y Gregoriano";

//-- MONTH NAMES
$pgv_lang["jan"]	= "Enero";
$pgv_lang["feb"]	= "Febrero";
$pgv_lang["mar"]	= "Marzo";
$pgv_lang["apr"]	= "Abril";
$pgv_lang["may"]	= "Mayo";
$pgv_lang["jun"]	= "Junio";
$pgv_lang["jul"]	= "Julio";
$pgv_lang["aug"]	= "Agosto";
$pgv_lang["sep"]	= "Septiembre";
$pgv_lang["oct"]	= "Octubre";
$pgv_lang["nov"]	= "Noviembre";
$pgv_lang["dec"]	= "Diciembre";
$pgv_lang["abt"]	= "acerca";
$pgv_lang["aft"]	= "después";
$pgv_lang["and"]	= "y";
$pgv_lang["bef"]	= "antes";
$pgv_lang["bet"]	= "entre";
$pgv_lang["cal"]	= "calculada";
$pgv_lang["est"]	= "estimada";
$pgv_lang["from"]	= "desde";
$pgv_lang["int"]	= "interpretada";
$pgv_lang["cir"]	= "alrededor de";
$pgv_lang["apx"]	= "aprox.";
$pgv_lang["to"]	= "a";
//-- Admin File Messages
$pgv_lang["rebuild_indexes"]	= "Reconstruir los Índices";
$pgv_lang["user_admin"]	= "Administrador de Usuarios";
$pgv_lang["password_mismatch"]	= "Las contraseñas no coinciden.";
$pgv_lang["enter_username"]	= "Debe ingresar un Nombre de Usuario.";
$pgv_lang["enter_fullname"]	= "Escriba su nombre completo.";
$pgv_lang["enter_password"]	= "Escriba una contraseña.";
$pgv_lang["confirm_password"]	= "Debe confirmar la contraseña.";
$pgv_lang["delete"]	= "Borrar";
$pgv_lang["edit"]	= "Editar";
$pgv_lang["no_login"]	= "No es posible autenticar al usuario.";
$pgv_lang["import_gedcom"]	= "Importar este archivo GEDCOM";
$pgv_lang["enter_gedcomid"]	= "Debe ingresar una ID GEDCOM.";
$pgv_lang["user_info"]	= "Mi información de Usuario";
$pgv_lang["file_not_exists"]	= "El archivo ingresado no existe.";
$pgv_lang["enter_filename"]	= "Debe ingresar un nombre de archivo GEDCOM";
$pgv_lang["file_exists"]	= "Ya existe un archivo GEDCOM con ese nombre. Por favor elija otro nombre o elimine el archivo anterior.";
$pgv_lang["new_gedcom_title"]	= "Genealogía de [#GEDCOMFILE#]";
$pgv_lang["upload_help"]	= "Seleccione un archivo de su computadora local para cargar al servidor. Todos los archivos se guardarán en el directorio: ";
$pgv_lang["add_gedcom_instructions"] = "Ingrese un nombre de archivo para este GEDCOM. El nuevo archivo GEDCOM será creado en el directorio \"index\":";
$pgv_lang["research_log"]	= "Registro de investigación";
$pgv_lang["utf8_to_ansi"]	= "Desea convertir la codificación de este GEDCOM de UTF-8 a ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]	= "Manual del usuario PhpGedView";
$pgv_lang["upgrade"]	= "Actualice PhpGedView";
$pgv_lang["step1"]	= "Paso 1 de 4";
$pgv_lang["step3"]	= "Paso 3 de 4";
$pgv_lang["step4"]	= "Paso 4 de 4";
//-- Relationship chart messages
$pgv_lang["relationship_chart"]	= "Gráfico de Parentesco";
$pgv_lang["person1"]	= "Persona 1";
$pgv_lang["person2"]	= "Persona 2";
$pgv_lang["no_link_found"]	= "No se encontró ninguna (otra) relación entre estas dos personas.";
$pgv_lang["sibling"]	= "Hermano";
$pgv_lang["follow_spouse"]	= "Controlar parentesco por matrimonio.";
$pgv_lang["timeout_error"]	= "Tiempo vencido antes de encontrar un parentesco.";
$pgv_lang["son"]	= "Hijo";
$pgv_lang["daughter"]	= "Hija";
$pgv_lang["brother"]	= "Hermano";
$pgv_lang["sister"]	= "Hermana";
$pgv_lang["relationship_to_me"]	= "Parentesco conmigo";
$pgv_lang["next_path"]	= "Hallar próxima línea";
$pgv_lang["line_up_generations"]	= "Alinear las mismas generaciones";
$pgv_lang["show_path"]	= "Mostrar línea";
//-- language edit utility
$pgv_lang["save"]	= "Guardar";
$pgv_lang["close_window"]	= "Cerrar ventana";
//-- GEDCOM edit utility
$pgv_lang["check_delete"]	= "Seguro que desea eliminar este acontecimiento GEDCOM?";
$pgv_lang["access_denied"]	= "<b>Acceso denegado</b><br>No tiene permiso para acceder a este recurso.";
$pgv_lang["changes_exist"]	= "Se han efectuado modificaciones a este GEDCOM.";
$pgv_lang["find_place"]	= "Encontrar Lugar";
$pgv_lang["close_window_without_refresh"] = "Cerrar ventana sin actualizar";
$pgv_lang["place_contains"]	= "Los Lugares tienen:";
$pgv_lang["now_import"]	= "Ahora puede importar los registros GEDCOM en PhpGedView seleccionando el vínculo inferior.";
$pgv_lang["add"]	= "Añadir";
$pgv_lang["custom_event"]	= "Evento singular";
$pgv_lang["delete_person"]	= "Borrar este individuo";
$pgv_lang["confirm_delete_person"] = "Realmente desea borrar este individuo del archivo GEDCOM?";
$pgv_lang["find_media"]	= "Buscar MultiMedios";
$pgv_lang["set_link"]	= "Crear vínculo";
$pgv_lang["delete_source"]	= "Borrar esta Fuente";
$pgv_lang["confirm_delete_source"] = "Realmente desea borrar esta Fuente del archivo GEDCOM?";
$pgv_lang["find_fam_list"]		= "Encontrar la lista de Familia";
$pgv_lang["find_family"]	= "Buscar familia";
$pgv_lang["edit_name"]	= "Modificar nombre";
$pgv_lang["delete_name"]	= "Borrar nombre";
$pgv_lang["select_date"]		= "Seleccione una fecha";
$pgv_lang["sunday"]	= "Domingo";
$pgv_lang["monday"]	= "Lunes";
$pgv_lang["tuesday"]	= "Martes";
$pgv_lang["wednesday"]	= "Miércoles";
$pgv_lang["viewyear"]			= "Ver año";
$pgv_lang["thursday"]	= "Jueves";
$pgv_lang["friday"]	= "Viernes";
$pgv_lang["saturday"]	= "Sábado";
$pgv_lang["viewday"]	= "Ver día";
$pgv_lang["viewmonth"]	= "Ver mes";
$pgv_lang["all_people"]	= "Todos las personas";
$pgv_lang["living_only"]	= "Personas vivas";
$pgv_lang["recent_events"]	= "Años recientes (< 100 años)";
$pgv_lang["year_error"]	= "Disculpe. no se aceptan fechas anteriores a 1970.";
$pgv_lang["lost_password"]	= "Perdió su Contraseña?";
$pgv_lang["requestpassword"]	= "Solicitar nueva contraseña";
$pgv_lang["no_account_yet"]	= "Sin cuenta todavía?";
$pgv_lang["requestaccount"]	= "Solicitar nueva cuenta";
$pgv_lang["register_info_01"]	= "La información públicamente visible puede ser restringida por la aplicación de leyes concernientes a la privacidad. Muchas personas no desean que sus datos sean públicamente visibles en Internet. Podría ser utilizado para \"spam\" o robo de identidad.<br /><br />Para tener acceso a la información privada, debe tener una cuenta en este sitio. Luego que el administrador haya controlado su solicitud y la haya aprobado, podrá registrarse y ver la información privada.<br /><br />Si la privacidad por parentesco está activada, después de registrarse sólo podrá acceder a la información privada de sus familiares cercanos. El administrador también puede brindar acceso a la edición de la información en la base de datos, de forma tal que pueda agregar o editar la información.<br /><br />NOTA: Solamente tendrá acceso a la información privada si puede probar que es un familiar cercano a una persona en la base de datos.<br /><br />Si Ud. no es un familiar cercano, probablemente no le sea otorgada una cuenta, eliminando de esta forma el problema.<br />Si necesita mayor asistencia, utilice el enlace al final de la página para contactarse con el Administrador principal.";
$pgv_lang["pls_note01"]	= "Considere que el sistema distingue letras mayúsculas y minúsculas!";
$pgv_lang["min6chars"]	= "La contraseña debe contener al menos 6 caracteres";
$pgv_lang["pls_note02"]	= "Las contraseñas pueden contener números, letras y otros caracteres.";
$pgv_lang["pls_note03"]	= "Esta dirección de correo electrónico será verificada antes de la activación de la cuenta. No será publicada en el sitio. Recibirá un mensaje en esta dirección de correo electrónico con sus datos de ingreso.";
$pgv_lang["emailadress"]	= "Dirección de correo electrónico";
$pgv_lang["pls_note04"]	= "Los campos indicados con * son obligatorios";
$pgv_lang["pls_note05"]	= "La finalización del formulario y verificación de sus respuestas se halla pendiente. Le será enviada una confirmación por correo electrónico a la dirección indicada en esta página. Utilizando el correo de confirmación Ud. deberá activar su cuenta; si no lo hace dentro de los siete días, será depurado (Ud. puede registrarse nuevamente a partir de ese momento). Para utilizar este sitio, deberá conocer su Nombre de Usuario y la Contraseña. Debe especificar una dirección de correo electrónico válida y existente para recibir la confirmación por correo electrónico.<br /><br />Si encuentra algún problema registrándose en este sitio, por favor envíe una Solicitud de Soporte al Adminstrador.";
$pgv_lang["mail01_line01"]	= "Hola #user_fullname# ...";
$pgv_lang["mail01_line02"]	= "Se realizó una solicitud a ( #SERVER_NAME# ) para registrar su dirección de correo electrónico ( #user_email# ).";
$pgv_lang["mail01_line03"]	= "Se utilizó la siguiente información";
$pgv_lang["mail01_line04"]	= "Por favor, seleccione el vínculo siguiente y complete los datos requeridos para verificar su cuenta y su dirección de correo electrónico.";
$pgv_lang["mail01_line05"]	= "Si no solicitó esta información sólo borre este mensaje";
$pgv_lang["mail01_line06"]	= "No recibirá ningún correo electrónico de este sistema nuevamente, porque su cuenta será borrada sin verificación dentro de siete días";
$pgv_lang["mail01_subject"]	= "Su Ingreso en #SERVER_NAME#";
$pgv_lang["mail02_line01"]	= "Hola Administrador ...";
$pgv_lang["mail02_line02"]	= "Un nuevo usuario realizó una nueva registración en ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]	= "El usuario recibió un correo electrónico con la información necesaria para verificar su cuenta";
$pgv_lang["mail02_line04"]	= "Tan pronto como el usuario haya hecho esta verificación, será informado por correo para otorgar a este usuario el permiso para registrarse en su sitio";
$pgv_lang["mail02_subject"]	= "Nueva registración en #SERVER_NAME#";
$pgv_lang["hashcode"]	= "Código de verificación:";
$pgv_lang["thankyou"]	= "Hola #user_fullname# ...<br>Gracias por registrarse";
//-- calendar.php messages
$pgv_lang["pls_note06"]	= "Ud. recibirá un correo electrónico de confirmación a la dirección ( #user_email# ). Usando el correo electrónico de confirmación activará su cuenta; si no la activa dentro de 7 días será depurado (podrá registrarse nuevamente a partir de este punto). Para registrarse en este sitio, deberá recordar su nombre y contraseña";
$pgv_lang["registernew"]	= "Nueva confirmación de cuenta.";
$pgv_lang["user_verify"]	= "Verificación de usuario";
$pgv_lang["send"]	= "Enviar";
$pgv_lang["pls_note07"]	= "Por favor escriba su Nombre de Usuario, su contraseña y el código de verificación que recibió por correo electrónico de este sistema para verificar su solicitud de ingreso.";
$pgv_lang["pls_note08"]	= "Fue verificada la información para el usuario #user_name#";
$pgv_lang["mail03_line01"]	= "Hola administrador...";
$pgv_lang["mail03_line02"]	= "#newuser[username]# ( #newuser[fullname]# ) ha verificado los datos de ingreso.";
$pgv_lang["mail03_line03"]	= "Por favor, presione el vínculo inferior para ingresar al sitio, editar el usuario y otorgarle el permiso para ingresar a él.";
$pgv_lang["mail03_subject"]	= "Nueva verificación en #SERVER_NAME#";
$pgv_lang["pls_note09"]	= "Se lo identificó como Usuario registrado";
$pgv_lang["pls_note10"]	= "El administrador ha sido informado.<br>Tan pronto como él le otorgue permiso para ingresar, Ud. podrá hacerlo con su Nombre de Usuario y Contraseña de acceso.";
$pgv_lang["data_incorrect"]	= "Información incorrecta!<br>Por favor intente nuevamente!";
$pgv_lang["user_not_found"]	= "No se pudo verificar la información ingresada. Retroceda e intente nuevamente.";
$pgv_lang["lost_pw_reset"]	= "Solicitud de contraseña extraviada";
$pgv_lang["pls_note11"]	= "Para regenerar su contraseña, proporcione el Nombre de Usuario y la dirección de correo electrónico de su cuenta.<br /><br />Le enviaremos una dirección URL especial por correo electrónico conteniendo el sistema de confirmación para su cuenta. Visitando la dirección URL suministrada, se le permitirá modificar su nombre y contraseña de acceso a este sitio. Por razones de seguridad, no debe suministrar a nadie este sistema de confirmación incluyendo los administradores del sitio (no haremos preguntas).<br /><br />Si requiere asistencia del administrador del sitio, por favor contáctese con él.";
$pgv_lang["enter_email"]	= "Debe ingresar una dirección de correo electrónico";
$pgv_lang["mail04_line01"]	= "Hola #user_fullname# ...";
$pgv_lang["mail04_line02"]	= "Se ha solicitado una nueva contraseña para su Nombre de Usuario!";
$pgv_lang["mail04_line03"]	= "Recomendación: ";
$pgv_lang["mail04_line04"]	= "Ahora presione el vínculo inferior, ingrese con la nueva contraseña y guárdela para mantener la seguridad de su información";
$pgv_lang["mail04_subject"]	= "Solicitud de información en #SERVER_NAME#";
$pgv_lang["pwreqinfo"]	= "Hola...<br><br>Se envió un mensaje a la dirección de correo electrónico (#user[email]#) incluyendo la nueva contraseña.<br><br>Por favor verifique su correo electrónico ya que el mensaje se recibirá en los próximos minutos.<br><br>Recomendación:<br><br>Después de recibir este mensaje debería ingresar al sitio con su su nueva contraseña y cambiarla para mantener la integridad de la seguridad de su información";
$pgv_lang["editowndata"]	= "Mi Cuenta";
$pgv_lang["savedata"]	= "Información modificada archivada";
$pgv_lang["datachanged"]	= "Información del usuario modificada!";
$pgv_lang["datachanged_name"]	= "Necesita registrarse nuevamente con su nuevo Nombre de Usuario";
$pgv_lang["myuserdata"]	= "Mi Cuenta";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<b>BIENVENIDO A ESTE SITIO DE GENEALOGÍA</b></br></br>Se permite el acceso a todo visitante que posea una cuenta de usuario en el sitio.</br>Si ya posee una cuenta de usuario, puede ingresar al sitio en esta página.</br></br>Si aún no la posee, puede solicitarla presionando el enlace adecuado en esta página.</br>Despues de verificar sus datos, el administrador del sitio activarå su cuenta.</br> Recibirá un correo electrónico cuando su cuenta sea activada.";
$pgv_lang["welcome_text_cust_head"]		=	"<b>BIENVENIDO A ESTE SITIO DE GENEALOGÍA</b></br></br>Se permite el acceso a usuarios que posean una cuenta de usuario y una contraseña asigandas.</br>";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<b>BIENVENIDO A ESTE SITIO DE GENEALOGÍA</b></br></br>Se permite el acceso <b>solamente a los miembros de la familia</b>.</br>Si ya posee una cuenta de usuario, puede ingresar al sitio en esta página.</br></br>Si aún no la posee, puede solicitarla presionando el enlace adecuado en esta página.</br>Despues de verificar sus datos, el administrador del sitio activarå su cuenta.</br> Recibirá un correo electrónico cuando su cuenta sea activada.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<b>BIENVENIDO A ESTE SITIO DE GENEALOGÍA</b></br></br>Se permite el acceso solamente a usuarios <b>autorizados</b>.</br>Si ya posee una cuenta de usuario, puede ingresar al sitio en esta página.</br></br>Si aún no la posee, puede solicitarla presionando el vínculo adecuado en esta página.</br>Despues de verificar sus datos, el administrador del sitio activará su cuenta.</br> Recibirá un correo electrónico cuando su cuenta sea activada.";
$pgv_lang["user_theme"]	= "Mi Tema";
$pgv_lang["mgv"]	= "Mi GedView";
$pgv_lang["mygedview"]	= "Portal Mi GedView";
$pgv_lang["passwordlength"]	= "La contraseña debe contener al menos 6 caracteres";
$pgv_lang["welcome"] = "Bienvenido a su nuevo sitio de PhpGedView. Dado que está viendo esta página, ha instalado satisfactoriamente PhpGedView en su servidor y listo para ser configurado en la forma que desee.<br>";
$pgv_lang["upcoming_events"]	= "Eventos por suceder";
$pgv_lang["chat"]	= "Conversación";
$pgv_lang["users_logged_in"]	= "Usuarios registrados";
$pgv_lang["message"]	= "Enviar mensaje";
$pgv_lang["my_messages"]	= "Mis mensajes";
$pgv_lang["date_created"]	= "Fecha de envío:";
$pgv_lang["message_from"]	= "Mensaje de: ";
$pgv_lang["message_from_name"]	= "Su nombre";
$pgv_lang["message_to"]	= "Mensaje a: ";
$pgv_lang["message_subject"]	= "Título: ";
$pgv_lang["message_body"]	= "Contenido: ";
$pgv_lang["no_to_user"]	= "No se suministró el destinatario. Imposible continuar.";
$pgv_lang["provide_email"]	= "Por favor, indique su dirección de correo electrónico de forma tal que podamos comunicarnos en respuesta a este mensaje. Si no suministra su dirección de correo electrónico no podremos responder a su solicitud. Su dirección de correo electrónico no será utilizada con otro fin que el responder a su solicitud.";
$pgv_lang["reply"]	= "Respuesta";
$pgv_lang["message_deleted"]	= "Mensaje eliminado";
$pgv_lang["message_sent"]	= "Mensaje enviado";
$pgv_lang["reset"]	= "Original";
$pgv_lang["site_default"]	= "Opción original del sitio";
$pgv_lang["mygedview_desc"]	= "Su página Mi GedView le permite almacenar vínculos a sus personas favoritas, controlar eventos por suceder y colaborar con otros usuarios PhpGedView.";
$pgv_lang["no_messages"]	= "No tiene mensajes pendientes.";
$pgv_lang["clicking_ok"]	= "Presionando OK, abrirá una nueva ventana donde podrá contactar a #user[fullname]#";
$pgv_lang["my_favorites"]	= "Mis favoritos";
$pgv_lang["no_favorites"]	= "No ha seleccionado favoritos. Para agregar una persona a sus favoritos, busque los detalles de la persona que desea agregar y luego presione el vínculo \"Agregar a Mis Favoritos\" o use la caja ID inferior para agregar una persona por su identificación ID.";
$pgv_lang["add_to_my_favorites"] = "Agregar a Mis Favoritos";
$pgv_lang["gedcom_favorites"]	= "Favoritos de este GEDCOM";
$pgv_lang["no_gedcom_favorites"]	= "Al momento no se han seleccionado Favoritos. El Administrador puede agregar Favoritos para mostrarse al comienzo.";
$pgv_lang["confirm_fav_remove"] = "Seguro desea remover este ítem de sus favoritos?";
$pgv_lang["invalid_email"]	= "Por favor ingrese una dirección de correo electrónico válida";
$pgv_lang["enter_subject"]	= "Por favor ingrese un Tema del mensaje.";
$pgv_lang["enter_body"]	= "Por favor ingrese texto en el mensaje antes de enviarlo.";
$pgv_lang["confirm_message_delete"] = "Seguro desea eliminar este mensaje? No podrá recuperarse posteriormente.";
$pgv_lang["message_email1"]	= "El siguiente mensaje ha sido enviado a su cuenta PhpGedView por";
$pgv_lang["message_email2"]	= "Ud. envió el siguiente mensaje a un usuario PhpGedView";
$pgv_lang["message_email3"]	= "Ud, envió el siguiente mensaje al administrador PhpGedView";
$pgv_lang["viewing_url"]	= "Este mensaje se envió mientras estaba en la página";
$pgv_lang["messaging2_help"]	= "Cuando envíe este mensaje recibirá una copia por correo electrónico a la dirección que Ud. suministró";
$pgv_lang["random_picture"]	= "Imagen al azar";
$pgv_lang["message_instructions"]	= "<b>Atención:</b> La información privada de las personas vivas sólo se exhibirá a parientes y amigos cercanos. Deberá validar su parentesco antes de recibir información privada. Algunas veces la información de personas fallecidas puede ser privada. Si éste es el caso, es porque no existe suficiente información conocida de la persona para saber si aún vive.<br /><br />Antes de realizar preguntas, verifique que está consultando sobre la persona correcta controlando fechas, lugares y parientes cercanos. Si está realizando cambios a la información genealógica, incluya las fuentes de dónde obtuvo la información.<br /><br />";
$pgv_lang["sending_to"]	= "Este mensaje será enviado a #TO_USER#";
$pgv_lang["gedcom_created_on2"]	= "el <b>#DATE#</b>";
$pgv_lang["preferred_lang"]	 	= "Este usuario prefiere recibir mensajes en #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Este GEDCOM fue creado usando <b>#SOFTWARE# #VERSION#</b> ";
$pgv_lang["gedcom_created_on"]	= "Este GEDCOM fue creado el <b>#DATE#</b>.";
$pgv_lang["gedcom_stats"]	= "Estadísticas del GEDCOM";
$pgv_lang["stat_individuals"]	= "Individuos,";
$pgv_lang["stat_families"]	= "Familias,";
$pgv_lang["stat_sources"]	= "Fuentes,";
$pgv_lang["stat_other"]	= "Otros Registros";
$pgv_lang["customize_page"]	= "Personalice su Portal personal";
$pgv_lang["customize_gedcom_page"]	= "Personalice la Página de Bienvenida de este GEDCOM";
$pgv_lang["upcoming_events_block"]	= "Bloque de Acontecimientos por Suceder";
$pgv_lang["upcoming_events_descr"]	= "El Bloque de Acontecimientos por Suceder muestra una lista de los acontecimientos en el GEDCOM activo que ocurrieron en el pasado en los siguientes 30 días. Para la página Mi GedView de un usuario, el bloque sólo listará a las personas vivas. Para la página de Bienvenida GEDCOM, listará a todas las personas.";
$pgv_lang["todays_events_block"]	= "Bloque En este Día";
$pgv_lang["todays_events_descr"]	= "El bloque \"En este día en su Historia...\" muestra una lista de los acontecimientos en el GEDCOM activo que ocurrieron el día de hoy. Si no existen acontecimientos, el bloque no se muestra. Para la página Mi GedView de un usuario, el bloque listará sólo a las personas vivas. Para la página de Bienvenida GEDCOM, listará a todas las personas.";
$pgv_lang["logged_in_users_block"]	= "Bloque de Usuarios Registrados";
$pgv_lang["logged_in_users_descr"]	= "El Bloque de Usuarios Registrados muestra una lista de los usuarios que actualmente han ingresado.";
$pgv_lang["user_messages_block"]	= "Bloque de Mensajes al Usuario";
$pgv_lang["user_messages_descr"]	= "El Bloque de Mensajes al Usuario muestra una lista de los mensajes enviados al usuario activo.";
$pgv_lang["user_favorites_block"]	= "Bloque de Favoritos del Usuario";
$pgv_lang["user_favorites_descr"]	= "El Bloque de Favoritos del Usuario muestra al usuario un listado de sus individuos favoritos haciéndolos fácilmente accesibles.";
$pgv_lang["welcome_block"]	= "Bloque de Bienvenida al Usuario";
$pgv_lang["welcome_descr"]	= "El Bloque de Bienvenida al Usuario muestra al usuario la fecha y hora actual, vínculos rápidos para modificar su cuenta o dirigirse a su propio Gráfico de Antepasados y un vínculo para personalizar su página Mi GedView.";
$pgv_lang["random_media_block"]	= "Bloque de Medios al Azar";
$pgv_lang["random_media_descr"]	= "El Bloque de Medios al Azar selecciona al azar una foto u otro ítem MulltMedio en al GEDCOM activo y la muestra al usuario.";
$pgv_lang["gedcom_block"]	= "Bloque de Bienvenida al GEDCOM";
$pgv_lang["gedcom_descr"]	= "El Bloque de Bienvenida al GEDCOM funciona en forma similar al Bloque de Bienvenida al Usuario, dándole la bienvenida al usuario, mostrando el título del GEDCOM activo, la hora y fecha actuales.";
$pgv_lang["gedcom_favorites_block"]	= "Bloque de Favoritos del GEDCOM";
$pgv_lang["gedcom_favorites_descr"]	= "El Bloque de Favoritos del GEDCOM permite al administrador seleccionar a sus personas favoritas de forma tal que los usuarios puedan encontrarlas fácilmente. Esta es una forma de destacar a aquellas personas importantes en su historia familiar.";
$pgv_lang["gedcom_stats_block"]	= "Bloque de Estadísticas del GEDCOM";
$pgv_lang["gedcom_stats_descr"]	= "El Bloque de Estadísticas del GEDCOM muestra al usuario información básica acerca del GEDCOM, tal como cuando fue creado y cuantas personas integran el GEDCOM.";
$pgv_lang["portal_config_intructions"]	= "Aquí puede personalizar la página, posicionando los bloques en la forma que desee. La página está dividida en dos secciones, la sección 'Principal' y la sección 'Derecha'. Los bloques de la sección 'Principal' aparecen de mayor tamaño y bajo el título de la página. La sección 'Derecha' comienza a la derecha del título orientada hacia abajo y a la derecha de la página. Cada sección posee su propia lista de bloques que serán desplegados en la página en el orden en que están listados. Puede agregar, quitar y reordenar los bloques como desee.";
$pgv_lang["login_block"]	= "Bloque de Ingreso";
$pgv_lang["login_descr"]	= "El Bloque de Ingreso despliega Nombre de Usuario y Contraseña para que los usuarios se registren.";
$pgv_lang["gedcom_news_block"]	= "Bloque de Novedades GEDCOM";
$pgv_lang["gedcom_news_descr"]	= "El Bloque de Novedades GEDCOM muestra al usuario novedades o artículos ingresados por un usuario administrador. 'Novedades' es un buen sitio para anunciar una actualización del GEDCOM o una reunión familiar.";
$pgv_lang["user_news_block"]	= "Bloque Boletín del Usuario";
$pgv_lang["user_news_descr"]	= "El Bloque de Boletín del Usuario permita a los usuarios guardar notas en un boletín en línea.";
$pgv_lang["my_journal"]	= "Mi Boletín";
$pgv_lang["no_journal"]	= "No ha creado ningún ítem en el Boletín.";
$pgv_lang["confirm_journal_delete"]	= "Seguro desea borrar este ingreso al Boletín?";
$pgv_lang["add_journal"]	= "Agregar un nuevo ingreso al Boletín";
$pgv_lang["gedcom_news"]	= "Novedades";
$pgv_lang["confirm_news_delete"]	= "Seguro desea eliminar este ingreso a Novedades?";
$pgv_lang["add_news"]	= "Agregar un artículo a Novedades";
$pgv_lang["no_news"]	= "No se han remitido artículos a Novedades";
$pgv_lang["edit_news"]	= "Agregar/editar ingresos a Boletín/Novedades";
$pgv_lang["enter_title"]	= "Por favor ingrese un título.";
$pgv_lang["enter_text"]	= "Por favor ingrese algún texto para esta novedad o artículo.";
$pgv_lang["news_saved"]	= "Ingreso a Novedades/Boletín guardado exitosamente.";
$pgv_lang["article_text"]	= "Texto del ingreso:";
$pgv_lang["move_left"]			= "Mover a la izquierda";
$pgv_lang["move_right"]			= "Mover a la derecha";
$pgv_lang["main_section"]	= "Bloques de la Sección Principal";
$pgv_lang["right_section"]	= "Bloques de la Sección Derecha";
$pgv_lang["move_up"]	= "Hacia arriba";
$pgv_lang["move_down"]	= "Hacia abajo";
$pgv_lang["add_main_block"]	= "Agregar bloque a la Sección Principal...";
$pgv_lang["add_right_block"]	= "Agregar bloque a la Sección Derecha...";
$pgv_lang["broadcast_all"]	= "Difundir a todos los usuarios";
$pgv_lang["delete_selected_messages"]	= "Eliminar los mensajes seleccionados";
$pgv_lang["recent_changes_descr"]	= "El Bloque de modificaciones recientes indicará todos los cambios realizados al GEDCOM en el último mes. Este bloque lo ayudará a mantenerse actualizado con las modificaciones realizadas. Los cambios se detectan por la etiqueta CHAN.";
$pgv_lang["recent_changes_block"]	= "Bloque de modificaciones recientes";
$pgv_lang["recent_changes"]		= "Modificaciones recientes";
$pgv_lang["hit_count"]	= "Cantidad de aciertos:";
$pgv_lang["phpgedview_message"]	= "Mensaje PhpGedView";
$pgv_lang["common_surnames"]	= "Apellidos más comunes";
$pgv_lang["default_news_title"]	= "Bienvenido a Su Genealogía";
$pgv_lang["default_news_text"]	= "La información genealógica de este sitio está controlada por <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView3</a>. Esta página suministra una introducción e información general de esta genealogía. Para comenzar a trabajar con la información, elija una de las páginas de gráficos del menú de gráficos, diríjase a la lista de personas o busque un nombre o un lugar.<br /><br />Si tiene problemas con el uso del sitio, seleccionando el menú de ayuda obtendrá información sobre cómo utilizar la página en la que se encuentra.<br /><br />Gracias por visitar este sitio.";
$pgv_lang["reset_default_blocks"]	= "Reestablecer los bloques por omisión";
//-- upgrade.php messages
$pgv_lang["upgrade_util"]	= "Utilitario de actualización";
$pgv_lang["no_upgrade"]	= "No existen archivos a actualizar";
$pgv_lang["use_version"]	= "Está usando la versión: ";
$pgv_lang["current_version"]	= "Versión actual estable:";
$pgv_lang["upgrade_download"]	= "Cargar";
$pgv_lang["latest"]	= "Está ejecutando la última versión de PhpGedView";
$pgv_lang["location"]	= "Ubicación de los archivos de actualización";
$pgv_lang["include"]	= "Incluir";
$pgv_lang["options"]	= "Opciones";
$pgv_lang["inc_config"]	= "Archivo de configuración";
$pgv_lang["inc_researchlog"]	= "Registro de investigación";
$pgv_lang["inc_index"]	= "Archivos Índice";
$pgv_lang["inc_themes"]	= "Temas";
$pgv_lang["inc_docs"]	= "Manuales";
$pgv_lang["inc_privacy"]	= "Archivos de privacidad";
$pgv_lang["inc_backup"]	= "Crear archivo de respaldo";
$pgv_lang["upgrade_help"]	= "Ayuda";
$pgv_lang["cannot_read"]	= "No se puede leer el archivo:";
$pgv_lang["not_configured"]	= "Todavía no ha configurado PhpGedView";
$pgv_lang["location_upgrade"]	= "Por favor indique la ubicación de sus archivos de actualización";
$pgv_lang["new_variable"]	= "Se encontró una nueva variable";
$pgv_lang["config_open_error"]	= "Ha habido un error abriendo el archivo de configuración";
$pgv_lang["config_write_error"] 	= "Error!!! No se puede grabar el archivo de configuración.";
$pgv_lang["config_update_ok"]	= "Archivo de configuración actualizado con éxito";
$pgv_lang["config_uptodate"]	= "Su archivo de configuración se encuentra al día";
$pgv_lang["processing"]	= "Procesando...";
$pgv_lang["privacy_open_error"]	= "Ha ocurrido un error al abrir el archivo [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"] = "ERROR!!! No se puede grabar el archivo [#PRIVACY_MODULE#].<br />Verifique tener permisos de escritura sobre el archivo.<br />Los permisos pueden volver a modificarse una vez que el archivo de privacidad haya sido grabado.";
$pgv_lang["privacy_update_ok"]	= "Archivo de privacidad [#PRIVACY_MODULE#] actualizado con éxito";
$pgv_lang["privacy_uptodate"]	= "Su archivo [#PRIVACY_MODULE#] se encuentra al día";
$pgv_lang["heading_privacy"]	= "Archivo(s) de privacidad:";
$pgv_lang["heading_phpgedview"]	= "Archivos PhpGedView:";
$pgv_lang["heading_image"]	= "Archivos de imágen:";
$pgv_lang["heading_index"]	= "Archivos Índice:";
$pgv_lang["heading_language"]	= "Archivos de Idioma:";
$pgv_lang["heading_theme"]	= "Archivos de Temas:";
$pgv_lang["heading_docs"]	= "Manuales:";
$pgv_lang["heading_researchlog"] = "Archivos del Registro de Investigación:";
$pgv_lang["heading_researchloglang"] = "Archivos de idioma de los archivos del Registro de Investigación:";
$pgv_lang["copied_success"]	= "Copiados con éxito";
$pgv_lang["backup_copied_success"] = "Archivo de resguardo creado con éxito";
$pgv_lang["process_error"]	= "Existen problemas al procesar la página. No se puede determinar una versión más reciente.";
$pgv_lang["upgrade_completed"]	= "Actualización realizada con éxito";
$pgv_lang["start_using_upgrad"]	= "Presione aquí para comenzar usando la versión ";
$pgv_lang["changed_mac"]	= "Se detectó finales de línea tipo Macintosh. Se cambió las líneas finalizando sólo con 'return' a 'return'+'linefeed'";
$pgv_lang["changed_places"]	= "Se detectó codificación de lugares inválida. Se realizó una limpieza de los registros de lugares para conformar las especificaciones GEDCOM 5.5 adecuadas. Un ejemplo para su GEDCOM es:";
$pgv_lang["optional_tools"]	= "Si desea, puede ejecutar las siguientes herramientas opcionales antes de realizar la importación.";
$pgv_lang["optional"]	= "Herramientas opcionales";
$pgv_lang["date_format"]	= "Formato de fecha:";
$pgv_lang["add_media_tool"]	= "Agregar Herramienta de Medios";
$pgv_lang["launch_media_tool"]	= "Presione aquí para ejecutar Agregar Herramienta de Medios.";
$pgv_lang["add_media_descr"]	= "Esta herramienta agregará etiquetas OBJE al GEDCOM. Cierre esta ventana cuando finalice el agregado de Medios.";
$pgv_lang["extension"]	= "Extensión";
$pgv_lang["order"]	= "Orden";
$pgv_lang["add_media_button"]	= "Agregar Medios";
$pgv_lang["media_table_created"]	= "Tabla de <i>Medios</i> actualizada exitosamente.";
$pgv_lang["click_to_add_media"]	= "Presione aquí para añadir los Medios listados precedentemente al GEDCOM #GEDCOM#";
$pgv_lang["download_report"]			= "Descargar reporte";
$pgv_lang["select_report"]		= "Seleccionar reporte";
$pgv_lang["run_report"]			= "Ver reporte";
$pgv_lang["selected_report"]		= "Reporte seleccionado";
$pgv_lang["enter_report_values"]	= "Ingrese los parámetros del reporte";
$pgv_lang["choose_report"]		= "Seleccione un reporte";
$pgv_lang["in_this_year"]		= "En este año, en su Historia";
$pgv_lang["adds_completed"]	= "Medios agregados con éxito al archivo GEDCOM.";
$pgv_lang["statistics"]			= "Estadísticas";
$pgv_lang["slk_list"]			= "Lista EXCEL SLK";
$pgv_lang["patriarch_list"]		= "Lista de patriarcas";
$pgv_lang["excel_create"]		= "se creará en el archivo:";
$pgv_lang["excel_list"]			= "Salida en formato EXCEL (SLK) en los siguientes archivos (primero use la lista de patriarcas):";
$pgv_lang["make_slklist"]		= "Crear una lista EXCEL (SLK)";
$pgv_lang["dynasty_list"]		= "Información general de familias";
$pgv_lang["hourglass_chart"]	= "Gráfico 'Reloj de Arena'";
$pgv_lang["cleanup"]	= "Limpieza";
$pgv_lang["in_this_month"]	= "En este mes en su Historia";
$pgv_lang["on_this_day"]	= "En este día en su Historia...";
$pgv_lang["year_anniversary"]	= "hace #year_var# años";
$pgv_lang["today"]	= "Hoy";
$pgv_lang["day"]	= "Día:";
$pgv_lang["month"]	= "Mes:";
$pgv_lang["showcal"]	= "Mostrar acontecimientos de:";
$pgv_lang["anniversary_calendar"] = "Calendario de Aniversarios";
?>
