<?php
/**
 * Standard file of language_settings.php
 *
 * -> NEVER manually delete or edit this file <-
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  John Finlay and Others
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License;or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not;write to the Free Software
 * Foundation;Inc.;59 Temple Place;Suite 330;Boston;MA  02111-1307  USA
 *
 * $Id: lang_settings_std.php 1804 2007-10-01 22:11:43Z canajun2eh $
 *
 * @package PhpGedView
 * @subpackage Languages
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access an include file directly.";
	exit;
}

//-- NEVER manually delete or edit this entry and every line below this entry! --START--//

// Array definition of language_settings
$language_settings = array();

//-- settings for czech
$lang = array();
$lang["pgv_langname"]    = "czech";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Čeština";
$lang["lang_short_cut"]    = "cz";
$lang["langcode"]    = "cs;cz;";
$lang["pgv_language"]    = "languages/lang.cz.php";
$lang["confighelpfile"]    = "languages/configure_help.cz.php";
$lang["helptextfile"]    = "languages/help_text.cz.php";
$lang["flagsfile"]    = "images/flags/czech republic.gif";
$lang["factsfile"]    = "languages/facts.cz.php";
$lang["adminfile"]    = "languages/admin.cz.php";
$lang["editorfile"]    = "languages/editor.cz.php";
$lang["countryfile"]    = "languages/countries.cz.php";
$lang["faqlistfile"]    = "languages/faqlist.cz.php";
$lang["extrafile"]    = "languages/extra.cz.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AÁBCČDĎEĚÉFGHIÍJKLMNŇOÓPQRŘSŠTŤUÚŮVWXYÝZŽ";
$lang["ALPHABET_lower"]    = "aábcčdďeěéfghiíjklmnňoópqrřsštťuúůvwxyýzž";
$lang["MULTI_LETTER_ALPHABET"]	= "ch";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["czech"]  = $lang;

//-- settings for german
$lang = array();
$lang["pgv_langname"]    = "german";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Deutsch";
$lang["lang_short_cut"]    = "de";
$lang["langcode"]    = "de;de-de;de-at;de-li;de-lu;de-ch;";
$lang["pgv_language"]    = "languages/lang.de.php";
$lang["confighelpfile"]    = "languages/configure_help.de.php";
$lang["helptextfile"]    = "languages/help_text.de.php";
$lang["flagsfile"]    = "images/flags/germany.gif";
$lang["factsfile"]    = "languages/facts.de.php";
$lang["adminfile"]    = "languages/admin.de.php";
$lang["editorfile"]    = "languages/editor.de.php";
$lang["countryfile"]    = "languages/countries.de.php";
$lang["faqlistfile"]    = "languages/faqlist.de.php";
$lang["extrafile"]    = "languages/extra.de.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "H:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AÄBCDEFGHIJKLMNOÖPQRSßTUÜVWXYZ";
$lang["ALPHABET_lower"]    = "aäbcdefghijklmnoöpqrsßtuüvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["german"]  = $lang;

//-- settings for english
$lang = array();
$lang["pgv_langname"]    = "english";
$lang["pgv_lang_use"]    = true;
$lang["pgv_lang"]    = "English";
$lang["lang_short_cut"]    = "en";
$lang["langcode"]    = "en;en-us;en-au;en-bz;en-ca;en-ie;en-jm;en-nz;en-ph;en-za;en-tt;en-gb;en-zw;";
$lang["pgv_language"]    = "languages/lang.en.php";
$lang["confighelpfile"]    = "languages/configure_help.en.php";
$lang["helptextfile"]    = "languages/help_text.en.php";
$lang["flagsfile"]    = "images/flags/usa.gif";
$lang["factsfile"]    = "languages/facts.en.php";
$lang["adminfile"]    = "languages/admin.en.php";
$lang["editorfile"]    = "languages/editor.en.php";
$lang["countryfile"]    = "languages/countries.en.php";
$lang["faqlistfile"]    = "languages/faqlist.en.php";
$lang["extrafile"]    = "languages/extra.en.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["english"]  = $lang;

//-- settings for spanish
$lang = array();
$lang["pgv_langname"]    = "spanish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Español";
$lang["lang_short_cut"]    = "es";
$lang["langcode"]    = "es;es-ar;es-bo;es-cl;es-co;es-cr;es-do;es-ec;es-sv;es-gt;es-hn;es-mx;es-ni;es-pa;es-py;es-pe;es-pr;es-us;es-uy;es-ve;";
$lang["pgv_language"]    = "languages/lang.es.php";
$lang["confighelpfile"]    = "languages/configure_help.es.php";
$lang["helptextfile"]    = "languages/help_text.es.php";
$lang["flagsfile"]    = "images/flags/spain.gif";
$lang["factsfile"]    = "languages/facts.es.php";
$lang["adminfile"]    = "languages/admin.es.php";
$lang["editorfile"]    = "languages/editor.es.php";
$lang["countryfile"]    = "languages/countries.es.php";
$lang["faqlistfile"]    = "languages/faqlist.es.php";
$lang["extrafile"]    = "languages/extra.es.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNÑOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnñopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["spanish"]  = $lang;

//-- settings for spanish-ar
$lang = array();
$lang["pgv_langname"]    = "spanish-ar";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Español Latinoamericano";
$lang["lang_short_cut"]    = "es-ar";
$lang["langcode"]    = "es;es-ar;es-bo;es-cl;es-co;es-cr;es-do;es-ec;es-sv;es-gt;es-hn;es-mx;es-ni;es-pa;es-py;es-pe;es-pr;es-us;es-uy;es-ve;";
$lang["pgv_language"]    = "languages/lang.es-ar.php";
$lang["confighelpfile"]    = "languages/configure_help.es-ar.php";
$lang["helptextfile"]    = "languages/help_text.es-ar.php";
$lang["flagsfile"]    = "images/flags/argentina.gif";
$lang["factsfile"]    = "languages/facts.es-ar.php";
$lang["adminfile"]    = "languages/admin.es-ar.php";
$lang["editorfile"]    = "languages/editor.es-ar.php";
$lang["countryfile"]    = "languages/countries.es-ar.php";
$lang["faqlistfile"]    = "languages/faqlist.es-ar.php";
$lang["extrafile"]    = "languages/extra.es-ar.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNÑOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnñopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["spanish-ar"]  = $lang;

//-- settings for french
$lang = array();
$lang["pgv_langname"]    = "french";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Français";
$lang["lang_short_cut"]    = "fr";
$lang["langcode"]    = "fr;fr-be;fr-ca;fr-lu;fr-mc;fr-ch;";
$lang["pgv_language"]    = "languages/lang.fr.php";
$lang["confighelpfile"]    = "languages/configure_help.fr.php";
$lang["helptextfile"]    = "languages/help_text.fr.php";
$lang["flagsfile"]    = "images/flags/france.gif";
$lang["factsfile"]    = "languages/facts.fr.php";
$lang["adminfile"]    = "languages/admin.fr.php";
$lang["editorfile"]    = "languages/editor.fr.php";
$lang["countryfile"]    = "languages/countries.fr.php";
$lang["faqlistfile"]    = "languages/faqlist.fr.php";
$lang["extrafile"]    = "languages/extra.fr.php";
$lang["DATE_FORMAT"]    = "D j F Y";
$lang["TIME_FORMAT"]    = "H:i:s";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AÀÂÆBCÇDEÉÈËÊFGHIÏÎJKLMNOÔŒPQRSTUÙÛVWXYZ";
$lang["ALPHABET_lower"]    = "aàâæbcçdeéèëêfghiïîjklmnoôœpqrstuùûvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["french"]  = $lang;

//-- settings for italian
$lang = array();
$lang["pgv_langname"]    = "italian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Italiano";
$lang["lang_short_cut"]    = "it";
$lang["langcode"]    = "it;it-ch;";
$lang["pgv_language"]    = "languages/lang.it.php";
$lang["confighelpfile"]    = "languages/configure_help.it.php";
$lang["helptextfile"]    = "languages/help_text.it.php";
$lang["flagsfile"]    = "images/flags/italy.gif";
$lang["factsfile"]    = "languages/facts.it.php";
$lang["adminfile"]    = "languages/admin.it.php";
$lang["editorfile"]    = "languages/editor.it.php";
$lang["countryfile"]    = "languages/countries.it.php";
$lang["faqlistfile"]    = "languages/faqlist.it.php";
$lang["extrafile"]    = "languages/extra.it.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["italian"]  = $lang;

//-- settings for hungarian
$lang = array();
$lang["pgv_langname"]    = "hungarian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Magyar";
$lang["lang_short_cut"]    = "hu";
$lang["langcode"]    = "hu;";
$lang["pgv_language"]    = "languages/lang.hu.php";
$lang["confighelpfile"]    = "languages/configure_help.hu.php";
$lang["helptextfile"]    = "languages/help_text.hu.php";
$lang["flagsfile"]    = "images/flags/hungary.gif";
$lang["factsfile"]    = "languages/facts.hu.php";
$lang["adminfile"]    = "languages/admin.hu.php";
$lang["editorfile"]    = "languages/editor.hu.php";
$lang["countryfile"]    = "languages/countries.hu.php";
$lang["faqlistfile"]    = "languages/faqlist.hu.php";
$lang["extrafile"]    = "languages/extra.hu.php";
$lang["DATE_FORMAT"]    = "Y. M D.";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = true;
$lang["ALPHABET_upper"]    = "AÁBCDEÉFGHIÍJKLMNOÓÖŐPQRSTUÚÜŰVWXYZ";
$lang["ALPHABET_lower"]    = "aábcdeéfghiíjklmnoóöőpqrstuúüűvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "cs;ccs;dz;ddz;dzs;ddzs;gy;ggy;ly;lly;ny;nny;sz;ssz;ty;tty;zs;zzs";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["hungarian"]  = $lang;

//-- settings for dutch
$lang = array();
$lang["pgv_langname"]    = "dutch";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Nederlands";
$lang["lang_short_cut"]    = "nl";
$lang["langcode"]    = "nl;nl-be;";
$lang["pgv_language"]    = "languages/lang.nl.php";
$lang["confighelpfile"]    = "languages/configure_help.nl.php";
$lang["helptextfile"]    = "languages/help_text.nl.php";
$lang["flagsfile"]    = "images/flags/netherlands.gif";
$lang["factsfile"]    = "languages/facts.nl.php";
$lang["adminfile"]    = "languages/admin.nl.php";
$lang["editorfile"]    = "languages/editor.nl.php";
$lang["countryfile"]    = "languages/countries.nl.php";
$lang["faqlistfile"]    = "languages/faqlist.nl.php";
$lang["extrafile"]    = "languages/extra.nl.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["dutch"]  = $lang;

//-- settings for norwegian
$lang = array();
$lang["pgv_langname"]    = "norwegian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Norsk";
$lang["lang_short_cut"]    = "no";
$lang["langcode"]    = "no;nb;nn;";
$lang["pgv_language"]    = "languages/lang.no.php";
$lang["confighelpfile"]    = "languages/configure_help.no.php";
$lang["helptextfile"]    = "languages/help_text.no.php";
$lang["flagsfile"]    = "images/flags/norway.gif";
$lang["factsfile"]    = "languages/facts.no.php";
$lang["adminfile"]    = "languages/admin.no.php";
$lang["editorfile"]    = "languages/editor.no.php";
$lang["countryfile"]    = "languages/countries.no.php";
$lang["faqlistfile"]    = "languages/faqlist.no.php";
$lang["extrafile"]    = "languages/extra.no.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "H:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZÅØÆ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyzåøæ";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["norwegian"]  = $lang;

//-- settings for polish
$lang = array();
$lang["pgv_langname"]    = "polish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Polski";
$lang["lang_short_cut"]    = "pl";
$lang["langcode"]    = "pl;";
$lang["pgv_language"]    = "languages/lang.pl.php";
$lang["confighelpfile"]    = "languages/configure_help.pl.php";
$lang["helptextfile"]    = "languages/help_text.pl.php";
$lang["flagsfile"]    = "images/flags/poland.gif";
$lang["factsfile"]    = "languages/facts.pl.php";
$lang["adminfile"]    = "languages/admin.pl.php";
$lang["editorfile"]    = "languages/editor.pl.php";
$lang["countryfile"]    = "languages/countries.pl.php";
$lang["faqlistfile"]    = "languages/faqlist.pl.php";
$lang["extrafile"]    = "languages/extra.pl.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AĄBCĆDEĘFGHIJKLŁMNŃOÓPQRSŚTUVWXYZŹŻ";
$lang["ALPHABET_lower"]    = "aąbcćdeęfghijklłmnńoópqrsśtuvwxyzźż";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["polish"]  = $lang;

//-- settings for portuguese-br
$lang = array();
$lang["pgv_langname"]    = "portuguese-br";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Português";
$lang["lang_short_cut"]    = "pt-br";
$lang["langcode"]    = "pt;pt-br;";
$lang["pgv_language"]    = "languages/lang.pt-br.php";
$lang["confighelpfile"]    = "languages/configure_help.pt-br.php";
$lang["helptextfile"]    = "languages/help_text.pt-br.php";
$lang["flagsfile"]    = "images/flags/brazil.gif";
$lang["factsfile"]    = "languages/facts.pt-br.php";
$lang["adminfile"]    = "languages/admin.pt-br.php";
$lang["editorfile"]    = "languages/editor.pt-br.php";
$lang["countryfile"]    = "languages/countries.pt-br.php";
$lang["faqlistfile"]    = "languages/faqlist.pt-br.php";
$lang["extrafile"]    = "languages/extra.pt-br.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AÁÂÃBCÇDEÉÊFGHIÍJKLMNÑOÓÔÕPQRSTUÚÜVWXYZ";
$lang["ALPHABET_lower"]    = "aáâãbcçdeéêfghiíjklmnñoóôõpqrstuúüvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["portuguese-br"]  = $lang;

//-- settings for finnish
$lang = array();
$lang["pgv_langname"]    = "finnish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Suomi";
$lang["lang_short_cut"]    = "fi";
$lang["langcode"]    = "fi;";
$lang["pgv_language"]    = "languages/lang.fi.php";
$lang["confighelpfile"]    = "languages/configure_help.fi.php";
$lang["helptextfile"]    = "languages/help_text.fi.php";
$lang["flagsfile"]    = "images/flags/finland.gif";
$lang["factsfile"]    = "languages/facts.fi.php";
$lang["adminfile"]    = "languages/admin.fi.php";
$lang["editorfile"]    = "languages/editor.fi.php";
$lang["countryfile"]    = "languages/countries.fi.php";
$lang["faqlistfile"]    = "languages/faqlist.fi.php";
$lang["extrafile"]    = "languages/extra.fi.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "H:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyzåäö";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["finnish"]  = $lang;

//-- settings for swedish
$lang = array();
$lang["pgv_langname"]    = "swedish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Svenska";
$lang["lang_short_cut"]    = "sv";
$lang["langcode"]    = "sv;sv-fi;";
$lang["pgv_language"]    = "languages/lang.sv.php";
$lang["confighelpfile"]    = "languages/configure_help.sv.php";
$lang["helptextfile"]    = "languages/help_text.sv.php";
$lang["flagsfile"]    = "images/flags/sweden.gif";
$lang["factsfile"]    = "languages/facts.sv.php";
$lang["adminfile"]    = "languages/admin.sv.php";
$lang["editorfile"]    = "languages/editor.sv.php";
$lang["countryfile"]    = "languages/countries.sv.php";
$lang["faqlistfile"]    = "languages/faqlist.sv.php";
$lang["extrafile"]    = "languages/extra.sv.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "H:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyzåäö";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["swedish"]  = $lang;

//-- settings for turkish
$lang = array();
$lang["pgv_langname"]    = "turkish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Türkçe";
$lang["lang_short_cut"]    = "tr";
$lang["langcode"]    = "tr;";
$lang["pgv_language"]    = "languages/lang.tr.php";
$lang["confighelpfile"]    = "languages/configure_help.tr.php";
$lang["helptextfile"]    = "languages/help_text.tr.php";
$lang["flagsfile"]    = "images/flags/turkey.gif";
$lang["factsfile"]    = "languages/facts.tr.php";
$lang["adminfile"]    = "languages/admin.tr.php";
$lang["editorfile"]    = "languages/editor.tr.php";
$lang["countryfile"]    = "languages/countries.tr.php";
$lang["faqlistfile"]    = "languages/faqlist.tr.php";
$lang["extrafile"]    = "languages/extra.tr.php";
$lang["faqlistfile"]    = "languages/faqlist.tr.php";
$lang["extrafile"]    = "languages/extra.tr.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCÇDEFGĞHIİJKLMNOÖPRSŞTUÜVYZ";
$lang["ALPHABET_lower"]    = "abcçdefgğhıijklmnoöprsştuüvyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["turkish"]  = $lang;

//-- settings for chinese
$lang = array();
$lang["pgv_langname"]    = "chinese";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "繁體中文";
$lang["lang_short_cut"]    = "zh";
$lang["langcode"]    = "zh;zh-cn;zh-hk;zh-mo;zh-sg;zh-tw;";
$lang["pgv_language"]    = "languages/lang.zh.php";
$lang["confighelpfile"]    = "languages/configure_help.zh.php";
$lang["helptextfile"]    = "languages/help_text.zh.php";
$lang["flagsfile"]    = "images/flags/china.gif";
$lang["factsfile"]    = "languages/facts.zh.php";
$lang["adminfile"]    = "languages/admin.zh.php";
$lang["editorfile"]    = "languages/editor.zh.php";
$lang["countryfile"]    = "languages/countries.zh.php";
$lang["faqlistfile"]    = "languages/faqlist.zh.php";
$lang["extrafile"]    = "languages/extra.zh.php";
$lang["DATE_FORMAT"]    = "Y年 M D日";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = true;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["chinese"]  = $lang;

//-- settings for hebrew
$lang = array();
$lang["pgv_langname"]    = "hebrew";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "‏עברית";
$lang["lang_short_cut"]    = "he";
$lang["langcode"]    = "he;";
$lang["pgv_language"]    = "languages/lang.he.php";
$lang["confighelpfile"]    = "languages/configure_help.he.php";
$lang["helptextfile"]    = "languages/help_text.he.php";
$lang["flagsfile"]    = "images/flags/israel.gif";
$lang["factsfile"]    = "languages/facts.he.php";
$lang["adminfile"]    = "languages/admin.he.php";
$lang["editorfile"]    = "languages/editor.he.php";
$lang["countryfile"]    = "languages/countries.he.php";
$lang["faqlistfile"]    = "languages/faqlist.he.php";
$lang["extrafile"]    = "languages/extra.he.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "rtl";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "אבגדהוזחטיכךלמםנןסעפףצץקרשת";
$lang["ALPHABET_lower"]    = "אבגדהוזחטיכךלמםנןסעפףצץקרשת";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["hebrew"]  = $lang;

//-- settings for russian
$lang = array();
$lang["pgv_langname"]    = "russian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "русский";
$lang["lang_short_cut"]    = "ru";
$lang["langcode"]    = "ru;ru-md;";
$lang["pgv_language"]    = "languages/lang.ru.php";
$lang["confighelpfile"]    = "languages/configure_help.ru.php";
$lang["helptextfile"]    = "languages/help_text.ru.php";
$lang["flagsfile"]    = "images/flags/russia.gif";
$lang["factsfile"]    = "languages/facts.ru.php";
$lang["adminfile"]    = "languages/admin.ru.php";
$lang["editorfile"]    = "languages/editor.ru.php";
$lang["countryfile"]    = "languages/countries.ru.php";
$lang["faqlistfile"]    = "languages/faqlist.ru.php";
$lang["extrafile"]    = "languages/extra.ru.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ";
$lang["ALPHABET_lower"]    = "абвгдеёжзийклмнопрстуфхцчшщъыьэюя";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["russian"]  = $lang;

//-- settings for greek
$lang = array();
$lang["pgv_langname"]    = "greek";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Ελληνικά";
$lang["lang_short_cut"]    = "el";
$lang["langcode"]    = "el;";
$lang["pgv_language"]    = "languages/lang.el.php";
$lang["confighelpfile"]    = "languages/configure_help.el.php";
$lang["helptextfile"]    = "languages/help_text.el.php";
$lang["flagsfile"]    = "images/flags/greece.gif";
$lang["factsfile"]    = "languages/facts.el.php";
$lang["adminfile"]    = "languages/admin.el.php";
$lang["editorfile"]    = "languages/editor.el.php";
$lang["countryfile"]    = "languages/countries.el.php";
$lang["faqlistfile"]    = "languages/faqlist.el.php";
$lang["extrafile"]    = "languages/extra.el.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ΆΑΒΓΔΈΕΖΉΗΘΊΪΪΙΚΛΜΝΞΌΟΠΡΣΣΤΎΫΫΥΦΧΨΏΩ";
$lang["ALPHABET_lower"]    = "άαβγδέεζήηθίϊΐικλμνξόοπρσςτύϋΰυφχψώω";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["greek"]  = $lang;

//-- settings for arabic
$lang = array();
$lang["pgv_langname"]    = "arabic";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "عربي";
$lang["lang_short_cut"]    = "ar";
$lang["langcode"]    = "ar;ar-ae;ar-bh;ar-dz;ar-eg;ar-iq;ar-jo;ar-kw;ar-lb;ar-ly;ar-ma;ar-om;ar-qa;ar-sa;ar-sy;ar-tn;ar-ye;";
$lang["pgv_language"]    = "languages/lang.ar.php";
$lang["confighelpfile"]    = "languages/configure_help.ar.php";
$lang["helptextfile"]    = "languages/help_text.ar.php";
$lang["flagsfile"]    = "images/flags/arab league.gif";
$lang["factsfile"]    = "languages/facts.ar.php";
$lang["adminfile"]    = "languages/admin.ar.php";
$lang["editorfile"]    = "languages/editor.ar.php";
$lang["countryfile"]    = "languages/countries.ar.php";
$lang["faqlistfile"]    = "languages/faqlist.ar.php";
$lang["extrafile"]    = "languages/extra.ar.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "h:i:sA";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "rtl";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ابتثجحخدذرزسشصضطظعغفقكلمنهويآةىی";
$lang["ALPHABET_lower"]    = "ابتثجحخدذرزسشصضطظعغفقكلمنهويآةىی";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["arabic"]  = $lang;

//-- settings for lithuanian
$lang = array();
$lang["pgv_langname"]    = "lithuanian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Lietuvių";
$lang["lang_short_cut"]    = "lt";
$lang["langcode"]    = "lt;";
$lang["pgv_language"]    = "languages/lang.lt.php";
$lang["confighelpfile"]    = "languages/configure_help.lt.php";
$lang["helptextfile"]    = "languages/help_text.lt.php";
$lang["flagsfile"]    = "images/flags/lithuania.gif";
$lang["factsfile"]    = "languages/facts.lt.php";
$lang["adminfile"]    = "languages/admin.lt.php";
$lang["editorfile"]    = "languages/editor.lt.php";
$lang["countryfile"]    = "languages/countries.lt.php";
$lang["faqlistfile"]    = "languages/faqlist.lt.php";
$lang["extrafile"]    = "languages/extra.lt.php";
$lang["DATE_FORMAT"]    = "Y M D";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AĄBCČDEĘĖFGHIYĮJKLMNOPRSŠTUŲŪVZŽ";
$lang["ALPHABET_lower"]    = "aąbcčdeęėfghiyįjklmnoprsštuųūvzž";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["lithuanian"]  = $lang;

//-- settings for danish
$lang = array();
$lang["pgv_langname"]    = "danish";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Dansk";
$lang["lang_short_cut"]    = "da";
$lang["langcode"]    = "da;";
$lang["pgv_language"]    = "languages/lang.da.php";
$lang["confighelpfile"]    = "languages/configure_help.da.php";
$lang["helptextfile"]    = "languages/help_text.da.php";
$lang["flagsfile"]    = "images/flags/denmark.gif";
$lang["factsfile"]    = "languages/facts.da.php";
$lang["adminfile"]    = "languages/admin.da.php";
$lang["editorfile"]    = "languages/editor.da.php";
$lang["countryfile"]    = "languages/countries.da.php";
$lang["faqlistfile"]    = "languages/faqlist.da.php";
$lang["extrafile"]    = "languages/extra.da.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSTUVWXYZÆØÅ";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrstuvwxyzæøå";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= false;
$language_settings["danish"]  = $lang;

//-- settings for vietnamese
$lang = array();
$lang["pgv_langname"]    = "vietnamese";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Tiếng Việt";
$lang["lang_short_cut"]    = "vi";
$lang["langcode"]    = "vi;";
$lang["pgv_language"]    = "languages/lang.vi.php";
$lang["confighelpfile"]    = "languages/configure_help.vi.php";
$lang["helptextfile"]    = "languages/help_text.vi.php";
$lang["flagsfile"]    = "images/flags/vietnam.gif";
$lang["factsfile"]    = "languages/facts.vi.php";
$lang["adminfile"]    = "languages/admin.vi.php";
$lang["editorfile"]    = "languages/editor.vi.php";
$lang["countryfile"]    = "languages/countries.vi.php";
$lang["faqlistfile"]    = "languages/faqlist.vi.php";
$lang["extrafile"]    = "languages/extra.vi.php";
$lang["DATE_FORMAT"]    = "D M Y";
$lang["TIME_FORMAT"]    = "g:i:sa";
$lang["WEEK_START"]    = "0";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = true;
$lang["ALPHABET_upper"]    = "AÀẢÃÁẠĂẰẲẴẮẶÂẦẨẪẤẬBCDĐEÈẺẼÉẸÊỀỂỄẾỆFGHIÌỈĨÍỊJKLMNOÒỎÕÓỌÔỒỔỖỐỘƠỜỞỠỚỢPQRSTUÙỦŨÚỤƯỪỬỮỨỰVWXYỲỶỸÝỴZ";
$lang["ALPHABET_lower"]    = "aàảãáạăằẳẵắặâầẩẫấậbcdđeèẻẽéẹêềểễếệfghiìỉĩíịjklmnoòỏõóọôồổỗốộơờởỡớợpqrstuùủũúụưừửữứựvwxyỳỷỹýỵz";
$lang["MULTI_LETTER_ALPHABET"]	= "";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["vietnamese"]  = $lang;

//-- settings for slovak
$lang = array();
$lang["pgv_langname"]    = "slovak";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Slovenčina";
$lang["lang_short_cut"]    = "sk";
$lang["langcode"]    = "sk;";
$lang["pgv_language"]    = "languages/lang.sk.php";
$lang["confighelpfile"]    = "languages/configure_help.sk.php";
$lang["helptextfile"]    = "languages/help_text.sk.php";
$lang["flagsfile"]    = "images/flags/slovakia.gif";
$lang["factsfile"]    = "languages/facts.sk.php";
$lang["adminfile"]    = "languages/admin.sk.php";
$lang["editorfile"]    = "languages/editor.sk.php";
$lang["countryfile"]    = "languages/countries.sk.php";
$lang["faqlistfile"]    = "languages/faqlist.sk.php";
$lang["extrafile"]    = "languages/extra.sk.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "AÁÄBCČDĎEÉFGHCHIÍJKLĽĹMNŇOÓÔPQRŔSŠTŤUÚVWXYÝZŽ";
$lang["ALPHABET_lower"]    = "aáäbcčdďeéfghchiíjklľĺmnňoóôpqrŕsštťuúvwxyýzž";
$lang["MULTI_LETTER_ALPHABET"]	= "dz,ch";
$lang["DICTIONARY_SORT"]	= true;
$language_settings["slovak"]  = $lang;

//-- settings for estonian
$lang = array();
$lang["pgv_langname"]    = "estonian";
$lang["pgv_lang_use"]    = false;
$lang["pgv_lang"]    = "Eesti";
$lang["lang_short_cut"]    = "et";
$lang["langcode"]    = "et;";
$lang["pgv_language"]    = "languages/lang.et.php";
$lang["confighelpfile"]    = "languages/configure_help.et.php";
$lang["helptextfile"]    = "languages/help_text.et.php";
$lang["flagsfile"]    = "images/flags/estonia.gif";
$lang["factsfile"]    = "languages/facts.et.php";
$lang["adminfile"]    = "languages/admin.et.php";
$lang["editorfile"]    = "languages/editor.et.php";
$lang["countryfile"]    = "languages/countries.et.php";
$lang["faqlistfile"]    = "languages/faqlist.et.php";
$lang["extrafile"]    = "languages/extra.et.php";
$lang["DATE_FORMAT"]    = "D. M Y";
$lang["TIME_FORMAT"]    = "G:i:s";
$lang["WEEK_START"]    = "1";
$lang["TEXT_DIRECTION"]    = "ltr";
$lang["NAME_REVERSE"]    = false;
$lang["ALPHABET_upper"]    = "ABCDEFGHIJKLMNOPQRSŠZŽTUVWÕÄÖÜXY";
$lang["ALPHABET_lower"]    = "abcdefghijklmnopqrsšzžtuvwõäöüxy";
$lang["MULTI_LETTER_ALPHABET"]    = "";
$lang["DICTIONARY_SORT"]    = false;
$language_settings["estonian"]  = $lang;

//-- NEVER manually delete or edit this entry and every line above this entry! --END--//

?>
