<?php
/**
*
* common [Danish]
*
* @package language
* @version Id: common.php 11057 2011-03-13 04:45:12Z git-gate $
* @version $Id: common.php 179 2011-11-25 08:07:09Z Jan Skovsgaard $
* @source file is copyright (c) 2005 phpBB Group
* @modified and translated by Olympus DK Team
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU Public License version 2
*
* This file is part of the Danish language package for phpBB 3.x.x.
* Copyright (c) 2006, 2007, 2008 Olympus DK Team
*
* The package is free software; you can redistribute it and/or modify it under the terms of the GNU
* General Public License as published by the Free Software Foundation, version 2 of the License.
*
* The Danish language package is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
* A PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along with this language
* package. If not, see <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Danish translation &amp; support by <a href="http://www.olympusdkteam.dk">Olympus DK Team</a>',
	'DIRECTION'	=> 'ltr',
	'DATE_FORMAT'	=> '|j. M Y|',// 1. jan 2007 (med relative dage aktiveret)
	'USER_LANG'			=> 'da',

	'1_DAY'	=> '1 dag',
	'1_MONTH'	=> '1 måned',
	'1_YEAR'	=> '1 år',
	'2_WEEKS'	=> '2 uger',
	'3_MONTHS'	=> '3 måneder',
	'6_MONTHS'	=> '6 måneder',
	'7_DAYS'	=> '7 dage',

	'ACCOUNT_ALREADY_ACTIVATED'	=> 'Din konto er allerede aktiveret.',
	'ACCOUNT_DEACTIVATED'	=> 'Din konto er manuelt deaktiveret og kan kun genaktiveres af en administrator.',
	'ACCOUNT_NOT_ACTIVATED'	=> 'Din konto er endnu ikke aktiveret.',
	'ACP'	=> 'Administratorkontrolpanel',
	'ACTIVE'	=> 'aktiv',
	'ACTIVE_ERROR'	=> 'Det angivne brugernavn er i øjeblikket ikke aktivt. Kontakt venligst en boardadministrator, hvis du har problemer med at aktivere din konto.',
	'ADMINISTRATOR'	=> 'Administrator',
	'ADMINISTRATORS'	=> 'Administratorer',
	'AGE'							=> 'Alder',
	'AIM'							=> 'AIM',
	'ALLOWED'	=> 'Tilladt',
	'ALL_FILES'	=> 'Alle filer',
	'ALL_FORUMS'	=> 'Alle fora',
	'ALL_MESSAGES'	=> 'Alle beskeder',
	'ALL_POSTS'	=> 'Alle indlæg',
	'ALL_TIMES'	=> 'Alle tider er %1$s %2$s',
	'ALL_TOPICS'	=> 'Alle emner',
	'AND'	=> 'og',
	'ARE_WATCHING_FORUM'	=> 'Du overvåger nu forummet og bliver informeret ved nye indlæg i dette.',
	'ARE_WATCHING_TOPIC'	=> 'Du overvåger nu emnet og bliver informeret ved nye indlæg i dette.',
	'ASCENDING'	=> 'Stigende',
	'ATTACHMENTS'	=> 'Vedhæftede filer',
	'ATTACHED_IMAGE_NOT_IMAGE'	=> 'Den billedfil du forsøgte at vedhæfte er ugyldig.',
	'AUTHOR'	=> 'Forfatter',
	'AUTH_NO_PROFILE_CREATED'		=> 'Oprettelse af brugerprofil slog fejl.',
	'AVATAR_DISALLOWED_CONTENT'	=> 'Upload blev afvist, filen blev identificeret som et muligt angrebsforsøg.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Denne fil kan ikke vises, da filtypen <strong>%s</strong> er ikke tilladt.',
	'AVATAR_EMPTY_REMOTE_DATA'	=> 'Angivne avatar kunne ikke uploades, fordi data fra den eksterne server ser ud til at være ugyldige eller ødelagte.',
	'AVATAR_EMPTY_FILEUPLOAD'	=> 'Den uploadede avatarfil er tom.',
	'AVATAR_INVALID_FILENAME'	=> '%s er et ugyldigt filnavn.',
	'AVATAR_NOT_UPLOADED'	=> 'Avatar kunne ikke uploades.',
	'AVATAR_NO_SIZE'	=> 'Bredde eller højde på det linkede avatar kunne ikke bestemmes. Indtast dem venligst manuelt.',
	'AVATAR_PARTIAL_UPLOAD'	=> 'Den angivne fil blev kun delvist uploadet.',
	'AVATAR_PHP_SIZE_NA'	=> 'Avatarens filstørrelse er for stor.<br />Den maksimale filstørrelse defineret i php.ini kunne ikke afgøres.',
	'AVATAR_PHP_SIZE_OVERRUN'	=> 'Avatarens filstørrelse er for stor. Den maksimale uploadstørrelse er %1$d %2$s.<br />Bemærk at grænsen er defineret i php.ini filen, og ikke kan tilsidesættes.',
	'AVATAR_URL_INVALID'	=> 'Den angivne URL er ugyldig.',
	'AVATAR_URL_NOT_FOUND'	=> 'Den angivne fil kunne ikke findes.',
	'AVATAR_WRONG_FILESIZE'	=> 'Avatarens filstørrelse skal være mellem 0 og %1d %2s.',
	'AVATAR_WRONG_SIZE'	=> 'Den indsendte avatar er %5$d pixels bred og %6$d pixels høj. Den skal være mindst %1$d pixels bred, %2$d pixels høj og maksimalt %3$d pixels bred og %4$d pixels høj.',

	'BACK_TO_TOP'	=> 'Top',
	'BACK_TO_PREV'	=> 'Tilbage til foregående side',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Din emailadresse er blevet udelukket.',
	'BAN_TRIGGERED_BY_IP'	=> 'Din IP-adresse er blevet udelukket.',
	'BAN_TRIGGERED_BY_USER'	=> 'Dit brugernavn er blevet udelukket.',
	'BBCODE_GUIDE'	=> 'BBkode-guide',
	'BCC'	=> 'BCC',
	'BIRTHDAYS'	=> 'Fødselsdage',
	'BOARD_BAN_PERM'	=> 'Du er blevet udelukket <strong>permanent</strong> fra dette board.<br /><br />Kontakt venligst %2$sboardadministrator%3$s for yderligere oplysninger.',
	'BOARD_BAN_REASON'	=> 'Årsag angivet for udelukkelse: <strong>%s</strong>',
	'BOARD_BAN_TIME'	=> 'Du er blevet udelukket fra dette board indtil <strong>%1$s</strong>.<br /><br />Kontakt venligst %2$sboardadministrator%3$s for yderligere oplysninger.',
	'BOARD_DISABLE'	=> 'Beklager, men dette board er ikke tilgængeligt i øjeblikket.',
	'BOARD_DISABLED'		=> 'Beklager, men boardet er ikke tilgængeligt i øjeblikket.',
	'BOARD_UNAVAILABLE'	=> 'Beklager, men dette board er midlertidigt ikke tilgængeligt, prøv venligst igen om et par minutter.',
	'BROWSING_FORUM'		=> 'Brugere der læser dette forum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Brugere der læser dette forum: %1$s og %2$d gæst',
	'BROWSING_FORUM_GUESTS'	=> 'Brugere der læser dette forum: %1$s og %2$d gæster',
	'BYTES'	=> 'bytes',

	'CANCEL'	=> 'Annuller',
	'CHANGE'	=> 'Skift',
    'CHANGE_FONT_SIZE'		=> 'Skift skriftstørrelse',
	'CHANGING_PREFERENCES'	=> 'Ændrer boardindstillinger',
	'CHANGING_PROFILE'		=> 'Ændrer profilindstillinger',
	'CLICK_VIEW_PRIVMSG'	=> '%sTilbage til din indbakke%s',
	'CLOSE_WINDOW'	=> 'Luk vindue',
	'COLLAPSE_VIEW'			=> 'Kollaps visning',
	'COLOUR_SWATCH'	=> 'Farvepalette',
	'COMMA_SEPARATOR'	=> ', ',        // Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'	=> 'Bekræft',
	'CONFIRM_CODE'	=> 'Bekræftelseskode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Indtast koden præcis som du ser den i billedet. Der er ikke forskel på store og små bogstaver.',
	'CONFIRM_CODE_WRONG'	=> 'Den indtastede bekræftelseskode er ugyldig.',
	'CONFIRM_OPERATION'		=> 'Er du sikker på at du ønsker at udføre denne handling?',
	'CONGRATULATIONS'	=> 'Tillykke til',
	'CONNECTION_FAILED'	=> 'Forbindelse fejlede!',
	'CONNECTION_SUCCESS'	=> 'Forbindelse etableret!',
	'COOKIES_DELETED'	=> 'Alle boardcookies er blevet slettet.',
	'CURRENT_TIME'	=> 'Dato og tid er %s',

	'DAY'	=> 'Dag',	// anvendes kun i UCP ved angivelse af fødselsdag?
	'DAYS'	=> 'dage',
	'DELETE'	=> 'Slet',
	'DELETE_ALL'	=> 'Slet alle',
	'DELETE_COOKIES'	=> 'Slet alle boardcookies',
	'DELETE_MARKED'	=> 'Slet valgte',
	'DELETE_POST'	=> 'Slet indlæg',
	'DELIMITER'	=> 'Afgrænsning',
	'DESCENDING'	=> 'Faldende',
	'DISABLED'	=> 'Inaktiv',
	'DISPLAY'	=> 'Visning',
	'DISPLAY_GUESTS'	=> 'Vis gæster',
	'DISPLAY_MESSAGES'	=> 'Vis beskeder fra seneste',
	'DISPLAY_POSTS'	=> 'Vis indlæg fra foregående',
	'DISPLAY_TOPICS'	=> 'Vis emner fra foregående',
	'DOWNLOADED'	=> 'Downloadet',
	'DOWNLOADING_FILE'	=> 'Downloader fil',
	'DOWNLOAD_COUNT'	=> 'Downloadet %d gang',
	'DOWNLOAD_COUNTS'	=> 'Downloadet %d gange',
	'DOWNLOAD_COUNT_NONE'	=> 'Ikke downloadet endnu',
	'VIEWED_COUNT'	=> 'Vist %d gang',
	'VIEWED_COUNTS'	=> 'Vist %d gange',
	'VIEWED_COUNT_NONE'	=> 'Ikke vist endnu',

	'EDIT_POST'	=> 'Rediger indlæg',
	'EMAIL'	=> 'Email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'	=> 'Emailadresse',
	'EMAIL_SMTP_ERROR_RESPONSE'	=> 'Løb ind i problemer med at sende email: <strong>Linie %1$s</strong>. Svar: %2$s.',
	'EMPTY_SUBJECT'	=> 'Du skal angive en titel når du skriver et nyt emne.',
	'EMPTY_MESSAGE_SUBJECT'	=> 'Du skal angive en titel når du skriver en ny besked.',
	'ENABLED'	=> 'Aktiv',
	'ENCLOSURE'	=> 'Bilag',
	'ENTER_USERNAME'          => 'Angiv brugernavn',
	'ERR_CHANGING_DIRECTORY'	=> 'Kunne ikke skifte mappe.',
	'ERR_CONNECTING_SERVER'	=> 'Kunne ikke forbinde til server.',
	'ERR_JAB_AUTH'			=> 'Kunne ikke autoriseres på Jabberserver.',
	'ERR_JAB_CONNECT'		=> 'Kunne ikke forbinde til Jabberserver.',
	'ERR_UNABLE_TO_LOGIN'	=> 'Det angivne brugernavn eller kodeord er ikke korrekt.',
	'ERR_UNWATCHING'			=> 'Der opstod en fejl under forsøget på at slå overvågning fra.',
	'ERR_WATCHING'				=> 'Der opstod en fejl under forsøget på at slå overvågning til.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Den angivne phpBB sti synes at være ugyldig.',
	'EXPAND_VIEW'						=> 'Udvidet visning',
	'EXTENSION'	=> 'Filtype',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Filtypen <strong>%s</strong> er deaktiveret og kan ikke længere vises.',

	'FAQ'	=> 'OSS',
	'FAQ_EXPLAIN'	=> 'Ofte stillede spørgsmål',
	'FILENAME'	=> 'Filnavn',
	'FILESIZE'	=> 'Filstørrelse',
	'FILEDATE'				=> 'Fildato',
	'FILE_COMMENT'	=> 'Filkommentar',
	'FILE_NOT_FOUND'	=> 'Den ønskede fil kunne ikke findes.',
	'FIND_USERNAME'	=> 'Find en tilmeldt bruger',
	'FOLDER'	=> 'Mappe',
	'FORGOT_PASS'	=> 'Jeg har glemt mit kodeord',
	'FORM_INVALID'			=> 'Den indsendte formular var ugyldig. Prøv at indsende igen.',
	'FORUM'	=> 'Forum',
	'FORUMS'	=> 'Fora',
	'FORUMS_MARKED'	=> 'Valgte fora er markeret læste.',
	'FORUM_CAT'	=> 'Forumkategori',
	'FORUM_INDEX'	=> 'Boardindeks',
	'FORUM_LINK'	=> 'Forumlink',
	'FORUM_LOCATION'	=> 'Forumplacering',
	'FORUM_LOCKED'	=> 'Forum låst',
	'FORUM_RULES'	=> 'Forumregler',
	'FORUM_RULES_LINK'	=> 'Klik venligst her for at læse forumreglerne',
	'FROM'	=> 'fra',
	'FSOCK_DISABLED'	=> 'Handlingen kunne ikke gennemføres fordi funktionen <var>fsockopen</var> er deaktiveret, eller fordi den forespurgte server ikke kunne findes.',
	'FSOCK_TIMEOUT'      => 'Der opstod en timeout under læsning af network stream.',

	'FTP_FSOCK_HOST'	=> 'FTP-vært',
	'FTP_FSOCK_HOST_EXPLAIN'	=> 'FTP-server brugt til at forbinde dit site.',
	'FTP_FSOCK_PASSWORD'	=> 'FTP-kodeord',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Kodeord for din FTP-bruger.',
	'FTP_FSOCK_PORT'	=> 'FTP-port',
	'FTP_FSOCK_PORT_EXPLAIN'	=> 'Port der bruges til at forbinde til din server.',
	'FTP_FSOCK_ROOT_PATH'	=> 'Sti til phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Sti fra roden til dit phpBB-board.',
	'FTP_FSOCK_TIMEOUT'	=> 'FTP-timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'	=> 'Antallet af sekunder systemet vil vente på et svar fra din server.',
	'FTP_FSOCK_USERNAME'	=> 'FTP-brugernavn',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Brugernavn der bruges til at forbinde til din server.',

	'FTP_HOST'	=> 'FTP-vært',
	'FTP_HOST_EXPLAIN'	=> 'FTP-server brugt til at forbinde til dit site.',
	'FTP_PASSWORD'	=> 'FTP-kodeord',
	'FTP_PASSWORD_EXPLAIN'	=> 'Kodeord for din FTP-bruger.',
	'FTP_PORT'	=> 'FTP-port',
	'FTP_PORT_EXPLAIN'	=> 'Port der bruges til at forbinde til din server.',
	'FTP_ROOT_PATH'	=> 'Sti til phpBB',
	'FTP_ROOT_PATH_EXPLAIN'	=> 'Sti fra roden til dit phpBB-board.',
	'FTP_TIMEOUT'	=> 'FTP-timeout',
	'FTP_TIMEOUT_EXPLAIN'	=> 'Antallet af sekunder systemet vil vente på et svar fra din server.',
	'FTP_USERNAME'	=> 'FTP-brugernavn',
	'FTP_USERNAME_EXPLAIN'	=> 'Brugernavn der bruges til at forbinde til din server.',

	'GENERAL_ERROR'	=> 'Generel fejl',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',	
	'GO'	=> 'Udfør',
	'GOTO_PAGE'	=> 'Gå til side',
	'GROUP'	=> 'Gruppe',
	'GROUPS'	=> 'Grupper',
	'GROUP_ERR_TYPE'	=> 'Upassende gruppetype valgt.',
	'GROUP_ERR_USERNAME'	=> 'Intet gruppenavn angivet.',
	'GROUP_ERR_USER_LONG'	=> 'Gruppenavne må ikke være længere end 60 tegn. Det angivne gruppenavn er for langt.',
	'GUEST'	=> 'Gæst',
	'GUEST_USERS_ONLINE'	=> 'Der er %d gæster online',
	'GUEST_USERS_TOTAL'	=> '%d gæster',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Der er 0 gæster online',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 gæster',
	'GUEST_USER_ONLINE'	=> 'Der er %d gæst online',
	'GUEST_USER_TOTAL'	=> '%d gæst',
	'G_ADMINISTRATORS'	=> 'Administratorer',
	'G_BOTS'	=> 'Botter',
	'G_GUESTS'	=> 'Gæster',
	'G_REGISTERED'	=> 'Tilmeldte brugere',
	'G_REGISTERED_COPPA'	=> 'Tilmeldte COPPA-brugere',
	'G_GLOBAL_MODERATORS'	=> 'Globale redaktører',
	'G_NEWLY_REGISTERED'		=> 'Nye brugere',

	'HIDDEN_USERS_ONLINE'	=> '%d skjulte brugere online',
	'HIDDEN_USERS_TOTAL'	=> '%d skjulte',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d skjulte og ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 skjulte brugere online',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 skjulte',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 skjulte og ',
	'HIDDEN_USER_ONLINE'	=> '%d skjult bruger online',
	'HIDDEN_USER_TOTAL'	=> '%d skjult',
	'HIDDEN_USER_TOTAL_AND'	=> '%d skjult og ',
	'HIDE_GUESTS'	=> 'Skjul gæster',
	'HIDE_ME'	=> 'Skjul min onlinestatus ved dette besøg',
	'HOURS'	=> 'timer',
	'HOME'	=> 'Hjem',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'	=> 'ICQ-status',
	'IF'	=> 'Hvis',
	'IMAGE'	=> 'Billede',
	'IMAGE_FILETYPE_INVALID'	=> 'Billedfiltype %d for mimetype %s ikke understøttet.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Billedfiltype passer ikke: Forventet filtype %1$s med filtype %2$s givet.',
	'IN'	=> 'i',
	'INDEX'	=> 'Boardindeks',
	'INFORMATION'	=> 'Information',
	'INTERESTS'	=> 'Interesser',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ugyldig overvågningsbestilling.',
	'INVALID_EMAIL_LOG'	=> '<strong>%s</strong> er muligvis en ugyldig emailadresse?',
	'IP'	=> 'IP-adresse',
	'IP_BLACKLISTED'			=> 'Din IP-adresse %1$s er blevet blokeret fordi den er sortlistet. For information se venligst <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'	=> 'Tilmeldt',
	'JUMP_PAGE'	=> 'Indtast det sidenummer du ønsker at gå til',
	'JUMP_TO'	=> 'Hop til',
	'JUMP_TO_PAGE'	=> 'Klik for at hoppe til side...',

	'KB'	=> 'kB',
	'KIB'	=> 'KiB',

	'LAST_POST'	=> 'Seneste indlæg',
	'LAST_UPDATED'	=> 'Sidst opdateret',
	'LAST_VISIT'			=> 'Seneste besøg',
	'LDAP_NO_LDAP_EXTENSION'	=> 'LDAP-udvidelsesmodul ikke til rådighed.',
	'LDAP_NO_SERVER_CONNECTION'	=> 'Kunne ikke forbinde til LDAP-server.',
	'LDAP_SEARCH_FAILED' => 'Der opstod en fejl under søgningen i LDAP-kataloget.',
	'LEGEND'	=> 'Farveforklaring',
	'LOCATION'	=> 'Geografisk sted',
	'LOCK_POST'	=> 'Lås indlæg',
	'LOCK_POST_EXPLAIN'	=> 'Forhindrer redigering',
	'LOCK_TOPIC'	=> 'Lås emne',
	'LOGIN'	=> 'Log ind',
	'LOGIN_CHECK_PM'	=> 'Log ind for at kontrollere dine private beskeder.',
	'LOGIN_CONFIRMATION'	=> 'Bekræftelse af login',
	'LOGIN_CONFIRM_EXPLAIN'	=> 'For at hindre brute force-hacking af brugerkonti, bedes du efter et antal forfejlede loginforsøg, indtaste en bekræftelsekode eller svare på et spørgsmål. Koden eller spørgsmålet ses herunder. Er du synshandicappet eller af andre årsager ikke kan læse koden bedes du kontakte %sboardadministrator%s.', //unused
	'LOGIN_ERROR_ATTEMPTS'	=> 'Du har overskredet antallet af tilladte loginforsøg. Du bedes derfor igen at angive dit brugernavn og kodeord, og desuden indtaste en vist bekræftelsekode eller svare på et spørgsmål herunder.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Du er ikke blevet autentificeret af Apache.',
	'LOGIN_ERROR_PASSWORD'	=> 'Du har angivet et forkert kodeord. Kontroller venligst dit kodeord, og prøv igen. Hvis du fortsat har problemer, kontakt venligst %sboardadministrator%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'          => 'Det var ikke muligt at konvertere dit kodeord under opdatering af dette boards software. Rekvirer venligst %set nyt kodeord%s. Kontakt venligst %sboardadministrator%s, hvis du fortsat har problemer.',
	'LOGIN_ERROR_USERNAME'	=> 'Du har angivet et forkert brugernavn. Kontroller venligst dit brugernavn, og prøv igen. Hvis du fortsat har problemer, kontakt venligst %sboardadministrator%s.',
	'LOGIN_FORUM'	=> 'For at læse eller skrive i dette forum skal du indtaste dets kodeord.',
	'LOGIN_INFO'	=> 'For at kunne logge ind skal du være tilmeldt. Det tager kun få sekunder at tilmelde sig, og giver dig langt flere muligheder på boardet. Som tilmeldt bruger kan du desuden få tildelt udvidede tilladelser af en boardadministrator. Før du tilmelder dig bedes du sikre dig at du er bekendt med vore brugsbetingelser og relaterede politikker. Læs også reglerne for de forskellige fora når du besøger dem.',
	'LOGIN_VIEWFORUM'	=> 'Boardadministratoren kræver at du er tilmeldt og logget ind for at læse dette forum.',
	'LOGIN_EXPLAIN_EDIT'	=> 'For at kunne redigere indlæg i dette forum skal du være tilmeldt bruger og logget ind.',
	'LOGIN_EXPLAIN_VIEWONLINE'	=> 'Du skal være tilmeldt og logget ind for at kunne se hvem der er online.',
	'LOGOUT'	=> 'Log ud',
	'LOGOUT_USER'	=> 'Log ud [ %s ]',
	'LOG_ME_IN'	=> 'Log mig automatisk ind ved hvert besøg',

	'MARK'	=> 'Vælg',
	'MARK_ALL'	=> 'Vælg alle',
	'MARK_FORUMS_READ'	=> 'Afmærk fora som læste',
	'MARK_SUBFORUMS_READ'	=> 'Afmærk subfora som læste',
	'MB'	=> 'MB',
	'MIB'	=> 'MiB',
	'MCP'	=> 'Redaktørkontrolpanel',
	'MEMBERLIST'	=> 'Tilmeldte brugere',
	'MEMBERLIST_EXPLAIN'	=> 'Vis komplet liste over de tilmeldte brugere',
	'MERGE'		=> 'Sammenlæg',
	'MERGE_POSTS'	=> 'Flyt indlæg',
	'MERGE_TOPIC'	=> 'Sammenlæg emner',
	'MESSAGE'	=> 'besked',
	'MESSAGES'	=> 'beskeder',
	'MESSAGE_BODY'	=> 'Meddelelsesindhold',
	'MINUTES'	=> 'minutter',
	'MODERATE'	=> 'Rediger',
	'MODERATOR'	=> 'Redaktør',
	'MODERATORS'	=> 'Redaktører',
	'MONTH'	=> 'Måned',
	'MOVE'	=> 'Flyt',
	'MSNM'	=> 'MSNM/WLM',

	'NA'	=> 'Ikke tilgængelig',
	'NEWEST_USER'	=> 'Senest tilmeldte bruger <strong>%s</strong>',
	'NEW_MESSAGE'	=> 'Ny besked',
	'NEW_MESSAGES'	=> 'Nye beskeder',
	'NEW_PM'	=> '<strong>%d</strong> ny besked',
	'NEW_PMS'	=> '<strong>%d</strong> nye beskeder',
	'NEW_POST'	=> 'Nyt indlæg', // Not used anymore
	'NEW_POSTS'	=> 'Nye indlæg', // Not used anymore
	'NEXT'	=> 'Næste',// Used in pagination
	'NEXT_STEP' => 'Næste',
	'NEVER'	=> 'Aldrig',
	'NO'	=> 'Nej',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Du har ikke tilladelse til at administrere denne gruppe.',
	'NOT_AUTHORISED'	=> 'Du har ikke adgangstilladelser til dette område.',
	'NOT_WATCHING_FORUM'	=> 'Du overvåger ikke længere dette forum.',
	'NOTIFY_ADMIN'			=> 'Informer venligst boardadministrator eller webmaster.',
	'NOTIFY_ADMIN_EMAIL'	=> 'Informer venligst boardadministrator eller webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NOT_WATCHING_TOPIC'	=> 'Du overvåger ikke længere på dette emne.',
	'NO_ACCESS_ATTACHMENT'	=> 'Du har ikke tilladelse til at se denne fil.',
	'NO_ACTION'					=> 'Ingen handling angivet.',
	'NO_ADMINISTRATORS'			=> 'Der er ingen administratorer.',
	'NO_AUTH_ADMIN'	=> 'Du har ikke adgang til administratorkontrolpanelet, da du ikke har administratortilladelser.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Du kan ikke genautentificere dig som en anden bruger.',
	'NO_AUTH_OPERATION'	=> 'Du har ikke de nødvendige tilladelser til at udføre denne operation.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Kunne ikke forbinde til SMTP-vært : %1$s : %2$s',
	'NO_BIRTHDAYS'	=> 'Ingen fødselsdage i dag',
	'NO_EMAIL_MESSAGE'	=> 'Meddelelsesfeltet i emailen var tomt.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Kunne ikke få svar-koder fra mailserver.',
	'NO_EMAIL_SUBJECT'	=> 'Du har ikke skrevet en emnetitel i emailen.',
	'NO_FORUM'	=> 'Det valgte forum findes ikke.',
	'NO_FORUMS'	=> 'Dette board har ingen fora.',
	'NO_GROUP'	=> 'Den angivne brugergruppe findes ikke.',
	'NO_GROUP_MEMBERS'	=> 'Denne gruppe har ingen medlemmer tilknyttet i øjeblikket.',
	'NO_IPS_DEFINED'	=> 'Ingen IP-adresser eller værtsnavne defineret.',
	'NO_MEMBERS'	=> 'Ingen medlemmer fundet med dette søgekriterie.',
	'NO_MESSAGES'	=> 'Ingen beskeder',
	'NO_MODE'					=> 'Ingen tilstand angivet.',
	'NO_MODERATORS'				=> 'Der er ingen redaktører.',
	'NO_NEW_MESSAGES'	=> 'Ingen nye beskeder',
	'NO_NEW_PM'	=> '<strong>0</strong> nye beskeder',
	'NO_NEW_POSTS'	=> 'Ingen nye indlæg', // Not used anymore
	'NO_ONLINE_USERS'			=> 'Ingen tilmeldte',
	'NO_POSTS'	=> 'Ingen indlæg',
	'NO_POSTS_TIME_FRAME'		=> 'Ingen indlæg eksisterer i dette emne inden for det valgte tidsinterval.',
	'NO_FEED_ENABLED'	=> 'Feeds er ikke tilgængelige på dette board.',
	'NO_FEED'			=> 'Forlangte feed er ikke tilgængelig.',
	'NO_SUBJECT'	=> 'Intet emne angivet.',// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'	=> 'Det angivne søgesystem findes ikke.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Ingen understøttede autentifikationsmetoder.',
	'NO_TOPIC'	=> 'Det valgte emne findes ikke.',
	'NO_TOPIC_FORUM'	=> 'Emnet eller forummet eksisterer ikke længere.',
	'NO_TOPICS'	=> 'Der er ingen emner eller indlæg i dette forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Ingen emner eksisterer i dette forum for det valgte tidsinterval.',
	'NO_UNREAD_PM'	=> '<strong>0</strong> ulæste beskeder',
	'NO_UNREAD_POSTS'      => 'Ingen ulæste indlæg',
	'NO_UPLOAD_FORM_FOUND'		=> 'Upload påbegyndt, men ingen gyldig filuploadformular fundet.',
	'NO_USER'	=> 'Den valgte bruger findes ikke.',
	'NO_USERS'	=> 'De valgte brugere findes ikke',
	'NO_USER_SPECIFIED'			=> 'Der var ikke angivet et brugernavn.',
	
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0										=> 'Ingen indlæg i kø',		// 0
		1										=> '1 indlæg i kø',				// 1
		2										=> '%d indlæg i kø',			// 2+
	),

	'OCCUPATION'	=> 'Beskæftigelse',
	'OFFLINE'	=> 'Offline',
	'ONLINE'	=> 'Online',
	'ONLINE_BUDDIES'	=> 'Online venner',
	'ONLINE_USERS_TOTAL'	=> 'Der er <strong>%d</strong> brugere online :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Der er <strong>0</strong> brugere online :: ',
	'ONLINE_USER_TOTAL'	=> 'Der er <strong>%d</strong> bruger online :: ',
	'OPTIONS'	=> 'Handling',

	'PAGE_OF'	=> 'Side <strong>%1$d</strong> af <strong>%2$d</strong>',
	'PASSWORD'	=> 'Kodeord',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Afspil Quicktime-fil',
	'PM'	=> 'PB',
	'PM_REPORTED' => 'Klik for at se rapport',
	'POSTING_MESSAGE'	=> 'Skriver indlæg i %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Skriver privat besked',
	'POST'	=> 'Indlæg',
	'POST_ANNOUNCEMENT'	=> 'Bekendtgørelse',
	'POST_STICKY'	=> 'Opslag',
	'POSTED'	=> '',
	'POSTED_IN_FORUM'	=> 'i',
	'POSTED_ON_DATE'	=> 'skrevet',
	'POSTS'	=> 'Indlæg',
	'POSTS_UNAPPROVED'	=> 'Mindst et indlæg i dette emne er ikke blevet godkendt',
	'POST_BY_AUTHOR'	=> 'af',
	'POST_BY_FOE'	=> 'Dette indlæg blev skrevet af <strong>%1$s</strong> som i øjeblikket er på din ignorerliste. For at vise dette indlæg klik %2$sHER%3$s.',
	'POST_DAY'	=> '%.2f indlæg pr. dag',
	'POST_DETAILS'	=> 'Indlægsinformation',
	'POST_NEW_TOPIC'	=> 'Skriv nyt emne',
	'POST_PCT'	=> '%.2f%% af alle indlæg',
	'POST_PCT_ACTIVE'	=> '%.2f%% af brugers indlæg',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% af dine indlæg',
	'POST_REPLY'	=> 'Skriv et svar',
	'POST_REPORTED'	=> 'Klik for at se rapport',
	'POST_SUBJECT'	=> 'Titel',
	'POST_TIME'	=> 'Skrevet',
	'POST_TOPIC'	=> 'Skriv et nyt emne',
	'POST_UNAPPROVED'	=> 'Dette indlæg afventer godkendelse.',
	'PREVIEW'	=> 'Vis prøve',
	'PREVIOUS'	=> 'Foregående',// Used in pagination
	'PREVIOUS_STEP'	=> 'Foregående',
	'PRIVACY'	=> 'Fortrolighedserklæring',
	'PRIVATE_MESSAGE'	=> 'Privat besked',
	'PRIVATE_MESSAGES'	=> 'Private beskeder',
	'PRIVATE_MESSAGING'	=> 'Private beskeder',
	'PROFILE'	=> 'Brugerkontrolpanel',

	'READING_FORUM'	=> 'Læser emner i %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Læser global bekendtgørelse',
	'READING_LINK'	=> 'Følger forumlink %s',
	'READING_TOPIC'	=> 'Læser emne i %s',
	'READ_PROFILE'	=> 'Profil',
	'REASON'	=> 'Begrundelse',
	'RECORD_ONLINE_USERS'	=> 'Flest brugere online var <strong>%1$s</strong>, %2$s',
	'REDIRECT'	=> 'Viderestil',
	'REDIRECTS'	=> 'Viderestillinger',
	'REGISTER'	=> 'Tilmeld',
	'REGISTERED_USERS'	=> 'Tilmeldte brugere:',
	'REG_USERS_ONLINE'	=> 'Der er %d tilmeldte brugere og ',
	'REG_USERS_TOTAL'	=> '%d tilmeldte, ',
	'REG_USERS_TOTAL_AND'		=> '%d tilmeldte og ',
	'REG_USERS_ZERO_ONLINE'	=> 'Der er 0 tilmeldte brugere og ',
	'REG_USERS_ZERO_TOTAL'	=> '0 tilmeldte, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 tilmeldte og ',
	'REG_USER_ONLINE'	=> 'Der er %d tilmeldt bruger og ',
	'REG_USER_TOTAL'	=> '%d tilmeldt, ',
	'REG_USER_TOTAL_AND'	=> '%d tilmeldt og ',
	'REMOVE'	=> 'Fjern',
	'REMOVE_INSTALL'	=> 'Vær venlig at slette, flytte eller omdøbe mappen install før du går online med dit board. Så længe denne mappe er til stede, er kun administratorkontrolpanelet (ACP) tilgængeligt.',
	'REPLIES'	=> 'Svar',
	'REPLY_WITH_QUOTE'	=> 'Svar med citat',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Besvarer global bekendtgørelse',
	'REPLYING_MESSAGE'	=> 'Besvarer indlæg i %s',
	'REPORT_BY'	=> 'Rapport af',
	'REPORT_POST'	=> 'Rapporter dette indlæg',
	'REPORTING_POST'	=> 'rapporterer indlæg',
	'RESEND_ACTIVATION'	=> 'Gensend aktiveringsemail',
	'RESET'	=> 'Nulstil',
	'RESTORE_PERMISSIONS'	=> 'Genetabler tilladelser',
	'RETURN_INDEX'	=> '%sTilbage til boardindeks%s',
	'RETURN_FORUM'	=> '%sTilbage til senest besøgte forum%s',
	'RETURN_PAGE'	=> '%sTilbage til foregående side%s',
	'RETURN_TOPIC'	=> '%sTilbage til senest besøgte emne%s',
	'RETURN_TO'	=> 'Tilbage til',
	'FEED'				=> 'Feed',
	'FEED_NEWS'	=> 'Nyheder',
	'FEED_TOPICS_ACTIVE' => 'Aktive emner',
	'FEED_TOPICS_NEW' => 'Nye emner', 
	'RULES_ATTACH_CAN'	=> 'Du <strong>kan</strong> vedhæfte filer',
	'RULES_ATTACH_CANNOT'	=> 'Du <strong>kan ikke</strong> vedhæfte filer',
	'RULES_DELETE_CAN'	=> 'Du <strong>kan</strong> slette dine indlæg',
	'RULES_DELETE_CANNOT'	=> 'Du <strong>kan ikke</strong> slette dine indlæg',
	'RULES_DOWNLOAD_CAN'	=> 'Du <strong>kan</strong> downloade vedhæftede filer',
	'RULES_DOWNLOAD_CANNOT'	=> 'Du <strong>kan ikke</strong> downloade vedhæftede filer',
	'RULES_EDIT_CAN'	=> 'Du <strong>kan</strong> redigere dine indlæg',
	'RULES_EDIT_CANNOT'	=> 'Du <strong>kan ikke</strong> redigere dine indlæg',
	'RULES_LOCK_CAN'	=> 'Du <strong>kan</strong> låse dine emner',
	'RULES_LOCK_CANNOT'	=> 'Du <strong>kan ikke</strong> låse dine emner',
	'RULES_POST_CAN'	=> 'Du <strong>kan</strong> skrive nye emner',
	'RULES_POST_CANNOT'	=> 'Du <strong>kan ikke</strong> skrive nye emner',
	'RULES_REPLY_CAN'	=> 'Du <strong>kan</strong> besvare emner',
	'RULES_REPLY_CANNOT'	=> 'Du <strong>kan ikke</strong> besvare emner',
	'RULES_VOTE_CAN'	=> 'Du <strong>kan</strong> stemme i afstemninger',
	'RULES_VOTE_CANNOT'	=> 'Du <strong>kan ikke</strong> stemme i afstemninger',

	'SEARCH'	=> 'Søg',
	'SEARCH_MINI'	=> 'Søg…',
	'SEARCH_ADV'	=> 'Avanceret søgning',
	'SEARCH_ADV_EXPLAIN'	=> 'Vis avancerede søgemuligheder',
	'SEARCH_KEYWORDS'	=> 'Søg efter nøgleord',
	'SEARCHING_FORUMS'	=> 'Søger fora',
	'SEARCH_ACTIVE_TOPICS'	=> 'Vis aktive emner',
	'SEARCH_FOR'	=> 'Søg efter',
	'SEARCH_FORUM'				=> 'Søg i dette forum...',
	'SEARCH_NEW'	=> 'Vis nye indlæg',
	'SEARCH_POSTS_BY'			=> 'Søg indlæg af',
	'SEARCH_SELF'	=> 'Vis dine indlæg',
	'SEARCH_TOPIC'				=> 'Søg i dette emne...',
	'SEARCH_UNANSWERED'	=> 'Vis ubesvarede indlæg',
	'SEARCH_UNREAD'			=> 'Vis ulæste indlæg',
	'SEARCH_USER_POSTS'		=> 'Vis brugers indlæg',
	'SECONDS'	=> 'sekunder',
	'SELECT'	=> 'Vælg',
	'SELECT_ALL_CODE'	=> 'Vælg alt',
	'SELECT_DESTINATION_FORUM'	=> 'Vælg venligst et destinationsforum',
	'SELECT_FORUM'	=> 'Vælg et forum',
	'SEND_EMAIL'	=> 'Send email', // Used for submit buttons
	'SEND_EMAIL_USER'	=> 'Email', // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'	=> 'Send privat besked',
	'SETTINGS'	=> 'Opsætning',
	'SIGNATURE'	=> 'Signatur',
	'SKIP'	=> 'Spring til indhold',
	'SMTP_NO_AUTH_SUPPORT'	=> 'SMTP-serveren understøtter ikke denne type autentifikation',
	'SORRY_AUTH_READ'	=> 'Du har ikke tilladelser til at læse dette forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Du har ikke tilladelser til at downloade denne vedhæftede fil.',
	'SORT_BY'	=> 'Sorter efter',
	'SORT_JOINED'	=> 'Tilmeldingsdato',
	'SORT_LOCATION'	=> 'Geografisk sted',
	'SORT_RANK'	=> 'Rang',
	'SORT_POSTS'			=> 'Indlæg',
	'SORT_TOPIC_TITLE'	=> 'Emnetitel',
	'SORT_USERNAME'	=> 'Brugernavn',
	'SPLIT_TOPIC'	=> 'Opdel emne',
	'SQL_ERROR_OCCURRED'	=> 'Der optrådte en SQL-fejl ved læsning af denne side. Kontakt venligst %sboardadministrator%s hvis problemet fortsætter.',
	'STATISTICS'	=> 'Statistikker',
	'START_WATCHING_FORUM'	=> 'Overvåg forum',
	'START_WATCHING_TOPIC'	=> 'Overvåg emne',
	'STOP_WATCHING_FORUM'	=> 'Stop overvågning af forum',
	'STOP_WATCHING_TOPIC'	=> 'Stop overvågning af emne',
	'SUBFORUM'	=> 'Underforum',
	'SUBFORUMS'	=> 'Underfora',
	'SUBJECT'	=> 'Emne',
	'SUBMIT'	=> 'Udfør',

	'TERMS_USE'	=> 'Betingelser for brug',
	'TEST_CONNECTION'	=> 'Test forbindelse',
	'THE_TEAM'	=> 'Holdet',
	'TIME'	=> 'Tid',

	'TOO_LARGE'										=> 'Den indtastede værdi er for stor.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Du indtastede et for højt antal i indstillingen af <strong>Maximalt antal tilladte modtagere af private beskeder</strong>.',

	'TOO_LONG'			=> 'Den indtastede værdi er for lang.',

	'TOO_LONG_AIM'	=> 'Det indtastede skærmnavn er for langt.',
	'TOO_LONG_CONFIRM_CODE'	=> 'Den indtastede bekræftelseskode er for lang.',
	'TOO_LONG_DATEFORMAT'	=> 'Det indtastede datoformat er for langt.',
	'TOO_LONG_ICQ'	=> 'Det indtastede ICQ-nummer er for langt.',
	'TOO_LONG_INTERESTS'	=> 'Det angivne om interesser er for langt.',
	'TOO_LONG_JABBER'	=> 'Det angivne Jabberkontonavn er for langt.',
	'TOO_LONG_LOCATION'	=> 'Det angivne geografiske sted er for langt.',
	'TOO_LONG_MSN'	=> 'Det angivne MSN/WLM-navn er for langt.',
	'TOO_LONG_NEW_PASSWORD'	=> 'Det indtastede kodeord er for langt.',
	'TOO_LONG_OCCUPATION'	=> 'Den angivne beskæftigelse er for lang.',
	'TOO_LONG_PASSWORD_CONFIRM'	=> 'Den indtastede bekræftelse af kodeord er for lang.',
	'TOO_LONG_USER_PASSWORD'	=> 'Det indtastede kodeord er for langt.',
	'TOO_LONG_USERNAME'	=> 'Det indtastede brugernavn er for langt.',
	'TOO_LONG_EMAIL'	=> 'Den indtastede emailadresse er for lang.',
	'TOO_LONG_EMAIL_CONFIRM'	=> 'Den indtastede bekræftelse af emailadresse er for lang.',
	'TOO_LONG_WEBSITE'	=> 'Den angivne adresse på hjemmeside er for lang.',
	'TOO_LONG_YIM'	=> 'Det angivne Yahoo! Messengernavn er for langt.',

	'TOO_MANY_VOTE_OPTIONS'	=> 'Du har forsøgt at stemme på for mange muligheder.',

	'TOO_SHORT'						=> 'Den indtastede værdi er for kort.',

	'TOO_SHORT_AIM'	=> 'Det indtastede skærmnavn er for kort.',
	'TOO_SHORT_CONFIRM_CODE'	=> 'Den indtastede bekræftelseskode er for kort.',
	'TOO_SHORT_DATEFORMAT'		=> 'Det indtastede datoformat er for kort.',
	'TOO_SHORT_ICQ'	=> 'Det indtastede ICQ-nummer er for kort.',
	'TOO_SHORT_INTERESTS'	=> 'Det angivne om interesser er for kort.',
	'TOO_SHORT_JABBER'	=> 'Det angivne Jabberkontonavn er for kort.',
	'TOO_SHORT_LOCATION'	=> 'Det angivne geografiske sted er for kort.',
	'TOO_SHORT_MSN'	=> 'Det angivne MSN/WLM-navn er for kort.',
	'TOO_SHORT_NEW_PASSWORD'	=> 'Det indtastede kodeord er for kort.',
	'TOO_SHORT_OCCUPATION'	=> 'Den angivne beskæftigelse er for kort.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Den indtastede bekræftelse af kodeord er for kort.',
	'TOO_SHORT_USER_PASSWORD'	=> 'Det indtastede kodeord er for kort.',
	'TOO_SHORT_USERNAME'	=> 'Det indtastede brugernavn er for kort.',
	'TOO_SHORT_EMAIL'	=> 'Den indtastede emailadresse er for kort.',
	'TOO_SHORT_EMAIL_CONFIRM'	=> 'Den indtastede bekræftelse af emailadresse er for kort.',
	'TOO_SHORT_WEBSITE'	=> 'Den angivne adresse på hjemmeside er for kort.',
	'TOO_SHORT_YIM'	=> 'Det angivne Yahoo! Messengernavn er for kort.',

	'TOO_SMALL'						=> 'Den indtastede værdi er for lille.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Du indtastede et for lavt antal i indstillingen af <strong>Maximalt antal tilladte modtagere af private beskeder</strong>.',

	'TOPIC'	=> 'Emne',
	'TOPICS'	=> 'Emner',
	'TOPICS_UNAPPROVED'	=> 'Mindst et emne i forummet er ikke godkendt.',
	'TOPIC_ICON'	=> 'Emneikon',
	'TOPIC_LOCKED'	=> 'Dette emne er låst, du kan ikke redigere indlæg eller skrive yderligere indlæg.',
	'TOPIC_LOCKED_SHORT'=>	'Emne låst',
	'TOPIC_MOVED'	=> 'Flyttet emne',
	'TOPIC_REVIEW'	=> 'Emnegennemgang',
	'TOPIC_TITLE'	=> 'Emnetitel',
	'TOPIC_UNAPPROVED'	=> 'Dette emne er ikke godkendt.',
	'TOTAL_ATTACHMENTS'	=> 'Vedhæftede filer',
	'TOTAL_LOG'	=> '1 logtekst',
	'TOTAL_LOGS'	=> '%d logtekster',
	'TOTAL_NO_PM'	=> 'Ingen private beskeder',
	'TOTAL_PM'	=> '1 privat besked',
	'TOTAL_PMS'	=> '%d private beskeder',
	'TOTAL_POSTS'	=> 'Indlæg',
	'TOTAL_POSTS_OTHER'	=> 'Indlæg <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Indlæg <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Dette emne er blevet rapporteret.',
	'TOTAL_TOPICS_OTHER'	=> 'Emner <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Emner <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Tilmeldte brugere <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Tilmeldte brugere <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Sporede PHP-fejl: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Det var ikke muligt at fastslå billedets dimensioner.',
	'UNABLE_TO_DELIVER_FILE'=> 'Kunne ikke aflevere fil.',
	'UNKNOWN_BROWSER'	=> 'Ukendt browser',
	'UNMARK_ALL'	=> 'Fravælg alle',
	'UNREAD_MESSAGES'	=> 'Ulæste beskeder',
	'UNREAD_PM'	=> '<strong>%d</strong> ulæst besked',
	'UNREAD_PMS'	=> '<strong>%d</strong> ulæste beskeder',
	'UNREAD_POST'      => 'Ulæst indlæg',
	'UNREAD_POSTS'      => 'Ulæste indlæg',
	'UNWATCH_FORUM_CONFIRM'    => 'Er du sikker på at du vil stoppe overvågning af dette forum?',
	'UNWATCH_FORUM_DETAILED'  => 'Er du sikker på at du vil stoppe overvågning af forummet "%s"?',
	'UNWATCH_TOPIC_CONFIRM'    => 'Er du sikker på at du vil stoppe overvågning af dette emne?',
	'UNWATCH_TOPIC_DETAILED'  => 'Er du sikker på at du vil stoppe overvågning af emnet "%s"?',
	'UNWATCHED_FORUMS'	=> 'Du overvåger ikke længere de valgte fora.',
	'UNWATCHED_TOPICS'	=> 'Du overvåger ikke længere de valgte emner.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Du overvåger ikke længere de valgte fora og emner.',
	'UPDATE'	=> 'Opdater',
	'UPLOAD_IN_PROGRESS'	=> 'Upload er i gang.',
	'URL_REDIRECT'	=> 'Hvis din browser ikke understøtter metahenvisninger %skan du klikke HER for at blive viderestillet%s.',
	'USERGROUPS'	=> 'Grupper',
	'USERNAME'	=> 'Brugernavn',
	'USERNAMES'	=> 'Brugernavne',
	'USER_AVATAR'			=> 'Brugeravatar',
	'USER_CANNOT_READ'	=> 'Du kan ikke læse indlæg i dette forum.',
	'USER_POST'	=> '%d indlæg',
	'USER_POSTS'	=> '%d indlæg',
	'USERS'	=> 'Brugere',
	'USE_PERMISSIONS'	=> 'Afprøv tilladelser',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Vi beklager, men du kan ikke bruge denne mulighed. For at anvende den skal du være tilmeldt og deltage mere aktivt.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ', // Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'	=> 'Læst',
	'VIEWING_FAQ'	=> 'Læser OSS',
	'VIEWING_MEMBERS'	=> 'Læser oplysning om bruger',
	'VIEWING_ONLINE'	=> 'Læser hvem der er online',
	'VIEWING_MCP'		=> 'Læser redaktørkontrolpanel',
	'VIEWING_MEMBER_PROFILE'	=> 'Læser brugerprofil',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Læser private beskeder',
	'VIEWING_REGISTER'	=> 'Læser tilmeldte brugere',
	'VIEWING_UCP'	=> 'Læser brugerkontrolpanel',
	'VIEWS'	=> 'Visninger',
	'VIEW_BOOKMARKS'	=> 'Vis bogmærker',
	'VIEW_FORUM_LOGS'	=> 'Logtekst',
	'VIEW_LATEST_POST'	=> 'Vis det seneste indlæg',
	'VIEW_NEWEST_POST'	=> 'Vis første ulæste indlæg',
	'VIEW_NOTES'	=> 'Vis brugernotater',
	'VIEW_ONLINE_TIME'	=> 'baseret på det seneste %d minuts aktivitet',
	'VIEW_ONLINE_TIMES'	=> 'baseret på de seneste %d minutters aktivitet',
	'VIEW_TOPIC'	=> 'Vis emne',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Bekendtgørelse: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Global bekendtgørelse: ',
	'VIEW_TOPIC_LOCKED'	=> 'Låst: ',
	'VIEW_TOPIC_LOGS'	=> 'Logtekst',
	'VIEW_TOPIC_MOVED'	=> 'Flyttet: ',
	'VIEW_TOPIC_POLL'	=> 'Afstemning: ',
	'VIEW_TOPIC_STICKY'	=> 'Opslag: ',
	'VISIT_WEBSITE'				=> 'Besøg hjemmeside',

	'WARNINGS'	=> 'Advarsler',
	'WARN_USER'	=> 'Advar bruger',
	'WATCH_FORUM_CONFIRM'  => 'Er du sikker på at du ønsker at overvåge dette forum?',
	'WATCH_FORUM_DETAILED'  => 'Er dy sikker på at du ønsker at overvåge forummet "%s"?',
	'WATCH_TOPIC_CONFIRM'  => 'Er du sikker på at du ønsker at overvåge dette emne?',
	'WATCH_TOPIC_DETAILED'  => 'Er du sikker på at du ønsker at overvåge emnet "%s"?',
	'WELCOME_SUBJECT'	=> 'Velkommen til %s',
	'WEBSITE'	=> 'Hjemmeside',
	'WHOIS'	=> 'Whois',
	'WHO_IS_ONLINE'	=> 'Hvem er online',
	'WRONG_PASSWORD'	=> 'Du indtastede et forkert kodeord.',

	'WRONG_DATA_ICQ'	=> 'Det indtastede nummer er ikke et gyldigt ICQ-nummer.',
	'WRONG_DATA_JABBER'	=> 'Det indtastede navn er ikke et gyldigt Jabberkontonavn.',
	'WRONG_DATA_LANG'	=> 'Det valgte sprog er ikke gyldigt.',
	'WRONG_DATA_WEBSITE'	=> 'Adressen på hjemmesiden skal være en gyldig URL, inklusiv protokol. For eksempel http://www.eksempel.com/.',
	'WROTE'				=> 'skrev',

	'YEAR'	=> 'År',
	'YEAR_MONTH_DAY'	=> '(ÅÅÅÅ-MM-DD)',
	'YES'	=> 'Ja',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'Seneste besøg: %s',
	'YOU_NEW_PM'	=> 'En ny privat besked venter på dig i din indbakke.',
	'YOU_NEW_PMS'	=> 'Nye private beskeder venter på dig i din indbakke.',
	'YOU_NO_NEW_PM'	=> 'Der er ingen nye private beskeder.',

	'datetime'	=> array(
		'TODAY'	=> 'i dag',
		'TOMORROW'	=> 'i morgen',
		'YESTERDAY'	=> 'i går',
		'AGO'			=> array(
			0			=> 'det seneste minut',
			1			=> 'for %d minut siden',
			2			=> 'for %d minutter siden',
			60		=> 'for 1 time siden',
		),

		'Sunday'	=> 'søndag',
		'Monday'	=> 'mandag',
		'Tuesday'	=> 'tirsdag',
		'Wednesday'	=> 'onsdag',
		'Thursday'	=> 'torsdag',
		'Friday'	=> 'fredag',
		'Saturday'	=> 'lørdag',

		'Sun'	=> 'søn',
		'Mon'	=> 'man',
		'Tue'	=> 'tirs',
		'Wed'	=> 'ons',
		'Thu'	=> 'tors',
		'Fri'	=> 'fre',
		'Sat'	=> 'lør',

		'January'	=> 'januar',
		'February'	=> 'februar',
		'March'	=> 'marts',
		'April'	=> 'april',
		'May'	=> 'maj',
		'June'	=> 'juni',
		'July'	=> 'juli',
		'August'	=> 'august',
		'September'	=> 'september',
		'October'	=> 'oktober',
		'November'	=> 'november',
		'December'	=> 'december',

		'Jan'	=> 'jan',
		'Feb'	=> 'feb',
		'Mar'	=> 'mar',
		'Apr'	=> 'apr',
		'May_short'	=> 'maj',
		'Jun'	=> 'jun',
		'Jul'	=> 'jul',
		'Aug'	=> 'aug',
		'Sep'	=> 'sep',
		'Oct'	=> 'okt',
		'Nov'	=> 'nov',
		'Dec'	=> 'dec',
	),

	'tz'	=> array(
		'-12'	=> 'UTC - 12 timer',
		'-11'	=> 'UTC - 11 timer',
		'-10'	=> 'UTC - 10 timer',
		'-9.5'	=> 'UTC - 9:30 timer',
		'-9'	=> 'UTC - 9 timer',
		'-8'	=> 'UTC - 8 timer',
		'-7'	=> 'UTC - 7 timer',
		'-6'	=> 'UTC - 6 timer',
		'-5'	=> 'UTC - 5 timer',
		'-4.5'	=> 'UTC - 4:30 timer',
		'-4'	=> 'UTC - 4 timer',
		'-3.5'	=> 'UTC - 3:30 timer',
		'-3'	=> 'UTC - 3 timer',
		'-2'	=> 'UTC - 2 timer',
		'-1'	=> 'UTC - 1 time',
		'0'	=> 'UTC',
		'1'	=> 'UTC + 1  time',
		'2'	=> 'UTC + 2  timer',
		'3'	=> 'UTC + 3  timer',
		'3.5'	=> 'UTC + 3:30  timer',
		'4'	=> 'UTC + 4  timer',
		'4.5'	=> 'UTC + 4:30  timer',
		'5'	=> 'UTC + 5  timer',
		'5.5'	=> 'UTC + 5:30  timer',
		'5.75'	=> 'UTC + 5:45  timer',
		'6'	=> 'UTC + 6  timer',
		'6.5'	=> 'UTC + 6:30  timer',
		'7'	=> 'UTC + 7  timer',
		'8'	=> 'UTC + 8  timer',
		'8.75'	=> 'UTC + 8:45  timer',
		'9'	=> 'UTC + 9  timer',
		'9.5'	=> 'UTC + 9:30  timer',
		'10'	=> 'UTC + 10  timer',
		'10.5'	=> 'UTC + 10:30  timer',
		'11'	=> 'UTC + 11  timer',
		'11.5'	=> 'UTC + 11:30  timer',
		'12'	=> 'UTC + 12  timer',
		'12.75'	=> 'UTC + 12:45  timer',
		'13'	=> 'UTC + 13  timer',
		'14'	=> 'UTC + 14  timer',
		'dst'	=> '[<abbr title="Sommertid">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Howard- & Baker-øerne',
		'-11'	=> '[UTC - 11] Midway-øerne',
		'-10'	=> '[UTC - 10] Hawaii, Cook-øerne',
		'-9.5'	=> '[UTC - 9:30] Fransk Polynesien',
		'-9'	=> '[UTC - 9] Alaska, Gambier-øerne',
		'-8'	=> '[UTC - 8] Stillehavstid (San Francisco m.fl)',
		'-7'	=> '[UTC - 7] Bjergtid (Salt Lake City m.fl)',
		'-6'	=> '[UTC - 6] Centraltid (Houston, Chicago m.fl)',
		'-5'	=> '[UTC - 5] Østkysttid (New York m.fl)',
		'-4.5'	=> '[UTC - 4:30] Venezuela',
		'-4'	=> '[UTC - 4] Atlanterhavstid (Thule Air Base m.fl)',
		'-3.5'	=> '[UTC - 3:30] Newfoundland',
		'-3'	=> '[UTC - 3] Amazontid, Vestgrønland',
		'-2'	=> '[UTC - 2] Fernando de Noronha & Sydlige Sandwich-øer',
		'-1'	=> '[UTC - 1] Azorerne, Østgrønland',
		'0'	=> '[UTC] Vesteuropa (England, Færøerne m.fl)',
		'1'	=> '[UTC + 1] Centraleuropa & Vestafrika (Danmark m.fl)',
		'2'	=> '[UTC + 2] Østeuropa & Centralafrika',
		'3'	=> '[UTC + 3] Moskva & Østafrika',
		'3.5'	=> '[UTC + 3:30] Iran',
		'4'	=> '[UTC + 4] Golfen & Samara',
		'4.5'	=> '[UTC + 4:30] Afghanistan',
		'5'	=> '[UTC + 5] Vestasien & Jekaterinburg',
		'5.5'	=> '[UTC + 5:30] Indien',
		'5.75'	=> '[UTC + 5:45] Nepal',
		'6'	=> '[UTC + 6] Bangladesh, Bhutan & Omsk',
		'6.5'	=> '[UTC + 6:30] Burma & Coco-øerne',
		'7'	=> '[UTC + 7] Indonesien, Krasnoyarsk',
		'8'	=> '[UTC + 8] Kina, Vestaustralien & Irkutsk',
		'8.75'	=> '[UTC + 8:45] Central vestaustralien',
		'9'	=> '[UTC + 9] Japan, Korea & Yakutsk',
		'9.5'	=> '[UTC + 9:30] Central Australien',
		'10'	=> '[UTC + 10] Østaustralien & Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe',
		'11'	=> '[UTC + 11] Solomon-øerne & Magadan',
		'11.5'	=> '[UTC + 11:30] Norfolk-øerne',
		'12'	=> '[UTC + 12] New Zealand & Kamchatka',
		'12.75'	=> '[UTC + 12:45] Chatham-øerne',
		'13'	=> '[UTC + 13] Tonga & Føniks-øerne',
		'14'	=> '[UTC + 14] Linie-øerne',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'j. M Y, H:i'	=> '1. jan 2007, 13:37',
		'D j. M Y H:i'	=> 'man 1. jan 2007 13:37',
		'd M Y H:i'		=> '01 jan 2007 13:37',
		'|j. M Y| H:i'		=> 'I dag 13:37 / 1. jan 2007 13:37',
		'|j/m/Y| H:i'		=> 'I dag 13:37 / 01/01/2007 13:37',
		'j/m/Y H:i'		=> '01/01/2007 13:37',
		'|Y-m-j| H:i'		=> 'I dag 13:37 / 2007-01-01, 13:37',
		'Y-m-j H:i'		=> '2007-01-01 13:37',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> '|D j. M Y| H:i',
));

?>