--TEST--
maxdb_fetch_object
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 smallint,
                                                     c2 smallint,
                                                     c3 smallint,
                                                     c4 smallint,
                                                     c5 smallint,
                                                     c6 smallint,
                                                     c7 smallint)");

	$stmt = maxdb_prepare($link, "INSERT INTO test_bind_fetch VALUES (?,?,?,?,?,?,?)");
	maxdb_bind_param($stmt, "iiiiiii", $c1,$c2,$c3,$c4,$c5,$c6,$c7);

	$c1 = -23;
	$c2 = 3599;
	$c3 = NULL;
	$c4 = -500;
	$c5 = -9999;
	$c6 = -0;
	$c7 = 0;

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$result = maxdb_query($link, "SELECT * FROM test_bind_fetch");
	$test = maxdb_fetch_object($result);
	maxdb_free_result($result);

	var_dump($test);

	maxdb_close($link);
?>
--EXPECTF--
%s
  ["C1"]=>
  int(-23)
  ["C2"]=>
  int(3599)
  ["C3"]=>
  NULL
  ["C4"]=>
  int(-500)
  ["C5"]=>
  int(-9999)
  ["C6"]=>
  int(0)
  ["C7"]=>
  int(0)
}
