<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.6 $
 *
 *  ABOUT
 *  -----
 *
 *  A class for Kolab shared folder management.
 *
 */

/** The basic Kolab object definition */
require_once('Kolab/Webadmin/object.php');

/**
 * This class provides methods to deal with shared folders
 * entries for Kolab.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/sharedfolder.class.php,v 1.6 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen <steffen@klaralvdalens-datakonsult.se>
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Webadmin
 */
class KolabSharedFolder extends KolabObject {

    /**
     * The LDAP filter to retrieve this object type
     *
     * @var string
     */
    var $filter = '(objectclass=kolabSharedFolder)';

    /**
     * Sort using this attribute by default
     *
     * @var string
     */
    var $sort = KOLAB_ATTR_CN;

    /**
     * The LDAP attributes fetched for listing
     *
     * @var array
     */
    var $list_attributes = array(
        KOLAB_ATTR_CN,
        KOLAB_ATTR_DELETED,
        'kolabFolderType',
    );

    /**
     * The attributes supported by this class
     *
     * @var array
     */
    var $_supported_attributes = array(
        KOLAB_ATTR_CN,
        KOLAB_ATTR_DELETED,
    );

    /**
     * Get the folder type
     *
     * @return string The type of this shared folder
     */
    function getType()
    {
        if (!$this->_cache) {
            $this->read();
        }
        $type = '';
        if (isset($this->_cache['kolabFolderType'])) {
            $type = $this->_cache['kolabFolderType'][0];
        }

        $type_map = array(''        => 'Unspecified', 
                          'mail'    => 'Mails', 
                          'task'    => 'Tasks', 
                          'journal' => 'Journals',
                          'event'   => 'Events', 
                          'contact' => 'Contacts', 
                          'note'    => 'Notes');
        
        if (isset($type_map[$type])) {
            return _($type_map[$type]);
        } else {
            return _($type_map['']);
        }
    }

    function deleteSharedFolder($dn, $delete_now = false) 
    {
        return $this->_doDeleteObject($dn, $delete_now, false);
    }
}

class KolabSharedFolderListView extends KolabObjectListView {

    /**
     * Return a list title for this type of object
     *
     * @return 
     */
    function getTitle()
    {
        return _("Shared folders");
    }

    /**
     * Return an array of table header entries for this type of object
     *
     * @return array The header entries
     */
    function _getHeader()
    {
        return array(_("Name"), _("Server"), _("Type"));
    }
    
    /**
     * Return an array of table row entries for this type of object
     *
     * @return array The row entries
     */
    function _getRow()
    {
        return array($this->_object->getName(),
					 $this->_object->getServer(),
					 $this->_object->getType());
    }
    
}

/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
  vim:encoding=utf-8:
 */
?>
