<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.2 $
 *
 *  ABOUT
 *  -----
 *
 *  Debugging functions.
 *
 */

// Generate OpenLDAP style SSHA password strings
function ssha($string, $salt)
{
  return "{SSHA}" . base64_encode(pack("H*", sha1($string . $salt)) . $salt);
}

// return 4 random bytes
function gensalt()
{
  $salt = '';
  while (strlen($salt) < 4)
    $salt = $salt . chr(mt_rand(0,255));
  return $salt;
}

//FIXME: won't work
// Check that passwords from form input match
function checkpw( $form, $key, $value, $action ) {
  if( $action == 'firstsave' ) {
    if( $key == 'password_0' ) {
      if( $value == '' ) return _('Password is empty');
    } else if( $key == 'password_1' ) {
      if( $value != $_POST['password_0'] ) {
        return _('Passwords dont match');
      }
    }
  } else {
    if( $value != $_POST['password_0'] ) {
      return _('Passwords dont match');
    }
  }
  return '';
}

?>