<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.5 $
 *
 *  ABOUT
 *  -----
 *
 *  A class for Kolab group (distribution list) management.
 *
 */

/** The basic Kolab object definition */
require_once('Kolab/Webadmin/object.php');

/**
 * This class provides methods to deal with groups for Kolab.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/group.class.php,v 1.5 2007/08/22 13:25:00 gunnar Exp $
 *
 * @author  Steffen Hansen <steffen@klaralvdalens-datakonsult.se>
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Webadmin
 */
class KolabGroup extends KolabObject {

    /**
     * The LDAP filter to retrieve this object type
     *
     * @var string
     */
    var $filter = '(&(!(cn=domains))(objectclass=kolabGroupOfNames))';

    /**
     * Sort using this attribute by default
     *
     * @var string
     */
    var $sort = KOLAB_ATTR_CN;

    /**
     * The LDAP attributes fetched for listing
     *
     * @var array
     */
    var $list_attributes = array(
        KOLAB_ATTR_CN,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
    );

    /**
     * The attributes supported by this class
     *
     * @var array
     */
    var $_supported_attributes = array(
        KOLAB_ATTR_CN,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
    );

    /**
     * Is this an internal group?
     *
     * @return boolean True if this is an internal group
     */
    function getInternal()
    {
        return (strpos($this->_dn, 'cn=internal') !== false);
    }


    function exists_group($group) {
        $filter = '(&(objectClass=kolabGroupOfNames)(mail='.$this->escape($group).'))';
        $res = $this->search($this->_base_dn, $filter, array('dn'));
        return ($this->count($res) > 0);
    }

    // Get members of a group as an array of DNs
    function groupMembers($base, $group) {
        $privmembers = array();
        $mybase = 'cn='.$group.','.$base;
        $filter = '(objectClass=kolabGroupOfNames)';
        $res = ldap_search($this->_ldap, $mybase, $filter, array('member'));
        if (!$res) {
            array_push($this->errors, _("LDAP Error: Can't read maintainers group: ")
                       .ldap_error($conn));   
            return array();
        }
        $entries = ldap_get_entries($this->_ldap, $res);
        foreach($entries as $key=>$val) {
            if ($key === 'count') {
                // Do nothing
            } else if (is_array($val) && is_array($val['member'])) {
                foreach($val['member'] as $member) {
                    $privmembers[$member] = true;
                }
            }
        }
        ldap_free_result($res);
        return $privmembers;
    }

    function deleteGroupOfNames($dn, $delete_now = false) {
        return $this->_doDeleteObject($dn, $delete_now, false);
    }

};

/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
  vim:encoding=utf-8:
 */
?>
