<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.9 $
 *
 *  ABOUT
 *  -----
 *
 *  A Kolab Server filter for incoming mails that are parsed for iCal
 *  contents.
 *
 */

/* Load the basic filter definition */
require_once 'Kolab/Filter/Filter.php';

class Filter_Incoming extends Filter
{

    var $_add_headers;

    function Filter_Incoming($transport = 'LMTP', $debug = false)
    {
        Filter::Filter($transport, $debug);
    }

    function _parse($inh = STDIN)
    {
        $ical = false;
        $add_headers = array();
        $headers_done = false;

        /* High speed section START */
        $headers_done = false;
        while (!feof($inh) && !$headers_done) {
            $buffer = fgets($inh, 8192);
            $line = rtrim( $buffer, "\r\n");
            if ($line == '') {
                /* Done with headers */
                $headers_done = true;
            } else if (eregi('^Content-Type: text/calendar', $line)) {
                Horde::logMessage(_("Found iCal data in message"), 
                                  __FILE__, __LINE__, PEAR_LOG_DEBUG);
                $ical = true;
            } else if (eregi('^Message-ID: (.*)', $line, $regs)) {
                $this->_id = $regs[1];
            }
            if (@fwrite($this->_tmpfh, $buffer) === false) {
                $msg = $php_errormsg;
                return PEAR::raiseError(sprintf(_("Error: Could not write to %s: %s"),
                                                $this->_tmpfile, $msg),
                                        OUT_LOG | EX_TEMPFAIL);
            }
        }

        if ($ical) {
            /* iCal already identified. So let's just pipe the rest of
             * the message through.
             */
            while (!feof($inh)) {
                $buffer = fread($inh, 8192);
                if (@fwrite($this->_tmpfh, $buffer) === false) {
                    $msg = $php_errormsg;
                    return PEAR::raiseError(sprintf(_("Error: Could not write to %s: %s"),
                                                    $this->_tmpfile, $msg),
                                            OUT_LOG | EX_TEMPFAIL);
                }
            }
        } else {
            /* No ical yet? Let's try to identify the string
             * "text/calendar". It's likely that we have a mime
             * multipart message including iCal then.
             */
            while (!feof($inh)) {
                $buffer = fread($inh, 8192);
                if (@fwrite($this->_tmpfh, $buffer) === false) {
                    $msg = $php_errormsg;
                    return PEAR::raiseError(sprintf(_("Error: Could not write to %s: %s"),
                                                    $this->_tmpfile, $msg),
                                            OUT_LOG | EX_TEMPFAIL);
                }
                if (strpos($buffer, 'text/calendar')) {
                    $ical = true;
                }
            }
        }
        /* High speed section END */
        

        if (@fclose($this->_tmpfh) === false) {
            $msg = $php_errormsg;
            return PEAR::raiseError(sprintf(_("Error: Failed closing %s: %s"),
                                            $this->_tmpfile, $msg),
                                    OUT_LOG | EX_TEMPFAIL);
        }

        if ($ical) {
            require_once 'Kolab/Filter/Resource.php';
            $newrecips = array();
            foreach ($this->_recipients as $recip) {
                Horde::logMessage(sprintf(_("Calling resmgr_filter(%s, %s, %s, %s)"),
                                          $this->_fqhostname, $this->_sender,
                                          $recip, $this->_tmpfile), __FILE__, __LINE__,
                                  PEAR_LOG_DEBUG);
                $rc = resmgr_filter($this->_fqhostname, $this->_sender, $recip,
                                    $this->_tmpfile);

                if ($rc instanceof PEAR_Error) {
                    return $rc;
                } else if ($rc === true) {
                    $newrecips[] = $recip;
                }
            }
            $this->_recipients = $newrecips;
            $this->_add_headers[] = "X-Kolab-Scheduling-Message: TRUE";
        } else {
            $this->_add_headers[] = "X-Kolab-Scheduling-Message: FALSE";
        }

        /* Check if we still have recipients */
        if (empty($this->_recipients)) {
            Horde::logMessage(_("No recipients left."), 
                              __FILE__, __LINE__, PEAR_LOG_DEBUG);
            return;
        } else {
            $result = $this->deliver();
            if ($result instanceof PEAR_Error) {
                return $result;
            }
        }
        
        Horde::logMessage(_("Filter_Incoming successfully completed."), 
                          __FILE__, __LINE__, PEAR_LOG_DEBUG);
    }

    function deliver()
    {
        global $conf;

        if (isset($conf['filter']['lmtp_host'])) {
            $host = $conf['filter']['lmtp_host'];
        } else {
            $host = 'localhost';
        }
        if (isset($conf['filter']['lmtp_port'])) {
            $port = $conf['filter']['lmtp_port'];
        } else {
            $port = 2003;
        }

        $transport = $this->_getTransport($host, $port);

        $tmpf = @fopen($this->_tmpfile, 'r');
        if (!$tmpf) {
            $msg = $php_errormsg;
            return PEAR::raiseError(sprintf(_("Error: Could not open %s for writing: %s"),
                                            $this->_tmpfile, $msg),
                                    OUT_LOG | EX_TEMPFAIL);
        }

        $result = $transport->start($this->_sender, $this->_recipients);
        if ($result instanceof PEAR_Error) {
            return $this->_rewriteCode($result);
        }
        
        $headers_done = false;
        while (!feof($tmpf) && !$headers_done) {
            $buffer = fgets($tmpf, 8192);
            if (!$headers_done && rtrim($buffer, "\r\n") == '') {
                $headers_done = true;
                foreach ($this->_add_headers as $h) {
                    $result = $transport->data("$h\r\n");
                    if ($result instanceof PEAR_Error) {
                        return $this->_rewriteCode($result);
                    }
                }
            }
            $result = $transport->data($buffer);
            if ($result instanceof PEAR_Error) {
                return $this->_rewriteCode($result);
            }
        }

        while (!feof($tmpf)) {
            $buffer = fread($tmpf, 8192);
            $len = strlen($buffer);
            
            /* We can't tolerate that the buffer breaks the data
             * between \r and \n, so we try to avoid that. The limit
             * of 100 reads is to battle abuse
             */
            while ($buffer{$len-1} == "\r" && $len < 8192 + 100) {
                $buffer .= fread($tmpf, 1);
                $len++;
            }
            $result = $transport->data($buffer);
            if ($result instanceof PEAR_Error) {
                return $this->_rewriteCode($result);
            }
        }
        return $transport->end();
    }
}
?>
