--TEST--
Inline charset test
--FILE--
<?php

require_once __DIR__ . '/common.php';
$ical = new Horde_Icalendar();

$data = 'BEGIN:VCALENDAR
VERSION:1.0
BEGIN:VEVENT
SUMMARY;ENCODING=QUOTED-PRINTABLE;CHARSET=UTF-8:m=C3=B6chen
DTSTART:20040628T080000Z
DTEND:20040628T090000Z
X-EPOCAGENDAENTRYTYPE:APPOINTMENT
CLASS:PUBLIC
DCREATED:20040627T220000Z
LAST-MODIFIED:20040628T175300Z
PRIORITY:0
STATUS:NEEDS ACTION
END:VEVENT
END:VCALENDAR';

$ical->parseVCalendar($data);
$event = $ical->getComponent(0);
var_dump($event->getAttribute('SUMMARY'));

$data = 'BEGIN:VCALENDAR
VERSION:1.0
BEGIN:VEVENT
SUMMARY;ENCODING=QUOTED-PRINTABLE:m=C3=B6chen
DTSTART:20040628T080000Z
DTEND:20040628T090000Z
X-EPOCAGENDAENTRYTYPE:APPOINTMENT
CLASS:PUBLIC
DCREATED:20040627T220000Z
LAST-MODIFIED:20040628T175300Z
PRIORITY:0
STATUS:NEEDS ACTION
END:VEVENT
END:VCALENDAR';

$ical->parseVCalendar($data, 'VCALENDAR');
$event = $ical->getComponent(0);
var_dump($event->getAttribute('SUMMARY'));

?>
--EXPECT--
string(7) "möchen"
string(7) "möchen"
