/*

  OpenLayers.js -- OpenLayers Map Viewer Library

  Copyright 2005-2011 OpenLayers Contributors, released under the FreeBSD
  license. Please see http://svn.openlayers.org/trunk/openlayers/license.txt
  for the full text of the license.

  Includes compressed code under the following licenses:

  (For uncompressed versions of the code used please see the
  OpenLayers SVN repository: <http://openlayers.org/>)

*/

/* Contains portions of Prototype.js:
 *
 * Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
 *--------------------------------------------------------------------------*/

/**
*
*  Contains portions of Rico <http://openrico.org/>
*
*  Copyright 2005 Sabre Airline Solutions
*
*  Licensed under the Apache License, Version 2.0 (the "License"); you
*  may not use this file except in compliance with the License. You
*  may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
*  implied. See the License for the specific language governing
*  permissions and limitations under the License.
*
**/

/**
 * Contains XMLHttpRequest.js <http://code.google.com/p/xmlhttprequest/>
 * Copyright 2007 Sergey Ilinsky (http://www.ilinsky.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 */

/**
 * Contains portions of Gears <http://code.google.com/apis/gears/>
 *
 * Copyright 2007, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. Neither the name of Google Inc. nor the names of its contributors may be
 *     used to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sets up google.gears.*, which is *the only* supported way to access Gears.
 *
 * Circumvent this file at your own risk!
 *
 * In the future, Gears may automatically define google.gears.* without this
 * file. Gears may use these objects to transparently fix bugs and compatibility
 * issues. Applications that use the code below will continue to work seamlessly
 * when that happens.
 */

/**
 * OpenLayers.Util.pagePosition is based on Yahoo's getXY method, which is
 * Copyright (c) 2006, Yahoo! Inc.
 * All rights reserved.
 *
 * Redistribution and use of this software in source and binary forms, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 *
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of Yahoo! Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission of Yahoo! Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */var OpenLayers={VERSION_NUMBER:"Release 2.11",singleFile:!0,_getScriptLocation:function(){for(var a=/(^|(.*?\/))(OpenLayers.js)(\?|$)/,b=document.getElementsByTagName("script"),c,d="",e=0,f=b.length;e<f;e++)if(c=b[e].getAttribute("src"))if(c=c.match(a)){d=c[1];break}return function(){return d}}()};
(function(){var a=typeof OpenLayers=="object"&&OpenLayers.singleFile,b=!a?"lib/OpenLayers.js":"OpenLayers.js",c=window.OpenLayers;window.OpenLayers={_getScriptLocation:function(){for(var a=RegExp("(^|(.*?\\/))("+b+")(\\?|$)"),c=document.getElementsByTagName("script"),d,e="",f=0,o=c.length;f<o;f++)if(d=c[f].getAttribute("src"))if(d=d.match(a)){e=d[1];break}return function(){return e}}()};if(!a){c||(c="OpenLayers/BaseTypes/Class.js,OpenLayers/Util.js,OpenLayers/BaseTypes.js,OpenLayers/BaseTypes/Bounds.js,OpenLayers/BaseTypes/Date.js,OpenLayers/BaseTypes/Element.js,OpenLayers/BaseTypes/LonLat.js,OpenLayers/BaseTypes/Pixel.js,OpenLayers/BaseTypes/Size.js,OpenLayers/Console.js,OpenLayers/Tween.js,OpenLayers/Kinetic.js,Rico/Corner.js,Rico/Color.js,OpenLayers/Ajax.js,OpenLayers/Events.js,OpenLayers/Request.js,OpenLayers/Request/XMLHttpRequest.js,OpenLayers/Projection.js,OpenLayers/Map.js,OpenLayers/Layer.js,OpenLayers/Icon.js,OpenLayers/Marker.js,OpenLayers/Marker/Box.js,OpenLayers/Popup.js,OpenLayers/Tile.js,OpenLayers/Tile/Image.js,OpenLayers/Tile/Image/IFrame.js,OpenLayers/Tile/WFS.js,OpenLayers/Layer/Image.js,OpenLayers/Layer/SphericalMercator.js,OpenLayers/Layer/EventPane.js,OpenLayers/Layer/FixedZoomLevels.js,OpenLayers/Layer/Google.js,OpenLayers/Layer/Google/v3.js,OpenLayers/Layer/VirtualEarth.js,OpenLayers/Layer/Yahoo.js,OpenLayers/Layer/HTTPRequest.js,OpenLayers/Layer/Grid.js,OpenLayers/Layer/MapGuide.js,OpenLayers/Layer/MapServer.js,OpenLayers/Layer/MapServer/Untiled.js,OpenLayers/Layer/KaMap.js,OpenLayers/Layer/KaMapCache.js,OpenLayers/Layer/MultiMap.js,OpenLayers/Layer/Markers.js,OpenLayers/Layer/Text.js,OpenLayers/Layer/WorldWind.js,OpenLayers/Layer/ArcGIS93Rest.js,OpenLayers/Layer/WMS.js,OpenLayers/Layer/WMS/Untiled.js,OpenLayers/Layer/WMS/Post.js,OpenLayers/Layer/WMTS.js,OpenLayers/Layer/ArcIMS.js,OpenLayers/Layer/GeoRSS.js,OpenLayers/Layer/Boxes.js,OpenLayers/Layer/XYZ.js,OpenLayers/Layer/Bing.js,OpenLayers/Layer/TMS.js,OpenLayers/Layer/TileCache.js,OpenLayers/Layer/Zoomify.js,OpenLayers/Layer/ArcGISCache.js,OpenLayers/Popup/Anchored.js,OpenLayers/Popup/AnchoredBubble.js,OpenLayers/Popup/Framed.js,OpenLayers/Popup/FramedCloud.js,OpenLayers/Feature.js,OpenLayers/Feature/Vector.js,OpenLayers/Feature/WFS.js,OpenLayers/Handler.js,OpenLayers/Handler/Click.js,OpenLayers/Handler/Hover.js,OpenLayers/Handler/Point.js,OpenLayers/Handler/Path.js,OpenLayers/Handler/Polygon.js,OpenLayers/Handler/Feature.js,OpenLayers/Handler/Drag.js,OpenLayers/Handler/Pinch.js,OpenLayers/Handler/RegularPolygon.js,OpenLayers/Handler/Box.js,OpenLayers/Handler/MouseWheel.js,OpenLayers/Handler/Keyboard.js,OpenLayers/Control.js,OpenLayers/Control/Attribution.js,OpenLayers/Control/Button.js,OpenLayers/Control/ZoomBox.js,OpenLayers/Control/ZoomToMaxExtent.js,OpenLayers/Control/DragPan.js,OpenLayers/Control/Navigation.js,OpenLayers/Control/PinchZoom.js,OpenLayers/Control/TouchNavigation.js,OpenLayers/Control/MouseDefaults.js,OpenLayers/Control/MousePosition.js,OpenLayers/Control/OverviewMap.js,OpenLayers/Control/KeyboardDefaults.js,OpenLayers/Control/PanZoom.js,OpenLayers/Control/PanZoomBar.js,OpenLayers/Control/ArgParser.js,OpenLayers/Control/Permalink.js,OpenLayers/Control/Scale.js,OpenLayers/Control/ScaleLine.js,OpenLayers/Control/Snapping.js,OpenLayers/Control/Split.js,OpenLayers/Control/LayerSwitcher.js,OpenLayers/Control/DrawFeature.js,OpenLayers/Control/DragFeature.js,OpenLayers/Control/ModifyFeature.js,OpenLayers/Control/Panel.js,OpenLayers/Control/SelectFeature.js,OpenLayers/Control/NavigationHistory.js,OpenLayers/Control/Measure.js,OpenLayers/Control/WMSGetFeatureInfo.js,OpenLayers/Control/WMTSGetFeatureInfo.js,OpenLayers/Control/Graticule.js,OpenLayers/Control/TransformFeature.js,OpenLayers/Control/SLDSelect.js,OpenLayers/Geometry.js,OpenLayers/Geometry/Rectangle.js,OpenLayers/Geometry/Collection.js,OpenLayers/Geometry/Point.js,OpenLayers/Geometry/MultiPoint.js,OpenLayers/Geometry/Curve.js,OpenLayers/Geometry/LineString.js,OpenLayers/Geometry/LinearRing.js,OpenLayers/Geometry/Polygon.js,OpenLayers/Geometry/MultiLineString.js,OpenLayers/Geometry/MultiPolygon.js,OpenLayers/Geometry/Surface.js,OpenLayers/Renderer.js,OpenLayers/Renderer/Elements.js,OpenLayers/Renderer/NG.js,OpenLayers/Renderer/SVG.js,OpenLayers/Renderer/SVG2.js,OpenLayers/Renderer/Canvas.js,OpenLayers/Renderer/VML.js,OpenLayers/Layer/Vector.js,OpenLayers/Layer/PointGrid.js,OpenLayers/Layer/Vector/RootContainer.js,OpenLayers/Strategy.js,OpenLayers/Strategy/Filter.js,OpenLayers/Strategy/Fixed.js,OpenLayers/Strategy/Cluster.js,OpenLayers/Strategy/Paging.js,OpenLayers/Strategy/BBOX.js,OpenLayers/Strategy/Save.js,OpenLayers/Strategy/Refresh.js,OpenLayers/Filter.js,OpenLayers/Filter/FeatureId.js,OpenLayers/Filter/Logical.js,OpenLayers/Filter/Comparison.js,OpenLayers/Filter/Spatial.js,OpenLayers/Filter/Function.js,OpenLayers/Protocol.js,OpenLayers/Protocol/HTTP.js,OpenLayers/Protocol/SQL.js,OpenLayers/Protocol/SQL/Gears.js,OpenLayers/Protocol/WFS.js,OpenLayers/Protocol/WFS/v1.js,OpenLayers/Protocol/WFS/v1_0_0.js,OpenLayers/Protocol/WFS/v1_1_0.js,OpenLayers/Protocol/Script.js,OpenLayers/Protocol/SOS.js,OpenLayers/Protocol/SOS/v1_0_0.js,OpenLayers/Layer/PointTrack.js,OpenLayers/Layer/GML.js,OpenLayers/Style.js,OpenLayers/Style2.js,OpenLayers/StyleMap.js,OpenLayers/Rule.js,OpenLayers/Format.js,OpenLayers/Format/QueryStringFilter.js,OpenLayers/Format/XML.js,OpenLayers/Format/XML/VersionedOGC.js,OpenLayers/Format/Context.js,OpenLayers/Format/ArcXML.js,OpenLayers/Format/ArcXML/Features.js,OpenLayers/Format/GML.js,OpenLayers/Format/GML/Base.js,OpenLayers/Format/GML/v2.js,OpenLayers/Format/GML/v3.js,OpenLayers/Format/Atom.js,OpenLayers/Format/KML.js,OpenLayers/Format/GeoRSS.js,OpenLayers/Format/WFS.js,OpenLayers/Format/WFSCapabilities.js,OpenLayers/Format/WFSCapabilities/v1.js,OpenLayers/Format/WFSCapabilities/v1_0_0.js,OpenLayers/Format/WFSCapabilities/v1_1_0.js,OpenLayers/Format/WFSDescribeFeatureType.js,OpenLayers/Format/WMSDescribeLayer.js,OpenLayers/Format/WMSDescribeLayer/v1_1.js,OpenLayers/Format/WKT.js,OpenLayers/Format/CQL.js,OpenLayers/Format/OSM.js,OpenLayers/Format/GPX.js,OpenLayers/Format/Filter.js,OpenLayers/Format/Filter/v1.js,OpenLayers/Format/Filter/v1_0_0.js,OpenLayers/Format/Filter/v1_1_0.js,OpenLayers/Format/SLD.js,OpenLayers/Format/SLD/v1.js,OpenLayers/Format/SLD/v1_0_0.js,OpenLayers/Format/OWSCommon.js,OpenLayers/Format/OWSCommon/v1.js,OpenLayers/Format/OWSCommon/v1_0_0.js,OpenLayers/Format/OWSCommon/v1_1_0.js,OpenLayers/Format/CSWGetDomain.js,OpenLayers/Format/CSWGetDomain/v2_0_2.js,OpenLayers/Format/CSWGetRecords.js,OpenLayers/Format/CSWGetRecords/v2_0_2.js,OpenLayers/Format/WFST.js,OpenLayers/Format/WFST/v1.js,OpenLayers/Format/WFST/v1_0_0.js,OpenLayers/Format/WFST/v1_1_0.js,OpenLayers/Format/Text.js,OpenLayers/Format/JSON.js,OpenLayers/Format/GeoJSON.js,OpenLayers/Format/WMC.js,OpenLayers/Format/WMC/v1.js,OpenLayers/Format/WMC/v1_0_0.js,OpenLayers/Format/WMC/v1_1_0.js,OpenLayers/Format/WCSGetCoverage.js,OpenLayers/Format/WMSCapabilities.js,OpenLayers/Format/WMSCapabilities/v1.js,OpenLayers/Format/WMSCapabilities/v1_1.js,OpenLayers/Format/WMSCapabilities/v1_1_0.js,OpenLayers/Format/WMSCapabilities/v1_1_1.js,OpenLayers/Format/WMSCapabilities/v1_3.js,OpenLayers/Format/WMSCapabilities/v1_3_0.js,OpenLayers/Format/WMSCapabilities/v1_1_1_WMSC.js,OpenLayers/Format/WMSGetFeatureInfo.js,OpenLayers/Format/SOSCapabilities.js,OpenLayers/Format/SOSCapabilities/v1_0_0.js,OpenLayers/Format/SOSGetFeatureOfInterest.js,OpenLayers/Format/SOSGetObservation.js,OpenLayers/Format/OWSContext.js,OpenLayers/Format/OWSContext/v0_3_1.js,OpenLayers/Format/WMTSCapabilities.js,OpenLayers/Format/WMTSCapabilities/v1_0_0.js,OpenLayers/Format/WPSCapabilities.js,OpenLayers/Format/WPSCapabilities/v1_0_0.js,OpenLayers/Format/WPSDescribeProcess.js,OpenLayers/Format/WPSExecute.js,OpenLayers/Format/XLS.js,OpenLayers/Format/XLS/v1.js,OpenLayers/Format/XLS/v1_1_0.js,OpenLayers/Format/OGCExceptionReport.js,OpenLayers/Layer/WFS.js,OpenLayers/Control/GetFeature.js,OpenLayers/Control/MouseToolbar.js,OpenLayers/Control/NavToolbar.js,OpenLayers/Control/PanPanel.js,OpenLayers/Control/Pan.js,OpenLayers/Control/ZoomIn.js,OpenLayers/Control/ZoomOut.js,OpenLayers/Control/ZoomPanel.js,OpenLayers/Control/EditingToolbar.js,OpenLayers/Control/Geolocate.js,OpenLayers/Symbolizer.js,OpenLayers/Symbolizer/Point.js,OpenLayers/Symbolizer/Line.js,OpenLayers/Symbolizer/Polygon.js,OpenLayers/Symbolizer/Text.js,OpenLayers/Symbolizer/Raster.js,OpenLayers/Lang.js,OpenLayers/Lang/en.js".split(","));
for(var a=Array(c.length),d=OpenLayers._getScriptLocation()+"lib/",e=0,f=c.length;e<f;e++)a[e]="<script src='"+d+c[e]+"'><\/script>";a.length>0&&document.write(a.join(""))}})();OpenLayers.VERSION_NUMBER="Release 2.11";
OpenLayers.String={startsWith:function(a,b){return a.indexOf(b)==0},contains:function(a,b){return a.indexOf(b)!=-1},trim:function(a){return a.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},camelize:function(a){for(var a=a.split("-"),b=a[0],c=1,d=a.length;c<d;c++){var e=a[c];b+=e.charAt(0).toUpperCase()+e.substring(1)}return b},format:function(a,b,c){b||(b=window);return a.replace(OpenLayers.String.tokenRegEx,function(a,e){for(var f,g=e.split(/\.+/),h=0;h<g.length;h++)h==0&&(f=b),f=f[g[h]];typeof f=="function"&&
(f=c?f.apply(null,c):f());return typeof f=="undefined"?"undefined":f})},tokenRegEx:/\$\{([\w.]+?)\}/g,numberRegEx:/^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,isNumeric:function(a){return OpenLayers.String.numberRegEx.test(a)},numericIf:function(a){return OpenLayers.String.isNumeric(a)?parseFloat(a):a}};
if(!String.prototype.startsWith)String.prototype.startsWith=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.startsWith"}));return OpenLayers.String.startsWith(this,a)};if(!String.prototype.contains)String.prototype.contains=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.contains"}));return OpenLayers.String.contains(this,a)};
if(!String.prototype.trim)String.prototype.trim=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.trim"}));return OpenLayers.String.trim(this)};if(!String.prototype.camelize)String.prototype.camelize=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.String.camelize"}));return OpenLayers.String.camelize(this)};
OpenLayers.Number={decimalSeparator:".",thousandsSeparator:",",limitSigDigs:function(a,b){var c=0;b>0&&(c=parseFloat(a.toPrecision(b)));return c},format:function(a,b,c,d){b=typeof b!="undefined"?b:0;c=typeof c!="undefined"?c:OpenLayers.Number.thousandsSeparator;d=typeof d!="undefined"?d:OpenLayers.Number.decimalSeparator;b!=null&&(a=parseFloat(a.toFixed(b)));var e=a.toString().split(".");e.length==1&&b==null&&(b=0);a=e[0];if(c)for(var f=/(-?[0-9]+)([0-9]{3})/;f.test(a);)a=a.replace(f,"$1"+c+"$2");
b==0?b=a:(c=e.length>1?e[1]:"0",b!=null&&(c+=Array(b-c.length+1).join("0")),b=a+d+c);return b}};if(!Number.prototype.limitSigDigs)Number.prototype.limitSigDigs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Number.limitSigDigs"}));return OpenLayers.Number.limitSigDigs(this,a)};
OpenLayers.Function={bind:function(a,b){var c=Array.prototype.slice.apply(arguments,[2]);return function(){var d=c.concat(Array.prototype.slice.apply(arguments,[0]));return a.apply(b,d)}},bindAsEventListener:function(a,b){return function(c){return a.call(b,c||window.event)}},False:function(){return!1},True:function(){return!0},Void:function(){}};
if(!Function.prototype.bind)Function.prototype.bind=function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bind"}));Array.prototype.unshift.apply(arguments,[this]);return OpenLayers.Function.bind.apply(null,arguments)};
if(!Function.prototype.bindAsEventListener)Function.prototype.bindAsEventListener=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Function.bindAsEventListener"}));return OpenLayers.Function.bindAsEventListener(this,a)};OpenLayers.Array={filter:function(a,b,c){var d=[];if(Array.prototype.filter)d=a.filter(b,c);else{var e=a.length;if(typeof b!="function")throw new TypeError;for(var f=0;f<e;f++)if(f in a){var g=a[f];b.call(c,g,f,a)&&d.push(g)}}return d}};
OpenLayers.Class=function(){var a=arguments.length,b=arguments[0],c=arguments[a-1],d=typeof c.initialize=="function"?c.initialize:function(){b.prototype.initialize.apply(this,arguments)};a>1?(a=[d,b].concat(Array.prototype.slice.call(arguments).slice(1,a-1),c),OpenLayers.inherit.apply(null,a)):d.prototype=c;return d};OpenLayers.Class.isPrototype=function(){};OpenLayers.Class.create=function(){return function(){arguments&&arguments[0]!=OpenLayers.Class.isPrototype&&this.initialize.apply(this,arguments)}};
OpenLayers.Class.inherit=function(a){var b=function(){a.call(this)},c=[b].concat(Array.prototype.slice.call(arguments));OpenLayers.inherit.apply(null,c);return b.prototype};OpenLayers.inherit=function(a,b){var c=function(){};c.prototype=b.prototype;a.prototype=new c;var d,e;for(c=2,d=arguments.length;c<d;c++){e=arguments[c];if(typeof e==="function")e=e.prototype;OpenLayers.Util.extend(a.prototype,e)}};OpenLayers.Util=OpenLayers.Util||{};
OpenLayers.Util.extend=function(a,b){a=a||{};if(b){for(var c in b){var d=b[c];d!==void 0&&(a[c]=d)}if(!(typeof window.Event=="function"&&b instanceof window.Event)&&b.hasOwnProperty&&b.hasOwnProperty("toString"))a.toString=b.toString}return a};OpenLayers.Util=OpenLayers.Util||{};OpenLayers.Util.getElement=function(){for(var a=[],b=0,c=arguments.length;b<c;b++){var d=arguments[b];typeof d=="string"&&(d=document.getElementById(d));if(arguments.length==1)return d;a.push(d)}return a};
OpenLayers.Util.isElement=function(a){return!!(a&&a.nodeType===1)};OpenLayers.Util.isArray=function(a){return Object.prototype.toString.call(a)==="[object Array]"};if(typeof window.$==="undefined")window.$=OpenLayers.Util.getElement;OpenLayers.Util.removeItem=function(a,b){for(var c=a.length-1;c>=0;c--)a[c]==b&&a.splice(c,1);return a};OpenLayers.Util.clearArray=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"array = []"}));a.length=0};
OpenLayers.Util.indexOf=function(a,b){if(typeof a.indexOf=="function")return a.indexOf(b);else{for(var c=0,d=a.length;c<d;c++)if(a[c]==b)return c;return-1}};
OpenLayers.Util.modifyDOMElement=function(a,b,c,d,e,f,g,h){if(b)a.id=b;if(c)a.style.left=c.x+"px",a.style.top=c.y+"px";if(d)a.style.width=d.w+"px",a.style.height=d.h+"px";if(e)a.style.position=e;if(f)a.style.border=f;if(g)a.style.overflow=g;if(parseFloat(h)>=0&&parseFloat(h)<1)a.style.filter="alpha(opacity="+h*100+")",a.style.opacity=h;else if(parseFloat(h)==1)a.style.filter="",a.style.opacity=""};
OpenLayers.Util.createDiv=function(a,b,c,d,e,f,g,h){var i=document.createElement("div");if(d)i.style.backgroundImage="url("+d+")";a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="absolute");OpenLayers.Util.modifyDOMElement(i,a,b,c,e,f,g,h);return i};
OpenLayers.Util.createImage=function(a,b,c,d,e,f,g,h){var i=document.createElement("img");a||(a=OpenLayers.Util.createUniqueID("OpenLayersDiv"));e||(e="relative");OpenLayers.Util.modifyDOMElement(i,a,b,c,e,f,null,g);if(h)i.style.display="none",OpenLayers.Event.observe(i,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,i)),OpenLayers.Event.observe(i,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,i));i.style.alt=a;i.galleryImg="no";if(d)i.src=d;return i};
OpenLayers.Util.setOpacity=function(a,b){OpenLayers.Util.modifyDOMElement(a,null,null,null,null,null,null,b)};OpenLayers.Util.onImageLoad=function(){if(!this.viewRequestID||this.map&&this.viewRequestID==this.map.viewRequestID)this.style.display="";OpenLayers.Element.removeClass(this,"olImageLoadError")};OpenLayers.IMAGE_RELOAD_ATTEMPTS=0;
OpenLayers.Util.onImageLoadError=function(){this._attempts=this._attempts?this._attempts+1:1;if(this._attempts<=OpenLayers.IMAGE_RELOAD_ATTEMPTS){var a=this.urls;if(a&&OpenLayers.Util.isArray(a)&&a.length>1){var b=this.src.toString(),c,d;for(d=0;c=a[d];d++)if(b.indexOf(c)!=-1)break;var e=Math.floor(a.length*Math.random()),e=a[e];for(d=0;e==c&&d++<4;)e=Math.floor(a.length*Math.random()),e=a[e];this.src=b.replace(c,e)}else this.src=this.src}else OpenLayers.Element.addClass(this,"olImageLoadError");
this.style.display=""};OpenLayers.Util.alphaHackNeeded=null;OpenLayers.Util.alphaHack=function(){if(OpenLayers.Util.alphaHackNeeded==null){var a=navigator.appVersion.split("MSIE"),a=parseFloat(a[1]),b=!1;try{b=!!document.body.filters}catch(c){}OpenLayers.Util.alphaHackNeeded=b&&a>=5.5&&a<7}return OpenLayers.Util.alphaHackNeeded};
OpenLayers.Util.modifyAlphaImageDiv=function(a,b,c,d,e,f,g,h,i){OpenLayers.Util.modifyDOMElement(a,b,c,d,f,null,null,i);b=a.childNodes[0];if(e)b.src=e;OpenLayers.Util.modifyDOMElement(b,a.id+"_innerImage",null,d,"relative",g);if(OpenLayers.Util.alphaHack()){if(a.style.display!="none")a.style.display="inline-block";h==null&&(h="scale");a.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+b.src+"', sizingMethod='"+h+"')";parseFloat(a.style.opacity)>=0&&parseFloat(a.style.opacity)<
1&&(a.style.filter+=" alpha(opacity="+a.style.opacity*100+")");b.style.filter="alpha(opacity=0)"}};
OpenLayers.Util.createAlphaImageDiv=function(a,b,c,d,e,f,g,h,i){var j=OpenLayers.Util.createDiv(),k=OpenLayers.Util.createImage(null,null,null,null,null,null,null,!1);j.appendChild(k);if(i)k.style.display="none",OpenLayers.Event.observe(k,"load",OpenLayers.Function.bind(OpenLayers.Util.onImageLoad,j)),OpenLayers.Event.observe(k,"error",OpenLayers.Function.bind(OpenLayers.Util.onImageLoadError,j));OpenLayers.Util.modifyAlphaImageDiv(j,a,b,c,d,e,f,g,h);return j};
OpenLayers.Util.upperCaseObject=function(a){var b={},c;for(c in a)b[c.toUpperCase()]=a[c];return b};OpenLayers.Util.applyDefaults=function(a,b){var a=a||{},c=typeof window.Event=="function"&&b instanceof window.Event,d;for(d in b)if(a[d]===void 0||!c&&b.hasOwnProperty&&b.hasOwnProperty(d)&&!a.hasOwnProperty(d))a[d]=b[d];if(!c&&b&&b.hasOwnProperty&&b.hasOwnProperty("toString")&&!a.hasOwnProperty("toString"))a.toString=b.toString;return a};
OpenLayers.Util.getParameterString=function(a){var b=[],c;for(c in a){var d=a[c];if(d!=null&&typeof d!="function"){if(typeof d=="object"&&d.constructor==Array){for(var e=[],f,g=0,h=d.length;g<h;g++)f=d[g],e.push(encodeURIComponent(f===null||f===void 0?"":f));d=e.join(",")}else d=encodeURIComponent(d);b.push(encodeURIComponent(c)+"="+d)}}return b.join("&")};OpenLayers.Util.urlAppend=function(a,b){var c=a;if(b){var d=(a+" ").split(/[?&]/);c+=d.pop()===" "?b:d.length?"&"+b:"?"+b}return c};
OpenLayers.ImgPath="";OpenLayers.Util.getImagesLocation=function(){return OpenLayers.ImgPath||OpenLayers._getScriptLocation()+"img/"};OpenLayers.Util.Try=function(){for(var a=null,b=0,c=arguments.length;b<c;b++){var d=arguments[b];try{a=d();break}catch(e){}}return a};OpenLayers.Util.getXmlNodeValue=function(a){var b=null;OpenLayers.Util.Try(function(){b=a.text;if(!b)b=a.textContent;if(!b)b=a.firstChild.nodeValue},function(){b=a.textContent});return b};
OpenLayers.Util.mouseLeft=function(a,b){for(var c=a.relatedTarget?a.relatedTarget:a.toElement;c!=b&&c!=null;)c=c.parentNode;return c!=b};OpenLayers.Util.DEFAULT_PRECISION=14;OpenLayers.Util.toFloat=function(a,b){if(b==null)b=OpenLayers.Util.DEFAULT_PRECISION;typeof a!=="number"&&(a=parseFloat(a));return b===0?a:parseFloat(a.toPrecision(b))};OpenLayers.Util.rad=function(a){return a*Math.PI/180};OpenLayers.Util.deg=function(a){return a*180/Math.PI};
OpenLayers.Util.VincentyConstants={a:6378137,b:6356752.3142,f:1/298.257223563};
OpenLayers.Util.distVincenty=function(a,b){for(var c=OpenLayers.Util.VincentyConstants,d=c.a,e=c.b,c=c.f,f=OpenLayers.Util.rad(b.lon-a.lon),g=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(a.lat))),h=Math.atan((1-c)*Math.tan(OpenLayers.Util.rad(b.lat))),i=Math.sin(g),g=Math.cos(g),j=Math.sin(h),h=Math.cos(h),k=f,o=2*Math.PI,n=20;Math.abs(k-o)>1.0E-12&&--n>0;){var l=Math.sin(k),m=Math.cos(k),q=Math.sqrt(h*l*h*l+(g*j-i*h*m)*(g*j-i*h*m));if(q==0)return 0;var m=i*j+g*h*m,p=Math.atan2(q,m),r=Math.asin(g*
h*l/q),s=Math.cos(r)*Math.cos(r),l=m-2*i*j/s,t=c/16*s*(4+c*(4-3*s)),o=k,k=f+(1-t)*c*Math.sin(r)*(p+t*q*(l+t*m*(-1+2*l*l)))}if(n==0)return NaN;d=s*(d*d-e*e)/(e*e);c=d/1024*(256+d*(-128+d*(74-47*d)));return(e*(1+d/16384*(4096+d*(-768+d*(320-175*d))))*(p-c*q*(l+c/4*(m*(-1+2*l*l)-c/6*l*(-3+4*q*q)*(-3+4*l*l))))).toFixed(3)/1E3};
OpenLayers.Util.destinationVincenty=function(a,b,c){for(var d=OpenLayers.Util,e=d.VincentyConstants,f=e.a,g=e.b,h=e.f,e=a.lon,a=a.lat,i=d.rad(b),b=Math.sin(i),i=Math.cos(i),a=(1-h)*Math.tan(d.rad(a)),j=1/Math.sqrt(1+a*a),k=a*j,o=Math.atan2(a,i),a=j*b,n=1-a*a,f=n*(f*f-g*g)/(g*g),l=1+f/16384*(4096+f*(-768+f*(320-175*f))),m=f/1024*(256+f*(-128+f*(74-47*f))),f=c/(g*l),q=2*Math.PI;Math.abs(f-q)>1.0E-12;)var p=Math.cos(2*o+f),r=Math.sin(f),s=Math.cos(f),t=m*r*(p+m/4*(s*(-1+2*p*p)-m/6*p*(-3+4*r*r)*(-3+4*
p*p))),q=f,f=c/(g*l)+t;c=k*r-j*s*i;g=Math.atan2(k*s+j*r*i,(1-h)*Math.sqrt(a*a+c*c));b=Math.atan2(r*b,j*s-k*r*i);i=h/16*n*(4+h*(4-3*n));p=b-(1-i)*h*a*(f+i*r*(p+i*s*(-1+2*p*p)));Math.atan2(a,-c);return new OpenLayers.LonLat(e+d.deg(p),d.deg(g))};
OpenLayers.Util.getParameters=function(a){var a=a===null||a===void 0?window.location.href:a,b="";if(OpenLayers.String.contains(a,"?"))var b=a.indexOf("?")+1,c=OpenLayers.String.contains(a,"#")?a.indexOf("#"):a.length,b=a.substring(b,c);for(var a={},b=b.split(/[&;]/),c=0,d=b.length;c<d;++c){var e=b[c].split("=");if(e[0]){var f=e[0];try{f=decodeURIComponent(f)}catch(g){f=unescape(f)}e=(e[1]||"").replace(/\+/g," ");try{e=decodeURIComponent(e)}catch(h){e=unescape(e)}e=e.split(",");e.length==1&&(e=e[0]);
a[f]=e}}return a};OpenLayers.Util.getArgs=function(a){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"OpenLayers.Util.getParameters"}));return OpenLayers.Util.getParameters(a)};OpenLayers.Util.lastSeqID=0;OpenLayers.Util.createUniqueID=function(a){a==null&&(a="id_");OpenLayers.Util.lastSeqID+=1;return a+OpenLayers.Util.lastSeqID};OpenLayers.INCHES_PER_UNIT={inches:1,ft:12,mi:63360,m:39.3701,km:39370.1,dd:4374754,yd:36};OpenLayers.INCHES_PER_UNIT["in"]=OpenLayers.INCHES_PER_UNIT.inches;
OpenLayers.INCHES_PER_UNIT.degrees=OpenLayers.INCHES_PER_UNIT.dd;OpenLayers.INCHES_PER_UNIT.nmi=1852*OpenLayers.INCHES_PER_UNIT.m;OpenLayers.METERS_PER_INCH=0.0254000508001016;
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{Inch:OpenLayers.INCHES_PER_UNIT.inches,Meter:1/OpenLayers.METERS_PER_INCH,Foot:0.3048006096012192/OpenLayers.METERS_PER_INCH,IFoot:0.3048/OpenLayers.METERS_PER_INCH,ClarkeFoot:0.3047972651151/OpenLayers.METERS_PER_INCH,SearsFoot:0.30479947153867626/OpenLayers.METERS_PER_INCH,GoldCoastFoot:0.3047997101815088/OpenLayers.METERS_PER_INCH,IInch:0.0254/OpenLayers.METERS_PER_INCH,MicroInch:2.54E-5/OpenLayers.METERS_PER_INCH,Mil:2.54E-8/OpenLayers.METERS_PER_INCH,
Centimeter:0.01/OpenLayers.METERS_PER_INCH,Kilometer:1E3/OpenLayers.METERS_PER_INCH,Yard:0.9144018288036576/OpenLayers.METERS_PER_INCH,SearsYard:0.914398414616029/OpenLayers.METERS_PER_INCH,IndianYard:0.9143985307444408/OpenLayers.METERS_PER_INCH,IndianYd37:0.91439523/OpenLayers.METERS_PER_INCH,IndianYd62:0.9143988/OpenLayers.METERS_PER_INCH,IndianYd75:0.9143985/OpenLayers.METERS_PER_INCH,IndianFoot:0.30479951/OpenLayers.METERS_PER_INCH,IndianFt37:0.30479841/OpenLayers.METERS_PER_INCH,IndianFt62:0.3047996/
OpenLayers.METERS_PER_INCH,IndianFt75:0.3047995/OpenLayers.METERS_PER_INCH,Mile:1609.3472186944373/OpenLayers.METERS_PER_INCH,IYard:0.9144/OpenLayers.METERS_PER_INCH,IMile:1609.344/OpenLayers.METERS_PER_INCH,NautM:1852/OpenLayers.METERS_PER_INCH,"Lat-66":110943.31648893273/OpenLayers.METERS_PER_INCH,"Lat-83":110946.25736872235/OpenLayers.METERS_PER_INCH,Decimeter:0.1/OpenLayers.METERS_PER_INCH,Millimeter:0.0010/OpenLayers.METERS_PER_INCH,Dekameter:10/OpenLayers.METERS_PER_INCH,Decameter:10/OpenLayers.METERS_PER_INCH,
Hectometer:100/OpenLayers.METERS_PER_INCH,GermanMeter:1.0000135965/OpenLayers.METERS_PER_INCH,CaGrid:0.999738/OpenLayers.METERS_PER_INCH,ClarkeChain:20.1166194976/OpenLayers.METERS_PER_INCH,GunterChain:20.11684023368047/OpenLayers.METERS_PER_INCH,BenoitChain:20.116782494375872/OpenLayers.METERS_PER_INCH,SearsChain:20.11676512155/OpenLayers.METERS_PER_INCH,ClarkeLink:0.201166194976/OpenLayers.METERS_PER_INCH,GunterLink:0.2011684023368047/OpenLayers.METERS_PER_INCH,BenoitLink:0.20116782494375873/OpenLayers.METERS_PER_INCH,
SearsLink:0.2011676512155/OpenLayers.METERS_PER_INCH,Rod:5.02921005842012/OpenLayers.METERS_PER_INCH,IntnlChain:20.1168/OpenLayers.METERS_PER_INCH,IntnlLink:0.201168/OpenLayers.METERS_PER_INCH,Perch:5.02921005842012/OpenLayers.METERS_PER_INCH,Pole:5.02921005842012/OpenLayers.METERS_PER_INCH,Furlong:201.1684023368046/OpenLayers.METERS_PER_INCH,Rood:3.778266898/OpenLayers.METERS_PER_INCH,CapeFoot:0.3047972615/OpenLayers.METERS_PER_INCH,Brealey:375/OpenLayers.METERS_PER_INCH,ModAmFt:0.304812252984506/
OpenLayers.METERS_PER_INCH,Fathom:1.8288/OpenLayers.METERS_PER_INCH,"NautM-UK":1853.184/OpenLayers.METERS_PER_INCH,"50kilometers":5E4/OpenLayers.METERS_PER_INCH,"150kilometers":15E4/OpenLayers.METERS_PER_INCH});
OpenLayers.Util.extend(OpenLayers.INCHES_PER_UNIT,{mm:OpenLayers.INCHES_PER_UNIT.Meter/1E3,cm:OpenLayers.INCHES_PER_UNIT.Meter/100,dm:OpenLayers.INCHES_PER_UNIT.Meter*100,km:OpenLayers.INCHES_PER_UNIT.Meter*1E3,kmi:OpenLayers.INCHES_PER_UNIT.nmi,fath:OpenLayers.INCHES_PER_UNIT.Fathom,ch:OpenLayers.INCHES_PER_UNIT.IntnlChain,link:OpenLayers.INCHES_PER_UNIT.IntnlLink,"us-in":OpenLayers.INCHES_PER_UNIT.inches,"us-ft":OpenLayers.INCHES_PER_UNIT.Foot,"us-yd":OpenLayers.INCHES_PER_UNIT.Yard,"us-ch":OpenLayers.INCHES_PER_UNIT.GunterChain,
"us-mi":OpenLayers.INCHES_PER_UNIT.Mile,"ind-yd":OpenLayers.INCHES_PER_UNIT.IndianYd37,"ind-ft":OpenLayers.INCHES_PER_UNIT.IndianFt37,"ind-ch":20.11669506/OpenLayers.METERS_PER_INCH});OpenLayers.DOTS_PER_INCH=72;OpenLayers.Util.normalizeScale=function(a){return a>1?1/a:a};OpenLayers.Util.getResolutionFromScale=function(a,b){var c;a&&(b==null&&(b="degrees"),c=1/(OpenLayers.Util.normalizeScale(a)*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH));return c};
OpenLayers.Util.getScaleFromResolution=function(a,b){b==null&&(b="degrees");return a*OpenLayers.INCHES_PER_UNIT[b]*OpenLayers.DOTS_PER_INCH};OpenLayers.Util.safeStopPropagation=function(a){OpenLayers.Event.stop(a,!0)};
OpenLayers.Util.pagePosition=function(a){var b=[0,0],c=OpenLayers.Util.getViewportElement();if(!a||a==window||a==c)return b;var d=OpenLayers.IS_GECKO&&document.getBoxObjectFor&&OpenLayers.Element.getStyle(a,"position")=="absolute"&&(a.style.top==""||a.style.left==""),e=null;if(a.getBoundingClientRect)a=a.getBoundingClientRect(),e=c.scrollTop,b[0]=a.left+c.scrollLeft,b[1]=a.top+e;else if(document.getBoxObjectFor&&!d)a=document.getBoxObjectFor(a),c=document.getBoxObjectFor(c),b[0]=a.screenX-c.screenX,
b[1]=a.screenY-c.screenY;else{b[0]=a.offsetLeft;b[1]=a.offsetTop;e=a.offsetParent;if(e!=a)for(;e;)b[0]+=e.offsetLeft,b[1]+=e.offsetTop,e=e.offsetParent;c=OpenLayers.BROWSER_NAME;if(c=="opera"||c=="safari"&&OpenLayers.Element.getStyle(a,"position")=="absolute")b[1]-=document.body.offsetTop;for(e=a.offsetParent;e&&e!=document.body;){b[0]-=e.scrollLeft;if(c!="opera"||e.tagName!="TR")b[1]-=e.scrollTop;e=e.offsetParent}}return b};
OpenLayers.Util.getViewportElement=function(){var a=arguments.callee.viewportElement;if(a==void 0)a=OpenLayers.BROWSER_NAME=="msie"&&document.compatMode!="CSS1Compat"?document.body:document.documentElement,arguments.callee.viewportElement=a;return a};
OpenLayers.Util.isEquivalentUrl=function(a,b,c){c=c||{};OpenLayers.Util.applyDefaults(c,{ignoreCase:!0,ignorePort80:!0,ignoreHash:!0});var a=OpenLayers.Util.createUrlObject(a,c),b=OpenLayers.Util.createUrlObject(b,c),d;for(d in a)if(d!=="args"&&a[d]!=b[d])return!1;for(d in a.args){if(a.args[d]!=b.args[d])return!1;delete b.args[d]}for(d in b.args)return!1;return!0};
OpenLayers.Util.createUrlObject=function(a,b){b=b||{};if(!/^\w+:\/\//.test(a)){var c=window.location,d=c.port?":"+c.port:"",d=c.protocol+"//"+c.host.split(":").shift()+d;a.indexOf("/")===0?a=d+a:(c=c.pathname.split("/"),c.pop(),a=d+c.join("/")+"/"+a)}b.ignoreCase&&(a=a.toLowerCase());c=document.createElement("a");c.href=a;d={};d.host=c.host.split(":").shift();d.protocol=c.protocol;d.port=b.ignorePort80?c.port=="80"||c.port=="0"?"":c.port:c.port==""||c.port=="0"?"80":c.port;d.hash=b.ignoreHash||c.hash===
"#"?"":c.hash;var e=c.search;e||(e=a.indexOf("?"),e=e!=-1?a.substr(e):"");d.args=OpenLayers.Util.getParameters(e);d.pathname=c.pathname.charAt(0)=="/"?c.pathname:"/"+c.pathname;return d};OpenLayers.Util.removeTail=function(a){var b=null,b=a.indexOf("?"),c=a.indexOf("#");return b=b==-1?c!=-1?a.substr(0,c):a:c!=-1?a.substr(0,Math.min(b,c)):a.substr(0,b)};OpenLayers.IS_GECKO=function(){var a=navigator.userAgent.toLowerCase();return a.indexOf("webkit")==-1&&a.indexOf("gecko")!=-1}();
OpenLayers.BROWSER_NAME=function(){var a="",b=navigator.userAgent.toLowerCase();b.indexOf("opera")!=-1?a="opera":b.indexOf("msie")!=-1?a="msie":b.indexOf("safari")!=-1?a="safari":b.indexOf("mozilla")!=-1&&(a=b.indexOf("firefox")!=-1?"firefox":"mozilla");return a}();OpenLayers.Util.getBrowserName=function(){return OpenLayers.BROWSER_NAME};
OpenLayers.Util.getRenderedDimensions=function(a,b,c){var d,e,f=document.createElement("div");f.style.visibility="hidden";var g=c&&c.containerElement?c.containerElement:document.body;if(b)if(b.w)d=b.w,f.style.width=d+"px";else if(b.h)e=b.h,f.style.height=e+"px";if(c&&c.displayClass)f.className=c.displayClass;b=document.createElement("div");b.innerHTML=a;b.style.overflow="visible";if(b.childNodes){a=0;for(c=b.childNodes.length;a<c;a++)if(b.childNodes[a].style)b.childNodes[a].style.overflow="visible"}f.appendChild(b);
g.appendChild(f);a=!1;for(c=f.parentNode;c&&c.tagName.toLowerCase()!="body";){var h=OpenLayers.Element.getStyle(c,"position");if(h=="absolute"){a=!0;break}else if(h&&h!="static")break;c=c.parentNode}if(!a)f.style.position="absolute";if(!d)d=parseInt(b.scrollWidth),f.style.width=d+"px";e||(e=parseInt(b.scrollHeight));f.removeChild(b);g.removeChild(f);return new OpenLayers.Size(d,e)};
OpenLayers.Util.getScrollbarWidth=function(){var a=OpenLayers.Util._scrollbarWidth;if(a==null){var b=null,c=null,b=a=0,b=document.createElement("div");b.style.position="absolute";b.style.top="-1000px";b.style.left="-1000px";b.style.width="100px";b.style.height="50px";b.style.overflow="hidden";c=document.createElement("div");c.style.width="100%";c.style.height="200px";b.appendChild(c);document.body.appendChild(b);a=c.offsetWidth;b.style.overflow="scroll";b=c.offsetWidth;document.body.removeChild(document.body.lastChild);
OpenLayers.Util._scrollbarWidth=a-b;a=OpenLayers.Util._scrollbarWidth}return a};
OpenLayers.Util.getFormattedLonLat=function(a,b,c){c||(c="dms");var a=(a+540)%360-180,d=Math.abs(a),e=Math.floor(d),f=d=(d-e)/(1/60),d=Math.floor(d),f=Math.round((f-d)/(1/60)*10);f/=10;f>=60&&(f-=60,d+=1,d>=60&&(d-=60,e+=1));e<10&&(e="0"+e);e+="\u00b0";c.indexOf("dm")>=0&&(d<10&&(d="0"+d),e+=d+"'",c.indexOf("dms")>=0&&(f<10&&(f="0"+f),e+=f+'"'));e+=b=="lon"?a<0?OpenLayers.i18n("W"):OpenLayers.i18n("E"):a<0?OpenLayers.i18n("S"):OpenLayers.i18n("N");return e};OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Corner={round:function(a,b){a=OpenLayers.Util.getElement(a);this._setOptions(b);var c=this.options.color;this.options.color=="fromElement"&&(c=this._background(a));var d=this.options.bgColor;this.options.bgColor=="fromParent"&&(d=this._background(a.offsetParent));this._roundCornersImpl(a,c,d)},changeColor:function(a,b){a.style.backgroundColor=b;for(var c=a.parentNode.getElementsByTagName("span"),d=0;d<c.length;d++)c[d].style.backgroundColor=b},changeOpacity:function(a,b){var c="alpha(opacity="+
b*100+")";a.style.opacity=b;a.style.filter=c;for(var d=a.parentNode.getElementsByTagName("span"),e=0;e<d.length;e++)d[e].style.opacity=b,d[e].style.filter=c},reRound:function(a,b){var c=a.parentNode.childNodes[2];a.parentNode.removeChild(a.parentNode.childNodes[0]);a.parentNode.removeChild(c);this.round(a.parentNode,b)},_roundCornersImpl:function(a,b,c){this.options.border&&this._renderBorder(a,c);this._isTopRounded()&&this._roundTopCorners(a,b,c);this._isBottomRounded()&&this._roundBottomCorners(a,
b,c)},_renderBorder:function(a,b){var c="1px solid "+this._borderColor(b);a.innerHTML="<div "+("style='border-left: "+c+";"+("border-right: "+c)+"'")+">"+a.innerHTML+"</div>"},_roundTopCorners:function(a,b,c){for(var d=this._createCorner(c),e=0;e<this.options.numSlices;e++)d.appendChild(this._createCornerSlice(b,c,e,"top"));a.style.paddingTop=0;a.insertBefore(d,a.firstChild)},_roundBottomCorners:function(a,b,c){for(var d=this._createCorner(c),e=this.options.numSlices-1;e>=0;e--)d.appendChild(this._createCornerSlice(b,
c,e,"bottom"));a.style.paddingBottom=0;a.appendChild(d)},_createCorner:function(a){var b=document.createElement("div");b.style.backgroundColor=this._isTransparent()?"transparent":a;return b},_createCornerSlice:function(a,b,c,d){var e=document.createElement("span"),f=e.style;f.backgroundColor=a;f.display="block";f.height="1px";f.overflow="hidden";f.fontSize="1px";a=this._borderColor(a,b);if(this.options.border&&c==0)f.borderTopStyle="solid",f.borderTopWidth="1px",f.borderLeftWidth="0px",f.borderRightWidth=
"0px",f.borderBottomWidth="0px",f.height="0px",f.borderColor=a;else if(a)f.borderColor=a,f.borderStyle="solid",f.borderWidth="0px 1px";if(!this.options.compact&&c==this.options.numSlices-1)f.height="2px";this._setMargin(e,c,d);this._setBorder(e,c,d);return e},_setOptions:function(a){this.options={corners:"all",color:"fromElement",bgColor:"fromParent",blend:!0,border:!1,compact:!1};OpenLayers.Util.extend(this.options,a||{});this.options.numSlices=this.options.compact?2:4;if(this._isTransparent())this.options.blend=
!1},_whichSideTop:function(){if(this._hasString(this.options.corners,"all","top"))return"";if(this.options.corners.indexOf("tl")>=0&&this.options.corners.indexOf("tr")>=0)return"";if(this.options.corners.indexOf("tl")>=0)return"left";else if(this.options.corners.indexOf("tr")>=0)return"right";return""},_whichSideBottom:function(){if(this._hasString(this.options.corners,"all","bottom"))return"";if(this.options.corners.indexOf("bl")>=0&&this.options.corners.indexOf("br")>=0)return"";if(this.options.corners.indexOf("bl")>=
0)return"left";else if(this.options.corners.indexOf("br")>=0)return"right";return""},_borderColor:function(a,b){return a=="transparent"?b:this.options.border?this.options.border:this.options.blend?this._blend(b,a):""},_setMargin:function(a,b,c){b=this._marginSize(b);c=c=="top"?this._whichSideTop():this._whichSideBottom();c=="left"?(a.style.marginLeft=b+"px",a.style.marginRight="0px"):c=="right"?(a.style.marginRight=b+"px",a.style.marginLeft="0px"):(a.style.marginLeft=b+"px",a.style.marginRight=b+
"px")},_setBorder:function(a,b,c){b=this._borderSize(b);c=c=="top"?this._whichSideTop():this._whichSideBottom();c=="left"?(a.style.borderLeftWidth=b+"px",a.style.borderRightWidth="0px"):c=="right"?(a.style.borderRightWidth=b+"px",a.style.borderLeftWidth="0px"):(a.style.borderLeftWidth=b+"px",a.style.borderRightWidth=b+"px");if(this.options.border!=!1)a.style.borderLeftWidth=b+"px",a.style.borderRightWidth=b+"px"},_marginSize:function(a){if(this._isTransparent())return 0;var b=[5,3,2,1],c=[3,2,1,0],
d=[2,1],e=[1,0];return this.options.compact&&this.options.blend?e[a]:this.options.compact?d[a]:this.options.blend?c[a]:b[a]},_borderSize:function(a){var b=[5,3,2,1],c=[2,1,1,1],d=[1,0],e=[0,2,0,0];if(this.options.compact&&(this.options.blend||this._isTransparent()))return 1;else if(this.options.compact)return d[a];else if(this.options.blend)return c[a];else if(this.options.border)return e[a];else if(this._isTransparent())return b[a];return 0},_hasString:function(a){for(var b=1;b<arguments.length;b++)if(a.indexOf(arguments[b])>=
0)return!0;return!1},_blend:function(a,b){var c=OpenLayers.Rico.Color.createFromHex(a);c.blend(OpenLayers.Rico.Color.createFromHex(b));return c},_background:function(a){try{return OpenLayers.Rico.Color.createColorFromBackground(a).asHex()}catch(b){return"#ffffff"}},_isTransparent:function(){return this.options.color=="transparent"},_isTopRounded:function(){return this._hasString(this.options.corners,"all","top","tl","tr")},_isBottomRounded:function(){return this._hasString(this.options.corners,"all",
"bottom","bl","br")},_hasSingleTextChild:function(a){return a.childNodes.length==1&&a.childNodes[0].nodeType==3}};OpenLayers.Console={log:function(){},debug:function(){},info:function(){},warn:function(){},error:function(){},userError:function(a){alert(a)},assert:function(){},dir:function(){},dirxml:function(){},trace:function(){},group:function(){},groupEnd:function(){},time:function(){},timeEnd:function(){},profile:function(){},profileEnd:function(){},count:function(){},CLASS_NAME:"OpenLayers.Console"};
(function(){for(var a=document.getElementsByTagName("script"),b=0,c=a.length;b<c;++b)if(a[b].src.indexOf("firebug.js")!=-1&&console){OpenLayers.Util.extend(OpenLayers.Console,console);break}})();
OpenLayers.Control=OpenLayers.Class({id:null,map:null,div:null,type:null,allowSelection:!1,displayClass:"",title:"",autoActivate:!1,active:null,handler:null,eventListeners:null,events:null,EVENT_TYPES:["activate","deactivate"],initialize:function(a){this.displayClass=this.CLASS_NAME.replace("OpenLayers.","ol").replace(/\./g,"");OpenLayers.Util.extend(this,a);this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);if(this.id==
null)this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){if(this.events)this.eventListeners&&this.events.un(this.eventListeners),this.events.destroy(),this.events=null;this.eventListeners=null;if(this.handler)this.handler.destroy(),this.handler=null;if(this.handlers){for(var a in this.handlers)this.handlers.hasOwnProperty(a)&&typeof this.handlers[a].destroy=="function"&&this.handlers[a].destroy();this.handlers=null}if(this.map)this.map.removeControl(this),this.map=null;
this.div=null},setMap:function(a){this.map=a;this.handler&&this.handler.setMap(a)},draw:function(a){if(this.div==null){this.div=OpenLayers.Util.createDiv(this.id);this.div.className=this.displayClass;if(!this.allowSelection)this.div.className+=" olControlNoSelect",this.div.setAttribute("unselectable","on",0),this.div.onselectstart=OpenLayers.Function.False;if(this.title!="")this.div.title=this.title}if(a!=null)this.position=a.clone();this.moveTo(this.position);return this.div},moveTo:function(a){if(a!=
null&&this.div!=null)this.div.style.left=a.x+"px",this.div.style.top=a.y+"px"},activate:function(){if(this.active)return!1;this.handler&&this.handler.activate();this.active=!0;this.map&&OpenLayers.Element.addClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,"")+"Active");this.events.triggerEvent("activate");return!0},deactivate:function(){return this.active?(this.handler&&this.handler.deactivate(),this.active=!1,this.map&&OpenLayers.Element.removeClass(this.map.viewPortDiv,this.displayClass.replace(/ /g,
"")+"Active"),this.events.triggerEvent("deactivate"),!0):!1},CLASS_NAME:"OpenLayers.Control"});OpenLayers.Control.TYPE_BUTTON=1;OpenLayers.Control.TYPE_TOGGLE=2;OpenLayers.Control.TYPE_TOOL=3;
OpenLayers.Lang={code:null,defaultCode:"en",getCode:function(){OpenLayers.Lang.code||OpenLayers.Lang.setCode();return OpenLayers.Lang.code},setCode:function(a){var b;a||(a=OpenLayers.BROWSER_NAME=="msie"?navigator.userLanguage:navigator.language);a=a.split("-");a[0]=a[0].toLowerCase();typeof OpenLayers.Lang[a[0]]=="object"&&(b=a[0]);if(a[1]){var c=a[0]+"-"+a[1].toUpperCase();typeof OpenLayers.Lang[c]=="object"&&(b=c)}if(!b)OpenLayers.Console.warn("Failed to find OpenLayers.Lang."+a.join("-")+" dictionary, falling back to default language"),
b=OpenLayers.Lang.defaultCode;OpenLayers.Lang.code=b},translate:function(a,b){var c=OpenLayers.Lang[OpenLayers.Lang.getCode()];(c=c&&c[a])||(c=a);b&&(c=OpenLayers.String.format(c,b));return c}};OpenLayers.i18n=OpenLayers.Lang.translate;
OpenLayers.Bounds=OpenLayers.Class({left:null,bottom:null,right:null,top:null,centerLonLat:null,initialize:function(a,b,c,d){if(a!=null)this.left=OpenLayers.Util.toFloat(a);if(b!=null)this.bottom=OpenLayers.Util.toFloat(b);if(c!=null)this.right=OpenLayers.Util.toFloat(c);if(d!=null)this.top=OpenLayers.Util.toFloat(d)},clone:function(){return new OpenLayers.Bounds(this.left,this.bottom,this.right,this.top)},equals:function(a){var b=!1;a!=null&&(b=this.left==a.left&&this.right==a.right&&this.top==a.top&&
this.bottom==a.bottom);return b},toString:function(){return[this.left,this.bottom,this.right,this.top].join(",")},toArray:function(a){return a===!0?[this.bottom,this.left,this.top,this.right]:[this.left,this.bottom,this.right,this.top]},toBBOX:function(a,b){a==null&&(a=6);var c=Math.pow(10,a),d=Math.round(this.left*c)/c,e=Math.round(this.bottom*c)/c,f=Math.round(this.right*c)/c,c=Math.round(this.top*c)/c;return b===!0?e+","+d+","+c+","+f:d+","+e+","+f+","+c},toGeometry:function(){return new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing([new OpenLayers.Geometry.Point(this.left,
this.bottom),new OpenLayers.Geometry.Point(this.right,this.bottom),new OpenLayers.Geometry.Point(this.right,this.top),new OpenLayers.Geometry.Point(this.left,this.top)])])},getWidth:function(){return this.right-this.left},getHeight:function(){return this.top-this.bottom},getSize:function(){return new OpenLayers.Size(this.getWidth(),this.getHeight())},getCenterPixel:function(){return new OpenLayers.Pixel((this.left+this.right)/2,(this.bottom+this.top)/2)},getCenterLonLat:function(){if(!this.centerLonLat)this.centerLonLat=
new OpenLayers.LonLat((this.left+this.right)/2,(this.bottom+this.top)/2);return this.centerLonLat},scale:function(a,b){b==null&&(b=this.getCenterLonLat());var c,d;b.CLASS_NAME=="OpenLayers.LonLat"?(c=b.lon,d=b.lat):(c=b.x,d=b.y);return new OpenLayers.Bounds((this.left-c)*a+c,(this.bottom-d)*a+d,(this.right-c)*a+c,(this.top-d)*a+d)},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("boundsAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.Bounds(this.left+a,this.bottom+
b,this.right+a,this.top+b)},extend:function(a){var b=null;if(a){switch(a.CLASS_NAME){case "OpenLayers.LonLat":b=new OpenLayers.Bounds(a.lon,a.lat,a.lon,a.lat);break;case "OpenLayers.Geometry.Point":b=new OpenLayers.Bounds(a.x,a.y,a.x,a.y);break;case "OpenLayers.Bounds":b=a}if(b){this.centerLonLat=null;if(this.left==null||b.left<this.left)this.left=b.left;if(this.bottom==null||b.bottom<this.bottom)this.bottom=b.bottom;if(this.right==null||b.right>this.right)this.right=b.right;if(this.top==null||b.top>
this.top)this.top=b.top}}},containsLonLat:function(a,b){return this.contains(a.lon,a.lat,b)},containsPixel:function(a,b){return this.contains(a.x,a.y,b)},contains:function(a,b,c){c==null&&(c=!0);if(a==null||b==null)return!1;var a=OpenLayers.Util.toFloat(a),b=OpenLayers.Util.toFloat(b),d=!1;return d=c?a>=this.left&&a<=this.right&&b>=this.bottom&&b<=this.top:a>this.left&&a<this.right&&b>this.bottom&&b<this.top},intersectsBounds:function(a,b){b==null&&(b=!0);var c=!1,d=this.left==a.right||this.right==
a.left||this.top==a.bottom||this.bottom==a.top;if(b||!d)var c=a.top>=this.bottom&&a.top<=this.top||this.top>a.bottom&&this.top<a.top,d=a.left>=this.left&&a.left<=this.right||this.left>=a.left&&this.left<=a.right,e=a.right>=this.left&&a.right<=this.right||this.right>=a.left&&this.right<=a.right,c=(a.bottom>=this.bottom&&a.bottom<=this.top||this.bottom>=a.bottom&&this.bottom<=a.top||c)&&(d||e);return c},containsBounds:function(a,b,c){b==null&&(b=!1);c==null&&(c=!0);var d=this.contains(a.left,a.bottom,
c),e=this.contains(a.right,a.bottom,c),f=this.contains(a.left,a.top,c),a=this.contains(a.right,a.top,c);return b?d||e||f||a:d&&e&&f&&a},determineQuadrant:function(a){var b="",c=this.getCenterLonLat();b+=a.lat<c.lat?"b":"t";b+=a.lon<c.lon?"l":"r";return b},transform:function(a,b){this.centerLonLat=null;var c=OpenLayers.Projection.transform({x:this.left,y:this.bottom},a,b),d=OpenLayers.Projection.transform({x:this.right,y:this.bottom},a,b),e=OpenLayers.Projection.transform({x:this.left,y:this.top},
a,b),f=OpenLayers.Projection.transform({x:this.right,y:this.top},a,b);this.left=Math.min(c.x,e.x);this.bottom=Math.min(c.y,d.y);this.right=Math.max(d.x,f.x);this.top=Math.max(e.y,f.y);return this},wrapDateLine:function(a,b){var b=b||{},c=b.leftTolerance||0,d=b.rightTolerance||0,e=this.clone();if(a){for(;e.left<a.left&&e.right-d<=a.left;)e=e.add(a.getWidth(),0);for(;e.left+c>=a.right&&e.right>a.right;)e=e.add(-a.getWidth(),0)}return e},CLASS_NAME:"OpenLayers.Bounds"});
OpenLayers.Bounds.fromString=function(a,b){var c=a.split(",");return OpenLayers.Bounds.fromArray(c,b)};OpenLayers.Bounds.fromArray=function(a,b){return b===!0?new OpenLayers.Bounds(parseFloat(a[1]),parseFloat(a[0]),parseFloat(a[3]),parseFloat(a[2])):new OpenLayers.Bounds(parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2]),parseFloat(a[3]))};OpenLayers.Bounds.fromSize=function(a){return new OpenLayers.Bounds(0,a.h,a.w,0)};
OpenLayers.Bounds.oppositeQuadrant=function(a){var b="";b+=a.charAt(0)=="t"?"b":"t";b+=a.charAt(1)=="l"?"r":"l";return b};
OpenLayers.Element={visible:function(a){return OpenLayers.Util.getElement(a).style.display!="none"},toggle:function(){for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]),d=OpenLayers.Element.visible(c)?"hide":"show";OpenLayers.Element[d](c)}},hide:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = 'none';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=
"none"}},show:function(){OpenLayers.Console.warn(OpenLayers.i18n("methodDeprecated",{newMethod:"element.style.display = '';"}));for(var a=0,b=arguments.length;a<b;a++){var c=OpenLayers.Util.getElement(arguments[a]);if(c)c.style.display=""}},remove:function(a){a=OpenLayers.Util.getElement(a);a.parentNode.removeChild(a)},getHeight:function(a){a=OpenLayers.Util.getElement(a);return a.offsetHeight},getDimensions:function(a){a=OpenLayers.Util.getElement(a);if(OpenLayers.Element.getStyle(a,"display")!=
"none")return{width:a.offsetWidth,height:a.offsetHeight};var b=a.style,c=b.visibility,d=b.position,e=b.display;b.visibility="hidden";b.position="absolute";b.display="";var f=a.clientWidth,a=a.clientHeight;b.display=e;b.position=d;b.visibility=c;return{width:f,height:a}},hasClass:function(a,b){var c=a.className;return!!c&&RegExp("(^|\\s)"+b+"(\\s|$)").test(c)},addClass:function(a,b){OpenLayers.Element.hasClass(a,b)||(a.className+=(a.className?" ":"")+b);return a},removeClass:function(a,b){var c=a.className;
if(c)a.className=OpenLayers.String.trim(c.replace(RegExp("(^|\\s+)"+b+"(\\s+|$)")," "));return a},toggleClass:function(a,b){OpenLayers.Element.hasClass(a,b)?OpenLayers.Element.removeClass(a,b):OpenLayers.Element.addClass(a,b);return a},getStyle:function(a,b){var a=OpenLayers.Util.getElement(a),c=null;if(a&&a.style){c=a.style[OpenLayers.String.camelize(b)];c||(document.defaultView&&document.defaultView.getComputedStyle?c=(c=document.defaultView.getComputedStyle(a,null))?c.getPropertyValue(b):null:
a.currentStyle&&(c=a.currentStyle[OpenLayers.String.camelize(b)]));var d=["left","top","right","bottom"];window.opera&&OpenLayers.Util.indexOf(d,b)!=-1&&OpenLayers.Element.getStyle(a,"position")=="static"&&(c="auto")}return c=="auto"?null:c}};
OpenLayers.LonLat=OpenLayers.Class({lon:0,lat:0,initialize:function(a,b){this.lon=OpenLayers.Util.toFloat(a);this.lat=OpenLayers.Util.toFloat(b)},toString:function(){return"lon="+this.lon+",lat="+this.lat},toShortString:function(){return this.lon+", "+this.lat},clone:function(){return new OpenLayers.LonLat(this.lon,this.lat)},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("lonlatAddError");OpenLayers.Console.error(c);return null}return new OpenLayers.LonLat(this.lon+OpenLayers.Util.toFloat(a),
this.lat+OpenLayers.Util.toFloat(b))},equals:function(a){var b=!1;a!=null&&(b=this.lon==a.lon&&this.lat==a.lat||isNaN(this.lon)&&isNaN(this.lat)&&isNaN(a.lon)&&isNaN(a.lat));return b},transform:function(a,b){var c=OpenLayers.Projection.transform({x:this.lon,y:this.lat},a,b);this.lon=c.x;this.lat=c.y;return this},wrapDateLine:function(a){var b=this.clone();if(a){for(;b.lon<a.left;)b.lon+=a.getWidth();for(;b.lon>a.right;)b.lon-=a.getWidth()}return b},CLASS_NAME:"OpenLayers.LonLat"});
OpenLayers.LonLat.fromString=function(a){a=a.split(",");return new OpenLayers.LonLat(a[0],a[1])};OpenLayers.LonLat.fromArray=function(a){var b=OpenLayers.Util.isArray(a);return new OpenLayers.LonLat(b&&a[0],b&&a[1])};
OpenLayers.Pixel=OpenLayers.Class({x:0,y:0,initialize:function(a,b){this.x=parseFloat(a);this.y=parseFloat(b)},toString:function(){return"x="+this.x+",y="+this.y},clone:function(){return new OpenLayers.Pixel(this.x,this.y)},equals:function(a){var b=!1;a!=null&&(b=this.x==a.x&&this.y==a.y||isNaN(this.x)&&isNaN(this.y)&&isNaN(a.x)&&isNaN(a.y));return b},distanceTo:function(a){return Math.sqrt(Math.pow(this.x-a.x,2)+Math.pow(this.y-a.y,2))},add:function(a,b){if(a==null||b==null){var c=OpenLayers.i18n("pixelAddError");
OpenLayers.Console.error(c);return null}return new OpenLayers.Pixel(this.x+a,this.y+b)},offset:function(a){var b=this.clone();a&&(b=this.add(a.x,a.y));return b},CLASS_NAME:"OpenLayers.Pixel"});
OpenLayers.Size=OpenLayers.Class({w:0,h:0,initialize:function(a,b){this.w=parseFloat(a);this.h=parseFloat(b)},toString:function(){return"w="+this.w+",h="+this.h},clone:function(){return new OpenLayers.Size(this.w,this.h)},equals:function(a){var b=!1;a!=null&&(b=this.w==a.w&&this.h==a.h||isNaN(this.w)&&isNaN(this.h)&&isNaN(a.w)&&isNaN(a.h));return b},CLASS_NAME:"OpenLayers.Size"});
OpenLayers.Event={observers:!1,KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,element:function(a){return a.target||a.srcElement},isSingleTouch:function(a){return a.touches&&a.touches.length==1},isMultiTouch:function(a){return a.touches&&a.touches.length>1},isLeftClick:function(a){return a.which&&a.which==1||a.button&&a.button==1},isRightClick:function(a){return a.which&&a.which==3||a.button&&a.button==2},stop:function(a,b){if(!b)a.preventDefault?
a.preventDefault():a.returnValue=!1;a.stopPropagation?a.stopPropagation():a.cancelBubble=!0},findElement:function(a,b){for(var c=OpenLayers.Event.element(a);c.parentNode&&(!c.tagName||c.tagName.toUpperCase()!=b.toUpperCase());)c=c.parentNode;return c},observe:function(a,b,c,d){a=OpenLayers.Util.getElement(a);d=d||!1;if(b=="keypress"&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.attachEvent))b="keydown";if(!this.observers)this.observers={};if(!a._eventCacheID){var e="eventCacheID_";a.id&&
(e=a.id+"_"+e);a._eventCacheID=OpenLayers.Util.createUniqueID(e)}e=a._eventCacheID;this.observers[e]||(this.observers[e]=[]);this.observers[e].push({element:a,name:b,observer:c,useCapture:d});a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent("on"+b,c)},stopObservingElement:function(a){a=OpenLayers.Util.getElement(a)._eventCacheID;this._removeElementObservers(OpenLayers.Event.observers[a])},_removeElementObservers:function(a){if(a)for(var b=a.length-1;b>=0;b--){var c=a[b];OpenLayers.Event.stopObserving.apply(this,
[c.element,c.name,c.observer,c.useCapture])}},stopObserving:function(a,b,c,d){var d=d||!1,a=OpenLayers.Util.getElement(a),e=a._eventCacheID;if(b=="keypress"&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||a.detachEvent))b="keydown";var f=!1,g=OpenLayers.Event.observers[e];if(g)for(var h=0;!f&&h<g.length;){var i=g[h];if(i.name==b&&i.observer==c&&i.useCapture==d){g.splice(h,1);g.length==0&&delete OpenLayers.Event.observers[e];f=!0;break}h++}f&&(a.removeEventListener?a.removeEventListener(b,
c,d):a&&a.detachEvent&&a.detachEvent("on"+b,c));return f},unloadCache:function(){if(OpenLayers.Event&&OpenLayers.Event.observers){for(var a in OpenLayers.Event.observers)OpenLayers.Event._removeElementObservers.apply(this,[OpenLayers.Event.observers[a]]);OpenLayers.Event.observers=!1}},CLASS_NAME:"OpenLayers.Event"};OpenLayers.Event.observe(window,"unload",OpenLayers.Event.unloadCache,!1);if(window.Event)OpenLayers.Util.applyDefaults(window.Event,OpenLayers.Event);else var Event=OpenLayers.Event;
OpenLayers.Events=OpenLayers.Class({BROWSER_EVENTS:"mouseover,mouseout,mousedown,mouseup,mousemove,click,dblclick,rightclick,dblrightclick,resize,focus,blur,touchstart,touchmove,touchend".split(","),listeners:null,object:null,element:null,eventTypes:null,eventHandler:null,fallThrough:null,includeXY:!1,clearMouseListener:null,initialize:function(a,b,c,d,e){OpenLayers.Util.extend(this,e);this.object=a;this.fallThrough=d;this.listeners={};this.eventHandler=OpenLayers.Function.bindAsEventListener(this.handleBrowserEvent,
this);this.clearMouseListener=OpenLayers.Function.bind(this.clearMouseCache,this);this.eventTypes=[];if(c!=null){a=0;for(d=c.length;a<d;a++)this.addEventType(c[a])}b!=null&&this.attachToElement(b)},destroy:function(){this.element&&(OpenLayers.Event.stopObservingElement(this.element),this.element.hasScrollEvent&&OpenLayers.Event.stopObserving(window,"scroll",this.clearMouseListener));this.eventHandler=this.fallThrough=this.eventTypes=this.object=this.listeners=this.element=null},addEventType:function(a){this.listeners[a]||
(this.eventTypes.push(a),this.listeners[a]=[])},attachToElement:function(a){this.element&&OpenLayers.Event.stopObservingElement(this.element);this.element=a;for(var b=0,c=this.BROWSER_EVENTS.length;b<c;b++){var d=this.BROWSER_EVENTS[b];this.addEventType(d);OpenLayers.Event.observe(a,d,this.eventHandler)}OpenLayers.Event.observe(a,"dragstart",OpenLayers.Event.stop)},on:function(a){for(var b in a)b!="scope"&&this.register(b,a.scope,a[b])},register:function(a,b,c){if(c!=null&&OpenLayers.Util.indexOf(this.eventTypes,
a)!=-1){if(b==null)b=this.object;this.listeners[a].push({obj:b,func:c})}},registerPriority:function(a,b,c){if(c!=null){if(b==null)b=this.object;a=this.listeners[a];a!=null&&a.unshift({obj:b,func:c})}},un:function(a){for(var b in a)b!="scope"&&this.unregister(b,a.scope,a[b])},unregister:function(a,b,c){if(b==null)b=this.object;a=this.listeners[a];if(a!=null)for(var d=0,e=a.length;d<e;d++)if(a[d].obj==b&&a[d].func==c){a.splice(d,1);break}},remove:function(a){this.listeners[a]!=null&&(this.listeners[a]=
[])},triggerEvent:function(a,b){var c=this.listeners[a];if(c&&c.length!=0){b==null&&(b={});b.object=this.object;b.element=this.element;if(!b.type)b.type=a;for(var c=c.slice(),d,e=0,f=c.length;e<f;e++)if(d=c[e],d=d.func.apply(d.obj,[b]),d!=void 0&&d==!1)break;this.fallThrough||OpenLayers.Event.stop(b,!0);return d}},handleBrowserEvent:function(a){var b=a.type,c=this.listeners[b];if(c&&c.length!=0){if((c=a.touches)&&c[0]){for(var d=0,e=0,f=c.length,g,h=0;h<f;++h)g=c[h],d+=g.clientX,e+=g.clientY;a.clientX=
d/f;a.clientY=e/f}if(this.includeXY)a.xy=this.getMousePosition(a);this.triggerEvent(b,a)}},clearMouseCache:function(){this.element.scrolls=null;this.element.lefttop=null;var a=document.body;if(a&&(!(a.scrollTop!=0||a.scrollLeft!=0)||!navigator.userAgent.match(/iPhone/i)))this.element.offsets=null},getMousePosition:function(a){if(this.includeXY){if(!this.element.hasScrollEvent)OpenLayers.Event.observe(window,"scroll",this.clearMouseListener),this.element.hasScrollEvent=!0}else this.clearMouseCache();
if(!this.element.scrolls){var b=OpenLayers.Util.getViewportElement();this.element.scrolls=[b.scrollLeft,b.scrollTop]}if(!this.element.lefttop)this.element.lefttop=[document.documentElement.clientLeft||0,document.documentElement.clientTop||0];if(!this.element.offsets)this.element.offsets=OpenLayers.Util.pagePosition(this.element);return new OpenLayers.Pixel(a.clientX+this.element.scrolls[0]-this.element.offsets[0]-this.element.lefttop[0],a.clientY+this.element.scrolls[1]-this.element.offsets[1]-this.element.lefttop[1])},
CLASS_NAME:"OpenLayers.Events"});
OpenLayers.Control.OverviewMap=OpenLayers.Class(OpenLayers.Control,{element:null,ovmap:null,size:new OpenLayers.Size(180,90),layers:null,minRectSize:15,minRectDisplayClass:"RectReplacement",minRatio:8,maxRatio:32,mapOptions:null,autoPan:!1,handlers:null,resolutionFactor:1,maximized:!1,initialize:function(a){this.layers=[];this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,[a])},destroy:function(){if(this.mapDiv){this.handlers.click&&this.handlers.click.destroy();this.handlers.drag&&
this.handlers.drag.destroy();this.ovmap&&this.ovmap.eventsDiv.removeChild(this.extentRectangle);this.extentRectangle=null;if(this.rectEvents)this.rectEvents.destroy(),this.rectEvents=null;if(this.ovmap)this.ovmap.destroy(),this.ovmap=null;this.element.removeChild(this.mapDiv);this.mapDiv=null;this.div.removeChild(this.element);this.element=null;if(this.maximizeDiv)OpenLayers.Event.stopObservingElement(this.maximizeDiv),this.div.removeChild(this.maximizeDiv),this.maximizeDiv=null;if(this.minimizeDiv)OpenLayers.Event.stopObservingElement(this.minimizeDiv),
this.div.removeChild(this.minimizeDiv),this.minimizeDiv=null;this.map.events.un({moveend:this.update,changebaselayer:this.baseLayerDraw,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!(this.layers.length>0))if(this.map.baseLayer)this.layers=[this.map.baseLayer.clone()];else return this.map.events.register("changebaselayer",this,this.baseLayerDraw),this.div;this.element=document.createElement("div");
this.element.className=this.displayClass+"Element";this.element.style.display="none";this.mapDiv=document.createElement("div");this.mapDiv.style.width=this.size.w+"px";this.mapDiv.style.height=this.size.h+"px";this.mapDiv.style.position="relative";this.mapDiv.style.overflow="hidden";this.mapDiv.id=OpenLayers.Util.createUniqueID("overviewMap");this.extentRectangle=document.createElement("div");this.extentRectangle.style.position="absolute";this.extentRectangle.style.zIndex=1E3;this.extentRectangle.className=
this.displayClass+"ExtentRectangle";this.element.appendChild(this.mapDiv);this.div.appendChild(this.element);if(this.outsideViewport)this.element.style.display="";else{this.div.className+=" "+this.displayClass+"Container";var a=OpenLayers.Util.getImagesLocation();this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv(this.displayClass+"MaximizeButton",null,new OpenLayers.Size(18,18),a+"layer-switcher-maximize.png","absolute");this.maximizeDiv.style.display="none";this.maximizeDiv.className=this.displayClass+
"MaximizeButton";OpenLayers.Event.observe(this.maximizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.maximizeControl,this));this.div.appendChild(this.maximizeDiv);this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_minimizeDiv",null,new OpenLayers.Size(18,18),a+"layer-switcher-minimize.png","absolute");this.minimizeDiv.style.display="none";this.minimizeDiv.className=this.displayClass+"MinimizeButton";OpenLayers.Event.observe(this.minimizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.minimizeControl,
this));this.div.appendChild(this.minimizeDiv);for(var a=["dblclick","mousedown"],b=0,c=a.length;b<c;b++)OpenLayers.Event.observe(this.maximizeDiv,a[b],OpenLayers.Event.stop),OpenLayers.Event.observe(this.minimizeDiv,a[b],OpenLayers.Event.stop);this.minimizeControl()}this.map.getExtent()&&this.update();this.map.events.register("moveend",this,this.update);this.maximized&&this.maximizeControl();return this.div},baseLayerDraw:function(){this.draw();this.map.events.unregister("changebaselayer",this,this.baseLayerDraw)},
rectDrag:function(a){var b=this.handlers.drag.last.x-a.x,c=this.handlers.drag.last.y-a.y;if(b!=0||c!=0){var d=this.rectPxBounds.top,e=this.rectPxBounds.left,a=Math.abs(this.rectPxBounds.getHeight()),f=this.rectPxBounds.getWidth(),c=Math.max(0,d-c),c=Math.min(c,this.ovmap.size.h-this.hComp-a),b=Math.max(0,e-b),b=Math.min(b,this.ovmap.size.w-this.wComp-f);this.setRectPxBounds(new OpenLayers.Bounds(b,c+a,b+f,c))}},mapDivClick:function(a){var b=this.rectPxBounds.getCenterPixel(),c=a.xy.x-b.x,d=a.xy.y-
b.y,e=this.rectPxBounds.top,f=this.rectPxBounds.left,a=Math.abs(this.rectPxBounds.getHeight()),b=this.rectPxBounds.getWidth(),d=Math.max(0,e+d),d=Math.min(d,this.ovmap.size.h-a),c=Math.max(0,f+c),c=Math.min(c,this.ovmap.size.w-b);this.setRectPxBounds(new OpenLayers.Bounds(c,d+a,c+b,d));this.updateMapToRect()},maximizeControl:function(a){this.element.style.display="";this.showToggle(!1);a!=null&&OpenLayers.Event.stop(a)},minimizeControl:function(a){this.element.style.display="none";this.showToggle(!0);
a!=null&&OpenLayers.Event.stop(a)},showToggle:function(a){this.maximizeDiv.style.display=a?"":"none";this.minimizeDiv.style.display=a?"none":""},update:function(){this.ovmap==null&&this.createMap();(this.autoPan||!this.isSuitableOverview())&&this.updateOverview();this.updateRectToMap()},isSuitableOverview:function(){var a=this.map.getExtent(),b=this.map.maxExtent,a=new OpenLayers.Bounds(Math.max(a.left,b.left),Math.max(a.bottom,b.bottom),Math.min(a.right,b.right),Math.min(a.top,b.top));this.ovmap.getProjection()!=
this.map.getProjection()&&(a=a.transform(this.map.getProjectionObject(),this.ovmap.getProjectionObject()));b=this.ovmap.getResolution()/this.map.getResolution();return b>this.minRatio&&b<=this.maxRatio&&this.ovmap.getExtent().containsBounds(a)},updateOverview:function(){var a=this.map.getResolution(),b=this.ovmap.getResolution(),c=b/a;c>this.maxRatio?b=this.minRatio*a:c<=this.minRatio&&(b=this.maxRatio*a);this.ovmap.getProjection()!=this.map.getProjection()?(a=this.map.center.clone(),a.transform(this.map.getProjectionObject(),
this.ovmap.getProjectionObject())):a=this.map.center;this.ovmap.setCenter(a,this.ovmap.getZoomForResolution(b*this.resolutionFactor));this.updateRectToMap()},createMap:function(){var a=OpenLayers.Util.extend({controls:[],maxResolution:"auto",fallThrough:!1},this.mapOptions);this.ovmap=new OpenLayers.Map(this.mapDiv,a);this.ovmap.eventsDiv.appendChild(this.extentRectangle);OpenLayers.Event.stopObserving(window,"unload",this.ovmap.unloadDestroy);this.ovmap.addLayers(this.layers);this.ovmap.zoomToMaxExtent();
this.wComp=(this.wComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-left-width"))+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-right-width")))?this.wComp:2;this.hComp=(this.hComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-top-width"))+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-bottom-width")))?this.hComp:2;this.handlers.drag=new OpenLayers.Handler.Drag(this,{move:this.rectDrag,done:this.updateMapToRect},{map:this.ovmap});
this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.mapDivClick},{single:!0,"double":!1,stopSingle:!0,stopDouble:!0,pixelTolerance:1,map:this.ovmap});this.handlers.click.activate();this.rectEvents=new OpenLayers.Events(this,this.extentRectangle,null,!0);this.rectEvents.register("mouseover",this,function(){!this.handlers.drag.active&&!this.map.dragging&&this.handlers.drag.activate()});this.rectEvents.register("mouseout",this,function(){this.handlers.drag.dragging||this.handlers.drag.deactivate()});
if(this.ovmap.getProjection()!=this.map.getProjection()){var a=this.map.getProjectionObject().getUnits()||this.map.units||this.map.baseLayer.units,b=this.ovmap.getProjectionObject().getUnits()||this.ovmap.units||this.ovmap.baseLayer.units;this.resolutionFactor=a&&b?OpenLayers.INCHES_PER_UNIT[a]/OpenLayers.INCHES_PER_UNIT[b]:1}},updateRectToMap:function(){var a=this.getRectBoundsFromMapBounds(this.ovmap.getProjection()!=this.map.getProjection()?this.map.getExtent().transform(this.map.getProjectionObject(),
this.ovmap.getProjectionObject()):this.map.getExtent());a&&this.setRectPxBounds(a)},updateMapToRect:function(){var a=this.getMapBoundsFromRectBounds(this.rectPxBounds);this.ovmap.getProjection()!=this.map.getProjection()&&(a=a.transform(this.ovmap.getProjectionObject(),this.map.getProjectionObject()));this.map.panTo(a.getCenterLonLat())},setRectPxBounds:function(a){var b=Math.max(a.top,0),c=Math.max(a.left,0),d=Math.min(a.top+Math.abs(a.getHeight()),this.ovmap.size.h-this.hComp),a=Math.min(a.left+
a.getWidth(),this.ovmap.size.w-this.wComp),e=Math.max(a-c,0),f=Math.max(d-b,0);e<this.minRectSize||f<this.minRectSize?(this.extentRectangle.className=this.displayClass+this.minRectDisplayClass,e=c+e/2-this.minRectSize/2,this.extentRectangle.style.top=Math.round(b+f/2-this.minRectSize/2)+"px",this.extentRectangle.style.left=Math.round(e)+"px",this.extentRectangle.style.height=this.minRectSize+"px",this.extentRectangle.style.width=this.minRectSize+"px"):(this.extentRectangle.className=this.displayClass+
"ExtentRectangle",this.extentRectangle.style.top=Math.round(b)+"px",this.extentRectangle.style.left=Math.round(c)+"px",this.extentRectangle.style.height=Math.round(f)+"px",this.extentRectangle.style.width=Math.round(e)+"px");this.rectPxBounds=new OpenLayers.Bounds(Math.round(c),Math.round(d),Math.round(a),Math.round(b))},getRectBoundsFromMapBounds:function(a){var b=new OpenLayers.LonLat(a.left,a.bottom),a=new OpenLayers.LonLat(a.right,a.top),b=this.getOverviewPxFromLonLat(b),a=this.getOverviewPxFromLonLat(a),
c=null;b&&a&&(c=new OpenLayers.Bounds(b.x,b.y,a.x,a.y));return c},getMapBoundsFromRectBounds:function(a){var b=new OpenLayers.Pixel(a.left,a.bottom),a=new OpenLayers.Pixel(a.right,a.top),b=this.getLonLatFromOverviewPx(b),a=this.getLonLatFromOverviewPx(a);return new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat)},getLonLatFromOverviewPx:function(a){var b=this.ovmap.size,c=this.ovmap.getResolution(),d=this.ovmap.getExtent().getCenterLonLat();return new OpenLayers.LonLat(d.lon+(a.x-b.w/2)*c,d.lat-(a.y-b.h/
2)*c)},getOverviewPxFromLonLat:function(a){var b=this.ovmap.getResolution(),c=this.ovmap.getExtent(),d=null;c&&(d=new OpenLayers.Pixel(Math.round(1/b*(a.lon-c.left)),Math.round(1/b*(c.top-a.lat))));return d},CLASS_NAME:"OpenLayers.Control.OverviewMap"});
OpenLayers.Control.Panel=OpenLayers.Class(OpenLayers.Control,{controls:null,autoActivate:!0,defaultControl:null,saveState:!1,allowDepress:!1,activeState:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);this.controls=[];this.activeState={}},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments);for(var a,b=this.controls.length-1;b>=0;b--)a=this.controls[b],a.events&&a.events.un({activate:this.iconOn,deactivate:this.iconOff}),OpenLayers.Event.stopObservingElement(a.panel_div),
a.panel_div=null;this.activeState=null},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){for(var a,b=0,c=this.controls.length;b<c;b++)a=this.controls[b],(a===this.defaultControl||this.saveState&&this.activeState[a.id])&&a.activate();if(this.saveState===!0)this.defaultControl=null;this.redraw();return!0}else return!1},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){for(var a,b=0,c=this.controls.length;b<c;b++)a=this.controls[b],
this.activeState[a.id]=a.deactivate();this.redraw();return!0}else return!1},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.addControlsToMap(this.controls);return this.div},redraw:function(){for(var a=this.div.childNodes.length-1;a>=0;a--)this.div.removeChild(this.div.childNodes[a]);this.div.innerHTML="";if(this.active)for(var a=0,b=this.controls.length;a<b;a++)this.div.appendChild(this.controls[a].panel_div)},activateControl:function(a){if(!this.active)return!1;if(a.type==
OpenLayers.Control.TYPE_BUTTON)a.trigger();else if(a.type==OpenLayers.Control.TYPE_TOGGLE)a.active?a.deactivate():a.activate();else if(this.allowDepress&&a.active)a.deactivate();else{for(var b,c=0,d=this.controls.length;c<d;c++)b=this.controls[c],b!=a&&(b.type===OpenLayers.Control.TYPE_TOOL||b.type==null)&&b.deactivate();a.activate()}},addControls:function(a){OpenLayers.Util.isArray(a)||(a=[a]);this.controls=this.controls.concat(a);for(var b=0,c=a.length;b<c;b++){var d=document.createElement("div");
d.className=a[b].displayClass+"ItemInactive";a[b].panel_div=d;if(a[b].title!="")a[b].panel_div.title=a[b].title;OpenLayers.Event.observe(a[b].panel_div,"click",OpenLayers.Function.bind(this.onClick,this,a[b]));OpenLayers.Event.observe(a[b].panel_div,"dblclick",OpenLayers.Function.bind(this.onDoubleClick,this,a[b]));OpenLayers.Event.observe(a[b].panel_div,"mousedown",OpenLayers.Function.bindAsEventListener(OpenLayers.Event.stop))}this.map&&(this.addControlsToMap(a),this.redraw())},addControlsToMap:function(a){for(var b,
c=0,d=a.length;c<d;c++)b=a[c],b.autoActivate===!0?(b.autoActivate=!1,this.map.addControl(b),b.autoActivate=!0):(this.map.addControl(b),b.deactivate()),b.events.on({activate:this.iconOn,deactivate:this.iconOff})},iconOn:function(){var a=this.panel_div;a.className=a.className.replace(/ItemInactive$/,"ItemActive")},iconOff:function(){var a=this.panel_div;a.className=a.className.replace(/ItemActive$/,"ItemInactive")},onClick:function(a,b){OpenLayers.Event.stop(b?b:window.event);this.activateControl(a)},
onDoubleClick:function(a,b){OpenLayers.Event.stop(b?b:window.event)},getControlsBy:function(a,b){var c=typeof b.test=="function";return OpenLayers.Array.filter(this.controls,function(d){return d[a]==b||c&&b.test(d[a])})},getControlsByName:function(a){return this.getControlsBy("name",a)},getControlsByClass:function(a){return this.getControlsBy("CLASS_NAME",a)},CLASS_NAME:"OpenLayers.Control.Panel"});
OpenLayers.Control.ZoomIn=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map.zoomIn()},CLASS_NAME:"OpenLayers.Control.ZoomIn"});OpenLayers.Control.ZoomOut=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map.zoomOut()},CLASS_NAME:"OpenLayers.Control.ZoomOut"});
OpenLayers.Control.ZoomToMaxExtent=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){this.map&&this.map.zoomToMaxExtent()},CLASS_NAME:"OpenLayers.Control.ZoomToMaxExtent"});OpenLayers.Control.ZoomPanel=OpenLayers.Class(OpenLayers.Control.Panel,{initialize:function(a){OpenLayers.Control.Panel.prototype.initialize.apply(this,[a]);this.addControls([new OpenLayers.Control.ZoomIn,new OpenLayers.Control.ZoomToMaxExtent,new OpenLayers.Control.ZoomOut])},CLASS_NAME:"OpenLayers.Control.ZoomPanel"});
OpenLayers.Control.PanZoom=OpenLayers.Class(OpenLayers.Control,{slideFactor:50,slideRatio:null,buttons:null,position:null,initialize:function(a){this.position=new OpenLayers.Pixel(OpenLayers.Control.PanZoom.X,OpenLayers.Control.PanZoom.Y);OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.removeButtons();this.position=this.buttons=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);
a=this.position;this.buttons=[];var b=new OpenLayers.Size(18,18),c=new OpenLayers.Pixel(a.x+b.w/2,a.y);this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft","west-mini.png",a,b);this._addButton("panright","east-mini.png",a.add(b.w,0),b);this._addButton("pandown","south-mini.png",c.add(0,b.h*2),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,b.h*3+5),b);this._addButton("zoomworld","zoom-world-mini.png",c.add(0,b.h*4+5),b);this._addButton("zoomout","zoom-minus-mini.png",
c.add(0,b.h*5+5),b);return this.div},_addButton:function(a,b,c,d){b=OpenLayers.Util.getImagesLocation()+b;c=OpenLayers.Util.createAlphaImageDiv(this.id+"_"+a,c,d,b,"absolute");c.style.cursor="pointer";this.div.appendChild(c);OpenLayers.Event.observe(c,"mousedown",OpenLayers.Function.bindAsEventListener(this.buttonDown,c));OpenLayers.Event.observe(c,"dblclick",OpenLayers.Function.bindAsEventListener(this.doubleClick,c));OpenLayers.Event.observe(c,"click",OpenLayers.Function.bindAsEventListener(this.doubleClick,
c));c.action=a;c.map=this.map;if(this.slideRatio)var e=this.slideRatio,a=function(a){return this.map.getSize()[a]*e};else var f=this.slideFactor,a=function(){return f};c.getSlideFactor=a;this.buttons.push(c);return c},_removeButton:function(a){OpenLayers.Event.stopObservingElement(a);a.map=null;a.getSlideFactor=null;this.div.removeChild(a);OpenLayers.Util.removeItem(this.buttons,a)},removeButtons:function(){for(var a=this.buttons.length-1;a>=0;--a)this._removeButton(this.buttons[a])},doubleClick:function(a){OpenLayers.Event.stop(a);
return!1},buttonDown:function(a){if(OpenLayers.Event.isLeftClick(a)){switch(this.action){case "panup":this.map.pan(0,-this.getSlideFactor("h"));break;case "pandown":this.map.pan(0,this.getSlideFactor("h"));break;case "panleft":this.map.pan(-this.getSlideFactor("w"),0);break;case "panright":this.map.pan(this.getSlideFactor("w"),0);break;case "zoomin":this.map.zoomIn();break;case "zoomout":this.map.zoomOut();break;case "zoomworld":this.map.zoomToMaxExtent()}OpenLayers.Event.stop(a)}},CLASS_NAME:"OpenLayers.Control.PanZoom"});
OpenLayers.Control.PanZoom.X=4;OpenLayers.Control.PanZoom.Y=4;
OpenLayers.Control.PanZoomBar=OpenLayers.Class(OpenLayers.Control.PanZoom,{zoomStopWidth:18,zoomStopHeight:11,slider:null,sliderEvents:null,zoombarDiv:null,divEvents:null,zoomWorldIcon:!1,panIcons:!0,forceFixedZoomLevel:!1,mouseDragStart:null,deltaY:null,zoomStart:null,destroy:function(){this._removeZoomBar();this.map.events.un({changebaselayer:this.redraw,scope:this});OpenLayers.Control.PanZoom.prototype.destroy.apply(this,arguments);delete this.mouseDragStart;delete this.zoomStart},setMap:function(a){OpenLayers.Control.PanZoom.prototype.setMap.apply(this,
arguments);this.map.events.register("changebaselayer",this,this.redraw)},redraw:function(){this.div!=null&&(this.removeButtons(),this._removeZoomBar());this.draw()},draw:function(a){OpenLayers.Control.prototype.draw.apply(this,arguments);a=this.position.clone();this.buttons=[];var b=new OpenLayers.Size(18,18);if(this.panIcons){var c=new OpenLayers.Pixel(a.x+b.w/2,a.y),d=b.w;this.zoomWorldIcon&&(c=new OpenLayers.Pixel(a.x+b.w,a.y));this._addButton("panup","north-mini.png",c,b);a.y=c.y+b.h;this._addButton("panleft",
"west-mini.png",a,b);this.zoomWorldIcon&&(this._addButton("zoomworld","zoom-world-mini.png",a.add(b.w,0),b),d*=2);this._addButton("panright","east-mini.png",a.add(d,0),b);this._addButton("pandown","south-mini.png",c.add(0,b.h*2),b);this._addButton("zoomin","zoom-plus-mini.png",c.add(0,b.h*3+5),b);c=this._addZoomBar(c.add(0,b.h*4+5));this._addButton("zoomout","zoom-minus-mini.png",c,b)}else this._addButton("zoomin","zoom-plus-mini.png",a,b),c=this._addZoomBar(a.add(0,b.h)),this._addButton("zoomout",
"zoom-minus-mini.png",c,b),this.zoomWorldIcon&&(c=c.add(0,b.h+3),this._addButton("zoomworld","zoom-world-mini.png",c,b));return this.div},_addZoomBar:function(a){var b=OpenLayers.Util.getImagesLocation(),c=this.id+"_"+this.map.id,d=this.map.getNumZoomLevels()-1-this.map.getZoom(),d=OpenLayers.Util.createAlphaImageDiv(c,a.add(-1,d*this.zoomStopHeight),new OpenLayers.Size(20,9),b+"slider.png","absolute");d.style.cursor="move";this.slider=d;this.sliderEvents=new OpenLayers.Events(this,d,null,!0,{includeXY:!0});
this.sliderEvents.on({touchstart:this.zoomBarDown,touchmove:this.zoomBarDrag,touchend:this.zoomBarUp,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});var e=new OpenLayers.Size;e.h=this.zoomStopHeight*this.map.getNumZoomLevels();e.w=this.zoomStopWidth;c=null;OpenLayers.Util.alphaHack()?(c=this.id+"_"+this.map.id,c=OpenLayers.Util.createAlphaImageDiv(c,a,new OpenLayers.Size(e.w,this.zoomStopHeight),b+"zoombar.png","absolute",
null,"crop"),c.style.height=e.h+"px"):c=OpenLayers.Util.createDiv("OpenLayers_Control_PanZoomBar_Zoombar"+this.map.id,a,e,b+"zoombar.png");c.style.cursor="pointer";this.zoombarDiv=c;this.divEvents=new OpenLayers.Events(this,c,null,!0,{includeXY:!0});this.divEvents.on({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,click:this.doubleClick});this.div.appendChild(c);this.startTop=parseInt(c.style.top);this.div.appendChild(d);this.map.events.register("zoomend",
this,this.moveZoomBar);return a=a.add(0,this.zoomStopHeight*this.map.getNumZoomLevels())},_removeZoomBar:function(){this.sliderEvents.un({touchmove:this.zoomBarDrag,mousedown:this.zoomBarDown,mousemove:this.zoomBarDrag,mouseup:this.zoomBarUp,dblclick:this.doubleClick,click:this.doubleClick});this.sliderEvents.destroy();this.divEvents.un({touchmove:this.passEventToSlider,mousedown:this.divClick,mousemove:this.passEventToSlider,dblclick:this.doubleClick,click:this.doubleClick});this.divEvents.destroy();
this.div.removeChild(this.zoombarDiv);this.zoombarDiv=null;this.div.removeChild(this.slider);this.slider=null;this.map.events.unregister("zoomend",this,this.moveZoomBar)},passEventToSlider:function(a){this.sliderEvents.handleBrowserEvent(a)},divClick:function(a){if(OpenLayers.Event.isLeftClick(a)){var b=a.xy.y/this.zoomStopHeight;if(this.forceFixedZoomLevel||!this.map.fractionalZoom)b=Math.floor(b);b=this.map.getNumZoomLevels()-1-b;b=Math.min(Math.max(b,0),this.map.getNumZoomLevels()-1);this.map.zoomTo(b);
OpenLayers.Event.stop(a)}},zoomBarDown:function(a){if(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a))this.map.events.on({touchmove:this.passEventToSlider,mousemove:this.passEventToSlider,mouseup:this.passEventToSlider,scope:this}),this.mouseDragStart=a.xy.clone(),this.zoomStart=a.xy.clone(),this.div.style.cursor="move",this.zoombarDiv.offsets=null,OpenLayers.Event.stop(a)},zoomBarDrag:function(a){if(this.mouseDragStart!=null){var b=this.mouseDragStart.y-a.xy.y,c=OpenLayers.Util.pagePosition(this.zoombarDiv);
if(a.clientY-c[1]>0&&a.clientY-c[1]<parseInt(this.zoombarDiv.style.height)-2)this.slider.style.top=parseInt(this.slider.style.top)-b+"px",this.mouseDragStart=a.xy.clone();this.deltaY=this.zoomStart.y-a.xy.y;OpenLayers.Event.stop(a)}},zoomBarUp:function(a){if((OpenLayers.Event.isLeftClick(a)||a.type==="touchend")&&this.mouseDragStart){this.div.style.cursor="";this.map.events.un({touchmove:this.passEventToSlider,mouseup:this.passEventToSlider,mousemove:this.passEventToSlider,scope:this});var b=this.map.zoom;
!this.forceFixedZoomLevel&&this.map.fractionalZoom?(b+=this.deltaY/this.zoomStopHeight,b=Math.min(Math.max(b,0),this.map.getNumZoomLevels()-1)):(b+=this.deltaY/this.zoomStopHeight,b=Math.max(Math.round(b),0));this.map.zoomTo(b);this.zoomStart=this.mouseDragStart=null;this.deltaY=0;OpenLayers.Event.stop(a)}},moveZoomBar:function(){this.slider.style.top=(this.map.getNumZoomLevels()-1-this.map.getZoom())*this.zoomStopHeight+this.startTop+1+"px"},CLASS_NAME:"OpenLayers.Control.PanZoomBar"});
OpenLayers.Format=OpenLayers.Class({options:null,externalProjection:null,internalProjection:null,data:null,keepData:!1,initialize:function(a){OpenLayers.Util.extend(this,a);this.options=a},destroy:function(){},read:function(){OpenLayers.Console.userError(OpenLayers.i18n("readNotImplemented"))},write:function(){OpenLayers.Console.userError(OpenLayers.i18n("writeNotImplemented"))},CLASS_NAME:"OpenLayers.Format"});
OpenLayers.Feature=OpenLayers.Class({layer:null,id:null,lonlat:null,data:null,marker:null,popupClass:null,popup:null,initialize:function(a,b,c){this.layer=a;this.lonlat=b;this.data=c!=null?c:{};this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){this.layer!=null&&this.layer.map!=null&&this.popup!=null&&this.layer.map.removePopup(this.popup);this.layer!=null&&this.marker!=null&&this.layer.removeMarker(this.marker);this.data=this.lonlat=this.id=this.layer=null;if(this.marker!=
null)this.destroyMarker(this.marker),this.marker=null;if(this.popup!=null)this.destroyPopup(this.popup),this.popup=null},onScreen:function(){var a=!1;this.layer!=null&&this.layer.map!=null&&(a=this.layer.map.getExtent().containsLonLat(this.lonlat));return a},createMarker:function(){if(this.lonlat!=null)this.marker=new OpenLayers.Marker(this.lonlat,this.data.icon);return this.marker},destroyMarker:function(){this.marker.destroy()},createPopup:function(a){if(this.lonlat!=null){if(!this.popup)this.popup=
new (this.popupClass?this.popupClass:OpenLayers.Popup.AnchoredBubble)(this.id+"_popup",this.lonlat,this.data.popupSize,this.data.popupContentHTML,this.marker?this.marker.icon:null,a);if(this.data.overflow!=null)this.popup.contentDiv.style.overflow=this.data.overflow;this.popup.feature=this}return this.popup},destroyPopup:function(){if(this.popup)this.popup.feature=null,this.popup.destroy(),this.popup=null},CLASS_NAME:"OpenLayers.Feature"});
OpenLayers.State={UNKNOWN:"Unknown",INSERT:"Insert",UPDATE:"Update",DELETE:"Delete"};
OpenLayers.Feature.Vector=OpenLayers.Class(OpenLayers.Feature,{fid:null,geometry:null,attributes:null,bounds:null,state:null,style:null,url:null,renderIntent:"default",modified:null,initialize:function(a,b,c){OpenLayers.Feature.prototype.initialize.apply(this,[null,null,b]);this.lonlat=null;this.geometry=a?a:null;this.state=null;this.attributes={};if(b)this.attributes=OpenLayers.Util.extend(this.attributes,b);this.style=c?c:null},destroy:function(){if(this.layer)this.layer.removeFeatures(this),this.layer=
null;this.modified=this.geometry=null;OpenLayers.Feature.prototype.destroy.apply(this,arguments)},clone:function(){return new OpenLayers.Feature.Vector(this.geometry?this.geometry.clone():null,this.attributes,this.style)},onScreen:function(a){var b=!1;this.layer&&this.layer.map&&(b=this.layer.map.getExtent(),a?(a=this.geometry.getBounds(),b=b.intersectsBounds(a)):b=b.toGeometry().intersects(this.geometry));return b},getVisibility:function(){return!(this.style&&this.style.display=="none"||!this.layer||
this.layer&&this.layer.styleMap&&this.layer.styleMap.createSymbolizer(this,this.renderIntent).display=="none"||this.layer&&!this.layer.getVisibility())},createMarker:function(){return null},destroyMarker:function(){},createPopup:function(){return null},atPoint:function(a,b,c){var d=!1;this.geometry&&(d=this.geometry.atPoint(a,b,c));return d},destroyPopup:function(){},move:function(a){if(this.layer&&this.geometry.move){var a=a.CLASS_NAME=="OpenLayers.LonLat"?this.layer.getViewPortPxFromLonLat(a):a,
b=this.layer.getViewPortPxFromLonLat(this.geometry.getBounds().getCenterLonLat()),c=this.layer.map.getResolution();this.geometry.move(c*(a.x-b.x),c*(b.y-a.y));this.layer.drawFeature(this);return b}},toState:function(a){if(a==OpenLayers.State.UPDATE)switch(this.state){case OpenLayers.State.UNKNOWN:case OpenLayers.State.DELETE:this.state=a}else if(a==OpenLayers.State.INSERT)switch(this.state){case OpenLayers.State.UNKNOWN:break;default:this.state=a}else if(a==OpenLayers.State.DELETE)switch(this.state){case OpenLayers.State.UNKNOWN:case OpenLayers.State.UPDATE:this.state=
a}else if(a==OpenLayers.State.UNKNOWN)this.state=a},CLASS_NAME:"OpenLayers.Feature.Vector"});
OpenLayers.Feature.Vector.style={"default":{fillColor:"#ee9900",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"#ee9900",strokeOpacity:1,strokeWidth:1,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},select:{fillColor:"blue",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"blue",strokeOpacity:1,
strokeWidth:2,strokeLinecap:"round",strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"pointer"},temporary:{fillColor:"#66cccc",fillOpacity:0.2,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"#66cccc",strokeOpacity:1,strokeLinecap:"round",strokeWidth:2,strokeDashstyle:"solid",hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,
hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"inherit"},"delete":{display:"none"}};
OpenLayers.Format.WKT=OpenLayers.Class(OpenLayers.Format,{initialize:function(a){this.regExes={typeStr:/^\s*(\w+)\s*\(\s*(.*)\s*\)\s*$/,spaces:/\s+/,parenComma:/\)\s*,\s*\(/,doubleParenComma:/\)\s*\)\s*,\s*\(\s*\(/,trimParens:/^\s*\(?(.*?)\)?\s*$/};OpenLayers.Format.prototype.initialize.apply(this,[a])},read:function(a){var b,c,a=a.replace(/[\n\r]/g," ");if(c=this.regExes.typeStr.exec(a))if(a=c[1].toLowerCase(),c=c[2],this.parse[a]&&(b=this.parse[a].apply(this,[c])),this.internalProjection&&this.externalProjection)if(b&&
b.CLASS_NAME=="OpenLayers.Feature.Vector")b.geometry.transform(this.externalProjection,this.internalProjection);else if(b&&a!="geometrycollection"&&typeof b=="object"){a=0;for(c=b.length;a<c;a++)b[a].geometry.transform(this.externalProjection,this.internalProjection)}return b},write:function(a){var b,c;a.constructor==Array?c=!0:(a=[a],c=!1);var d=[];c&&d.push("GEOMETRYCOLLECTION(");for(var e=0,f=a.length;e<f;++e)c&&e>0&&d.push(","),b=a[e].geometry,d.push(this.extractGeometry(b));c&&d.push(")");return d.join("")},
extractGeometry:function(a){var b=a.CLASS_NAME.split(".")[2].toLowerCase();if(!this.extract[b])return null;this.internalProjection&&this.externalProjection&&(a=a.clone(),a.transform(this.internalProjection,this.externalProjection));return(b=="collection"?"GEOMETRYCOLLECTION":b.toUpperCase())+"("+this.extract[b].apply(this,[a])+")"},extract:{point:function(a){return a.x+" "+a.y},multipoint:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.point.apply(this,[a.components[c]])+
")");return b.join(",")},linestring:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extract.point.apply(this,[a.components[c]]));return b.join(",")},multilinestring:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.linestring.apply(this,[a.components[c]])+")");return b.join(",")},polygon:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.linestring.apply(this,[a.components[c]])+")");return b.join(",")},multipolygon:function(a){for(var b=
[],c=0,d=a.components.length;c<d;++c)b.push("("+this.extract.polygon.apply(this,[a.components[c]])+")");return b.join(",")},collection:function(a){for(var b=[],c=0,d=a.components.length;c<d;++c)b.push(this.extractGeometry.apply(this,[a.components[c]]));return b.join(",")}},parse:{point:function(a){a=OpenLayers.String.trim(a).split(this.regExes.spaces);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(a[0],a[1]))},multipoint:function(a){for(var b=OpenLayers.String.trim(a).split(","),
c=[],d=0,e=b.length;d<e;++d)a=b[d].replace(this.regExes.trimParens,"$1"),c.push(this.parse.point.apply(this,[a]).geometry);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiPoint(c))},linestring:function(a){for(var a=OpenLayers.String.trim(a).split(","),b=[],c=0,d=a.length;c<d;++c)b.push(this.parse.point.apply(this,[a[c]]).geometry);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LineString(b))},multilinestring:function(a){for(var b=OpenLayers.String.trim(a).split(this.regExes.parenComma),
c=[],d=0,e=b.length;d<e;++d)a=b[d].replace(this.regExes.trimParens,"$1"),c.push(this.parse.linestring.apply(this,[a]).geometry);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiLineString(c))},polygon:function(a){for(var b,a=OpenLayers.String.trim(a).split(this.regExes.parenComma),c=[],d=0,e=a.length;d<e;++d)b=a[d].replace(this.regExes.trimParens,"$1"),b=this.parse.linestring.apply(this,[b]).geometry,b=new OpenLayers.Geometry.LinearRing(b.components),c.push(b);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Polygon(c))},
multipolygon:function(a){for(var b=OpenLayers.String.trim(a).split(this.regExes.doubleParenComma),c=[],d=0,e=b.length;d<e;++d)a=b[d].replace(this.regExes.trimParens,"$1"),c.push(this.parse.polygon.apply(this,[a]).geometry);return new OpenLayers.Feature.Vector(new OpenLayers.Geometry.MultiPolygon(c))},geometrycollection:function(a){for(var a=a.replace(/,\s*([A-Za-z])/g,"|$1"),a=OpenLayers.String.trim(a).split("|"),b=[],c=0,d=a.length;c<d;++c)b.push(OpenLayers.Format.WKT.prototype.read.apply(this,[a[c]]));
return b}},CLASS_NAME:"OpenLayers.Format.WKT"});
OpenLayers.Geometry=OpenLayers.Class({id:null,parent:null,bounds:null,initialize:function(){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){this.bounds=this.id=null},clone:function(){return new OpenLayers.Geometry},setBounds:function(a){if(a)this.bounds=a.clone()},clearBounds:function(){this.bounds=null;this.parent&&this.parent.clearBounds()},extendBounds:function(a){this.getBounds()?this.bounds.extend(a):this.setBounds(a)},getBounds:function(){this.bounds==null&&this.calculateBounds();
return this.bounds},calculateBounds:function(){},distanceTo:function(){},getVertices:function(){},atPoint:function(a,b,c){var d=!1;this.getBounds()!=null&&a!=null&&(b=b!=null?b:0,c=c!=null?c:0,d=(new OpenLayers.Bounds(this.bounds.left-b,this.bounds.bottom-c,this.bounds.right+b,this.bounds.top+c)).containsLonLat(a));return d},getLength:function(){return 0},getArea:function(){return 0},getCentroid:function(){return null},toString:function(){return OpenLayers.Format.WKT.prototype.write(new OpenLayers.Feature.Vector(this))},
CLASS_NAME:"OpenLayers.Geometry"});OpenLayers.Geometry.fromWKT=function(a){var b=arguments.callee.format;if(!b)b=new OpenLayers.Format.WKT,arguments.callee.format=b;var c,b=b.read(a);if(b instanceof OpenLayers.Feature.Vector)c=b.geometry;else if(OpenLayers.Util.isArray(b)){c=b.length;for(var d=Array(c),e=0;e<c;++e)d[e]=b[e].geometry;c=new OpenLayers.Geometry.Collection(d)}return c};
OpenLayers.Geometry.segmentsIntersect=function(a,b,c){var d=c&&c.point,c=c&&c.tolerance,e=!1,f=a.x1-b.x1,g=a.y1-b.y1,h=a.x2-a.x1,i=a.y2-a.y1,j=b.y2-b.y1,k=b.x2-b.x1,o=j*h-k*i,j=k*g-j*f,g=h*g-i*f;o==0?j==0&&g==0&&(e=!0):(f=j/o,o=g/o,f>=0&&f<=1&&o>=0&&o<=1&&(d?(h=a.x1+f*h,o=a.y1+f*i,e=new OpenLayers.Geometry.Point(h,o)):e=!0));if(c)if(e){if(d){a=[a,b];b=0;a:for(;b<2;++b){f=a[b];for(i=1;i<3;++i)if(h=f["x"+i],o=f["y"+i],d=Math.sqrt(Math.pow(h-e.x,2)+Math.pow(o-e.y,2)),d<c){e.x=h;e.y=o;break a}}}}else{a=
[a,b];b=0;a:for(;b<2;++b){h=a[b];o=a[(b+1)%2];for(i=1;i<3;++i)if(f={x:h["x"+i],y:h["y"+i]},g=OpenLayers.Geometry.distanceToSegment(f,o),g.distance<c){e=d?new OpenLayers.Geometry.Point(f.x,f.y):!0;break a}}}return e};OpenLayers.Geometry.distanceToSegment=function(a,b){var c=a.x,d=a.y,e=b.x1,f=b.y1,g=b.x2,h=b.y2,i=g-e,j=h-f,k=(i*(c-e)+j*(d-f))/(Math.pow(i,2)+Math.pow(j,2));k<=0||(k>=1?(e=g,f=h):(e+=k*i,f+=k*j));return{distance:Math.sqrt(Math.pow(e-c,2)+Math.pow(f-d,2)),x:e,y:f}};
OpenLayers.Geometry.Collection=OpenLayers.Class(OpenLayers.Geometry,{components:null,componentTypes:null,initialize:function(a){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.components=[];a!=null&&this.addComponents(a)},destroy:function(){this.components.length=0;this.components=null;OpenLayers.Geometry.prototype.destroy.apply(this,arguments)},clone:function(){for(var a=eval("new "+this.CLASS_NAME+"()"),b=0,c=this.components.length;b<c;b++)a.addComponent(this.components[b].clone());
OpenLayers.Util.applyDefaults(a,this);return a},getComponentsString:function(){for(var a=[],b=0,c=this.components.length;b<c;b++)a.push(this.components[b].toShortString());return a.join(",")},calculateBounds:function(){this.bounds=null;var a=new OpenLayers.Bounds,b=this.components;if(b)for(var c=0,d=b.length;c<d;c++)a.extend(b[c].getBounds());a.left!=null&&a.bottom!=null&&a.right!=null&&a.top!=null&&this.setBounds(a)},addComponents:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<
c;b++)this.addComponent(a[b])},addComponent:function(a,b){var c=!1;if(a&&(this.componentTypes==null||OpenLayers.Util.indexOf(this.componentTypes,a.CLASS_NAME)>-1)){if(b!=null&&b<this.components.length){var c=this.components.slice(0,b),d=this.components.slice(b,this.components.length);c.push(a);this.components=c.concat(d)}else this.components.push(a);a.parent=this;this.clearBounds();c=!0}return c},removeComponents:function(a){var b=!1;OpenLayers.Util.isArray(a)||(a=[a]);for(var c=a.length-1;c>=0;--c)b=
this.removeComponent(a[c])||b;return b},removeComponent:function(a){OpenLayers.Util.removeItem(this.components,a);this.clearBounds();return!0},getLength:function(){for(var a=0,b=0,c=this.components.length;b<c;b++)a+=this.components[b].getLength();return a},getArea:function(){for(var a=0,b=0,c=this.components.length;b<c;b++)a+=this.components[b].getArea();return a},getGeodesicArea:function(a){for(var b=0,c=0,d=this.components.length;c<d;c++)b+=this.components[c].getGeodesicArea(a);return b},getCentroid:function(a){if(!a)return this.components.length&&
this.components[0].getCentroid();a=this.components.length;if(!a)return!1;for(var b=[],c=[],d=0,e=Number.MAX_VALUE,f,g=0;g<a;++g){f=this.components[g];var h=f.getArea();f=f.getCentroid(!0);!isNaN(h)&&!isNaN(f.x)&&!isNaN(f.y)&&(b.push(h),d+=h,e=h<e&&h>0?h:e,c.push(f))}a=b.length;if(d===0){for(g=0;g<a;++g)b[g]=1;d=b.length}else{for(g=0;g<a;++g)b[g]/=e;d/=e}for(var i=e=0,g=0;g<a;++g)f=c[g],h=b[g],e+=f.x*h,i+=f.y*h;return new OpenLayers.Geometry.Point(e/d,i/d)},getGeodesicLength:function(a){for(var b=
0,c=0,d=this.components.length;c<d;c++)b+=this.components[c].getGeodesicLength(a);return b},move:function(a,b){for(var c=0,d=this.components.length;c<d;c++)this.components[c].move(a,b)},rotate:function(a,b){for(var c=0,d=this.components.length;c<d;++c)this.components[c].rotate(a,b)},resize:function(a,b,c){for(var d=0;d<this.components.length;++d)this.components[d].resize(a,b,c);return this},distanceTo:function(a,b){for(var c=!(b&&b.edge===!1)&&b&&b.details,d,e,f,g=Number.POSITIVE_INFINITY,h=0,i=this.components.length;h<
i;++h)if(d=this.components[h].distanceTo(a,b),f=c?d.distance:d,f<g&&(g=f,e=d,g==0))break;return e},equals:function(a){var b=!0;if(!a||!a.CLASS_NAME||this.CLASS_NAME!=a.CLASS_NAME)b=!1;else if(!OpenLayers.Util.isArray(a.components)||a.components.length!=this.components.length)b=!1;else for(var c=0,d=this.components.length;c<d;++c)if(!this.components[c].equals(a.components[c])){b=!1;break}return b},transform:function(a,b){if(a&&b){for(var c=0,d=this.components.length;c<d;c++)this.components[c].transform(a,
b);this.bounds=null}return this},intersects:function(a){for(var b=!1,c=0,d=this.components.length;c<d;++c)if(b=a.intersects(this.components[c]))break;return b},getVertices:function(a){for(var b=[],c=0,d=this.components.length;c<d;++c)Array.prototype.push.apply(b,this.components[c].getVertices(a));return b},CLASS_NAME:"OpenLayers.Geometry.Collection"});
OpenLayers.Geometry.Point=OpenLayers.Class(OpenLayers.Geometry,{x:null,y:null,initialize:function(a,b){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.x=parseFloat(a);this.y=parseFloat(b)},clone:function(a){a==null&&(a=new OpenLayers.Geometry.Point(this.x,this.y));OpenLayers.Util.applyDefaults(a,this);return a},calculateBounds:function(){this.bounds=new OpenLayers.Bounds(this.x,this.y,this.x,this.y)},distanceTo:function(a,b){var c=!(b&&b.edge===!1)&&b&&b.details,d,e,f,g,h;a instanceof
OpenLayers.Geometry.Point?(e=this.x,f=this.y,g=a.x,h=a.y,d=Math.sqrt(Math.pow(e-g,2)+Math.pow(f-h,2)),d=!c?d:{x0:e,y0:f,x1:g,y1:h,distance:d}):(d=a.distanceTo(this,b),c&&(d={x0:d.x1,y0:d.y1,x1:d.x0,y1:d.y0,distance:d.distance}));return d},equals:function(a){var b=!1;a!=null&&(b=this.x==a.x&&this.y==a.y||isNaN(this.x)&&isNaN(this.y)&&isNaN(a.x)&&isNaN(a.y));return b},toShortString:function(){return this.x+", "+this.y},move:function(a,b){this.x+=a;this.y+=b;this.clearBounds()},rotate:function(a,b){a*=
Math.PI/180;var c=this.distanceTo(b),d=a+Math.atan2(this.y-b.y,this.x-b.x);this.x=b.x+c*Math.cos(d);this.y=b.y+c*Math.sin(d);this.clearBounds()},getCentroid:function(){return new OpenLayers.Geometry.Point(this.x,this.y)},resize:function(a,b,c){this.x=b.x+a*(c==void 0?1:c)*(this.x-b.x);this.y=b.y+a*(this.y-b.y);this.clearBounds();return this},intersects:function(a){var b=!1;return b=a.CLASS_NAME=="OpenLayers.Geometry.Point"?this.equals(a):a.intersects(this)},transform:function(a,b){if(a&&b)OpenLayers.Projection.transform(this,
a,b),this.bounds=null;return this},getVertices:function(){return[this]},CLASS_NAME:"OpenLayers.Geometry.Point"});OpenLayers.Geometry.MultiPoint=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(a){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},addPoint:function(a,b){this.addComponent(a,b)},removePoint:function(a){this.removeComponent(a)},CLASS_NAME:"OpenLayers.Geometry.MultiPoint"});
OpenLayers.Geometry.Curve=OpenLayers.Class(OpenLayers.Geometry.MultiPoint,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(a){OpenLayers.Geometry.MultiPoint.prototype.initialize.apply(this,arguments)},getLength:function(){var a=0;if(this.components&&this.components.length>1)for(var b=1,c=this.components.length;b<c;b++)a+=this.components[b-1].distanceTo(this.components[b]);return a},getGeodesicLength:function(a){var b=this;if(a){var c=new OpenLayers.Projection("EPSG:4326");c.equals(a)||
(b=this.clone().transform(a,c))}a=0;if(b.components&&b.components.length>1)for(var d,e=1,f=b.components.length;e<f;e++)c=b.components[e-1],d=b.components[e],a+=OpenLayers.Util.distVincenty({lon:c.x,lat:c.y},{lon:d.x,lat:d.y});return a*1E3},CLASS_NAME:"OpenLayers.Geometry.Curve"});
OpenLayers.Geometry.LineString=OpenLayers.Class(OpenLayers.Geometry.Curve,{initialize:function(a){OpenLayers.Geometry.Curve.prototype.initialize.apply(this,arguments)},removeComponent:function(a){var b=this.components&&this.components.length>2;b&&OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments);return b},intersects:function(a){var b=!1,c=a.CLASS_NAME;if(c=="OpenLayers.Geometry.LineString"||c=="OpenLayers.Geometry.LinearRing"||c=="OpenLayers.Geometry.Point"){var d=this.getSortedSegments(),
a=c=="OpenLayers.Geometry.Point"?[{x1:a.x,y1:a.y,x2:a.x,y2:a.y}]:a.getSortedSegments(),e,f,g,h,i,j,k,o=0,n=d.length;a:for(;o<n;++o){c=d[o];e=c.x1;f=c.x2;g=c.y1;h=c.y2;var l=0,m=a.length;for(;l<m;++l){i=a[l];if(i.x1>f)break;if(!(i.x2<e)&&(j=i.y1,k=i.y2,!(Math.min(j,k)>Math.max(g,h))&&!(Math.max(j,k)<Math.min(g,h))&&OpenLayers.Geometry.segmentsIntersect(c,i))){b=!0;break a}}}}else b=a.intersects(this);return b},getSortedSegments:function(){for(var a=this.components.length-1,b=Array(a),c,d,e=0;e<a;++e)c=
this.components[e],d=this.components[e+1],b[e]=c.x<d.x?{x1:c.x,y1:c.y,x2:d.x,y2:d.y}:{x1:d.x,y1:d.y,x2:c.x,y2:c.y};return b.sort(function(a,b){return a.x1-b.x1})},splitWithSegment:function(a,b){for(var c=!(b&&b.edge===!1),d=b&&b.tolerance,e=[],f=this.getVertices(),g=[],h=[],i=!1,j,k,o,n={point:!0,tolerance:d},l=null,m=0,q=f.length-2;m<=q;++m)if(d=f[m],g.push(d.clone()),j=f[m+1],k={x1:d.x,y1:d.y,x2:j.x,y2:j.y},k=OpenLayers.Geometry.segmentsIntersect(a,k,n),k instanceof OpenLayers.Geometry.Point&&((o=
k.x===a.x1&&k.y===a.y1||k.x===a.x2&&k.y===a.y2||k.equals(d)||k.equals(j)?!0:!1)||c))k.equals(h[h.length-1])||h.push(k.clone()),!(m===0&&k.equals(d))&&!k.equals(j)&&(i=!0,k.equals(d)||g.push(k),e.push(new OpenLayers.Geometry.LineString(g)),g=[k.clone()]);i&&(g.push(j.clone()),e.push(new OpenLayers.Geometry.LineString(g)));if(h.length>0)var p=a.x1<a.x2?1:-1,r=a.y1<a.y2?1:-1,l={lines:e,points:h.sort(function(a,b){return p*a.x-p*b.x||r*a.y-r*b.y})};return l},split:function(a,b){var c=null,d=b&&b.mutual,
e,f,g,h;if(a instanceof OpenLayers.Geometry.LineString){var i=this.getVertices(),j,k,o,n,l,m=[];g=[];for(var q=0,p=i.length-2;q<=p;++q){j=i[q];k=i[q+1];o={x1:j.x,y1:j.y,x2:k.x,y2:k.y};h=h||[a];d&&m.push(j.clone());for(var r=0;r<h.length;++r)if(n=h[r].splitWithSegment(o,b))if(l=n.lines,l.length>0&&(l.unshift(r,1),Array.prototype.splice.apply(h,l),r+=l.length-2),d)for(var s=0,t=n.points.length;s<t;++s)l=n.points[s],l.equals(j)||(m.push(l),g.push(new OpenLayers.Geometry.LineString(m)),m=l.equals(k)?
[]:[l.clone()])}d&&g.length>0&&m.length>0&&(m.push(k.clone()),g.push(new OpenLayers.Geometry.LineString(m)))}else c=a.splitWith(this,b);h&&h.length>1?f=!0:h=[];g&&g.length>1?e=!0:g=[];if(f||e)c=d?[g,h]:h;return c},splitWith:function(a,b){return a.split(this,b)},getVertices:function(a){return a===!0?[this.components[0],this.components[this.components.length-1]]:a===!1?this.components.slice(1,this.components.length-1):this.components.slice()},distanceTo:function(a,b){var c=!(b&&b.edge===!1)&&b&&b.details,
d,e={},f=Number.POSITIVE_INFINITY;if(a instanceof OpenLayers.Geometry.Point){for(var g=this.getSortedSegments(),h=a.x,i=a.y,j,k=0,o=g.length;k<o;++k)if(j=g[k],d=OpenLayers.Geometry.distanceToSegment(a,j),d.distance<f){if(f=d.distance,e=d,f===0)break}else if(j.x2>h&&(i>j.y1&&i<j.y2||i<j.y1&&i>j.y2))break;e=c?{distance:e.distance,x0:e.x,y0:e.y,x1:h,y1:i}:e.distance}else if(a instanceof OpenLayers.Geometry.LineString){var g=this.getSortedSegments(),h=a.getSortedSegments(),n,l,m=h.length,q={point:!0},
k=0,o=g.length;a:for(;k<o;++k){i=g[k];j=i.x1;l=i.y1;for(var p=0;p<m;++p)if(d=h[p],n=OpenLayers.Geometry.segmentsIntersect(i,d,q)){f=0;e={distance:0,x0:n.x,y0:n.y,x1:n.x,y1:n.y};break a}else if(d=OpenLayers.Geometry.distanceToSegment({x:j,y:l},d),d.distance<f)f=d.distance,e={distance:f,x0:j,y0:l,x1:d.x,y1:d.y}}if(!c)e=e.distance;f!==0&&i&&(d=a.distanceTo(new OpenLayers.Geometry.Point(i.x2,i.y2),b),k=c?d.distance:d,k<f&&(e=c?{distance:f,x0:d.x1,y0:d.y1,x1:d.x0,y1:d.y0}:k))}else e=a.distanceTo(this,
b),c&&(e={distance:e.distance,x0:e.x1,y0:e.y1,x1:e.x0,y1:e.y0});return e},simplify:function(a){if(this&&this!==null){var b=this.getVertices();if(b.length<3)return this;var c=function(a,b,d,i){for(var j=0,k=0,o=b,n;o<d;o++){n=a[b];var l=a[d],m=a[o],m=Math.abs(0.5*(n.x*l.y+l.x*m.y+m.x*n.y-l.x*n.y-m.x*l.y-n.x*m.y));n=Math.sqrt(Math.pow(n.x-l.x,2)+Math.pow(n.y-l.y,2));n=m/n*2;n>j&&(j=n,k=o)}j>i&&k!=b&&(e.push(k),c(a,b,k,i),c(a,k,d,i))},d=b.length-1,e=[];e.push(0);for(e.push(d);b[0].equals(b[d]);)d--,
e.push(d);c(b,0,d,a);a=[];e.sort(function(a,b){return a-b});for(d=0;d<e.length;d++)a.push(b[e[d]]);return new OpenLayers.Geometry.LineString(a)}else return this},CLASS_NAME:"OpenLayers.Geometry.LineString"});
OpenLayers.Geometry.LinearRing=OpenLayers.Class(OpenLayers.Geometry.LineString,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(a){OpenLayers.Geometry.LineString.prototype.initialize.apply(this,arguments)},addComponent:function(a,b){var c=!1,d=this.components.pop();if(b!=null||!a.equals(d))c=OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,arguments);OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[this.components[0]]);return c},removeComponent:function(a){var b=
this.components&&this.components.length>3;b&&(this.components.pop(),OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments),OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[this.components[0]]));return b},move:function(a,b){for(var c=0,d=this.components.length;c<d-1;c++)this.components[c].move(a,b)},rotate:function(a,b){for(var c=0,d=this.components.length;c<d-1;++c)this.components[c].rotate(a,b)},resize:function(a,b,c){for(var d=0,e=this.components.length;d<
e-1;++d)this.components[d].resize(a,b,c);return this},transform:function(a,b){if(a&&b){for(var c=0,d=this.components.length;c<d-1;c++)this.components[c].transform(a,b);this.bounds=null}return this},getCentroid:function(){if(this.components&&this.components.length>2){for(var a=0,b=0,c=0;c<this.components.length-1;c++){var d=this.components[c],e=this.components[c+1];a+=(d.x+e.x)*(d.x*e.y-e.x*d.y);b+=(d.y+e.y)*(d.x*e.y-e.x*d.y)}c=-1*this.getArea();return new OpenLayers.Geometry.Point(a/(6*c),b/(6*c))}else return null},
getArea:function(){var a=0;if(this.components&&this.components.length>2){for(var b=a=0,c=this.components.length;b<c-1;b++){var d=this.components[b],e=this.components[b+1];a+=(d.x+e.x)*(e.y-d.y)}a=-a/2}return a},getGeodesicArea:function(a){var b=this;if(a){var c=new OpenLayers.Projection("EPSG:4326");c.equals(a)||(b=this.clone().transform(a,c))}a=0;c=b.components&&b.components.length;if(c>2){for(var d,e,f=0;f<c-1;f++)d=b.components[f],e=b.components[f+1],a+=OpenLayers.Util.rad(e.x-d.x)*(2+Math.sin(OpenLayers.Util.rad(d.y))+
Math.sin(OpenLayers.Util.rad(e.y)));a=a*40680631590769/2}return a},containsPoint:function(a){for(var b=OpenLayers.Number.limitSigDigs,c=b(a.x,14),a=b(a.y,14),d=this.components.length-1,e,f,g,h,i,j=0,k=0;k<d;++k)if(e=this.components[k],g=b(e.x,14),e=b(e.y,14),f=this.components[k+1],h=b(f.x,14),f=b(f.y,14),e==f){if(a==e&&(g<=h&&c>=g&&c<=h||g>=h&&c<=g&&c>=h)){j=-1;break}}else{i=b(((g-h)*a+(h*e-g*f))/(e-f),14);if(i==c&&(e<f&&a>=e&&a<=f||e>f&&a<=e&&a>=f)){j=-1;break}i<=c||g!=h&&(i<Math.min(g,h)||i>Math.max(g,
h))||(e<f&&a>=e&&a<f||e>f&&a<e&&a>=f)&&++j}return j==-1?1:!!(j&1)},intersects:function(a){var b=!1;if(a.CLASS_NAME=="OpenLayers.Geometry.Point")b=this.containsPoint(a);else if(a.CLASS_NAME=="OpenLayers.Geometry.LineString")b=a.intersects(this);else if(a.CLASS_NAME=="OpenLayers.Geometry.LinearRing")b=OpenLayers.Geometry.LineString.prototype.intersects.apply(this,[a]);else for(var c=0,d=a.components.length;c<d;++c)if(b=a.components[c].intersects(this))break;return b},getVertices:function(a){return a===
!0?[]:this.components.slice(0,this.components.length-1)},CLASS_NAME:"OpenLayers.Geometry.LinearRing"});
OpenLayers.Renderer=OpenLayers.Class({container:null,root:null,extent:null,locked:!1,size:null,resolution:null,map:null,initialize:function(a,b){this.container=OpenLayers.Util.getElement(a);OpenLayers.Util.extend(this,b)},destroy:function(){this.map=this.resolution=this.size=this.extent=this.container=null},supported:function(){return!1},setExtent:function(a,b){this.extent=a.clone();if(b)this.resolution=null},setSize:function(a){this.size=a.clone();this.resolution=null},getResolution:function(){return this.resolution=
this.resolution||this.map.getResolution()},drawFeature:function(a,b){if(b==null)b=a.style;if(a.geometry){var c=a.geometry.getBounds();if(c){c.intersectsBounds(this.extent)||(b={display:"none"});c=this.drawGeometry(a.geometry,b,a.id);if(b.display!="none"&&b.label&&c!==!1){var d=a.geometry.getCentroid();if(b.labelXOffset||b.labelYOffset){var e=isNaN(b.labelXOffset)?0:b.labelXOffset,f=isNaN(b.labelYOffset)?0:b.labelYOffset,g=this.getResolution();d.move(e*g,f*g)}this.drawText(a.id,b,d)}else this.removeText(a.id);
return c}}},drawGeometry:function(){},drawText:function(){},removeText:function(){},clear:function(){},getFeatureIdFromEvent:function(){},eraseFeatures:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0,c=a.length;b<c;++b){var d=a[b];this.eraseGeometry(d.geometry,d.id);this.removeText(d.id)}},eraseGeometry:function(){},moveRoot:function(){},getRenderLayerId:function(){return this.container.id},applyDefaultSymbolizer:function(a){var b=OpenLayers.Util.extend({},OpenLayers.Renderer.defaultSymbolizer);
a.stroke===!1&&(delete b.strokeWidth,delete b.strokeColor);a.fill===!1&&delete b.fillColor;OpenLayers.Util.extend(b,a);return b},CLASS_NAME:"OpenLayers.Renderer"});OpenLayers.Renderer.defaultSymbolizer={fillColor:"#000000",strokeColor:"#000000",strokeWidth:2,fillOpacity:1,strokeOpacity:1,pointRadius:0};
OpenLayers.Renderer.Canvas=OpenLayers.Class(OpenLayers.Renderer,{hitDetection:!0,hitOverflow:0,canvas:null,features:null,pendingRedraw:!1,initialize:function(a,b){OpenLayers.Renderer.prototype.initialize.apply(this,arguments);this.root=document.createElement("canvas");this.container.appendChild(this.root);this.canvas=this.root.getContext("2d");this.features={};if(this.hitDetection)this.hitCanvas=document.createElement("canvas"),this.hitContext=this.hitCanvas.getContext("2d")},eraseGeometry:function(a,
b){this.eraseFeatures(this.features[b][0])},supported:function(){return!!document.createElement("canvas").getContext},setSize:function(a){this.size=a.clone();var b=this.root;b.style.width=a.w+"px";b.style.height=a.h+"px";b.width=a.w;b.height=a.h;this.resolution=null;if(this.hitDetection)b=this.hitCanvas,b.style.width=a.w+"px",b.style.height=a.h+"px",b.width=a.w,b.height=a.h},drawFeature:function(a,b){var c;if(a.geometry)b=this.applyDefaultSymbolizer(b||a.style),c=a.geometry.getBounds(),(c=b.display!==
"none"&&!!c&&c.intersectsBounds(this.extent))?this.features[a.id]=[a,b]:delete this.features[a.id],this.pendingRedraw=!0;if(this.pendingRedraw&&!this.locked)this.redraw(),this.pendingRedraw=!1;return c},drawGeometry:function(a,b,c){var d=a.CLASS_NAME;if(d=="OpenLayers.Geometry.Collection"||d=="OpenLayers.Geometry.MultiPoint"||d=="OpenLayers.Geometry.MultiLineString"||d=="OpenLayers.Geometry.MultiPolygon")for(d=0;d<a.components.length;d++)this.drawGeometry(a.components[d],b,c);else switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":this.drawPoint(a,
b,c);break;case "OpenLayers.Geometry.LineString":this.drawLineString(a,b,c);break;case "OpenLayers.Geometry.LinearRing":this.drawLinearRing(a,b,c);break;case "OpenLayers.Geometry.Polygon":this.drawPolygon(a,b,c)}},drawExternalGraphic:function(a,b,c){var d=new Image;if(b.graphicTitle)d.title=b.graphicTitle;var e=b.graphicWidth||b.graphicHeight,f=b.graphicHeight||b.graphicWidth,e=e?e:b.pointRadius*2,f=f?f:b.pointRadius*2,g=b.graphicXOffset!=void 0?b.graphicXOffset:-(0.5*e),h=b.graphicYOffset!=void 0?
b.graphicYOffset:-(0.5*f),i=b.graphicOpacity||b.fillOpacity;d.onload=OpenLayers.Function.bind(function(){if(this.features[c]){var b=this.getLocalXY(a),k=b[0],b=b[1];if(!isNaN(k)&&!isNaN(b)){var k=k+g|0,b=b+h|0,o=this.canvas;o.globalAlpha=i;var n=OpenLayers.Renderer.Canvas.drawImageScaleFactor||(OpenLayers.Renderer.Canvas.drawImageScaleFactor=/android 2.1/.test(navigator.userAgent.toLowerCase())?320/window.screen.width:1);o.drawImage(d,k*n,b*n,e*n,f*n);this.hitDetection&&(this.setHitContextStyle("fill",
c),this.hitContext.fillRect(k,b,e,f))}}},this);d.src=b.externalGraphic},setCanvasStyle:function(a,b){a==="fill"?(this.canvas.globalAlpha=b.fillOpacity,this.canvas.fillStyle=b.fillColor):a==="stroke"?(this.canvas.globalAlpha=b.strokeOpacity,this.canvas.strokeStyle=b.strokeColor,this.canvas.lineWidth=b.strokeWidth):(this.canvas.globalAlpha=0,this.canvas.lineWidth=1)},featureIdToHex:function(a){a=Number(a.split("_").pop())+1;if(a>=16777216)this.hitOverflow=a-16777215,a=a%16777216+1;var a="000000"+a.toString(16),
b=a.length;return a="#"+a.substring(b-6,b)},setHitContextStyle:function(a,b,c){b=this.featureIdToHex(b);a=="fill"?(this.hitContext.globalAlpha=1,this.hitContext.fillStyle=b):a=="stroke"?(this.hitContext.globalAlpha=1,this.hitContext.strokeStyle=b,this.hitContext.lineWidth=c.strokeWidth+2):(this.hitContext.globalAlpha=0,this.hitContext.lineWidth=1)},drawPoint:function(a,b,c){if(b.graphic!==!1)if(b.externalGraphic)this.drawExternalGraphic(a,b,c);else{var d=this.getLocalXY(a),a=d[0],d=d[1];if(!isNaN(a)&&
!isNaN(d)){var e=Math.PI*2,f=b.pointRadius;b.fill!==!1&&(this.setCanvasStyle("fill",b),this.canvas.beginPath(),this.canvas.arc(a,d,f,0,e,!0),this.canvas.fill(),this.hitDetection&&(this.setHitContextStyle("fill",c,b),this.hitContext.beginPath(),this.hitContext.arc(a,d,f,0,e,!0),this.hitContext.fill()));b.stroke!==!1&&(this.setCanvasStyle("stroke",b),this.canvas.beginPath(),this.canvas.arc(a,d,f,0,e,!0),this.canvas.stroke(),this.hitDetection&&(this.setHitContextStyle("stroke",c,b),this.hitContext.beginPath(),
this.hitContext.arc(a,d,f,0,e,!0),this.hitContext.stroke()),this.setCanvasStyle("reset"))}}},drawLineString:function(a,b,c){b=OpenLayers.Util.applyDefaults({fill:!1},b);this.drawLinearRing(a,b,c)},drawLinearRing:function(a,b,c){b.fill!==!1&&(this.setCanvasStyle("fill",b),this.renderPath(this.canvas,a,b,c,"fill"),this.hitDetection&&(this.setHitContextStyle("fill",c,b),this.renderPath(this.hitContext,a,b,c,"fill")));b.stroke!==!1&&(this.setCanvasStyle("stroke",b),this.renderPath(this.canvas,a,b,c,"stroke"),
this.hitDetection&&(this.setHitContextStyle("stroke",c,b),this.renderPath(this.hitContext,a,b,c,"stroke")));this.setCanvasStyle("reset")},renderPath:function(a,b,c,d,e){b=b.components;c=b.length;a.beginPath();var d=this.getLocalXY(b[0]),f=d[1];if(!isNaN(d[0])&&!isNaN(f)){a.moveTo(d[0],d[1]);for(d=1;d<c;++d)f=this.getLocalXY(b[d]),a.lineTo(f[0],f[1]);e==="fill"?a.fill():a.stroke()}},drawPolygon:function(a,b,c){var a=a.components,d=a.length;this.drawLinearRing(a[0],b,c);for(var e=1;e<d;++e){this.canvas.globalCompositeOperation=
"destination-out";if(this.hitDetection)this.hitContext.globalCompositeOperation="destination-out";this.drawLinearRing(a[e],OpenLayers.Util.applyDefaults({stroke:!1,fillOpacity:1},b),c);this.canvas.globalCompositeOperation="source-over";if(this.hitDetection)this.hitContext.globalCompositeOperation="source-over";this.drawLinearRing(a[e],OpenLayers.Util.applyDefaults({fill:!1},b),c)}},drawText:function(a,b){var b=OpenLayers.Util.extend({fontColor:"#000000",labelAlign:"cm"},b),c=this.getLocalXY(a);this.setCanvasStyle("reset");
this.canvas.fillStyle=b.fontColor;this.canvas.globalAlpha=b.fontOpacity||1;var d=[b.fontStyle?b.fontStyle:"normal","normal",b.fontWeight?b.fontWeight:"normal",b.fontSize?b.fontSize:"1em",b.fontFamily?b.fontFamily:"sans-serif"].join(" "),e=b.label.split("\n"),f=e.length;if(this.canvas.fillText){this.canvas.font=d;this.canvas.textAlign=OpenLayers.Renderer.Canvas.LABEL_ALIGN[b.labelAlign[0]]||"center";this.canvas.textBaseline=OpenLayers.Renderer.Canvas.LABEL_ALIGN[b.labelAlign[1]]||"middle";var g=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[1]];
g==null&&(g=-0.5);d=this.canvas.measureText("Mg").height||this.canvas.measureText("xx").width;c[1]+=d*g*(f-1);for(g=0;g<f;g++)this.canvas.fillText(e[g],c[0],c[1]+d*g)}else if(this.canvas.mozDrawText){this.canvas.mozTextStyle=d;var h=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[0]];h==null&&(h=-0.5);g=OpenLayers.Renderer.Canvas.LABEL_FACTOR[b.labelAlign[1]];g==null&&(g=-0.5);d=this.canvas.mozMeasureText("xx");c[1]+=d*(1+g*f);for(g=0;g<f;g++){var i=c[0]+h*this.canvas.mozMeasureText(e[g]),j=
c[1]+g*d;this.canvas.translate(i,j);this.canvas.mozDrawText(e[g]);this.canvas.translate(-i,-j)}}this.setCanvasStyle("reset")},getLocalXY:function(a){var b=this.getResolution(),c=this.extent;return[a.x/b+-c.left/b,c.top/b-a.y/b]},clear:function(){var a=this.root.height,b=this.root.width;this.canvas.clearRect(0,0,b,a);this.features={};this.hitDetection&&this.hitContext.clearRect(0,0,b,a)},getFeatureIdFromEvent:function(a){var b=null;if(this.hitDetection&&!this.map.dragging)a=a.xy,a=this.hitContext.getImageData(a.x|
0,a.y|0,1,1).data,a[3]===255&&(a=a[2]+256*(a[1]+256*a[0]))&&(b=this.features["OpenLayers.Feature.Vector_"+(a-1+this.hitOverflow)][0]);return b},eraseFeatures:function(a){OpenLayers.Util.isArray(a)||(a=[a]);for(var b=0;b<a.length;++b)delete this.features[a[b].id];this.redraw()},redraw:function(){if(!this.locked){var a=this.root.height,b=this.root.width;this.canvas.clearRect(0,0,b,a);this.hitDetection&&this.hitContext.clearRect(0,0,b,a);var a=[],c,d;for(d in this.features)this.features.hasOwnProperty(d)&&
(b=this.features[d][0],c=this.features[d][1],this.drawGeometry(b.geometry,c,b.id),c.label&&a.push([b,c]));b=0;for(c=a.length;b<c;++b)d=a[b],this.drawText(d[0].geometry.getCentroid(),d[1])}},CLASS_NAME:"OpenLayers.Renderer.Canvas"});OpenLayers.Renderer.Canvas.LABEL_ALIGN={l:"left",r:"right",t:"top",b:"bottom"};OpenLayers.Renderer.Canvas.LABEL_FACTOR={l:0,r:-1,t:0,b:-1};OpenLayers.Renderer.Canvas.drawImageScaleFactor=null;
OpenLayers.Handler=OpenLayers.Class({id:null,control:null,map:null,keyMask:null,active:!1,evt:null,initialize:function(a,b,c){OpenLayers.Util.extend(this,c);this.control=a;this.callbacks=b;(a=this.map||a.map)&&this.setMap(a);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},setMap:function(a){this.map=a},checkModifiers:function(a){return this.keyMask==null?!0:((a.shiftKey?OpenLayers.Handler.MOD_SHIFT:0)|(a.ctrlKey?OpenLayers.Handler.MOD_CTRL:0)|(a.altKey?OpenLayers.Handler.MOD_ALT:0))==
this.keyMask},activate:function(){if(this.active)return!1;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.register(a[b],this[a[b]]);return this.active=!0},deactivate:function(){if(!this.active)return!1;for(var a=OpenLayers.Events.prototype.BROWSER_EVENTS,b=0,c=a.length;b<c;b++)this[a[b]]&&this.unregister(a[b],this[a[b]]);this.active=!1;return!0},callback:function(a,b){a&&this.callbacks[a]&&this.callbacks[a].apply(this.control,b)},register:function(a,b){this.map.events.registerPriority(a,
this,b);this.map.events.registerPriority(a,this,this.setEvent)},unregister:function(a,b){this.map.events.unregister(a,this,b);this.map.events.unregister(a,this,this.setEvent)},setEvent:function(a){this.evt=a;return!0},destroy:function(){this.deactivate();this.control=this.map=null},CLASS_NAME:"OpenLayers.Handler"});OpenLayers.Handler.MOD_NONE=0;OpenLayers.Handler.MOD_SHIFT=1;OpenLayers.Handler.MOD_CTRL=2;OpenLayers.Handler.MOD_ALT=4;
OpenLayers.Handler.MouseWheel=OpenLayers.Class(OpenLayers.Handler,{wheelListener:null,mousePosition:null,interval:0,delta:0,cumulative:!0,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.wheelListener=OpenLayers.Function.bindAsEventListener(this.onWheelEvent,this)},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);this.wheelListener=null},onWheelEvent:function(a){if(this.map&&this.checkModifiers(a)){for(var b=!1,c=!1,d=!1,e=
OpenLayers.Event.element(a);e!=null&&!d&&!b;){if(!b)try{var f=e.currentStyle?e.currentStyle.overflow:document.defaultView.getComputedStyle(e,null).getPropertyValue("overflow"),b=f&&f=="auto"||f=="scroll"}catch(g){}if(!c)for(var d=0,h=this.map.layers.length;d<h;d++)if(e==this.map.layers[d].div||e==this.map.layers[d].pane){c=!0;break}d=e==this.map.div;e=e.parentNode}if(!b&&d){if(c){b=0;if(!a)a=window.event;a.wheelDelta?(b=a.wheelDelta/120,window.opera&&window.opera.version()<9.2&&(b=-b)):a.detail&&
(b=-a.detail/3);this.delta+=b;this.interval?(window.clearTimeout(this._timeoutId),this._timeoutId=window.setTimeout(OpenLayers.Function.bind(function(){this.wheelZoom(a)},this),this.interval)):this.wheelZoom(a)}OpenLayers.Event.stop(a)}}},wheelZoom:function(a){var b=this.delta;this.delta=0;if(b){if(this.mousePosition)a.xy=this.mousePosition;if(!a.xy)a.xy=this.map.getPixelFromLonLat(this.map.getCenter());b<0?this.callback("down",[a,this.cumulative?b:-1]):this.callback("up",[a,this.cumulative?b:1])}},
mousemove:function(a){this.mousePosition=a.xy},activate:function(a){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){var b=this.wheelListener;OpenLayers.Event.observe(window,"DOMMouseScroll",b);OpenLayers.Event.observe(window,"mousewheel",b);OpenLayers.Event.observe(document,"mousewheel",b);return!0}else return!1},deactivate:function(a){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){var b=this.wheelListener;OpenLayers.Event.stopObserving(window,"DOMMouseScroll",b);
OpenLayers.Event.stopObserving(window,"mousewheel",b);OpenLayers.Event.stopObserving(document,"mousewheel",b);return!0}else return!1},CLASS_NAME:"OpenLayers.Handler.MouseWheel"});OpenLayers.Symbolizer=OpenLayers.Class({zIndex:0,initialize:function(a){OpenLayers.Util.extend(this,a)},clone:function(){return new (eval(this.CLASS_NAME))(OpenLayers.Util.extend({},this))},CLASS_NAME:"OpenLayers.Symbolizer"});
OpenLayers.Symbolizer.Raster=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(a){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Raster"});
OpenLayers.Tile=OpenLayers.Class({EVENT_TYPES:["loadstart","loadend","reload","unload"],events:null,id:null,layer:null,url:null,bounds:null,size:null,position:null,isLoading:!1,initialize:function(a,b,c,d,e,f){this.layer=a;this.position=b.clone();this.bounds=c.clone();this.url=d;if(e)this.size=e.clone();this.id=OpenLayers.Util.createUniqueID("Tile_");this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);OpenLayers.Util.extend(this,f)},unload:function(){if(this.isLoading)this.isLoading=!1,
this.events.triggerEvent("unload")},destroy:function(){this.position=this.size=this.bounds=this.layer=null;this.events.destroy();this.events=null},clone:function(a){a==null&&(a=new OpenLayers.Tile(this.layer,this.position,this.bounds,this.url,this.size));OpenLayers.Util.applyDefaults(a,this);return a},draw:function(){var a=this.layer.maxExtent;this.shouldDraw=a&&this.bounds.intersectsBounds(a,!1)||this.layer.displayOutsideMaxExtent;this.clear();return this.shouldDraw},moveTo:function(a,b,c){c==null&&
(c=!0);this.bounds=a.clone();this.position=b.clone();c&&this.draw()},clear:function(){},getBoundsFromBaseLayer:function(a){var b=OpenLayers.i18n("reprojectDeprecated",{layerName:this.layer.name});OpenLayers.Console.warn(b);b=this.layer.map.getLonLatFromLayerPx(a);a=a.clone();a.x+=this.size.w;a.y+=this.size.h;a=this.layer.map.getLonLatFromLayerPx(a);if(b.lon>a.lon)b.lon<0?b.lon=-180-(b.lon+180):a.lon=180+a.lon+180;return new OpenLayers.Bounds(b.lon,a.lat,a.lon,b.lat)},showTile:function(){this.shouldDraw&&
this.show()},show:function(){},hide:function(){},CLASS_NAME:"OpenLayers.Tile"});
OpenLayers.Tile.Image=OpenLayers.Class(OpenLayers.Tile,{url:null,imgDiv:null,frame:null,layerAlphaHack:null,isBackBuffer:!1,isFirstDraw:!0,backBufferTile:null,maxGetUrlLength:null,initialize:function(a,b,c,d,e,f){OpenLayers.Tile.prototype.initialize.apply(this,arguments);this.maxGetUrlLength!=null&&OpenLayers.Util.extend(this,OpenLayers.Tile.Image.IFrame);this.url=d;this.frame=document.createElement("div");this.frame.style.overflow="hidden";this.frame.style.position="absolute";this.layerAlphaHack=
this.layer.alpha&&OpenLayers.Util.alphaHack()},destroy:function(){this.imgDiv!=null&&this.removeImgDiv();this.imgDiv=null;this.frame!=null&&this.frame.parentNode==this.layer.div&&this.layer.div.removeChild(this.frame);this.frame=null;if(this.backBufferTile)this.backBufferTile.destroy(),this.backBufferTile=null;this.layer.events.unregister("loadend",this,this.resetBackBuffer);OpenLayers.Tile.prototype.destroy.apply(this,arguments)},clone:function(a){a==null&&(a=new OpenLayers.Tile.Image(this.layer,
this.position,this.bounds,this.url,this.size));a=OpenLayers.Tile.prototype.clone.apply(this,[a]);a.imgDiv=null;return a},draw:function(){if(this.layer!=this.layer.map.baseLayer&&this.layer.reproject)this.bounds=this.getBoundsFromBaseLayer(this.position);var a=OpenLayers.Tile.prototype.draw.apply(this,arguments);if(OpenLayers.Util.indexOf(this.layer.SUPPORTED_TRANSITIONS,this.layer.transitionEffect)!=-1||this.layer.singleTile)if(a){if(!this.backBufferTile)this.backBufferTile=this.clone(),this.backBufferTile.hide(),
this.backBufferTile.isBackBuffer=!0,this.events.register("loadend",this,this.resetBackBuffer),this.layer.events.register("loadend",this,this.resetBackBuffer);this.startTransition()}else this.backBufferTile&&this.backBufferTile.clear();else if(a&&this.isFirstDraw)this.events.register("loadend",this,this.showTile),this.isFirstDraw=!1;if(!a)return!1;this.isLoading?this.events.triggerEvent("reload"):(this.isLoading=!0,this.events.triggerEvent("loadstart"));return this.renderTile()},resetBackBuffer:function(){this.showTile();
if(this.backBufferTile&&(this.isFirstDraw||!this.layer.numLoadingTiles)){this.isFirstDraw=!1;var a=this.layer.maxExtent;if(a&&this.bounds.intersectsBounds(a,!1))this.backBufferTile.position=this.position,this.backBufferTile.bounds=this.bounds,this.backBufferTile.size=this.size,this.backBufferTile.imageSize=this.layer.getImageSize(this.bounds)||this.size,this.backBufferTile.imageOffset=this.layer.imageOffset,this.backBufferTile.resolution=this.layer.getResolution(),this.backBufferTile.renderTile();
this.backBufferTile.hide()}},renderTile:function(){this.layer.async?(this.initImgDiv(),this.layer.getURLasync(this.bounds,this,"url",this.positionImage)):(this.url=this.layer.getURL(this.bounds),this.initImgDiv(),this.positionImage());return!0},positionImage:function(){if(this.layer!==null){OpenLayers.Util.modifyDOMElement(this.frame,null,this.position,this.size);var a=this.layer.getImageSize(this.bounds);this.layerAlphaHack?OpenLayers.Util.modifyAlphaImageDiv(this.imgDiv,null,null,a,this.url):(OpenLayers.Util.modifyDOMElement(this.imgDiv,
null,null,a),this.imgDiv.src=this.url)}},clear:function(){if(this.imgDiv&&(this.hide(),OpenLayers.Tile.Image.useBlankTile))this.imgDiv.src=OpenLayers.Util.getImagesLocation()+"blank.gif"},initImgDiv:function(){if(this.imgDiv==null){var a=this.layer.imageOffset,b=this.layer.getImageSize(this.bounds);this.imgDiv=this.layerAlphaHack?OpenLayers.Util.createAlphaImageDiv(null,a,b,null,"relative",null,null,null,!0):OpenLayers.Util.createImage(null,a,b,null,"relative",null,null,!0);if(OpenLayers.Util.isArray(this.layer.url))this.imgDiv.urls=
this.layer.url.slice();this.imgDiv.className="olTileImage";this.frame.style.zIndex=this.isBackBuffer?0:1;this.frame.appendChild(this.imgDiv);this.layer.div.appendChild(this.frame);this.layer.opacity!=null&&OpenLayers.Util.modifyDOMElement(this.imgDiv,null,null,null,null,null,null,this.layer.opacity);this.imgDiv.map=this.layer.map;var c=function(){if(this.isLoading)this.isLoading=!1,this.events.triggerEvent("loadend")};this.layerAlphaHack?OpenLayers.Event.observe(this.imgDiv.childNodes[0],"load",OpenLayers.Function.bind(c,
this)):OpenLayers.Event.observe(this.imgDiv,"load",OpenLayers.Function.bind(c,this));OpenLayers.Event.observe(this.imgDiv,"error",OpenLayers.Function.bind(function(){this.imgDiv._attempts>OpenLayers.IMAGE_RELOAD_ATTEMPTS&&c.call(this)},this))}this.imgDiv.viewRequestID=this.layer.map.viewRequestID},removeImgDiv:function(){OpenLayers.Event.stopObservingElement(this.imgDiv);if(this.imgDiv.parentNode==this.frame)this.frame.removeChild(this.imgDiv),this.imgDiv.map=null;this.imgDiv.urls=null;var a=this.imgDiv.firstChild;
a?(OpenLayers.Event.stopObservingElement(a),this.imgDiv.removeChild(a),delete a):this.imgDiv.src=OpenLayers.Util.getImagesLocation()+"blank.gif"},checkImgURL:function(){this.layer&&(OpenLayers.Util.isEquivalentUrl(this.layerAlphaHack?this.imgDiv.firstChild.src:this.imgDiv.src,this.url)||this.hide())},startTransition:function(){if(this.backBufferTile&&this.backBufferTile.imgDiv){var a=1;this.backBufferTile.resolution&&(a=this.backBufferTile.resolution/this.layer.getResolution());if(a!=1){if(this.layer.transitionEffect==
"resize"){var b=new OpenLayers.LonLat(this.backBufferTile.bounds.left,this.backBufferTile.bounds.top),c=new OpenLayers.Size(this.backBufferTile.size.w*a,this.backBufferTile.size.h*a),b=this.layer.map.getLayerPxFromLonLat(b);OpenLayers.Util.modifyDOMElement(this.backBufferTile.frame,null,b,c);c=this.backBufferTile.imageSize;c=new OpenLayers.Size(c.w*a,c.h*a);(b=this.backBufferTile.imageOffset)&&(b=new OpenLayers.Pixel(b.x*a,b.y*a));OpenLayers.Util.modifyDOMElement(this.backBufferTile.imgDiv,null,b,
c);this.backBufferTile.show()}}else this.layer.singleTile?this.backBufferTile.show():this.backBufferTile.hide()}},show:function(){this.frame.style.display="";if(OpenLayers.Util.indexOf(this.layer.SUPPORTED_TRANSITIONS,this.layer.transitionEffect)!=-1&&OpenLayers.IS_GECKO===!0)this.frame.scrollLeft=this.frame.scrollLeft},hide:function(){this.frame.style.display="none"},CLASS_NAME:"OpenLayers.Tile.Image"});
OpenLayers.Tile.Image.useBlankTile=OpenLayers.BROWSER_NAME=="safari"||OpenLayers.BROWSER_NAME=="opera";
OpenLayers.ElementsIndexer=OpenLayers.Class({maxZIndex:null,order:null,indices:null,compare:null,initialize:function(a){this.compare=a?OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER_Y_ORDER:OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER_DRAWING_ORDER;this.clear()},insert:function(a){this.exists(a)&&this.remove(a);var b=a.id;this.determineZIndex(a);for(var c=-1,d=this.order.length,e;d-c>1;)e=parseInt((c+d)/2),this.compare(this,a,OpenLayers.Util.getElement(this.order[e]))>0?c=e:d=e;this.order.splice(d,
0,b);this.indices[b]=this.getZIndex(a);return this.getNextElement(d)},remove:function(a){var a=a.id,b=OpenLayers.Util.indexOf(this.order,a);if(b>=0)this.order.splice(b,1),delete this.indices[a],this.maxZIndex=this.order.length>0?this.indices[this.order[this.order.length-1]]:0},clear:function(){this.order=[];this.indices={};this.maxZIndex=0},exists:function(a){return this.indices[a.id]!=null},getZIndex:function(a){return a._style.graphicZIndex},determineZIndex:function(a){var b=a._style.graphicZIndex;
if(b==null)b=this.maxZIndex,a._style.graphicZIndex=b;else if(b>this.maxZIndex)this.maxZIndex=b},getNextElement:function(a){a+=1;if(a<this.order.length){var b=OpenLayers.Util.getElement(this.order[a]);b==void 0&&(b=this.getNextElement(a));return b}else return null},CLASS_NAME:"OpenLayers.ElementsIndexer"});
OpenLayers.ElementsIndexer.IndexingMethods={Z_ORDER:function(a,b,c){var b=a.getZIndex(b),d=0;c&&(a=a.getZIndex(c),d=b-a);return d},Z_ORDER_DRAWING_ORDER:function(a,b,c){a=OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER(a,b,c);c&&a==0&&(a=1);return a},Z_ORDER_Y_ORDER:function(a,b,c){a=OpenLayers.ElementsIndexer.IndexingMethods.Z_ORDER(a,b,c);c&&a===0&&(b=c._boundsBottom-b._boundsBottom,a=b===0?1:b);return a}};
OpenLayers.Renderer.Elements=OpenLayers.Class(OpenLayers.Renderer,{rendererRoot:null,root:null,vectorRoot:null,textRoot:null,xmlns:null,indexer:null,BACKGROUND_ID_SUFFIX:"_background",LABEL_ID_SUFFIX:"_label",initialize:function(a,b){OpenLayers.Renderer.prototype.initialize.apply(this,arguments);this.rendererRoot=this.createRenderRoot();this.root=this.createRoot("_root");this.vectorRoot=this.createRoot("_vroot");this.textRoot=this.createRoot("_troot");this.root.appendChild(this.vectorRoot);this.root.appendChild(this.textRoot);
this.rendererRoot.appendChild(this.root);this.container.appendChild(this.rendererRoot);if(b&&(b.zIndexing||b.yOrdering))this.indexer=new OpenLayers.ElementsIndexer(b.yOrdering)},destroy:function(){this.clear();this.xmlns=this.root=this.rendererRoot=null;OpenLayers.Renderer.prototype.destroy.apply(this,arguments)},clear:function(){var a,b=this.vectorRoot;if(b)for(;a=b.firstChild;)b.removeChild(a);if(b=this.textRoot)for(;a=b.firstChild;)b.removeChild(a);this.indexer&&this.indexer.clear()},getNodeType:function(){},
drawGeometry:function(a,b,c){var d=a.CLASS_NAME,e=!0;if(d=="OpenLayers.Geometry.Collection"||d=="OpenLayers.Geometry.MultiPoint"||d=="OpenLayers.Geometry.MultiLineString"||d=="OpenLayers.Geometry.MultiPolygon"){for(var d=0,f=a.components.length;d<f;d++)e=this.drawGeometry(a.components[d],b,c)&&e;return e}d=e=!1;b.display!="none"&&(b.backgroundGraphic?this.redrawBackgroundNode(a.id,a,b,c):d=!0,e=this.redrawNode(a.id,a,b,c));if(e==!1&&(b=document.getElementById(a.id)))b._style.backgroundGraphic&&(d=
!0),b.parentNode.removeChild(b);d&&(b=document.getElementById(a.id+this.BACKGROUND_ID_SUFFIX))&&b.parentNode.removeChild(b);return e},redrawNode:function(a,b,c,d){c=this.applyDefaultSymbolizer(c);a=this.nodeFactory(a,this.getNodeType(b,c));a._featureId=d;a._boundsBottom=b.getBounds().bottom;a._geometryClass=b.CLASS_NAME;a._style=c;b=this.drawGeometryNode(a,b,c);if(b===!1)return!1;a=b.node;this.indexer?(c=this.indexer.insert(a))?this.vectorRoot.insertBefore(a,c):this.vectorRoot.appendChild(a):a.parentNode!==
this.vectorRoot&&this.vectorRoot.appendChild(a);this.postDraw(a);return b.complete},redrawBackgroundNode:function(a,b,c){c=OpenLayers.Util.extend({},c);c.externalGraphic=c.backgroundGraphic;c.graphicXOffset=c.backgroundXOffset;c.graphicYOffset=c.backgroundYOffset;c.graphicZIndex=c.backgroundGraphicZIndex;c.graphicWidth=c.backgroundWidth||c.graphicWidth;c.graphicHeight=c.backgroundHeight||c.graphicHeight;c.backgroundGraphic=null;c.backgroundXOffset=null;c.backgroundYOffset=null;c.backgroundGraphicZIndex=
null;return this.redrawNode(a+this.BACKGROUND_ID_SUFFIX,b,c,null)},drawGeometryNode:function(a,b,c){var c=c||a._style,d={isFilled:c.fill===void 0?!0:c.fill,isStroked:c.stroke===void 0?!!c.strokeWidth:c.stroke},e;switch(b.CLASS_NAME){case "OpenLayers.Geometry.Point":if(c.graphic===!1)d.isFilled=!1,d.isStroked=!1;e=this.drawPoint(a,b);break;case "OpenLayers.Geometry.LineString":d.isFilled=!1;e=this.drawLineString(a,b);break;case "OpenLayers.Geometry.LinearRing":e=this.drawLinearRing(a,b);break;case "OpenLayers.Geometry.Polygon":e=
this.drawPolygon(a,b);break;case "OpenLayers.Geometry.Surface":e=this.drawSurface(a,b);break;case "OpenLayers.Geometry.Rectangle":e=this.drawRectangle(a,b)}a._options=d;return e!=!1?{node:this.setStyle(a,c,d,b),complete:e}:!1},postDraw:function(){},drawPoint:function(){},drawLineString:function(){},drawLinearRing:function(){},drawPolygon:function(){},drawRectangle:function(){},drawCircle:function(){},drawSurface:function(){},removeText:function(a){(a=document.getElementById(a+this.LABEL_ID_SUFFIX))&&
this.textRoot.removeChild(a)},getFeatureIdFromEvent:function(a){var b=a.target,c=b&&b.correspondingUseElement;return(c?c:b||a.srcElement)._featureId},eraseGeometry:function(a,b){if(a.CLASS_NAME=="OpenLayers.Geometry.MultiPoint"||a.CLASS_NAME=="OpenLayers.Geometry.MultiLineString"||a.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon"||a.CLASS_NAME=="OpenLayers.Geometry.Collection")for(var c=0,d=a.components.length;c<d;c++)this.eraseGeometry(a.components[c],b);else if((c=OpenLayers.Util.getElement(a.id))&&
c.parentNode){if(c.geometry)c.geometry.destroy(),c.geometry=null;c.parentNode.removeChild(c);this.indexer&&this.indexer.remove(c);c._style.backgroundGraphic&&(c=OpenLayers.Util.getElement(a.id+this.BACKGROUND_ID_SUFFIX))&&c.parentNode&&c.parentNode.removeChild(c)}},nodeFactory:function(a,b){var c=OpenLayers.Util.getElement(a);c?this.nodeTypeCompare(c,b)||(c.parentNode.removeChild(c),c=this.nodeFactory(a,b)):c=this.createNode(b,a);return c},nodeTypeCompare:function(){},createNode:function(){},moveRoot:function(a){var b=
this.root;if(a.root.parentNode==this.rendererRoot)b=a.root;b.parentNode.removeChild(b);a.rendererRoot.appendChild(b)},getRenderLayerId:function(){return this.root.parentNode.parentNode.id},isComplexSymbol:function(a){return a!="circle"&&!!a},CLASS_NAME:"OpenLayers.Renderer.Elements"});
OpenLayers.Renderer.symbol={star:[350,75,379,161,469,161,397,215,423,301,350,250,277,301,303,215,231,161,321,161,350,75],cross:[4,0,6,0,6,4,10,4,10,6,6,6,6,10,4,10,4,6,0,6,0,4,4,4,4,0],x:[0,0,25,0,50,35,75,0,100,0,65,50,100,100,75,100,50,65,25,100,0,100,35,50,0,0],square:[0,0,0,1,1,1,1,0,0,0],triangle:[0,10,10,10,5,0,0,10]};
OpenLayers.Tween=OpenLayers.Class({INTERVAL:10,easing:null,begin:null,finish:null,duration:null,callbacks:null,time:null,interval:null,playing:!1,initialize:function(a){this.easing=a?a:OpenLayers.Easing.Expo.easeOut},start:function(a,b,c,d){this.playing=!0;this.begin=a;this.finish=b;this.duration=c;this.callbacks=d.callbacks;this.time=0;if(this.interval)window.clearInterval(this.interval),this.interval=null;this.callbacks&&this.callbacks.start&&this.callbacks.start.call(this,this.begin);this.interval=
window.setInterval(OpenLayers.Function.bind(this.play,this),this.INTERVAL)},stop:function(){if(this.playing)this.callbacks&&this.callbacks.done&&this.callbacks.done.call(this,this.finish),window.clearInterval(this.interval),this.interval=null,this.playing=!1},play:function(){var a={},b;for(b in this.begin){var c=this.begin[b],d=this.finish[b];(c==null||d==null||isNaN(c)||isNaN(d))&&OpenLayers.Console.error("invalid value for Tween");a[b]=this.easing.apply(this,[this.time,c,d-c,this.duration])}this.time++;
this.callbacks&&this.callbacks.eachStep&&this.callbacks.eachStep.call(this,a);this.time>this.duration&&this.stop()},CLASS_NAME:"OpenLayers.Tween"});OpenLayers.Easing={CLASS_NAME:"OpenLayers.Easing"};OpenLayers.Easing.Linear={easeIn:function(a,b,c,d){return c*a/d+b},easeOut:function(a,b,c,d){return c*a/d+b},easeInOut:function(a,b,c,d){return c*a/d+b},CLASS_NAME:"OpenLayers.Easing.Linear"};
OpenLayers.Easing.Expo={easeIn:function(a,b,c,d){return a==0?b:c*Math.pow(2,10*(a/d-1))+b},easeOut:function(a,b,c,d){return a==d?b+c:c*(-Math.pow(2,-10*a/d)+1)+b},easeInOut:function(a,b,c,d){return a==0?b:a==d?b+c:(a/=d/2)<1?c/2*Math.pow(2,10*(a-1))+b:c/2*(-Math.pow(2,-10*--a)+2)+b},CLASS_NAME:"OpenLayers.Easing.Expo"};
OpenLayers.Easing.Quad={easeIn:function(a,b,c,d){return c*(a/=d)*a+b},easeOut:function(a,b,c,d){return-c*(a/=d)*(a-2)+b},easeInOut:function(a,b,c,d){return(a/=d/2)<1?c/2*a*a+b:-c/2*(--a*(a-2)-1)+b},CLASS_NAME:"OpenLayers.Easing.Quad"};
OpenLayers.Map=OpenLayers.Class({Z_INDEX_BASE:{BaseLayer:100,Overlay:325,Feature:725,Popup:750,Control:1E3},EVENT_TYPES:"preaddlayer,addlayer,preremovelayer,removelayer,changelayer,movestart,move,moveend,zoomend,popupopen,popupclose,addmarker,removemarker,clearmarkers,mouseover,mouseout,mousemove,dragstart,drag,dragend,changebaselayer".split(","),id:null,fractionalZoom:!1,events:null,allOverlays:!1,div:null,dragging:!1,size:null,viewPortDiv:null,layerContainerOrigin:null,layerContainerDiv:null,layers:null,
controls:null,popups:null,baseLayer:null,center:null,resolution:null,zoom:0,panRatio:1.5,viewRequestID:0,tileSize:null,projection:"EPSG:4326",units:"degrees",resolutions:null,maxResolution:1.40625,minResolution:null,maxScale:null,minScale:null,maxExtent:null,minExtent:null,restrictedExtent:null,numZoomLevels:16,theme:null,displayProjection:null,fallThrough:!0,panTween:null,eventListeners:null,panMethod:OpenLayers.Easing.Expo.easeOut,panDuration:50,paddingForPopups:null,minPx:null,maxPx:null,initialize:function(a,
b){arguments.length===1&&typeof a==="object"&&(a=(b=a)&&b.div);this.tileSize=new OpenLayers.Size(OpenLayers.Map.TILE_WIDTH,OpenLayers.Map.TILE_HEIGHT);this.maxExtent=new OpenLayers.Bounds(-180,-90,180,90);this.paddingForPopups=new OpenLayers.Bounds(15,15,15,15);this.theme=OpenLayers._getScriptLocation()+"theme/default/style.css";OpenLayers.Util.extend(this,b);this.layers=[];this.id=OpenLayers.Util.createUniqueID("OpenLayers.Map_");this.div=OpenLayers.Util.getElement(a);if(!this.div)this.div=document.createElement("div"),
this.div.style.height="1px",this.div.style.width="1px";OpenLayers.Element.addClass(this.div,"olMap");var c=this.id+"_OpenLayers_ViewPort";this.viewPortDiv=OpenLayers.Util.createDiv(c,null,null,null,"relative",null,"hidden");this.viewPortDiv.style.width="100%";this.viewPortDiv.style.height="100%";this.viewPortDiv.className="olMapViewport";this.div.appendChild(this.viewPortDiv);c=document.createElement("div");c.id=this.id+"_events";c.style.position="absolute";c.style.width="100%";c.style.height="100%";
c.style.zIndex=this.Z_INDEX_BASE.Control-1;this.viewPortDiv.appendChild(c);this.eventsDiv=c;this.events=new OpenLayers.Events(this,this.eventsDiv,this.EVENT_TYPES,this.fallThrough,{includeXY:!0});c=this.id+"_OpenLayers_Container";this.layerContainerDiv=OpenLayers.Util.createDiv(c);this.layerContainerDiv.style.zIndex=this.Z_INDEX_BASE.Popup-1;this.eventsDiv.appendChild(this.layerContainerDiv);this.updateSize();if(this.eventListeners instanceof Object)this.events.on(this.eventListeners);this.events.register("movestart",
this,this.updateSize);OpenLayers.String.contains(navigator.appName,"Microsoft")?this.events.register("resize",this,this.updateSize):(this.updateSizeDestroy=OpenLayers.Function.bind(this.updateSize,this),OpenLayers.Event.observe(window,"resize",this.updateSizeDestroy));if(this.theme){for(var c=!0,d=document.getElementsByTagName("link"),e=0,f=d.length;e<f;++e)if(OpenLayers.Util.isEquivalentUrl(d.item(e).href,this.theme)){c=!1;break}c&&(c=document.createElement("link"),c.setAttribute("rel","stylesheet"),
c.setAttribute("type","text/css"),c.setAttribute("href",this.theme),document.getElementsByTagName("head")[0].appendChild(c))}if(this.controls==null)this.controls=OpenLayers.Control!=null?[new OpenLayers.Control.Navigation,new OpenLayers.Control.PanZoom,new OpenLayers.Control.ArgParser,new OpenLayers.Control.Attribution]:[];e=0;for(f=this.controls.length;e<f;e++)this.addControlToMap(this.controls[e]);this.popups=[];this.unloadDestroy=OpenLayers.Function.bind(this.destroy,this);OpenLayers.Event.observe(window,
"unload",this.unloadDestroy);b&&b.layers&&(delete this.center,this.addLayers(b.layers),b.center&&this.setCenter(b.center,b.zoom))},render:function(a){this.div=OpenLayers.Util.getElement(a);OpenLayers.Element.addClass(this.div,"olMap");this.viewPortDiv.parentNode.removeChild(this.viewPortDiv);this.div.appendChild(this.viewPortDiv);this.updateSize()},unloadDestroy:null,updateSizeDestroy:null,destroy:function(){if(!this.unloadDestroy)return!1;if(this.panTween)this.panTween.stop(),this.panTween=null;
OpenLayers.Event.stopObserving(window,"unload",this.unloadDestroy);this.unloadDestroy=null;this.updateSizeDestroy?OpenLayers.Event.stopObserving(window,"resize",this.updateSizeDestroy):this.events.unregister("resize",this,this.updateSize);this.paddingForPopups=null;if(this.controls!=null){for(var a=this.controls.length-1;a>=0;--a)this.controls[a].destroy();this.controls=null}if(this.layers!=null){for(a=this.layers.length-1;a>=0;--a)this.layers[a].destroy(!1);this.layers=null}this.viewPortDiv&&this.div.removeChild(this.viewPortDiv);
this.viewPortDiv=null;if(this.eventListeners)this.events.un(this.eventListeners),this.eventListeners=null;this.events.destroy();this.events=null},setOptions:function(a){var b=this.minPx&&a.restrictedExtent!=this.restrictedExtent;OpenLayers.Util.extend(this,a);b&&this.moveTo(this.getCachedCenter(),this.zoom,{forceZoomChange:!0})},getTileSize:function(){return this.tileSize},getBy:function(a,b,c){var d=typeof c.test=="function";return OpenLayers.Array.filter(this[a],function(a){return a[b]==c||d&&c.test(a[b])})},
getLayersBy:function(a,b){return this.getBy("layers",a,b)},getLayersByName:function(a){return this.getLayersBy("name",a)},getLayersByClass:function(a){return this.getLayersBy("CLASS_NAME",a)},getControlsBy:function(a,b){return this.getBy("controls",a,b)},getControlsByClass:function(a){return this.getControlsBy("CLASS_NAME",a)},getLayer:function(a){for(var b=null,c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];if(e.id==a){b=e;break}}return b},setLayerZIndex:function(a,b){a.setZIndex(this.Z_INDEX_BASE[a.isBaseLayer?
"BaseLayer":"Overlay"]+b*5)},resetLayersZIndex:function(){for(var a=0,b=this.layers.length;a<b;a++)this.setLayerZIndex(this.layers[a],a)},addLayer:function(a){for(var b=0,c=this.layers.length;b<c;b++)if(this.layers[b]==a)return a=OpenLayers.i18n("layerAlreadyAdded",{layerName:a.name}),OpenLayers.Console.warn(a),!1;if(this.events.triggerEvent("preaddlayer",{layer:a})!==!1){if(this.allOverlays)a.isBaseLayer=!1;a.div.className="olLayerDiv";a.div.style.overflow="";this.setLayerZIndex(a,this.layers.length);
a.isFixed?this.viewPortDiv.appendChild(a.div):this.layerContainerDiv.appendChild(a.div);this.layers.push(a);a.setMap(this);a.isBaseLayer||this.allOverlays&&!this.baseLayer?this.baseLayer==null?this.setBaseLayer(a):a.setVisibility(!1):a.redraw();this.events.triggerEvent("addlayer",{layer:a});a.events.triggerEvent("added",{map:this,layer:a});a.afterAdd()}},addLayers:function(a){for(var b=0,c=a.length;b<c;b++)this.addLayer(a[b])},removeLayer:function(a,b){if(this.events.triggerEvent("preremovelayer",
{layer:a})!==!1){b==null&&(b=!0);a.isFixed?this.viewPortDiv.removeChild(a.div):this.layerContainerDiv.removeChild(a.div);OpenLayers.Util.removeItem(this.layers,a);a.removeMap(this);a.map=null;if(this.baseLayer==a&&(this.baseLayer=null,b))for(var c=0,d=this.layers.length;c<d;c++){var e=this.layers[c];if(e.isBaseLayer||this.allOverlays){this.setBaseLayer(e);break}}this.resetLayersZIndex();this.events.triggerEvent("removelayer",{layer:a});a.events.triggerEvent("removed",{map:this,layer:a})}},getNumLayers:function(){return this.layers.length},
getLayerIndex:function(a){return OpenLayers.Util.indexOf(this.layers,a)},setLayerIndex:function(a,b){var c=this.getLayerIndex(a);if(b<0)b=0;else if(b>this.layers.length)b=this.layers.length;if(c!=b){this.layers.splice(c,1);this.layers.splice(b,0,a);for(var c=0,d=this.layers.length;c<d;c++)this.setLayerZIndex(this.layers[c],c);this.events.triggerEvent("changelayer",{layer:a,property:"order"});this.allOverlays&&(b===0?this.setBaseLayer(a):this.baseLayer!==this.layers[0]&&this.setBaseLayer(this.layers[0]))}},
raiseLayer:function(a,b){var c=this.getLayerIndex(a)+b;this.setLayerIndex(a,c)},setBaseLayer:function(a){if(a!=this.baseLayer&&OpenLayers.Util.indexOf(this.layers,a)!=-1){var b=this.getCachedCenter(),c=OpenLayers.Util.getResolutionFromScale(this.getScale(),a.units);this.baseLayer!=null&&!this.allOverlays&&this.baseLayer.setVisibility(!1);this.baseLayer=a;this.viewRequestID++;(!this.allOverlays||this.baseLayer.visibility)&&this.baseLayer.setVisibility(!0);b!=null&&(a=this.getZoomForResolution(c||this.resolution,
!0),this.setCenter(b,a,!1,!0));this.events.triggerEvent("changebaselayer",{layer:this.baseLayer})}},addControl:function(a,b){this.controls.push(a);this.addControlToMap(a,b)},addControls:function(a,b){for(var c=arguments.length===1?[]:b,d=0,e=a.length;d<e;d++)this.addControl(a[d],c[d]?c[d]:null)},addControlToMap:function(a,b){a.outsideViewport=a.div!=null;if(this.displayProjection&&!a.displayProjection)a.displayProjection=this.displayProjection;a.setMap(this);var c=a.draw(b);if(c&&!a.outsideViewport)c.style.zIndex=
this.Z_INDEX_BASE.Control+this.controls.length,this.viewPortDiv.appendChild(c);a.autoActivate&&a.activate()},getControl:function(a){for(var b=null,c=0,d=this.controls.length;c<d;c++){var e=this.controls[c];if(e.id==a){b=e;break}}return b},removeControl:function(a){a&&a==this.getControl(a.id)&&(a.div&&a.div.parentNode==this.viewPortDiv&&this.viewPortDiv.removeChild(a.div),OpenLayers.Util.removeItem(this.controls,a))},addPopup:function(a,b){if(b)for(var c=this.popups.length-1;c>=0;--c)this.removePopup(this.popups[c]);
a.map=this;this.popups.push(a);if(c=a.draw())c.style.zIndex=this.Z_INDEX_BASE.Popup+this.popups.length,this.layerContainerDiv.appendChild(c)},removePopup:function(a){OpenLayers.Util.removeItem(this.popups,a);if(a.div)try{this.layerContainerDiv.removeChild(a.div)}catch(b){}a.map=null},getSize:function(){var a=null;this.size!=null&&(a=this.size.clone());return a},updateSize:function(){var a=this.getCurrentSize();if(a&&!isNaN(a.h)&&!isNaN(a.w)){this.events.clearMouseCache();var b=this.getSize();if(b==
null)this.size=b=a;if(!a.equals(b)){this.size=a;a=0;for(b=this.layers.length;a<b;a++)this.layers[a].onMapResize();a=this.getCachedCenter();if(this.baseLayer!=null&&a!=null)b=this.getZoom(),this.zoom=null,this.setCenter(a,b)}}},getCurrentSize:function(){var a=new OpenLayers.Size(this.div.clientWidth,this.div.clientHeight);if(a.w==0&&a.h==0||isNaN(a.w)&&isNaN(a.h))a.w=this.div.offsetWidth,a.h=this.div.offsetHeight;if(a.w==0&&a.h==0||isNaN(a.w)&&isNaN(a.h))a.w=parseInt(this.div.style.width),a.h=parseInt(this.div.style.height);
return a},calculateBounds:function(a,b){var c=null;a==null&&(a=this.getCachedCenter());b==null&&(b=this.getResolution());if(a!=null&&b!=null)var d=this.getSize(),c=d.w*b,d=d.h*b,c=new OpenLayers.Bounds(a.lon-c/2,a.lat-d/2,a.lon+c/2,a.lat+d/2);return c},getCenter:function(){var a=null,b=this.getCachedCenter();b&&(a=b.clone());return a},getCachedCenter:function(){if(!this.center&&this.size)this.center=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(this.size.w/2,this.size.h/2));return this.center},
getZoom:function(){return this.zoom},pan:function(a,b,c){c=OpenLayers.Util.applyDefaults(c,{animate:!0,dragging:!1});if(c.dragging)(a!=0||b!=0)&&this.moveByPx(a,b);else{var d=this.getViewPortPxFromLonLat(this.getCachedCenter()),a=d.add(a,b);if(this.dragging||!a.equals(d))d=this.getLonLatFromViewPortPx(a),c.animate?this.panTo(d):(this.moveTo(d),this.dragging=!1,this.events.triggerEvent("moveend"))}},panTo:function(a){if(this.panMethod&&this.getExtent().scale(this.panRatio).containsLonLat(a)){if(!this.panTween)this.panTween=
new OpenLayers.Tween(this.panMethod);var b=this.getCachedCenter();if(!a.equals(b)){var b=this.getPixelFromLonLat(b),c=this.getPixelFromLonLat(a),d=0,e=0;this.panTween.start({x:0,y:0},{x:c.x-b.x,y:c.y-b.y},this.panDuration,{callbacks:{eachStep:OpenLayers.Function.bind(function(a){this.moveByPx(a.x-d,a.y-e);d=Math.round(a.x);e=Math.round(a.y)},this),done:OpenLayers.Function.bind(function(){this.moveTo(a);this.dragging=!1;this.events.triggerEvent("moveend")},this)}})}}else this.setCenter(a)},setCenter:function(a,
b,c,d){this.panTween&&this.panTween.stop();this.moveTo(a,b,{dragging:c,forceZoomChange:d})},moveByPx:function(a,b){var c=this.size.w/2,d=this.size.h/2,e=c+a,f=d+b,g=this.baseLayer.wrapDateLine,h=0,i=0;this.restrictedExtent&&(h=c,i=d,g=!1);a=g||e<=this.maxPx.x-h&&e>=this.minPx.x+h?Math.round(a):0;b=f<=this.maxPx.y-i&&f>=this.minPx.y+i?Math.round(b):0;c=this.minPx.x;d=this.maxPx.x;if(a||b){if(!this.dragging)this.dragging=!0,this.events.triggerEvent("movestart");this.center=null;if(a)this.layerContainerDiv.style.left=
parseInt(this.layerContainerDiv.style.left)-a+"px",this.minPx.x-=a,this.maxPx.x-=a,g&&(this.maxPx.x>d&&(this.maxPx.x-=d-c),this.minPx.x<c&&(this.minPx.x+=d-c));if(b)this.layerContainerDiv.style.top=parseInt(this.layerContainerDiv.style.top)-b+"px",this.minPx.y-=b,this.maxPx.y-=b;for(c=0,d=this.layers.length;c<d;++c)if(g=this.layers[c],g.visibility&&(g===this.baseLayer||g.inRange))g.moveByPx(a,b),g.events.triggerEvent("move");this.events.triggerEvent("move")}},moveTo:function(a,b,c){c||(c={});b!=null&&
(b=parseFloat(b),this.fractionalZoom||(b=Math.round(b)));var d=c.dragging||this.dragging,e=c.forceZoomChange;if(!this.getCachedCenter()&&!this.isValidLonLat(a))a=this.maxExtent.getCenterLonLat(),this.center=a.clone();if(this.restrictedExtent!=null){if(a==null)a=this.center;b==null&&(b=this.getZoom());var f=this.getResolutionForZoom(b),f=this.calculateBounds(a,f);if(!this.restrictedExtent.containsBounds(f)){var g=this.restrictedExtent.getCenterLonLat();f.getWidth()>this.restrictedExtent.getWidth()?
a=new OpenLayers.LonLat(g.lon,a.lat):f.left<this.restrictedExtent.left?a=a.add(this.restrictedExtent.left-f.left,0):f.right>this.restrictedExtent.right&&(a=a.add(this.restrictedExtent.right-f.right,0));f.getHeight()>this.restrictedExtent.getHeight()?a=new OpenLayers.LonLat(a.lon,g.lat):f.bottom<this.restrictedExtent.bottom?a=a.add(0,this.restrictedExtent.bottom-f.bottom):f.top>this.restrictedExtent.top&&(a=a.add(0,this.restrictedExtent.top-f.top))}}e=e||this.isValidZoomLevel(b)&&b!=this.getZoom();
f=this.isValidLonLat(a)&&!a.equals(this.center);if(e||f||d){d||this.events.triggerEvent("movestart");if(f)!e&&this.center&&this.centerLayerContainer(a),this.center=a.clone();a=e?this.getResolutionForZoom(b):this.getResolution();if(e||this.layerContainerOrigin==null){this.layerContainerOrigin=this.getCachedCenter();this.layerContainerDiv.style.left="0px";this.layerContainerDiv.style.top="0px";var h=this.getMaxExtent({restricted:!0}),f=h.getCenterLonLat(),g=this.center.lon-f.lon,i=f.lat-this.center.lat,
f=Math.round(h.getWidth()/a),h=Math.round(h.getHeight()/a),g=(this.size.w-f)/2-g/a,i=(this.size.h-h)/2-i/a;this.minPx=new OpenLayers.Pixel(g,i);this.maxPx=new OpenLayers.Pixel(g+f,i+h)}if(e)this.zoom=b,this.resolution=a,this.viewRequestID++;a=this.getExtent();this.baseLayer.visibility&&(this.baseLayer.moveTo(a,e,c.dragging),c.dragging||this.baseLayer.events.triggerEvent("moveend",{zoomChanged:e}));a=this.baseLayer.getExtent();for(b=this.layers.length-1;b>=0;--b)if(f=this.layers[b],f!==this.baseLayer&&
!f.isBaseLayer){g=f.calculateInRange();if(f.inRange!=g)(f.inRange=g)||f.display(!1),this.events.triggerEvent("changelayer",{layer:f,property:"visibility"});g&&f.visibility&&(f.moveTo(a,e,c.dragging),c.dragging||f.events.triggerEvent("moveend",{zoomChanged:e}))}this.events.triggerEvent("move");d||this.events.triggerEvent("moveend");if(e){b=0;for(c=this.popups.length;b<c;b++)this.popups[b].updatePosition();this.events.triggerEvent("zoomend")}}},centerLayerContainer:function(a){var b=this.getViewPortPxFromLonLat(this.layerContainerOrigin),
c=this.getViewPortPxFromLonLat(a);if(b!=null&&c!=null){var d=parseInt(this.layerContainerDiv.style.left),a=parseInt(this.layerContainerDiv.style.top),e=Math.round(b.x-c.x),b=Math.round(b.y-c.y);this.layerContainerDiv.style.left=e+"px";this.layerContainerDiv.style.top=b+"px";d-=e;a-=b;this.minPx.x-=d;this.maxPx.x-=d;this.minPx.y-=a;this.maxPx.y-=a}},isValidZoomLevel:function(a){return a!=null&&a>=0&&a<this.getNumZoomLevels()},isValidLonLat:function(a){var b=!1;a!=null&&(b=this.getMaxExtent().containsLonLat(a));
return b},getProjection:function(){var a=this.getProjectionObject();return a?a.getCode():null},getProjectionObject:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.projection;return a},getMaxResolution:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.maxResolution;return a},getMaxExtent:function(a){var b=null;if(a&&a.restricted&&this.restrictedExtent)b=this.restrictedExtent;else if(this.baseLayer!=null)b=this.baseLayer.maxExtent;return b},getNumZoomLevels:function(){var a=
null;if(this.baseLayer!=null)a=this.baseLayer.numZoomLevels;return a},getExtent:function(){var a=null;this.baseLayer!=null&&(a=this.baseLayer.getExtent());return a},getResolution:function(){var a=null;this.baseLayer!=null?a=this.baseLayer.getResolution():this.allOverlays===!0&&this.layers.length>0&&(a=this.layers[0].getResolution());return a},getUnits:function(){var a=null;if(this.baseLayer!=null)a=this.baseLayer.units;return a},getScale:function(){var a=null;this.baseLayer!=null&&(a=this.getResolution(),
a=OpenLayers.Util.getScaleFromResolution(a,this.baseLayer.units));return a},getZoomForExtent:function(a,b){var c=null;this.baseLayer!=null&&(c=this.baseLayer.getZoomForExtent(a,b));return c},getResolutionForZoom:function(a){var b=null;this.baseLayer&&(b=this.baseLayer.getResolutionForZoom(a));return b},getZoomForResolution:function(a,b){var c=null;this.baseLayer!=null&&(c=this.baseLayer.getZoomForResolution(a,b));return c},zoomTo:function(a){this.isValidZoomLevel(a)&&this.setCenter(null,a)},zoomIn:function(){this.zoomTo(this.getZoom()+
1)},zoomOut:function(){this.zoomTo(this.getZoom()-1)},zoomToExtent:function(a,b){var c=a.getCenterLonLat();if(this.baseLayer.wrapDateLine){c=this.getMaxExtent();for(a=a.clone();a.right<a.left;)a.right+=c.getWidth();c=a.getCenterLonLat().wrapDateLine(c)}this.setCenter(c,this.getZoomForExtent(a,b))},zoomToMaxExtent:function(a){this.zoomToExtent(this.getMaxExtent({restricted:a?a.restricted:!0}))},zoomToScale:function(a,b){var c=OpenLayers.Util.getResolutionFromScale(a,this.baseLayer.units),d=this.getSize(),
e=d.w*c;c*=d.h;d=this.getCachedCenter();this.zoomToExtent(new OpenLayers.Bounds(d.lon-e/2,d.lat-c/2,d.lon+e/2,d.lat+c/2),b)},getLonLatFromViewPortPx:function(a){var b=null;this.baseLayer!=null&&(b=this.baseLayer.getLonLatFromViewPortPx(a));return b},getViewPortPxFromLonLat:function(a){var b=null;this.baseLayer!=null&&(b=this.baseLayer.getViewPortPxFromLonLat(a));return b},getLonLatFromPixel:function(a){return this.getLonLatFromViewPortPx(a)},getPixelFromLonLat:function(a){a=this.getViewPortPxFromLonLat(a);
a.x=Math.round(a.x);a.y=Math.round(a.y);return a},getGeodesicPixelSize:function(a){var b=a?this.getLonLatFromPixel(a):this.getCachedCenter()||new OpenLayers.LonLat(0,0),c=this.getResolution(),a=b.add(-c/2,0),d=b.add(c/2,0),e=b.add(0,-c/2),b=b.add(0,c/2),c=new OpenLayers.Projection("EPSG:4326"),f=this.getProjectionObject()||c;f.equals(c)||(a.transform(f,c),d.transform(f,c),e.transform(f,c),b.transform(f,c));return new OpenLayers.Size(OpenLayers.Util.distVincenty(a,d),OpenLayers.Util.distVincenty(e,
b))},getViewPortPxFromLayerPx:function(a){var b=null;if(a!=null)var b=parseInt(this.layerContainerDiv.style.left),c=parseInt(this.layerContainerDiv.style.top),b=a.add(b,c);return b},getLayerPxFromViewPortPx:function(a){var b=null;if(a!=null){var b=-parseInt(this.layerContainerDiv.style.left),c=-parseInt(this.layerContainerDiv.style.top),b=a.add(b,c);if(isNaN(b.x)||isNaN(b.y))b=null}return b},getLonLatFromLayerPx:function(a){a=this.getViewPortPxFromLayerPx(a);return this.getLonLatFromViewPortPx(a)},
getLayerPxFromLonLat:function(a){return this.getLayerPxFromViewPortPx(this.getPixelFromLonLat(a))},CLASS_NAME:"OpenLayers.Map"});OpenLayers.Map.TILE_WIDTH=256;OpenLayers.Map.TILE_HEIGHT=256;
OpenLayers.Projection=OpenLayers.Class({proj:null,projCode:null,titleRegEx:/\+title=[^\+]*/,initialize:function(a,b){OpenLayers.Util.extend(this,b);this.projCode=a;if(window.Proj4js)this.proj=new Proj4js.Proj(a)},getCode:function(){return this.proj?this.proj.srsCode:this.projCode},getUnits:function(){return this.proj?this.proj.units:null},toString:function(){return this.getCode()},equals:function(a){var b=!1;a&&(window.Proj4js&&this.proj.defData&&a.proj.defData?b=this.proj.defData.replace(this.titleRegEx,
"")==a.proj.defData.replace(this.titleRegEx,""):a.getCode&&(b=this.getCode(),a=a.getCode(),b=b==a||!!OpenLayers.Projection.transforms[b]&&OpenLayers.Projection.transforms[b][a]===OpenLayers.Projection.nullTransform));return b},destroy:function(){delete this.proj;delete this.projCode},CLASS_NAME:"OpenLayers.Projection"});OpenLayers.Projection.transforms={};
OpenLayers.Projection.addTransform=function(a,b,c){OpenLayers.Projection.transforms[a]||(OpenLayers.Projection.transforms[a]={});OpenLayers.Projection.transforms[a][b]=c};OpenLayers.Projection.transform=function(a,b,c){if(b.proj&&c.proj)a=Proj4js.transform(b.proj,c.proj,a);else if(b&&c&&OpenLayers.Projection.transforms[b.getCode()]&&OpenLayers.Projection.transforms[b.getCode()][c.getCode()])OpenLayers.Projection.transforms[b.getCode()][c.getCode()](a);return a};
OpenLayers.Projection.nullTransform=function(a){return a};
OpenLayers.Layer=OpenLayers.Class({id:null,name:null,div:null,opacity:null,alwaysInRange:null,EVENT_TYPES:"loadstart,loadend,loadcancel,visibilitychanged,move,moveend,added,removed".split(","),RESOLUTION_PROPERTIES:"scales,resolutions,maxScale,minScale,maxResolution,minResolution,numZoomLevels,maxZoomLevel".split(","),events:null,map:null,isBaseLayer:!1,alpha:!1,displayInLayerSwitcher:!0,visibility:!0,attribution:null,inRange:!1,imageSize:null,imageOffset:null,options:null,eventListeners:null,gutter:0,
projection:null,units:null,scales:null,resolutions:null,maxExtent:null,minExtent:null,maxResolution:null,minResolution:null,numZoomLevels:null,minScale:null,maxScale:null,displayOutsideMaxExtent:!1,wrapDateLine:!1,transitionEffect:null,SUPPORTED_TRANSITIONS:["resize"],metadata:{},initialize:function(a,b){this.addOptions(b);this.name=a;if(this.id==null&&(this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_"),this.div=OpenLayers.Util.createDiv(this.id),this.div.style.width="100%",this.div.style.height=
"100%",this.div.dir="ltr",this.events=new OpenLayers.Events(this,this.div,this.EVENT_TYPES),this.eventListeners instanceof Object))this.events.on(this.eventListeners);if(this.wrapDateLine)this.displayOutsideMaxExtent=!0},destroy:function(a){a==null&&(a=!0);this.map!=null&&this.map.removeLayer(this,a);this.options=this.div=this.name=this.map=this.projection=null;this.events&&(this.eventListeners&&this.events.un(this.eventListeners),this.events.destroy());this.events=this.eventListeners=null},clone:function(a){a==
null&&(a=new OpenLayers.Layer(this.name,this.getOptions()));OpenLayers.Util.applyDefaults(a,this);a.map=null;return a},getOptions:function(){var a={},b;for(b in this.options)a[b]=this[b];return a},setName:function(a){if(a!=this.name)this.name=a,this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"name"})},addOptions:function(a,b){if(this.options==null)this.options={};OpenLayers.Util.extend(this.options,a);OpenLayers.Util.extend(this,a);if(typeof this.projection=="string")this.projection=
new OpenLayers.Projection(this.projection);if(this.projection&&this.projection.getUnits())this.units=this.projection.getUnits();if(this.map){var c=this.map.getResolution(),d=this.RESOLUTION_PROPERTIES.concat(["projection","units","minExtent","maxExtent"]),e;for(e in a)if(a.hasOwnProperty(e)&&OpenLayers.Util.indexOf(d,e)>=0){this.initResolutions();b&&this.map.baseLayer===this&&(this.map.setCenter(this.map.getCenter(),this.map.getZoomForResolution(c),!1,!0),this.map.events.triggerEvent("changebaselayer",
{layer:this}));break}}},onMapResize:function(){},redraw:function(){var a=!1;if(this.map){this.inRange=this.calculateInRange();var b=this.getExtent();b&&this.inRange&&this.visibility&&(this.moveTo(b,!0,!1),this.events.triggerEvent("moveend",{zoomChanged:!0}),a=!0)}return a},moveTo:function(){var a=this.visibility;this.isBaseLayer||(a=a&&this.inRange);this.display(a)},moveByPx:function(){},setMap:function(a){if(this.map==null){this.map=a;this.maxExtent=this.maxExtent||this.map.maxExtent;this.minExtent=
this.minExtent||this.map.minExtent;this.projection=this.projection||this.map.projection;if(typeof this.projection=="string")this.projection=new OpenLayers.Projection(this.projection);this.units=this.projection.getUnits()||this.units||this.map.units;this.initResolutions();if(!this.isBaseLayer)this.inRange=this.calculateInRange(),this.div.style.display=this.visibility&&this.inRange?"":"none";this.setTileSize()}},afterAdd:function(){},removeMap:function(){},getImageSize:function(){return this.imageSize||
this.tileSize},setTileSize:function(a){this.tileSize=a=a?a:this.tileSize?this.tileSize:this.map.getTileSize();if(this.gutter)this.imageOffset=new OpenLayers.Pixel(-this.gutter,-this.gutter),this.imageSize=new OpenLayers.Size(a.w+2*this.gutter,a.h+2*this.gutter)},getVisibility:function(){return this.visibility},setVisibility:function(a){if(a!=this.visibility)this.visibility=a,this.display(a),this.redraw(),this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"}),
this.events.triggerEvent("visibilitychanged")},display:function(a){if(a!=(this.div.style.display!="none"))this.div.style.display=a&&this.calculateInRange()?"block":"none"},calculateInRange:function(){var a=!1;this.alwaysInRange?a=!0:this.map&&(a=this.map.getResolution(),a=a>=this.minResolution&&a<=this.maxResolution);return a},setIsBaseLayer:function(a){if(a!=this.isBaseLayer)this.isBaseLayer=a,this.map!=null&&this.map.events.triggerEvent("changebaselayer",{layer:this})},initResolutions:function(){var a,
b,c,d={},e=!0;for(a=0,b=this.RESOLUTION_PROPERTIES.length;a<b;a++)c=this.RESOLUTION_PROPERTIES[a],d[c]=this.options[c],e&&this.options[c]&&(e=!1);if(this.alwaysInRange==null)this.alwaysInRange=e;if(d.resolutions==null)d.resolutions=this.resolutionsFromScales(d.scales);if(d.resolutions==null)d.resolutions=this.calculateResolutions(d);if(d.resolutions==null){for(a=0,b=this.RESOLUTION_PROPERTIES.length;a<b;a++)c=this.RESOLUTION_PROPERTIES[a],d[c]=this.options[c]!=null?this.options[c]:this.map[c];if(d.resolutions==
null)d.resolutions=this.resolutionsFromScales(d.scales);if(d.resolutions==null)d.resolutions=this.calculateResolutions(d)}var f;if(this.options.maxResolution&&this.options.maxResolution!=="auto")f=this.options.maxResolution;this.options.minScale&&(f=OpenLayers.Util.getResolutionFromScale(this.options.minScale,this.units));var g;if(this.options.minResolution&&this.options.minResolution!=="auto")g=this.options.minResolution;this.options.maxScale&&(g=OpenLayers.Util.getResolutionFromScale(this.options.maxScale,
this.units));d.resolutions&&(d.resolutions.sort(function(a,b){return b-a}),f||(f=d.resolutions[0]),g||(g=d.resolutions[d.resolutions.length-1]));if(this.resolutions=d.resolutions){b=this.resolutions.length;this.scales=Array(b);for(a=0;a<b;a++)this.scales[a]=OpenLayers.Util.getScaleFromResolution(this.resolutions[a],this.units);this.numZoomLevels=b}if(this.minResolution=g)this.maxScale=OpenLayers.Util.getScaleFromResolution(g,this.units);if(this.maxResolution=f)this.minScale=OpenLayers.Util.getScaleFromResolution(f,
this.units)},resolutionsFromScales:function(a){if(a!=null){var b,c,d;d=a.length;b=Array(d);for(c=0;c<d;c++)b[c]=OpenLayers.Util.getResolutionFromScale(a[c],this.units);return b}},calculateResolutions:function(a){var b,c,d=a.maxResolution;a.minScale!=null?d=OpenLayers.Util.getResolutionFromScale(a.minScale,this.units):d=="auto"&&this.maxExtent!=null&&(b=this.map.getSize(),c=this.maxExtent.getWidth()/b.w,b=this.maxExtent.getHeight()/b.h,d=Math.max(c,b));c=a.minResolution;a.maxScale!=null?c=OpenLayers.Util.getResolutionFromScale(a.maxScale,
this.units):a.minResolution=="auto"&&this.minExtent!=null&&(b=this.map.getSize(),c=this.minExtent.getWidth()/b.w,b=this.minExtent.getHeight()/b.h,c=Math.max(c,b));b=a.maxZoomLevel;a=a.numZoomLevels;typeof c==="number"&&typeof d==="number"&&a===void 0?a=Math.floor(Math.log(d/c)/Math.log(2))+1:a===void 0&&b!=null&&(a=b+1);if(!(typeof a!=="number"||a<=0||typeof d!=="number"&&typeof c!=="number")){b=Array(a);var e=2;typeof c=="number"&&typeof d=="number"&&(e=Math.pow(d/c,1/(a-1)));var f;if(typeof d===
"number")for(f=0;f<a;f++)b[f]=d/Math.pow(e,f);else for(f=0;f<a;f++)b[a-1-f]=c*Math.pow(e,f);return b}},getResolution:function(){return this.getResolutionForZoom(this.map.getZoom())},getExtent:function(){return this.map.calculateBounds()},getZoomForExtent:function(a,b){var c=this.map.getSize();return this.getZoomForResolution(Math.max(a.getWidth()/c.w,a.getHeight()/c.h),b)},getDataExtent:function(){},getResolutionForZoom:function(a){a=Math.max(0,Math.min(a,this.resolutions.length-1));if(this.map.fractionalZoom)var b=
Math.floor(a),c=Math.ceil(a),a=this.resolutions[b]-(a-b)*(this.resolutions[b]-this.resolutions[c]);else a=this.resolutions[Math.round(a)];return a},getZoomForResolution:function(a,b){var c,d;if(this.map.fractionalZoom){var e=0,f=this.resolutions[e],g=this.resolutions[this.resolutions.length-1],h;for(c=0,d=this.resolutions.length;c<d;++c)if(h=this.resolutions[c],h>=a&&(f=h,e=c),h<=a){g=h;break}c=f-g;c=c>0?e+(f-a)/c:e}else{f=Number.POSITIVE_INFINITY;for(c=0,d=this.resolutions.length;c<d;c++)if(b){e=
Math.abs(this.resolutions[c]-a);if(e>f)break;f=e}else if(this.resolutions[c]<a)break;c=Math.max(0,c-1)}return c},getLonLatFromViewPortPx:function(a){var b=null,c=this.map;if(a!=null&&c.minPx){var b=c.getResolution(),d=c.getMaxExtent({restricted:!0}),b=new OpenLayers.LonLat((a.x-c.minPx.x)*b+d.left,(c.minPx.y-a.y)*b+d.top);this.wrapDateLine&&(b=b.wrapDateLine(this.maxExtent))}return b},getViewPortPxFromLonLat:function(a){var b=null;if(a!=null)var b=this.map.getResolution(),c=this.map.getExtent(),b=
new OpenLayers.Pixel(1/b*(a.lon-c.left),1/b*(c.top-a.lat));return b},setOpacity:function(a){if(a!=this.opacity){this.opacity=a;for(var b=0,c=this.div.childNodes.length;b<c;++b)OpenLayers.Util.modifyDOMElement(this.div.childNodes[b].firstChild,null,null,null,null,null,null,a);this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"opacity"})}},getZIndex:function(){return this.div.style.zIndex},setZIndex:function(a){this.div.style.zIndex=a},adjustBounds:function(a){if(this.gutter)var b=
this.gutter*this.map.getResolution(),a=new OpenLayers.Bounds(a.left-b,a.bottom-b,a.right+b,a.top+b);this.wrapDateLine&&(b={rightTolerance:this.getResolution(),leftTolerance:this.getResolution()},a=a.wrapDateLine(this.maxExtent,b));return a},CLASS_NAME:"OpenLayers.Layer"});
OpenLayers.Layer.Markers=OpenLayers.Class(OpenLayers.Layer,{isBaseLayer:!1,markers:null,drawn:!1,initialize:function(a,b){OpenLayers.Layer.prototype.initialize.apply(this,arguments);this.markers=[]},destroy:function(){this.clearMarkers();this.markers=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},setOpacity:function(a){if(a!=this.opacity){this.opacity=a;for(var a=0,b=this.markers.length;a<b;a++)this.markers[a].setOpacity(this.opacity)}},moveTo:function(a,b,c){OpenLayers.Layer.prototype.moveTo.apply(this,
arguments);if(b||!this.drawn){for(var d=0,e=this.markers.length;d<e;d++)this.drawMarker(this.markers[d]);this.drawn=!0}},addMarker:function(a){this.markers.push(a);this.opacity!=null&&a.setOpacity(this.opacity);if(this.map&&this.map.getExtent())a.map=this.map,this.drawMarker(a)},removeMarker:function(a){this.markers&&this.markers.length&&(OpenLayers.Util.removeItem(this.markers,a),a.erase())},clearMarkers:function(){if(this.markers!=null)for(;this.markers.length>0;)this.removeMarker(this.markers[0])},
drawMarker:function(a){var b=this.map.getLayerPxFromLonLat(a.lonlat);b==null?a.display(!1):a.isDrawn()?a.icon&&a.icon.moveTo(b):this.div.appendChild(a.draw(b))},getDataExtent:function(){var a=null;if(this.markers&&this.markers.length>0)for(var a=new OpenLayers.Bounds,b=0,c=this.markers.length;b<c;b++)a.extend(this.markers[b].lonlat);return a},CLASS_NAME:"OpenLayers.Layer.Markers"});
OpenLayers.Control.Pan=OpenLayers.Class(OpenLayers.Control,{slideFactor:50,slideRatio:null,direction:null,type:OpenLayers.Control.TYPE_BUTTON,initialize:function(a,b){this.direction=a;this.CLASS_NAME+=this.direction;OpenLayers.Control.prototype.initialize.apply(this,[b])},trigger:function(){var a=OpenLayers.Function.bind(function(a){return this.slideRatio?this.map.getSize()[a]*this.slideRatio:this.slideFactor},this);switch(this.direction){case OpenLayers.Control.Pan.NORTH:this.map.pan(0,-a("h"));
break;case OpenLayers.Control.Pan.SOUTH:this.map.pan(0,a("h"));break;case OpenLayers.Control.Pan.WEST:this.map.pan(-a("w"),0);break;case OpenLayers.Control.Pan.EAST:this.map.pan(a("w"),0)}},CLASS_NAME:"OpenLayers.Control.Pan"});OpenLayers.Control.Pan.NORTH="North";OpenLayers.Control.Pan.SOUTH="South";OpenLayers.Control.Pan.EAST="East";OpenLayers.Control.Pan.WEST="West";
OpenLayers.Handler.Feature=OpenLayers.Class(OpenLayers.Handler,{EVENTMAP:{click:{"in":"click",out:"clickout"},mousemove:{"in":"over",out:"out"},dblclick:{"in":"dblclick",out:null},mousedown:{"in":null,out:null},mouseup:{"in":null,out:null},touchstart:{"in":"click",out:"clickout"}},feature:null,lastFeature:null,down:null,up:null,touch:!1,clickTolerance:4,geometryTypes:null,stopClick:!0,stopDown:!0,stopUp:!1,initialize:function(a,b,c,d){OpenLayers.Handler.prototype.initialize.apply(this,[a,c,d]);this.layer=
b},touchstart:function(a){if(!this.touch)this.touch=!0,this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,click:this.click,dblclick:this.dblclick,scope:this});return OpenLayers.Event.isMultiTouch(a)?!0:this.mousedown(a)},touchmove:function(a){OpenLayers.Event.stop(a)},mousedown:function(a){this.down=a.xy;return this.handle(a)?!this.stopDown:!0},mouseup:function(a){this.up=a.xy;return this.handle(a)?!this.stopUp:!0},click:function(a){return this.handle(a)?!this.stopClick:
!0},mousemove:function(a){if(!this.callbacks.over&&!this.callbacks.out)return!0;this.handle(a);return!0},dblclick:function(a){return!this.handle(a)},geometryTypeMatches:function(a){return this.geometryTypes==null||OpenLayers.Util.indexOf(this.geometryTypes,a.geometry.CLASS_NAME)>-1},handle:function(a){if(this.feature&&!this.feature.layer)this.feature=null;var b=a.type,c=!1,d=!!this.feature,e=b=="click"||b=="dblclick"||b=="touchstart";if((this.feature=this.layer.getFeatureFromEvent(a))&&!this.feature.layer)this.feature=
null;if(this.lastFeature&&!this.lastFeature.layer)this.lastFeature=null;this.feature?(b==="touchstart"&&OpenLayers.Event.stop(a),a=this.feature!=this.lastFeature,this.geometryTypeMatches(this.feature)?(d&&a?(this.lastFeature&&this.triggerCallback(b,"out",[this.lastFeature]),this.triggerCallback(b,"in",[this.feature])):(!d||e)&&this.triggerCallback(b,"in",[this.feature]),this.lastFeature=this.feature,c=!0):(this.lastFeature&&(d&&a||e)&&this.triggerCallback(b,"out",[this.lastFeature]),this.feature=
null)):this.lastFeature&&(d||e)&&this.triggerCallback(b,"out",[this.lastFeature]);return c},triggerCallback:function(a,b,c){(b=this.EVENTMAP[a][b])&&(a=="click"&&this.up&&this.down?Math.sqrt(Math.pow(this.up.x-this.down.x,2)+Math.pow(this.up.y-this.down.y,2))<=this.clickTolerance&&this.callback(b,c):this.callback(b,c))},activate:function(){var a=!1;OpenLayers.Handler.prototype.activate.apply(this,arguments)&&(this.moveLayerToTop(),this.map.events.on({removelayer:this.handleMapEvents,changelayer:this.handleMapEvents,
scope:this}),a=!0);return a},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments))this.moveLayerBack(),this.up=this.down=this.lastFeature=this.feature=null,this.touch=!1,this.map.events.un({removelayer:this.handleMapEvents,changelayer:this.handleMapEvents,scope:this}),a=!0;return a},handleMapEvents:function(a){(a.type=="removelayer"||a.property=="order")&&this.moveLayerToTop()},moveLayerToTop:function(){this.layer.setZIndex(Math.max(this.map.Z_INDEX_BASE.Feature-
1,this.layer.getZIndex())+1)},moveLayerBack:function(){var a=this.layer.getZIndex()-1;a>=this.map.Z_INDEX_BASE.Feature?this.layer.setZIndex(a):this.map.setLayerZIndex(this.layer,this.map.getLayerIndex(this.layer))},CLASS_NAME:"OpenLayers.Handler.Feature"});
OpenLayers.Style=OpenLayers.Class({id:null,name:null,title:null,description:null,layerName:null,isDefault:!1,rules:null,context:null,defaultStyle:null,defaultsPerSymbolizer:!1,propertyStyles:null,initialize:function(a,b){OpenLayers.Util.extend(this,b);this.rules=[];b&&b.rules&&this.addRules(b.rules);this.setDefaultStyle(a||OpenLayers.Feature.Vector.style["default"]);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){for(var a=0,b=this.rules.length;a<b;a++)this.rules[a].destroy(),
this.rules[a]=null;this.defaultStyle=this.rules=null},createSymbolizer:function(a){for(var b=this.defaultsPerSymbolizer?{}:this.createLiterals(OpenLayers.Util.extend({},this.defaultStyle),a),c=this.rules,d,e=[],f=!1,g=0,h=c.length;g<h;g++)d=c[g],d.evaluate(a)&&(d instanceof OpenLayers.Rule&&d.elseFilter?e.push(d):(f=!0,this.applySymbolizer(d,b,a)));if(f==!1&&e.length>0){f=!0;g=0;for(h=e.length;g<h;g++)this.applySymbolizer(e[g],b,a)}if(c.length>0&&f==!1)b.display="none";if(b.label&&typeof b.label!==
"string")b.label=String(b.label);return b},applySymbolizer:function(a,b,c){var d=c.geometry?this.getSymbolizerPrefix(c.geometry):OpenLayers.Style.SYMBOLIZER_PREFIXES[0],a=a.symbolizer[d]||a.symbolizer;if(this.defaultsPerSymbolizer===!0)d=this.defaultStyle,OpenLayers.Util.applyDefaults(a,{pointRadius:d.pointRadius}),(a.stroke===!0||a.graphic===!0)&&OpenLayers.Util.applyDefaults(a,{strokeWidth:d.strokeWidth,strokeColor:d.strokeColor,strokeOpacity:d.strokeOpacity,strokeDashstyle:d.strokeDashstyle,strokeLinecap:d.strokeLinecap}),
(a.fill===!0||a.graphic===!0)&&OpenLayers.Util.applyDefaults(a,{fillColor:d.fillColor,fillOpacity:d.fillOpacity}),a.graphic===!0&&OpenLayers.Util.applyDefaults(a,{pointRadius:this.defaultStyle.pointRadius,externalGraphic:this.defaultStyle.externalGraphic,graphicName:this.defaultStyle.graphicName,graphicOpacity:this.defaultStyle.graphicOpacity,graphicWidth:this.defaultStyle.graphicWidth,graphicHeight:this.defaultStyle.graphicHeight,graphicXOffset:this.defaultStyle.graphicXOffset,graphicYOffset:this.defaultStyle.graphicYOffset});
return this.createLiterals(OpenLayers.Util.extend(b,a),c)},createLiterals:function(a,b){var c=OpenLayers.Util.extend({},b.attributes||b.data);OpenLayers.Util.extend(c,this.context);for(var d in this.propertyStyles)a[d]=OpenLayers.Style.createLiteral(a[d],c,b,d);return a},findPropertyStyles:function(){var a={};this.addPropertyStyles(a,this.defaultStyle);for(var b=this.rules,c,d,e=0,f=b.length;e<f;e++){c=b[e].symbolizer;for(var g in c)if(d=c[g],typeof d=="object")this.addPropertyStyles(a,d);else{this.addPropertyStyles(a,
c);break}}return a},addPropertyStyles:function(a,b){var c,d;for(d in b)c=b[d],typeof c=="string"&&c.match(/\$\{\w+\}/)&&(a[d]=!0);return a},addRules:function(a){Array.prototype.push.apply(this.rules,a);this.propertyStyles=this.findPropertyStyles()},setDefaultStyle:function(a){this.defaultStyle=a;this.propertyStyles=this.findPropertyStyles()},getSymbolizerPrefix:function(a){for(var b=OpenLayers.Style.SYMBOLIZER_PREFIXES,c=0,d=b.length;c<d;c++)if(a.CLASS_NAME.indexOf(b[c])!=-1)return b[c]},clone:function(){var a=
OpenLayers.Util.extend({},this);if(this.rules){a.rules=[];for(var b=0,c=this.rules.length;b<c;++b)a.rules.push(this.rules[b].clone())}a.context=this.context&&OpenLayers.Util.extend({},this.context);b=OpenLayers.Util.extend({},this.defaultStyle);return new OpenLayers.Style(b,a)},CLASS_NAME:"OpenLayers.Style"});OpenLayers.Style.createLiteral=function(a,b,c,d){typeof a=="string"&&a.indexOf("${")!=-1&&(a=OpenLayers.String.format(a,b,[c,d]),a=isNaN(a)||!a?a:parseFloat(a));return a};
OpenLayers.Style.SYMBOLIZER_PREFIXES=["Point","Line","Polygon","Text","Raster"];
OpenLayers.StyleMap=OpenLayers.Class({styles:null,extendDefault:!0,initialize:function(a,b){this.styles={"default":new OpenLayers.Style(OpenLayers.Feature.Vector.style["default"]),select:new OpenLayers.Style(OpenLayers.Feature.Vector.style.select),temporary:new OpenLayers.Style(OpenLayers.Feature.Vector.style.temporary),"delete":new OpenLayers.Style(OpenLayers.Feature.Vector.style["delete"])};if(a instanceof OpenLayers.Style)this.styles["default"]=a,this.styles.select=a,this.styles.temporary=a,this.styles["delete"]=
a;else if(typeof a=="object")for(var c in a)if(a[c]instanceof OpenLayers.Style)this.styles[c]=a[c];else if(typeof a[c]=="object")this.styles[c]=new OpenLayers.Style(a[c]);else{this.styles["default"]=new OpenLayers.Style(a);this.styles.select=new OpenLayers.Style(a);this.styles.temporary=new OpenLayers.Style(a);this.styles["delete"]=new OpenLayers.Style(a);break}OpenLayers.Util.extend(this,b)},destroy:function(){for(var a in this.styles)this.styles[a].destroy();this.styles=null},createSymbolizer:function(a,
b){a||(a=new OpenLayers.Feature.Vector);this.styles[b]||(b="default");a.renderIntent=b;var c={};this.extendDefault&&b!="default"&&(c=this.styles["default"].createSymbolizer(a));return OpenLayers.Util.extend(c,this.styles[b].createSymbolizer(a))},addUniqueValueRules:function(a,b,c,d){var e=[],f;for(f in c)e.push(new OpenLayers.Rule({symbolizer:c[f],context:d,filter:new OpenLayers.Filter.Comparison({type:OpenLayers.Filter.Comparison.EQUAL_TO,property:b,value:f})}));this.styles[a].addRules(e)},CLASS_NAME:"OpenLayers.StyleMap"});
OpenLayers.Layer.Vector=OpenLayers.Class(OpenLayers.Layer,{EVENT_TYPES:"beforefeatureadded,beforefeaturesadded,featureadded,featuresadded,beforefeatureremoved,beforefeaturesremoved,featureremoved,featuresremoved,beforefeatureselected,featureselected,featureunselected,beforefeaturemodified,featuremodified,afterfeaturemodified,vertexmodified,vertexremoved,sketchstarted,sketchmodified,sketchcomplete,refresh".split(","),isBaseLayer:!1,isFixed:!1,features:null,filter:null,selectedFeatures:null,unrenderedFeatures:null,
reportError:!0,style:null,styleMap:null,strategies:null,protocol:null,renderers:["SVG","VML","Canvas"],renderer:null,rendererOptions:null,geometryType:null,drawn:!1,initialize:function(a,b){this.EVENT_TYPES=OpenLayers.Layer.Vector.prototype.EVENT_TYPES.concat(OpenLayers.Layer.prototype.EVENT_TYPES);OpenLayers.Layer.prototype.initialize.apply(this,arguments);(!this.renderer||!this.renderer.supported())&&this.assignRenderer();if(!this.renderer||!this.renderer.supported())this.renderer=null,this.displayError();
if(!this.styleMap)this.styleMap=new OpenLayers.StyleMap;this.features=[];this.selectedFeatures=[];this.unrenderedFeatures={};if(this.strategies)for(var c=0,d=this.strategies.length;c<d;c++)this.strategies[c].setLayer(this)},destroy:function(){if(this.strategies){var a,b,c;for(b=0,c=this.strategies.length;b<c;b++)a=this.strategies[b],a.autoDestroy&&a.destroy();this.strategies=null}if(this.protocol)this.protocol.autoDestroy&&this.protocol.destroy(),this.protocol=null;this.destroyFeatures();this.unrenderedFeatures=
this.selectedFeatures=this.features=null;this.renderer&&this.renderer.destroy();this.drawn=this.geometryType=this.renderer=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},clone:function(a){a==null&&(a=new OpenLayers.Layer.Vector(this.name,this.getOptions()));for(var a=OpenLayers.Layer.prototype.clone.apply(this,[a]),b=this.features,c=b.length,d=Array(c),e=0;e<c;++e)d[e]=b[e].clone();a.features=d;return a},refresh:function(a){this.calculateInRange()&&this.visibility&&this.events.triggerEvent("refresh",
a)},assignRenderer:function(){for(var a=0,b=this.renderers.length;a<b;a++){var c=this.renderers[a];if((c=typeof c=="function"?c:OpenLayers.Renderer[c])&&c.prototype.supported()){this.renderer=new c(this.div,this.rendererOptions);break}}},displayError:function(){this.reportError&&OpenLayers.Console.userError(OpenLayers.i18n("browserNotSupported",{renderers:this.renderers.join("\n")}))},setMap:function(a){OpenLayers.Layer.prototype.setMap.apply(this,arguments);this.renderer?(this.renderer.map=this.map,
this.renderer.setSize(this.map.getSize())):this.map.removeLayer(this)},afterAdd:function(){if(this.strategies){var a,b,c;for(b=0,c=this.strategies.length;b<c;b++)a=this.strategies[b],a.autoActivate&&a.activate()}},removeMap:function(){this.drawn=!1;if(this.strategies){var a,b,c;for(b=0,c=this.strategies.length;b<c;b++)a=this.strategies[b],a.autoActivate&&a.deactivate()}},onMapResize:function(){OpenLayers.Layer.prototype.onMapResize.apply(this,arguments);this.renderer.setSize(this.map.getSize())},
moveTo:function(a,b,c){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);var d=OpenLayers.Renderer.NG&&this.renderer instanceof OpenLayers.Renderer.NG;if(d)c||this.renderer.updateDimensions(b);else{var e=!0;if(!c){this.renderer.root.style.visibility="hidden";this.div.style.left=-parseInt(this.map.layerContainerDiv.style.left)+"px";this.div.style.top=-parseInt(this.map.layerContainerDiv.style.top)+"px";e=this.renderer.setExtent(this.map.getExtent(),b);this.renderer.root.style.visibility="visible";
if(OpenLayers.IS_GECKO===!0)this.div.scrollLeft=this.div.scrollLeft;if(!b&&e)for(var f in this.unrenderedFeatures){var g=this.unrenderedFeatures[f];this.drawFeature(g)}}}if(!this.drawn||!d&&(b||!e)){this.drawn=!0;f=0;for(d=this.features.length;f<d;f++)this.renderer.locked=f!==d-1,g=this.features[f],this.drawFeature(g)}},redraw:function(){if(OpenLayers.Renderer.NG&&this.renderer instanceof OpenLayers.Renderer.NG)this.drawn=!1;return OpenLayers.Layer.prototype.redraw.apply(this,arguments)},display:function(a){OpenLayers.Layer.prototype.display.apply(this,
arguments);var b=this.div.style.display;if(b!=this.renderer.root.style.display)this.renderer.root.style.display=b},addFeatures:function(a,b){OpenLayers.Util.isArray(a)||(a=[a]);var c=!b||!b.silent;if(c){var d={features:a};if(this.events.triggerEvent("beforefeaturesadded",d)===!1)return;a=d.features}for(var d=[],e=0,f=a.length;e<f;e++){this.renderer.locked=e!=a.length-1?!0:!1;var g=a[e];if(this.geometryType&&!(g.geometry instanceof this.geometryType))throw OpenLayers.i18n("componentShouldBe",{geomType:this.geometryType.prototype.CLASS_NAME});
g.layer=this;if(!g.style&&this.style)g.style=OpenLayers.Util.extend({},this.style);if(c){if(this.events.triggerEvent("beforefeatureadded",{feature:g})===!1)continue;this.preFeatureInsert(g)}d.push(g);this.features.push(g);this.drawFeature(g);c&&(this.events.triggerEvent("featureadded",{feature:g}),this.onFeatureInsert(g))}c&&this.events.triggerEvent("featuresadded",{features:d})},removeFeatures:function(a,b){if(a&&a.length!==0){if(a===this.features)return this.removeAllFeatures(b);OpenLayers.Util.isArray(a)||
(a=[a]);a===this.selectedFeatures&&(a=a.slice());var c=!b||!b.silent;c&&this.events.triggerEvent("beforefeaturesremoved",{features:a});for(var d=a.length-1;d>=0;d--){this.renderer.locked=d!=0&&a[d-1].geometry?!0:!1;var e=a[d];delete this.unrenderedFeatures[e.id];c&&this.events.triggerEvent("beforefeatureremoved",{feature:e});this.features=OpenLayers.Util.removeItem(this.features,e);e.layer=null;e.geometry&&this.renderer.eraseFeatures(e);OpenLayers.Util.indexOf(this.selectedFeatures,e)!=-1&&OpenLayers.Util.removeItem(this.selectedFeatures,
e);c&&this.events.triggerEvent("featureremoved",{feature:e})}c&&this.events.triggerEvent("featuresremoved",{features:a})}},removeAllFeatures:function(a){var a=!a||!a.silent,b=this.features;a&&this.events.triggerEvent("beforefeaturesremoved",{features:b});for(var c,d=b.length-1;d>=0;d--)c=b[d],a&&this.events.triggerEvent("beforefeatureremoved",{feature:c}),c.layer=null,a&&this.events.triggerEvent("featureremoved",{feature:c});this.renderer.clear();this.features=[];this.unrenderedFeatures={};this.selectedFeatures=
[];a&&this.events.triggerEvent("featuresremoved",{features:b})},destroyFeatures:function(a,b){if(a==void 0)a=this.features;if(a){this.removeFeatures(a,b);for(var c=a.length-1;c>=0;c--)a[c].destroy()}},drawFeature:function(a,b){if(this.drawn){if(typeof b!="object"){!b&&a.state===OpenLayers.State.DELETE&&(b="delete");var c=b||a.renderIntent;(b=a.style||this.style)||(b=this.styleMap.createSymbolizer(a,c))}c=this.renderer.drawFeature(a,b);c===!1||c===null?this.unrenderedFeatures[a.id]=a:delete this.unrenderedFeatures[a.id]}},
eraseFeatures:function(a){this.renderer.eraseFeatures(a)},getFeatureFromEvent:function(a){if(!this.renderer)return OpenLayers.Console.error(OpenLayers.i18n("getFeatureError")),null;var b=null;(a=this.renderer.getFeatureIdFromEvent(a))&&(b=typeof a==="string"?this.getFeatureById(a):a);return b},getFeatureBy:function(a,b){for(var c=null,d=0,e=this.features.length;d<e;++d)if(this.features[d][a]==b){c=this.features[d];break}return c},getFeatureById:function(a){return this.getFeatureBy("id",a)},getFeatureByFid:function(a){return this.getFeatureBy("fid",
a)},getFeaturesByAttribute:function(a,b){var c,d,e=this.features.length,f=[];for(c=0;c<e;c++)(d=this.features[c])&&d.attributes&&d.attributes[a]===b&&f.push(d);return f},onFeatureInsert:function(){},preFeatureInsert:function(){},getDataExtent:function(){var a=null,b=this.features;if(b&&b.length>0)for(var c=null,d=0,e=b.length;d<e;d++)if(c=b[d].geometry)a===null&&(a=new OpenLayers.Bounds),a.extend(c.getBounds());return a},CLASS_NAME:"OpenLayers.Layer.Vector"});
OpenLayers.Layer.Vector.RootContainer=OpenLayers.Class(OpenLayers.Layer.Vector,{displayInLayerSwitcher:!1,layers:null,initialize:function(a,b){OpenLayers.Layer.Vector.prototype.initialize.apply(this,arguments)},display:function(){},getFeatureFromEvent:function(a){for(var b=this.layers,c,d=0;d<b.length;d++)if(c=b[d].getFeatureFromEvent(a))return c},setMap:function(a){OpenLayers.Layer.Vector.prototype.setMap.apply(this,arguments);this.collectRoots();a.events.register("changelayer",this,this.handleChangeLayer)},
removeMap:function(a){a.events.unregister("changelayer",this,this.handleChangeLayer);this.resetRoots();OpenLayers.Layer.Vector.prototype.removeMap.apply(this,arguments)},collectRoots:function(){for(var a,b=0;b<this.map.layers.length;++b)a=this.map.layers[b],OpenLayers.Util.indexOf(this.layers,a)!=-1&&a.renderer.moveRoot(this.renderer)},resetRoots:function(){for(var a,b=0;b<this.layers.length;++b)a=this.layers[b],this.renderer&&a.renderer.getRenderLayerId()==this.id&&this.renderer.moveRoot(a.renderer)},
handleChangeLayer:function(a){var b=a.layer;a.property=="order"&&OpenLayers.Util.indexOf(this.layers,b)!=-1&&(this.resetRoots(),this.collectRoots())},CLASS_NAME:"OpenLayers.Layer.Vector.RootContainer"});
OpenLayers.Control.SelectFeature=OpenLayers.Class(OpenLayers.Control,{EVENT_TYPES:["beforefeaturehighlighted","featurehighlighted","featureunhighlighted"],multipleKey:null,toggleKey:null,multiple:!1,clickout:!0,toggle:!1,hover:!1,highlightOnly:!1,box:!1,onBeforeSelect:function(){},onSelect:function(){},onUnselect:function(){},scope:null,geometryTypes:null,layer:null,layers:null,callbacks:null,selectStyle:null,renderIntent:"select",handlers:null,initialize:function(a,b){this.EVENT_TYPES=OpenLayers.Control.SelectFeature.prototype.EVENT_TYPES.concat(OpenLayers.Control.prototype.EVENT_TYPES);
OpenLayers.Control.prototype.initialize.apply(this,[b]);if(this.scope===null)this.scope=this;this.initLayer(a);var c={click:this.clickFeature,clickout:this.clickoutFeature};if(this.hover)c.over=this.overFeature,c.out=this.outFeature;this.callbacks=OpenLayers.Util.extend(c,this.callbacks);this.handlers={feature:new OpenLayers.Handler.Feature(this,this.layer,this.callbacks,{geometryTypes:this.geometryTypes})};if(this.box)this.handlers.box=new OpenLayers.Handler.Box(this,{done:this.selectBox},{boxDivClassName:"olHandlerBoxSelectFeature"})},
initLayer:function(a){OpenLayers.Util.isArray(a)?(this.layers=a,this.layer=new OpenLayers.Layer.Vector.RootContainer(this.id+"_container",{layers:a})):this.layer=a},destroy:function(){this.active&&this.layers&&this.map.removeLayer(this.layer);OpenLayers.Control.prototype.destroy.apply(this,arguments);this.layers&&this.layer.destroy()},activate:function(){this.active||(this.layers&&this.map.addLayer(this.layer),this.handlers.feature.activate(),this.box&&this.handlers.box&&this.handlers.box.activate());
return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.active&&(this.handlers.feature.deactivate(),this.handlers.box&&this.handlers.box.deactivate(),this.layers&&this.map.removeLayer(this.layer));return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},unselectAll:function(a){for(var b=this.layers||[this.layer],c,d,e=0;e<b.length;++e){c=b[e];for(var f=c.selectedFeatures.length-1;f>=0;--f)d=c.selectedFeatures[f],(!a||a.except!=d)&&this.unselect(d)}},
clickFeature:function(a){this.hover||(OpenLayers.Util.indexOf(a.layer.selectedFeatures,a)>-1?this.toggleSelect()?this.unselect(a):this.multipleSelect()||this.unselectAll({except:a}):(this.multipleSelect()||this.unselectAll({except:a}),this.select(a)))},multipleSelect:function(){return this.multiple||this.handlers.feature.evt&&this.handlers.feature.evt[this.multipleKey]},toggleSelect:function(){return this.toggle||this.handlers.feature.evt&&this.handlers.feature.evt[this.toggleKey]},clickoutFeature:function(){!this.hover&&
this.clickout&&this.unselectAll()},overFeature:function(a){var b=a.layer;this.hover&&(this.highlightOnly?this.highlight(a):OpenLayers.Util.indexOf(b.selectedFeatures,a)==-1&&this.select(a))},outFeature:function(a){if(this.hover)if(this.highlightOnly){if(a._lastHighlighter==this.id)if(a._prevHighlighter&&a._prevHighlighter!=this.id){delete a._lastHighlighter;var b=this.map.getControl(a._prevHighlighter);b&&b.highlight(a)}else this.unhighlight(a)}else this.unselect(a)},highlight:function(a){var b=a.layer;
if(this.events.triggerEvent("beforefeaturehighlighted",{feature:a})!==!1)a._prevHighlighter=a._lastHighlighter,a._lastHighlighter=this.id,b.drawFeature(a,this.selectStyle||this.renderIntent),this.events.triggerEvent("featurehighlighted",{feature:a})},unhighlight:function(a){var b=a.layer;if(a._prevHighlighter==void 0)delete a._lastHighlighter;else{if(a._prevHighlighter!=this.id)a._lastHighlighter=a._prevHighlighter;delete a._prevHighlighter}b.drawFeature(a,a.style||a.layer.style||"default");this.events.triggerEvent("featureunhighlighted",
{feature:a})},select:function(a){var b=this.onBeforeSelect.call(this.scope,a),c=a.layer;if(b!==!1&&(b=c.events.triggerEvent("beforefeatureselected",{feature:a}),b!==!1)){c.selectedFeatures.push(a);this.highlight(a);if(!this.handlers.feature.lastFeature)this.handlers.feature.lastFeature=c.selectedFeatures[0];c.events.triggerEvent("featureselected",{feature:a});this.onSelect.call(this.scope,a)}},unselect:function(a){var b=a.layer;this.unhighlight(a);OpenLayers.Util.removeItem(b.selectedFeatures,a);
b.events.triggerEvent("featureunselected",{feature:a});this.onUnselect.call(this.scope,a)},selectBox:function(a){if(a instanceof OpenLayers.Bounds){var b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom)),a=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top)),b=new OpenLayers.Bounds(b.lon,b.lat,a.lon,a.lat);this.multipleSelect()||this.unselectAll();a=this.multiple;this.multiple=!0;for(var c=this.layers||[this.layer],d,e=0;e<c.length;++e){d=c[e];for(var f=0,g=d.features.length;f<
g;++f){var h=d.features[f];h.getVisibility()&&(this.geometryTypes==null||OpenLayers.Util.indexOf(this.geometryTypes,h.geometry.CLASS_NAME)>-1)&&b.toGeometry().intersects(h.geometry)&&OpenLayers.Util.indexOf(d.selectedFeatures,h)==-1&&this.select(h)}}this.multiple=a}},setMap:function(a){this.handlers.feature.setMap(a);this.box&&this.handlers.box.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},setLayer:function(a){var b=this.active;this.unselectAll();this.deactivate();if(this.layers)this.layer.destroy(),
this.layers=null;this.initLayer(a);this.handlers.feature.layer=this.layer;b&&this.activate()},CLASS_NAME:"OpenLayers.Control.SelectFeature"});
OpenLayers.Request={DEFAULT_CONFIG:{method:"GET",url:window.location.href,async:!0,user:void 0,password:void 0,params:null,proxy:OpenLayers.ProxyHost,headers:{},data:null,callback:function(){},success:null,failure:null,scope:null},URL_SPLIT_REGEX:/([^:]*:)\/\/([^:]*:?[^@]*@)?([^:\/\?]*):?([^\/\?]*)/,events:new OpenLayers.Events(this,null,["complete","success","failure"]),issue:function(a){var b=OpenLayers.Util.extend(this.DEFAULT_CONFIG,{proxy:OpenLayers.ProxyHost}),a=OpenLayers.Util.applyDefaults(a,
b),c=new OpenLayers.Request.XMLHttpRequest,d=OpenLayers.Util.urlAppend(a.url,OpenLayers.Util.getParameterString(a.params||{})),b=d.indexOf("http")!=0,e=!b&&d.match(this.URL_SPLIT_REGEX);if(e){var f=window.location,b=e[1]==f.protocol&&e[3]==f.hostname,e=e[4],f=f.port;if(e!=80&&e!=""||f!="80"&&f!="")b=b&&e==f}b||(a.proxy?d=typeof a.proxy=="function"?a.proxy(d):a.proxy+encodeURIComponent(d):OpenLayers.Console.warn(OpenLayers.i18n("proxyNeeded"),{url:d}));c.open(a.method,d,a.async,a.user,a.password);
for(var g in a.headers)c.setRequestHeader(g,a.headers[g]);var h=this.events,i=this;c.onreadystatechange=function(){c.readyState==OpenLayers.Request.XMLHttpRequest.DONE&&h.triggerEvent("complete",{request:c,config:a,requestUrl:d})!==!1&&i.runCallbacks({request:c,config:a,requestUrl:d})};a.async===!1?c.send(a.data):window.setTimeout(function(){c.readyState!==0&&c.send(a.data)},0);return c},runCallbacks:function(a){var b=a.request,c=a.config,d=c.scope?OpenLayers.Function.bind(c.callback,c.scope):c.callback,
e;c.success&&(e=c.scope?OpenLayers.Function.bind(c.success,c.scope):c.success);var f;c.failure&&(f=c.scope?OpenLayers.Function.bind(c.failure,c.scope):c.failure);if(OpenLayers.Util.createUrlObject(c.url).protocol=="file:"&&b.responseText)b.status=200;d(b);if(!b.status||b.status>=200&&b.status<300)this.events.triggerEvent("success",a),e&&e(b);if(b.status&&(b.status<200||b.status>=300))this.events.triggerEvent("failure",a),f&&f(b)},GET:function(a){a=OpenLayers.Util.extend(a,{method:"GET"});return OpenLayers.Request.issue(a)},
POST:function(a){a=OpenLayers.Util.extend(a,{method:"POST"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},PUT:function(a){a=OpenLayers.Util.extend(a,{method:"PUT"});a.headers=a.headers?a.headers:{};"CONTENT-TYPE"in OpenLayers.Util.upperCaseObject(a.headers)||(a.headers["Content-Type"]="application/xml");return OpenLayers.Request.issue(a)},DELETE:function(a){a=OpenLayers.Util.extend(a,
{method:"DELETE"});return OpenLayers.Request.issue(a)},HEAD:function(a){a=OpenLayers.Util.extend(a,{method:"HEAD"});return OpenLayers.Request.issue(a)},OPTIONS:function(a){a=OpenLayers.Util.extend(a,{method:"OPTIONS"});return OpenLayers.Request.issue(a)}};
(function(){function a(){this._object=f&&!i?new f:new window.ActiveXObject("Microsoft.XMLHTTP");this._listeners=[]}function b(){return new a}function c(a){b.onreadystatechange&&b.onreadystatechange.apply(a);a.dispatchEvent({type:"readystatechange",bubbles:!1,cancelable:!1,timeStamp:new Date+0})}function d(a){try{a.responseText=a._object.responseText}catch(b){}try{var c=a._object,d=c.responseXML,e=c.responseText;if(h&&e&&d&&!d.documentElement&&c.getResponseHeader("Content-Type").match(/[^\/]+\/[^\+]+\+xml/))d=
new window.ActiveXObject("Microsoft.XMLDOM"),d.async=!1,d.validateOnParse=!1,d.loadXML(e);a.responseXML=d&&(h&&d.parseError!=0||!d.documentElement||d.documentElement&&d.documentElement.tagName=="parsererror")?null:d}catch(f){}try{a.status=a._object.status}catch(g){}try{a.statusText=a._object.statusText}catch(i){}}function e(a){a._object.onreadystatechange=new window.Function}var f=window.XMLHttpRequest,g=!!window.controllers,h=window.document.all&&!window.opera,i=h&&window.navigator.userAgent.match(/MSIE 7.0/);
b.prototype=a.prototype;if(g&&f.wrapped)b.wrapped=f.wrapped;b.UNSENT=0;b.OPENED=1;b.HEADERS_RECEIVED=2;b.LOADING=3;b.DONE=4;b.prototype.readyState=b.UNSENT;b.prototype.responseText="";b.prototype.responseXML=null;b.prototype.status=0;b.prototype.statusText="";b.prototype.priority="NORMAL";b.prototype.onreadystatechange=null;b.onreadystatechange=null;b.onopen=null;b.onsend=null;b.onabort=null;b.prototype.open=function(a,f,i,n,l){delete this._headers;arguments.length<3&&(i=!0);this._async=i;var m=this,
q=this.readyState,p;h&&i&&(p=function(){q!=b.DONE&&(e(m),m.abort())},window.attachEvent("onunload",p));b.onopen&&b.onopen.apply(this,arguments);arguments.length>4?this._object.open(a,f,i,n,l):arguments.length>3?this._object.open(a,f,i,n):this._object.open(a,f,i);this.readyState=b.OPENED;c(this);this._object.onreadystatechange=function(){if(!g||i)m.readyState=m._object.readyState,d(m),m._aborted?m.readyState=b.UNSENT:(m.readyState==b.DONE&&(delete m._data,e(m),h&&i&&window.detachEvent("onunload",p)),
q!=m.readyState&&c(m),q=m.readyState)}};b.prototype.send=function(a){b.onsend&&b.onsend.apply(this,arguments);arguments.length||(a=null);a&&a.nodeType&&(a=window.XMLSerializer?(new window.XMLSerializer).serializeToString(a):a.xml,oRequest._headers["Content-Type"]||oRequest._object.setRequestHeader("Content-Type","application/xml"));this._data=a;this._object.send(this._data);if(g&&!this._async){this.readyState=b.OPENED;for(d(this);this.readyState<b.DONE;)if(this.readyState++,c(this),this._aborted)break}};
b.prototype.abort=function(){b.onabort&&b.onabort.apply(this,arguments);if(this.readyState>b.UNSENT)this._aborted=!0;this._object.abort();e(this);this.readyState=b.UNSENT;delete this._data};b.prototype.getAllResponseHeaders=function(){return this._object.getAllResponseHeaders()};b.prototype.getResponseHeader=function(a){return this._object.getResponseHeader(a)};b.prototype.setRequestHeader=function(a,b){if(!this._headers)this._headers={};this._headers[a]=b;return this._object.setRequestHeader(a,b)};
b.prototype.addEventListener=function(a,b,c){for(var d=0,e;e=this._listeners[d];d++)if(e[0]==a&&e[1]==b&&e[2]==c)return;this._listeners.push([a,b,c])};b.prototype.removeEventListener=function(a,b,c){for(var d=0,e;e=this._listeners[d];d++)if(e[0]==a&&e[1]==b&&e[2]==c)break;e&&this._listeners.splice(d,1)};b.prototype.dispatchEvent=function(a){a={type:a.type,target:this,currentTarget:this,eventPhase:2,bubbles:a.bubbles,cancelable:a.cancelable,timeStamp:a.timeStamp,stopPropagation:function(){},preventDefault:function(){},
initEvent:function(){}};a.type=="readystatechange"&&this.onreadystatechange&&(this.onreadystatechange.handleEvent||this.onreadystatechange).apply(this,[a]);for(var b=0,c;c=this._listeners[b];b++)c[0]==a.type&&!c[2]&&(c[1].handleEvent||c[1]).apply(this,[a])};b.prototype.toString=function(){return"[object XMLHttpRequest]"};b.toString=function(){return"[XMLHttpRequest]"};if(!window.Function.prototype.apply)window.Function.prototype.apply=function(a,b){b||(b=[]);a.__func=this;a.__func(b[0],b[1],b[2],
b[3],b[4]);delete a.__func};OpenLayers.Request.XMLHttpRequest=b})();
OpenLayers.Layer.GML=OpenLayers.Class(OpenLayers.Layer.Vector,{loaded:!1,format:null,formatOptions:null,initialize:function(a,b,c){var d=[];d.push(a,c);OpenLayers.Layer.Vector.prototype.initialize.apply(this,d);this.url=b},setVisibility:function(a,b){OpenLayers.Layer.Vector.prototype.setVisibility.apply(this,arguments);this.visibility&&!this.loaded&&this.loadGML()},moveTo:function(a,b,c){OpenLayers.Layer.Vector.prototype.moveTo.apply(this,arguments);this.visibility&&!this.loaded&&this.loadGML()},
loadGML:function(){if(!this.loaded)this.events.triggerEvent("loadstart"),OpenLayers.Request.GET({url:this.url,success:this.requestSuccess,failure:this.requestFailure,scope:this}),this.loaded=!0},setUrl:function(a){this.url=a;this.destroyFeatures();this.loaded=!1;this.loadGML()},requestSuccess:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=a.responseText;a={};OpenLayers.Util.extend(a,this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject()))a.externalProjection=
this.projection,a.internalProjection=this.map.getProjectionObject();this.addFeatures((this.format?new this.format(a):new OpenLayers.Format.GML(a)).read(b));this.events.triggerEvent("loadend")},requestFailure:function(){OpenLayers.Console.userError(OpenLayers.i18n("errorLoadingGML",{url:this.url}));this.events.triggerEvent("loadend")},CLASS_NAME:"OpenLayers.Layer.GML"});
OpenLayers.Geometry.Polygon=OpenLayers.Class(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.LinearRing"],initialize:function(a){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments)},getArea:function(){var a=0;if(this.components&&this.components.length>0){a+=Math.abs(this.components[0].getArea());for(var b=1,c=this.components.length;b<c;b++)a-=Math.abs(this.components[b].getArea())}return a},getGeodesicArea:function(a){var b=0;if(this.components&&this.components.length>
0){b+=Math.abs(this.components[0].getGeodesicArea(a));for(var c=1,d=this.components.length;c<d;c++)b-=Math.abs(this.components[c].getGeodesicArea(a))}return b},containsPoint:function(a){var b=this.components.length,c=!1;if(b>0&&(c=this.components[0].containsPoint(a),c!==1&&c&&b>1))for(var d,e=1;e<b;++e)if(d=this.components[e].containsPoint(a)){c=d===1?1:!1;break}return c},intersects:function(a){var b=!1,c,d;if(a.CLASS_NAME=="OpenLayers.Geometry.Point")b=this.containsPoint(a);else if(a.CLASS_NAME==
"OpenLayers.Geometry.LineString"||a.CLASS_NAME=="OpenLayers.Geometry.LinearRing"){for(c=0,d=this.components.length;c<d;++c)if(b=a.intersects(this.components[c]))break;if(!b)for(c=0,d=a.components.length;c<d;++c)if(b=this.containsPoint(a.components[c]))break}else for(c=0,d=a.components.length;c<d;++c)if(b=this.intersects(a.components[c]))break;if(!b&&a.CLASS_NAME=="OpenLayers.Geometry.Polygon"){var e=this.components[0];for(c=0,d=e.components.length;c<d;++c)if(b=a.containsPoint(e.components[c]))break}return b},
distanceTo:function(a,b){return b&&b.edge===!1&&this.intersects(a)?0:OpenLayers.Geometry.Collection.prototype.distanceTo.apply(this,[a,b])},CLASS_NAME:"OpenLayers.Geometry.Polygon"});OpenLayers.Geometry.Polygon.createRegularPolygon=function(a,b,c,d){var e=Math.PI*(1/c-0.5);d&&(e+=d/180*Math.PI);for(var f,g=[],h=0;h<c;++h)f=e+h*2*Math.PI/c,d=a.x+b*Math.cos(f),f=a.y+b*Math.sin(f),g.push(new OpenLayers.Geometry.Point(d,f));a=new OpenLayers.Geometry.LinearRing(g);return new OpenLayers.Geometry.Polygon([a])};
OpenLayers.Control.PanPanel=OpenLayers.Class(OpenLayers.Control.Panel,{slideFactor:50,slideRatio:null,initialize:function(a){OpenLayers.Control.Panel.prototype.initialize.apply(this,[a]);a={slideFactor:this.slideFactor,slideRatio:this.slideRatio};this.addControls([new OpenLayers.Control.Pan(OpenLayers.Control.Pan.NORTH,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.SOUTH,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.EAST,a),new OpenLayers.Control.Pan(OpenLayers.Control.Pan.WEST,a)])},
CLASS_NAME:"OpenLayers.Control.PanPanel"});
OpenLayers.Control.Attribution=OpenLayers.Class(OpenLayers.Control,{separator:", ",destroy:function(){this.map.events.un({removelayer:this.updateAttribution,addlayer:this.updateAttribution,changelayer:this.updateAttribution,changebaselayer:this.updateAttribution,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.map.events.on({changebaselayer:this.updateAttribution,changelayer:this.updateAttribution,
addlayer:this.updateAttribution,removelayer:this.updateAttribution,scope:this});this.updateAttribution();return this.div},updateAttribution:function(){var a=[];if(this.map&&this.map.layers){for(var b=0,c=this.map.layers.length;b<c;b++){var d=this.map.layers[b];d.attribution&&d.getVisibility()&&OpenLayers.Util.indexOf(a,d.attribution)===-1&&a.push(d.attribution)}this.div.innerHTML=a.join(this.separator)}},CLASS_NAME:"OpenLayers.Control.Attribution"});
OpenLayers.Filter=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)},destroy:function(){},evaluate:function(){return!0},clone:function(){return null},CLASS_NAME:"OpenLayers.Filter"});
OpenLayers.Layer.GeoRSS=OpenLayers.Class(OpenLayers.Layer.Markers,{location:null,features:null,formatOptions:null,selectedFeature:null,icon:null,popupSize:null,useFeedTitle:!0,initialize:function(a,b,c){OpenLayers.Layer.Markers.prototype.initialize.apply(this,[a,c]);this.location=b;this.features=[]},destroy:function(){OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);this.clearFeatures();this.features=null},loadRSS:function(){if(!this.loaded)this.events.triggerEvent("loadstart"),OpenLayers.Request.GET({url:this.location,
success:this.parseData,scope:this}),this.loaded=!0},moveTo:function(a,b,c){OpenLayers.Layer.Markers.prototype.moveTo.apply(this,arguments);this.visibility&&!this.loaded&&this.loadRSS()},parseData:function(a){var b=a.responseXML;if(!b||!b.documentElement)b=OpenLayers.Format.XML.prototype.read(a.responseText);if(this.useFeedTitle){a=null;try{a=b.getElementsByTagNameNS("*","title")[0].firstChild.nodeValue}catch(c){a=b.getElementsByTagName("title")[0].firstChild.nodeValue}a&&this.setName(a)}a={};OpenLayers.Util.extend(a,
this.formatOptions);if(this.map&&!this.projection.equals(this.map.getProjectionObject()))a.externalProjection=this.projection,a.internalProjection=this.map.getProjectionObject();for(var b=(new OpenLayers.Format.GeoRSS(a)).read(b),a=0,d=b.length;a<d;a++){var e={},f=b[a];if(f.geometry){var g=f.attributes.title?f.attributes.title:"Untitled",h=f.attributes.description?f.attributes.description:"No description.",i=f.attributes.link?f.attributes.link:"",f=f.geometry.getBounds().getCenterLonLat();e.icon=
this.icon==null?OpenLayers.Marker.defaultIcon():this.icon.clone();e.popupSize=this.popupSize?this.popupSize.clone():new OpenLayers.Size(250,120);if(g||h){e.title=g;e.description=h;var j='<div class="olLayerGeoRSSClose">[x]</div>';j+='<div class="olLayerGeoRSSTitle">';i&&(j+='<a class="link" href="'+i+'" target="_blank">');j+=g;i&&(j+="</a>");j+="</div>";j+='<div style="" class="olLayerGeoRSSDescription">';j+=h;j+="</div>";e.popupContentHTML=j}f=new OpenLayers.Feature(this,f,e);this.features.push(f);
e=f.createMarker();e.events.register("click",f,this.markerClick);this.addMarker(e)}}this.events.triggerEvent("loadend")},markerClick:function(a){var b=this==this.layer.selectedFeature;this.layer.selectedFeature=!b?this:null;for(var c=0,d=this.layer.map.popups.length;c<d;c++)this.layer.map.removePopup(this.layer.map.popups[c]);b||(b=this.createPopup(),OpenLayers.Event.observe(b.div,"click",OpenLayers.Function.bind(function(){for(var a=0,b=this.layer.map.popups.length;a<b;a++)this.layer.map.removePopup(this.layer.map.popups[a])},
this)),this.layer.map.addPopup(b));OpenLayers.Event.stop(a)},clearFeatures:function(){if(this.features!=null)for(;this.features.length>0;){var a=this.features[0];OpenLayers.Util.removeItem(this.features,a);a.destroy()}},CLASS_NAME:"OpenLayers.Layer.GeoRSS"});
OpenLayers.Handler.Drag=OpenLayers.Class(OpenLayers.Handler,{started:!1,stopDown:!0,dragging:!1,touch:!1,last:null,start:null,lastMoveEvt:null,oldOnselectstart:null,interval:0,timeoutId:null,documentDrag:!1,documentEvents:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);if(this.documentDrag===!0){var d=this;this._docMove=function(a){d.mousemove({xy:{x:a.clientX,y:a.clientY},element:document})};this._docUp=function(a){d.mouseup({xy:{x:a.clientX,y:a.clientY}})}}},
dragstart:function(a){var b=!0;this.dragging=!1;if(this.checkModifiers(a)&&(OpenLayers.Event.isLeftClick(a)||OpenLayers.Event.isSingleTouch(a))){this.started=!0;this.last=this.start=a.xy;OpenLayers.Element.addClass(this.map.viewPortDiv,"olDragDown");this.down(a);this.callback("down",[a.xy]);OpenLayers.Event.stop(a);if(!this.oldOnselectstart)this.oldOnselectstart=document.onselectstart?document.onselectstart:OpenLayers.Function.True;document.onselectstart=OpenLayers.Function.False;b=!this.stopDown}else this.started=
!1,this.last=this.start=null;return b},dragmove:function(a){this.lastMoveEvt=a;if(this.started&&!this.timeoutId&&(a.xy.x!=this.last.x||a.xy.y!=this.last.y)){this.documentDrag===!0&&this.documentEvents&&(a.element===document?(this.adjustXY(a),this.setEvent(a)):this.removeDocumentEvents());if(this.interval>0)this.timeoutId=setTimeout(OpenLayers.Function.bind(this.removeTimeout,this),this.interval);this.dragging=!0;this.move(a);this.callback("move",[a.xy]);if(!this.oldOnselectstart)this.oldOnselectstart=
document.onselectstart,document.onselectstart=OpenLayers.Function.False;this.last=a.xy}return!0},dragend:function(a){if(this.started){this.documentDrag===!0&&this.documentEvents&&(this.adjustXY(a),this.removeDocumentEvents());var b=this.start!=this.last;this.dragging=this.started=!1;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.up(a);this.callback("up",[a.xy]);b&&this.callback("done",[a.xy]);document.onselectstart=this.oldOnselectstart}return!0},down:function(){},move:function(){},
up:function(){},out:function(){},mousedown:function(a){return this.dragstart(a)},touchstart:function(a){if(!this.touch)this.touch=!0,this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,mousemove:this.mousemove,click:this.click,scope:this});return this.dragstart(a)},mousemove:function(a){return this.dragmove(a)},touchmove:function(a){return this.dragmove(a)},removeTimeout:function(){this.timeoutId=null;this.dragging&&this.mousemove(this.lastMoveEvt)},mouseup:function(a){return this.dragend(a)},
touchend:function(a){a.xy=this.last;return this.dragend(a)},mouseout:function(a){if(this.started&&OpenLayers.Util.mouseLeft(a,this.map.eventsDiv))if(this.documentDrag===!0)this.addDocumentEvents();else{var b=this.start!=this.last;this.dragging=this.started=!1;OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");this.out(a);this.callback("out",[]);b&&this.callback("done",[a.xy]);if(document.onselectstart)document.onselectstart=this.oldOnselectstart}return!0},click:function(){return this.start==
this.last},activate:function(){var a=!1;if(OpenLayers.Handler.prototype.activate.apply(this,arguments))this.dragging=!1,a=!0;return a},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments))this.dragging=this.started=this.touch=!1,this.last=this.start=null,a=!0,OpenLayers.Element.removeClass(this.map.viewPortDiv,"olDragDown");return a},adjustXY:function(a){var b=OpenLayers.Util.pagePosition(this.map.viewPortDiv);a.xy.x-=b[0];a.xy.y-=b[1]},addDocumentEvents:function(){OpenLayers.Element.addClass(document.body,
"olDragDown");this.documentEvents=!0;OpenLayers.Event.observe(document,"mousemove",this._docMove);OpenLayers.Event.observe(document,"mouseup",this._docUp)},removeDocumentEvents:function(){OpenLayers.Element.removeClass(document.body,"olDragDown");this.documentEvents=!1;OpenLayers.Event.stopObserving(document,"mousemove",this._docMove);OpenLayers.Event.stopObserving(document,"mouseup",this._docUp)},CLASS_NAME:"OpenLayers.Handler.Drag"});
OpenLayers.Handler.Box=OpenLayers.Class(OpenLayers.Handler,{dragHandler:null,boxDivClassName:"olHandlerBoxZoomBox",boxOffsets:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.dragHandler=new OpenLayers.Handler.Drag(this,{down:this.startBox,move:this.moveBox,out:this.removeBox,up:this.endBox},{keyMask:this.keyMask})},destroy:function(){OpenLayers.Handler.prototype.destroy.apply(this,arguments);if(this.dragHandler)this.dragHandler.destroy(),this.dragHandler=
null},setMap:function(a){OpenLayers.Handler.prototype.setMap.apply(this,arguments);this.dragHandler&&this.dragHandler.setMap(a)},startBox:function(){this.callback("start",[]);this.zoomBox=OpenLayers.Util.createDiv("zoomBox",new OpenLayers.Pixel(-9999,-9999));this.zoomBox.className=this.boxDivClassName;this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;this.map.eventsDiv.appendChild(this.zoomBox);OpenLayers.Element.addClass(this.map.eventsDiv,"olDrawBox")},moveBox:function(a){var b=this.dragHandler.start.x,
c=this.dragHandler.start.y,d=Math.abs(b-a.x),e=Math.abs(c-a.y),f=this.getBoxOffsets();this.zoomBox.style.width=d+f.width+1+"px";this.zoomBox.style.height=e+f.height+1+"px";this.zoomBox.style.left=(a.x<b?b-d-f.left:b-f.left)+"px";this.zoomBox.style.top=(a.y<c?c-e-f.top:c-f.top)+"px"},endBox:function(a){var b;if(Math.abs(this.dragHandler.start.x-a.x)>5||Math.abs(this.dragHandler.start.y-a.y)>5){var c=this.dragHandler.start;b=Math.min(c.y,a.y);var d=Math.max(c.y,a.y),e=Math.min(c.x,a.x),a=Math.max(c.x,
a.x);b=new OpenLayers.Bounds(e,d,a,b)}else b=this.dragHandler.start.clone();this.removeBox();this.callback("done",[b])},removeBox:function(){this.map.eventsDiv.removeChild(this.zoomBox);this.boxOffsets=this.zoomBox=null;OpenLayers.Element.removeClass(this.map.eventsDiv,"olDrawBox")},activate:function(){return OpenLayers.Handler.prototype.activate.apply(this,arguments)?(this.dragHandler.activate(),!0):!1},deactivate:function(){return OpenLayers.Handler.prototype.deactivate.apply(this,arguments)?(this.dragHandler.deactivate()&&
this.zoomBox&&this.removeBox(),!0):!1},getBoxOffsets:function(){if(!this.boxOffsets){var a=document.createElement("div");a.style.position="absolute";a.style.border="1px solid black";a.style.width="3px";document.body.appendChild(a);var b=a.clientWidth==3;document.body.removeChild(a);var a=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-left-width")),c=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-right-width")),d=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-top-width")),
e=parseInt(OpenLayers.Element.getStyle(this.zoomBox,"border-bottom-width"));this.boxOffsets={left:a,right:c,top:d,bottom:e,width:b===!1?a+c:0,height:b===!1?d+e:0}}return this.boxOffsets},CLASS_NAME:"OpenLayers.Handler.Box"});
OpenLayers.Control.ZoomBox=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,out:!1,alwaysZoom:!1,draw:function(){this.handler=new OpenLayers.Handler.Box(this,{done:this.zoomBox},{keyMask:this.keyMask})},zoomBox:function(a){if(a instanceof OpenLayers.Bounds){var b;if(this.out){b=Math.abs(a.right-a.left);var c=Math.abs(a.top-a.bottom);b=Math.min(this.map.size.h/c,this.map.size.w/b);var c=this.map.getExtent(),d=this.map.getLonLatFromPixel(a.getCenterPixel()),a=d.lon-c.getWidth()/
2*b,e=d.lon+c.getWidth()/2*b,f=d.lat-c.getHeight()/2*b;b=d.lat+c.getHeight()/2*b;b=new OpenLayers.Bounds(a,f,e,b)}else b=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom)),c=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top)),b=new OpenLayers.Bounds(b.lon,b.lat,c.lon,c.lat);c=this.map.getZoom();this.map.zoomToExtent(b);c==this.map.getZoom()&&this.alwaysZoom==!0&&this.map.zoomTo(c+(this.out?-1:1))}else this.out?this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()-
1):this.map.setCenter(this.map.getLonLatFromPixel(a),this.map.getZoom()+1)},CLASS_NAME:"OpenLayers.Control.ZoomBox"});
OpenLayers.Control.DragPan=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,panned:!1,interval:1,documentDrag:!1,kinetic:null,enableKinetic:!1,kineticInterval:10,draw:function(){if(this.enableKinetic){var a={interval:this.kineticInterval};typeof this.enableKinetic==="object"&&(a=OpenLayers.Util.extend(a,this.enableKinetic));this.kinetic=new OpenLayers.Kinetic(a)}this.handler=new OpenLayers.Handler.Drag(this,{move:this.panMap,done:this.panMapDone,down:this.panMapStart},{interval:this.interval,
documentDrag:this.documentDrag})},panMapStart:function(){this.kinetic&&this.kinetic.begin()},panMap:function(a){this.kinetic&&this.kinetic.update(a);this.panned=!0;this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:!0,animate:!1})},panMapDone:function(a){if(this.panned){var b=null;this.kinetic&&(b=this.kinetic.end(a));this.map.pan(this.handler.last.x-a.x,this.handler.last.y-a.y,{dragging:!!b,animate:!1});if(b){var c=this;this.kinetic.move(b,function(a,b,f){c.map.pan(a,b,{dragging:!f,
animate:!1})})}this.panned=!1}},CLASS_NAME:"OpenLayers.Control.DragPan"});
OpenLayers.Handler.Click=OpenLayers.Class(OpenLayers.Handler,{delay:300,single:!0,"double":!1,pixelTolerance:0,dblclickTolerance:13,stopSingle:!1,stopDouble:!1,timerId:null,touch:!1,down:null,last:null,first:null,rightclickTimerId:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},touchstart:function(a){if(!this.touch)this.unregisterMouseListeners(),this.touch=!0;this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return!0},touchmove:function(a){this.last=
this.getEventInfo(a);return!0},touchend:function(a){if(this.down)a.xy=this.last.xy,a.lastTouches=this.last.touches,this.handleSingle(a),this.down=null;return!0},unregisterMouseListeners:function(){this.map.events.un({mousedown:this.mousedown,mouseup:this.mouseup,click:this.click,dblclick:this.dblclick,scope:this})},mousedown:function(a){this.down=this.getEventInfo(a);this.last=this.getEventInfo(a);return!0},mouseup:function(a){var b=!0;this.checkModifiers(a)&&this.control.handleRightClicks&&OpenLayers.Event.isRightClick(a)&&
(b=this.rightclick(a));return b},rightclick:function(a){if(this.passesTolerance(a))if(this.rightclickTimerId!=null)return this.clearTimer(),this.callback("dblrightclick",[a]),!this.stopDouble;else a=this["double"]?OpenLayers.Util.extend({},a):this.callback("rightclick",[a]),a=OpenLayers.Function.bind(this.delayedRightCall,this,a),this.rightclickTimerId=window.setTimeout(a,this.delay);return!this.stopSingle},delayedRightCall:function(a){this.rightclickTimerId=null;a&&this.callback("rightclick",[a])},
click:function(a){if(!this.last)this.last=this.getEventInfo(a);this.handleSingle(a);return!this.stopSingle},dblclick:function(a){this.handleDouble(a);return!this.stopDouble},handleDouble:function(a){this["double"]&&this.passesDblclickTolerance(a)&&this.callback("dblclick",[a])},handleSingle:function(a){if(this.passesTolerance(a))this.timerId!=null?(this.last.touches&&this.last.touches.length===1&&(this["double"]&&OpenLayers.Event.stop(a),this.handleDouble(a)),(!this.last.touches||this.last.touches.length!==
2)&&this.clearTimer()):(this.first=this.getEventInfo(a),this.queuePotentialClick(this.single?OpenLayers.Util.extend({},a):null))},queuePotentialClick:function(a){this.timerId=window.setTimeout(OpenLayers.Function.bind(this.delayedCall,this,a),this.delay)},passesTolerance:function(a){var b=!0;if(this.pixelTolerance!=null&&this.down&&this.down.xy&&(b=this.pixelTolerance>=this.down.xy.distanceTo(a.xy))&&this.touch&&this.down.touches.length===this.last.touches.length)for(var a=0,c=this.down.touches.length;a<
c;++a)if(this.getTouchDistance(this.down.touches[a],this.last.touches[a])>this.pixelTolerance){b=!1;break}return b},getTouchDistance:function(a,b){return Math.sqrt(Math.pow(a.clientX-b.clientX,2)+Math.pow(a.clientY-b.clientY,2))},passesDblclickTolerance:function(){var a=!0;this.down&&this.first&&(a=this.down.xy.distanceTo(this.first.xy)<=this.dblclickTolerance);return a},clearTimer:function(){if(this.timerId!=null)window.clearTimeout(this.timerId),this.timerId=null;if(this.rightclickTimerId!=null)window.clearTimeout(this.rightclickTimerId),
this.rightclickTimerId=null},delayedCall:function(a){this.timerId=null;a&&this.callback("click",[a])},getEventInfo:function(a){var b;if(a.touches){var c=a.touches.length;b=Array(c);for(var d,e=0;e<c;e++)d=a.touches[e],b[e]={clientX:d.clientX,clientY:d.clientY}}return{xy:a.xy,touches:b}},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments))this.clearTimer(),this.last=this.first=this.down=null,this.touch=!1,a=!0;return a},CLASS_NAME:"OpenLayers.Handler.Click"});
OpenLayers.Control.Navigation=OpenLayers.Class(OpenLayers.Control,{dragPan:null,dragPanOptions:null,pinchZoom:null,pinchZoomOptions:null,documentDrag:!1,zoomBox:null,zoomBoxEnabled:!0,zoomWheelEnabled:!0,mouseWheelOptions:null,handleRightClicks:!1,zoomBoxKeyMask:OpenLayers.Handler.MOD_SHIFT,autoActivate:!0,initialize:function(a){this.handlers={};OpenLayers.Control.prototype.initialize.apply(this,arguments)},destroy:function(){this.deactivate();this.dragPan&&this.dragPan.destroy();this.dragPan=null;
this.zoomBox&&this.zoomBox.destroy();this.zoomBox=null;this.pinchZoom&&this.pinchZoom.destroy();this.pinchZoom=null;OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){this.dragPan.activate();this.zoomWheelEnabled&&this.handlers.wheel.activate();this.handlers.click.activate();this.zoomBoxEnabled&&this.zoomBox.activate();this.pinchZoom&&this.pinchZoom.activate();return OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.pinchZoom&&this.pinchZoom.deactivate();
this.zoomBox.deactivate();this.dragPan.deactivate();this.handlers.click.deactivate();this.handlers.wheel.deactivate();return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},draw:function(){if(this.handleRightClicks)this.map.viewPortDiv.oncontextmenu=OpenLayers.Function.False;this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.defaultClick,dblclick:this.defaultDblClick,dblrightclick:this.defaultDblRightClick},{"double":!0,stopDouble:!0});this.dragPan=new OpenLayers.Control.DragPan(OpenLayers.Util.extend({map:this.map,
documentDrag:this.documentDrag},this.dragPanOptions));this.zoomBox=new OpenLayers.Control.ZoomBox({map:this.map,keyMask:this.zoomBoxKeyMask});this.dragPan.draw();this.zoomBox.draw();this.handlers.wheel=new OpenLayers.Handler.MouseWheel(this,{up:this.wheelUp,down:this.wheelDown},this.mouseWheelOptions);if(OpenLayers.Control.PinchZoom)this.pinchZoom=new OpenLayers.Control.PinchZoom(OpenLayers.Util.extend({map:this.map},this.pinchZoomOptions))},defaultClick:function(a){a.lastTouches&&a.lastTouches.length==
2&&this.map.zoomOut()},defaultDblClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom+1)},defaultDblRightClick:function(a){this.map.setCenter(this.map.getLonLatFromViewPortPx(a.xy),this.map.zoom-1)},wheelChange:function(a,b){var c=this.map.getZoom(),d=this.map.getZoom()+Math.round(b),d=Math.max(d,0),d=Math.min(d,this.map.getNumZoomLevels());if(d!==c){var e=this.map.getSize(),c=e.w/2-a.xy.x,e=a.xy.y-e.h/2,f=this.map.baseLayer.getResolutionForZoom(d),g=this.map.getLonLatFromPixel(a.xy);
this.map.setCenter(new OpenLayers.LonLat(g.lon+c*f,g.lat+e*f),d)}},wheelUp:function(a,b){this.wheelChange(a,b||1)},wheelDown:function(a,b){this.wheelChange(a,b||-1)},disableZoomBox:function(){this.zoomBoxEnabled=!1;this.zoomBox.deactivate()},enableZoomBox:function(){this.zoomBoxEnabled=!0;this.active&&this.zoomBox.activate()},disableZoomWheel:function(){this.zoomWheelEnabled=!1;this.handlers.wheel.deactivate()},enableZoomWheel:function(){this.zoomWheelEnabled=!0;this.active&&this.handlers.wheel.activate()},
CLASS_NAME:"OpenLayers.Control.Navigation"});
OpenLayers.Layer.HTTPRequest=OpenLayers.Class(OpenLayers.Layer,{URL_HASH_FACTOR:(Math.sqrt(5)-1)/2,url:null,params:null,reproject:!1,initialize:function(a,b,c,d){OpenLayers.Layer.prototype.initialize.apply(this,[a,d]);this.url=b;this.params=OpenLayers.Util.extend({},c)},destroy:function(){this.params=this.url=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},clone:function(a){a==null&&(a=new OpenLayers.Layer.HTTPRequest(this.name,this.url,this.params,this.getOptions()));return a=OpenLayers.Layer.prototype.clone.apply(this,
[a])},setUrl:function(a){this.url=a},mergeNewParams:function(a){this.params=OpenLayers.Util.extend(this.params,a);a=this.redraw();this.map!=null&&this.map.events.triggerEvent("changelayer",{layer:this,property:"params"});return a},redraw:function(a){return a?this.mergeNewParams({_olSalt:Math.random()}):OpenLayers.Layer.prototype.redraw.apply(this,[])},selectUrl:function(a,b){for(var c=1,d=0,e=a.length;d<e;d++)c*=a.charCodeAt(d)*this.URL_HASH_FACTOR,c-=Math.floor(c);return b[Math.floor(c*b.length)]},
getFullRequestString:function(a,b){var c=b||this.url,d=OpenLayers.Util.extend({},this.params),d=OpenLayers.Util.extend(d,a),e=OpenLayers.Util.getParameterString(d);OpenLayers.Util.isArray(c)&&(c=this.selectUrl(e,c));var e=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(c)),f;for(f in d)f.toUpperCase()in e&&delete d[f];e=OpenLayers.Util.getParameterString(d);return OpenLayers.Util.urlAppend(c,e)},CLASS_NAME:"OpenLayers.Layer.HTTPRequest"});
OpenLayers.Layer.Grid=OpenLayers.Class(OpenLayers.Layer.HTTPRequest,{tileSize:null,tileOriginCorner:"bl",tileOrigin:null,tileOptions:null,grid:null,singleTile:!1,ratio:1.5,buffer:0,numLoadingTiles:0,tileLoadingDelay:100,timerId:null,initialize:function(a,b,c,d){OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,arguments);this.events.addEventType("tileloaded");this.grid=[];this._moveGriddedTiles=OpenLayers.Function.bind(this.moveGriddedTiles,this)},removeMap:function(){if(this.timerId!=
null)window.clearTimeout(this.timerId),this.timerId=null},destroy:function(){this.clearGrid();this.tileSize=this.grid=null;OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments)},clearGrid:function(){if(this.grid){for(var a=0,b=this.grid.length;a<b;a++)for(var c=this.grid[a],d=0,e=c.length;d<e;d++){var f=c[d];this.removeTileMonitoringHooks(f);f.destroy()}this.grid=[]}},clone:function(a){a==null&&(a=new OpenLayers.Layer.Grid(this.name,this.url,this.params,this.getOptions()));a=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,
[a]);if(this.tileSize!=null)a.tileSize=this.tileSize.clone();a.grid=[];return a},moveTo:function(a,b,c){OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);a=a||this.map.getExtent();if(a!=null){var d=!this.grid.length||b,e=this.getTilesBounds();this.singleTile?(d||!c&&!e.containsBounds(a))&&this.initSingleTile(a):d||!e.containsBounds(a,!0)?this.initGriddedTiles(a):this.scheduleMoveGriddedTiles()}},moveByPx:function(){this.singleTile||this.scheduleMoveGriddedTiles()},scheduleMoveGriddedTiles:function(){this.timerId!=
null&&window.clearTimeout(this.timerId);this.timerId=window.setTimeout(this._moveGriddedTiles,this.tileLoadingDelay)},setTileSize:function(a){if(this.singleTile)a=this.map.getSize(),a.h=parseInt(a.h*this.ratio),a.w=parseInt(a.w*this.ratio);OpenLayers.Layer.HTTPRequest.prototype.setTileSize.apply(this,[a])},getGridBounds:function(){OpenLayers.Console.warn("The getGridBounds() function is deprecated. It will be removed in 3.0. Please use getTilesBounds() instead.");return this.getTilesBounds()},getTilesBounds:function(){var a=
null;if(this.grid.length)var a=this.grid[this.grid.length-1][0],b=this.grid[0][this.grid[0].length-1],a=new OpenLayers.Bounds(a.bounds.left,a.bounds.bottom,b.bounds.right,b.bounds.top);return a},initSingleTile:function(a){var b=a.getCenterLonLat(),c=a.getWidth()*this.ratio,a=a.getHeight()*this.ratio,b=new OpenLayers.Bounds(b.lon-c/2,b.lat-a/2,b.lon+c/2,b.lat+a/2),c=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(b.left,b.top));this.grid.length||(this.grid[0]=[]);(a=this.grid[0][0])?a.moveTo(b,
c):(a=this.addTile(b,c),this.addTileMonitoringHooks(a),a.draw(),this.grid[0][0]=a);this.removeExcessTiles(1,1)},calculateGridLayout:function(a,b,c){var d=c*this.tileSize.w;c*=this.tileSize.h;var e=a.left-b.lon,f=Math.floor(e/d)-this.buffer,e=-(e/d-f)*this.tileSize.w,f=b.lon+f*d,a=a.top-(b.lat+c),g=Math.ceil(a/c)+this.buffer;return{tilelon:d,tilelat:c,tileoffsetlon:f,tileoffsetlat:b.lat+g*c,tileoffsetx:e,tileoffsety:-(g-a/c)*this.tileSize.h}},getTileOrigin:function(){var a=this.tileOrigin;if(!a)var a=
this.getMaxExtent(),b={tl:["left","top"],tr:["right","top"],bl:["left","bottom"],br:["right","bottom"]}[this.tileOriginCorner],a=new OpenLayers.LonLat(a[b[0]],a[b[1]]);return a},initGriddedTiles:function(a){var b=this.map.getSize(),c=Math.ceil(b.h/this.tileSize.h)+Math.max(1,2*this.buffer),b=Math.ceil(b.w/this.tileSize.w)+Math.max(1,2*this.buffer),d=this.getTileOrigin(),e=this.map.getResolution(),f=this.calculateGridLayout(a,d,e),d=Math.round(f.tileoffsetx),e=Math.round(f.tileoffsety),g=f.tileoffsetlon,
h=f.tileoffsetlat,i=f.tilelon,f=f.tilelat;this.origin=new OpenLayers.Pixel(d,e);var j=d,k=g,o=0,n=parseInt(this.map.layerContainerDiv.style.left),l=parseInt(this.map.layerContainerDiv.style.top);do{var m=this.grid[o++];m||(m=[],this.grid.push(m));var g=k,d=j,q=0;do{var p=new OpenLayers.Bounds(g,h,g+i,h+f),r=d;r-=n;var s=e;s-=l;r=new OpenLayers.Pixel(r,s);(s=m[q++])?s.moveTo(p,r,!1):(s=this.addTile(p,r),this.addTileMonitoringHooks(s),m.push(s));g+=i;d+=this.tileSize.w}while(g<=a.right+i*this.buffer||
q<b);h-=f;e+=this.tileSize.h}while(h>=a.bottom-f*this.buffer||o<c);this.removeExcessTiles(o,q);this.spiralTileLoad()},getMaxExtent:function(){return this.maxExtent},spiralTileLoad:function(){for(var a=[],b=["right","down","left","up"],c=0,d=-1,e=OpenLayers.Util.indexOf(b,"right"),f=0;f<b.length;){var g=c,h=d;switch(b[e]){case "right":h++;break;case "down":g++;break;case "left":h--;break;case "up":g--}var i=null;g<this.grid.length&&g>=0&&h<this.grid[0].length&&h>=0&&(i=this.grid[g][h]);i!=null&&!i.queued?
(a.unshift(i),i.queued=!0,f=0,c=g,d=h):(e=(e+1)%4,f++)}b=0;for(c=a.length;b<c;b++)i=a[b],i.draw(),i.queued=!1},addTile:function(a,b){return new OpenLayers.Tile.Image(this,b,a,null,this.tileSize,this.tileOptions)},addTileMonitoringHooks:function(a){a.onLoadStart=function(){this.numLoadingTiles==0&&this.events.triggerEvent("loadstart");this.numLoadingTiles++};a.events.register("loadstart",this,a.onLoadStart);a.onLoadEnd=function(){this.numLoadingTiles--;this.events.triggerEvent("tileloaded");this.numLoadingTiles==
0&&this.events.triggerEvent("loadend")};a.events.register("loadend",this,a.onLoadEnd);a.events.register("unload",this,a.onLoadEnd)},removeTileMonitoringHooks:function(a){a.unload();a.events.un({loadstart:a.onLoadStart,loadend:a.onLoadEnd,unload:a.onLoadEnd,scope:this})},moveGriddedTiles:function(){var a=!0,b=this.buffer||1,c=this.grid[0][0].position,d=parseInt(this.map.layerContainerDiv.style.left),e=parseInt(this.map.layerContainerDiv.style.top),c=c.add(d,e);c.x>-this.tileSize.w*(b-1)?this.shiftColumn(!0):
c.x<-this.tileSize.w*b?this.shiftColumn(!1):c.y>-this.tileSize.h*(b-1)?this.shiftRow(!0):c.y<-this.tileSize.h*b?this.shiftRow(!1):a=!1;if(a)this.timerId=window.setTimeout(this._moveGriddedTiles,0)},shiftRow:function(a){var b=this.grid,c=b[a?0:this.grid.length-1],d=this.map.getResolution(),e=a?-this.tileSize.h:this.tileSize.h;d*=-e;for(var f=a?b.pop():b.shift(),g=0,h=c.length;g<h;g++){var i=c[g],j=i.bounds.clone(),i=i.position.clone();j.bottom+=d;j.top+=d;i.y+=e;f[g].moveTo(j,i)}a?b.unshift(f):b.push(f)},
shiftColumn:function(a){for(var b=a?-this.tileSize.w:this.tileSize.w,c=this.map.getResolution()*b,d=0,e=this.grid.length;d<e;d++){var f=this.grid[d],g=f[a?0:f.length-1],h=g.bounds.clone(),g=g.position.clone();h.left+=c;h.right+=c;g.x+=b;var i=a?this.grid[d].pop():this.grid[d].shift();i.moveTo(h,g);a?f.unshift(i):f.push(i)}},removeExcessTiles:function(a,b){for(;this.grid.length>a;)for(var c=this.grid.pop(),d=0,e=c.length;d<e;d++){var f=c[d];this.removeTileMonitoringHooks(f);f.destroy()}for(;this.grid[0].length>
b;){d=0;for(e=this.grid.length;d<e;d++)c=this.grid[d],f=c.pop(),this.removeTileMonitoringHooks(f),f.destroy()}},onMapResize:function(){this.singleTile&&(this.clearGrid(),this.setTileSize())},getTileBounds:function(a){var b=this.maxExtent,c=this.getResolution(),d=c*this.tileSize.w;c*=this.tileSize.h;var e=this.getLonLatFromViewPortPx(a),a=b.left+d*Math.floor((e.lon-b.left)/d),b=b.bottom+c*Math.floor((e.lat-b.bottom)/c);return new OpenLayers.Bounds(a,b,a+d,b+c)},CLASS_NAME:"OpenLayers.Layer.Grid"});
OpenLayers.Layer.WMS=OpenLayers.Class(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{service:"WMS",version:"1.1.1",request:"GetMap",styles:"",format:"image/jpeg"},reproject:!1,isBaseLayer:!0,encodeBBOX:!1,noMagic:!1,yx:{"EPSG:4326":!0},initialize:function(a,b,c,d){var e=[],c=OpenLayers.Util.upperCaseObject(c);if(parseFloat(c.VERSION)>=1.3&&!c.EXCEPTIONS)c.EXCEPTIONS="INIMAGE";e.push(a,b,c,d);OpenLayers.Layer.Grid.prototype.initialize.apply(this,e);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));
if(!this.noMagic&&this.params.TRANSPARENT&&this.params.TRANSPARENT.toString().toLowerCase()=="true"){if(d==null||!d.isBaseLayer)this.isBaseLayer=!1;if(this.params.FORMAT=="image/jpeg")this.params.FORMAT=OpenLayers.Util.alphaHack()?"image/gif":"image/png"}},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments)},clone:function(a){a==null&&(a=new OpenLayers.Layer.WMS(this.name,this.url,this.params,this.getOptions()));return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,
[a])},reverseAxisOrder:function(){return parseFloat(this.params.VERSION)>=1.3&&!!this.yx[this.map.getProjectionObject().getCode()]},getURL:function(a){var a=this.adjustBounds(a),b=this.getImageSize(),c={},d=this.reverseAxisOrder();c.BBOX=this.encodeBBOX?a.toBBOX(null,d):a.toArray(d);c.WIDTH=b.w;c.HEIGHT=b.h;return this.getFullRequestString(c)},mergeNewParams:function(a){a=[OpenLayers.Util.upperCaseObject(a)];return OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,a)},getFullRequestString:function(a,
b){var c=this.map.getProjectionObject(),c=this.projection&&this.projection.equals(c)?this.projection.getCode():c.getCode(),c=c=="none"?null:c;parseFloat(this.params.VERSION)>=1.3?this.params.CRS=c:this.params.SRS=c;if(typeof this.params.TRANSPARENT=="boolean")a.TRANSPARENT=this.params.TRANSPARENT?"TRUE":"FALSE";return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments)},CLASS_NAME:"OpenLayers.Layer.WMS"});
OpenLayers.Layer.XYZ=OpenLayers.Class(OpenLayers.Layer.Grid,{isBaseLayer:!0,sphericalMercator:!1,zoomOffset:0,serverResolutions:null,initialize:function(a,b,c){if(c&&c.sphericalMercator||this.sphericalMercator)c=OpenLayers.Util.extend({maxExtent:new OpenLayers.Bounds(-2.003750834E7,-2.003750834E7,2.003750834E7,2.003750834E7),maxResolution:156543.03390625,numZoomLevels:19,units:"m",projection:"EPSG:900913"},c);b=b||this.url;a=a||this.name;OpenLayers.Layer.Grid.prototype.initialize.apply(this,[a,b,
{},c])},clone:function(a){a==null&&(a=new OpenLayers.Layer.XYZ(this.name,this.url,this.getOptions()));return a=OpenLayers.Layer.Grid.prototype.clone.apply(this,[a])},getURL:function(a){var a=this.getXYZ(a),b=this.url;OpenLayers.Util.isArray(b)&&(b=this.selectUrl(""+a.x+a.y+a.z,b));return OpenLayers.String.format(b,a)},getXYZ:function(a){var b=this.map.getResolution(),c=Math.round((a.left-this.maxExtent.left)/(b*this.tileSize.w)),a=Math.round((this.maxExtent.top-a.top)/(b*this.tileSize.h)),b=this.serverResolutions!=
null?OpenLayers.Util.indexOf(this.serverResolutions,b):this.map.getZoom()+this.zoomOffset,d=Math.pow(2,b);this.wrapDateLine&&(c=(c%d+d)%d);return{x:c,y:a,z:b}},setMap:function(a){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);if(!this.tileOrigin)this.tileOrigin=new OpenLayers.LonLat(this.maxExtent.left,this.maxExtent.bottom)},CLASS_NAME:"OpenLayers.Layer.XYZ"});
OpenLayers.Layer.OSM=OpenLayers.Class(OpenLayers.Layer.XYZ,{name:"OpenStreetMap",attribution:"Data CC-By-SA by <a href='http://openstreetmap.org/'>OpenStreetMap</a>",sphericalMercator:!0,url:"http://tile.openstreetmap.org/${z}/${x}/${y}.png",clone:function(a){a==null&&(a=new OpenLayers.Layer.OSM(this.name,this.url,this.getOptions()));return a=OpenLayers.Layer.XYZ.prototype.clone.apply(this,[a])},wrapDateLine:!0,CLASS_NAME:"OpenLayers.Layer.OSM"});
OpenLayers.Renderer.SVG=OpenLayers.Class(OpenLayers.Renderer.Elements,{xmlns:"http://www.w3.org/2000/svg",xlinkns:"http://www.w3.org/1999/xlink",MAX_PIXEL:15E3,translationParameters:null,symbolMetrics:null,initialize:function(a){if(this.supported())OpenLayers.Renderer.Elements.prototype.initialize.apply(this,arguments),this.translationParameters={x:0,y:0},this.symbolMetrics={}},supported:function(){return document.implementation&&(document.implementation.hasFeature("org.w3c.svg","1.0")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#SVG",
"1.1")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"))},inValidRange:function(a,b,c){a+=c?0:this.translationParameters.x;b+=c?0:this.translationParameters.y;return a>=-this.MAX_PIXEL&&a<=this.MAX_PIXEL&&b>=-this.MAX_PIXEL&&b<=this.MAX_PIXEL},setExtent:function(a,b){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var c=this.getResolution(),d=-a.left/c,c=a.top/c;return b?(this.left=d,this.top=c,this.rendererRoot.setAttributeNS(null,
"viewBox","0 0 "+this.size.w+" "+this.size.h),this.translate(0,0),!0):((d=this.translate(d-this.left,c-this.top))||this.setExtent(a,!0),d)},translate:function(a,b){if(this.inValidRange(a,b,!0)){var c="";if(a||b)c="translate("+a+","+b+")";this.root.setAttributeNS(null,"transform",c);this.translationParameters={x:a,y:b};return!0}else return!1},setSize:function(a){OpenLayers.Renderer.prototype.setSize.apply(this,arguments);this.rendererRoot.setAttributeNS(null,"width",this.size.w);this.rendererRoot.setAttributeNS(null,
"height",this.size.h)},getNodeType:function(a,b){var c=null;switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":c=b.externalGraphic?"image":this.isComplexSymbol(b.graphicName)?"svg":"circle";break;case "OpenLayers.Geometry.Rectangle":c="rect";break;case "OpenLayers.Geometry.LineString":c="polyline";break;case "OpenLayers.Geometry.LinearRing":c="polygon";break;case "OpenLayers.Geometry.Polygon":case "OpenLayers.Geometry.Curve":case "OpenLayers.Geometry.Surface":c="path"}return c},setStyle:function(a,
b,c){var b=b||a._style,c=c||a._options,d=parseFloat(a.getAttributeNS(null,"r")),e=1,f;if(a._geometryClass=="OpenLayers.Geometry.Point"&&d){a.style.visibility="";if(b.graphic===!1)a.style.visibility="hidden";else if(b.externalGraphic){f=this.getPosition(a);if(b.graphicTitle)a.setAttributeNS(null,"title",b.graphicTitle),d=this.nodeFactory(null,"title"),d.textContent=b.graphicTitle,a.appendChild(d);b.graphicWidth&&b.graphicHeight&&a.setAttributeNS(null,"preserveAspectRatio","none");var d=b.graphicWidth||
b.graphicHeight,g=b.graphicHeight||b.graphicWidth,d=d?d:b.pointRadius*2,g=g?g:b.pointRadius*2,h=b.graphicYOffset!=void 0?b.graphicYOffset:-(0.5*g),i=b.graphicOpacity||b.fillOpacity;a.setAttributeNS(null,"x",(f.x+(b.graphicXOffset!=void 0?b.graphicXOffset:-(0.5*d))).toFixed());a.setAttributeNS(null,"y",(f.y+h).toFixed());a.setAttributeNS(null,"width",d);a.setAttributeNS(null,"height",g);a.setAttributeNS(this.xlinkns,"href",b.externalGraphic);a.setAttributeNS(null,"style","opacity: "+i);a.onclick=OpenLayers.Renderer.SVG.preventDefault}else if(this.isComplexSymbol(b.graphicName)){var d=
b.pointRadius*3,g=d*2,j=this.importSymbol(b.graphicName);f=this.getPosition(a);e=this.symbolMetrics[j.id][0]*3/g;h=a.parentNode;i=a.nextSibling;h&&h.removeChild(a);a.firstChild&&a.removeChild(a.firstChild);a.appendChild(j.firstChild.cloneNode(!0));a.setAttributeNS(null,"viewBox",j.getAttributeNS(null,"viewBox"));a.setAttributeNS(null,"width",g);a.setAttributeNS(null,"height",g);a.setAttributeNS(null,"x",f.x-d);a.setAttributeNS(null,"y",f.y-d);i?h.insertBefore(a,i):h&&h.appendChild(a)}else a.setAttributeNS(null,
"r",b.pointRadius);d=b.rotation;if((d!==void 0||a._rotation!==void 0)&&f)a._rotation=d,d|=0,a.nodeName!=="svg"?a.setAttributeNS(null,"transform","rotate("+d+" "+f.x+" "+f.y+")"):(f=this.symbolMetrics[j.id],a.firstChild.setAttributeNS(null,"transform","rotate("+d+" "+f[1]+" "+f[2]+")"))}c.isFilled?(a.setAttributeNS(null,"fill",b.fillColor),a.setAttributeNS(null,"fill-opacity",b.fillOpacity)):a.setAttributeNS(null,"fill","none");c.isStroked?(a.setAttributeNS(null,"stroke",b.strokeColor),a.setAttributeNS(null,
"stroke-opacity",b.strokeOpacity),a.setAttributeNS(null,"stroke-width",b.strokeWidth*e),a.setAttributeNS(null,"stroke-linecap",b.strokeLinecap||"round"),a.setAttributeNS(null,"stroke-linejoin","round"),b.strokeDashstyle&&a.setAttributeNS(null,"stroke-dasharray",this.dashStyle(b,e))):a.setAttributeNS(null,"stroke","none");b.pointerEvents&&a.setAttributeNS(null,"pointer-events",b.pointerEvents);b.cursor!=null&&a.setAttributeNS(null,"cursor",b.cursor);return a},dashStyle:function(a,b){var c=a.strokeWidth*
b,d=a.strokeDashstyle;switch(d){case "solid":return"none";case "dot":return[1,4*c].join();case "dash":return[4*c,4*c].join();case "dashdot":return[4*c,4*c,1,4*c].join();case "longdash":return[8*c,4*c].join();case "longdashdot":return[8*c,4*c,1,4*c].join();default:return OpenLayers.String.trim(d).replace(/\s+/g,",")}},createNode:function(a,b){var c=document.createElementNS(this.xmlns,a);b&&c.setAttributeNS(null,"id",b);return c},nodeTypeCompare:function(a,b){return b==a.nodeName},createRenderRoot:function(){return this.nodeFactory(this.container.id+
"_svgRoot","svg")},createRoot:function(a){return this.nodeFactory(this.container.id+a,"g")},createDefs:function(){var a=this.nodeFactory(this.container.id+"_defs","defs");this.rendererRoot.appendChild(a);return a},drawPoint:function(a,b){return this.drawCircle(a,b,1)},drawCircle:function(a,b,c){var d=this.getResolution(),e=b.x/d+this.left,b=this.top-b.y/d;return this.inValidRange(e,b)?(a.setAttributeNS(null,"cx",e),a.setAttributeNS(null,"cy",b),a.setAttributeNS(null,"r",c),a):!1},drawLineString:function(a,
b){var c=this.getComponentsString(b.components);return c.path?(a.setAttributeNS(null,"points",c.path),c.complete?a:null):!1},drawLinearRing:function(a,b){var c=this.getComponentsString(b.components);return c.path?(a.setAttributeNS(null,"points",c.path),c.complete?a:null):!1},drawPolygon:function(a,b){for(var c="",d=!0,e=!0,f,g,h=0,i=b.components.length;h<i;h++)c+=" M",f=this.getComponentsString(b.components[h].components," "),(g=f.path)?(c+=" "+g,e=f.complete&&e):d=!1;c+=" z";return d?(a.setAttributeNS(null,
"d",c),a.setAttributeNS(null,"fill-rule","evenodd"),e?a:null):!1},drawRectangle:function(a,b){var c=this.getResolution(),d=b.x/c+this.left,e=this.top-b.y/c;return this.inValidRange(d,e)?(a.setAttributeNS(null,"x",d),a.setAttributeNS(null,"y",e),a.setAttributeNS(null,"width",b.width/c),a.setAttributeNS(null,"height",b.height/c),a):!1},drawSurface:function(a,b){for(var c=null,d=!0,e=0,f=b.components.length;e<f;e++)if(e%3==0&&e/3==0){var g=this.getShortString(b.components[e]);g||(d=!1);c="M "+g}else e%
3==1?((g=this.getShortString(b.components[e]))||(d=!1),c+=" C "+g):((g=this.getShortString(b.components[e]))||(d=!1),c+=" "+g);c+=" Z";return d?(a.setAttributeNS(null,"d",c),a):!1},drawText:function(a,b,c){var d=this.getResolution(),e=c.x/d+this.left,f=c.y/d-this.top,d=this.nodeFactory(a+this.LABEL_ID_SUFFIX,"text");d.setAttributeNS(null,"x",e);d.setAttributeNS(null,"y",-f);b.fontColor&&d.setAttributeNS(null,"fill",b.fontColor);b.fontOpacity&&d.setAttributeNS(null,"opacity",b.fontOpacity);b.fontFamily&&
d.setAttributeNS(null,"font-family",b.fontFamily);b.fontSize&&d.setAttributeNS(null,"font-size",b.fontSize);b.fontWeight&&d.setAttributeNS(null,"font-weight",b.fontWeight);b.fontStyle&&d.setAttributeNS(null,"font-style",b.fontStyle);b.labelSelect===!0?(d.setAttributeNS(null,"pointer-events","visible"),d._featureId=a):d.setAttributeNS(null,"pointer-events","none");f=b.labelAlign||"cm";d.setAttributeNS(null,"text-anchor",OpenLayers.Renderer.SVG.LABEL_ALIGN[f[0]]||"middle");OpenLayers.IS_GECKO===!0&&
d.setAttributeNS(null,"dominant-baseline",OpenLayers.Renderer.SVG.LABEL_ALIGN[f[1]]||"central");for(var g=b.label.split("\n"),h=g.length;d.childNodes.length>h;)d.removeChild(d.lastChild);for(var i=0;i<h;i++){var j=this.nodeFactory(a+this.LABEL_ID_SUFFIX+"_tspan_"+i,"tspan");if(b.labelSelect===!0)j._featureId=a,j._geometry=c,j._geometryClass=c.CLASS_NAME;OpenLayers.IS_GECKO===!1&&j.setAttributeNS(null,"baseline-shift",OpenLayers.Renderer.SVG.LABEL_VSHIFT[f[1]]||"-35%");j.setAttribute("x",e);if(i==
0){var k=OpenLayers.Renderer.SVG.LABEL_VFACTOR[f[1]];k==null&&(k=-0.5);j.setAttribute("dy",k*(h-1)+"em")}else j.setAttribute("dy","1em");j.textContent=g[i]===""?" ":g[i];j.parentNode||d.appendChild(j)}d.parentNode||this.textRoot.appendChild(d)},getComponentsString:function(a,b){for(var c=[],d=!0,e=a.length,f=[],g,h=0;h<e;h++)g=a[h],c.push(g),(g=this.getShortString(g))?f.push(g):(h>0&&this.getShortString(a[h-1])&&f.push(this.clipLine(a[h],a[h-1])),h<e-1&&this.getShortString(a[h+1])&&f.push(this.clipLine(a[h],
a[h+1])),d=!1);return{path:f.join(b||","),complete:d}},clipLine:function(a,b){if(b.equals(a))return"";var c=this.getResolution(),d=this.MAX_PIXEL-this.translationParameters.x,e=this.MAX_PIXEL-this.translationParameters.y,f=b.x/c+this.left,g=this.top-b.y/c,h=a.x/c+this.left,c=this.top-a.y/c,i;if(h<-d||h>d)i=(c-g)/(h-f),h=h<0?-d:d,c=g+(h-f)*i;if(c<-e||c>e)i=(h-f)/(c-g),c=c<0?-e:e,h=f+(c-g)*i;return h+","+c},getShortString:function(a){var b=this.getResolution(),c=a.x/b+this.left,a=this.top-a.y/b;return this.inValidRange(c,
a)?c+","+a:!1},getPosition:function(a){return{x:parseFloat(a.getAttributeNS(null,"cx")),y:parseFloat(a.getAttributeNS(null,"cy"))}},importSymbol:function(a){if(!this.defs)this.defs=this.createDefs();var b=this.container.id+"-"+a,c=document.getElementById(b);if(c!=null)return c;var d=OpenLayers.Renderer.symbol[a];if(!d)throw Error(a+" is not a valid symbol name");var a=this.nodeFactory(b,"symbol"),e=this.nodeFactory(null,"polygon");a.appendChild(e);for(var c=new OpenLayers.Bounds(Number.MAX_VALUE,
Number.MAX_VALUE,0,0),f=[],g,h,i=0;i<d.length;i+=2)g=d[i],h=d[i+1],c.left=Math.min(c.left,g),c.bottom=Math.min(c.bottom,h),c.right=Math.max(c.right,g),c.top=Math.max(c.top,h),f.push(g,",",h);e.setAttributeNS(null,"points",f.join(" "));d=c.getWidth();e=c.getHeight();a.setAttributeNS(null,"viewBox",[c.left-d,c.bottom-e,d*3,e*3].join(" "));this.symbolMetrics[b]=[Math.max(d,e),c.getCenterLonLat().lon,c.getCenterLonLat().lat];this.defs.appendChild(a);return a},getFeatureIdFromEvent:function(a){var b=OpenLayers.Renderer.Elements.prototype.getFeatureIdFromEvent.apply(this,
arguments);if(!b)b=a.target,b=b.parentNode&&b!=this.rendererRoot&&b.parentNode._featureId;return b},CLASS_NAME:"OpenLayers.Renderer.SVG"});OpenLayers.Renderer.SVG.LABEL_ALIGN={l:"start",r:"end",b:"bottom",t:"hanging"};OpenLayers.Renderer.SVG.LABEL_VSHIFT={t:"-70%",b:"0"};OpenLayers.Renderer.SVG.LABEL_VFACTOR={t:0,b:-1};OpenLayers.Renderer.SVG.preventDefault=function(a){a.preventDefault&&a.preventDefault()};
OpenLayers.Icon=OpenLayers.Class({url:null,size:null,offset:null,calculateOffset:null,imageDiv:null,px:null,initialize:function(a,b,c,d){this.url=a;this.size=b?b:new OpenLayers.Size(20,20);this.offset=c?c:new OpenLayers.Pixel(-(this.size.w/2),-(this.size.h/2));this.calculateOffset=d;a=OpenLayers.Util.createUniqueID("OL_Icon_");this.imageDiv=OpenLayers.Util.createAlphaImageDiv(a)},destroy:function(){this.erase();OpenLayers.Event.stopObservingElement(this.imageDiv.firstChild);this.imageDiv.innerHTML=
"";this.imageDiv=null},clone:function(){return new OpenLayers.Icon(this.url,this.size,this.offset,this.calculateOffset)},setSize:function(a){if(a!=null)this.size=a;this.draw()},setUrl:function(a){if(a!=null)this.url=a;this.draw()},draw:function(a){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,null,this.size,this.url,"absolute");this.moveTo(a);return this.imageDiv},erase:function(){this.imageDiv!=null&&this.imageDiv.parentNode!=null&&OpenLayers.Element.remove(this.imageDiv)},setOpacity:function(a){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,
null,null,null,null,null,null,null,a)},moveTo:function(a){if(a!=null)this.px=a;if(this.imageDiv!=null)if(this.px==null)this.display(!1);else{if(this.calculateOffset)this.offset=this.calculateOffset(this.size);a=this.px.offset(this.offset);OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,a)}},display:function(a){this.imageDiv.style.display=a?"":"none"},isDrawn:function(){return this.imageDiv&&this.imageDiv.parentNode&&this.imageDiv.parentNode.nodeType!=11},CLASS_NAME:"OpenLayers.Icon"});
OpenLayers.Marker=OpenLayers.Class({icon:null,lonlat:null,events:null,map:null,initialize:function(a,b){this.lonlat=a;var c=b?b:OpenLayers.Marker.defaultIcon();this.icon==null?this.icon=c:(this.icon.url=c.url,this.icon.size=c.size,this.icon.offset=c.offset,this.icon.calculateOffset=c.calculateOffset);this.events=new OpenLayers.Events(this,this.icon.imageDiv,null)},destroy:function(){this.erase();this.map=null;this.events.destroy();this.events=null;if(this.icon!=null)this.icon.destroy(),this.icon=
null},draw:function(a){return this.icon.draw(a)},erase:function(){this.icon!=null&&this.icon.erase()},moveTo:function(a){a!=null&&this.icon!=null&&this.icon.moveTo(a);this.lonlat=this.map.getLonLatFromLayerPx(a)},isDrawn:function(){return this.icon&&this.icon.isDrawn()},onScreen:function(){var a=!1;this.map&&(a=this.map.getExtent().containsLonLat(this.lonlat));return a},inflate:function(a){this.icon&&this.icon.setSize(new OpenLayers.Size(this.icon.size.w*a,this.icon.size.h*a))},setOpacity:function(a){this.icon.setOpacity(a)},
setUrl:function(a){this.icon.setUrl(a)},display:function(a){this.icon.display(a)},CLASS_NAME:"OpenLayers.Marker"});OpenLayers.Marker.defaultIcon=function(){var a=OpenLayers.Util.getImagesLocation()+"marker.png",b=new OpenLayers.Size(21,25);return new OpenLayers.Icon(a,b,null,function(a){return new OpenLayers.Pixel(-(a.w/2),-a.h)})};
OpenLayers.Layer.EventPane=OpenLayers.Class(OpenLayers.Layer,{smoothDragPan:!0,isBaseLayer:!0,isFixed:!0,pane:null,mapObject:null,initialize:function(a,b){OpenLayers.Layer.prototype.initialize.apply(this,arguments);if(this.pane==null)this.pane=OpenLayers.Util.createDiv(this.div.id+"_EventPane")},destroy:function(){this.pane=this.mapObject=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments)},setMap:function(a){OpenLayers.Layer.prototype.setMap.apply(this,arguments);this.pane.style.zIndex=
parseInt(this.div.style.zIndex)+1;this.pane.style.display=this.div.style.display;this.pane.style.width="100%";this.pane.style.height="100%";if(OpenLayers.BROWSER_NAME=="msie")this.pane.style.background="url("+OpenLayers.Util.getImagesLocation()+"blank.gif)";this.isFixed?this.map.eventsDiv.appendChild(this.pane):this.map.layerContainerDiv.appendChild(this.pane);this.loadMapObject();this.mapObject==null&&this.loadWarningMessage()},removeMap:function(a){this.pane&&this.pane.parentNode&&this.pane.parentNode.removeChild(this.pane);
OpenLayers.Layer.prototype.removeMap.apply(this,arguments)},loadWarningMessage:function(){this.div.style.backgroundColor="darkblue";var a=this.map.getSize(),b=Math.min(a.w,300),c=Math.min(a.h,200),b=new OpenLayers.Size(b,c),a=(new OpenLayers.Pixel(a.w/2,a.h/2)).add(-b.w/2,-b.h/2),a=OpenLayers.Util.createDiv(this.name+"_warning",a,b,null,null,null,"auto");a.style.padding="7px";a.style.backgroundColor="yellow";a.innerHTML=this.getWarningHTML();this.div.appendChild(a)},getWarningHTML:function(){return""},
display:function(a){OpenLayers.Layer.prototype.display.apply(this,arguments);this.pane.style.display=this.div.style.display},setZIndex:function(a){OpenLayers.Layer.prototype.setZIndex.apply(this,arguments);this.pane.style.zIndex=parseInt(this.div.style.zIndex)+1},moveByPx:function(a,b){OpenLayers.Layer.prototype.moveByPx.apply(this,arguments);this.dragPanMapObject?this.dragPanMapObject(a,-b):this.moveTo(this.map.getCachedCenter())},moveTo:function(a,b,c){OpenLayers.Layer.prototype.moveTo.apply(this,
arguments);if(this.mapObject!=null){var d=this.map.getCenter(),e=this.map.getZoom();if(d!=null){var f=this.getOLLonLatFromMapObjectLonLat(this.getMapObjectCenter()),g=this.getOLZoomFromMapObjectZoom(this.getMapObjectZoom());if(!d.equals(f)||e!=g)!b&&f&&this.dragPanMapObject&&this.smoothDragPan?(e=this.map.getViewPortPxFromLonLat(f),d=this.map.getViewPortPxFromLonLat(d),this.dragPanMapObject(d.x-e.x,e.y-d.y)):(d=this.getMapObjectLonLatFromOLLonLat(d),e=this.getMapObjectZoomFromOLZoom(e),this.setMapObjectCenter(d,
e,c))}}},getLonLatFromViewPortPx:function(a){var b=null;this.mapObject!=null&&this.getMapObjectCenter()!=null&&(b=this.getOLLonLatFromMapObjectLonLat(this.getMapObjectLonLatFromMapObjectPixel(this.getMapObjectPixelFromOLPixel(a))));return b},getViewPortPxFromLonLat:function(a){var b=null;this.mapObject!=null&&this.getMapObjectCenter()!=null&&(b=this.getOLPixelFromMapObjectPixel(this.getMapObjectPixelFromMapObjectLonLat(this.getMapObjectLonLatFromOLLonLat(a))));return b},getOLLonLatFromMapObjectLonLat:function(a){var b=
null;a!=null&&(b=this.getLongitudeFromMapObjectLonLat(a),a=this.getLatitudeFromMapObjectLonLat(a),b=new OpenLayers.LonLat(b,a));return b},getMapObjectLonLatFromOLLonLat:function(a){var b=null;a!=null&&(b=this.getMapObjectLonLatFromLonLat(a.lon,a.lat));return b},getOLPixelFromMapObjectPixel:function(a){var b=null;a!=null&&(b=this.getXFromMapObjectPixel(a),a=this.getYFromMapObjectPixel(a),b=new OpenLayers.Pixel(b,a));return b},getMapObjectPixelFromOLPixel:function(a){var b=null;a!=null&&(b=this.getMapObjectPixelFromXY(a.x,
a.y));return b},CLASS_NAME:"OpenLayers.Layer.EventPane"});
OpenLayers.Lang.en={unhandledRequest:"Unhandled request return ${statusText}",Permalink:"Permalink",Overlays:"Overlays","Base Layer":"Base Layer",readNotImplemented:"Read not implemented.",writeNotImplemented:"Write not implemented.",noFID:"Can't update a feature for which there is no FID.",errorLoadingGML:"Error in loading GML file ${url}",browserNotSupported:"Your browser does not support vector rendering. Currently supported renderers are:\n${renderers}",componentShouldBe:"addFeatures : component should be an ${geomType}",
getFeatureError:"getFeatureFromEvent called on layer with no renderer. This usually means you destroyed a layer, but not some handler which is associated with it.",minZoomLevelError:"The minZoomLevel property is only intended for use with the FixedZoomLevels-descendent layers. That this wfs layer checks for minZoomLevel is a relic of thepast. We cannot, however, remove it without possibly breaking OL based applications that may depend on it. Therefore we are deprecating it -- the minZoomLevel check below will be removed at 3.0. Please instead use min/max resolution setting as described here: http://trac.openlayers.org/wiki/SettingZoomLevels",
commitSuccess:"WFS Transaction: SUCCESS ${response}",commitFailed:"WFS Transaction: FAILED ${response}",googleWarning:"The Google Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the Google Maps library script was either not included, or does not contain the correct API key for your site.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/Google' target='_blank'>click here</a>",
getLayerWarning:"The ${layerType} Layer was unable to load correctly.<br><br>To get rid of this message, select a new BaseLayer in the layer switcher in the upper-right corner.<br><br>Most likely, this is because the ${layerLib} library script was not correctly included.<br><br>Developers: For help getting this working correctly, <a href='http://trac.openlayers.org/wiki/${layerLib}' target='_blank'>click here</a>","Scale = 1 : ${scaleDenom}":"Scale = 1 : ${scaleDenom}",W:"W",E:"E",N:"N",S:"S",Graticule:"Graticule",
layerAlreadyAdded:"You tried to add the layer: ${layerName} to the map, but it has already been added",reprojectDeprecated:"You are using the 'reproject' option on the ${layerName} layer. This option is deprecated: its use was designed to support displaying data over commercial basemaps, but that functionality should now be achieved by using Spherical Mercator support. More information is available from http://trac.openlayers.org/wiki/SphericalMercator.",methodDeprecated:"This method has been deprecated and will be removed in 3.0. Please use ${newMethod} instead.",
boundsAddError:"You must pass both x and y values to the add function.",lonlatAddError:"You must pass both lon and lat values to the add function.",pixelAddError:"You must pass both x and y values to the add function.",unsupportedGeometryType:"Unsupported geometry type: ${geomType}",filterEvaluateNotImplemented:"evaluate is not implemented for this filter type.",proxyNeeded:"You probably need to set OpenLayers.ProxyHost to access ${url}.See http://trac.osgeo.org/openlayers/wiki/FrequentlyAskedQuestions#ProxyHost",
end:""};
OpenLayers.Layer.SphericalMercator={getExtent:function(){var a=null;return a=this.sphericalMercator?this.map.calculateBounds():OpenLayers.Layer.FixedZoomLevels.prototype.getExtent.apply(this)},getLonLatFromViewPortPx:function(a){return OpenLayers.Layer.prototype.getLonLatFromViewPortPx.apply(this,arguments)},getViewPortPxFromLonLat:function(a){return OpenLayers.Layer.prototype.getViewPortPxFromLonLat.apply(this,arguments)},initMercatorParameters:function(){this.RESOLUTIONS=[];for(var a=0;a<=this.MAX_ZOOM_LEVEL;++a)this.RESOLUTIONS[a]=
156543.03390625/Math.pow(2,a);this.units="m";this.projection=this.projection||"EPSG:900913"},forwardMercator:function(a,b){var c=a*2.003750834E7/180,d=Math.log(Math.tan((90+b)*Math.PI/360))/(Math.PI/180);return new OpenLayers.LonLat(c,d*2.003750834E7/180)},inverseMercator:function(a,b){var c=a/2.003750834E7*180,d;d=180/Math.PI*(2*Math.atan(Math.exp(b/2.003750834E7*180*Math.PI/180))-Math.PI/2);return new OpenLayers.LonLat(c,d)},projectForward:function(a){var b=OpenLayers.Layer.SphericalMercator.forwardMercator(a.x,
a.y);a.x=b.lon;a.y=b.lat;return a},projectInverse:function(a){var b=OpenLayers.Layer.SphericalMercator.inverseMercator(a.x,a.y);a.x=b.lon;a.y=b.lat;return a}};(function(){var a=["EPSG:900913","EPSG:3857","EPSG:102113","EPSG:102100"],b=OpenLayers.Projection.addTransform,c=OpenLayers.Layer.SphericalMercator,d=OpenLayers.Projection.nullTransform,e,f,g,h,i;for(e=0,f=a.length;e<f;++e){g=a[e];b("EPSG:4326",g,c.projectForward);b(g,"EPSG:4326",c.projectInverse);for(i=e+1;i<f;++i)h=a[i],b(g,h,d),b(h,g,d)}})();
OpenLayers.Symbolizer.Point=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(a){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Point"});OpenLayers.Symbolizer.Line=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(a){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Line"});
OpenLayers.Symbolizer.Polygon=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(a){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Polygon"});OpenLayers.Symbolizer.Text=OpenLayers.Class(OpenLayers.Symbolizer,{initialize:function(a){OpenLayers.Symbolizer.prototype.initialize.apply(this,arguments)},CLASS_NAME:"OpenLayers.Symbolizer.Text"});
OpenLayers.Rule=OpenLayers.Class({id:null,name:null,title:null,description:null,context:null,filter:null,elseFilter:!1,symbolizer:null,symbolizers:null,minScaleDenominator:null,maxScaleDenominator:null,initialize:function(a){this.symbolizer={};OpenLayers.Util.extend(this,a);this.symbolizers&&delete this.symbolizer;this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")},destroy:function(){for(var a in this.symbolizer)this.symbolizer[a]=null;this.symbolizer=null;delete this.symbolizers},evaluate:function(a){var b=
this.getContext(a),c=!0;if(this.minScaleDenominator||this.maxScaleDenominator)var d=a.layer.map.getScale();this.minScaleDenominator&&(c=d>=OpenLayers.Style.createLiteral(this.minScaleDenominator,b));c&&this.maxScaleDenominator&&(c=d<OpenLayers.Style.createLiteral(this.maxScaleDenominator,b));c&&this.filter&&(c=this.filter.CLASS_NAME=="OpenLayers.Filter.FeatureId"?this.filter.evaluate(a):this.filter.evaluate(b));return c},getContext:function(a){var b=this.context;b||(b=a.attributes||a.data);typeof this.context==
"function"&&(b=this.context(a));return b},clone:function(){var a=OpenLayers.Util.extend({},this);if(this.symbolizers){var b=this.symbolizers.length;a.symbolizers=Array(b);for(var c=0;c<b;++c)a.symbolizers[c]=this.symbolizers[c].clone()}else{a.symbolizer={};for(var d in this.symbolizer)b=this.symbolizer[d],c=typeof b,c==="object"?a.symbolizer[d]=OpenLayers.Util.extend({},b):c==="string"&&(a.symbolizer[d]=b)}a.filter=this.filter&&this.filter.clone();a.context=this.context&&OpenLayers.Util.extend({},
this.context);return new OpenLayers.Rule(a)},CLASS_NAME:"OpenLayers.Rule"});
OpenLayers.Layer.FixedZoomLevels=OpenLayers.Class({initialize:function(){},initResolutions:function(){for(var a=["minZoomLevel","maxZoomLevel","numZoomLevels"],b=0,c=a.length;b<c;b++){var d=a[b];this[d]=this.options[d]!=null?this.options[d]:this.map[d]}if(this.minZoomLevel==null||this.minZoomLevel<this.MIN_ZOOM_LEVEL)this.minZoomLevel=this.MIN_ZOOM_LEVEL;a=this.MAX_ZOOM_LEVEL-this.minZoomLevel+1;b=this.options.numZoomLevels==null&&this.options.maxZoomLevel!=null||this.numZoomLevels==null&&this.maxZoomLevel!=
null?this.maxZoomLevel-this.minZoomLevel+1:this.numZoomLevels;this.numZoomLevels=b!=null?Math.min(b,a):a;this.maxZoomLevel=this.minZoomLevel+this.numZoomLevels-1;if(this.RESOLUTIONS!=null){a=0;this.resolutions=[];for(b=this.minZoomLevel;b<=this.maxZoomLevel;b++)this.resolutions[a++]=this.RESOLUTIONS[b];this.maxResolution=this.resolutions[0];this.minResolution=this.resolutions[this.resolutions.length-1]}},getResolution:function(){if(this.resolutions!=null)return OpenLayers.Layer.prototype.getResolution.apply(this,
arguments);else{var a=null,b=this.map.getSize(),c=this.getExtent();b!=null&&c!=null&&(a=Math.max(c.getWidth()/b.w,c.getHeight()/b.h));return a}},getExtent:function(){var a=null,b=this.map.getSize(),c=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(0,0)),b=this.getLonLatFromViewPortPx(new OpenLayers.Pixel(b.w,b.h));c!=null&&b!=null&&(a=new OpenLayers.Bounds(c.lon,b.lat,b.lon,c.lat));return a},getZoomForResolution:function(a){return this.resolutions!=null?OpenLayers.Layer.prototype.getZoomForResolution.apply(this,
arguments):this.getZoomForExtent(OpenLayers.Layer.prototype.getExtent.apply(this,[]))},getOLZoomFromMapObjectZoom:function(a){var b=null;a!=null&&(b=a-this.minZoomLevel,this.map.baseLayer!==this&&(b=this.map.baseLayer.getZoomForResolution(this.getResolutionForZoom(b))));return b},getMapObjectZoomFromOLZoom:function(a){var b=null;a!=null&&(b=a+this.minZoomLevel,this.map.baseLayer!==this&&(b=this.getZoomForResolution(this.map.baseLayer.getResolutionForZoom(b))));return b},CLASS_NAME:"OpenLayers.Layer.FixedZoomLevels"});
OpenLayers.Handler.Hover=OpenLayers.Class(OpenLayers.Handler,{delay:500,pixelTolerance:null,stopMove:!1,px:null,timerId:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments)},mousemove:function(a){if(this.passesTolerance(a.xy))this.clearTimer(),this.callback("move",[a]),this.px=a.xy,a=OpenLayers.Util.extend({},a),this.timerId=window.setTimeout(OpenLayers.Function.bind(this.delayedCall,this,a),this.delay);return!this.stopMove},mouseout:function(a){OpenLayers.Util.mouseLeft(a,
this.map.eventsDiv)&&(this.clearTimer(),this.callback("move",[a]));return!0},passesTolerance:function(a){var b=!0;this.pixelTolerance&&this.px&&Math.sqrt(Math.pow(this.px.x-a.x,2)+Math.pow(this.px.y-a.y,2))<this.pixelTolerance&&(b=!1);return b},clearTimer:function(){if(this.timerId!=null)window.clearTimeout(this.timerId),this.timerId=null},delayedCall:function(a){this.callback("pause",[a])},deactivate:function(){var a=!1;OpenLayers.Handler.prototype.deactivate.apply(this,arguments)&&(this.clearTimer(),
a=!0);return a},CLASS_NAME:"OpenLayers.Handler.Hover"});
OpenLayers.Control.MousePosition=OpenLayers.Class(OpenLayers.Control,{autoActivate:!0,element:null,prefix:"",separator:", ",suffix:"",numDigits:5,granularity:10,emptyString:null,lastXy:null,displayProjection:null,destroy:function(){this.deactivate();OpenLayers.Control.prototype.destroy.apply(this,arguments)},activate:function(){return OpenLayers.Control.prototype.activate.apply(this,arguments)?(this.map.events.register("mousemove",this,this.redraw),this.map.events.register("mouseout",this,this.reset),
this.redraw(),!0):!1},deactivate:function(){return OpenLayers.Control.prototype.deactivate.apply(this,arguments)?(this.map.events.unregister("mousemove",this,this.redraw),this.map.events.unregister("mouseout",this,this.reset),this.element.innerHTML="",!0):!1},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element)this.div.left="",this.div.top="",this.element=this.div;return this.div},redraw:function(a){var b;if(a==null)this.reset();else if(this.lastXy==null||Math.abs(a.xy.x-
this.lastXy.x)>this.granularity||Math.abs(a.xy.y-this.lastXy.y)>this.granularity)this.lastXy=a.xy;else if(b=this.map.getLonLatFromPixel(a.xy))if(this.displayProjection&&b.transform(this.map.getProjectionObject(),this.displayProjection),this.lastXy=a.xy,a=this.formatOutput(b),a!=this.element.innerHTML)this.element.innerHTML=a},reset:function(){if(this.emptyString!=null)this.element.innerHTML=this.emptyString},formatOutput:function(a){var b=parseInt(this.numDigits);return this.prefix+a.lon.toFixed(b)+
this.separator+a.lat.toFixed(b)+this.suffix},CLASS_NAME:"OpenLayers.Control.MousePosition"});
OpenLayers.Format.XML=OpenLayers.Class(OpenLayers.Format,{namespaces:null,namespaceAlias:null,defaultPrefix:null,readers:{},writers:{},xmldom:null,initialize:function(a){if(window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");OpenLayers.Format.prototype.initialize.apply(this,[a]);this.namespaces=OpenLayers.Util.extend({},this.namespaces);this.namespaceAlias={};for(var b in this.namespaces)this.namespaceAlias[this.namespaces[b]]=b},destroy:function(){this.xmldom=null;OpenLayers.Format.prototype.destroy.apply(this,
arguments)},setNamespace:function(a,b){this.namespaces[a]=b;this.namespaceAlias[b]=a},read:function(a){var b=a.indexOf("<");b>0&&(a=a.substring(b));b=OpenLayers.Util.Try(OpenLayers.Function.bind(function(){var b;b=window.ActiveXObject&&!this.xmldom?new ActiveXObject("Microsoft.XMLDOM"):this.xmldom;b.loadXML(a);return b},this),function(){return(new DOMParser).parseFromString(a,"text/xml")},function(){var b=new XMLHttpRequest;b.open("GET","data:text/xml;charset=utf-8,"+encodeURIComponent(a),!1);b.overrideMimeType&&
b.overrideMimeType("text/xml");b.send(null);return b.responseXML});if(this.keepData)this.data=b;return b},write:function(a){if(this.xmldom)a=a.xml;else{var b=new XMLSerializer;if(a.nodeType==1){var c=document.implementation.createDocument("","",null);c.importNode&&(a=c.importNode(a,!0));c.appendChild(a);a=b.serializeToString(c)}else a=b.serializeToString(a)}return a},createElementNS:function(a,b){return this.xmldom?typeof a=="string"?this.xmldom.createNode(1,b,a):this.xmldom.createNode(1,b,""):document.createElementNS(a,
b)},createTextNode:function(a){typeof a!=="string"&&(a=String(a));return this.xmldom?this.xmldom.createTextNode(a):document.createTextNode(a)},getElementsByTagNameNS:function(a,b,c){var d=[];if(a.getElementsByTagNameNS)d=a.getElementsByTagNameNS(b,c);else for(var a=a.getElementsByTagName("*"),e,f,g=0,h=a.length;g<h;++g)if(e=a[g],f=e.prefix?e.prefix+":"+c:c,c=="*"||f==e.nodeName)(b=="*"||b==e.namespaceURI)&&d.push(e);return d},getAttributeNodeNS:function(a,b,c){var d=null;if(a.getAttributeNodeNS)d=
a.getAttributeNodeNS(b,c);else for(var a=a.attributes,e,f,g=0,h=a.length;g<h;++g)if(e=a[g],e.namespaceURI==b&&(f=e.prefix?e.prefix+":"+c:c,f==e.nodeName)){d=e;break}return d},getAttributeNS:function(a,b,c){var d="";if(a.getAttributeNS)d=a.getAttributeNS(b,c)||"";else if(a=this.getAttributeNodeNS(a,b,c))d=a.nodeValue;return d},getChildValue:function(a,b){var c=b||"";if(a)for(var d=a.firstChild;d;d=d.nextSibling)switch(d.nodeType){case 3:case 4:c+=d.nodeValue}return c},concatChildValues:function(a,
b){for(var c="",d=a.firstChild,e;d;)(e=d.nodeValue)&&(c+=e),d=d.nextSibling;c==""&&b!=void 0&&(c=b);return c},isSimpleContent:function(a){for(var b=!0,a=a.firstChild;a;a=a.nextSibling)if(a.nodeType===1){b=!1;break}return b},contentType:function(a){for(var b=!1,c=!1,d=OpenLayers.Format.XML.CONTENT_TYPE.EMPTY,a=a.firstChild;a;a=a.nextSibling){switch(a.nodeType){case 1:c=!0;break;case 8:break;default:b=!0}if(c&&b)break}if(c&&b)d=OpenLayers.Format.XML.CONTENT_TYPE.MIXED;else if(c)return OpenLayers.Format.XML.CONTENT_TYPE.COMPLEX;
else if(b)return OpenLayers.Format.XML.CONTENT_TYPE.SIMPLE;return d},hasAttributeNS:function(a,b,c){var d=!1;return d=a.hasAttributeNS?a.hasAttributeNS(b,c):!!this.getAttributeNodeNS(a,b,c)},setAttributeNS:function(a,b,c,d){if(a.setAttributeNS)a.setAttributeNS(b,c,d);else if(this.xmldom)b?(b=a.ownerDocument.createNode(2,c,b),b.nodeValue=d,a.setAttributeNode(b)):a.setAttribute(c,d);else throw"setAttributeNS not implemented";},createElementNSPlus:function(a,b){var b=b||{},c=b.uri||this.namespaces[b.prefix];
c||(c=a.indexOf(":"),c=this.namespaces[a.substring(0,c)]);c||(c=this.namespaces[this.defaultPrefix]);c=this.createElementNS(c,a);b.attributes&&this.setAttributes(c,b.attributes);var d=b.value;d!=null&&c.appendChild(this.createTextNode(d));return c},setAttributes:function(a,b){var c,d,e;for(e in b)b[e]!=null&&b[e].toString&&(c=b[e].toString(),d=this.namespaces[e.substring(0,e.indexOf(":"))]||null,this.setAttributeNS(a,d,e,c))},readNode:function(a,b){b||(b={});var c=this.readers[a.namespaceURI?this.namespaceAlias[a.namespaceURI]:
this.defaultPrefix];if(c){var d=a.localName||a.nodeName.split(":").pop();(c=c[d]||c["*"])&&c.apply(this,[a,b])}return b},readChildNodes:function(a,b){b||(b={});for(var c=a.childNodes,d,e=0,f=c.length;e<f;++e)d=c[e],d.nodeType==1&&this.readNode(d,b);return b},writeNode:function(a,b,c){var d,e=a.indexOf(":");e>0?(d=a.substring(0,e),a=a.substring(e+1)):d=c?this.namespaceAlias[c.namespaceURI]:this.defaultPrefix;b=this.writers[d][a].apply(this,[b]);c&&c.appendChild(b);return b},getChildEl:function(a,b,
c){return a&&this.getThisOrNextEl(a.firstChild,b,c)},getNextEl:function(a,b,c){return a&&this.getThisOrNextEl(a.nextSibling,b,c)},getThisOrNextEl:function(a,b,c){a:for(;a;a=a.nextSibling)switch(a.nodeType){case 1:if((!b||b===(a.localName||a.nodeName.split(":").pop()))&&(!c||c===a.namespaceURI))break a;a=null;break a;case 3:if(/^\s*$/.test(a.nodeValue))break;case 4:case 6:case 12:case 10:case 11:a=null;break a}return a||null},lookupNamespaceURI:function(a,b){var c=null;if(a)if(a.lookupNamespaceURI)c=
a.lookupNamespaceURI(b);else a:switch(a.nodeType){case 1:if(a.namespaceURI!==null&&a.prefix===b){c=a.namespaceURI;break a}if(c=a.attributes.length)for(var d,e=0;e<c;++e)if(d=a.attributes[e],d.prefix==="xmlns"&&d.name==="xmlns:"+b){c=d.value||null;break a}else if(d.name==="xmlns"&&b===null){c=d.value||null;break a}c=this.lookupNamespaceURI(a.parentNode,b);break a;case 2:c=this.lookupNamespaceURI(a.ownerElement,b);break a;case 9:c=this.lookupNamespaceURI(a.documentElement,b);break a;case 6:case 12:case 10:case 11:break a;
default:c=this.lookupNamespaceURI(a.parentNode,b)}return c},getXMLDoc:function(){if(!OpenLayers.Format.XML.document&&!this.xmldom)if(document.implementation&&document.implementation.createDocument)OpenLayers.Format.XML.document=document.implementation.createDocument("","",null);else if(!this.xmldom&&window.ActiveXObject)this.xmldom=new ActiveXObject("Microsoft.XMLDOM");return OpenLayers.Format.XML.document||this.xmldom},CLASS_NAME:"OpenLayers.Format.XML"});
OpenLayers.Format.XML.CONTENT_TYPE={EMPTY:0,SIMPLE:1,COMPLEX:2,MIXED:3};OpenLayers.Format.XML.lookupNamespaceURI=OpenLayers.Function.bind(OpenLayers.Format.XML.prototype.lookupNamespaceURI,OpenLayers.Format.XML.prototype);OpenLayers.Format.XML.document=null;
OpenLayers.Format.GeoRSS=OpenLayers.Class(OpenLayers.Format.XML,{rssns:"http://backend.userland.com/rss2",featureNS:"http://mapserver.gis.umn.edu/mapserver",georssns:"http://www.georss.org/georss",geons:"http://www.w3.org/2003/01/geo/wgs84_pos#",featureTitle:"Untitled",featureDescription:"No Description",gmlParser:null,xy:!1,createGeometryFromItem:function(a){var b=this.getElementsByTagNameNS(a,this.georssns,"point"),c=this.getElementsByTagNameNS(a,this.geons,"lat"),d=this.getElementsByTagNameNS(a,
this.geons,"long"),e=this.getElementsByTagNameNS(a,this.georssns,"line"),f=this.getElementsByTagNameNS(a,this.georssns,"polygon"),g=this.getElementsByTagNameNS(a,this.georssns,"where"),a=this.getElementsByTagNameNS(a,this.georssns,"box");if(b.length>0||c.length>0&&d.length>0){b.length>0?(c=OpenLayers.String.trim(b[0].firstChild.nodeValue).split(/\s+/),c.length!=2&&(c=OpenLayers.String.trim(b[0].firstChild.nodeValue).split(/\s*,\s*/))):c=[parseFloat(c[0].firstChild.nodeValue),parseFloat(d[0].firstChild.nodeValue)];
var h=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0]))}else if(e.length>0){c=OpenLayers.String.trim(this.concatChildValues(e[0])).split(/\s+/);d=[];e=0;for(f=c.length;e<f;e+=2)b=new OpenLayers.Geometry.Point(parseFloat(c[e+1]),parseFloat(c[e])),d.push(b);h=new OpenLayers.Geometry.LineString(d)}else if(f.length>0){c=OpenLayers.String.trim(this.concatChildValues(f[0])).split(/\s+/);d=[];e=0;for(f=c.length;e<f;e+=2)b=new OpenLayers.Geometry.Point(parseFloat(c[e+1]),parseFloat(c[e])),
d.push(b);h=new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing(d)])}else if(g.length>0){if(!this.gmlParser)this.gmlParser=new OpenLayers.Format.GML({xy:this.xy});h=this.gmlParser.parseFeature(g[0]).geometry}else a.length>0&&(c=OpenLayers.String.trim(a[0].firstChild.nodeValue).split(/\s+/),d=[],c.length>3&&(b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0])),d.push(b),b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[2])),d.push(b),b=new OpenLayers.Geometry.Point(parseFloat(c[3]),
parseFloat(c[2])),d.push(b),b=new OpenLayers.Geometry.Point(parseFloat(c[3]),parseFloat(c[0])),d.push(b),b=new OpenLayers.Geometry.Point(parseFloat(c[1]),parseFloat(c[0])),d.push(b)),h=new OpenLayers.Geometry.Polygon([new OpenLayers.Geometry.LinearRing(d)]));h&&this.internalProjection&&this.externalProjection&&h.transform(this.externalProjection,this.internalProjection);return h},createFeatureFromItem:function(a){var b=this.createGeometryFromItem(a),c=this.getChildValue(a,"*","title",this.featureTitle),
d=this.getChildValue(a,"*","description",this.getChildValue(a,"*","content",this.getChildValue(a,"*","summary",this.featureDescription))),e=this.getChildValue(a,"*","link");if(!e)try{e=this.getElementsByTagNameNS(a,"*","link")[0].getAttribute("href")}catch(f){e=null}a=this.getChildValue(a,"*","id",null);b=new OpenLayers.Feature.Vector(b,{title:c,description:d,link:e});b.fid=a;return b},getChildValue:function(a,b,c,d){return(a=this.getElementsByTagNameNS(a,b,c))&&a[0]&&a[0].firstChild&&a[0].firstChild.nodeValue?
OpenLayers.Format.XML.prototype.getChildValue(a[0]):d==void 0?"":d},read:function(a){typeof a=="string"&&(a=OpenLayers.Format.XML.prototype.read.apply(this,[a]));var b=null,b=this.getElementsByTagNameNS(a,"*","item");b.length==0&&(b=this.getElementsByTagNameNS(a,"*","entry"));for(var a=b.length,c=Array(a),d=0;d<a;d++)c[d]=this.createFeatureFromItem(b[d]);return c},write:function(a){var b;if(OpenLayers.Util.isArray(a)){b=this.createElementNS(this.rssns,"rss");for(var c=0,d=a.length;c<d;c++)b.appendChild(this.createFeatureXML(a[c]))}else b=
this.createFeatureXML(a);return OpenLayers.Format.XML.prototype.write.apply(this,[b])},createFeatureXML:function(a){var b=this.buildGeometryNode(a.geometry),c=this.createElementNS(this.rssns,"item"),d=this.createElementNS(this.rssns,"title");d.appendChild(this.createTextNode(a.attributes.title?a.attributes.title:""));var e=this.createElementNS(this.rssns,"description");e.appendChild(this.createTextNode(a.attributes.description?a.attributes.description:""));c.appendChild(d);c.appendChild(e);a.attributes.link&&
(d=this.createElementNS(this.rssns,"link"),d.appendChild(this.createTextNode(a.attributes.link)),c.appendChild(d));for(var f in a.attributes)f=="link"||f=="title"||f=="description"||(d=this.createTextNode(a.attributes[f]),e=f,f.search(":")!=-1&&(e=f.split(":")[1]),e=this.createElementNS(this.featureNS,"feature:"+e),e.appendChild(d),c.appendChild(e));c.appendChild(b);return c},buildGeometryNode:function(a){this.internalProjection&&this.externalProjection&&(a=a.clone(),a.transform(this.internalProjection,
this.externalProjection));var b;if(a.CLASS_NAME=="OpenLayers.Geometry.Polygon")b=this.createElementNS(this.georssns,"georss:polygon"),b.appendChild(this.buildCoordinatesNode(a.components[0]));else if(a.CLASS_NAME=="OpenLayers.Geometry.LineString")b=this.createElementNS(this.georssns,"georss:line"),b.appendChild(this.buildCoordinatesNode(a));else if(a.CLASS_NAME=="OpenLayers.Geometry.Point")b=this.createElementNS(this.georssns,"georss:point"),b.appendChild(this.buildCoordinatesNode(a));else throw"Couldn't parse "+
a.CLASS_NAME;return b},buildCoordinatesNode:function(a){var b=null;if(a.components)b=a.components;if(b){for(var a=b.length,c=Array(a),d=0;d<a;d++)c[d]=b[d].y+" "+b[d].x;b=c.join(" ")}else b=a.y+" "+a.x;return this.createTextNode(b)},CLASS_NAME:"OpenLayers.Format.GeoRSS"});OpenLayers.Rico=OpenLayers.Rico||{};
OpenLayers.Rico.Color=OpenLayers.Class({initialize:function(a,b,c){this.rgb={r:a,g:b,b:c}},setRed:function(a){this.rgb.r=a},setGreen:function(a){this.rgb.g=a},setBlue:function(a){this.rgb.b=a},setHue:function(a){var b=this.asHSB();b.h=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setSaturation:function(a){var b=this.asHSB();b.s=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},setBrightness:function(a){var b=this.asHSB();b.b=a;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,b.b)},
darken:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.max(b.b-a,0))},brighten:function(a){var b=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(b.h,b.s,Math.min(b.b+a,1))},blend:function(a){this.rgb.r=Math.floor((this.rgb.r+a.rgb.r)/2);this.rgb.g=Math.floor((this.rgb.g+a.rgb.g)/2);this.rgb.b=Math.floor((this.rgb.b+a.rgb.b)/2)},isBright:function(){this.asHSB();return this.asHSB().b>0.5},isDark:function(){return!this.isBright()},asRGB:function(){return"rgb("+
this.rgb.r+","+this.rgb.g+","+this.rgb.b+")"},asHex:function(){return"#"+this.rgb.r.toColorPart()+this.rgb.g.toColorPart()+this.rgb.b.toColorPart()},asHSB:function(){return OpenLayers.Rico.Color.RGBtoHSB(this.rgb.r,this.rgb.g,this.rgb.b)},toString:function(){return this.asHex()}});
OpenLayers.Rico.Color.createFromHex=function(a){if(a.length==4)for(var b=a,a="#",c=1;c<4;c++)a+=b.charAt(c)+b.charAt(c);a.indexOf("#")==0&&(a=a.substring(1));b=a.substring(0,2);c=a.substring(2,4);a=a.substring(4,6);return new OpenLayers.Rico.Color(parseInt(b,16),parseInt(c,16),parseInt(a,16))};
OpenLayers.Rico.Color.createColorFromBackground=function(a){var b=OpenLayers.Element.getStyle(OpenLayers.Util.getElement(a),"backgroundColor");if(b=="transparent"&&a.parentNode)return OpenLayers.Rico.Color.createColorFromBackground(a.parentNode);return b==null?new OpenLayers.Rico.Color(255,255,255):b.indexOf("rgb(")==0?(a=b.substring(4,b.length-1).split(","),new OpenLayers.Rico.Color(parseInt(a[0]),parseInt(a[1]),parseInt(a[2]))):b.indexOf("#")==0?OpenLayers.Rico.Color.createFromHex(b):new OpenLayers.Rico.Color(255,
255,255)};
OpenLayers.Rico.Color.HSBtoRGB=function(a,b,c){var d=0,e=0,f=0;if(b==0)f=e=d=parseInt(c*255+0.5);else{var a=(a-Math.floor(a))*6,g=a-Math.floor(a),h=c*(1-b),i=c*(1-b*g),b=c*(1-b*(1-g));switch(parseInt(a)){case 0:d=c*255+0.5;e=b*255+0.5;f=h*255+0.5;break;case 1:d=i*255+0.5;e=c*255+0.5;f=h*255+0.5;break;case 2:d=h*255+0.5;e=c*255+0.5;f=b*255+0.5;break;case 3:d=h*255+0.5;e=i*255+0.5;f=c*255+0.5;break;case 4:d=b*255+0.5;e=h*255+0.5;f=c*255+0.5;break;case 5:d=c*255+0.5,e=h*255+0.5,f=i*255+0.5}}return{r:parseInt(d),g:parseInt(e),
b:parseInt(f)}};OpenLayers.Rico.Color.RGBtoHSB=function(a,b,c){var d,e=a>b?a:b;c>e&&(e=c);var f=a<b?a:b;c<f&&(f=c);d=e!=0?(e-f)/e:0;if(d==0)a=0;else{var g=(e-a)/(e-f),h=(e-b)/(e-f),c=(e-c)/(e-f),a=a==e?c-h:b==e?2+g-c:4+h-g;a/=6;a<0&&(a+=1)}return{h:a,s:d,b:e/255}};
OpenLayers.Handler.Keyboard=OpenLayers.Class(OpenLayers.Handler,{KEY_EVENTS:["keydown","keyup"],eventListener:null,initialize:function(a,b,c){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.eventListener=OpenLayers.Function.bindAsEventListener(this.handleKeyEvent,this)},destroy:function(){this.deactivate();this.eventListener=null;OpenLayers.Handler.prototype.destroy.apply(this,arguments)},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){for(var a=
0,b=this.KEY_EVENTS.length;a<b;a++)OpenLayers.Event.observe(document,this.KEY_EVENTS[a],this.eventListener);return!0}else return!1},deactivate:function(){var a=!1;if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){for(var a=0,b=this.KEY_EVENTS.length;a<b;a++)OpenLayers.Event.stopObserving(document,this.KEY_EVENTS[a],this.eventListener);a=!0}return a},handleKeyEvent:function(a){this.checkModifiers(a)&&this.callback(a.type,[a])},CLASS_NAME:"OpenLayers.Handler.Keyboard"});
OpenLayers.Renderer.VML=OpenLayers.Class(OpenLayers.Renderer.Elements,{xmlns:"urn:schemas-microsoft-com:vml",symbolCache:{},offset:null,initialize:function(a){if(this.supported()){if(!document.namespaces.olv){document.namespaces.add("olv",this.xmlns);for(var b=document.createStyleSheet(),c="shape,rect,oval,fill,stroke,imagedata,group,textbox".split(","),d=0,e=c.length;d<e;d++)b.addRule("olv\\:"+c[d],"behavior: url(#default#VML); position: absolute; display: inline-block;")}OpenLayers.Renderer.Elements.prototype.initialize.apply(this,
arguments)}},supported:function(){return!!document.namespaces},setExtent:function(a,b){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var c=this.getResolution(),d=a.left/c|0,c=a.top/c-this.size.h|0;b||!this.offset?(this.offset={x:d,y:c},c=d=0):(d-=this.offset.x,c-=this.offset.y);this.root.coordorigin=d+" "+c;for(var d=[this.root,this.vectorRoot,this.textRoot],e=0,f=d.length;e<f;++e)c=d[e],c.coordsize=this.size.w+" "+this.size.h;this.root.style.flip="y";return!0},setSize:function(a){OpenLayers.Renderer.prototype.setSize.apply(this,
arguments);for(var b=[this.rendererRoot,this.root,this.vectorRoot,this.textRoot],c=this.size.w+"px",d=this.size.h+"px",e,f=0,g=b.length;f<g;++f)e=b[f],e.style.width=c,e.style.height=d},getNodeType:function(a,b){var c=null;switch(a.CLASS_NAME){case "OpenLayers.Geometry.Point":c=b.externalGraphic?"olv:rect":this.isComplexSymbol(b.graphicName)?"olv:shape":"olv:oval";break;case "OpenLayers.Geometry.Rectangle":c="olv:rect";break;case "OpenLayers.Geometry.LineString":case "OpenLayers.Geometry.LinearRing":case "OpenLayers.Geometry.Polygon":case "OpenLayers.Geometry.Curve":case "OpenLayers.Geometry.Surface":c=
"olv:shape"}return c},setStyle:function(a,b,c,d){var b=b||a._style,c=c||a._options,e=b.fillColor;if(a._geometryClass==="OpenLayers.Geometry.Point")if(b.externalGraphic){c.isFilled=!0;if(b.graphicTitle)a.title=b.graphicTitle;var e=b.graphicWidth||b.graphicHeight,f=b.graphicHeight||b.graphicWidth,e=e?e:b.pointRadius*2,f=f?f:b.pointRadius*2,g=this.getResolution(),h=b.graphicXOffset!=void 0?b.graphicXOffset:-(0.5*e),i=b.graphicYOffset!=void 0?b.graphicYOffset:-(0.5*f);a.style.left=(d.x/g-this.offset.x+
h|0)+"px";a.style.top=(d.y/g-this.offset.y-(i+f)|0)+"px";a.style.width=e+"px";a.style.height=f+"px";a.style.flip="y";e="none";c.isStroked=!1}else this.isComplexSymbol(b.graphicName)?(f=this.importSymbol(b.graphicName),a.path=f.path,a.coordorigin=f.left+","+f.bottom,f=f.size,a.coordsize=f+","+f,this.drawCircle(a,d,b.pointRadius),a.style.flip="y"):this.drawCircle(a,d,b.pointRadius);c.isFilled?a.fillcolor=e:a.filled="false";d=a.getElementsByTagName("fill");d=d.length==0?null:d[0];if(c.isFilled){d||(d=
this.createNode("olv:fill",a.id+"_fill"));d.opacity=b.fillOpacity;if(a._geometryClass==="OpenLayers.Geometry.Point"&&b.externalGraphic){if(b.graphicOpacity)d.opacity=b.graphicOpacity;d.src=b.externalGraphic;d.type="frame";if(!b.graphicWidth||!b.graphicHeight)d.aspect="atmost"}d.parentNode!=a&&a.appendChild(d)}else d&&a.removeChild(d);e=b.rotation;if(e!==void 0||a._rotation!==void 0)if(a._rotation=e,b.externalGraphic)this.graphicRotate(a,h,i,b),d.opacity=0;else if(a._geometryClass==="OpenLayers.Geometry.Point")a.style.rotation=
e||0;h=a.getElementsByTagName("stroke");h=h.length==0?null:h[0];if(c.isStroked){if(h||(h=this.createNode("olv:stroke",a.id+"_stroke"),a.appendChild(h)),h.on=!0,h.color=b.strokeColor,h.weight=b.strokeWidth+"px",h.opacity=b.strokeOpacity,h.endcap=b.strokeLinecap=="butt"?"flat":b.strokeLinecap||"round",b.strokeDashstyle)h.dashstyle=this.dashStyle(b)}else if(a.stroked=!1,h)h.on=!1;if(b.cursor!="inherit"&&b.cursor!=null)a.style.cursor=b.cursor;return a},graphicRotate:function(a,b,c,d){var d=d||a._style,
e=d.rotation||0,f,g;if(!d.graphicWidth||!d.graphicHeight){var h=new Image;h.onreadystatechange=OpenLayers.Function.bind(function(){if(h.readyState=="complete"||h.readyState=="interactive")f=h.width/h.height,g=Math.max(d.pointRadius*2,d.graphicWidth||0,d.graphicHeight||0),b*=f,d.graphicWidth=g*f,d.graphicHeight=g,this.graphicRotate(a,b,c,d)},this);h.src=d.externalGraphic}else{g=Math.max(d.graphicWidth,d.graphicHeight);f=d.graphicWidth/d.graphicHeight;var i=Math.round(d.graphicWidth||g*f),j=Math.round(d.graphicHeight||
g);a.style.width=i+"px";a.style.height=j+"px";var k=document.getElementById(a.id+"_image");k||(k=this.createNode("olv:imagedata",a.id+"_image"),a.appendChild(k));k.style.width=i+"px";k.style.height=j+"px";k.src=d.externalGraphic;k.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='', sizingMethod='scale')";k=e*Math.PI/180;e=Math.sin(k);k=Math.cos(k);e="progid:DXImageTransform.Microsoft.Matrix(M11="+k+",M12="+-e+",M21="+e+",M22="+k+",SizingMethod='auto expand')\n";(k=d.graphicOpacity||
d.fillOpacity)&&k!=1&&(e+="progid:DXImageTransform.Microsoft.BasicImage(opacity="+k+")\n");a.style.filter=e;e=new OpenLayers.Geometry.Point(-b,-c);i=(new OpenLayers.Bounds(0,0,i,j)).toGeometry();i.rotate(d.rotation,e);i=i.getBounds();a.style.left=Math.round(parseInt(a.style.left)+i.left)+"px";a.style.top=Math.round(parseInt(a.style.top)-i.bottom)+"px"}},postDraw:function(a){a.style.visibility="visible";var b=a._style.fillColor,c=a._style.strokeColor;if(b=="none"&&a.fillcolor!=b)a.fillcolor=b;if(c==
"none"&&a.strokecolor!=c)a.strokecolor=c},setNodeDimension:function(a,b){var c=b.getBounds();if(c){var d=this.getResolution(),c=new OpenLayers.Bounds(c.left/d-this.offset.x|0,c.bottom/d-this.offset.y|0,c.right/d-this.offset.x|0,c.top/d-this.offset.y|0);a.style.left=c.left+"px";a.style.top=c.top+"px";a.style.width=c.getWidth()+"px";a.style.height=c.getHeight()+"px";a.coordorigin=c.left+" "+c.top;a.coordsize=c.getWidth()+" "+c.getHeight()}},dashStyle:function(a){a=a.strokeDashstyle;switch(a){case "solid":case "dot":case "dash":case "dashdot":case "longdash":case "longdashdot":return a;
default:a=a.split(/[ ,]/);if(a.length==2)return 1*a[0]>=2*a[1]?"longdash":a[0]==1||a[1]==1?"dot":"dash";else if(a.length==4)return 1*a[0]>=2*a[1]?"longdashdot":"dashdot";return"solid"}},createNode:function(a,b){var c=document.createElement(a);if(b)c.id=b;c.unselectable="on";c.onselectstart=OpenLayers.Function.False;return c},nodeTypeCompare:function(a,b){var c=b,d=c.indexOf(":");d!=-1&&(c=c.substr(d+1));var e=a.nodeName,d=e.indexOf(":");d!=-1&&(e=e.substr(d+1));return c==e},createRenderRoot:function(){return this.nodeFactory(this.container.id+
"_vmlRoot","div")},createRoot:function(a){return this.nodeFactory(this.container.id+a,"olv:group")},drawPoint:function(a,b){return this.drawCircle(a,b,1)},drawCircle:function(a,b,c){if(!isNaN(b.x)&&!isNaN(b.y)){var d=this.getResolution();a.style.left=(b.x/d-this.offset.x|0)-c+"px";a.style.top=(b.y/d-this.offset.y|0)-c+"px";b=c*2;a.style.width=b+"px";a.style.height=b+"px";return a}return!1},drawLineString:function(a,b){return this.drawLine(a,b,!1)},drawLinearRing:function(a,b){return this.drawLine(a,
b,!0)},drawLine:function(a,b,c){this.setNodeDimension(a,b);for(var d=this.getResolution(),e=b.components.length,f=Array(e),g,h,i=0;i<e;i++)g=b.components[i],h=g.x/d-this.offset.x|0,g=g.y/d-this.offset.y|0,f[i]=" "+h+","+g+" l ";a.path="m"+f.join("")+(c?" x e":" e");return a},drawPolygon:function(a,b){this.setNodeDimension(a,b);var c=this.getResolution(),d=[],e,f,g,h,i,j,k,o,n,l;for(e=0,f=b.components.length;e<f;e++){d.push("m");g=b.components[e].components;h=e===0;j=i=null;for(k=0,o=g.length;k<o;k++)n=
g[k],l=n.x/c-this.offset.x|0,n=n.y/c-this.offset.y|0,l=" "+l+","+n,d.push(l),k==0&&d.push(" l"),h||(i?i!=l&&(j?j!=l&&(h=!0):j=l):i=l);d.push(h?" x ":" ")}d.push("e");a.path=d.join("");return a},drawRectangle:function(a,b){var c=this.getResolution();a.style.left=(b.x/c-this.offset.x|0)+"px";a.style.top=(b.y/c-this.offset.y|0)+"px";a.style.width=(b.width/c|0)+"px";a.style.height=(b.height/c|0)+"px";return a},drawText:function(a,b,c){var d=this.nodeFactory(a+this.LABEL_ID_SUFFIX,"olv:rect"),e=this.nodeFactory(a+
this.LABEL_ID_SUFFIX+"_textbox","olv:textbox"),f=this.getResolution();d.style.left=(c.x/f-this.offset.x|0)+"px";d.style.top=(c.y/f-this.offset.y|0)+"px";d.style.flip="y";e.innerText=b.label;if(b.cursor!="inherit"&&b.cursor!=null)e.style.cursor=b.cursor;if(b.fontColor)e.style.color=b.fontColor;if(b.fontOpacity)e.style.filter="alpha(opacity="+b.fontOpacity*100+")";if(b.fontFamily)e.style.fontFamily=b.fontFamily;if(b.fontSize)e.style.fontSize=b.fontSize;if(b.fontWeight)e.style.fontWeight=b.fontWeight;
if(b.fontStyle)e.style.fontStyle=b.fontStyle;if(b.labelSelect===!0)d._featureId=a,e._featureId=a,e._geometry=c,e._geometryClass=c.CLASS_NAME;e.style.whiteSpace="nowrap";e.inset="1px,0px,0px,0px";d.parentNode||(d.appendChild(e),this.textRoot.appendChild(d));b=b.labelAlign||"cm";b.length==1&&(b+="m");a=e.clientWidth*OpenLayers.Renderer.VML.LABEL_SHIFT[b.substr(0,1)];e=e.clientHeight*OpenLayers.Renderer.VML.LABEL_SHIFT[b.substr(1,1)];d.style.left=parseInt(d.style.left)-a-1+"px";d.style.top=parseInt(d.style.top)+
e+"px"},drawSurface:function(a,b){this.setNodeDimension(a,b);for(var c=this.getResolution(),d=[],e,f,g=0,h=b.components.length;g<h;g++)e=b.components[g],f=e.x/c-this.offset.x|0,e=e.y/c-this.offset.y|0,g%3==0&&g/3==0?d.push("m"):g%3==1&&d.push(" c"),d.push(" "+f+","+e);d.push(" x e");a.path=d.join("");return a},moveRoot:function(a){var b=this.map.getLayer(a.container.id);b instanceof OpenLayers.Layer.Vector.RootContainer&&(b=this.map.getLayer(this.container.id));b&&b.renderer.clear();OpenLayers.Renderer.Elements.prototype.moveRoot.apply(this,
arguments);b&&b.redraw()},importSymbol:function(a){var b=this.container.id+"-"+a,c=this.symbolCache[b];if(c)return c;c=OpenLayers.Renderer.symbol[a];if(!c)throw Error(a+" is not a valid symbol name");for(var a=new OpenLayers.Bounds(Number.MAX_VALUE,Number.MAX_VALUE,0,0),d=["m"],e=0;e<c.length;e+=2){var f=c[e],g=c[e+1];a.left=Math.min(a.left,f);a.bottom=Math.min(a.bottom,g);a.right=Math.max(a.right,f);a.top=Math.max(a.top,g);d.push(f);d.push(g);e==0&&d.push("l")}d.push("x e");c=d.join(" ");d=(a.getWidth()-
a.getHeight())/2;d>0?(a.bottom-=d,a.top+=d):(a.left+=d,a.right-=d);c={path:c,size:a.getWidth(),left:a.left,bottom:a.bottom};return this.symbolCache[b]=c},CLASS_NAME:"OpenLayers.Renderer.VML"});OpenLayers.Renderer.VML.LABEL_SHIFT={l:0,c:0.5,r:1,t:0,m:0.5,b:1};
OpenLayers.Control.DragFeature=OpenLayers.Class(OpenLayers.Control,{geometryTypes:null,onStart:function(){},onDrag:function(){},onComplete:function(){},onEnter:function(){},onLeave:function(){},documentDrag:!1,layer:null,feature:null,dragCallbacks:{},featureCallbacks:{},lastPixel:null,initialize:function(a,b){OpenLayers.Control.prototype.initialize.apply(this,[b]);this.layer=a;this.handlers={drag:new OpenLayers.Handler.Drag(this,OpenLayers.Util.extend({down:this.downFeature,move:this.moveFeature,
up:this.upFeature,out:this.cancel,done:this.doneDragging},this.dragCallbacks),{documentDrag:this.documentDrag}),feature:new OpenLayers.Handler.Feature(this,this.layer,OpenLayers.Util.extend({click:this.clickFeature,clickout:this.clickoutFeature,over:this.overFeature,out:this.outFeature},this.featureCallbacks),{geometryTypes:this.geometryTypes})}},clickFeature:function(a){if(this.handlers.feature.touch&&!this.over&&this.overFeature(a))this.handlers.drag.dragstart(this.handlers.feature.evt),this.handlers.drag.stopDown=
!1},clickoutFeature:function(a){if(this.handlers.feature.touch&&this.over)this.outFeature(a),this.handlers.drag.stopDown=!0},destroy:function(){this.layer=null;OpenLayers.Control.prototype.destroy.apply(this,[])},activate:function(){return this.handlers.feature.activate()&&OpenLayers.Control.prototype.activate.apply(this,arguments)},deactivate:function(){this.handlers.drag.deactivate();this.handlers.feature.deactivate();this.feature=null;this.dragging=!1;this.lastPixel=null;OpenLayers.Element.removeClass(this.map.viewPortDiv,
this.displayClass+"Over");return OpenLayers.Control.prototype.deactivate.apply(this,arguments)},overFeature:function(a){var b=!1;this.handlers.drag.dragging?this.over=this.feature.id==a.id?!0:!1:(this.feature=a,this.handlers.drag.activate(),this.over=b=!0,OpenLayers.Element.addClass(this.map.viewPortDiv,this.displayClass+"Over"),this.onEnter(a));return b},downFeature:function(a){this.lastPixel=a;this.onStart(this.feature,a)},moveFeature:function(a){var b=this.map.getResolution();this.feature.geometry.move(b*
(a.x-this.lastPixel.x),b*(this.lastPixel.y-a.y));this.layer.drawFeature(this.feature);this.lastPixel=a;this.onDrag(this.feature,a)},upFeature:function(){this.over||this.handlers.drag.deactivate()},doneDragging:function(a){this.onComplete(this.feature,a)},outFeature:function(a){if(this.handlers.drag.dragging){if(this.feature.id==a.id)this.over=!1}else this.over=!1,this.handlers.drag.deactivate(),OpenLayers.Element.removeClass(this.map.viewPortDiv,this.displayClass+"Over"),this.onLeave(a),this.feature=
null},cancel:function(){this.handlers.drag.deactivate();this.over=!1},setMap:function(a){this.handlers.drag.setMap(a);this.handlers.feature.setMap(a);OpenLayers.Control.prototype.setMap.apply(this,arguments)},CLASS_NAME:"OpenLayers.Control.DragFeature"});
OpenLayers.Filter.Comparison=OpenLayers.Class(OpenLayers.Filter,{type:null,property:null,value:null,matchCase:!0,lowerBoundary:null,upperBoundary:null,initialize:function(a){OpenLayers.Filter.prototype.initialize.apply(this,[a]);if(this.type===OpenLayers.Filter.Comparison.LIKE&&a.matchCase===void 0)this.matchCase=null},evaluate:function(a){if(a instanceof OpenLayers.Feature.Vector)a=a.attributes;var b=!1,a=a[this.property];switch(this.type){case OpenLayers.Filter.Comparison.EQUAL_TO:b=this.value;
b=!this.matchCase&&typeof a=="string"&&typeof b=="string"?a.toUpperCase()==b.toUpperCase():a==b;break;case OpenLayers.Filter.Comparison.NOT_EQUAL_TO:b=this.value;b=!this.matchCase&&typeof a=="string"&&typeof b=="string"?a.toUpperCase()!=b.toUpperCase():a!=b;break;case OpenLayers.Filter.Comparison.LESS_THAN:b=a<this.value;break;case OpenLayers.Filter.Comparison.GREATER_THAN:b=a>this.value;break;case OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO:b=a<=this.value;break;case OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO:b=
a>=this.value;break;case OpenLayers.Filter.Comparison.BETWEEN:b=a>=this.lowerBoundary&&a<=this.upperBoundary;break;case OpenLayers.Filter.Comparison.LIKE:b=RegExp(this.value,"gi").test(a)}return b},value2regex:function(a,b,c){if(a==".")return OpenLayers.Console.error("'.' is an unsupported wildCard character for OpenLayers.Filter.Comparison"),null;a=a?a:"*";b=b?b:".";this.value=this.value.replace(RegExp("\\"+(c?c:"!")+"(.|$)","g"),"\\$1");this.value=this.value.replace(RegExp("\\"+b,"g"),".");this.value=
this.value.replace(RegExp("\\"+a,"g"),".*");this.value=this.value.replace(RegExp("\\\\.\\*","g"),"\\"+a);return this.value=this.value.replace(RegExp("\\\\\\.","g"),"\\"+b)},regex2value:function(){var a=this.value,a=a.replace(/!/g,"!!"),a=a.replace(/(\\)?\\\./g,function(a,c){return c?a:"!."}),a=a.replace(/(\\)?\\\*/g,function(a,c){return c?a:"!*"}),a=a.replace(/\\\\/g,"\\");return a=a.replace(/\.\*/g,"*")},clone:function(){return OpenLayers.Util.extend(new OpenLayers.Filter.Comparison,this)},CLASS_NAME:"OpenLayers.Filter.Comparison"});
OpenLayers.Filter.Comparison.EQUAL_TO="==";OpenLayers.Filter.Comparison.NOT_EQUAL_TO="!=";OpenLayers.Filter.Comparison.LESS_THAN="<";OpenLayers.Filter.Comparison.GREATER_THAN=">";OpenLayers.Filter.Comparison.LESS_THAN_OR_EQUAL_TO="<=";OpenLayers.Filter.Comparison.GREATER_THAN_OR_EQUAL_TO=">=";OpenLayers.Filter.Comparison.BETWEEN="..";OpenLayers.Filter.Comparison.LIKE="~";
OpenLayers.Control.LayerSwitcher=OpenLayers.Class(OpenLayers.Control,{roundedCorner:!0,roundedCornerColor:"darkblue",layerStates:null,layersDiv:null,baseLayersDiv:null,baseLayers:null,dataLbl:null,dataLayersDiv:null,dataLayers:null,minimizeDiv:null,maximizeDiv:null,ascending:!0,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.layerStates=[]},destroy:function(){OpenLayers.Event.stopObservingElement(this.div);OpenLayers.Event.stopObservingElement(this.minimizeDiv);
OpenLayers.Event.stopObservingElement(this.maximizeDiv);this.clearLayersArray("base");this.clearLayersArray("data");this.map.events.un({addlayer:this.redraw,changelayer:this.redraw,removelayer:this.redraw,changebaselayer:this.redraw,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments)},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);this.map.events.on({addlayer:this.redraw,changelayer:this.redraw,removelayer:this.redraw,changebaselayer:this.redraw,scope:this})},
draw:function(){OpenLayers.Control.prototype.draw.apply(this);this.loadContents();this.outsideViewport||this.minimizeControl();this.redraw();return this.div},clearLayersArray:function(a){var b=this[a+"Layers"];if(b)for(var c=0,d=b.length;c<d;c++){var e=b[c];OpenLayers.Event.stopObservingElement(e.inputElem);OpenLayers.Event.stopObservingElement(e.labelSpan)}this[a+"LayersDiv"].innerHTML="";this[a+"Layers"]=[]},checkRedraw:function(){var a=!1;if(!this.layerStates.length||this.map.layers.length!=this.layerStates.length)a=
!0;else for(var b=0,c=this.layerStates.length;b<c;b++){var d=this.layerStates[b],e=this.map.layers[b];if(d.name!=e.name||d.inRange!=e.inRange||d.id!=e.id||d.visibility!=e.visibility){a=!0;break}}return a},redraw:function(){if(!this.checkRedraw())return this.div;this.clearLayersArray("base");this.clearLayersArray("data");var a=!1,b=!1,c=this.map.layers.length;this.layerStates=Array(c);for(var d=0;d<c;d++){var e=this.map.layers[d];this.layerStates[d]={name:e.name,visibility:e.visibility,inRange:e.inRange,
id:e.id}}var f=this.map.layers.slice();this.ascending||f.reverse();d=0;for(c=f.length;d<c;d++){var e=f[d],g=e.isBaseLayer;if(e.displayInLayerSwitcher){g?b=!0:a=!0;var h=g?e==this.map.baseLayer:e.getVisibility(),i=document.createElement("input");i.id=this.id+"_input_"+e.name;i.name=g?this.id+"_baseLayers":e.name;i.type=g?"radio":"checkbox";i.value=e.name;i.checked=h;i.defaultChecked=h;if(!g&&!e.inRange)i.disabled=!0;var j={inputElem:i,layer:e,layerSwitcher:this};OpenLayers.Event.observe(i,"mouseup",
OpenLayers.Function.bindAsEventListener(this.onInputClick,j));h=document.createElement("span");OpenLayers.Element.addClass(h,"labelSpan");if(!g&&!e.inRange)h.style.color="gray";h.innerHTML=e.name;h.style.verticalAlign=g?"bottom":"baseline";OpenLayers.Event.observe(h,"click",OpenLayers.Function.bindAsEventListener(this.onInputClick,j));j=document.createElement("br");(g?this.baseLayers:this.dataLayers).push({layer:e,inputElem:i,labelSpan:h});e=g?this.baseLayersDiv:this.dataLayersDiv;e.appendChild(i);
e.appendChild(h);e.appendChild(j)}}this.dataLbl.style.display=a?"":"none";this.baseLbl.style.display=b?"":"none";return this.div},onInputClick:function(a){if(!this.inputElem.disabled)this.inputElem.type=="radio"?(this.inputElem.checked=!0,this.layer.map.setBaseLayer(this.layer)):(this.inputElem.checked=!this.inputElem.checked,this.layerSwitcher.updateMap());OpenLayers.Event.stop(a)},onLayerClick:function(){this.updateMap()},updateMap:function(){for(var a=0,b=this.baseLayers.length;a<b;a++){var c=
this.baseLayers[a];c.inputElem.checked&&this.map.setBaseLayer(c.layer,!1)}a=0;for(b=this.dataLayers.length;a<b;a++)c=this.dataLayers[a],c.layer.setVisibility(c.inputElem.checked)},maximizeControl:function(a){this.div.style.width="";this.div.style.height="";this.showControls(!1);a!=null&&OpenLayers.Event.stop(a)},minimizeControl:function(a){this.div.style.width="0px";this.div.style.height="0px";this.showControls(!0);a!=null&&OpenLayers.Event.stop(a)},showControls:function(a){this.maximizeDiv.style.display=
a?"":"none";this.minimizeDiv.style.display=a?"none":"";this.layersDiv.style.display=a?"none":""},loadContents:function(){OpenLayers.Event.observe(this.div,"mouseup",OpenLayers.Function.bindAsEventListener(this.mouseUp,this));OpenLayers.Event.observe(this.div,"click",this.ignoreEvent);OpenLayers.Event.observe(this.div,"mousedown",OpenLayers.Function.bindAsEventListener(this.mouseDown,this));OpenLayers.Event.observe(this.div,"dblclick",this.ignoreEvent);this.layersDiv=document.createElement("div");
this.layersDiv.id=this.id+"_layersDiv";OpenLayers.Element.addClass(this.layersDiv,"layersDiv");this.baseLbl=document.createElement("div");this.baseLbl.innerHTML=OpenLayers.i18n("Base Layer");OpenLayers.Element.addClass(this.baseLbl,"baseLbl");this.baseLayersDiv=document.createElement("div");OpenLayers.Element.addClass(this.baseLayersDiv,"baseLayersDiv");this.dataLbl=document.createElement("div");this.dataLbl.innerHTML=OpenLayers.i18n("Overlays");OpenLayers.Element.addClass(this.dataLbl,"dataLbl");
this.dataLayersDiv=document.createElement("div");OpenLayers.Element.addClass(this.dataLayersDiv,"dataLayersDiv");this.ascending?(this.layersDiv.appendChild(this.baseLbl),this.layersDiv.appendChild(this.baseLayersDiv),this.layersDiv.appendChild(this.dataLbl),this.layersDiv.appendChild(this.dataLayersDiv)):(this.layersDiv.appendChild(this.dataLbl),this.layersDiv.appendChild(this.dataLayersDiv),this.layersDiv.appendChild(this.baseLbl),this.layersDiv.appendChild(this.baseLayersDiv));this.div.appendChild(this.layersDiv);
this.roundedCorner&&(OpenLayers.Rico.Corner.round(this.div,{corners:"tl bl",bgColor:"transparent",color:this.roundedCornerColor,blend:!1}),OpenLayers.Rico.Corner.changeOpacity(this.layersDiv,0.75));var a=OpenLayers.Util.getImagesLocation(),b=new OpenLayers.Size(18,18);this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MaximizeDiv",null,b,a+"layer-switcher-maximize.png","absolute");OpenLayers.Element.addClass(this.maximizeDiv,"maximizeDiv");this.maximizeDiv.style.display="none";
OpenLayers.Event.observe(this.maximizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.maximizeControl,this));this.div.appendChild(this.maximizeDiv);a+="layer-switcher-minimize.png";b=new OpenLayers.Size(18,18);this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MinimizeDiv",null,b,a,"absolute");OpenLayers.Element.addClass(this.minimizeDiv,"minimizeDiv");this.minimizeDiv.style.display="none";OpenLayers.Event.observe(this.minimizeDiv,"click",OpenLayers.Function.bindAsEventListener(this.minimizeControl,
this));this.div.appendChild(this.minimizeDiv)},ignoreEvent:function(a){OpenLayers.Event.stop(a)},mouseDown:function(a){this.isMouseDown=!0;this.ignoreEvent(a)},mouseUp:function(a){if(this.isMouseDown)this.isMouseDown=!1,this.ignoreEvent(a)},CLASS_NAME:"OpenLayers.Control.LayerSwitcher"});
