/*
 * Copyright (C) 2018 Purism SPC
 * SPDX-License-Identifier: GPL-3.0+
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "activity.h"

static void
test_phosh_activity_new(void)
{
  PhoshActivity *activity = PHOSH_ACTIVITY (phosh_activity_new ("com.example.foo", "bar"));
  g_assert (activity);
  g_assert_cmpstr (phosh_activity_get_app_id (activity), ==, "com.example.foo");
  g_assert_cmpstr (phosh_activity_get_title (activity), ==, "bar");
  gtk_widget_destroy (GTK_WIDGET (activity));
}


gint
main (gint argc,
      gchar *argv[])
{
  gtk_test_init (&argc, &argv, NULL);

  g_test_add_func("/phosh/activity/new", test_phosh_activity_new);
  return g_test_run();
}
