#include "phluid.h"
#include "debug.h"

static void
quit_gracefully(void)
{
  Client *c;
  for (c = client_list_head; c; c = c->next) {
    delete_client(c);
  }
  XCloseDisplay(disp);
  exit(0);
}

static void
sig_handler(int sig)
{
  switch (sig) {
    case SIGINT:
      DEBUG_PRINT("*** caught SIGINT ***\n");
      quit_gracefully();
      break;
  }
}

void
init_signal(void)
{
  (void) signal(SIGINT, sig_handler);
}
