# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from lib.reverse_translation import _t

#---PIL
def init():
    global Image, imtools
    import Image
    from lib import imtools

def transpose(image,method,amount=100):
    transposed  = image.transpose(getattr(Image,method))
    if amount < 100:
        transposed  = imtools.blend(image, transposed, amount/100.0)
    return transposed

#---Phatch

class Action(models.Action):
    """"""

    label       = _t('Transpose')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(transpose)
    version     = '0.1'
    tags        = [_t('default'), _t('transform')]
    __doc__     = _t('Flip or rotate 90 degrees')

    def interface(self,fields):
        fields[_t('Method')]   = self.ImageTransposeField(
                                    'Orientation')
        fields[_t('Amount')] = self.SliderField(100,1,100)

    def apply(self,photo,setting,cache):
        #get info
        info                = photo.info
        #dpi
        method              = self.get_field('Method',info)
        #special case turn to its orientation
        if method == 'ORIENTATION':
            photo._exif_transposition_reverse     = ()
            info['orientation'] = 1
        else:
            amount          = self.get_field('Amount',info)
            layer           = photo.get_layer()
            layer.image     = transpose(layer.image,method,amount)

        return photo

    icon = \
'x\xda\x01`\t\x9f\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\t\x17IDATh\x81\xed\xd9{\x8c\x9c\xd5y\x06\xf0\xdf\x99o\
\xee3{\xb7Y_\xd6\xd8\xd8\xa6\xc4.\x94\xe2[q\xa0\x01\n\xa8n\xa4\xc4$\xa2T\t\
\xa9ZE\x15\x94^\x94J\xf9\xa3\x89Z\xb5RD\xa4\xa4Q/\x8a\x8aZH\xa2DjU\x13\xa5\
\x8dTTD\x1b \x89"\x07\x1a\xb0MK|\xc7\xb0x\xb1\x8d\xbd\xbe\xad\xed\xf5\xce^f\
\xe6\xeb\x1f\xdf7\xde\xf5\xb2\xbe\x82eU\xf2;:\xfaFG\xe7;\xf3<\xefy\xcf{\x9e\
\xf7L\x88\xe3\xd8\xffg\xcb\\m\x00\xef\xd7\xae\x11\xb8\xdav\x8d\xc0\xd5\xb6\
\x0f\x8c@\x08!\x84\xef\x85(\xbc\x1bz\xc2\xa9\xb0$\x8c\x86\x15\xeb\xeb\xf7\
\xaf\xfe\xa0\xe6?\x97e/\xf7\xc5 T5\xdd#\xb6J\xb0R\xc3J\x19\xbd\x08\xad1\x1d\
\xa7\xdb\x07C.\xf4\xa1\x1e_\xa1|}I\x04\x82P\xc4G\xc5>-\xf8\xa8\x8c\xd2L\xe3\
\xf2r\xe6\x98-;\x92\x9b\x85v\x9c\xc4\xc4\xfb\x87\xfb^\xbb(\x02A\xc8\xe3Q\xfc\
\x19z\'}\xccrK\xac\xf3\x11\xd7\x9b\xaf\xcf\\\x9d\xcd\x0ec\x13\x13\xf6\xd7\
\x06m;\xb2;\xc6,\xd4B\x08Wd\x15.H \x08\x0f\xe1k\xb8~\xf2\xa5\xc8}\xd6\xfa\
\x8c\x8f\xcb\xd5r\xbe\xfb\xf3\xe7\xfc\xd7\xde\x8d\xf6\xed?\xe8\xc4\x89S\x93/\
\x1f7\x81N\x1cD\xed\x83\x06\x9f`97\xf0\x02\xfe\x0e\xbf?\xb5\xff~\xb7\xfb|\
\xfc\xbb\xb6\x1c\xde\xe1+?\xf9\x86\xad\xdb\xde8\xdf\xfc\x01EW0\xdb\xcdH \x08\
\x1dx\x01\xab\xa6\xf6?\xe0\x1e\x9f\xac\xdd\xe7\xe1o\x7f\xc1\xd1\xc3C\x17\x9e\
=N\xa7\xbb\x82\xf6\x1e\x02A\xc8\xe2_M\x03\xff)\xeb\xdc3\xbc\xdacO>\xee\xf4\
\xf0EF\xc3\x15\x85\x9e\xd8L+\xf0\xb7\xb8oj\xc7\x1dn\xb5v\xe8\x16\x7f\xfc\x8f\
_566~\xfe\x19\x9b\x92h\x1f\xc5\x90Q\xd4\xb5\xd6\xe2\n\xd8Y\x04\x82\xb0\x04\
\x8fM\x1f\xf4[\xf5\xfb}\xf1\xa9\xbf\x9f\x19\xfc)\xec\x17;\xa6\xee\xa4\x9a\
\x13F\x8c9i\xdc~M\x9b1\x82\xc6\x95\x81?}\x05b\x7f*\x88\xa6v\x95\x15m\xdb\xf3\
\x96\xd3\'k\xe4\xce\x8c\xe30\xde2a\xa7~\xfblWw\x14\xc3)\xe0S\xe9\x88~\x1c\
\xc5\xc4\xe5\xa4\xd0^\xe1\x96X\xe6\xf7\xb2\xc2my\xe1\x95\xa0\xfe\xe7\xfd\xe2\
\xd1s\x13\x08>9}\x929\xbam\xdd\xb3\'\t\r)\xc4\x97\x9d\xb2\xc7v\x87\xbc\x86\
\xfdx\x17\xc7qZ\x12<\xa3\xe9\xf7!\x9cp\x89\x87\xd8RaiS\xf4\xe5\xaa\xdc\x839!\
\x93\x93\x91\x13~U\x9c_\x182\xe1\xa1\xa9\xce8C \x0c\x86\xeb\\\xa7g\xfad\x03\
\x0ei\x1cl&^?\x81\xe7\xf5\xdb\xea9\xbc\x89\xbd)\xf8\x96\xf7\xc7%1\xdfL\x9fu\
\x89\x8c\xb8\xa8\x10\xbaSh\x1b\x92\xfbRI\xe1\xb1\x9cL\xa1 \x92\x13\xc9\xc9\
\xc8\xca\xc8\x86\xcc\x83\x85\xc3\x85;B\x08/\xc5q\xdc<\x8b\x80\xa6\x1bg\x9a\
\xb4\xaea\xa82\x9c\xf8\xf2G\xb6\xdb\xe5\xdf\xb0U\x12\x1e\x83\x12\x99\xd0\xda\
\xacM\x93\x1b6\x86\x8b\x0b\x9d\x10~E\xf1\xb3\xb1\xf2\xe3\x1d\xa29\x05Yy\x91\
\x82lJ \x92\x15\x89d\xc4\x13\xe3Or|U\x08a,\x8e\xe3f\x88\xe3X\x08!\xe3\x9f\
\xfd\x82\x87\xed\x98i\xfa\xcc\xcf\x82\xe6\xef\xc4[\xed\xf24\xb6`\x0f\x8eH\
\xe2\xbd\x8e\xe6\xe5\xca\x84{t\xdc>!\xfezV\xb4\xba(+iyy\xd9\xb4\xe5\xe4R\xf8\
\x91H\xdc\x08\xf1\xe6\'FV\xff\xf8s[\x7f\x1e\xc7\xf1x\x8b@\x1e\xbdF\xecU\x9a!\
{7\xb1\xce\x13\x9e\xf7\x1f\xd8\x99\x82\xaf\xbd\x1f\xe0\x0f=\x14\xa2#O\xb7\
\x7f=\x93\x89\x1e-\xcaE%yE9EyE\x05\x05yy\xb9\x94J\xf2\xc9\x88dd\x1c\xec\xcf\
\xbc\xfa\xd7\x8b\x9f\xb9\x0f\xc3Ar\xdc\x94\xb1\xc4F\xff\xeb\x8es\xfc\xe2\x88\
c\xbe\xe9S>\xe7\xa7\xa8\xb5b\xf0R-\x84\x10\x10=\xbc\x7f\xc5\xf7F\xe6\r>\x90E\
YAIAIQIQQQ!]\x87|\x1aHUU\x19\x19e%\xcdS\x1d\x8dO\xb4\xff\xc5B\x0cfS\x02y7X\
\x9e\xdd\x10\x89\xee\xc8\x18\x9b)i\x94u\xfb#\xff\xe2\xb3\xd6\xc5\xd5x\xd3\
\xe5\x80O-B[c\xdb\xdc_\x7f\xa4\xf33\x0e4\xf6\xdb1\xb1]\xb1kX9\x94\x94\x94S\
\x1ae\xf9t=\x96[.;1\xcb\xc9\xc6)\x13\x1a\xfef\xf3\x86 \x11\x89\xc7\'\t\xcc\
\xf2\xe1\xfa\xf6\x86y\x9bz\x1cXuT}\xa6\xb3\'\xa3G\xd5\x8bA\xf8C|7\x16_RzL\
\xbd\x9f\xc7\xac\xa7\xff\xf3\xd9\xf0\xf4K\xcfZ\xbc\xac\xcb\'~\xe3\x17\xcd\n\
\xb3\x95U\x95T\x94T\x15U\x14\x94\xcd\xb7\xc0\xe9Z\xd1\x9aG\x1f\x10\xb7\xc5\
\x898\x1f\x03\x1d\xc8g%J1\xabfL\x89\x81\xc7\x07\xad\xfd\x87\xe5^\x9e\xbb\xfd\
\\8\xda\xf1O\xf8Z\x10\x9e\xc2\x93\xb1\xf8\xc0\xc5r@\xae\xef\x97\xab\xf3f\xdf\
U\xce\xae\xbc\xbd\xcf\x87\xae\x9b\xaf\xa2\xaa\xa2]Y\x9b\x8a\x0ee\x1dJ\xdau\
\x99\xad\xd4\xe8\xb1\xe6K\xf7\x8a\'\xe2$\xaf\xb5Z\xa2r\xa3 9_\xe7(\xfa5\xb7\
\xfb\x8e<mK\xca\xee\xfd\xca\n\xcf\xb6\xff\xb7\t\xf5\x0b\x81\xaa\xe3Y\xbc\x8e\
\xfe\x0e\x06\xe6)\x0c\xfc\x81\xeb\x07F\x1d\xcf\xffT\xbc\xac){sQvY).\xddTi\
\x94\x96\xb6\x87\xca\r\x95\xa8R\xacjS\xd5\xae\xa2]U\xa7\x8aNU\xdd*\xba\xf5\
\x98\xab\x14\xf7X\xf5\xed\xfb\xed\xd9\xdc\x9f\xa4\x8d\x1e\xad\x15h\xfa+\xeb\
\xb0%\x9b\xf2i\x18uRAS\x909u`\xc4\x0f\xbe\xb8\xc9\x83_\xb8\xdb\xce\x05{\xbd\
\xe6\xbc\x9a?\x8b\xf5X_AQ\xc6\xb8\xa6o\xd9\xd7\xa8\xca\x85\x8a|\xa6*\xab\xa4\
\xa8\x1aJ\xaa\xd9\x8a\x8a\x8a\x16\xf8\xaa\x0eU]\xaa\xbaTt\xe94\xc7<\x8b\x1d\
\xa9\x8f\xfa\xd8\xf7\x7f\xd3\x9e\x81\xfed\xdd\xc2\x14\xef7\'\xc5a&\xed\x1a\
\xc7\xb0!\xbbEI\xef\xc8\xb1Q\x1b\xfe\xf2\x05\x85\x8d9\x8f4\xd6\xebT=\xef2\
\x94P\x96Q\x96Q\x12)\x8a\xa2\xa2l\xa6$\xa7$?-\xcb\x94\xcel\xd4\xc2\x946W\x9f\
\xde\xb8\xcfWw>\xe5\x86/\xdfj\xd3\x8e\xd7\xce\xfe\x91Q\x89\x1ax\xd3q\x89<\
\x89[\xc2-\x8b\x8a\xe3\xc6,u\xb7\xac \x97\xf4\xee\xdbq\xd8\xae\xd7\x07\xfc\
\xf6\x82u\xee\xec\xb8U\x1cb\x87\x1c\x9b\xea\x049\x94\x84\x94@\xa4,\xab,\xa7$\
7%E\x16\x14\x15\x94\xce\x80Ozg\xbb\xce"\x8b,\xb4\xd8\xff\x9c\x1cp\xf77>\xed\
\xb9M/L\x82\x0e\x92\xf0\xd9\xe8m\xbb\xbdm\x97\xedv\xda`\xcc6\x1ci\x1ddE\xcc\
\xc5j\xcb|\xde\xcd\xd6(pV+R\x99_t\xd7\x9d+\xac]\xfaK\xc6+u?\xf1\x9aWl\x951\
\xa6"\xa3*R\x15\xa9\xc8\xa9\xc8\xa9*\xa8(\xa8\xa4\xb9\xa5\xa2\xac\xaaj\x91\
\x85nt\xa3\xf9\x16zg\xac\xe6\x99\xbd/\xfb\xe6\x0f\xbf\xef\xddC\x87\xde\xbb\
\xb4\xa7\xf1\xef\xb6\xd9\xedE\x89\xee:$\x911o\xe2p\x8b@$\xc9.7\xe2\xc3V\xf9\
\x13\x1f\xb2Pi\x1a\x89\xfc\xe4\xbc\x9d}m\xee]\xb5\xc6G\xfan\xd3\xddV\xaaG\
\xf9\x89l\xc6\xb8a\'\x8c\x186\xa6\xa6K\xd5l]ztj\xd7)\x8a\xcbq\xa3\x19\xc5\
\xfbF\x872\xcf\xecy\xd5\x86\x1f\xfd\xe0\xecK\x80\xe96\x8e\xe7\rx\xd5\xb7$\
\xfa\xeb\xdd4\x88Z*w\xb4E\xe0L~\xc6r\xac\xb5\xc2#n1_\xc7\x14\x02\xe7\xbb\xc3\
(P\xe8\xcc\xea\xed\xea1\xaf\xb3[_\xc7\xacf\xbd!\x1c8z,\xbcsh\xd0\xe0\xe01\
\x8d\xfa%\xd45\'\xb1\xc9Q\x1b=\xa1\xe9g\xd8%\x91\xecc\x92\xf8\xaf\x9f\x11sH\
\x04]\x92[\xe7`\x19VZd\xbd\xb5n\xb3@\xb8\xb2w\x0bS\xac\x8e74\xbd\xe2u\xfd\
\x9e\xc1\xab\xd8!\t\x9d\x9a\xb42ii\xb03>\x8d\xe3\xb8\x19B\x18\x93H\xe4d\xaa\
\xb7\x8d\x18\xf2\x8e\xe5\xeer\xb3Ns]\xd9B\xfd 6;l\xab\x17\xd5l\x91\x84\xcd\
\xee\x14Sm\xa6\xba"L\x17\x93\xe9~(\xa2[r\x99u\x13n2\xcb\x1a\xcb\xac\xb4X\x9b\
^\x89\xfc{\xbf\xd6*\x92\x06\xc5\xf6\x1a\xb6\xdb\x16\x87\xbd$\t\x977\xb0OR,\
\x8d\x9e\xab(z\x0f\x81\x94DF\xb2\'\xda\xd0\x8b\x05X\x8cE*n\xd2k\xb9\xc5\xfa\
\xccU\xd0\x9e\x8e*^\x04\xe0\x86dc\x8e\xe0\xb0X\xbfS\x0e\x180h\x871\xfdx\x1bo\
a@RS\x0fc\xfc|\xcawF\x02)\x89 \t\xb1b\nq\xb6$\xd5\xceK[\xaf\xb2>\xed\xfaT\
\xcc\xd6\xadS\xbb\xa2\x82HR\x0b\x06M\xb1\x11\r\xa7M\x186\xe6\xb4\x9a\t55\xc7\
\x1d\xf1\x86q\x07$\xb1}\xd0d\x8a<b\xb2\xcak\\\xa8\xde8\'\x81)D2)\x91\x02*\
\x12\x15\xd8-Q&\xdd\xe8\x92H\xdb\xaa$\xb0\xf2\xe9\xf8H\xe2\xf3\xba\xc4\xef\
\xadb\x7f$\x05xtJ\x1b\x92\xdcd\x8cH\xb2L\xfdb\xeb\x8d\x0b\x12\x98F$\x92\x1c\
\xbcy\x89z\xa8LiE\x93\xa7E\x94\xb6Vq?\x91\x92\x18O\x01\x8e\x98\xbc\x82\xa9\
\x99r\x19p\xa9\x85\xd2E\x13\x98B\xa4%\xadZ \xb3&=\x9e*\xa93-\x11\x8a\t\x91\
\xd6s\xea\x8dE\xab/\xbe\xdc\xd2\xf4\x92\t\xcc@\x86I\xbdh\x86\xe7\xa4\x82\xbf\
\xac\x1b\x8b\x0b`\xb8\xf6O\xfdU\xb6k\x04\xae\xb6]#p\xb5\xed\xff\x00\xffpD!\
\x93;\xfd \x00\x00\x00\x00IEND\xaeB`\x82j\x88\xbf\xb5'
