# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu)

from core import models
from lib.reverse_translation import _t

#---PIL
def init():
    global Image, ImageOps, imtools
    import Image, ImageOps
    from lib import imtools

def solarize(image,treshold,amount=100):
    """Apply a filter
    - amount: 0-1"""
    image = imtools.convert_safe_mode(image)
    solarized  = image.convert('RGB')
    solarized   = ImageOps.solarize(solarized, treshold)
    if imtools.has_alpha(image):
        imtools.put_alpha(solarized, image.split()[-1])
    if amount < 100:
        return imtools.blend(image, solarized, amount/100.0)
    return solarized

#---Phatch
class Action(models.Action):
    label       = _t('Solarize')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(solarize)
    version     = '0.1'
    tags        = [_t('filter')]
    __doc__     = _t('Invert all pixel values above threshold')

    def interface(self,fields):
        fields[_t('Treshold')]   = self.SliderField(128,0,255)
        fields[_t('Amount')] = self.SliderField(100,1,100)

    icon = \
'x\xda\x01\xd3\x0b,\xf4\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0b\x8aIDATh\x81\xed\x99m\x8c\\\xd5y\xc7\x7f\xcf\xb9/\
3;3\xfb\xfef\xaf\xf1+\x06\xecB\x0cN\x9c\xc6m\r\nn\xa4|\tU\xeb\x06\xfaB\x938\
\x95\x00\xab\x1f\x8ah\x91\xda\xd06j\x8bZU\x95Z\x1b\xa9\xad\x04R\xddV\xd4\x10\
\xd47\xbe\xc0\xa7\xb4MDU\x17\x820\x90\xc5\xb1\xe3\x15\xb5\xcdz\xe3\xb5ww\xbc\
\xbb3;3\xf7\xe5<\xfdp\xef\x9d\x9d\x99]\x1b\xefB\x95/\x1c\xe9\xcc\x9c33\xf7\
\xde\xff\xef9\xcf\xf3\xdc\xe7\xdc\x81O\xda\x8f\xb7\x89\xaa\xae\xe9\x00=*\x00\
\x06\x90\xec\x1c\x9d?iy\xb7\xf2\xc4\xda\xce\xbf\xd6v\xd3\x00zT\x84L\xb8\xc5\
\xc1\xe2\xa28(\x06m\x83P\x0c\x16!\xc6\x10a\x88\x00\x0b\xe8\xff\x07\xcc\x87\
\x02\xb4\x087D\xf8\xc4xX\xdc\xb4;8\xb8\xf4\xe5<\x00\xca\x8d\x88\xb8)>\xeb!\
\x0e!.\r \x96\'\xd6\xb8\xe4\xeb\x05hq\x15C\x8cOD\x8e\x08\x9f\xbe|\x81-\xa5A\
\xe9vG\xe3\xe9\xc6=\x12\x85\x9bX\x8a\x87\x8c`\xac\xef\xceh\xce\xf9\x91\x19\
\xf1\xdfa>\x9a\xe6\x83\xea\x1c\xe5\xc6R\x13\xc0!\xc0\xa5\xc6\xc7\xe8Z\xab\
\x02\xa4\xe2\x1d\x14\x87\x90<\x11y\x06r\xa5\xf8\xf6\xbe\xad\xeed\xe5\xd7t\
\xc1\xbd\x97\xdc\xe6mto\xf1\xe8\xdb\x8e\xf6o\x07\'\x07\xf3\x17\x90k\xe7\x91\
\xf9\xff\x8d5\x98\xfa@\xf3\x0b\xffe7\x16N8g\xe6/0\x1fTq\xa9\xe3\xd2\xc0c\t!\
\xfc8 V\x004\xc5[\\B\n\x84\xe4\xf9\xdc\xe86\x9d\xae\xfe\x92\x99u\xbf\xaa\xb7\
}\xb9\xdf\xde\xfes\xe0\xf8\xe9\x01\xb4\x84qK(\x88 \x93\xff\x83\xfc\xe0\x1f\
\x16\xd5\x9f~\xc1\xf6\xe6^r\xbe?{\x11\xa1\x86G\r\x8f%\x0c\x8d\x8f\n\xd1\x06\
\xb0B\xbc\xd3U\x92\x9f\xec\xfb\t\xbe_\xf9s\x1d\xfd\xd9=z\xc7\xcf\x83Wl\xeal\
\xc6\xae\xb4\x8bo\x8fh\x90\x0b\xdfA.\xbc\xfc\xc3xS\xe3\x1b\xce[\xf3\xefa\x1b\
U<\x96\xf0\xa9`\x08>\nD\'\x80Aq\t(\xe2t\x95\xb8\xab\xe7>9\xbb\xf8\x17\xba\
\xf7\xb7Gm\xff\xf6\xf6|)\xb2\xeaXWd\xd5d.a\r\xbe\xf7ge\x19Y\xf8}N/\xfe\'Q\
\xb0\x88O\x15\x9fE\xf9-\x8d>2@\x9am\x1c\x02\n\x04\x14\xe3\x9f\x1a\xf9\x94\
\xfb\xee\xdc\xdf\xdb;\xbe\xb6\x91\x91=`V\xb1\xb6\xb0:\x94\xae\x02\xa3\x02\
\xb5\x19\xcc\xa9\xbf,\xeb\x0e\xef\x08\xaf_}\x1b\x97J\n\xb1\xb0\xde\xec\xd4\n\
\xe0\x10\x93\xa3A)\xfa\xcc\xe8\x0ew\xa2\xfc7\x0c\xdf\xbf\x97-\xf7\xb5hH\x157\
oa\x1d\xd6n\x01h~\xa3\xa9\xf8l:\x7f\x01s\xf6\xef\xce\xe9\xe6\xee\xdf\xe0\xad\
+\xef\x93K\x00p\xa9\xad\xc7\x95\xdcT|\x92\xeb#r\x0c\xe4J^\xb9~\x88\xa8\xb4\
\xd7n\xf84\x84\x95e\x83\x9bLh\xfa\x92\xc2h\x1b\x88\x80]\xbe\x1d7\xc5+\x88\
\x82\x14\x06\xa1{\xf7m\xcc\x9f{\x98n\xef\x18Ka\x84\xa1+\xbdO\xd8u\x01\x90\
\xdd\xa4"|\xd9\xd5\xbfY\xdf\xba\xf2u\xe9\xdd\r\xe1\xe2\xb2)\x8d$Z\x0c\x89\
\xa5\xa5\x85\xa15\x0b\xb5\x14\x12\x9a\xcd\xd3U\xd0l\xdc=\x06\xe7\xdf>\x14\
\xdf1\xf0o\xce\xf7f\xaa8\xe9}\x06jk\x06H3\x8f\x10\xe3\xd1\x95\xefb\xb2\xf2+\
\x12\xda!-\raR\x005\x89U1\x89\x90\xa6\x1b\x99\x96 \xd0\x94$\x15)iGA5=\xde\
\xa6P\xf9~\xb0\xda\xe3\xce\xd4\x1f\xd6\xa2\xff\'4\x82\x80\x98\xbc\x1e\x955\
\xbb\x91Kkm\xb3\xb34\xc8\xc5\x85\xfb\x11\xc0+\xa1a%\x11\x99\xdc\x8f\x9b\x82\
\xb2\xb9\xb6\xb8G\xabxH\xadmA\xd2N:\'N\xb3\x92\xdf\x0b\x0b\xd5\xfd\xd1Xq\xc8\
\x9d\x08*\xc4ii\x02\xf1z\x00\\,n\x9c\xf7\x86\xddz\xb8\r\x01\t\xaf\xa1R\x02\
\x87e\x17 \xb5|\x16\x98\xe9M\xac\x19\x1b\xa4\x16\xb6\xb4\xbb\x8d\xcd\xba$\
\xf2,\xa0\r\x88\xa21\xb7?7\x8ae\xb2Y_\xad\x0b@q\xb08Ne\xe9S\xa8\xfa\x08\xb0t\
\x19\x91\xd1d\xd9\x1dI@`\xd9\xe1\xb3X0i\x9cJ\xea6\x9d \x99\xf0\xac&\x8d\x05i\
\xd4\xc0\xd6@qu\xb6\xb6O,\xef\xa4\x1a\\\xa0\xb1V\x00\xd2\x92\xd8\xd1\xban\
\x91\xcc\xbf\xeb\xb3\x90/\x02\x92\xb8Nk\xf5oh\xba\n\x86\x04.s\xa1\x18PI\xdc\
\x86Lt\xd25NV@\xeb\xb3d\xd7\x11\xecf\x04\x07\x9bhX\x8b\xf8\x0c@P\x84\x9e\x9c\
g\x1a\xd1\xc6\xa6\xc8\xc6"\x1a,"\xae\xa4\x98\x02^*&\x13\x9d\xc6\x02n\xbaBI\
\xd5\xbf\xec&qj\xf9(9N\xb2ycv\xd9\xfd\xc2xX\xbb=\x8fz(\xb0>\x80\xd6&\xcb\t<F\
jS\x90\xefI\x04y\xa9\x85}\x92\xc0N\xad\x8a\x97\x8a\xf7\x81 \x85\xef\xf4\xf9(\
\x1d\x07@ci9=\'A\x9fl\x88\xb2\xbe\x0e\x80D\xf2|#\xb2\x83\xddW\r,g\x93\xb0\
\x01R\x06\xdfkcl\xbe\x99T\x14@Hb\xfd \x1d\x87\xad\xe3\x14"\x8c\xa0Qk\xc9V\
\xa0\xae3C\xa5\x16\xe25\xf3\xd4\x9a\x01\x12\xc9\x82\xaa\xefL\xb6\xf9\xba\x02\
q\x04A\x94\xb8O\x07C\xd3\xe7\xc3\x96\xdfg.\x13\xa4\x10m\x00\xda&>Q`.\x11c\
\xf1Pd\xbd\x00\xc9\x1e\xd6\xeah\xeem>\x90\x08U\x97\xd6\xf4gR\xa1Y\x96n\x05\
\xd0v\x00k\xa1aG\x89\xbb\xeeD\x87vA\xd7\x8e\xe4\x04q\x0cq\x08\xe5\xf7\x91\
\x99\xf7\xf0\xca\xe3\xe4\x82\x8a\xa5\x94;\x95]\x1fa\xcdUi\xe2BB\x8c\x10;\xe5\
p\x06\xdf\x9d\xa4\x11nk\n\xcf $\x15\x9a\xb5\x0c0J~W7\x83\x84#\xbf\x88\xdc\
\xf2e\xf2\x1b\x7f\x9a.\xa7%\x1e\xdb\nMEUiT\xe7)\x9f\xfe\x97\xc6\xe2\xf4\xdb\
\x85[\xe4x,\xd9\xfey\x1d\x00\x16C\x84C\xc4\x85\xea\x1c}\xfeI\xaet\x00t\xdeZ\
\xb2\xcf\x0c\xc4\xc6\xa1\xb2\xf1+\xe4\xf7~\x83\xee\xe2`\xaa\xb1\xd6\x01\xabm\
c\x01\xf2\xbeK~\xdfW\x9dBt\xf8\x9b\xef\x15\xee\xcb\x95\xbe}\xf8\x05\x13\x10m\
]#\x80\xa8jRJ7\xe8\xa1A7\x9f\x1d\xbeKN\xcf~\x0b\xb5\xdd\xc0r\xaatXN\x9d\x0e \
\x10\x89a\xf1\x9ec\xf4\xdd\xf1\x00\xd2V\x91jKQ\xd7.>\xfb\x1a\x11\xa50t\x15\
\xf1\x1bA\x14\xd9\xf2\\\xf9|\x10\xebL\x18\x86\x93a\x18^\x9c\x9a\x9a\xfa\xef\
\x83\x07\x0f\xbe\xae\x1f\xf2\xd8$\x0bb\x8bC\x80C\xc0D\xed\x82\x1d.\xfe\x93\
\xb9\xbc\xf8\xeb\xcd\x94\x98^4\xa0@}\xecK\xe8\xe0nl\xf52\x91?\xc0\xd0\x8e\
\x83HT])\xb2u\xbe\x1aL\xbeg\x11\x95\x05D#\xdf\xf3\xec\xe8\xc6M}\x88\xf4\x02\
\xb7\x02\xba}\xfb\xf6\x87O\x9e<y\x14\xf8\xc7\x9b\x01P\x1c\x1a8\xe4\x98\xab,\
\xda[GO\x98r\xfd\xf3\xd4\xc3\x1d\xb5\xdc\x10\xd1\xc6\x9f\x81\xae~\xcc\x8e/\
\xd23rk"$3xX\xe98\xe5\r\xac\x9fM\x1d/\xc4/N\xa1\xd4@cD"D\xa2\xe5\x13\x80\xef\
\xfb\xec\xda\xb5\xeb\x97\xdfx\xe3\rwzz\xfa\xf4\xcb/\xbf\xfc\x83\xe3\xc7\x8f/\
v.H\xfb\x962\xa2@\x83\x12\x96\x12\x9f\x1b\xfe\xcc\xe2\xe5\xbb\x8ew\xdd\xfft\
\xd1\xcb\x15!X\x00\x8d\xa15\x07\n\xed\xf3\xd5\xac\x9f\xfd$\x1b\x1b\'f\xf0\
\xd6\x1f\xe2\xf4\x961n\x8c\xe3F8\xb9\x001\xad\x8f$\xdbZ\x1c\xc7\xfe\xd2\xd2R\
4==\xfd\xda\xa9S\xa7^z\xe8\xa1\x87&2\xdd+7\xf5\x01\xdd4(\x9e\x1f\xfe\xe2\x8e\
[\xbe\xf2\xb7/z6\x1a\xa3z\xd5P\x9b\x03\xdbh\xb7\xfe\x8ak]\xc7\xdf\xb3\xb1\
\xe3\xc4\x0cn?\x87?:\x85\xf1C\x1c/\xc6\xcd\x05\x18/Zy\x82\xe6\xdc\x01z\xd3^\
\x8a\xa2h\xfe\xdc\xb9s\xcf?\xf9\xe4\x93\xcf\xbe\xf2\xca+qg)a\xf1XB1z\xe7\xd7\
\xb6{\x85\xd1\x1cvi\x9a\xa5+\x03\x84\xd5\x1cQ\xadc\x17\xdf"\xb2\xf3\xda\x9d\
\xee\xe3\xe7j\x0c\xee|\x17wp\x06L\x88H\x84qB\x8c\xd7Z}^\xcf"\x86\xc4\xdd}\
\xd7u7\xed\xde\xbd\xfbw\x8e\x1d;\xe6\x1e:t\xe8\xaf\xdb\x00\xe4\tE\x8fJ\x88\
\xc7R\xe0\x14\xeb 1\xf8\x15\xfa\xb7N\x13-\x0c27\xb7\x11\x1b\xbb\xab\n\xbe\
\x9e+\x89\x89\xe9\x19\x9ed\xf0\xb63H\xef|"\xdeD\x187\xc4\xcd\xd7oB|\x06\xe0\
\x019\xa0\x00\x0c\xee\xdc\xb9\xf3\xc8\xa3\x8f>\xfa\x9d\xce\x15\xc8 \x1a\xef|\
\xf7\xa5\xff\xd8\xf1\xe9\x83g}\xdf\x1f\x84|\x99\xde\xdb\'(\xf6\x16\xb8z\xf6N\
\xaa\xd7\x86\t\xea\x85U\x05g\xd7\xf6\xfc\x1a\x85\xbe\xab:\xb4\xf34f`V\xb4\
\xab\x81q"\x15\x13\xe1\xf8\x81\xba]\rl\x12\xd9\xa9\x1b\'/YL\xb6\xf8\xb6\x88 \
"9\x11\xe9\x12\x91\x1a\x10\x88\xc8\xf6\xb1\xb1\xb1=7|\xb8\xfb\xfag\xbf\xfd\
\x0b{\xf6\xec\xfdU\xcf\x11c\xeb\x0b\x975\xacY\xb5\xf5\x9cP\xed",\xf7\xb3x\
\xf9\x16\t\xebE\t\xea]**8\xb9\x9az\xb9\x8a-\x8eL\xa9\xd3[\x86BU\xf1\x1b\x187\
V\xc7\x8b\xd5\xb8!^)P\xaf\x10\xb4\n\xec\x18w\xc2\xa81&\xefy\xde\x06\xd7u78\
\x8e\xb3\xc1\x18\xb3\xc1\x18\xb3a||\xfc7o\xf8x]D\xe4O\xff\xf8\x9b\x9b\xf7\
\xef\xbb\xfb\x0bw\xee\xde\xb5Yl\xe8\x12\x87\x06\x1b\x1a\xb1\xb1Q\x1b\x19!r v\
\xd4Z\x01\'FMd1\x8aq\xac\x8a\x89\xd4\xb8\x16\xe3\xc6\xea\xe6B\xeb\x16\x1bj\
\xfcx\x15\xd1m\xd6\xef\xfcZD\xdcb\xb18\x96\xcb\xe56z\x9e7\xe6\xba\xee&cL\xcf\
\xf1\xe3\xc7\xbf\xb4\xc2\x85\xdaV!9\xcb\xc5\xfd\xfb\xf7\xbf\xf0\x07\xbf\xf7\
\xbb\x0f\xef\xda\xb9\xb5D\x14:bCGl\x94\x00\xd8d\x17\xa3\xaa\x02\x91M\xf7GV\
\x8d\xb1\x88\x1b\xc7\x8eD\xd6\xed\nl\xe4DP\x07\xea\xab\x8a\xbf\x9e\xf5\xb3q\
\xea>%cL\xd5\x18S\x9b\x9b\x9b{\xfd\xcd7\xdf|\xff\xa6\xff\xa1y\xe4\x91G\xb6=\
\xf8\xe0\x83\x9f\x1f\x18\xe8\x8f\xc5F\xc6\xd8\x86C\x1c\x88\xd1\xd0AUT- j\xc5\
\xb1*nlM.\xb2\xe2\xc6*N&\xe2z\xa2o\x08\x90}=888\xdc\xd7\xd7\xb7\xb5X,n\xa9T*\
\x8bO?\xfd\xf4\x1f>\xfb\xec\xb3?\xbai\x00\x11\xe1\x81\x07\x1e\x18\xdd\xbf\
\x7f\xff\xde\xbd{\xf7\x16|\xdf\xcf\x9e=\xac\x1a\x847\xa9\xb9\xd3}\xae\x0b644\
\xd4\xdb\xd7\xd77<11\xb1p\xe2\xc4\x89\x7f\x7f\xf1\xc5\x17/\xc1:\xfe\xe4\x13\
\x11\xf3\xd4SO\xdd\xbfo\xdf\xbeV\x11\x9d\x00\xd7\xcd(\xd9\xb8^\xaf\x9b|>oo\
\x10\x0b\xcd\xb1\xaa211a\xce\x9c9s\xe5\xb5\xd7^{\x7frr2\xdb\x07\xae\xd8\x13\
\x7fhSU{\xe0\xc0\x81w\xab\xd5\xea\xed[\xb6l1\x03\x03\x03\x01I\xa6h5\xc6\xf5`\
\xd4Z\xab\x97.]\xca=\xff\xfc\xf3K\xc3\xc3\xc3fdd\xa4\xb8m\xdb6)\x95J\x91\xef\
\xfb\xd6\xf3<+":33\xe3\\\xb9r%\xaeT*K\xb3\xb3\xb3\x953g\xce\\\x9e\x9e\x9e^\
\xf1\xc8e\xcd+\xd0<P\xc4\x1d\x1b\x1b+\x8d\x8d\x8d\xf5\x1f8p`\xf4\xf1\xc7\x1f\
\xbf\'\xfd\xbc\xcd\xfa\xd9<k\x0b\x0b\x0bW\x1e{\xec\xb1\x8b\'O\x9e<\xa5\xaa*I\
\x1d^\xe8\xeb\xeb\xf3<\xcf3\x9e\xe7\x19\x80\xa9\xa9\xa9\n\xd0\xb8\xd9rz\xcdM\
U#\xe0\x1apmtt\xf4\xea\x91#G\xee\xdd\xbcy\xf3]\xad\x00\xed{\x04TU\x83W_}\xf5\
_\xc7\xc7\xc7\xcf\xb4\xb8\x8b\x02\xd5\x15\x17X\x83\x90\x8f\xa5\x97J\xa5\xc2\
\xf8\xf8\xf8\xd7+\x95\xca_\x85a\xf8\xdd8\x8e\xcf\xa7\xfdL\x10\x04\xff<;;\xfb\
G\xcf=\xf7\xdc\xbd===\xf9\x8f\xeb\x9a\xaa\xba~\x17Z\xad\x89\x88l\xd8\xb0\xa1\
{hh\xa8\xeb\xf0\xe1\xc3\xc3w\xdf}\xf7\xd83\xcf<s\xf6\xec\xd9\xb3\x8d\x99\x99\
\x99j\xb9\\^Q\xcf\x7f\xd2>i?\xe6\xf6\x7f\xe6F\xbd]d\x9dV\x7f\x00\x00\x00\x00\
IEND\xaeB`\x82\xc3I\xef\r'
