# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

from core import models
from lib.reverse_translation import _t

#--- PIL function
def init():
    #lazy import
    global Image, ImageOps, imtools
    import Image, ImageOps
    from lib import imtools

def grayscale(image,amount=100):
    grayscaled = ImageOps.grayscale(image)
    if amount < 100:
        grayscaled = imtools.blend(image, grayscaled, amount/100.0)
    if image.mode == 'RGBA':
        grayscaled.putalpha(image.split()[-1])
    return grayscaled

#--- Phatch Action
class Action(models.Action):
    label       = _t('Desaturate')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(grayscale)
    version     = '0.1'
    tags        = [_t('color')]
    __doc__     = _t('Fade all colors to gray')

    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(100,1,100)

    icon = \
'x\xda\x01q\x07\x8e\xf8\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x07(IDATh\x81\xed\x98oh\x1ci\x1d\xc7\xbf\xcf3\xf3\xcc\
\xeelf\xfff\'W\x93M\x0c[7\xa4\x1c\x89\x89\r\x95\xa8\xa4\x15\xd3\xda\x17V\xa3\
\xc2\xe9]\x91S\xa4\'\xa2P\xf1\x85 \xdc\xc1\xbd88\xf0@\x05\x95\xf3\xa5B9}U\
\xce\xc2Q\xb8pI\x04S\xb5\x7f\xa0i+i\xd2$\xdb\xbf\x9bM\xe2\xeel\xb2\xdd\xdd\
\xd9\xf9\xf7\xf8bv\xd6\xa4iz\xd7d\xeb\x05\xcc\x17\x06v\x86\xd9\xdf\xf3\xfd\
\xfc\x9e\xdf<\xbfg\x06\xd8\xd3\x9e\xf6\xb4\xa7=\xfd?Kx\x16A\x0f\x1e<\xd8\xa1\
\xaa\xaa\xb5\xb4\xb4d>\x8b\xf8\xebE\x1b\x1cO:u\xea\xd4\xef\x15E\x99\xbc\x7f\
\xff~\'\x80\x18\x00\xd2\xe016\xa8\x91\x00\xfe\x93\'O\xbe\xf1\xe0\xc1\x83\x1f\
d2\x99?\xe5\xf3y\x13\x80\x0e\x807p\x8cMj\x14\x80t\xe4\xc8\x91\xe3\xba\xae\
\xffT\xd34\xd8\xb6\xbd\x00\xa0\x04\xa0\xda\xa0\xf8[\xaa\x11\x00,\x1a\x8d\xee\
\x93e\xf9W\xb9\\N\x90$\t\x8a\xa2\x04\xe1f\xdfn@\xfc\'j\xa7\xf5\xe9\xeb\xeb\
\xeb;\x18\x89D~\xce\x18\xfb\x8aw\x91s^\xb4m\xfb\x9f\x00\xee\x01\xb8\x05\xe0"\
\xe7|rbbB\xdf\xe1x\x9b\xb4-\x80D"!www\xbf\xc8\x18\xfb\xb1(\x8a\xfd\x94R\x10\
\xe2\x86\xe2\x9c\xc3\xb2,p\xce!I\x12\xc2\xe10\x18c(\x95JUM\xd3\xfeb\xdb\xf6[\
\xa3\xa3\xa3\x97?\x16\x80\xde\xde\xde\xa6\xf6\xf6\xf6\x1f\xfa|\xbe\xd3\x94\
\xd2\x04!\x04\xa2(B\x10\x04\x88\xa2\x08\xef\xbc\\.\xa3T*\x01\x00\x18c\x88\
\xc7\xe3\x88\xc7\xe3\x90e\x19\xb9\\\x8e\xcf\xcd\xcd\xbd\xb3\xb8\xb8x\xfa\xe2\
\xc5\x8b\xb9\x9d\x02|\xa4>\x90H$\xe4\xe1\xe1\xe1\xd3\xfb\xf6\xed{\xc7\xef\
\xf7\x7f\x931\x16\x92$\t\xde\xe1\xf3\xf9\xc0\x18\x83\xcf\xe7\x03!\x04\xba\
\xae\x83R\nA\x10@\x08\x81eY\xa0\x94B\x92$\xb4\xb6\xb6\x92\x03\x07\x0e\xf4\
\xca\xb2\xfcr(\x14\xfa\xd7\xfc\xfc\xfc\x02v\xb0R}\x18\x009q\xe2\xc4g\xba\xbb\
\xbb\xdf\x93e\xf9;\x82 \x04\x19cu\xe3\x8c1P\xea\xae\x03\x96e\xa1R\xa9\xc00\
\x8c\xbay\xef \x84\xc00\x0c\x08\x82\x00J)|>\x1fR\xa9\x94\xd2\xda\xda\xfaRSS\
\xd3\xda\xf4\xf4\xf4e\x00N\xa3\x01\x84\x91\x91\x91\xe1\x96\x96\x96\xf7EQl\
\xa3\x94\x821V7\xc59\xdfp\x10B6\x19\xf7\xca\xcb3\xee\xc1y\xf7\xaa\xaaJR\xa9\
\xd4\x97#\x91\x88r\xf5\xea\xd5\x0f\xb6\x03\xb1\x15\x009~\xfc\xf8g\xe3\xf1\
\xf89\xce\xb9\xe2\x19\xe4\x9c\xc3q\x1c8\x8e\xb3%\xc0\xa6@\x84\xd4\x0f\x00\
\x9b \x82\xc1 :;;\x07\xfd~\x7f\xe5\xfa\xf5\xeb\x7f\xc7S\x96\xd3c\x01b\xb1X\
\xa8\xbf\xbf\xff]\xcey\xbb7\xb8m\xdb\x9b\x8c\x8b\xa2\x88@ \x80@ \x00\x9f\xcf\
W\xcf\xb8\x07B\x08\xd9\xf4\x1f\xc7qP\xa9T\xea\xbf9\xe7\x08\x04\x02hkk\xfb"\
\xe7\xfc\xca\xec\xec\xec\xdc\xd3@<\x0e@8v\xec\xd8\xcf\xc2\xe1\xf0\xb7,\xcb\
\xaa?\x84\x9c\xbb1\xd7/\x8fMMMu\x93\xb6m\xc3\xb2,\xd8\xb6\r\xdb\xb6\xeb\x06\
\x1f\x07\xce9G\xb9\\\xae\xff\x06\x80p8L#\x91\xc8\xd1\xf9\xf9\xf9?k\x9a\xb6\
\xb6m\x80\xfd\xfb\xf7\xab\x1d\x1d\x1d\x7f\xb0m\xbb\x89\x10\x02\xd34\xeb\x83\
\x88\xa2\x88h4\nEQ\xea`\xba\xee\xf6&\xcf\xe8z\x18\xcb\xb26\x98\xf7\x12\xe0\
\xc1\x95J%\xd8\xf6\x7f\x9b\xb5\xaa\xaaM\x96e\xed\x9f\x9a\x9az\x0f\x1fq\x1b">\
\n\x94J\xa5\xbeM)U\t!\xa8T*(\x95J\x08\x87\xc3\x08\x85B\x08\x85B\xf5Fe\x9a&\
\x8a\xc5b\xbd\x94\xbc\xcc\xd7\xcc\xaf\xa4\xd3\xe9\xb7\xd6\xd6\xd6\x96\xf3\
\xf9\xbc\x06\x00\x8c1\x16\n\x85"\xd1h\xf4\x13\xc1`0\x19\x0c\x06\xfb$Iz>\x97\
\xcbI\xc5b\x11\x85B\x01\xb1X\x0c\x8c\xb1\xaf\x1e=z\xf4\xa5\xd1\xd1\xd13\x00\
\x1e>-\x80O\x96\xe5\x11/\xf3\x86a\xa0\xb9\xb9\x19\xaa\xaa\x821V7X,\x16a\x9a&\
\x04A\xa8g;\x1c\x0e#\x10\x08\xf0l6{\xf9\xec\xd9\xb3\xafU\xab\xd5\xe5Z\x16\
\xbd\x14\x93\xc5\xc5E\n@\xaa\x8d+E\xa3\xd1hoo\xef\x97TU}\xa1R\xa9\xb4e2\x19\
\x00@$\x12y\xb3\xab\xab\xeb\xca\xec\xec\xec\r\x00\x95\'\x01\xac\xef\xc4$\x99\
L~j``\xe0\x06\xa5T2\x0c\x03\x91H\x04\xf1x\x1c\x8e\xe3\xc04\xcdz\x87e\x8c\x81\
1V\x11\x04\xc1\xa1\x94:\x9cs-\x9b\xcd\xfemrr\xf2\xdd\x95\x95\x95\x07\x00r\
\x00\n5\x00\xab\x16\x9f\xc3-Y\x11\x00\xab\x81\xc8\x00\x02\xa2(\x06\x07\x07\
\x07\xbf\xde\xd2\xd2\xf22\xa54\x06\x00\xd5ju\xf2\xdc\xb9s/\x02\xc8\x02\xd8\
\xf2\xc5h=\x00\x1b\x1a\x1az%\x16\x8b\xfd\x96s\x0eA\x10\xa0\xaa*\xd7u\xfdF6\
\x9b}?\x9b\xcdfB\xa1P*\x18\x0c~N\x92\xa4\xe7m\xdb^\x9e\x9d\x9d}ufff\x1a\xee\
\xfam\xc1\x9d\xf2"\x80U<y7J\xbcY\x00\xd0\x04 \x00 \xa4\xaajb``\xe0UY\x96\x07\
\t!\xc8\xe7\xf3\xbf\x18\x1f\x1f\xff%\x80\x7fo\x15k=@hxx\xf8\x8f\x8a\xa2\x8c\
\x00@\xb9\\\x9eJ\xa7\xd3o\xdf\xbauk\x1a@\x19\xeeT\xda\x00|\x8a\xa2\x84\x05A\
\xf0\xad\xae\xae>\xaceZ\xabe[\x07`<\xc1\xf8V\x1e$\x00\n\x800\x80\xe8\xe1\xc3\
\x87\x7f\x14\x8dF\xbf\xc797\xd2\xe9\xf4\xc9k\xd7\xaeM\xd4\xc6\xd8\x14\xb7\
\x0e000\xf0\xf9T*\xf5W\xcb\xb2\xd6n\xdf\xbe\xfd\xbbK\x97.\x8d\xc1})Y\x85\x9b\
\xd5j\xcd\x1c\x85[\x02\xde\xf3\xa3\xd7\xee\xdb\xe9\xfb/\x81;\x13a\x00\xb1\
\xa1\xa1\xa1\x9fD"\x91\xef[\x96u\xe7\xc2\x85\x0b_+\x14\n\xf7j>6\x8c\xe3-\xa3\
\xb4\xbf\xbf\xff\x05\xd34\xf3\xe3\xe3\xe3o,,,\xdc\x00\x90\x07\xb0\x02\xb7\
\x9eW\xe1\x96\x87Q\x03)\xd7\xce\x1f\xd6\x00\xb6\xb5\x8fy\x8c\xccZ|\xe7\xce\
\x9d;W\x13\x89D\x0fc\xec\xd3\xaa\xaa&%I\xba\x97\xcb\xe5\xca\xb5\xfb,\xd4\x9a\
\x9d7\x03\x04@\x1c\xc0s5\xa8"\xdc\xd2\xf0L\xff\xaf\xc5\x00\xc4\x0f\x1d:\xf4J\
,\x16{\x1d\x00(\xa5\xf0\xfb\xfd+\xba\xae\x9f\x19\x1b\x1b\xfb\x8d\xae\xebK\
\x00\xca\xeb\x9f\x01\x01\x80\x1f.L\x15;/\x89\x9d\x88utttuuuMPJ\xe3\xdeEB\x08\
dY\x86,\xcb\xd7\xce\x9f?\xff\xddB\xa10\xbf\xbe\x13s\xb8\xa6\r4\xae$\xb6+\x7f\
OO\xcf\x9b\x82 \x0c>\xda\xc5\r\xc3\x80a\x18\xcf%\x93\xc9\xbe\x99\x99\x99\x0f\
\x9e\xc9\x87\xad\x06(\x98L&\xdf\x06\xe0\xe7\x9c\xa3R\xa9\x8ci\x9av\x86s\x9e\
\x03 :\x8e\x133\x0c#\xe1\xf7\xfbo?\xda\x89w\x8bD\xc7q\xfc\x00\xc09_\xbdy\xf3\
\xe6\xaf5M\x9b\x83[\x1dbGGGO{{\xfb\xeb\x8a\xa2|a\xb7\x02\x98\xa6if\x08!\x9f\
\\\\\\|M\xd3\xb4\xbbpW\xc55\x00\xc2\xdd\xbbw\x0bKKK\xdfhnn\xee\xdc\xad\x00\
\xbaa\x18W\x04A0\xd3\xe9\xf4\x14\xdc\xd5\xd0\xeb\xee\x00P\xaaV\xabZ&\x93\xc9\
\xec\xd6g\xc0Q\x14E\x03\x10Z^^\xfe\x07\xdc\xad\xc4\x1a6\xbe\xe8\xd8\x00\x8cg\
\xfa\xe1u\x87\x92\x00D\xe1.\xeb\xab\xf8\x90]\xe9n\xd6nN\xf2\x9e\xf6\xb4\xa7=\
\xed\xe9c\xd6\x7f\x00="`\t\x86\xccA\x1b\x00\x00\x00\x00IEND\xaeB`\x82U|\x9b\
\xeb'
