# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from lib.reverse_translation import _t

#---PIL
def init():
    global Image, ImageColor, imtools
    import Image, ImageColor
    from lib import imtools

def contrast(image,amount=50):
    """Adjust brightness from black to white
    - amount: -1(black) 0 (unchanged) 1(white)
    - repeat: how many times it should be repeated"""
    if amount == 0:
        return image
    elif amount < 0:
        #low contrast
        mean = reduce(lambda a,b: a+b, image.convert("L").histogram())/256.0
        im = imtools.blend(
                image,
                Image.new("L", image.size, mean).convert(image.mode),
                -amount/100.0
        )
    else:
        #high contrast
        im = imtools.blend(
                image,
                image.point(lambda x: x > 128 and 255),
                amount/100.0
        )
    #fix image transparency mask
    if image.mode == 'RGBA':
        im.putalpha(image.split()[-1])
    return im

#---Phatch
class Action(models.Action):
    label       = _t('Contrast')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(contrast)
    version     = '0.1'
    tags        = [_t('color')]
    __doc__     = _t('Adjust from grey to black & white')

    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(50,-100,100)

    icon = \
'x\xda\x01*\t\xd5\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x08\xe1IDATh\x81\xedY]l\x14\xd7\x19=\xb33\xb33\xe3\
\xddY{\xfflc;\xac\xd78\xae\x81\xace\x8c\x91\x81T\x18\xecB\x04Vp\x1a\xa5\x0e\
\x11Q\x08\x06\x85\x08\xc9RP\x84\xa2Z\xa9\x9a\xbcT<\xb5U\x14\x89J\xa8M\xa3@\
\x14dG\xa9\xd4&"\xd4\x04\xbfD\xa2H\xb1V\xa6\xa8\xc4&\xeb\xd8,^/\xfb\xeb\xdd\
\xd9\x9f\xf9\xefCX\xc7\x98]2KJ_\xe2#\xdd\x87;s\xe7\xcc9\xfb}\xf7\xbb\xf7\xce\
\x02\xabX\xc5*V\xb1\x8a\x9f2\xc8\x87y\xe8\xc5\x17_\xdc\xde\xdf\xdf\xff;\x87\
\xc31s\xe3\xc6\x8d\x85\x87}\xb9\xcb\xe5\xdaYWW7\x1c\x8f\xc7\'\x01,>,O\xd9x\
\xfb\xed\xb7\xff\x96\xcdf\xf5\x93\'O\x9e\xfb1<\xfb\xf6\xed\xfb\xfc\xbd\xf7\
\xde\xd3\x01\xbc\xf3\xb0\x1c\xe5F\x80|\xf5\xd5WO\xaf]\xbbv\xff\xd4\xd4\x14SQ\
Q\xe1\x99\x9d\x9d}&\x12\x89|\x00@-\x83\xc7\xdc\xdf\xdf\x7f:\x9f\xcf\xef\x1d\
\x19\x19a\x9a\x9a\x9a\xbc\xa9T\xea)Y\x96\xcf\x96\xa9\xa7<\x0c\x0f\x0f\xbf\
\x13\x8b\xc5\xf4t:\xad\xa7R)=\x1e\x8f\xeb]]]\xfa\xe0\xe0\xe0\x95rx\x06\x07\
\x07\xff\xe2\xf7\xfb\xf5\xf1\xf1q\xfd\xcc\x993\xfak\xaf\xbd\xa6\xf3<\xaf;\
\x9d\xce\xbf\x97\xab\xc9dt`ww\xf7\x96\xe7\x9f\x7f~\x90eY\xd04\r\x8a\xa2\x10\
\x89D\xe0\xf3\xf9\xd0\xd9\xd9\xd9\xb1g\xcf\x9e.#<\x1d\x1d\x1d=/\xbc\xf0\xc2\
\xc1\x96\x96\x168\x9dNX,\x16,..\xc2\xe1p\xc0l6w\x03X\xfbH\x0cl\xde\xbcy\xc0\
\xe3\xf1XL&\x13h\x9a\x06I\x92\x18\x1d\x1d\xc5\x8e\x1d;\xd0\xdd\xddM\xb7\xb5\
\xb5\r\x18\xe1\xf1z\xbd\xbf\xe2y\xde\x1c\x8f\xc7!\x8a"\x14E\xc1\xd4\xd4\x14\
\x9cN\'\x08\x82\xe0\x01\xbc\xf4H\x0c\xb8\\\xae\xb5\x00\xa0\xeb:TU\x85\xa6i\
\xb8z\xf5*H\x92\x84\xdb\xedFuu\xb5\xc7\x08\x0fI\x92\x8d\xa1P\x08\xd3\xd3\xd3\
\x98\x9f\x9fG"\x91@0\x18\x04M\xd3\x90$\t\x00\x0c\xf1\x14@\x19\x1dH\x10\x04\
\xa1\xaa*\x14E\x81\xae\xeb\xd04\r\r\r\r\xb0X,\x00\x00M\xd3\x0c\xf1\xa4\xd3ib\
vv\x16\xd1h\x14\xb9\\\x0e\xa1P\x08$I"\x93\xc9@\x10\x04\xa0\xcc\xc2b\xd8@4\
\x1a\x9dSU\x15\x04A@U\xbf+8\'N\x9c\x00\xcf\xf3\x00\x80D"1g\x84gaa!\x18\x08\
\x04\xc0\xb2,DQD,\x16Cmm-\xe6\xe6\xe6\x90\xcf\xe7\x01\xe0\xd6#1p\xed\xda\xb5\
\x91`0x\xbc\xa1\xa1\x81+\\\xb3\xd9l\x00\x80`0\x98\xbfr\xe5\xca\'Fxfgg?w\xbb\
\xdd/[,\x16R\x96e$\x93I\x84\xc3a\x84\xc3a\x00H\x01\x18-\xc7@9`\x8f\x1f?\xfe\
\x8fP(\xa4\xdf\xb9sg\xa9\x85B!}hh\xe8c\x18\x9fO\xb4\xcb\xe5\x1a\xf7\xf9|zkk\
\xab^__\xaf\xd34\xad\x03\xd0\x01\x9c)W\x14a`\x8c\xf9\x95W^\xf9\xe3\xa6M\x9b\
\xf6vvv\xae\xf5\xfb\xfd\xa6\xea\xeaj455!\x10\x08 \x1c\x0e\xa3\xb1\xb1Q\x9c\
\x98\x98\xf8\xcf\xe4\xe4\xe4\x9f?\xfc\xf0\xc3w\x8b\x914773v\xbb\xfd\x0f<\xcf\
?\xc5\xb2\xac\xc7\xef\xf7\x93\xd1h\x14\x92$\xc1d2A\xd7u\xe8\xba\x9e\x060\t\
\xe0]\x00\x1f\xfdO\x0c\xec\xde\xbd\xfb\x97\xe7\xce\x9d\x1b\xb1\xd9l\xa4\xa6i\
\xd04\r\xb7o\xdf\xc6\xf4\xf44\x9a\x9a\x9aPSS\x03M\xd3\xa0\xeb:>\xfd\xf4\xd3o\
\x0f\x1f>\xfc8\x00e%\xcf\xb6m\xdb\x8e\x1d=z\xf4O\xe9t\x1a\x89D\x02\x89D\x02\
\x81@\x00\xb7n\xdd\x02EQ\xc8\xe5r\x88\xc7\xe3H&\x93\xc8\xe7\xf3\xff\x06\xe03\
b\xe0\x07g| \x10\xb8133\x93\xba}\xfbvE(\x14\xaa\xe2y\x9e\xb5\xdb\xedhll\x04\
\x00\x84B!\xed\xc2\x85\x0b\x8b\x17.\\\xb8|\xe9\xd2\xa5\xdf\xdc\xbcys\xba\x18\
O0\x18\xf4K\x92d\x92e\xd9BQT\x95\xd3\xe9\xa4\xddn7\xea\xeb\xeb\xc10\x0cL&\
\x93&\x8ab\x1a\xc0\x98\xaa\xaa\xbfU\x14e\xc6\x88\x01#)\xb4\x84\xe1\xe1\xe1\
\x8b\xbd\xbd\xbd\xbb\x93\xc9$\xb2\xd9,l6\x1b\x1c\x0e\x07\xc2\xe1p\xe6\xb9\
\xe7\x9e\xdb\x00\xc0P%\xda\xbau\xebU\x97\xcb\xb5%\x9b\xcd"\x97\xcbA\x14E\xe4\
\xf3y$\x93\xc9\xe8\xfc\xfc\xfc\x1a\x14\x89`)\x18\xaeB\x00\xc00L\xd2\xe7\xbb?\
\xb2\xb1X\x0c\x00D\xa3<\x1c\xc7%\xd6\xacY\x83L&\xb3\xd4\x04A@&\x93\x91Q\x86x\
\xa0\x8c\x95\x18\x00\xf2\xf9\xbcD\x92\xf7g\x1dM\xd3&\x94\x11M]\xd7sf\xb3\x19\
\xcb\x1b\xc30\xa0iZ\x03@\x97\xa3\xa9,\x03<\xcf\xbbI\x92\x04A\xdc\xab\xb5\xb5\
\xb5\x95\xdb\xb2eK\xb7Q\x1e\x8e\xe3\\+\r\xd04\r\x9e\xe7k9\x8e\xdbT\x8e\xa6r\
\x0c\x10n\xb7\xbb\x8e$I\xac\x8c\x02\xcf\xf3hnn\xee0\xc8CY\xad\xd6\xfa\xe5\
\xc2i\x9a\x86\xd9l\x86\xcdf#Y\x96\xed-C\x93q\x03===\xcf\xec\xdd\xbb\xb7\xb5`\
`\xa5\t\x9f\xcf\xd7\x03\x03i\xb4q\xe3\xc6\x97}>\x9fgy\xea0\x0c\xb3\x14\x89\
\xaa\xaa\xaa\x9d\x8f\xca\xc0`]]\x1dU\x10o2\x99\xeeI\xa5g\x9f}\xb6\xa3\xaf\
\xafo\xf0\x07h\x88\xf5\xeb\xd7\x1f\xb0Z\xadD\xb1\x08\x98\xcdf\xb8\xdd\xee\
\x9f\xdb\xed\xf6>\xa3\xba\x0c\xed\xfc\x0e\x1f>|\xe2\xcd7\xdf<\xceq\x9c\t@a\
\xd5\x04\xf0\xfd.\x94\xe38\x82e\xd9\r\xdf|\xf3\xcd\'\xe1p8U\x8c\xa7\xb7\xb7w\
\xf8\xe9\xa7\x9f>B\x10\x04QX\x14\x0b\xad\xb0E\'I\x92\x96$i}<\x1e?\x07@\xfa\
\xd1\x06\x06\x06\x06~\xf1\xc6\x1bo\xfc\xde\xe3\xf1\xf0\x00\x96/\xfb\xf74\x00\
hnnv(\x8a\xd2y\xed\xda\xb5\x91\xbb%q\t{\xf6\xecy\xa6\xbf\xbf\xffTUUU\xc5J\
\xe1\x05\xf1\x85>\xcb\xb2k\x14E\xd9\x90J\xa5F\xf1\xdd\x1e\xe9\xe1\x0c\xf4\
\xf5\xf5=144tv\xeb\xd6\xad\x8f-\xbfN\x10D\xd1(\x00@{{\xbb\'\x97\xcbm\xf8\xf2\
\xcb/\x97^\xde\xd5\xd5\xd5600\xf0\xc1\xbau\xebjW\xfe\xe2\xa5\xfa\x1c\xc7\xb5\
\x8a\xa2\xb8&\x93\xc9<\xf0\x9c\xfc \x03\xc4\xb1c\xc7\xce\x1d<x\xb0\xf3\xbe\
\x1bws\xbf``\xb9\x19\x82 \xb0y\xf3\xe6\xd6H$\xc2LNN\x8e\x01\xa0\x0e\x1d:4\
\xb2k\xd7\xae\'J\t_\x19\x81B\x9fa\x98\xf6L&\xb3(\x8a\xe2\xbf\xca6\xb0s\xe7\
\xce\x03\xa7N\x9d:\xc9q\\\xd1\xca\xf2\xa0(P\x14\x05\x86aZ\xc6\xc7\xc7\xcfn\
\xdf\xbe\xfd\xa5\xd7_\x7f\xfd\x18\x80\x92B\x8b\xb5\xbb\x87&\x93$I\x8f/..\x9e\
A\x89\x15\xba\xa4\x81\xf6\xf6\xf6\xbf*\x8aR\xdd\xd6\xd6f2\x99\xee/V\xc5\xa2P\
0\x91\xcf\xe7q\xf1\xe2EJ\x10\x84-\xf9|\xbe\xb7\xa2\xa2\xc2\xd1\xd2\xd2B\x18I\
\x9d\xe5\xc6\x14E\xc1\xdc\xdc\x9cU\x92\xa4\x9f\xe9\xba^\xf4\xa0Sr/\xd4\xde\
\xde\x1e<p\xe0@\xc7\xe9\xd3\xa7\x93\x9a\xa6q;v\xec`|>\x1f(\xea\xfbGH\x92\\z\
\xb1,\xcb\x18\x1d\x1d\x95\x03\x81@\xbc\xa1\xa1\x81:r\xe4\x88S\x10\x84\x1b\
\xe1pXRU\xb5\xe5\xad\xb7\xdeJ\xd6\xd6\xd6Z\x9e|\xf2I\xdan\xb7C\x92\xa4\xa5\
\xf2)\xcb2$IZ*\xab333\xca\xd7_\x7f\x1dK\xa5R\x94\xa6iN\x007J\xe9|\xe0f\xcej\
\xb5\x12CCCU\x00033\xa3\x9e?\x7f^L\xa7\xd3\x8a(\x8a\x84\xd9l\x06I\x92j.\x97\
\xd3(\x8aBee%\xb5\x7f\xff~\x1b\xcf\xf35\xb2,/E\x86$I\xa2\xa6\xa6\xc6\xd4\xd3\
\xd3S%\x08\x02._\xbe,\xcf\xcf\xcf\x8b\xf9|^\x93e\xd9$\x8a"r\xb9\x9c*\x8a\xa2\
\x9a\xc9d\xb4l6K)\x8aR)\x08B\x8d\x91\x0f\x05%\r\xb0,\x9bY\xde\xf7z\xbd\xa4\
\xd7\xeb\xad(6\xb6\x10nY\x96\xa1(\xdf\xa7\xaa \x082\x00\x95eY(\x8a\x02UU\xd1\
\xd8\xd8H\xbb\\.:\x9dNC\x10\x84{\x1a\xcb\xb2`\x18\x06\xe9t\x1a\x8a\xa2 \x93Y\
\x92Pr\xc1-9\x07\x1c\x0eG\xc2\xe9t\xee\xf4z\xbdU\xa5\xc6\x14P\xc8\xff\xe5y\
\xfc\xd9g\x9f]\x1f\x1b\x1b\x1b\x96$i\xde\xe5r\xed\xb2\xdb\xed\x15+\'\xea\xca\
\xe7\x8a\xddS\x14e\x12\xc0\xaf\x01$\xca2p\xfd\xfa\xf5o\'&&>\x9e\x9a\x9a"\x03\
\x81\x80\x1a\x8b\xc5\xb8\x9a\x9a\x9a\n\x86a\x8a\x1a\x88F\xa3\x18\x1b\x1b\x0b\
}\xf1\xc5\x17\x13g\xcf\x9e=\xff\xfe\xfb\xef\x0f\xfa\xfd\xfe\xb9\xe9\xe9\xe9\
\xeb\x91H\xe4\xf3\x85\x85\x05&\x16\x8b\x11\xb2,[\xadV\xab\x19@Q\xe1w\x7f\xf9\
\x88(\x8a~I\x92\xce\xab\xaa:\x08\xa0\xe4\'\xfcrNd\x95\xdb\xb6m\xebs\xbb\xdd\
\r\x95\x95\x95\x16\x9b\xcdf\xd5u]O\xa5RB2\x99\xcc\x84B\xa1\xe9\xaf\xbe\xfa\
\xea\x9f\x002\x0f"\xe18\xee1\x8f\xc7\xb3\x8fa\x98j\x8a\xa2,\xba\xae[$I\xd2\
\xb2\xd9l&\x97\xcb\xa5\xd3\xe9\xf4MA\x10.\xe2\xff\xf9\x7f\xc1*V\xb1\x8aU\xfc\
t\xf1_9-\xf7(\xaaR5O\x00\x00\x00\x00IEND\xaeB`\x82Q6z\x97'
