# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

#---import modules

# gui-indepedent
if __name__ == '__main__':
    import sys
    sys.path.insert(0,'../../core/lib')
    
import formField

# gui-dependent
import wx
import graphics, popup, treeDragDrop
                            
if __name__ == '__main__':
    sys.path.insert(0,'../..')
    
from unicoding import exception_to_unicode

FIELD_DELIMITER = ': '
WX_ENCODING     = wx.GetDefaultPyEncoding()

try:
    from core.pil import create_test_info
    IMAGE_TEST_INFO = create_test_info()
except ImportError:
    IMAGE_TEST_INFO = {'size': (1, 1), 'format': None, 'height': 1, 'width': 1, 
        'mode': 'L', 'folder': '/test', 'filename': 'unknown', 'type': 'png', 
        'dpi': 72, 'location': '/test/unknown.png'}
        #generated from pil.create_test_info()

#---functions

#---tree
ITEM_HEIGHT = 28
ICON_SIZE   = (ITEM_HEIGHT,ITEM_HEIGHT)
TR_DEFAULT_STYLE   = wx.TR_HAS_BUTTONS|wx.TR_NO_LINES|wx.TR_FULL_ROW_HIGHLIGHT|wx.TR_HIDE_ROOT|wx.TR_DEFAULT_STYLE|wx.SUNKEN_BORDER

def _do_nothing(*args,**keyw):
    pass

def rescale(image,x,y,filter=None):
    """For compatibility with wxPython 2.6"""
    if filter is None and hasattr(wx,'IMAGE_QUALITY_HIGH'):
        filter  = wx.IMAGE_QUALITY_HIGH
    if filter is None:
        image.Rescale(x,y)
    else:
        image.Rescale(x,y,filter)

class TreeMixin(treeDragDrop.Mixin):
    def __init__(self,form_factory={},CtrlMixin=[],
        icon_size=(28,28),show_error=_do_nothing,set_dirty=_do_nothing):
        if wx.Platform == "__WXGTK__":
            #indentation
            self.SetIndent(int(self.GetIndent()*1.5))
##        elif wx.Platform == "__WXMSW__":#doesn't work
##            self.SetIndent(int(self.GetIndent()/2))
        #form factory
        self.form_factory       = form_factory 
        self.CtrlMixin          = CtrlMixin
        #popup
        self.popup              = None
        self.popup_item         = None
        self._field_selected    = False
        #methods
        self.show_error         = show_error
        self.set_dirty          = set_dirty
        #image list
        self.CreateImageList(icon_size)
        #drag & drop
        self.EnableDrag(dragTo=self.get_form_item)
        #clear
        self.delete_all_forms()
        #events
        self.events()
        
    def CreateImageList(self,icon_size):
        self.image_list = wx.ImageList(*icon_size)
        icon_disabled   = graphics.bitmap(ICON_DISABLED)
        for form in self.form_factory.values():
            self._AddFormToImageList(form,icon_size,icon_disabled)
        self.SetImageList(self.image_list)
        
    def _AddFormToImageList(self,form,icon_size,icon_disabled):
        image             = graphics.image(form.icon,icon_size)
        form.icon_bitmap  = wx.BitmapFromImage(image)
        rescale(image,icon_size[0],icon_size[1])
        form.icon_tree    = wx.BitmapFromImage(image)
        form.icon_tree_disabled   = icon_disabled
        form.icon_tree_id         = (
            self.image_list.Add(form.icon_tree_disabled),
            self.image_list.Add(form.icon_tree))
            
    def set_item_image(self,x,image):
        self.SetItemImage(x,image,wx.TreeItemIcon_Normal)
        
    def treeLabel(self,name,value):
        return ''.join([_(name),FIELD_DELIMITER,
            self.CtrlMixin._to_local(value)]) 
            
    def delete_all_forms(self):
        self.DeleteAllItems()
        self.AddRoot('')
        
    #---forms
    def append_form(self, form, item=-1):
        root    = self.GetRootItem()
        if item is -1:
            item    = self.AppendItem(root,_(form.label))
        else:
            item    = self.InsertItem(root,item,_(form.label))
        self.set_item_image(item,form.icon_tree_id[True])
        self.SetItemBold(item,True)
        self.import_form(item,form)
        self.SelectItem(item)
        return item
        
    def append_forms(self,forms):
        for form in forms:
            self.append_form(form)
        return forms
        
    def append_form_by_label(self,item,label):
        return self.append_form(self.form_factory[label](),item)
        
    def collapse_forms(self):
        root    = self.GetRootItem()
        for child in self.GetItemChildren(root):
            self.Collapse(child)
        
    def enable_form(self,item, bool):
        self.enable_form_item(self.get_form_item(item),bool)
        
    def enable_form_item(self,item,bool):
        form              = self.GetPyData(item)
        self.set_item_image(item,form.icon_tree_id[bool])
        self.SetItemTextColour(item,(wx.RED,wx.GREEN)[bool])
        
    def expand_forms(self):
        root    = self.GetRootItem()
        for child in self.GetItemChildren(root):
            self.Expand(child)
                      
    def export_form(self,item,label=None):
        form              = self.GetPyData(item)
        for field in self.GetItemChildren(item):
            label, value_as_string  = self.GetPyData(field)
            form.set_field_as_string(label,value_as_string)
        form.set_field('__enabled__',self.is_form_enabled(item))
        return form

    def export_forms(self):
        root    = self.GetRootItem()
        forms = []
        for child in self.GetItemChildren(root):
            forms.append(self.export_form(child))
        return forms

    def import_form(self,item,form):
        self.SetPyData(item,form)
        self.DeleteChildren(item)
        fields = form._get_fields()
        for label, field in fields.items():
            if field.visible:
                value_as_string = field.get_as_string()
                oItem           = self.AppendItem(item,
                    self.treeLabel(label,value_as_string))
                self.SetPyData(oItem,(label,value_as_string))
            elif label == '__enabled__':
                self.enable_form_item(item,field.get())
        self.Expand(item)
        
    def get_form(self,item,label=None):
        return self.export_form(self.get_form_item(item),label)
    
    def get_form_item(self,item):
        return self.GetRootChild(item)
    
    def get_form_field(self,item):
        label, value_as_string  = self.GetPyData(item)
        return self.get_form(item,label)._get_field(label)
    
    def has_forms(self):
        return self.GetCount()
    
    def toggle_form_item(self,item):
        root        = self.GetRootItem()
        if item == root:
            event.Skip()
        else:
            parent  = self.GetItemParent(item)
            if parent == root:
                image   =  self.GetItemImage(item,wx.TreeItemIcon_Normal)
                if image != -1:
                    self.enable_form_item(item,
                        not self.is_form_enabled(item))
                    
    def set_form_field_value(self,item, value_as_string):
        label, old  = self.GetPyData(item)
        if value_as_string.strip() and value_as_string != old:
            form      = self.get_form(item,label)
            field       = form._get_field(label)
            #test-validate the user input (see formField.Field.get)
            try:
                if isinstance(field,formField.FileSizeField):
                    field.get_size(IMAGE_TEST_INFO, 100, label,
                        value_as_string)
                    #100 is just some dummy value for base
                elif isinstance(field,formField.PixelField):
                    field.get_size(IMAGE_TEST_INFO, 100, 100,label,
                        value_as_string)
                    #100 is just some dummy value for base, dpi
                else:
                    field.get(IMAGE_TEST_INFO, label=label,
                        value_as_string=value_as_string, test=True)
                self.set_dirty(True)
            except formField.ValidationError, details:
                reason  = exception_to_unicode(details,WX_ENCODING)
                self.show_error(reason)
                value_as_string   = old
            self.SetPyData(item,(label,value_as_string))
            self.SetItemText(item,self.treeLabel(label,value_as_string))

    #---selected form
    def append_form_by_label_to_selected(self,label):
        item    = self.get_selected_form() 
        return self.append_form_by_label(item,label)

    def enable_selected_form(self, bool):
        self.enable_form_item(self.get_selected_form(),bool)
        
    def get_selected_form(self):
        if self.has_forms():
            return self.get_form_item(self.GetSelection())
        return -1
    
    def move_selected_form_down(self):
        self.MoveChildDown(self.get_selected_form())
        
    def move_selected_form_up(self):
        self.MoveChildUp(self.get_selected_form())
        
    def remove_selected_form(self):
        form  = self.get_selected_form()
        if form is -1:
            return False
        else:
            self.Delete(form)
            return True
        
    #---last form
    def append_form_by_label_to_last(self,label):
        item    = self.get_last_form()
        self.append_form_by_label(item,label)

    def get_last_form(self):
        return self.GetLastChild(self.GetRootItem())
            
    #---popup
    def create_popup(self,item):
        """Connect formField.field to popup.Ctrl (VIP!)"""
        field               = self.get_form_field(item)
        label, value        = self.GetItemText(item).split(FIELD_DELIMITER)
        pos, offset, size   = self.get_popup_pos_offset_size(item)
        typ                 = field.__class__.__name__.replace('Field','')
        if isinstance(field,formField.SliderField):
            extra   = {'minValue' : field.min,'maxValue' : field.max}
        elif isinstance(field,formField.ChoiceField):
            extra   = {'choices' : field.choices}
            typ     = 'Choice'
        elif isinstance(field,formField.DictionaryReadFileField):
            if field.dictionary is None:
                field.init_dictionary()
            extra   = {'extensions' : field.extensions,
                        'dictionary': field.dictionary}
            if not isinstance(field,formField.FontFileField):
                typ = 'DictionaryFile'
        elif isinstance(field,formField.FileField):
            extra   = {'extensions' : field.extensions}
            typ     = 'LabelFile'
        elif hasattr(field,'choices'):
            extra   = {'choices' : field.choices}
        else:
            extra   = {}
        self.popup          = popup.EditPanel(self, pos = pos, offset = offset,
                                size = size, label = _(label)+FIELD_DELIMITER, 
                                value = value, extra = extra, typ = typ,
                                border = 1, CtrlMixin   = self.CtrlMixin)
        self.popup_item     = item
        self.popup.Show()
        self.resize_popup() 
        
    def create_popup_selected(self):
        item    = self.GetSelection()
        if self.GetItemParent(item) == self.GetRootItem():
            return
        self.create_popup(item)
        
    def close_popup(self):
        if self.popup:
            value_as_string = self.popup.Close()
            self.set_form_field_value(self.popup_item, value_as_string)
        self.popup  = self.popup_item = None
            
##    This would be logical but only works in wxPython2.6
##    def get_popup_pos_offset_size(self, item):
##        text_only_rect  = self.GetBoundingRect(item,textOnly=True)
##        rect            = self.GetBoundingRect(item,textOnly=False)
##        pos             = rect.GetPosition()
##        size            = rect.GetSize()
##        offset          = text_only_rect.GetPosition()[0] - pos[0]
##        print self.GetClientSize(),self.GetSize(),self.GetRect(),text_only_rect,rect
##        return pos, offset, size
##        

    #A bit unlogical but works both in wxPython2.6 and 2.8
    def get_popup_pos_offset_size(self, item):
        text_only_rect  = self.GetBoundingRect(item,textOnly=True)
        rect            = self.GetRect()
        pos             = rect[0],text_only_rect[1]
        offset          = text_only_rect[0]-rect[0]
        size            = self.GetClientSize()[0],text_only_rect.GetSize()[1]
        return pos, offset, size
        
    def resize_popup(self):
        if not(self.popup is None):
            item                = self.GetSelection()
            pos, offset, size   = self.get_popup_pos_offset_size(item)
            popup               = self.popup
            popup.Freeze()
            popup.SetSize(size)
            popup.SetPosition(pos)
            popup.Layout()
            popup.Thaw()
        
    #---events
    def events(self):
        #events
        self.Bind(wx.EVT_TREE_SEL_CHANGING, self.on_sel_changing, self)
        self.Bind(wx.EVT_TREE_SEL_CHANGED, self.on_sel_changed, self)
        self.Bind(wx.EVT_TREE_ITEM_ACTIVATED, self.on_item_activated, self)
        self.Bind(wx.EVT_TREE_ITEM_RIGHT_CLICK,self.on_select,self)
        self.Bind(wx.EVT_LEFT_DOWN,self.on_left_down,self)
        
    def on_left_down(self,event):
        self.close_popup()
        event.Skip()

    def on_item_activated(self,event):
        item        = event.GetItem()
        if self.is_form(item):
            self.toggle_form_item(item)
        else:
            self.on_sel_changed(event)
        
    def on_sel_changing(self,event):
        self.close_popup()
        
    def on_sel_changed(self,event):
        self.close_popup()
        item                    = event.GetItem()
        self._field_selected    = self.is_field(item)
        if self._field_selected:
            self.create_popup(item)
        
    def on_select(self,event):
        self.on_sel_changing(event)
        self.SelectItem(event.GetItem(),True)
        event.Skip()
        
    #---checks
    def is_field(self,item):
        return self.GetItemParent(item)!= self.GetRootItem() and \
                item != self.GetRootItem()
    
    def is_field_selected(self):
        return self._field_selected
        
    def is_form(self,item):
        return self.GetItemParent(item)== self.GetRootItem()
        
    def is_form_enabled(self,item): 
        form              = self.GetPyData(item)
        return self.GetItemImage(item,wx.TreeItemIcon_Normal)==form.icon_tree_id[True]
        
    def is_form_selected(self):
        return not self._field_selected
        
def test():
    global _
    _ = str
    import sys
    
    class Form1(formField.Form):
        label   = 'form1'
        def __init__(self):
            formField.Form.__init__(self,
                foo1=formField.ChoiceField(value='a',choices=('a','b')))
    
    class Form2(formField.Form):
        label   = 'form2'
        def __init__(self):
            formField.Form.__init__(self,
                foo2=formField.PixelField(value='100'))
    
    class Form3(formField.Form):
        label   = 'form3'
        def __init__(self):
            formField.Form.__init__(self,
                foo2=formField.FileSizeField(value='100'))
    
    form_factory    = {
        'form1' : Form1,
        'form2' : Form2,
        'form3' : Form3,
    }
    form4   = formField.Form(foo3=formField.SliderField(value='100',
                    minValue=0,maxValue=100))
    forms   = [x() for x in form_factory.values()] #+ [form4]
    
    class Tree(wx.TreeCtrl,TreeMixin):
        
        def __init__(self,parent,form_factory,*args,**keyw):
            
            class I18n_CtrlMixin:
                """Fake example of a Mixin"""
                _to_local   = str
                _to_english = str
                _to_local   = staticmethod(_to_local)
                _to_english = staticmethod(_to_english)
                
            wx.TreeCtrl.__init__(self,parent,style=TR_DEFAULT_STYLE,*args,**keyw)
            TreeMixin.__init__(self,
                form_factory= form_factory,
                CtrlMixin   = I18n_CtrlMixin,
                icon_size   = (28,28),
                show_error  = parent.show_error,
                set_dirty   = parent.set_dirty,
            )
            
    class Frame(wx.Frame):
        def show_error(self,message):
            sys.stdout.write(message+'\n')
            
        def set_dirty(self,bool):
            self.SetTitle(['','*'][bool]+'treeEdit test')
            
    class App(wx.App):
        def OnInit(self,*args,**keyw):
            frame       = Frame(None)
            frame.set_dirty(False)
            
            sizer       = wx.BoxSizer(wx.VERTICAL)
            self.tree   = Tree(frame,form_factory)
            self.tree.append_forms(forms)
            sizer.Add(self.tree,proportion=1, flag=wx.EXPAND)
            frame.SetSizer(sizer)
            sizer.Fit(frame)
            
            frame.SetSize((300,300))
            frame.Layout()
            frame.Show()
            self.SetTopWindow(frame)
            return True
        
        
    app = App(0)
    app.MainLoop()
        
#---disabled
ICON_DISABLED = \
'x\xda\x015\x02\xca\xfd\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x1c\
\x00\x00\x00\x1c\x08\x06\x00\x00\x00r\r\xdf\x94\x00\x00\x00\x04sBIT\x08\x08\
\x08\x08|\x08d\x88\x00\x00\x01\xecIDATH\x89\xb5\xd6\xbdk\x14A\x18\x06\xf0\
\x9f\xf1\x14\xbd\x04\xd4\xc2\x8f\xc2\xafx \xa8\xa4\x08\xa8\x85\xa2\x96\x166\
\n\x96\x16\xfa/\x88\x88\x88\x8d\x9d\x16Z\xf8\x17\x88E\n[k\x11QD\xb0Q\x84+$\
\x01Ma@1\xf1\xe3\x08\xf1b\x12\x8b\xd9\xe5\xe66\xd9\xdc\xee\x1d\xfb\xc0\xcb\
\xee\xbc\xf3\xf1\xcc\xbc\xf3\xcc;\xc3`8\x8fW\xf8\x8a\x1b\xd8<\xe0x\xebb\x14M\
\xac$\xf6\x16\xbb{u\x1a\x1a\x80\xf04\x1aQy\x01\xed*\tO\xea\x0ea\x0b\xf3U\x12\
\x9e\xc9\x94gU\xb8\xc2:\x8ef|S\xc2^VBx\xd0jE~*\xd2\xb1_\xc2\xc3k\xf8\x9aU\
\x1262\xe5\x96p\x16+!\x1c\x12B\x1ac\x1a\x7f\xab"\xdc\x8a}\x19\xdf\x17,\x16\
\xe9\\\x8b\xfe\x0f\xe1"\xc60\x89g\xf8h\xb5\xf2\x86\xb17\xe3\x9b.J\x98\xa2\
\x817XN\x08\x96\x92A\xeeb?6DmG\x85\xfdJS\xda2\xeed\xda\xf4\xc4\t\xfc\x8a\x06\
\x89\xed=\xae\xe8\x84\xff\x14\xfeE\xf5m\\+C\x06\xdb\xf0$\x870]\xc5;\\\xc6\
\x83L\xdd<.\x94%\x84=x,\x7f\xa5+\xf8\x93X\xeck\t\x89\xbc/l\xc1%\xbc\x16d\x9e\
G\x1c\xdbo\x1c\xef\x970E\x1dW\x05\xb5\xa6B\xca\xb36n\xeaV|.6\xe6\xf8\x17\xf1\
\x01O\x85\x10\x1e\xc0\x8eu\xc68\x9b\xd8\xf6d\x12\xb3\x82\xb0\xfaB\rGp_8*\xb1\
B\xb3\xb6\x84\x19<\xc7-\x8c\x0b\xd1\xea\x1bc\xba\x9f\x15\xbd\xec\x07n\xe3\
\x1c6Q>\xb5\xcd\x08O\x89\x18\x0b\xc2]\xd8\xc4\x9c\x8e\x9a\xa7\x84\xd5\x8d\
\x0b\xa9o\x88\x82\x1b\x1daD\xc8\xa5)\xbe\xe3:^\n\xe1\xaccW\xf2\x9d\x14T?\x87\
o\n\\\xcek\xe1\x18>\xeb\x84\xeca\xd9I\x97\r\xe9\x880kB\x86\x99PR\x8de\t\x87u\
B\xfaB\xc1g\xc5 \x845\xe1V\xf8\x89GB\x96)\x85\xbc\x83\x9f\x87\x9d\t\xc9=\xe1\
\xac\x95\xc6\x7f\xe8\x04\xa1\xc9:\x81R\xb6\x00\x00\x00\x00IEND\xaeB`\x82U\
\x9b\xf8k'

if __name__ == '__main__':
    test()