<?php
/*
 * Phamm - http://www.phamm.org - <team AT phamm DOT org>
 * Copyright (C) 2004,2008 Alessandro De Zorzi and Mirko Grava
 * Project sponsored by RHX Studio Associato - www.rhx.it
 *  
 * Phamm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Phamm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
* The main Phamm config file
*
* @package Phamm
* @subpackage configuration
* @author Alessandro De Zorzi <adezorzi AT rhx DOT it>
**/

// *============================*
// *=== LDAP Server Settings ===*
// *============================*

// The server address (IP or FQDN)
define ('LDAP_HOST_NAME','127.0.0.1');

// The protocol version [2,3]
define ('LDAP_PROTOCOL_VERSION','3');

// The server port
define ('LDAP_PORT','389');

// The container
define ('SUFFIX','dc=example,dc=tld');

// The admin bind dn (could be rootdn)
define ('BINDDN','cn=admin,dc=example,dc=tld');

// The Phamm container
define ('LDAP_BASE','o=hosting,dc=example,dc=tld');

// *============================*
// *===    Phamm Settings    ===*
// *============================*

// Phamm Version (+ indicate a CVS version)
define ('VERSION','0.5.12');

// Useful if you want hide the version [0,1]
define ('HIDE_VERSION',0);

// Phamm access control Settings [0,1]
define ('NOLOGIN',0);

// Only needed if you set NOLOGIN 1 [0,1]
// define ('SECRET','secret');

// Useful if you wish force SSL through PHP [0,1]
define ('FORCE_SSL',0);

// Min password length
define ('PASSWORD_MIN_LENGHT',3);

// Random password length
define ('PASSWORD_RND_LENGHT',6);

// Seconds after refresh page
define ('REFRESH_TIME',1);

// Funny host color [0,1]
define ('FUNNY_COLOR',0);

// A way to choose languages [select, links, none]
define ('LANG_MENU','select');

// Performance setting
// none suggest domains and/or accounts > 1000 [all, none]
define ('DEFAULT_VIEW','all');

// A Domain administrator (example: postmaster)
define ('PHAMM_DOMAIN_ADMIN_NAME','postmaster');

// Welcome message
define ('SEND_WELCOME',0);
$welcome_msg = '../welcome_message.txt';
$welcome_subject = 'Welcome!';
$welcome_sender = 'root@localhost';
$welcome_bcc = 'root@localhost';

//
$group_actions_accounts[] = 'account;delete;TRUE';
$group_actions_accounts[] = 'account;delete;FALSE';
$group_actions_accounts[] = 'account;amavisBypassVirusChecks;TRUE';
$group_actions_accounts[] = 'account;amavisBypassVirusChecks;FALSE';
$group_actions_accounts[] = 'account;amavisBypassSpamChecks;TRUE';
$group_actions_accounts[] = 'account;amavisBypassSpamChecks;FALSE';
$group_actions_accounts[] = 'account;accountActive;TRUE';
$group_actions_accounts[] = 'account;accountActive;FALSE';
$group_actions_accounts[] = 'account;smtpAuth;TRUE';
$group_actions_accounts[] = 'account;smtpAuth;FALSE';

$group_actions_domains[] = 'domain;accountActive;TRUE';
$group_actions_domains[] = 'domain;accountActive;FALSE';
$group_actions_domains[] = 'domain;delete;TRUE';
$group_actions_domains[] = 'domain;delete;FALSE';
$group_actions_domains[] = 'postmaster;editAccounts;TRUE';
$group_actions_domains[] = 'postmaster;editAccounts;FALSE';


// *============================*
// *===   Layout Settings    ===*
// *============================*

// Page title
define('ORG_TITLE','Phamm');

// URL
define('ORG_URL','http://www.phamm.org');

// Logo
define('ORG_LOGO', './img/phamm_100.png');

// Style (user can change it)
$style			= 'phamm';

// Table colum widht for values (in pixel)
define ('TDW',200);

// Table colum widht for bolean values (in pixel)
define ('TDWB',100);

// Default language (user can change it)
$language		= 'en_GB';

// The languages will be displayed
$supported_languages = array();
$supported_languages["pt_BR"] = "Brasileiro";
$supported_languages["de_DE"] = "Deutsch";
$supported_languages["en_GB"] = "English";
$supported_languages["fr_FR"] = "Francais";
$supported_languages["id_ID"] = "Indonesian";
$supported_languages["it_IT"] = "Italiano";
$supported_languages["hu_HU"] = "Magyar";
$supported_languages["ru_RU"] = "Russian";
$supported_languages["es_ES"] = "Espanol";
// $supported_languages["ll_CC"] = "Your language here";


// *============================*
// *===   Plugins Settings   ===*
// *============================*

// The default plugin
define ('DEFAULT_PLUGIN','mail');

// This array contains the active plugins
// NOTE the display order reflect this order
$plugins = array();
$plugins[] = "mail";
$plugins[] = "alias";
//$plugins[] = "dns";
//$plugins[] = "ftp";
//$plugins[] = "proxy";
//$plugins[] = "radius";
//$plugins[] = "radius_stats";
//$plugins[] = "rates";
//$plugins[] = "person";

// Account can be mail OR alias
$plugins_exclusion = array("mail","alias");

// This array contains the TLDs (filter option)
$tld = array();
$tld[] = ".com";
$tld[] = ".org";
$tld[] = ".net";
// $tld[] = ".biz";
// $tld[] = ".info";
// $tld[] = ".eu";
// $tld[] = ".it";
// $tld[] = ".ie";
// $tld[] = ".fr";
// $tld[] = ".de";


// *============================*
// *===  Advanced Settings   ===*
// *============================*

// Debug level [0,1]
define ('DEBUG',0);

// PHP Error Level [0,1,2,10]
define ('ERROR_LEVEL',2);

// Only for advanced users
define ('ADVANCED_VIEW',0);

// Log level 0->don't log [0,1,2]
define ('PHAMM_LOG',0);

// Log file path
define ('LOG_FILE','/var/log/phamm.log');

// Standard LDAP encryption type [CRYPT,MD5,CLEAR]
define ('ENC_TYPE','CRYPT');

// Unused
// define ('CUSTOM_SESSION_PATH','/tmp');

// Permit login without @domain (use it with carefull)
// define ('DEFAULT_DOMAIN','example.tld');

// *===========================*
// *===  Plugins Settings   ===* // @todo in each plugin
// *===========================*

define ('VDHOME','/home/vmail/domains');

/*
Predefined Constants
set with ldap_set_option($connect,COSTANT,ARG);

LDAP_DEREF_NEVER
LDAP_DEREF_SEARCHING
LDAP_DEREF_FINDING
LDAP_DEREF_ALWAYS
LDAP_OPT_DEREF
LDAP_OPT_SIZELIMIT
LDAP_OPT_TIMELIMIT
LDAP_OPT_PROTOCOL_VERSION
LDAP_OPT_ERROR_NUMBER
LDAP_OPT_REFERRALS
LDAP_OPT_RESTART
LDAP_OPT_HOST_NAME
LDAP_OPT_ERROR_STRING
LDAP_OPT_MATCHED_DN
LDAP_OPT_SERVER_CONTROLS
LDAP_OPT_CLIENT_CONTROLS
LDAP_OPT_DEBUG_LEVEL
GSLC_SSL_NO_AUTH
GSLC_SSL_ONEWAY_AUTH
GSLC_SSL_TWOWAY_AUTH
*/

?>
