<?php

/*
 * Copyright (c) 2008 Guillaume Lelarge <guillaume@lelarge.info>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

$query = "SHOW server_version";

$rows = pg_query($connection, $query);
if (!$rows) {
  echo "An error occured.\n";
  exit;
}

if ($row = pg_fetch_array($rows)) {
  $version = $row['server_version'];
}

$buffer = '
<div id="pgContentWrap">

<h1>PGSnap (PostgreSQL Snapshot) '.$VERSION.'</h1>
<p>
These pages are dynamically generated by the pgsnap.php script.
They represent a snapshot of the target database at the time the script was executed.
</p>

<div class="tblBasic">

<table border="0" cellpadding="0" cellspacing="0" class="tblBasicGrey">

<tr><td>Report created on</td><td>'.date('r').'</td></tr>
<tr><td>Host, and port</td><td>'.$PGHOST.':'.$PGPORT.'</td></tr>
<tr><td>User</td><td>'.$PGUSER.'</td></tr>
<tr><td>Database</td><td>'.$PGDATABASE.'</td></tr>
<tr><td>PostgreSQL Release</td><td>'.$version.'</td></tr>
</table>

</div>

<p>
<a href="http://www.postgresql.org" target="_blank">PostgreSQL Official Website</a>
-
<a href="http://www.postgresql.org/docs" target="_blank">PostgreSQL Official Manuals</a>
</p>

</div>';

$filename = $outputdir.'/index.html';
include 'lib/fileoperations.php';

?>
