/*
# PostgreSQL Database Modeler (pgModeler)
#
# Copyright 2006-2020 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful),
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also), you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

/**
\ingroup libparsers
\namespace Attributes
\brief Definition of parsers attributes namespace which stores a series of static strings constants used
 to reference the attributes of objects in SQL/XML generation methods.
 Each string stores the name of the attribute used in the schema file "sch" of the respective objects.
\note <strong>Creation date:</strong> 23/09/2008
*/

#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

/* Including QByteArray due to 'QByteArray has no toStdString()'
   error on Qt 5.4 (Windows only) */
#include <QByteArray>
#include <QString>

namespace Attributes {
	extern const QString
	Action,
	ActiveLayers,
	AdminOption,
	AdminRoles,
	Alias,
	Alignment,
	AlignObjsToGrid,
	AllowConns,
	AlterCmds,
	AnalyzeFunc,
	AncestorTable,
	AppendAtEod,
	AppendedSql,
	Application,
	ApplyOnServer,
	ArgCount,
	ArgDefaults,
	ArgDefCount,
	ArgModes,
	ArgNames,
	ArgTypes,
	Arguments,
	AscOrder,
	Assignment,
	AttribsPage,
	AttribsPerPage,
	Attribute,
	AutoBrowseDb,
	AutoSaveInterval,
	BackgroundColor,
	BaseType,
	Before,
	BehaviorType,
	Bold,
	BorderColor,
	Bottom,
	Buffering,
	BypassRls,
	ByValue,
	Cache,
	CanonicalFunc,
	CanvasCornerMove,
	Cascade,
	CaseSensitive,
	CastType,
	Category,
	Change,
	Changelog,
	CheckExp,
	CheckUpdate,
	CkConstr,
	ClientEncoding,
	CodeCompletion,
	CodeFont,
	CodeFontSize,
	CodeTabWidth,
	ColIndexes,
	ColIsIdentity,
	CollapseMode,
	Collatable,
	Collation,
	Collations,
	Color,
	Colors,
	ColsComment,
	Column,
	ColumnAlias,
	Columns,
	Command,
	Commands,
	Comment,
	CommutatorOp,
	CompactView,
	CompareToDatabase,
	ComparisonType,
	CompletionTrigger,
	CompositeType,
	Concurrent,
	Condition,
	ConfigFile,
	Configuration,
	ConfirmValidation,
	ConnectCenterPnts,
	ConnectFkToPk,
	Connection,
	Connections,
	ConnectionTimeout,
	ConnectPriv,
	ConnectTableEdges,
	ConnLimit,
	Constraint,
	Constraints,
	ConstrDefs,
	ConstrIndexes,
	ConstrSqlDisabled,
	Contents,
	CopyMode,
	CopyOptions,
	CopyTable,
	Create,
	CreateCmds,
	CreateDb,
	CreatePriv,
	CreateRole,
	CrowsFoot,
	CteExpression,
	CurIdentityType,
	CurrentModel,
	CurrentModel,
	CurVersion,
	CustomColor,
	CustomFilter,
	CustomIdxs,
	Cycle,
	Database,
	DataDirectory,
	Date,
	DbModel,
	DdlEndToken,
	DeadRowsAmount,
	Declaration,
	DeclInTable,
	Default,
	DefaultCollation,
	DefaultForOps,
	DefaultOwner,
	DefaultSchema,
	DefaultTablespace,
	DefaultValue,
	Deferrable,
	DeferType,
	Definition,
	DelAction,
	DeletePriv,
	DelEvent,
	Delimiter,
	DestType,
	Diff,
	Dimension,
	Directory,
	DisableSmoothness,
	DisplayLineNumbers,
	DockWidgets,
	DomConstraint,
	DontDropMissingObjs,
	Drop,
	DropCmds,
	DropMissingColsConstrs,
	DropTruncCascade,
	DstColPattern,
	DstColumns,
	DstEncoding,
	DstFkPattern,
	DstLabel,
	DstRequired,
	DstTable,
	DstType,
	DynamicLibraryPath,
	DynamicSharedMemory,
	Element,
	Elements,
	EmptyPassword,
	Encoding,
	Encrypted,
	EndExp,
	Enumerations,
	EnumType,
	Entry,
	EscapeComment,
	Event,
	Events,
	EventType,
	ExactMatch,
	ExcBuiltinArrays,
	ExcludeElement,
	ExConstr,
	ExecType,
	ExecutionCost,
	ExecutPriv,
	ExistingValue,
	Explicit,
	Export,
	ExportToFile,
	Expression,
	Expressions,
	ExtAttribsPage,
	ExtAttribsPerPage,
	ExtObjOids,
	ExtraCondition,
	Factor,
	FadedOut,
	FadeInObjects,
	False,
	Family,
	FastUpdate,
	Fdw,
	File,
	FileAssociated,
	FillColor,
	Filter,
	FilterOids,
	FilterTableTypes,
	FinalFunc,
	FiringType,
	FkColumn,
	FkConstr,
	FkDefs,
	Font,
	FontSize,
	ForceObjsRecreation,
	ForegroundColor,
	ForeignKeys,
	ForeignTableBody,
	ForeignTableExtBody,
	ForeignTableName,
	ForeignTableSchemaName,
	ForeignTableTitle,
	FormatName,
	FromExp,
	Function,
	FunctionType,
	GenAlterCmds,
	General,
	Generated,
	Global,
	GrantOp,
	GridSize,
	Group,
	HandlerFunc,
	HandlesType,
	HasChanges,
	Hashes,
	HbaFile,
	Height,
	HideExtAttribs,
	HideRelName,
	HideTableTags,
	HighlightLines,
	HighlightOrder,
	HistoryMaxLength,
	Icon,
	Id,
	IdentFile,
	Identifier,
	IdentityType,
	IgnoredChars,
	IgnoreDuplicErrors,
	IgnoreErrorCodes,
	IgnoreImportErrors,
	Implicit,
	Import,
	ImportExtObjs,
	ImportSysObjs,
	Increment,
	Index,
	IndexElement,
	Indexes,
	IndexType,
	Info,
	InhColumn,
	InhColumns,
	Inherit,
	Inherited,
	InitialCond,
	InitialData,
	InitialExp,
	InlineFunc,
	InputDatabase,
	InputDatabase,
	InputFunc,
	InsertPriv,
	InsEvent,
	InternalLength,
	IntervalType,
	InvertRangeSelTrigger,
	IoCast,
	IsPartitioned,
	IsTemplate,
	Italic,
	Item,
	Items,
	JoinFunc,
	KeepClusterObjs,
	KeepObjsPerms,
	Label,
	LabelsPos,
	Landscape,
	Language,
	LastAnalyze,
	LastAutovacuum,
	LastPosition,
	LastSysOid,
	LastVacuum,
	LastValue,
	LastZoom,
	Layer,
	Layers,
	LcCollate,
	LcCtype,
	LeakProof,
	Left,
	LeftType,
	Length,
	Library,
	LikeType,
	Line,
	LineHighlightColor,
	LineNumbersBgColor,
	LineNumbersColor,
	Link,
	ListenAddresses,
	Locale,
	LockerArc,
	LockerBody,
	Login,
	LookaheadChar,
	LowVerbosity,
	Materialized,
	MaxConnections,
	Maximized,
	MaxObjCount,
	MaxValue,
	Member,
	MemberRoles,
	Merges,
	Metadata,
	MinObjectOpacity,
	MinValue,
	Mode,
	ModelAuthor,
	Name,
	NameFilter,
	NameLabel,
	NamePatterns,
	Names,
	NegatorOp,
	NewIdentityType,
	NewName,
	NewTableName,
	NewVersion,
	Next,
	NnColumn,
	NoInherit,
	None,
	NotExtObject,
	NotNull,
	NullsFirst,
	Object,
	ObjectFinder,
	ObjectId,
	Objects,
	ObjectType,
	ObjCount,
	ObjSelection,
	Oid,
	OidFilterOp,
	Oids,
	OldName,
	OldTableName,
	OldVersion,
	OpClass,
	OpClasses,
	Operator,
	OperatorFunc,
	Operators,
	OpFamily,
	OpListSize,
	Options,
	OriginalPk,
	OutputFunc,
	Owner,
	OwnerColumn,
	Pagination,
	PaperCustomSize,
	PaperMargin,
	PaperOrientation,
	PaperType,
	Parameter,
	Parameters,
	ParamIn,
	ParamOut,
	ParamVariadic,
	Parent,
	ParentType,
	Parents,
	Parsable,
	PartialMatch,
	PartitionBoundExpr,
	PartitionedTable,
	PartitionTables,
	Partitioning,
	PartitionKey,
	PartKeyColls,
	PartKeyCols,
	PartKeyExprs,
	PartKeyOpCls,
	Password,
	PasswordEncryption,
	Path,
	Patterns,
	Permission,
	Permissive,
	PerRow,
	PgModelerVersion,
	PgSqlBaseType,
	PgSqlVersion,
	PkColPattern,
	PkColumn,
	PkConstr,
	PkPattern,
	Placeholder,
	Placeholders,
	Points,
	Port,
	Portrait,
	Position,
	PositionInfo,
	Precision,
	Predicate,
	Preferred,
	PrependAtBod,
	PrependedSql,
	PreserveDbName,
	PrependSchema,
	Preset,
	Preset,
	Previous,
	PrintGrid,
	PrintPgNum,
	Privileges,
	PrivilegesGop,
	ProtColumn,
	Protected,
	RangeAttribs,
	RangeType,
	Recent,
	RecentModels,
	RecreateUnmodObjs,
	RectVisible,
	Recursive,
	RecvFunc,
	ReducedForm,
	RefAlias,
	RefColumn,
	Refer,
	Reference,
	ReferenceFk,
	References,
	ReferencesPriv,
	Referrers,
	RefName,
	RefRoles,
	RefTable,
	RefTables,
	RefTableTag,
	RefType,
	RegularExp,
	Relationship,
	Relationship11,
	Relationship1n,
	RelationshipDep,
	RelationshipFk,
	RelationshipGen,
	RelationshipNn,
	RelationshipPart,
	RelationshipTabView,
	Rename,
	Replication,
	RestartSeq,
	RestrictionFunc,
	ReturnsSetOf,
	ReturnTable,
	ReturnType,
	ReuseSequences,
	Revoke,
	Right,
	RightType,
	RlsEnabled,
	RlsForced,
	Role,
	Roles,
	RoleType,
	RowAmount,
	Rules,
	SaveLastPosition,
	SaveRestoreGeometry,
	Schema,
	SchemaOid,
	SearchPath,
	SecurityType,
	SelectExp,
	SelectObjects,
	SelectPriv,
	SendFunc,
	Sequence,
	Server,
	ServerEncoding,
	ServerPid,
	ServerProtocol,
	ServerVersion,
	SetPerms,
	SharedObj,
	ShellTypes,
	ShowAttributesGrid,
	ShowCanvasGrid,
	ShowMainMenu,
	ShowPageDelimiters,
	ShowSourcePane,
	Signature,
	SimpleExp,
	SimplifiedObjCreation,
	SinglePkColumn,
	Size,
	Snippet,
	SortOp,
	SourceEditorApp,
	SourceEditorArgs,
	SourceType,
	SpatialType,
	SpecialPkCols,
	Splitted,
	SqlDisabled,
	SqlObject,
	SqlTool,
	SqlValidation,
	SrcColPattern,
	SrcColumns,
	SrcEncoding,
	SrcFkPattern,
	SrcLabel,
	SrcRequired,
	SrcTable,
	SrcType,
	Srid,
	Ssl,
	SslCaFile,
	SslCertFile,
	SslCrlFile,
	SslKeyFile,
	Start,
	StateType,
	Storage,
	StorageParams,
	StoreInFile,
	StrategyNum,
	Style,
	Styles,
	Subtype,
	SubtypeDiffFunc,
	Superuser,
	Symbol,
	Table,
	TableBody,
	TableExtBody,
	TableName,
	TableObject,
	TableSchemaName,
	Tablespace,
	TableTitle,
	TableType,
	Tag,
	TemplateDb,
	TemporaryPriv,
	Top,
	TpmodInFunc,
	TpmodOutFunc,
	TransitionFunc,
	TriggerFunc,
	TriggerPriv,
	Triggers,
	True,
	Truncate,
	TruncateCmds,
	TruncatePriv,
	TruncColsBeforeAlter,
	TruncEvent,
	Trusted,
	TuplesDel,
	TuplesIns,
	Type,
	TypeAttribute,
	TypeClass,
	TypeOid,
	Types,
	TyplesUpd,
	UiLanguage,
	Underline,
	Unique,
	Unlogged,
	Unset,
	UnsetPerms,
	UpdAction,
	UpdatePriv,
	UpdEvent,
	UqColumn,
	UqConstr,
	UqPattern,
	UsagePriv,
	UseChangelog,
	UseCurvedLines,
	UsePlaceholders,
	UseSignature,
	UseSorting,
	UseUniqueNames,
	UsingExp,
	Validation,
	Validator,
	ValidatorFunc,
	Validity,
	Value,
	Values,
	Variable,
	Variation,
	Version,
	ViewBody,
	ViewExtBody,
	ViewName,
	ViewSchemaName,
	ViewTitle,
	Visible,
	Widget,
	WidgetsGeometry,
	Width,
	Wildcard,
	WindowFunc,
	WithNoData,
	WithoutOids,
	WithTimezone,
	WordDelimiters,
	WordSeparators,
	WorkingDir,
	XPos,
	YPos,
	ZValue;
}

#endif
