//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: sysLogger.h 7215 2008-04-04 12:28:00Z dpage $
// Copyright (C) 2002 - 2008, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// sysLogger.h - Log handling class
//
//////////////////////////////////////////////////////////////////////////

#ifndef SYSLOGGER_H
#define SYSLOGGER_H

// wxWindows headers
#include <wx/wx.h>

// App headers

enum LOG_LEVEL
{
    LOG_NONE = 0,
    LOG_ERRORS = 1,
    LOG_NOTICE = 2,
    LOG_SQL = 3,
    LOG_DEBUG = 4
};

// Class declarations
class sysLogger : public wxLog
{
public:
    virtual void DoLog(wxLogLevel level, const wxChar *msg, time_t timestamp);
    static wxLogLevel logLevel;
    static wxString logFile;

private:
    void WriteLog(const wxString& msg);
    bool SilenceMessage(const wxString &msg);
};

#define wxLOG_Notice (wxLOG_User+1)
#define wxLOG_Sql (wxLOG_User+2)
#define wxLOG_QuietError (wxLOG_User+3)

DECLARE_LOG_FUNCTION(Notice);
DECLARE_LOG_FUNCTION(Sql);
DECLARE_LOG_FUNCTION(QuietError);

#endif
