#ifndef PETSC4PY_PETSC_NPY_H
#define PETSC4PY_PETSC_NPY_H

#if defined(PETSC_USE_64BIT_INDICES)
# define NPY_PETSC_INT     NPY_LONGLONG
#else
# define NPY_PETSC_INT     NPY_INT
#endif

#if   defined(PETSC_USE_SCALAR_SINGLE) || defined(PETSC_USE_SINGLE)
# define NPY_PETSC_REAL    NPY_FLOAT
# define NPY_PETSC_COMPLEX NPY_CFLOAT
#elif defined(PETSC_USE_SCALAR_LONG_DOUBLE) ||defined(PETSC_USE_LONG_DOUBLE)
# define NPY_PETSC_REAL    NPY_LONGDOUBLE
# define NPY_PETSC_COMPLEX NPY_CLONGDOUBLE
#elif defined(PETSC_USE_SCALAR_INT) || defined(PETSC_USE_INT)
# define NPY_PETSC_REAL    NPY_INT
# define NPY_PETSC_COMPLEX NPY_CFLOAT /* ??? */
#else    /*  (PETSC_USE_SCALAR_DOUBLE) || (PETSC_USE_DOUBLE)  */
# define NPY_PETSC_REAL    NPY_DOUBLE
# define NPY_PETSC_COMPLEX NPY_CDOUBLE
#endif

#if defined(PETSC_USE_COMPLEX)
# define NPY_PETSC_SCALAR  NPY_PETSC_COMPLEX
#else    /* PETSC_USE_REAL */
# define NPY_PETSC_SCALAR  NPY_PETSC_REAL
#endif

#endif /* !PETSC4PY_PETSC_NPY_H */
