/* $Id$ */

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#if defined(PETSC_HAVE_MPIUNI)
#if !defined(MPI_Finalized)
static int MPI_Finalized(int *flag)
{
  if (flag) *flag = 0;
  return 0;
}
#endif
#endif
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define VecStrideScale(v,start,scale) VecStrideScale(v,start,&scale)
#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
static 
PetscErrorCode ISSum_232(IS is1,IS is2,IS *is3) {
  PetscTruth     f;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(is1,IS_COOKIE,1);
  PetscValidHeaderSpecific(is2,IS_COOKIE,2);
  PetscValidPointer(is3, 3);
  ierr = ISSorted(is1,&f); CHKERRQ(ierr);
  if (!f) SETERRQ(PETSC_ERR_ARG_INCOMP,"Arg 1 is not sorted");
  ierr = ISSorted(is2,&f); CHKERRQ(ierr);
  if (!f) SETERRQ(PETSC_ERR_ARG_INCOMP,"Arg 2 is not sorted");
  ierr = ISDuplicate(is1,is3); CHKERRQ(ierr);
  ierr = ISSum(is3,is2); CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
#define ISSum(is1,is2,is3) ISSum_232(is1,is2,is3)
#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define VecScatterBegin(sct,x,y,im,sm) VecScatterBegin(x,y,im,sm,sct)
#define VecScatterEnd(sct,x,y,im,sm)   VecScatterEnd(x,y,im,sm,sct)
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define MatGetRowIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatGetRowIJ(mat,shift,symm,n,ia,ja,done)
#define MatRestoreRowIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatRestoreRowIJ(mat,shift,symm,n,ia,ja,done)
#define MatGetColumnIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatGetColumnIJ(mat,shift,symm,n,ia,ja,done)
#define MatRestoreColumnIJ(mat,shift,symm,bc,n,ia,ja,done) \
        MatRestoreColumnIJ(mat,shift,symm,n,ia,ja,done)
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define PetscOptionsMonitorSet(mfun,mctx,mdestr) PetscOptionsSetMonitor(mfun,mctx,mdestr)
#define PetscOptionsMonitorCancel() PetscOptionsClearMonitor()

#define KSPMonitorSet(ksp,mfun,mctx,mdestr) KSPSetMonitor(ksp,mfun,mctx,mdestr)
#define KSPMonitorCancel(ksp) KSPClearMonitor(ksp)
#define KSPMonitorDefault KSPDefaultMonitor
#define KSPMonitorTrueResidualNorm KSPTrueMonitor
#define KSPMonitorSolution KSPVecViewMonitor
#define KSPMonitorLG KSPLGMonitor

#define SNESMonitorSet(snes,mfun,mctx,mdestr) SNESSetMonitor(snes,mfun,mctx,mdestr)
#define SNESMonitorCancel(snes) SNESClearMonitor(snes)
#define SNESMonitorDefault SNESDefaultMonitor
#define SNESMonitorResidual SNESVecViewResidualMonitor
#define SNESMonitorSolution SNESVecViewMonitor
#define SNESMonitorSolutionUpdate SNESVecViewUpdateMonitor
#define SNESMonitorLG SNESLGMonitor

#define TSMonitorSet(snes,mfun,mctx,mdestr) TSSetMonitor(snes,mfun,mctx,mdestr)
#define TSMonitorCancel(snes) TSClearMonitor(snes)
#define TSMonitorDefault TSDefaultMonitor
#define TSMonitorSolution TSVecViewMonitor
#define TSMonitorLG TSLGMonitor

#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#define KSP_NORM_NO		  KSP_NO_NORM
#define KSP_NORM_PRECONDITIONED   KSP_PRECONDITIONED_NORM
#define KSP_NORM_UNPRECONDITIONED KSP_UNPRECONDITIONED_NORM
#define KSP_NORM_NATURAL          KSP_NATURAL_NORM

#include "include/private/kspimpl.h"

static 
PetscErrorCode KSPGetNormType(KSP ksp, KSPNormType *normtype) {
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ksp,KSP_COOKIE,1);
  PetscValidPointer(normtype, 2);
  *normtype = ksp->normtype;
  PetscFunctionReturn(0);
}

#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#include "include/private/snesimpl.h"

#define SNES_CONVERGED_ITS 5
#define SNESDefaultConverged SNESConverged_LS
#define SNESSkipConverged(snes,it,xnorm,pnorm,fnorm,reason,ctx) \
  (*reason = SNES_CONVERGED_ITERATING, 0)
#endif
%}

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#include "include/private/snesimpl.h"
#undef __FUNCT__
#define __FUNCT__ "SNESKSPSetUseEW"
static
PetscErrorCode SNESKSPSetUseEW(SNES snes,PetscTruth flag)
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  snes->ksp_ewconv = flag;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPGetUseEW"
static
PetscErrorCode SNESKSPGetUseEW(SNES snes, PetscTruth *flag)
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  PetscValidPointer(flag,2);
  *flag = snes->ksp_ewconv;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPGetParametersEW"
static
PetscErrorCode SNESKSPGetParametersEW(SNES snes,PetscInt *version,PetscReal *rtol_0,PetscReal *rtol_max,
				      PetscReal *gamma,PetscReal *alpha,PetscReal *alpha2,PetscReal *threshold)
{
  SNES_KSP_EW_ConvCtx *kctx;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  kctx = (SNES_KSP_EW_ConvCtx*)snes->kspconvctx;
  if (!kctx) SETERRQ(PETSC_ERR_ARG_WRONGSTATE,"No Eisenstat-Walker context existing");
  if(version)   *version   = kctx->version;
  if(rtol_0)    *rtol_0    = kctx->rtol_0;
  if(rtol_max)  *rtol_max  = kctx->rtol_max;
  if(gamma)     *gamma     = kctx->gamma;
  if(alpha)     *alpha     = kctx->alpha;
  if(alpha2)    *alpha2    = kctx->alpha2;
  if(threshold) *threshold = kctx->threshold;
  PetscFunctionReturn(0);
}
#undef __FUNCT__
#define __FUNCT__ "SNESKSPSetParametersEW"
static
PetscErrorCode SNESKSPSetParametersEW(SNES snes,PetscInt version,PetscReal rtol_0,PetscReal rtol_max,
				      PetscReal gamma,PetscReal alpha,PetscReal alpha2,PetscReal threshold)
{
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(snes,SNES_COOKIE,1);
  ierr = SNES_KSP_SetParametersEW(snes,version,rtol_0,rtol_max,gamma,alpha,alpha2,threshold);CHKERRQ(ierr);
  PetscFunctionReturn(0);

}
#endif
%}


%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
#define SNESGetNonlinearStepFailures	SNESGetNumberUnsuccessfulSteps
#define SNESSetMaxNonlinearStepFailures	SNESSetMaximumUnsuccessfulSteps
#define SNESGetMaxNonlinearStepFailures	SNESGetMaximumUnsuccessfulSteps
#define SNESGetLinearSolveIterations    SNESGetNumberLinearIterations
#endif
%}

/* ---------------------------------------------------------------- */

%header %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

#include "include/private/tsimpl.h"

static
PetscErrorCode TSSolve(TS ts, Vec u)
{
  PetscInt       steps;
  PetscReal      ptime;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ts,TS_COOKIE,1);
  /* set solution vector if provided */
  if (u) { ierr = TSSetSolution(ts, u); CHKERRQ(ierr); }
  /* reset time step and iteration counters */
  ts->steps = 0; ts->linear_its = 0; ts->nonlinear_its = 0;
  /* steps the requested number of timesteps. */
  ierr = TSStep(ts, &steps, &ptime);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

static
PetscErrorCode TSSetTime(TS ts, PetscReal t) 
{
  PetscFunctionBegin;
  PetscValidHeaderSpecific(ts,TS_COOKIE,1);
  ts->ptime = t;
  PetscFunctionReturn(0);
}

#endif
%}

/* ---------------------------------------------------------------- */

%header %{

#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)

PETSC_EXTERN_CXX_BEGIN
EXTERN PETSC_DLLEXPORT PetscCookie CONTAINER_COOKIE;
PETSC_EXTERN_CXX_END

#define PETSC_CONTAINER_COOKIE        CONTAINER_COOKIE
#define PetscContainer                PetscObjectContainer
#define PetscContainerGetPointer      PetscObjectContainerGetPointer
#define PetscContainerSetPointer      PetscObjectContainerSetPointer
#define PetscContainerDestroy         PetscObjectContainerDestroy
#define PetscContainerCreate          PetscObjectContainerCreate
#define PetscContainerSetUserDestroy  PetscObjectContainerSetUserDestroy

#endif
%}

/* ---------------------------------------------------------------- */

/*
 * Local Variables:
 * mode: C
 * End:
 */
