#include "petsc.h"
#include "petscfix.h"
/* memc.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petsc.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscmemcpy_ PETSCMEMCPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscmemcpy_ petscmemcpy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscmemzero_ PETSCMEMZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscmemzero_ petscmemzero
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscmemcmp_ PETSCMEMCMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscmemcmp_ petscmemcmp
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscmemmove_ PETSCMEMMOVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscmemmove_ petscmemmove
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   petscmemcpy_(void*a, void*b,size_t *n, int *__ierr ){
*__ierr = PetscMemcpy(a,b,*n);
}
void PETSC_STDCALL   petscmemzero_(void*a,size_t *n, int *__ierr ){
*__ierr = PetscMemzero(a,*n);
}
void PETSC_STDCALL   petscmemcmp_( void*str1, void*str2,size_t *len,PetscTruth *e, int *__ierr ){
*__ierr = PetscMemcmp(str1,str2,*len,e);
}
void PETSC_STDCALL   petscmemmove_(void*a,void*b,size_t *n, int *__ierr ){
*__ierr = PetscMemmove(a,b,*n);
}
#if defined(__cplusplus)
}
#endif
