# Written by Owen Williams
# see LICENSE for license information
import os,sys,time
import string
import fnmatch

VERSION="1.02"

def format_size(size):
	if size > 1000000000:
		return str(size/1000000000)+" GB"
	elif size > 1000000:
		return str(size/1000000)+ " MB"
	elif size > 1000:
		return str(size/1000)+" KB"
	else:
		return str(size)+" bytes"
		
def GetPrefix():
	h, t = os.path.split(os.path.split(os.path.abspath(sys.argv[0]))[0])
	return h

def hours(n):  #this func copyright Bram Cohen
    if n == -1:
        return '<unknown>'
    if n == 0:
        return 'complete!'
    n = long(n)
    h, r = divmod(n, 60 * 60)
    m, sec = divmod(r, 60)
    if h > 1000000:
        return '<unknown>'
    if h > 0:
        return '%d:%02d:%02d' % (h, m, sec)
    else:
        return '%d:%02d' % (m, sec)

def is_known_media(filename):
	good_ext = [
				'mp3','ogg','flac', 'wav', #windows audio
				'mp4','m4p','aac','aif',   #mac audio
				'avi','wmv','asf','mpg',         #windows video
				'mov', 'm4v', 'm4a',                    #mac
				'ogm','mkv']               #weird but ok I think

	if os.path.isdir(filename):
		for root,dirs,files in os.walk(filename):
			for f in files:
				ext = f.split('.')[-1].lower()
				if ext in good_ext:
					return True

	ext = filename[filename.rfind(".")+1:].lower()

	if ext in good_ext:
		return True
	else:
		return False
				
def get_dated_dir():
	today = time.strftime("%Y-%m-%d")
	return today				
			
#http://www.faqts.com/knowledge_base/view.phtml/aid/2682
class GlobDirectoryWalker:
    # a forward iterator that traverses a directory tree

    def __init__(self, directory, pattern="*"):
        self.stack = [directory]
        self.pattern = pattern
        self.files = []
        self.index = 0

    def __getitem__(self, index):
        while 1:
            try:
                file = self.files[self.index]
                self.index = self.index + 1
            except IndexError:
                # pop next directory from stack
                self.directory = self.stack.pop()
                self.files = os.listdir(self.directory)
                self.index = 0
            else:
                # got a filename
                fullname = os.path.join(self.directory, file)
                if os.path.isdir(fullname) and not os.path.islink(fullname):
                    self.stack.append(fullname)
                if fnmatch.fnmatch(file, self.pattern):
                    return fullname
#usage:
#for file in GlobDirectoryWalker(".", "*.py"):
#    print file

def deltree(path):
#adapted and corrected from: http://aspn.activestate.com/ASPN/docs/ActivePython/2.2/PyWin32/Recursive_directory_deletes_and_special_files.html
	for file in os.listdir(path):
		file_or_dir = os.path.join(path,file)
		if os.path.isdir(file_or_dir) and not os.path.islink(file_or_dir):
			deltree(file_or_dir) #it's a directory reucursive call to function again
		else:
			os.remove(file_or_dir) #it's a file, delete it
	os.rmdir(path) #delete the directory here


def my_quote(str):
	"""Replaces some problematic characters with html equivalent if necessary"""
	#right now just & to &amp;, but not &amp; to &amp;amp;
	#instead of doing this with logic, just "unquote" the amps and then requote them
	str=string.replace(str,"&amp;","&")
	str=string.replace(str,"&","&amp;")
	return str
