# Written by Owen Williams
# see LICENSE for license information

from pysqlite2 import dbapi2 as sqlite
import feedparser
import OPML
import time
import string
import sha
import urllib
from types import *
import threading
import ThreadPool
import sys, os, re, traceback
import glob

import utils

import timeoutsocket
import smtplib
timeoutsocket.setDefaultSocketTimeout(20)

SUCCESS= 0
NOUSER = 1
NOFEED = 2
ALREADYEXISTS = 3
FAILURE = 4

NEW = 0
EXISTS = 1
MODIFIED = 2
DELETED = 3

F_ERROR       = 64
F_DOWNLOADING = 32   
F_UNVIEWED    = 16
F_DOWNLOADED  = 8
F_NEW         = 4
F_MEDIA       = 2
F_PAUSED			= 1

from HTMLParser import HTMLParser
from formatter import NullFormatter

class HTMLtagParser(HTMLParser):
	def __init__(self):
		HTMLParser.__init__(self)
		self.text=''
		in_tag=0
		
	def handle_starttag(self, tag, attrs):
		"""Signal when we get to a tag.
		"""
		self.in_tag = 1###

	def end_a(self, attrs):
		"""Signal when we are out of the tag"""
		self.in_tag = 0#

	def handle_data(self, text):
		"""This is called everytime we get to text data (ie. not tags) """
		if self.in_tag and text!='' and self.text=='' and text[0].isalpha():
			self.text = text
			

class ptvDB:
	def __init__(self, polling_callback=None):#,username,password):
		try:
			self.home=os.getenv('HOME')
			os.stat(self.home+"/.penguintv")
		except:
			try:
				os.mkdir(self.home+"/.penguintv")
			except:
				raise DBError, "error creating directories: "+self.home+"/.penguintv"
		try:	
			self.db=sqlite.connect(self.home+"/.penguintv/penguintv.db", timeout=21, isolation_level=None)
			self.db.isolation_level="DEFERRED"
		except:
			raise DBError,"error connecting to database"
		self.c = self.db.cursor()
#		self.in_threading=1
#		self.pool = ThreadPool.ThreadPool(5)
		#self.db_lock = threading.RLock()
		if polling_callback==None:
			self.polling_callback=self._polling_callback
		else:
			self.polling_callback = polling_callback		

	def maybe_initialize_db(self):
		try:
			self.c.execute(u'SELECT * FROM feeds')
		except:
			self.init_database()
			return True	
		return False

	def __del__(self):
		self.finish()
		#print "joining"
		#self.pool.joinAll()
		#print "done joining"
		#del self.pool
	#	self.c.close()
	#	self.db.close()
		
	def finish(self):
	#	
	#	if self.pool.getThreadCount()>0:
	#		print "doop doop waiting to join"
#		self.pool.joinAll()
	#		print "done joining"
	#	del self.pool
	#		self.pool=ThreadPool.ThreadPool(5)
	#	
		self.c.close()
		self.db.close()
		
	def init_database(self):
		
		try:
			self.c.execute(u'DROP TABLE settings')
		except:
			pass	
			
		try:
			self.c.execute(u'DROP TABLE feeds')
		except:
			pass
			
		try:
			self.c.execute(u'DROP TABLE entries')
		except:
			pass
			
		try:
			self.c.execute(u'DROP TABLE media')
		except:
			pass
			
		self.c.execute(u"""CREATE TABLE  feeds
(
    id INTEGER PRIMARY KEY,
    url NOT NULL,
    polled INT NOT NULL,
    pollfail BOOL NOT NULL,
    title  ,
    description  ,
    modified INT UNSIGNED NOT NULL,
    etag ,
    UNIQUE(url)
);""")
		self.c.execute(u"""CREATE TABLE entries
(
    id INTEGER  PRIMARY KEY,
        feed_id INT UNSIGNED NOT NULL,
        title ,
        creator  ,
        description,
        date DATE,
        guid ,
        link ,
				read BOOL NOT NULL,
        old BOOL NOT NULL,
        new BOOL NOT NULL,
        UNIQUE(id)
);""")
		self.c.execute(u"""CREATE TABLE  media
(
	id INTEGER  PRIMARY KEY,
	entry_id INTEGER UNSIGNED NOT NULL,
	url  NOT NULL,
	file ,
	mimetype ,
	download_status NOT NULL,
	viewed BOOL NOT NULL,
	keep BOOL NOT NULL,
	length,
	UNIQUE(id)
);
""")
		
	def insertURL(self, url):
		#if a feed with that url doesn't already exists, add it
		#since every time a url add a person is adding it, we can use this opportunity
		#to both associate a url with a user, and add new urls as needed

		self.c.execute("""SELECT url FROM feeds WHERE url=?""",(url,))
		#on success, fetch will return the url itself
		if self.c.fetchone() != (url,):
			self.c.execute(u"""INSERT INTO feeds (id,url,polled,pollfail,modified) VALUES (NULL, ?,0,0, 0)""", (url,))
			self.db.commit()
			self.c.execute(u"""SELECT id,url FROM feeds WHERE url=?""",(url,))
			feed_id = self.c.fetchone()
			feed_id = feed_id[0]
			#now poll the feed to seed it for the first time
			#no, don't use the tuple
			if self.poll_feed(feed_id) == NOFEED:
			#result = self.poll_feed(feed_id)
			#if result > 0:
				self.c.execute("""DELETE FROM feeds WHERE id=?""",(feed_id,))
				self.db.commit()
				return NOFEED
		else:
			self.c.execute("""SELECT id FROM feeds WHERE url=?""",(url,))
			feed_id = self.c.fetchone()
			feed_id = feed_id[0]
					
		return SUCCESS
		
	def delete_feed(self, feed_id):
		#check for valid entry		
		self.c.execute("""SELECT id FROM feeds WHERE id=?""",(feed_id,))
		result = self.c.fetchone()[0]

		if result != feed_id:			
			raise NoFeed,feed_id
		
		#delete the feed, its entries, and its media (this does not delete files)
		self.c.execute("""DELETE FROM feeds WHERE id=?""",(feed_id,))
		self.db.commit()
		#result = self.c.fetchone()
		#print(result)
		#can't seem to do a multidelete...self.c.execute("""DELETE FROM media WHERE feed_id=?""",(feed_id,))
		self.c.execute('SELECT id FROM entries WHERE feed_id=?',(feed_id,))
		data=self.c.fetchall()
		if data: 
			dataList = [list(row) for row in data]
			for datum in dataList:
				self.c.execute('SELECT id FROM media WHERE entry_id=?',(datum[0],))
				media=self.c.fetchall()
				if media: 
					mediaList = [list(row) for row in media]
					for medium in mediaList:
						self.delete_media(int(medium[0]))
						self.db.commit()
					self.c.execute('DELETE FROM media WHERE entry_id=?',(datum[0],))
		self.c.execute("""DELETE FROM entries WHERE feed_id=?""",(feed_id,))
		self.db.commit()
		#TODO: also delete media
		
		return SUCCESS
		
	def DEBUG_delete_all_media(self):		
		self.c.execute(u'UPDATE media SET download_status=0')
		self.db.commit()
				
	def delete_media(self, media_id):
		media = self.get_media(media_id)
#		print "deleting media: "+str(media)
		try: #if it doesn't even have a 'file' key then return
			if media['file']==None:
				return
		except:
			return
	#	print "deleting >"+str(media['file'])+"<"
		try:
			if os.path.isfile(media['file']):
				os.remove(media['file'])
			else: #could be a dir if it was a bittorrent download
				utils.deltree(media['file']) 
			#now check to see if we should get rid of the dated dir
			globlist = glob.glob(os.path.split(media['file'])[0]+"/*")
			if len(globlist)==1 and os.path.split(globlist[0])[1]=="playlist.m3u": #if only the playlist is left, we're done
				utils.deltree(os.path.split(media['file'])[0])
			if len(globlist)==0: #similarly, if dir is empty, we're done.
				utils.deltree(os.path.split(media['file'])[0])
		#if everything worked, set status
			self.set_media_download_status(media_id,0)
		except os.error, detail:
			print "Error deleting: "+str(detail)
		
	def delete_bad(self):		
		self.c.execute("""DELETE FROM feeds WHERE title IS NULL""")
		self.db.commit()
		return SUCCESS
		
	def poll_multiple(self, override=0):
		"""Polls multiple feeds multithreadedly, and returns a tuple
		representing the success of each poll based on the enum"""
		
		#print "active before start:" + str(threading.activeCount())
		#temporarily disabled threading because it's not working
		successes=[]

		index = 0
		self.c.execute('SELECT id FROM feeds')
		data=self.c.fetchall()
		if data: 
			feeds = [list(row) for row in data]
		else:
			return
		pool = ThreadPool.ThreadPool(4)
		for feed in feeds:
			pool.queueTask(self.pool_poll_feed,(index,feed[0],override),self.polling_callback)
			index = index + 1
#		print "waiting for threads"
		pool.joinAll(True,True)
	
	def pool_poll_feed(self,args):
		"""a wrapper function that returns the index along with the result
		so we can sort"""
		try:	
			db=sqlite.connect(self.home+"/.penguintv/penguintv.db", timeout=2)
		except:
			raise DBError,"error connecting to database"
		index=args[0]
		feed_id=args[1]
		override = 0
		result = NOFEED
		try:
			override = args[2]
			result = self.poll_feed(feed_id,override,db)
		except:
			pass
		del db
		#print str(threading.currentThread().getName())+ " done "+time.strftime("%Y-%m-%d %H:%M:%S")
		return (feed_id,result)

	def _polling_callback(self, data):
		print "look a callback"
		print data
		
	def poll_feed(self, feed_id, override=0, db=None):
		#print str(threading.currentThread().getName())+" start poll "+time.strftime("%Y-%m-%d %H:%M:%S")
		#lock when we do database stuff
		if db is None:
			db = self.db
		c = db.cursor()
		
		c.execute("""SELECT url,modified,etag FROM feeds WHERE id=?""",(feed_id,))
		data = c.fetchone()
		url,modified,etag=data
		
		try:
			feedparser.disableWellFormedCheck=1
			#print "polling "+str(url)
			if override >0:
				data = feedparser.parse(url)
			else:
				data = feedparser.parse(url,etag)
		except:
			return NOFEED
			
			#print(data)
		#this is extrememly simple code to see if things are ok
		if data.has_key('status'):
			if data['status'] == 304:
				#print url+" up to date "
				c.execute("""UPDATE entries SET new=0 WHERE feed_id=?""",(feed_id,))
				db.commit()
				return SUCCESS
			if data['status'] == 404:
				#print url+" not found"
				return NOFEED
		#print str(threading.currentThread().getName())+ " inserting "+time.strftime("%Y-%m-%d %H:%M:%S")
		if len(data['channel']) == 0 or len(data['items']) == 0:
			c.execute("""UPDATE feeds SET pollfail=1 WHERE id=?""",(feed_id,))
			db.commit()
			#print url+" empty"
			return NOFEED
			
			#else...
		#print url +" continuing"
		if override==2:
			c.execute("""DELETE FROM entries WHERE feed_id=?""",(feed_id,))
			db.commit()
	        #to discover the old entries, first we mark everything as old
		#later, we well unset this flag for everything that is NEW,
		#MODIFIED, and EXISTS. anything still flagged should be deleted  
		c.execute("""UPDATE entries SET old=1 WHERE feed_id=?""",(feed_id,)) 
		db.commit()
		c.execute("""UPDATE entries SET new=0 WHERE feed_id=?""",(feed_id,))
		db.commit()
		#c.execute("SELECT new FROM entries WHERE feed_id=?",(feed_id,))
		#print c.fetchall()
		#also delete all related images
		#normalize results
		channel = data['channel']
		if channel.has_key('description') == 0:
			#print("creating empty description")
			channel['description']=""
		if len(channel['description']) > 128:
			channel['description'] = channel['description'][0:127]
		#print channel['description']
		channel['description']=self.encode_text(channel['description'])
		#print channel['description']
		#print 'desc set'
		if channel.has_key('title') == 0:
			if channel['description'] != "":
				#print("setting title to description")
				channel['title']=channel['description']
			else:
				channel['title']=url
		channel['title'] = self.encode_text(channel['title'])
		#print 'title set'
		#also set pollfail=0 since it worked, obviously
		if not data.has_key('etag'):
			data['etag']='0'
		if not data.has_key('modified'):
			modified='0'
		else:
			modified = time.mktime(data['modified'])
		#print 'about to commit'
		try:
			c.execute(u'SELECT title FROM feeds WHERE id=?',(feed_id,))
			exists=c.fetchone()
			if len(exists)>0: #don't change title
				if exists[0] is not None:
					c.execute("""UPDATE feeds SET description=?, modified=?, etag=?, pollfail=0 WHERE id=?""", (channel['description'], modified,data['etag'],feed_id))
				else:
					c.execute("""UPDATE feeds SET title=?, description=?, modified=?, etag=?, pollfail=0 WHERE id=?""", (channel['title'],channel['description'], modified,data['etag'],feed_id))
			else:
				c.execute("""UPDATE feeds SET title=?, description=?, modified=?, etag=?, pollfail=0 WHERE id=?""", (channel['title'],channel['description'], modified,data['etag'],feed_id))
			db.commit()
		except:
			#f = open("/var/log/penguintv.log",'a')
			#f.write("borked on: UPDATE feeds SET title="+str(channel['title'])+", description="+str(channel['description'])+", modified="+str(modified)+", etag="+str(data['etag'])+", pollfail=0 WHERE id="+str(feed_id))
			#f.close()				 
			
			return NOFEED
		
			#populate the entries
		c.execute("""SELECT id,guid,link,title,description FROM entries WHERE feed_id=? order by date""",(feed_id,)) 
		existing_entries = c.fetchall()
		#print existing_entries
		#print existing_entries
		#for entry in existing_entries:
		#	print entry[0]['title']+' '+entry[0]['link']
		#ID=0,GUID=1,LINK=2,TITLE=3,BODY=4
		#we can't trust the dates inside the items for timing data
		#bad formats, no dates at all, and timezones screw things up
		#so I introduce a fake date which works for determining read and
		#unread article counts, and keeps the articles in order
		fake_time = time.time()#-len(data['items'])
		i=0
		
		try:
			if data['items'][0].has_key('modified_parsed') == 1:
				data['items'].sort(lambda x,y: int(time.mktime(y['modified_parsed'])-time.mktime(x['modified_parsed'])))
		except:
			try:
				if data['items'][0].has_key('created_parsed') == 1:
					data['items'].sort(lambda x,y: int(time.mktime(y['created_parsed'])-time.mktime(x['modified_parsed'])))
			except:	
				try:	
					if data['items'][0].has_key('date_parsed') == 1:
						data['items'].sort(lambda x,y: int(time.mktime(y['date_parsed'])-time.mktime(x['date_parsed'])))
				except:
					pass #I feel dirty.
		
		for item in data['items']:
			#do a lot of normalizing
			if item.has_key('content') == 0:   #ok so peter was right, 
				if item.has_key('description') == 1:   #content_encoded is where we should be
					item['body'] = item['description']   #but we can fall back on the description
				else:
					item['body'] = ''
			else:
				item['body'] = item['content'][0]['value']
			
			item['body']=self.encode_text(item['body'])
			
			if item.has_key('title') == 0:
				item['title']=item['description'][0:35]	
				html_begin = string.find(item['title'],'<')
				if html_begin >= 0 and html_begin < 5: #in case it _begins_ with html, and the html is really early
					p = HTMLtagParser()
					p.feed(item['description'])
					item['title']=p.text[0:35]
			elif item['title']=="":
				item['title']=item['description'][0:35]
				html_begin = string.find(item['title'],'<')
				if html_begin >= 0 and html_begin < 5: #in case it _begins_ with html, and the html is really early
					p = HTMLtagParser()
					p.feed(item['description'])
					item['title']=p.text[0:35]
			
				elif html_begin > 5: #in case there's html within 35 chars...
					item['title']=item['title'][0:html_begin-1] #strip
					#things mess up if a title ends in a space, so strip trailing spaces
				#doublecheck
				if len(item['title'])==0:
					item['title']='untitled'
				else:
					while item['title'][len(item['title'])-1] == ' ':
						item['title']=item['title'][0:len(item['title'])-1]						
			item['title'] = re.sub('<','&lt;',item['title'])
			item['title'] = re.sub('&','&amp;',item['title'])
			item['title'] = self.encode_text(item['title'])
			
	#		print item['title']

			
			if item.has_key('creator') == 0:
				item['creator']=""
			if item.has_key('author') == 1:
				item['creator']=item['author']
			if item.has_key('guid') == 0:
				item['id']=0
				item['guid']='0'
			if item.has_key('link') == 0:
				item['link'] = ""
				
			item['creator']=self.encode_text(item['creator'])
			#print channel['title']+" "+item['title']
				
			status = self.get_status(item,existing_entries)
			#print 'status:'+str(status)
			#returns (status,entry id)
			if status[0]==NEW:
				#insert with fake time
				#try:
				c.execute(u'INSERT INTO entries (id, feed_id, title, creator, description, read, date, guid, link, old, new) VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',(feed_id,item['title'],item['creator'],item['body'],'0',fake_time-i,item['guid'],item['link'],'0','1'))
				db.commit()
				
				#except:
				#	pass
				c.execute("""SELECT id FROM entries WHERE date=?""",(fake_time-i,))
				entry_id = c.fetchone()[0]
				#print entry_id
				if item.has_key('enclosures'):
					for media in item['enclosures']:
						media.setdefault('type', 'application/octet-stream')
						c.execute(u"""INSERT INTO media (id, entry_id, url, mimetype, download_status, viewed, keep, length) VALUES (NULL, ?, ?, ?, ?, ?, ?, ?)""", (entry_id, media['url'], media['type'], 0, 0, 0, media['length']))
						db.commit()
			elif status[0]==EXISTS or status[0]==MODIFIED:
				#just clear flag
				c.execute("""UPDATE entries SET old=0 where id=?""",(status[1],))
				db.commit()
			i+=1

		#loop through old-marked entries...
		c.execute("""SELECT id FROM entries WHERE feed_id=? AND old=1""",(feed_id,)) 
		old_entries = c.fetchall()
		for entry in old_entries:
			medialist = self.get_entry_media(entry[0],c)
			if medialist:
				for medium in medialist:
					if medium['download_status']==2: #if something is downloaded
						c.execute("""UPDATE entries SET old=0 where id=?""",(entry[0],)) #don't delete this entry
						db.commit()	
		#anything not set above as new, mod, or exists is no longer in
		#the xml and therefore should be deleted
		#TODO: Also delete media
	#	c.execute(u'SELECT old,title FROM entries WHERE feed_id=?',(feed_id,))
#		print "=-"*40
	#	print c.fetchall()
		c.execute("""DELETE FROM entries WHERE old=1 AND feed_id=?""",(feed_id,))
		db.commit()
		return SUCCESS

	def get_status(self,item,existing_entries):
		#someone please tell me how to do enums 
		#fix this
		ID=0
		GUID=1
		LINK=2
		TITLE=3
		BODY=4

		entry_id=-1
		old_hash = sha.new()
		new_hash = sha.new()
		
		for entry_item in existing_entries:
			if str(item['guid'])!='0':
				#print 'g: '+str(entry_item[GUID])+' '+str(item['guid'])
				if str(entry_item[GUID]) == str(item['guid']):# and entry_item[TITLE] == item['title']:
					#print "matched on GUID"
					entry_id = entry_item[ID]
					old_hash.update(entry_item[GUID]+entry_item[BODY])
					new_hash.update(item['guid']+item['body'])
					break
			elif item['link']!='':
				#print "matched on link"
				if entry_item[LINK] == item['link'] and entry_item[TITLE] == item['title']:
					entry_id = entry_item[ID]
					old_hash.update(entry_item[LINK]+entry_item[BODY])
					new_hash.update(item['link']+item['body'])
					break
			elif entry_item[TITLE] == item['title']:
				#print "matched on title"
				entry_id = entry_item[ID]
				old_hash.update(entry_item[TITLE]+entry_item[BODY])
				new_hash.update(item['title']+item['body'])
				break

		if entry_id == -1:
			return (NEW, entry_id)

		if new_hash.hexdigest() == old_hash.hexdigest():
			#print 'exists'
			return (EXISTS,entry_id)
		else:
			#print 'modified'
			return (MODIFIED,entry_id)
			
	def get_entry_media(self, entry_id, c=None):
		if c==None:
			c = self.c
		c.execute("""SELECT * FROM media WHERE entry_id = ?""",(entry_id,))
		data=c.fetchall()
		
		if data: 
			dataList = [list(row) for row in data]
		else:
			return None
		media_list=[]
		for datum in dataList:
			medium={}
			medium['url']=datum[2] #MAGIC
			medium['download_status']=int(datum[5]) #MAGIC
			try:
				medium['size']=int(datum[8]) #MAGIC
			except:
				medium['size']=0
			medium['media_id']=int(datum[0]) #MAGIC
			medium['file']=datum[3] #MAGIC			
			medium['entry_id']=datum[1] #MAGIC
			medium['viewed']=int(datum[6]) #MAGIC
#			if medium['download_status'] == 1: #if downloading, get progress
			media_list.append(medium)			
		return media_list
		
	def get_media(self, media_id):
		
		self.c.execute(u'SELECT * FROM media WHERE id=?',(media_id,))
		datum=self.c.fetchone()
		if datum is None:
			return None
		
		medium={}
		medium['url']=datum[2] #MAGIC
		medium['download_status']=int(datum[5]) #MAGIC
		try:
			medium['size']=int(datum[8]) #MAGIC
		except:
			pass
		medium['media_id']=media_id
		medium['file']=datum[3] #MAGIC
		medium['entry_id']=datum[1] #MAGIC
		medium['viewed']=int(datum[6]) #MAGIC
		return medium
	
	def get_entry(self, entry_id):
	#	print "locking for get_entry"
		
		#print "locked"
		self.c.execute("""SELECT title, creator, link, description, feed_id FROM entries WHERE id=?""",(entry_id,))
		result = self.c.fetchone()
		
		entry_dic={}
		try:
			entry_dic['title'] = result[0]
			entry_dic['creator'] = result[1]
			entry_dic['link'] = result[2]
			entry_dic['description']=result[3]
			entry_dic['feed_id']= result[4]
			entry_dic['entry_id'] = entry_id
		except TypeError: #this error occurs when feed or item is wrong
			raise NoEntry, entry_id
		return entry_dic
		
	def get_entrylist(self, feed_index):
		self.c.execute("""SELECT id,title,date,new FROM entries WHERE feed_id=? ORDER BY date DESC""",(feed_index,))
		result = self.c.fetchall()
		
		if result=="":
			raise NoFeed, feed_index
		#result[1] = self.decode_text(result[1])
		return result

	def get_feedlist(self):
		
		self.c.execute("""SELECT id,title FROM feeds ORDER BY UPPER(title)""")
		result = self.c.fetchall()
		dataList = []
		if result: 
			dataList = [list(row) for row in result]
		else:
			result=[]
#		for item in dataList:
#			item[1] = self.decode_text(item[1])
		
		return dataList
		
	def get_feed_title(self, feed_index):
		
		self.c.execute("""SELECT title FROM feeds WHERE id=?""",(feed_index,))
		try:
			result = self.c.fetchone()[0]
		except TypeError:
			
			raise NoFeed, feed_index	
		
		#don't return a tuple
		return result #self.decode_text(result)
		
	def set_feed_name(self, feed_id, name):
		name = self.encode_text(name)
		
		if name is not None:
			self.c.execute(u'UPDATE feeds SET title=? WHERE id=?',(name,feed_id))
			self.db.commit()
		else:
			self.c.execute("""SELECT url FROM feeds WHERE id=?""",(feed_id,))
			url=self.c.fetchone()[0]
			
			try:
				feedparser.disableWellFormedCheck=1
				data = feedparser.parse(url)
			except:
				return
			channel=data['channel']
			print channel
			if channel.has_key('title') == 0:
				if channel['description'] != "":
					channel['title']=channel['description']
				else:
					channel['title']=url
			channel['title'] = self.encode_text(channel['title'])
			
			self.c.execute(u'UPDATE feeds SET title=? WHERE id=?',(channel['title'],feed_id))
			self.db.commit()
				
	def set_media_download_status(self, media_id, status):
		self.c.execute(u'UPDATE media SET download_status=? WHERE id=?', (status,media_id,))
		self.db.commit()
		
	def set_media_filename(self, media_id, filename):
		self.c.execute(u'UPDATE media SET file=? WHERE id=?', (filename,media_id))
		self.db.commit()
		
	def set_media_viewed(self, media_id, viewed=1):
		self.c.execute(u'UPDATE media SET viewed=? WHERE id=?',(int(viewed),media_id))
		self.db.commit()
	
	def set_media_size(self, media_id, size):
		self.c.execute(u'UPDATE media SET length=? WHERE id=?',(int(size),media_id))
		self.db.commit()
		
	def set_entry_new(self, entry_id, new):
		self.c.execute(u'UPDATE entries SET new=? WHERE id=?',(int(new),entry_id))
		self.db.commit()
		
	def set_entry_read(self, entry_id, read):
		self.c.execute(u'UPDATE entries SET read=? WHERE id=?',(int(read),entry_id))
		self.db.commit()
		
	def get_entry_read(self, entry_id):
		self.c.execute(u'SELECT read FROM entries WHERE id=?',(entry_id,))
		retval = self.c.fetchone()[0]
		return int(retval)
		
	def clean_media_status(self):
		self.c.execute(u'UPDATE media SET download_status=0 WHERE download_status<1')
		self.db.commit()
		self.c.execute(u'UPDATE media SET download_status=3 WHERE download_status=1')
		self.db.commit()
		
	def get_entryid_for_media(self, media_id):
		self.c.execute(u'SELECT entry_id FROM media WHERE id=?',(media_id,))
		ret = self.c.fetchone()
		return ret[0]
		
	def get_media_for_download(self):
		self.c.execute(u'SELECT media.id, media.length, media.entry_id FROM media, entries WHERE (download_status==0 OR download_status==3) AND viewed=0 AND media.entry_id = entries.id')
		list=self.c.fetchall()
		self.c.execute(u'SELECT media.id, media.length, media.entry_id FROM media, entries WHERE download_status==-1 AND media.entry_id = entries.id')
		list=list+self.c.fetchall()
		newlist=[]
		for item in list:
			new_item = (item[0],int(item[1]),item[2])
			newlist.append(new_item)
		return newlist 
		
	def get_unplayed_media_set_viewed(self):
		self.c.execute(u'SELECT media.id, media.entry_id, media.file FROM media, entries WHERE download_status=2 AND viewed=0 AND media.entry_id = entries.id')
		list=self.c.fetchall()
		playlist=[]
		for item in list:
			self.c.execute(u'UPDATE media SET viewed=1 WHERE id=?',(item[0],))
			self.c.execute(u'UPDATE entries SET new=0 WHERE id=?',(item[1],))		
			self.c.execute(u'UPDATE entries SET read=1 WHERE id=?',(item[1],))					
			playlist.append(item[2])
		self.db.commit()
		return playlist 
	
	#def get_media_download_status(self, media_id):
	#	
	#	self.c.execute(u'SELECT download_status FROM media WHERE id=?', (media_id,))
	#	
	#	return int(self.c.fetchone()[0])
		
	def get_entry_download_status(self, entry_id):
		self.c.execute(u'SELECT media.download_status, media.viewed FROM media,entries WHERE media.entry_id=entries.id AND media.download_status!=0 AND entries.id=?',(entry_id,))
		result = self.c.fetchall()
		#if entry_id==262:
		#	print result
		
		if result: 
			dataList = [list(row) for row in result]
		else:
			return 0
	#	if entry_id==262:
	#		print datum
		for datum in dataList:
			val = int(datum[0])
			if val==1:
				return 1
			if val==-1:
				return -1
			if val==3:
				return 3
		return 2		
		
	def get_feed_download_status(self, feed_id):
		entrylist = self.get_entrylist(feed_id)
		for entry in entrylist:
			status = self.get_entry_download_status(entry[0])
			if status!=0:
				return status
		return 0
		
	def get_entry_flags(self, entry_id):
		printstuff=0
		#if entry_id==262:
		#	printstuff=1
		importance=0
		status = self.get_entry_download_status(entry_id)
		
		self.c.execute(u'SELECT new,read FROM entries WHERE id=?',(entry_id,))
		temp = self.c.fetchone()
		new=temp[0]
		read=temp[1]
		
			
		medialist = self.get_entry_media(entry_id)
		
		if status==-1:
			importance=importance+F_ERROR
		if status==1:
			importance=importance+F_DOWNLOADING		
		if new==1:
			importance=importance+F_NEW
				
		if medialist:	
			importance=importance+F_MEDIA
			if status==2:
				importance=importance+F_DOWNLOADED
			elif status==3:
				importance=importance+F_PAUSED
			for medium in medialist:
				if medium['viewed']==0:
					importance=importance+F_UNVIEWED
		else:
			if int(read)==0:
				importance=importance+F_UNVIEWED
		
		#print "total: "+str(importance)
		return importance		
		
	def get_unread_count(self, feed_id):
		self.c.execute(u'SELECT read FROM entries WHERE feed_id=?',(feed_id,))
		list = self.c.fetchall()
		unread=0
		for item in list:
			if item[0]==0:
				unread=unread+1
		return unread
		
	def DEBUG_correct_feed(self, feed_id):
		self.c.execute(u'SELECT media.download_status, media.viewed, media.entry_id, media.id FROM media,entries WHERE media.entry_id=entries.id AND media.download_status!=0 AND entries.feed_id=?',(feed_id,))
		media = self.c.fetchall()
		for item in media:
			self.set_entry_read(item[2],item[1])
		
	def get_important_flag(self, feed_id):
		self.c.execute(u'SELECT media.download_status, media.viewed, media.entry_id FROM media,entries WHERE media.entry_id=entries.id AND entries.feed_id=?',(feed_id,))
		media = self.c.fetchall()
		self.c.execute(u'SELECT new,read,id FROM entries WHERE feed_id=?',(feed_id,))
		entries = self.c.fetchall()
		feed_has_media=0
		flaglist = []
		
		for entry in entries:
			flag = 0
			download_status = 0
			entry_has_media = 0
			for medium in media:
				if medium[2] == entry[2]: #media.entry_id == entry.id
					entry_has_media=1
					media
					if medium[0] == 1: #download_status
						download_status = 1
						break
					if medium[0] == -1:
						download_status = -1
						break
					if medium[0] == 3:
						download_status = 3
						break
					if medium[0] == 2:
						feed_has_media=1
						download_status=2 #no break
			
			if download_status==-1:
				flag=flag+F_ERROR
			elif download_status==1:
				flag=flag+F_DOWNLOADING
			if entry[0]==1: #new
				flag=flag+F_NEW
			
			if entry_has_media==1:
				flag=flag+F_MEDIA
				if download_status==2:
					flag=flag+F_DOWNLOADED
				elif download_status==3:
					flag=flag+F_PAUSED
				for medium in media:
					if medium[1] == 0: #viewed
						flag=flag+F_UNVIEWED
						break
			else:
				if entry[1]==0: #read
					flag=flag+F_UNVIEWED
			
			flaglist.append(flag)
		
		if len(flaglist)==0:
			return 0
		flaglist.sort()
		best_flag = flaglist[-1]
		
		if best_flag & F_DOWNLOADED == 0 and feed_has_media==1:
			return best_flag + F_DOWNLOADED
		else:
			return best_flag
		
	def export_OPML(self,stream):
		self.c.execute(u'SELECT title, description, url FROM feeds ORDER BY UPPER(title)')
		result = self.c.fetchall()
		dataList = []
		if result: 
			dataList = [list(row) for row in result]
		else:
			return
		
		o = OPML.OPML()
		o['title']='All'
		for feed in result:
			item = OPML.Outline()
			item['title']=feed[0]
			item['text']=feed[0]
			item['description']=feed[1]
			item['xmlUrl']=feed[2]
			o.outlines.append(item)
		o.output(stream)
		stream.close()
		
	def import_OPML(self, stream):
		p = OPML.parse(stream)
		for o in p.outlines:
			try:
				print "ok I would be inserting here"
				self.insertURL(o['xmlUrl'])
			except:
				pass
		stream.close()
				
	def DEBUG_get_full_feedlist(self):
		self.c.execute("""SELECT id,title,url FROM feeds ORDER BY id""")
		result = self.c.fetchall()
		return result
		
	def encode_text(self,text):
		try:
			return text.encode('utf8')
		except AttributeError:
			return u''
	
	#def decode_text(self,text):
		#return unicode(text)
	
class NoFeed(Exception):
	def __init__(self,feed):
		self.feed = feed
	def __str__(self):
		return "No such feed: "+self.feed
		
class NoEntry(Exception):
	def __init__(self,entry):
		self.entry = entry
	def __str__(self):
		return "No such entry: "+self.entry
		
class NoSetting(Exception):
	def __init__(self,setting):
		self.setting = setting
	def __str__(self):
		return "No such entry: "+self.setting
		
class NoUser(Exception):
	def __init__(self,user):
		self.user = user
	def __str__(self):
		return "No such user: "+self.user
		
class DBError(Exception):
	def __init__(self,error):
		self.error = error
	def __str__(self):
		return "Error connecting to database: "+self.error
