# Written by Owen Williams
# see LICENSE for license information

import ptvDB
import pycurl
from types import *
import ThreadPool
import time
import os
import glob
import BTDownloader
from utils import format_size

import utils

import gnome
#this isn't going to work right now, it only notifies when download is complete

class MediaManager:
	def __init__(self, progress_callback=None, finished_callback=None):
		self.index=0
		self.pool = ThreadPool.ThreadPool(5)
		self.db = ptvDB.ptvDB()
		self.time_appendix=0
		self.bt_settings = {}
		self.id_time=0
		self.quitting = False
		if finished_callback:
			self.pool_finished_callback = finished_callback
		else:
			self.pool_finished_callback = self._basic_finished_callback
			
		if progress_callback:
			self.pool_progress_callback = progress_callback
		else:
			self.pool_progress_callback = self._basic_progress_callback	
		try:
			home=os.getenv('HOME')
			os.stat(home+'/.penguintv/media')
		except:
			try:
				os.mkdir(home+'/.penguintv/media')
			except:
				raise NoDir, "error creating " +home+'/.penguintv/media'
		self.media_dir = home+'/.penguintv/media'
	
	def finish(self):
		self.quitting = True
		self.pool.joinAll()
		del self.pool
		
	def __del__(self):
		self.finish()
		
	def set_bt_settings(self, bt_settings):
		self.bt_settings = bt_settings
		
	def get_id(self):
		cur_time = int(time.time())
		
		if self.id_time == cur_time:
			self.time_appendix = self.time_appendix+1
		else:
			self.id_time = cur_time
			self.time_appendix=0
		
		return str(self.id_time)+"+"+str(self.time_appendix)
		
	def show_downloads(self):
		gnome.url_show("file://"+self.media_dir+"/"+utils.get_dated_dir())
		
	def download_entry(self, entry_id, queue=False, resume=False):
		"""queues a download
		 will interact with bittorrent python
	   use btlaunchmany code to write our own downloader
		 just need to change init funcs, hijack status funcs, add cancelling"""
		media_list = self.db.get_entry_media(entry_id)
		files=""
		if len(media_list)==0:
			return
		for media in media_list:
			self.download(media['media_id'], queue, resume)
			
	def download(self, media_id, queue=False, resume=False):
		"""queues a download"""
		media = self.db.get_media(media_id)
		media['downloader_index']=self.index
		media['download_status']=1			
		if media['file'] is None:
			filename = os.path.basename(media['url'])
			filen, ext = os.path.splitext(filename)
			ext = ext.split('?')[0] #grrr lugradio...
			media['file']=self.media_dir+"/"+utils.get_dated_dir()+"/"+filen+"-"+self.get_id()+ext
		else:
			dated_dir = os.path.split(os.path.split(media['file'])[0])[1]
			try: #make sure
				os.stat(self.media_dir+"/"+dated_dir)
			except:
				os.mkdir(self.media_dir+"/"+dated_dir)
			if resume==False:
				self.db.delete_media(media_id)
			#else:
			#	print "resuming using existing filename: "+str(media['file'])
		extension = media['url'][media['url'].rfind(".")+1:]
		if extension.upper()=="TORRENT":
			params = [
				'--minport', str(self.bt_settings['min_port']),
				'--maxport', str(self.bt_settings['max_port']),
				'--max_upload_rate', str(self.bt_settings['ul_limit'])]
				
			downloader = BTDownloader.BTDownloader(media, params, self.pool_progress_callback,self.pool_finished_callback, queue)
			self.pool.queueTask(downloader.download)
			pass
		else:
			downloader = self._downloader(media, self.pool_progress_callback, resume)
			self.pool.queueTask(downloader.download,queue,self.pool_finished_callback)
		self.db.set_media_download_status(media['media_id'],1)
		#self.db.set_media_viewed(media['media_id'],False)
		self.db.set_media_filename(media['media_id'],media['file'])
		self.index=self.index+1
		
	def bt_progress_callback(self, data):
		if self.quitting == True:
			return 1
		self.pool_progress_callback(data)
		
	class _downloader:
		"""Need a little internal class to keep track of callbacks from urllib.urlretrieve"""
		def __init__(self, media, progress_callback, resume=False):
			self.media = media
			self.progress_callback = progress_callback
			self.resume = resume
			
		def download(self, queue=False):
			db = ptvDB.ptvDB()
			try:
				os.makedirs(os.path.dirname(self.media['file']))
			except OSError:
				pass
			try:
				if self.resume:
					try:
						fp = open(self.media['file'], "ab")
					except:
						fp = open(self.media['file'], "wb")
				else:
					fp = open(self.media['file'], "wb")
				curl = pycurl.Curl()
				curl.setopt(pycurl.URL, str(self.media['url'])) #cause it's unicode or some shit which is not a string or some junk
				curl.setopt(pycurl.FOLLOWLOCATION, 1)
				curl.setopt(pycurl.MAXREDIRS, 5)
				curl.setopt(pycurl.CONNECTTIMEOUT, 30)
				#curl.setopt(pycurl.TIMEOUT, 300)
				curl.setopt(pycurl.NOSIGNAL, 1)
				curl.setopt(pycurl.WRITEDATA, fp)
				curl.setopt(pycurl.PROGRESSFUNCTION, self.wrap_progress_callback)
				curl.setopt(pycurl.NOPROGRESS, 0)
				curl.setopt(pycurl.USERAGENT,'PenguinTV '+utils.VERSION)
				if self.resume:
					#print os.stat(self.media['file'])
					cursize = os.stat(self.media['file'])[6]
					#print "current size "+str(cursize)
					curl.setopt(pycurl.RESUME_FROM_LARGE, cursize)
				curl.perform()
				curl.close()
				fp.close()
			except Exception, data:
				if data[0]==33: #if server doesn't support resuming, retry
					print data
					print "retrying without resume"
					self.resume=False
					return self.download(queue)
				print "some downloading error "+str(data)
				self.media['errormsg']=data
				return(self.media,0,data)
			if queue:
				return (self.media, 2,"finished downloading "+self.media['file'])
			return (self.media, 1,"finished downloading "+self.media['file'])
			
		def wrap_progress_callback(self, dl_total, dl_now, ul_total, ul_now):
			try:
				progress = int((dl_now*100.0)/dl_total)
			except:
				progress = 0
			result = self.progress_callback((self.media,progress,"Downloaded "+str(progress)+"% of "+format_size(self.media['size'])))
			return result
			
	def _basic_finished_callback(self, data):
		filename = data[0]['file']
		info = data[1:]
		print filename+" "+str(info)
			
	def _basic_progress_callback(self, data):
		media, blocks, blocksize, totalsize=data
		percent = (blocks*blocksize*100) / totalsize
		if percent>100:
			percent = 100
		if percent%10 == 0:
			print media['file']+" "+str(percent)+"%"
	
	def cancel_download(self, media_id):
		#find the thread with the right media_id
		#let it DIE
		pass
	
	def pause_download(self, media_id):
		#can't do right now
		pass
		
	def get_disk_usage(self):
		size = 0
		try:
			#filelist = glob.glob(self.media_dir+"/*")
			for f in utils.GlobDirectoryWalker(self.media_dir+"/"):
				size = size+os.stat(f)[6]
		except:
			pass
		return size
		
	def generate_playlist(self):
		dated_dir = utils.get_dated_dir()
		try:
			os.stat(self.media_dir+"/"+dated_dir)
		except:
			os.mkdir(self.media_dir+"/"+dated_dir)
		f = open(self.media_dir+"/"+dated_dir+"/playlist.m3u",'w')
		f.write('#EXTM3U\n')
		
		for item in glob.glob(self.media_dir+"/"+dated_dir+"/*"):
			filename = os.path.split(item)[1]
			if filename != "playlist.m3u":
				f.write(filename+"\n")
		f.close()
		
	def update_playlist(self, media):
		"""Adds media to the playlist in its directory"""
		
		try:
			os.stat(media['file'])
		except:
			return
			
		dated_dir = os.path.split(os.path.split(media['file'])[0])[1]
			
		try:
			os.stat(self.media_dir+"/"+dated_dir+"/playlist.m3u")
			f = open(self.media_dir+"/"+dated_dir+"/playlist.m3u",'a')
		except:
			f = open(self.media_dir+"/"+dated_dir+"/playlist.m3u",'w')
			f.write('#EXTM3U\n')
		
		f.write(os.path.split(media['file'])[1]+"\n")
		f.close()

class NoDir(Exception):
	def __init__(self,durr):
		self.durr = durr
	def __str__(self):
		return "no such directory: "+self.durr
