/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/extract.cc
 *******************************************/

#include "extract.hh"

/*** Constructor ***/
class_window_tools_extract::class_window_tools_extract() :
vbox_window(false, 5),
hbox_sourcefile(false, 5),
frame_sourcefile(Text::str_SOURCE_FILE),
button_sourcefile(Gtk::Stock::ADD),
button_save(Gtk::Stock::SAVE),
alignment_save(Gtk::ALIGN_CENTER, Gtk::ALIGN_CENTER, 0.0, 0.0){
	
	// Signal Handlers
	button_save.signal_clicked().connect(sigc::mem_fun(*this, &class_window_tools_extract::on_button_save));
	button_sourcefile.signal_clicked().connect(sigc::mem_fun(*this, &class_window_tools_extract::on_button_sourcefile));
	
	// Window
	set_title(Text::str_EXTRACT_ATTACHMENTS);
	set_default_size(600, -1);
	set_border_width(0);
	set_position(Gtk::WIN_POS_CENTER);
	//set_resizable(false);
	//set_keep_above(true); 
	
	// Widgets
	button_sourcefile.set_size_request(150,-1);
	button_save.set_size_request(150,-1);
	entry_sourcefile.set_editable(false);
	
	hbox_sourcefile.set_border_width(5);
	hbox_sourcefile.pack_start(entry_sourcefile, Gtk::PACK_EXPAND_WIDGET, 0);
	hbox_sourcefile.pack_start(button_sourcefile, Gtk::PACK_SHRINK      , 0);
	frame_sourcefile.add(hbox_sourcefile);
	
	hbox_save.pack_start(button_save, Gtk::PACK_SHRINK, 0);
	alignment_save.add(hbox_save);
	
	vbox_window.set_border_width(5);
	vbox_window.pack_start(frame_sourcefile, Gtk::PACK_SHRINK, 0);
	vbox_window.pack_start(alignment_save,   Gtk::PACK_SHRINK, 0);
	
	add(vbox_window);
	show_all_children();
	
	return;
}



/*** On Button -> Sourcefile ***/
void class_window_tools_extract::on_button_sourcefile(){
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_OPEN, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		entry_sourcefile.set_text(filename);
	}
	
	return;
}



/*** On Button Save ***/
void class_window_tools_extract::on_button_save(){
	
	// Check Errors -> No Source File
	if(entry_sourcefile.get_text() == ""){
		
		// Error Messages
		pt_dialogs->error_cerr("calss_window_tools_extract::on_button_save()", Text::err_NO_SOURCE_FILE, Text::err_msg_EXIT_FUNCTION);
		pt_dialogs->error_message(this, Text::str_EXTRACT_ATTACHMENTS, Text::err_NO_SOURCE_FILE);
		return;
	}
	
	Glib::ustring command;
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_FOLDER, Pdfchain::FILE_FILTER_ANY, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring foldername = filechooser.run();
	
	if(foldername != ""){
		
		// Create Command
		command += Command::cmd_PDFTK + Command::cmd_SPACE;
		command += quote_out(entry_sourcefile.get_text());
		command += Command::cmd_UNPACK_FILES + Command::cmd_OUTPUT + Command::cmd_SPACE;
		command += quote_out(foldername);
		command += Command::cmd_SLASH;
		
		// Execute Command
		execute(this, command);
	}
	
	return;
}



/*** Set Dialog ***/
void class_window_tools_extract::set_dialogs(class_dialogs* dialogs){
	
	pt_dialogs = dialogs;
	return;
}



/*** Clear ***/
void class_window_tools_extract::clear(){
	
	hide();
	entry_sourcefile.set_text("");
	
	return;
}
