##########################################################################################
## pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format     ##
## Copyright (C) 2002  Farokh Jamalyaria                                                ##
##                                                                                      ##
## This program is free software; you can redistribute it and/or                        ##
## modify it under the terms of the GNU General Public License                          ##
## as published by the Free Software Foundation; either version 2                       ##
## of the License, or (at your option) any later version.                               ##
##                                                                                      ##
## This program is distributed in the hope that it will be useful,                      ##
## but WITHOUT ANY WARRANTY; without even the implied warranty of                       ##
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                        ##
## GNU General Public License for more details.                                         ##
##                                                                                      ##
## You should have received a copy of the GNU General Public License                    ##
## along with this program; if not, write to the Free Software                          ##
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.          ##
##                                                                                      ##
## Author's contact information:                                                        ##
## Farokh Jamalyaria, farokhj@yahoo.com                                                 ##
## 9 Commons Lobby G222                                                                 ##
## College Station, TX 77840                                                            ##
##########################################################################################

#!/usr/bin/perl

## This is a wrapper for the pdb2dhl C++ program.
## It runs pdb2dhl and uses its raw output to
## produce an ECEPPAK input file.

## 2 choices of command-line parameters:
## 1)<file>.pdb <dir> <cpp-ofile> <N-term> <C-term> <pl_ofile>
## OR
## 2)<pl_ifile>

## If option 1 is chosen, a pl_ifile (named "pl_ifile")
## and supporting files will be automatically generated during
## the conversion.
## Option 2 also performs a conversion, this time assuming
## an already-existing pl_ifile.

## The generated cpp-infile will contain the line:
## <file>.pdb <dir> <cpp-ofile> <N-term> <C-term>

## <dir> is the direction in which the pdb file is read.
## <dir> can be 'f' or 'b' (forward or backward). The file
## must be read in the N to C direction.

## <N-term> is an ECEPPAK endgrp. See pdb2dhl source code for
## details. '0' will force the program to use the default
## group:  H2N

## <C-term>: Discussion is symmetrical to previous. '0' will force
## pdb2dhl to use default group CXH.

## <pl-ofile> will be the prefix of the ECEPPAK input file.
## <cpp-ofile> will be the prefix of pdb2dhl's output files' names.

### NOTE: You may have to modify the system calls to run this
### script on your computer.

$ARGC = @ARGV;                          ## store array length

if($ARGC == 1){
  $pl_inf = $ARGV[0];
  open(IN,$pl_inf) || die "Cannot open $pl_inf";
  $_ = <IN>;                            ## read line into variable $_.

  @ARGV = split(/\s+/, $_);             ## split line into words at whitespace.
  close(IN) || die "Cannot close $pl_inf";

  system("rm -f cpp_ifile");
  open (OUT,">>cpp_ifile") || die "Cannot create cpp_ifile";

}
elsif($ARGC == 6){
  system("rm -f cpp_ifile");
  open (OUT,">>cpp_ifile") || die "Cannot create cpp_ifile";
  system("rm -f pl_ifile");
  open (OUT2, ">>pl_ifile") || die "Cannot create pl_ifile";
  print OUT2 $ARGV[0]; print OUT2 " "; print OUT2 $ARGV[1]; print OUT2 " ";
  print OUT2 $ARGV[2]; print OUT2 " "; print OUT2 $ARGV[3]; print OUT2 " ";
  print OUT2 $ARGV[4]; print OUT2 " "; print OUT2 $ARGV[5];
  close(OUT2) || die "Cannot close pl_ifile";
}
else{
  die "Wrong number of command-line arguments; see instructions in pdb2epk.pl";
}

print OUT $ARGV[0]; print OUT " "; print OUT $ARGV[1]; print OUT " ";
print OUT $ARGV[2]; print OUT " "; print OUT $ARGV[3]; print OUT " ";
print OUT $ARGV[4];
close(OUT) || die "Cannot close infile";
system("./pdb2dhl < cpp_ifile");

## Construct input filenames:
$inp = $ARGV[2] . ".inp";
$seq = $ARGV[2] . ".seq";

$ARGV[5] = $ARGV[5] . ".inp";
system("rm -f $ARGV[5]");

$ARGV[5] = ">>" . $ARGV[5];
open (OUT,$ARGV[5]) || die "Cannot open $ARGV[5]";

##########################################################################
## Users can modify the following text portions to fulfill current needs.

print OUT
"\$CNTRL
RES_CODE=THREE_LETTER
runtyp = energy
PRINT_CART
OUTFORMAT = PDB
 FILE = 1GCN.ecpk
\$END

\$SEQ\n";

$fh = select(OUT);
$| = 1;
select($fh);

system("cat $seq $ARGV[5]");

print OUT
"\n\$END

\$GEOM\n";

$fh = select(OUT);
$| = 1;
select($fh);

system("cat $inp $ARGV[5]");

print OUT "\$END";

close(OUT) || die "can't close output file";

