patcherize
==========


  - connections to the containing patch will be kept (via inlets/outlets)
  - objects will keep their internal state

# Usage
- Select the objects you want to turn into a subpatch
- Press <kbd>Control</kbd>+<kbd>Shift</kbd>+<kbd>p</kbd> to turn the selected
  objects into a subpatch.
- the selection will be replaced by a subpatch `[pd /*patcherized*/]`
- Alternatively, you can do this via the Menu: `Edit` -> `(Sub)patcherize Selection`

You can also create an abstraction from the selection:
- Select the objects you want to turn into a subpatch
- Use the menu: `Edit` -> `Patcherize selection...`
- a "Save As..." menu will appear, asking you where you want to save the
  patcherized selection (e.g. pick "foo.pd")
- The selection will be replaced by an abstraction for the said name (e.g.
  `[foo]`).
- If you saved the abstraction outside Pd's search path, the abstraction will be
  instantiated with its full name (e.g. `[/home/frodel/foo]`)

# Installation

## Building
Build the external:

    make

If you have an unusual setup (and/or your Pd installation is at a place not
found by the compiler), you can parameterize the build. Try this first:

    make help


## Installing
Put both the externals (`patcherize.pd_linux` or similar) and the GUI plugin
(`patcherize-plugin.tcl`) into a directory `patcherize-plugin`, and put that
into a place where Pd can find it.

     make install

E.g.

    $ ~/.local/lib/pd/extra/patcherize-plugin/
    ~/.local/lib/pd/extra/patcherize-plugin/patcherize.pd_linux
    ~/.local/lib/pd/extra/patcherize-plugin/patcherize-plugin.tcl

# BUGS

## Pd crashes when clicking on a patcherized msgbox
Yes.
Patcherization does not re-instantiate any object (or msgbox).
Instead it just "moves" the selection to the new window, basically leaving
the object unaware that it's context has changed.

When clicking on the 'msgbox', the "flashing effect" will try to talk to the
wrong window, resulting in a crash.

This could be fixed by doing a Cut-n-Paste instead of sleekily migrating the
objects, but this would result in objects losing their inner state (not a
problem for a msgbox, that doesn't have any hidden inner state)

## GUI objects do not respond after being patcherized
See above: the reason for this behaviour is the same (albeit less drastic) than
the crashing msgbox.
Unfortunately, generic GUI objects might (and most probably) will have a hidden
inner state - which is the reason why i would rather not go the safe Cut-n-Paste
route.

# AUTHORS

IOhannes m zmölnig

# LICENSE
`patcherize` is released under the Gnu GPL version 2 (or later).
See LICENSE.md for the full text of the GPLv2.

## Special license grant to Miller Puckette
I hereby grant Miller S. Puckette the exclusive right to include
`patcherize` into Pure Data (Pd) under the BSD 3-clause license under
which Pd is currently released.

Once it has been included into Pd it is of course re-distributable under
that license. Until then, the Gnu GPL v2 (or later) applies.
