# Change Log

## [0.9.159] - 2017-06-30

### Added
- Option to create a cluster with or without corosync encryption enabled,
  by default the encryption is disabled ([rhbz#1165821])
- It is now possible to disable, enable, unmanage and manage bundle resources
  and set their meta attributes ([rhbz#1447910])
- Pcs now warns against using the `action` option of stonith devices
  ([rhbz#1421702])

### Fixed
- Fixed crash of the `pcs cluster setup` command when the `--force` flag was
  used ([rhbz#1176018])
- Fixed crash of the `pcs cluster destroy --all` command when the cluster was
  not running ([rhbz#1176018])
- Fixed crash of the `pcs config restore` command when restoring pacemaker
  authkey ([rhbz#1176018])
- Fixed "Error: unable to get cib" when adding a node to a stopped cluster
  ([rhbz#1176018])
- Fixed a crash in the `pcs cluster node add-remote` command when an id
  conflict occurs ([rhbz#1386114])
- Fixed creating a new cluster from the web UI ([rhbz#1284404])
- `pcs cluster node add-guest` now works with the flag `--skipp-offline`
  ([rhbz#1176018])
- `pcs cluster node remove-guest` can be run again when the guest node was
  unreachable first time ([rhbz#1176018])
- Fixed "Error: Unable to read /etc/corosync/corosync.conf" when running
  `pcs resource create`([rhbz#1386114])
- It is now possible to set `debug` and `verbose` parameters of stonith devices
  ([rhbz#1432283])
- Resource operation ids are now properly validated and no longer ignored in
  `pcs resource create`, `pcs resource update` and `pcs resource op add`
  commands ([rhbz#1443418])
- Flag `--force` works correctly when an operation is not successful on some
  nodes durrng `pcs cluster node add-remote` or `pcs cluster node add-guest`
  ([rhbz#1464781])

### Changed
- Binary data are stored in corosync authkey ([rhbz#1165821])
- It is now mandatory to specify container type in the `resource bundle create`
  command
- When creating a new cluster, corosync communication encryption is disabled
  by default (in 0.9.158 it was enabled by default, in 0.9.157 and older it was
  disabled)

[rhbz#1165821]: https://bugzilla.redhat.com/show_bug.cgi?id=1165821
[rhbz#1176018]: https://bugzilla.redhat.com/show_bug.cgi?id=1176018
[rhbz#1284404]: https://bugzilla.redhat.com/show_bug.cgi?id=1284404
[rhbz#1386114]: https://bugzilla.redhat.com/show_bug.cgi?id=1386114
[rhbz#1421702]: https://bugzilla.redhat.com/show_bug.cgi?id=1421702
[rhbz#1432283]: https://bugzilla.redhat.com/show_bug.cgi?id=1432283
[rhbz#1443418]: https://bugzilla.redhat.com/show_bug.cgi?id=1443418
[rhbz#1447910]: https://bugzilla.redhat.com/show_bug.cgi?id=1447910
[rhbz#1464781]: https://bugzilla.redhat.com/show_bug.cgi?id=1464781


## [0.9.158] - 2017-05-23

### Added
- Support for bundle resources (CLI only) ([rhbz#1433016])
- Commands for adding and removing guest and remote nodes including handling
  pacemaker authkey (CLI only) ([rhbz#1176018], [rhbz#1254984], [rhbz#1386114],
  [rhbz#1386512])
- Command `pcs cluster node clear` to remove a node from pacemaker's
  configuration and caches
- Backing up and restoring cluster configuration by `pcs config backup` and
  `pcs config restore` commands now support corosync and pacemaker authkeys
  ([rhbz#1165821], [rhbz#1176018])

### Deprecated
- `pcs cluster remote-node add` and `pcs cluster remote-node remove `commands
  have been deprecated in favor of `pcs cluster node add-guest` and `pcs
  cluster node remove-guest` commands ([rhbz#1386512])

### Fixed
- Fixed a bug which under specific conditions caused pcsd to crash on start
  when running under systemd ([ghissue#134])
- `pcs resource unmanage` now sets the unmanaged flag to primitive resources
  even if a clone or master/slave resource is specified. Thus the primitive
  resources will not become managed just by uncloning. This also prevents some
  discrepancies between disabled monitor operations and the unmanaged flag.
  ([rhbz#1303969])
- `pcs resource unmanage --monitor` now properly disables monitor operations
  even if a clone or master/slave resource is specified. ([rhbz#1303969])
- `--help` option now shows help just for the specified command. Previously the
  usage for a whole group of commands was shown.
- Fixed a crash when `pcs cluster cib-push` is called with an explicit value of
  the `--wait` flag ([rhbz#1422667])
- Handle pcsd crash when an unusable address is set in `PCSD_BIND_ADDR`
  ([rhbz#1373614])
- Removal of a pacemaker remote resource no longer causes the respective remote
  node to be fenced ([rhbz#1390609])

### Changed
- Newly created clusters are set up to encrypt corosync communication
  ([rhbz#1165821], [ghissue#98])

[ghissue#98]: https://github.com/ClusterLabs/pcs/issues/98
[ghissue#134]: https://github.com/ClusterLabs/pcs/issues/134
[rhbz#1176018]: https://bugzilla.redhat.com/show_bug.cgi?id=1176018
[rhbz#1254984]: https://bugzilla.redhat.com/show_bug.cgi?id=1254984
[rhbz#1303969]: https://bugzilla.redhat.com/show_bug.cgi?id=1303969
[rhbz#1373614]: https://bugzilla.redhat.com/show_bug.cgi?id=1373614
[rhbz#1386114]: https://bugzilla.redhat.com/show_bug.cgi?id=1386114
[rhbz#1386512]: https://bugzilla.redhat.com/show_bug.cgi?id=1386512
[rhbz#1390609]: https://bugzilla.redhat.com/show_bug.cgi?id=1390609
[rhbz#1422667]: https://bugzilla.redhat.com/show_bug.cgi?id=1422667
[rhbz#1433016]: https://bugzilla.redhat.com/show_bug.cgi?id=1433016
[rhbz#1165821]: https://bugzilla.redhat.com/show_bug.cgi?id=1165821


## [0.9.157] - 2017-04-10

### Added
- Resources in location constraints now may be specified by resource name
  patterns in addition to resource names ([rhbz#1362493])
- Proxy settings description in pcsd configuration file ([rhbz#1315627])
- Man page for pcsd ([rhbz#1378742])
- Pcs now allows to set `trace_ra` and `trace_file` options of `ocf:heartbeat`
  and `ocf:pacemaker` resources ([rhbz#1421702])
- `pcs resource describe` and `pcs stonith describe` commands now show all
  information about the specified agent if the `--full` flag is used
- `pcs resource manage | unmanage` enables respectively disables monitor
  operations when the `--monitor` flag is specified ([rhbz#1303969])
- Support for shared storage in SBD. Currently, there is very limited support
  in web UI ([rhbz#1413958])

### Changed
- It is now possible to specify more than one resource in the `pcs resource
  enable` and `pcs resource disable` commands.

### Fixed
- Python 3: pcs no longer spams stderr with error messages when communicating
  with another node
- Stopping a cluster does not timeout too early and it generally works better
  even if the cluster is running Virtual IP resources ([rhbz#1334429])
- `pcs booth remove` now works correctly even if the booth resource group is
  disabled (another fix) ([rhbz#1389941])
- Fixed Cross-site scripting (XSS) vulnerability in web UI ([CVE-2017-2661],
  [rhbz#1434111])
- Pcs no longer allows to create a stonith resource based on an agent whose
  name contains a colon ([rhbz#1415080])
- Pcs command now launches Python interpreter with "sane" options (python -Es)
  ([rhbz#1328882])
- Clufter is now supported on both Python 2 and Python 3 ([rhbz#1428350])
- Do not colorize clufter output if saved to a file

[CVE-2017-2661]: https://access.redhat.com/security/cve/CVE-2017-2661
[rhbz#1303969]: https://bugzilla.redhat.com/show_bug.cgi?id=1303969
[rhbz#1315627]: https://bugzilla.redhat.com/show_bug.cgi?id=1315627
[rhbz#1328882]: https://bugzilla.redhat.com/show_bug.cgi?id=1328882
[rhbz#1334429]: https://bugzilla.redhat.com/show_bug.cgi?id=1334429
[rhbz#1362493]: https://bugzilla.redhat.com/show_bug.cgi?id=1362493
[rhbz#1378742]: https://bugzilla.redhat.com/show_bug.cgi?id=1378742
[rhbz#1389941]: https://bugzilla.redhat.com/show_bug.cgi?id=1389941
[rhbz#1413958]: https://bugzilla.redhat.com/show_bug.cgi?id=1413958
[rhbz#1415080]: https://bugzilla.redhat.com/show_bug.cgi?id=1415080
[rhbz#1421702]: https://bugzilla.redhat.com/show_bug.cgi?id=1421702
[rhbz#1428350]: https://bugzilla.redhat.com/show_bug.cgi?id=1428350
[rhbz#1434111]: https://bugzilla.redhat.com/show_bug.cgi?id=1434111


## [0.9.156] - 2017-02-10

### Added
- Fencing levels now may be targeted in CLI by a node name pattern or a node
  attribute in addition to a node name ([rhbz#1261116])
- `pcs cluster cib-push` allows to push a diff obtained internally by comparing
  CIBs in specified files ([rhbz#1404233], [rhbz#1419903])
- Added flags `--wait`, `--disabled`, `--group`, `--after`, `--before` into
  the command `pcs stonith create`
- Added commands `pcs stonith enable` and `pcs stonith disable`
- Command line option --request-timeout ([rhbz#1292858])
- Check whenever proxy is set when unable to connect to a node ([rhbz#1315627])

### Changed
- `pcs node [un]standby` and `pcs node [un]maintenance` is now atomic even if
  more than one node is specified ([rhbz#1315992])
- Restarting pcsd initiated from pcs is now a synchronous operation
  ([rhbz#1284404])
- Stopped bundling fonts used in pcsd GUI ([ghissue#125])
- In `pcs resource create` flags `--master` and `--clone` changed to keywords
  `master` and `clone`
- libcurl is now used for node to node communication

### Fixed
- When upgrading CIB to the latest schema version, check for minimal common
  version across the cluster ([rhbz#1389443])
- `pcs booth remove` now works correctly even if the booth resource group is
  disabled ([rhbz#1389941])
- Adding a node in a CMAN cluster does not cause the new node to be fenced
  immediately ([rhbz#1394846])
- Show proper error message when there is an HTTP communication failure
  ([rhbz#1394273])
- Fixed searching for files to remove in the `/var/lib` directory ([ghpull#119],
  [ghpull#120])
- Fixed messages when managing services (start, stop, enable, disable...)
- Fixed disabling services on systemd systems when using instances
  ([rhbz#1389501])
- Fixed parsing commandline options ([rhbz#1404229])
- Pcs does not exit with a false error message anymore when pcsd-cli.rb outputs
  to stderr ([ghissue#124])
- Pcs now exits with an error when both `--all` and a list of nodes is specified
  in the `pcs cluster start | stop | enable | disable` commands ([rhbz#1339355])
- built-in help and man page fixes and improvements ([rhbz#1347335])
- In `pcs resource create` the flag `--clone` no longer steals arguments from
  the keywords `meta` and `op` ([rhbz#1395226])
- `pcs resource create` does not produce invalid cib when group id is already
  occupied with non-resource element ([rhbz#1382004])
- Fixed misbehavior of the flag `--master` in `pcs resource create` command
  ([rhbz#1378107])
- Fixed tacit acceptance of invalid resource operation in `pcs resource create`
  ([rhbz#1398562])
- Fixed misplacing metadata for disabling when running `pcs resource create`
  with flags `--clone` and `--disabled` ([rhbz#1402475])
- Fixed incorrect acceptance of the invalid attribute of resource operation in
  `pcs resource create` ([rhbz#1382597])
- Fixed validation of options of resource operations in `pcs resource create`
  ([rhbz#1390071])
- Fixed silent omission of duplicate options ([rhbz#1390066])
- Added more validation for resource agent names ([rhbz#1387670])
- Fixed network communication issues in pcsd when a node was specified by an
  IPv6 address
- Fixed JS error in web UI when empty cluster status is received
  ([rhbz#1396462])
- Fixed sending user group in cookies from Python 3
- Fixed pcsd restart in Python 3
- Fixed parsing XML in Python 3 (caused crashes when reading resource agents
  metadata) ([rhbz#1419639])
- Fixed the recognition of the structure of a resource agent name that contains
  a systemd instance ([rhbz#1419661])

### Removed
- Ruby 1.8 and 1.9 is no longer supported due to bad libcurl support

[ghissue#124]: https://github.com/ClusterLabs/pcs/issues/124
[ghissue#125]: https://github.com/ClusterLabs/pcs/issues/125
[ghpull#119]: https://github.com/ClusterLabs/pcs/pull/119
[ghpull#120]: https://github.com/ClusterLabs/pcs/pull/120
[rhbz#1261116]: https://bugzilla.redhat.com/show_bug.cgi?id=1261116
[rhbz#1284404]: https://bugzilla.redhat.com/show_bug.cgi?id=1284404
[rhbz#1292858]: https://bugzilla.redhat.com/show_bug.cgi?id=1292858
[rhbz#1315627]: https://bugzilla.redhat.com/show_bug.cgi?id=1315627
[rhbz#1315992]: https://bugzilla.redhat.com/show_bug.cgi?id=1315992
[rhbz#1339355]: https://bugzilla.redhat.com/show_bug.cgi?id=1339355
[rhbz#1347335]: https://bugzilla.redhat.com/show_bug.cgi?id=1347335
[rhbz#1378107]: https://bugzilla.redhat.com/show_bug.cgi?id=1378107
[rhbz#1382004]: https://bugzilla.redhat.com/show_bug.cgi?id=1382004
[rhbz#1382597]: https://bugzilla.redhat.com/show_bug.cgi?id=1382597
[rhbz#1387670]: https://bugzilla.redhat.com/show_bug.cgi?id=1387670
[rhbz#1389443]: https://bugzilla.redhat.com/show_bug.cgi?id=1389443
[rhbz#1389501]: https://bugzilla.redhat.com/show_bug.cgi?id=1389501
[rhbz#1389941]: https://bugzilla.redhat.com/show_bug.cgi?id=1389941
[rhbz#1390066]: https://bugzilla.redhat.com/show_bug.cgi?id=1390066
[rhbz#1390071]: https://bugzilla.redhat.com/show_bug.cgi?id=1390071
[rhbz#1394273]: https://bugzilla.redhat.com/show_bug.cgi?id=1394273
[rhbz#1394846]: https://bugzilla.redhat.com/show_bug.cgi?id=1394846
[rhbz#1395226]: https://bugzilla.redhat.com/show_bug.cgi?id=1395226
[rhbz#1396462]: https://bugzilla.redhat.com/show_bug.cgi?id=1396462
[rhbz#1398562]: https://bugzilla.redhat.com/show_bug.cgi?id=1398562
[rhbz#1402475]: https://bugzilla.redhat.com/show_bug.cgi?id=1402475
[rhbz#1404229]: https://bugzilla.redhat.com/show_bug.cgi?id=1404229
[rhbz#1404233]: https://bugzilla.redhat.com/show_bug.cgi?id=1404233
[rhbz#1419639]: https://bugzilla.redhat.com/show_bug.cgi?id=1419639
[rhbz#1419661]: https://bugzilla.redhat.com/show_bug.cgi?id=1419661
[rhbz#1419903]: https://bugzilla.redhat.com/show_bug.cgi?id=1419903


## [0.9.155] - 2016-11-03

### Added
- Show daemon status in `pcs status` on non-systemd machines
- SBD support for cman clusters ([rhbz#1380352])
- Alerts management in pcsd ([rhbz#1376480])

### Changed
- Get all information about resource and stonith agents from pacemaker. Pcs now
  supports the same set of agents as pacemaker does. ([rhbz#1262001],
  [ghissue#81])
- `pcs resource create` now exits with an error if more than one resource agent
  matches the specified short agent name instead of randomly selecting one of
  the agents
- Allow to remove multiple alerts and alert recipients at once

### Fixed
- When stopping a cluster with some of the nodes unreachable, stop the cluster
  completely on all reachable nodes ([rhbz#1380372])
- Fixed pcsd crash when rpam rubygem is installed ([ghissue#109])
- Fixed occasional crashes / failures when using locale other than en\_US.UTF8
  ([rhbz#1387106])
- Fixed starting and stopping cluster services on systemd machines without
  the `service` executable ([ghissue#115])


[ghissue#81]: https://github.com/ClusterLabs/pcs/issues/81
[ghissue#109]: https://github.com/ClusterLabs/pcs/issues/109
[ghissue#115]: https://github.com/ClusterLabs/pcs/issues/115
[rhbz#1262001]: https://bugzilla.redhat.com/show_bug.cgi?id=1262001
[rhbz#1376480]: https://bugzilla.redhat.com/show_bug.cgi?id=1376480
[rhbz#1380352]: https://bugzilla.redhat.com/show_bug.cgi?id=1380352
[rhbz#1380372]: https://bugzilla.redhat.com/show_bug.cgi?id=1380372
[rhbz#1387106]: https://bugzilla.redhat.com/show_bug.cgi?id=1387106


## [0.9.154] - 2016-09-21
- There is no change log for this and previous releases. We are sorry.
- Take a look at git history if you are interested.
