/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUMBER = 258,
     CHAR_CONST = 259,
     FLOAT = 260,
     STRING = 261,
     T_FILEVERSION = 262,
     T_PCB = 263,
     T_LAYER = 264,
     T_VIA = 265,
     T_RAT = 266,
     T_LINE = 267,
     T_ARC = 268,
     T_RECTANGLE = 269,
     T_TEXT = 270,
     T_ELEMENTLINE = 271,
     T_ELEMENT = 272,
     T_PIN = 273,
     T_PAD = 274,
     T_GRID = 275,
     T_FLAGS = 276,
     T_SYMBOL = 277,
     T_SYMBOLLINE = 278,
     T_CURSOR = 279,
     T_ELEMENTARC = 280,
     T_MARK = 281,
     T_GROUPS = 282,
     T_STYLES = 283,
     T_POLYGON = 284,
     T_NETLIST = 285,
     T_NET = 286,
     T_CONN = 287,
     T_AREA = 288,
     T_THERMAL = 289,
     T_DRC = 290,
     T_ATTRIBUTE = 291
   };
#endif
#define NUMBER 258
#define CHAR_CONST 259
#define FLOAT 260
#define STRING 261
#define T_FILEVERSION 262
#define T_PCB 263
#define T_LAYER 264
#define T_VIA 265
#define T_RAT 266
#define T_LINE 267
#define T_ARC 268
#define T_RECTANGLE 269
#define T_TEXT 270
#define T_ELEMENTLINE 271
#define T_ELEMENT 272
#define T_PIN 273
#define T_PAD 274
#define T_GRID 275
#define T_FLAGS 276
#define T_SYMBOL 277
#define T_SYMBOLLINE 278
#define T_CURSOR 279
#define T_ELEMENTARC 280
#define T_MARK 281
#define T_GROUPS 282
#define T_STYLES 283
#define T_POLYGON 284
#define T_NETLIST 285
#define T_NET 286
#define T_CONN 287
#define T_AREA 288
#define T_THERMAL 289
#define T_DRC 290
#define T_ATTRIBUTE 291




/* Copy the first part of user declarations.  */
#line 11 "parse_y.y"

/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

/* grammar to parse ASCII input of PCB description
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define GRIDFIT(x,g) (int)(0.5 + (int)(((x)+(g)/2.)/(g))*(g))
#include "global.h"
#include "create.h"
#include "data.h"
#include "error.h"
#include "file.h"
#include "mymem.h"
#include "misc.h"
#include "parse_l.h"
#include "polygon.h"
#include "remove.h"
#include "rtree.h"
#include "strflags.h"
#include "thermal.h"

#ifdef HAVE_LIBDMALLOC
# include <dmalloc.h> /* see http://dmalloc.com */
#endif

RCSID("$Id: parse_y.y,v 1.35 2006/12/15 06:15:33 djdelorie Exp $");

static	LayerTypePtr	Layer;
static	PolygonTypePtr	Polygon;
static	SymbolTypePtr	Symbol;
static	int		pin_num;
static	LibraryMenuTypePtr	Menu;
static	Boolean			LayerFlag[MAX_LAYER + 2];

extern	char			*yytext;		/* defined by LEX */
extern	PCBTypePtr		yyPCB;
extern	DataTypePtr		yyData;
extern	ElementTypePtr	yyElement;
extern	FontTypePtr		yyFont;
extern	int				yylineno;		/* linenumber */
extern	char			*yyfilename;	/* in this file */

static char *layer_group_string; 

static AttributeListTypePtr attr_list; 

int yyerror(const char *s);
int yylex();
static int check_file_version (int);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 92 "parse_y.y"
typedef union YYSTYPE {
	int		number;
	float		floating;
	char		*string;
	FlagType	flagtype;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 234 "parse_y.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 246 "parse_y.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   598

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  41
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  103
/* YYNRULES -- Number of rules. */
#define YYNRULES  191
/* YYNRULES -- Number of states. */
#define YYNSTATES  603

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   291

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      39,    40,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    37,     2,    38,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    12,    27,    28,
      31,    33,    34,    35,    38,    39,    44,    49,    56,    63,
      65,    67,    69,    71,    78,    86,    94,   102,   109,   116,
     123,   124,   125,   130,   131,   136,   137,   139,   141,   143,
     150,   158,   168,   173,   174,   179,   180,   185,   190,   191,
     193,   194,   196,   199,   201,   202,   205,   207,   209,   210,
     213,   215,   217,   219,   221,   223,   225,   237,   249,   260,
     270,   279,   290,   301,   302,   313,   315,   316,   318,   321,
     323,   325,   327,   329,   331,   333,   342,   344,   346,   348,
     349,   358,   369,   380,   390,   403,   416,   428,   437,   447,
     457,   459,   462,   467,   472,   473,   475,   477,   479,   481,
     483,   484,   497,   498,   514,   515,   532,   533,   552,   553,
     572,   574,   577,   579,   581,   583,   585,   587,   596,   605,
     616,   627,   633,   639,   640,   643,   645,   648,   650,   652,
     654,   656,   665,   674,   685,   696,   697,   700,   713,   726,
     737,   747,   756,   770,   784,   796,   807,   809,   811,   813,
     816,   817,   827,   828,   838,   840,   842,   844,   847,   849,
     851,   852,   861,   870,   872,   873,   880,   882,   883,   885,
     888,   889,   899,   901,   902,   904,   907,   912,   914,   917,
     923,   925
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
      42,     0,    -1,    43,    -1,    45,    -1,    48,    -1,     1,
      -1,    -1,    44,    50,    51,    52,    57,    58,    59,    60,
      64,    65,    66,    47,    67,   132,    -1,    -1,    46,    67,
      -1,    48,    -1,    -1,    -1,    49,   123,    -1,    -1,     7,
      37,     3,    38,    -1,     8,    39,     6,    40,    -1,     8,
      39,     6,     3,     3,    40,    -1,     8,    37,     6,     3,
       3,    38,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    20,    39,     3,     3,     3,    40,    -1,    20,    39,
       3,     3,     3,     3,    40,    -1,    20,    39,     5,     3,
       3,     3,    40,    -1,    20,    37,     5,     3,     3,     3,
      38,    -1,    24,    39,     3,     3,     3,    40,    -1,    24,
      37,     3,     3,     3,    38,    -1,    24,    37,     3,     3,
       5,    38,    -1,    -1,    -1,    33,    37,     5,    38,    -1,
      -1,    34,    37,     5,    38,    -1,    -1,    61,    -1,    62,
      -1,    63,    -1,    35,    37,     3,     3,     3,    38,    -1,
      35,    37,     3,     3,     3,     3,    38,    -1,    35,    37,
       3,     3,     3,     3,     3,     3,    38,    -1,    21,    39,
       3,    40,    -1,    -1,    27,    39,     6,    40,    -1,    -1,
      28,    39,     6,    40,    -1,    28,    37,     6,    38,    -1,
      -1,    68,    -1,    -1,    69,    -1,    68,    69,    -1,    72,
      -1,    -1,    70,   141,    -1,    78,    -1,    79,    -1,    -1,
      71,    96,    -1,     1,    -1,    73,    -1,    74,    -1,    75,
      -1,    76,    -1,    77,    -1,    10,    37,     3,     3,     3,
       3,     3,     3,     6,   122,    38,    -1,    10,    39,     3,
       3,     3,     3,     3,     3,     6,     3,    40,    -1,    10,
      39,     3,     3,     3,     3,     3,     6,     3,    40,    -1,
      10,    39,     3,     3,     3,     3,     6,     3,    40,    -1,
      10,    39,     3,     3,     3,     6,     3,    40,    -1,    11,
      37,     3,     3,     3,     3,     3,     3,   122,    38,    -1,
      11,    39,     3,     3,     3,     3,     3,     3,     3,    40,
      -1,    -1,     9,    39,     3,     6,   143,    40,    39,    80,
      81,    40,    -1,    82,    -1,    -1,    83,    -1,    82,    83,
      -1,    85,    -1,    86,    -1,    87,    -1,    88,    -1,    89,
      -1,    90,    -1,    14,    39,     3,     3,     3,     3,     3,
      40,    -1,    93,    -1,    92,    -1,    91,    -1,    -1,    29,
      39,   122,    40,    39,    84,    94,    40,    -1,    12,    37,
       3,     3,     3,     3,     3,     3,   122,    38,    -1,    12,
      39,     3,     3,     3,     3,     3,     3,     3,    40,    -1,
      12,    39,     3,     3,     3,     3,     3,     3,    40,    -1,
      13,    37,     3,     3,     3,     3,     3,     3,     3,     3,
     122,    38,    -1,    13,    39,     3,     3,     3,     3,     3,
       3,     3,     3,     3,    40,    -1,    13,    39,     3,     3,
       3,     3,     3,     3,     3,     3,    40,    -1,    15,    39,
       3,     3,     3,     6,     3,    40,    -1,    15,    39,     3,
       3,     3,     3,     6,     3,    40,    -1,    15,    37,     3,
       3,     3,     3,     6,   122,    38,    -1,    95,    -1,    94,
      95,    -1,    39,     3,     3,    40,    -1,    37,     3,     3,
      38,    -1,    -1,    97,    -1,    99,    -1,   101,    -1,   103,
      -1,   105,    -1,    -1,    17,    39,     6,     6,     3,     3,
       3,    40,    39,    98,   107,    40,    -1,    -1,    17,    39,
       3,     6,     6,     3,     3,     3,     3,     3,    40,    39,
     100,   107,    40,    -1,    -1,    17,    39,     3,     6,     6,
       6,     3,     3,     3,     3,     3,    40,    39,   102,   107,
      40,    -1,    -1,    17,    39,     3,     6,     6,     6,     3,
       3,     3,     3,     3,     3,     3,    40,    39,   104,   110,
      40,    -1,    -1,    17,    37,   122,     6,     6,     6,     3,
       3,     3,     3,     3,     3,   122,    38,    39,   106,   110,
      40,    -1,   108,    -1,   107,   108,    -1,   115,    -1,   116,
      -1,   117,    -1,   120,    -1,   121,    -1,    16,    37,     3,
       3,     3,     3,     3,    38,    -1,    16,    39,     3,     3,
       3,     3,     3,    40,    -1,    25,    37,     3,     3,     3,
       3,     3,     3,     3,    38,    -1,    25,    39,     3,     3,
       3,     3,     3,     3,     3,    40,    -1,    26,    37,     3,
       3,    38,    -1,    26,    39,     3,     3,    40,    -1,    -1,
     109,   141,    -1,   111,    -1,   110,   111,    -1,   114,    -1,
     113,    -1,   119,    -1,   118,    -1,    16,    37,     3,     3,
       3,     3,     3,    38,    -1,    16,    39,     3,     3,     3,
       3,     3,    40,    -1,    25,    37,     3,     3,     3,     3,
       3,     3,     3,    38,    -1,    25,    39,     3,     3,     3,
       3,     3,     3,     3,    40,    -1,    -1,   112,   141,    -1,
      18,    37,     3,     3,     3,     3,     3,     3,     6,     6,
     122,    38,    -1,    18,    39,     3,     3,     3,     3,     3,
       3,     6,     6,     3,    40,    -1,    18,    39,     3,     3,
       3,     3,     6,     6,     3,    40,    -1,    18,    39,     3,
       3,     3,     3,     6,     3,    40,    -1,    18,    39,     3,
       3,     3,     6,     3,    40,    -1,    19,    37,     3,     3,
       3,     3,     3,     3,     3,     6,     6,   122,    38,    -1,
      19,    39,     3,     3,     3,     3,     3,     3,     3,     6,
       6,     3,    40,    -1,    19,    39,     3,     3,     3,     3,
       3,     6,     6,     3,    40,    -1,    19,    39,     3,     3,
       3,     3,     3,     6,     3,    40,    -1,     3,    -1,     6,
      -1,   124,    -1,   123,   124,    -1,    -1,    22,    37,   127,
       3,    38,    39,   125,   128,    40,    -1,    -1,    22,    39,
     127,     3,    40,    39,   126,   128,    40,    -1,     3,    -1,
       4,    -1,   129,    -1,   128,   129,    -1,   130,    -1,   131,
      -1,    -1,    23,    39,     3,     3,     3,     3,     3,    40,
      -1,    23,    37,     3,     3,     3,     3,     3,    38,    -1,
     133,    -1,    -1,    30,    39,    40,    39,   134,    40,    -1,
     135,    -1,    -1,   136,    -1,   135,   136,    -1,    -1,    31,
      39,     6,     6,    40,    39,   137,   138,    40,    -1,   139,
      -1,    -1,   140,    -1,   139,   140,    -1,    32,    39,     6,
      40,    -1,   142,    -1,   141,   142,    -1,    36,    39,     6,
       6,    40,    -1,     6,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   115,   115,   116,   117,   118,   142,   142,   196,   196,
     215,   216,   221,   221,   260,   262,   294,   300,   306,   335,
     336,   337,   338,   341,   349,   362,   374,   406,   412,   418,
     424,   440,   442,   464,   466,   497,   499,   500,   501,   505,
     514,   524,   551,   555,   583,   587,   631,   639,   647,   651,
     652,   656,   657,   661,   662,   662,   663,   664,   666,   666,
     673,   677,   678,   679,   680,   681,   717,   726,   737,   747,
     757,   793,   798,   830,   829,   853,   854,   858,   859,   863,
     864,   865,   866,   867,   868,   870,   875,   876,   877,   880,
     879,   932,   940,   949,   997,  1005,  1014,  1051,  1061,  1079,
    1120,  1121,  1126,  1130,  1134,  1191,  1192,  1193,  1194,  1195,
    1203,  1202,  1221,  1220,  1239,  1238,  1259,  1257,  1280,  1278,
    1358,  1359,  1363,  1364,  1365,  1366,  1367,  1369,  1374,  1379,
    1384,  1389,  1394,  1399,  1399,  1403,  1404,  1408,  1409,  1410,
    1411,  1413,  1419,  1426,  1431,  1436,  1436,  1477,  1489,  1501,
    1512,  1528,  1582,  1596,  1609,  1620,  1631,  1632,  1636,  1637,
    1661,  1660,  1678,  1677,  1697,  1698,  1702,  1703,  1707,  1708,
    1709,  1730,  1737,  1753,  1754,  1758,  1763,  1764,  1768,  1769,
    1792,  1791,  1801,  1802,  1806,  1807,  1826,  1855,  1856,  1859,
    1867,  1868
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUMBER", "CHAR_CONST", "FLOAT", "STRING", 
  "T_FILEVERSION", "T_PCB", "T_LAYER", "T_VIA", "T_RAT", "T_LINE", 
  "T_ARC", "T_RECTANGLE", "T_TEXT", "T_ELEMENTLINE", "T_ELEMENT", "T_PIN", 
  "T_PAD", "T_GRID", "T_FLAGS", "T_SYMBOL", "T_SYMBOLLINE", "T_CURSOR", 
  "T_ELEMENTARC", "T_MARK", "T_GROUPS", "T_STYLES", "T_POLYGON", 
  "T_NETLIST", "T_NET", "T_CONN", "T_AREA", "T_THERMAL", "T_DRC", 
  "T_ATTRIBUTE", "'['", "']'", "'('", "')'", "$accept", "parse", 
  "parsepcb", "@1", "parsedata", "@2", "pcbfont", "parsefont", "@3", 
  "pcbfileversion", "pcbname", "pcbgrid", "pcbgridold", "pcbgridnew", 
  "pcb2grid", "pcbhigrid", "pcbcursor", "polyarea", "pcbthermal", 
  "pcbdrc", "pcbdrc1", "pcbdrc2", "pcbdrc3", "pcbflags", "pcbgroups", 
  "pcbstyles", "pcbdata", "pcbdefinitions", "pcbdefinition", "@4", "@5", 
  "via", "via_hi_format", "via_2.0_format", "via_1.7_format", 
  "via_newformat", "via_oldformat", "rats", "layer", "@6", "layerdata", 
  "layerdefinitions", "layerdefinition", "@7", "line_hi_format", 
  "line_1.7_format", "line_oldformat", "arc_hi_format", "arc_1.7_format", 
  "arc_oldformat", "text_oldformat", "text_newformat", "text_hi_format", 
  "polygonpoints", "polygonpoint", "element", "element_oldformat", "@8", 
  "element_1.3.4_format", "@9", "element_newformat", "@10", 
  "element_1.7_format", "@11", "element_hi_format", "@12", 
  "elementdefinitions", "elementdefinition", "@13", "relementdefs", 
  "relementdef", "@14", "pin_hi_format", "pin_1.7_format", 
  "pin_1.6.3_format", "pin_newformat", "pin_oldformat", "pad_hi_format", 
  "pad_1.7_format", "pad_newformat", "pad", "flags", "symbols", "symbol", 
  "@15", "@16", "symbolid", "symboldata", "symboldefinitions", 
  "symboldefinition", "hiressymbol", "pcbnetlist", "pcbnetdef", "nets", 
  "netdefs", "net", "@17", "connections", "conndefs", "conn", 
  "attributes", "attribute", "opt_string", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,    91,    93,    40,
      41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    41,    42,    42,    42,    42,    44,    43,    46,    45,
      47,    47,    49,    48,    50,    50,    51,    51,    51,    52,
      52,    52,    52,    53,    54,    55,    56,    57,    57,    57,
      57,    58,    58,    59,    59,    60,    60,    60,    60,    61,
      62,    63,    64,    64,    65,    65,    66,    66,    66,    67,
      67,    68,    68,    69,    70,    69,    69,    69,    71,    69,
      69,    72,    72,    72,    72,    72,    73,    74,    75,    76,
      77,    78,    78,    80,    79,    81,    81,    82,    82,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    84,
      83,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    94,    95,    95,    95,    96,    96,    96,    96,    96,
      98,    97,   100,    99,   102,   101,   104,   103,   106,   105,
     107,   107,   108,   108,   108,   108,   108,   108,   108,   108,
     108,   108,   108,   109,   108,   110,   110,   111,   111,   111,
     111,   111,   111,   111,   111,   112,   111,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   122,   123,   123,
     125,   124,   126,   124,   127,   127,   128,   128,   129,   129,
     129,   130,   131,   132,   132,   133,   134,   134,   135,   135,
     137,   136,   138,   138,   139,   139,   140,   141,   141,   142,
     143,   143
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     0,    14,     0,     2,
       1,     0,     0,     2,     0,     4,     4,     6,     6,     1,
       1,     1,     1,     6,     7,     7,     7,     6,     6,     6,
       0,     0,     4,     0,     4,     0,     1,     1,     1,     6,
       7,     9,     4,     0,     4,     0,     4,     4,     0,     1,
       0,     1,     2,     1,     0,     2,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,    11,    11,    10,     9,
       8,    10,    10,     0,    10,     1,     0,     1,     2,     1,
       1,     1,     1,     1,     1,     8,     1,     1,     1,     0,
       8,    10,    10,     9,    12,    12,    11,     8,     9,     9,
       1,     2,     4,     4,     0,     1,     1,     1,     1,     1,
       0,    12,     0,    15,     0,    16,     0,    18,     0,    18,
       1,     2,     1,     1,     1,     1,     1,     8,     8,    10,
      10,     5,     5,     0,     2,     1,     2,     1,     1,     1,
       1,     8,     8,    10,    10,     0,     2,    12,    12,    10,
       9,     8,    13,    13,    11,    10,     1,     1,     1,     2,
       0,     9,     0,     9,     1,     1,     1,     2,     1,     1,
       0,     8,     8,     1,     0,     6,     1,     0,     1,     2,
       0,     9,     1,     0,     1,     2,     4,     1,     2,     5,
       1,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     5,     0,     2,    14,     3,     0,     4,     0,     1,
       0,     0,    60,     0,     0,     0,     9,     0,    51,     0,
       0,    53,    61,    62,    63,    64,    65,    56,    57,     0,
      13,   158,     0,     0,     0,     0,     0,     0,     0,     0,
      52,     0,    55,   187,     0,    59,   105,   106,   107,   108,
     109,     0,     0,   159,     0,     0,     0,     0,    30,    19,
      20,    21,    22,     0,     0,     0,     0,     0,     0,   188,
       0,     0,   164,   165,     0,     0,    15,     0,     0,     0,
       0,     0,    31,   191,     0,     0,     0,     0,     0,   156,
     157,     0,     0,     0,     0,     0,     0,     0,    16,     0,
       0,     0,     0,     0,     0,    33,   190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,   189,     0,     0,     0,   160,   162,
      18,    17,     0,     0,     0,     0,     0,     0,     0,     0,
      43,    36,    37,    38,    73,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   170,   170,     0,     0,    23,
       0,     0,     0,     0,    32,     0,     0,     0,    45,    76,
       0,     0,     0,     0,    70,     0,     0,     0,     0,     0,
       0,     0,     0,   166,   168,   169,     0,    26,    24,    25,
      28,    29,    27,    34,     0,     0,     0,    48,     0,     0,
       0,     0,     0,     0,    75,    77,    79,    80,    81,    82,
      83,    84,    88,    87,    86,     0,     0,     0,    69,     0,
       0,     0,     0,     0,     0,     0,     0,   161,   167,   163,
       0,     0,     0,     0,    11,     0,     0,     0,     0,     0,
       0,     0,     0,    74,    78,     0,     0,    68,    71,    72,
       0,     0,     0,   110,     0,     0,     0,    42,     0,     0,
       0,     0,    10,     0,     0,     0,     0,     0,     0,     0,
       0,    66,    67,     0,     0,     0,   133,     0,     0,     0,
      39,    44,     0,     0,   174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,   120,     0,   122,   123,   124,   125,   126,     0,
       0,     0,    40,    47,    46,     0,     7,   173,     0,     0,
       0,     0,     0,     0,     0,    89,     0,   112,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   111,   121,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   104,     0,   133,     0,   114,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   100,     0,   133,     0,   133,     0,     0,     0,     0,
       0,     0,     0,     0,   172,   171,   177,     0,     0,     0,
       0,    85,     0,     0,    97,     0,     0,    90,   101,   118,
     113,   116,   133,     0,     0,     0,     0,     0,     0,   131,
     132,     0,     0,   176,   178,     0,     0,    93,     0,     0,
      99,    98,     0,     0,   145,   145,   115,     0,     0,     0,
       0,     0,     0,     0,     0,   175,   179,    91,    92,     0,
       0,   103,   102,     0,     0,     0,     0,   145,   135,     0,
     138,   137,   140,   139,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    96,     0,     0,     0,     0,
       0,     0,     0,     0,   119,   136,   146,   117,   127,   128,
       0,     0,   151,     0,     0,     0,     0,    94,    95,     0,
       0,     0,     0,     0,     0,     0,     0,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,   155,     0,   129,   130,   180,     0,     0,
       0,     0,     0,     0,     0,     0,   154,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   182,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     185,   141,   142,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,   143,   144,     0,     0,     0,     0,   147,   148,     0,
       0,   152,   153
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     2,     3,     4,     5,     6,   271,     7,     8,    11,
      34,    58,    59,    60,    61,    62,    82,   105,   127,   150,
     151,   152,   153,   178,   207,   244,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,   179,
     213,   214,   215,   363,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   390,   391,    45,    46,   286,    47,   365,
      48,   395,    49,   445,    50,   444,   311,   312,   313,   467,
     468,   469,   470,   471,   314,   315,   316,   472,   473,   317,
     318,    91,    30,    31,   165,   166,    74,   192,   193,   194,
     195,   326,   327,   432,   433,   434,   547,   557,   558,   559,
      42,    43,   107
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -439
static const short yypact[] =
{
      11,  -439,    37,  -439,     7,  -439,    15,  -439,    16,  -439,
      18,    57,  -439,    22,    45,    55,  -439,    39,  -439,    36,
      82,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,   110,
      16,  -439,   102,   111,   101,   174,   187,   188,   189,   190,
    -439,   105,    36,  -439,   114,  -439,  -439,  -439,  -439,  -439,
    -439,   168,   168,  -439,   157,   191,   192,   117,   170,  -439,
    -439,  -439,  -439,   193,   197,   199,   200,   201,   202,  -439,
      97,   112,  -439,  -439,   203,   204,  -439,   206,     2,   205,
      73,   118,   163,   207,   208,   209,   211,   212,   210,  -439,
    -439,   213,   214,   215,   167,   177,   219,   221,  -439,   222,
     223,   224,   225,   226,   181,   196,  -439,   194,   228,   113,
     229,   230,   195,   231,   232,   233,   216,   217,   220,   227,
     236,   237,   238,   239,   240,   241,   234,   218,   235,   242,
     128,   244,   245,   246,  -439,   248,   129,   247,  -439,  -439,
    -439,  -439,   249,     3,   254,   156,   256,   243,   255,   250,
     251,  -439,  -439,  -439,  -439,   258,   133,   259,   252,   260,
     261,   262,   263,   265,   266,   253,   253,   257,   264,  -439,
     267,   268,   271,   270,  -439,   273,   274,   275,   269,    96,
     272,   276,   277,   278,  -439,    97,   280,   281,   282,   283,
     279,   123,   -13,  -439,  -439,  -439,   -10,  -439,  -439,  -439,
    -439,  -439,  -439,  -439,   285,   286,   284,   287,   126,   127,
     288,   130,   289,   290,    96,  -439,  -439,  -439,  -439,  -439,
    -439,  -439,  -439,  -439,  -439,    97,   291,   292,  -439,   293,
     294,   295,   296,   297,   298,   299,   300,  -439,  -439,  -439,
     302,   301,   306,   131,   303,   310,   313,   314,   317,   318,
     319,   321,    97,  -439,  -439,   304,   305,  -439,  -439,  -439,
     323,   326,   330,  -439,   332,   333,    14,  -439,   307,   334,
     337,    53,  -439,   335,   336,   341,   343,   345,   346,   347,
     311,  -439,  -439,   349,   315,   350,   104,   351,   353,    20,
    -439,  -439,   320,   322,   327,   356,   357,   358,   360,   361,
     362,   363,   328,   365,   331,     4,   136,   338,   339,   137,
     141,    41,  -439,    36,  -439,  -439,  -439,  -439,  -439,   366,
     368,   369,  -439,  -439,  -439,   340,  -439,  -439,   370,   371,
     372,   373,   377,   378,   134,  -439,    97,  -439,   379,   344,
     381,   382,   383,   384,   385,   386,   387,   388,  -439,  -439,
      36,   389,   390,   359,   354,   392,   393,   395,   396,   397,
     398,   399,   403,   142,   364,   104,   367,  -439,   405,   406,
     407,   409,   410,   411,   412,   413,   380,   391,  -439,   394,
     414,   416,   417,   418,   400,    97,   419,   401,   420,   421,
      34,  -439,   404,    61,   408,   104,   422,   423,   424,   425,
     426,   427,   415,   402,  -439,  -439,   428,    97,     5,   429,
     431,  -439,   430,   432,  -439,   433,   434,  -439,  -439,  -439,
    -439,  -439,    72,   435,   436,   135,   441,   442,   443,  -439,
    -439,   437,   438,   428,  -439,   439,   440,  -439,   445,   446,
    -439,  -439,   444,   447,   108,   108,  -439,   448,   449,   450,
     452,   454,   455,   457,   456,  -439,  -439,  -439,  -439,    97,
       6,  -439,  -439,   145,   146,   149,   150,    77,  -439,    36,
    -439,  -439,  -439,  -439,    88,   451,   453,   139,   458,   459,
     460,   461,   463,   462,   464,  -439,   467,   468,   470,   471,
     472,   476,   478,   480,  -439,  -439,    36,  -439,  -439,  -439,
     465,   481,  -439,   140,   482,   483,   466,  -439,  -439,   485,
     487,   488,   489,   491,   492,   493,   494,  -439,   469,   473,
     496,   474,   475,   477,   498,   499,   500,   504,   505,   507,
     508,   511,  -439,  -439,   479,  -439,  -439,  -439,   514,   515,
     517,   518,   519,   520,   521,   522,  -439,   495,   523,   525,
     526,   527,   528,   529,   530,   531,   497,   501,   495,  -439,
     502,   503,   532,   534,   535,   536,   539,   541,   540,  -439,
    -439,  -439,  -439,   542,   543,   544,   547,   548,   549,   513,
     550,   551,   552,   553,   516,   524,  -439,    97,   557,   555,
     556,  -439,  -439,   533,   537,    97,   560,  -439,  -439,   538,
     545,  -439,  -439
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -439,  -439,  -439,  -439,  -439,  -439,  -439,     0,  -439,  -439,
    -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,
    -439,  -439,  -439,  -439,  -439,  -439,   -20,  -439,   558,  -439,
    -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,
    -439,  -439,    56,  -439,  -439,  -439,  -439,  -439,  -439,  -439,
    -439,  -439,  -439,  -439,  -117,  -439,  -439,  -439,  -439,  -439,
    -439,  -439,  -439,  -439,  -439,  -439,  -361,  -308,  -439,  -166,
    -438,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,  -439,
    -439,  -184,  -439,   554,  -439,  -439,   546,   124,  -161,  -439,
    -439,  -439,  -439,  -439,  -439,  -142,  -439,  -439,  -439,  -265,
    -311,   -42,  -439
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -59
static const short yytable[] =
{
      69,   229,   350,   349,   393,    97,   168,   338,   436,   484,
     191,    -8,     1,   191,    10,   -50,    12,   289,    -6,    -6,
      -8,    -8,    -8,   321,    13,    14,    15,   237,    -8,   495,
     239,   238,   -58,   -12,   422,   238,   495,     9,    29,   -49,
      12,   255,    98,   169,   339,   437,   485,    -8,    13,    14,
      15,   -54,   290,   -50,    12,    32,   -58,   306,   322,   307,
     308,    35,    13,    14,    15,    33,   309,   310,   280,   -49,
     -58,   388,    41,   389,   417,   -54,   100,   306,   101,   307,
     308,   348,    36,   -50,    37,   349,   309,   310,   306,   -54,
     307,   308,    38,   463,    39,   464,   465,   309,   310,    44,
      89,   420,   466,    90,   463,    54,   464,   465,   208,   209,
     210,   211,   446,   466,   349,    92,   130,   494,    93,   131,
     306,    57,   307,   308,   463,   212,   464,   465,   497,   309,
     310,   156,   162,   466,   157,   163,   181,   361,   449,   182,
     362,   450,   500,   519,    68,   501,   520,    51,    55,    52,
      56,    70,   364,    71,    79,   102,    80,   103,   496,   171,
     235,   172,   236,   245,   247,   246,   248,   250,   269,   251,
     270,    72,    73,   340,   344,   341,   345,    63,   346,   388,
     347,   389,   486,   488,   487,   489,   490,   492,   491,   493,
      64,    65,    66,    67,    81,    76,   104,    77,    78,    83,
      84,   412,    85,    86,    87,   116,    94,    95,    88,    96,
      99,   108,   109,   106,   110,   111,   112,   117,   125,   113,
     114,   115,   118,   435,   119,   120,   121,   122,   123,   124,
     126,   129,   132,   133,   128,   134,   137,   135,   136,   142,
     143,   144,   145,   146,   272,   155,   147,   158,   159,   160,
     164,   294,   167,   149,   161,   138,   139,   170,   140,   173,
     175,   180,   183,   185,   186,   187,   188,   141,   189,   190,
     254,   148,   177,   418,   154,   483,   191,   204,   225,   474,
     227,   174,   226,   230,   231,   232,   233,   176,   240,   241,
     196,   456,   184,   570,   256,   197,   206,     0,   260,   261,
     262,     0,   264,   265,   198,   266,   200,   199,    69,   201,
     202,   203,   268,   273,   205,   243,   274,   275,   228,   234,
     276,   277,   278,   242,   279,   -12,   283,   249,   252,   284,
     253,   258,   257,   285,   259,   287,   288,   263,   295,   296,
     292,   267,   281,   293,   297,   282,   298,   291,   299,   300,
     301,   302,   303,   305,   319,   304,   320,   325,   323,   328,
     329,   330,   324,   331,   332,   333,   334,   335,   336,   351,
     337,   352,   353,   355,   356,   357,   358,   342,   343,   354,
     359,   360,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   379,   380,   381,   378,   382,   383,
     384,     0,   392,   593,   385,   386,   387,   394,   396,   397,
     398,   599,   399,   400,   401,   402,   403,   407,   404,   408,
     409,   410,   413,   415,   416,   423,   424,   425,   426,   427,
     428,   405,   438,   406,   439,     0,   442,   443,   447,   448,
     411,   414,   430,   419,   451,   452,   453,   421,   459,   460,
       0,   475,   476,   429,    69,   478,   477,   479,   480,   431,
     481,     0,   482,   504,   505,   503,     0,     0,   440,   506,
     509,   510,   441,   511,   512,   513,   454,   457,   455,   514,
     458,   515,   461,   516,   518,   521,   522,   462,   524,   498,
     525,   526,   527,   499,   528,   529,   530,   531,   502,   534,
     507,   538,   539,   540,   508,   517,   523,   541,   542,   532,
     543,   544,   535,   533,   545,   536,   537,   548,   549,   546,
     550,   551,   552,   553,   554,   555,   560,   556,   561,   562,
     563,   564,   565,   566,   567,   573,   568,   574,   575,   576,
     571,   569,   577,   572,   578,     0,   579,   582,   580,   581,
     583,   584,   585,   586,   591,     0,   587,   588,   589,   590,
     594,   595,   596,   600,   592,     0,     0,     0,     0,     0,
       0,   597,     0,     0,     0,    40,   601,   598,     0,     0,
       0,     0,     0,     0,    53,   602,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    75
};

static const short yycheck[] =
{
      42,   185,   313,   311,   365,     3,     3,     3,     3,     3,
      23,     0,     1,    23,     7,     0,     1,     3,     7,     8,
       9,    10,    11,     3,     9,    10,    11,    40,    17,   467,
      40,   192,    17,    22,   395,   196,   474,     0,    22,     0,
       1,   225,    40,    40,    40,    40,    40,    36,     9,    10,
      11,    36,    38,     0,     1,    37,    17,    16,    38,    18,
      19,    39,     9,    10,    11,     8,    25,    26,   252,    30,
      17,    37,    36,    39,    40,    36,     3,    16,     5,    18,
      19,    40,    37,    30,    39,   393,    25,    26,    16,    36,
      18,    19,    37,    16,    39,    18,    19,    25,    26,    17,
       3,    40,    25,     6,    16,     3,    18,    19,    12,    13,
      14,    15,    40,    25,   422,     3,     3,    40,     6,     6,
      16,    20,    18,    19,    16,    29,    18,    19,    40,    25,
      26,     3,     3,    25,     6,     6,     3,     3,     3,     6,
       6,     6,     3,     3,    39,     6,     6,    37,    37,    39,
      39,    37,   336,    39,    37,    37,    39,    39,   469,     3,
      37,     5,    39,    37,    37,    39,    39,    37,    37,    39,
      39,     3,     4,    37,    37,    39,    39,     3,    37,    37,
      39,    39,    37,    37,    39,    39,    37,    37,    39,    39,
       3,     3,     3,     3,    24,    38,    33,     6,     6,     6,
       3,   385,     3,     3,     3,    38,     3,     3,     6,     3,
       5,     3,     3,     6,     3,     3,     6,    40,    37,     6,
       6,     6,     3,   407,     3,     3,     3,     3,     3,     3,
      34,     3,     3,     3,    40,    40,     3,     6,     6,     3,
       3,     3,     3,     3,   244,     3,     5,     3,     3,     3,
       3,   271,     3,    35,     6,    39,    39,     3,    38,     3,
       5,     3,     3,     3,     3,     3,     3,    40,     3,     3,
     214,    37,    21,   390,    39,   459,    23,     3,     6,   445,
       3,    38,     6,     3,     3,     3,     3,    37,     3,     3,
     166,   433,    40,   558,     3,    38,    27,    -1,     3,     3,
       3,    -1,     3,     3,    40,     3,    38,    40,   350,    38,
      40,    38,     6,     3,    39,    28,     3,     3,    40,    40,
       3,     3,     3,    39,     3,    22,     3,    39,    39,     3,
      40,    38,    40,     3,    40,     3,     3,    39,     3,     3,
       6,    40,    38,     6,     3,    40,     3,    40,     3,     3,
       3,    40,     3,     3,     3,    40,     3,    30,    38,     3,
       3,     3,    40,     3,     3,     3,     3,    39,     3,     3,
      39,     3,     3,     3,     3,     3,     3,    39,    39,    39,
       3,     3,     3,    39,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,    40,     3,     3,    38,     3,     3,
       3,    -1,    38,   587,     6,     6,     3,    40,     3,     3,
       3,   595,     3,     3,     3,     3,     3,     3,    38,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,    40,     3,    39,     3,    -1,     3,     3,     3,     3,
      40,    40,    40,    39,     3,     3,     3,    39,     3,     3,
      -1,     3,     3,    38,   496,     3,     6,     3,     3,    31,
       3,    -1,     6,     3,     3,     6,    -1,    -1,    38,     6,
       3,     3,    40,     3,     3,     3,    39,    38,    40,     3,
      40,     3,    38,     3,     3,     3,     3,    40,     3,    38,
       3,     3,     3,    40,     3,     3,     3,     3,    40,     3,
      38,     3,     3,     3,    40,    40,    40,     3,     3,    40,
       3,     3,    38,    40,     3,    40,    39,     3,     3,    40,
       3,     3,     3,     3,     3,     3,     3,    32,     3,     3,
       3,     3,     3,     3,     3,     3,    39,     3,     3,     3,
      38,    40,     3,    40,     3,    -1,     6,     3,     6,     6,
       3,     3,     3,    40,    38,    -1,     6,     6,     6,     6,
       3,     6,     6,     3,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    38,    -1,    -1,    -1,    17,    38,    40,    -1,    -1,
      -1,    -1,    -1,    -1,    30,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    52
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    42,    43,    44,    45,    46,    48,    49,     0,
       7,    50,     1,     9,    10,    11,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    22,
     123,   124,    37,     8,    51,    39,    37,    39,    37,    39,
      69,    36,   141,   142,    17,    96,    97,    99,   101,   103,
     105,    37,    39,   124,     3,    37,    39,    20,    52,    53,
      54,    55,    56,     3,     3,     3,     3,     3,    39,   142,
      37,    39,     3,     4,   127,   127,    38,     6,     6,    37,
      39,    24,    57,     6,     3,     3,     3,     3,     6,     3,
       6,   122,     3,     6,     3,     3,     3,     3,    40,     5,
       3,     5,    37,    39,    33,    58,     6,   143,     3,     3,
       3,     3,     6,     6,     6,     6,    38,    40,     3,     3,
       3,     3,     3,     3,     3,    37,    34,    59,    40,     3,
       3,     6,     3,     3,    40,     6,     6,     3,    39,    39,
      38,    40,     3,     3,     3,     3,     3,     5,    37,    35,
      60,    61,    62,    63,    39,     3,     3,     6,     3,     3,
       3,     6,     3,     6,     3,   125,   126,     3,     3,    40,
       3,     3,     5,     3,    38,     5,    37,    21,    64,    80,
       3,     3,     6,     3,    40,     3,     3,     3,     3,     3,
       3,    23,   128,   129,   130,   131,   128,    38,    40,    40,
      38,    38,    40,    38,     3,    39,    27,    65,    12,    13,
      14,    15,    29,    81,    82,    83,    85,    86,    87,    88,
      89,    90,    91,    92,    93,     6,     6,     3,    40,   122,
       3,     3,     3,     3,    40,    37,    39,    40,   129,    40,
       3,     3,    39,    28,    66,    37,    39,    37,    39,    39,
      37,    39,    39,    40,    83,   122,     3,    40,    38,    40,
       3,     3,     3,    39,     3,     3,     3,    40,     6,    37,
      39,    47,    48,     3,     3,     3,     3,     3,     3,     3,
     122,    38,    40,     3,     3,     3,    98,     3,     3,     3,
      38,    40,     6,     6,    67,     3,     3,     3,     3,     3,
       3,     3,    40,     3,    40,     3,    16,    18,    19,    25,
      26,   107,   108,   109,   115,   116,   117,   120,   121,     3,
       3,     3,    38,    38,    40,    30,   132,   133,     3,     3,
       3,     3,     3,     3,     3,    39,     3,    39,     3,    40,
      37,    39,    39,    39,    37,    39,    37,    39,    40,   108,
     141,     3,     3,     3,    39,     3,     3,     3,     3,     3,
       3,     3,     6,    84,   122,   100,     3,    39,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,    38,    40,
       3,     3,     3,     3,     3,     6,     6,     3,    37,    39,
      94,    95,    38,   107,    40,   102,     3,     3,     3,     3,
       3,     3,     3,     3,    38,    40,    39,     3,     3,     3,
       3,    40,   122,     3,    40,     3,     3,    40,    95,    39,
      40,    39,   107,     3,     3,     3,     3,     3,     3,    38,
      40,    31,   134,   135,   136,   122,     3,    40,     3,     3,
      38,    40,     3,     3,   106,   104,    40,     3,     3,     3,
       6,     3,     3,     3,    39,    40,   136,    38,    40,     3,
       3,    38,    40,    16,    18,    19,    25,   110,   111,   112,
     113,   114,   118,   119,   110,     3,     3,     6,     3,     3,
       3,     3,     6,   122,     3,    40,    37,    39,    37,    39,
      37,    39,    37,    39,    40,   111,   141,    40,    38,    40,
       3,     6,    40,     6,     3,     3,     6,    38,    40,     3,
       3,     3,     3,     3,     3,     3,     3,    40,     3,     3,
       6,     3,     3,    40,     3,     3,     3,     3,     3,     3,
       3,     3,    40,    40,     3,    38,    40,    39,     3,     3,
       3,     3,     3,     3,     3,     3,    40,   137,     3,     3,
       3,     3,     3,     3,     3,     3,    32,   138,   139,   140,
       3,     3,     3,     3,     3,     3,     3,     3,    39,    40,
     140,    38,    40,     3,     3,     3,     3,     3,     3,     6,
       6,     6,     3,     3,     3,     3,    40,     6,     6,     6,
       6,    38,    40,   122,     3,     6,     6,    38,    40,   122,
       3,    38,    40
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 118 "parse_y.y"
    { YYABORT; }
    break;

  case 6:
#line 142 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyPCB)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyFont = &yyPCB->Font;
				yyData = yyPCB->Data;
				yyData->pcb = (void *)yyPCB;
				yyData->LayerN = 0;
				layer_group_string = NULL;
			}
    break;

  case 7:
#line 174 "parse_y.y"
    {
			  int i, j;

			  if (layer_group_string == NULL)
			    layer_group_string = Settings.Groups;
			  CreateNewPCBPost (yyPCB, 0);
			  if (ParseGroupString(layer_group_string, &yyPCB->LayerGroups, yyData->LayerN))
			    {
			      Message("illegal layer-group string\n");
			      YYABORT;
			    }
			/* initialize the polygon clipping now since
			 * we didn't know the layer grouping before.
			 */
			for (i = 0; i < yyData->LayerN; i++)
			  for (j = 0; j < yyData->Layer[i].PolygonN; j++)
			      InitClip (yyData, &yyData->Layer[i], &yyData->Layer[i].Polygon[j]);
			}
    break;

  case 8:
#line 196 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyData || !yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyData->LayerN = 0;
			}
    break;

  case 12:
#line 221 "parse_y.y"
    {
					/* mark all symbols invalid */
				int	i;

				if (!yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				yyFont->Valid = False;
				for (i = 0; i <= MAX_FONTPOSITION; i++)
					yyFont->Symbol[i].Valid = False;
			}
    break;

  case 13:
#line 235 "parse_y.y"
    {
				yyFont->Valid = True;
		  		SetFontInfo(yyFont);
			}
    break;

  case 15:
#line 263 "parse_y.y"
    {
  if (check_file_version (yyvsp[-1].number) != 0)
    {
      YYABORT;
    }
}
    break;

  case 16:
#line 295 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-1].string;
				yyPCB->MaxWidth = MAX_COORD;
				yyPCB->MaxHeight = MAX_COORD;
			}
    break;

  case 17:
#line 301 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number*100;
				yyPCB->MaxHeight = yyvsp[-1].number*100;
			}
    break;

  case 18:
#line 307 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number;
				yyPCB->MaxHeight = yyvsp[-1].number;
			}
    break;

  case 23:
#line 342 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-3].number*100;
				yyPCB->GridOffsetX = yyvsp[-2].number*100;
				yyPCB->GridOffsetY = yyvsp[-1].number*100;
			}
    break;

  case 24:
#line 350 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].number*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 25:
#line 363 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 26:
#line 375 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating;
				yyPCB->GridOffsetX = yyvsp[-3].number;
				yyPCB->GridOffsetY = yyvsp[-2].number;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 27:
#line 407 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number*100;
				yyPCB->CursorY = yyvsp[-2].number*100;
				yyPCB->Zoom = yyvsp[-1].number*2;
			}
    break;

  case 28:
#line 413 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].number;
			}
    break;

  case 29:
#line 419 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].floating;
			}
    break;

  case 32:
#line 443 "parse_y.y"
    {
				yyPCB->IsleArea = yyvsp[-1].floating;
			}
    break;

  case 34:
#line 467 "parse_y.y"
    {
				yyPCB->ThermScale = yyvsp[-1].floating;
			}
    break;

  case 39:
#line 506 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-3].number;
				yyPCB->Shrink = yyvsp[-2].number;
				yyPCB->minWid = yyvsp[-1].number;
			}
    break;

  case 40:
#line 515 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-4].number;
				yyPCB->Shrink = yyvsp[-3].number;
				yyPCB->minWid = yyvsp[-2].number;
				yyPCB->minSlk = yyvsp[-1].number;
			}
    break;

  case 41:
#line 525 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-6].number;
				yyPCB->Shrink = yyvsp[-5].number;
				yyPCB->minWid = yyvsp[-4].number;
				yyPCB->minSlk = yyvsp[-3].number;
				yyPCB->minDrill = yyvsp[-2].number;
				yyPCB->minRing = yyvsp[-1].number;
			}
    break;

  case 42:
#line 552 "parse_y.y"
    {
				yyPCB->Flags = MakeFlags (yyvsp[-1].number & PCB_FLAGS);
			}
    break;

  case 44:
#line 584 "parse_y.y"
    {
			  layer_group_string = yyvsp[-1].string;
			}
    break;

  case 46:
#line 632 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 100))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 47:
#line 640 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 1))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 54:
#line 662 "parse_y.y"
    { attr_list = & yyPCB->Attributes; }
    break;

  case 58:
#line 666 "parse_y.y"
    {
					/* clear pointer to force memory allocation by 
					 * the appropriate subroutine
					 */
				yyElement = NULL;
			}
    break;

  case 60:
#line 673 "parse_y.y"
    { YYABORT; }
    break;

  case 66:
#line 718 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 67:
#line 727 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].string,
					OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 68:
#line 738 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					     (yyvsp[-5].number + yyvsp[-4].number)*100, yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 69:
#line 748 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100,  yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 70:
#line 758 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewVia(yyData, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 71:
#line 794 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, yyvsp[-1].flagtype);
			}
    break;

  case 72:
#line 799 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, OldFlags(yyvsp[-1].number));
			}
    break;

  case 73:
#line 830 "parse_y.y"
    {
				if (yyvsp[-4].number <= 0 || yyvsp[-4].number > MAX_LAYER + 2)
				{
					yyerror("Layernumber out of range");
					YYABORT;
				}
				if (LayerFlag[yyvsp[-4].number-1])
				{
					yyerror("Layernumber used twice");
					YYABORT;
				}
				Layer = &yyData->Layer[yyvsp[-4].number-1];

					/* memory for name is already allocated */
				Layer->Name = yyvsp[-3].string;
				LayerFlag[yyvsp[-4].number-1] = True;
				if (yyData->LayerN + 2 < yyvsp[-4].number)
				  yyData->LayerN = yyvsp[-4].number - 2;
			}
    break;

  case 85:
#line 871 "parse_y.y"
    {
				CreateNewPolygonFromRectangle(Layer,
					yyvsp[-5].number*100, yyvsp[-4].number*100, (yyvsp[-5].number+yyvsp[-3].number)*100, (yyvsp[-4].number+yyvsp[-2].number)*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 89:
#line 880 "parse_y.y"
    {
				Polygon = CreateNewPolygon(Layer, yyvsp[-2].flagtype);
			}
    break;

  case 90:
#line 884 "parse_y.y"
    {
					/* ignore junk */
				if (Polygon->PointN >= 3)
				  {
				    SetPolygonBoundingBox (Polygon);
				    if (!Layer->polygon_tree)
				      Layer->polygon_tree = r_create_tree (NULL, 0, 0);
				    r_insert_entry (Layer->polygon_tree, (BoxType *) Polygon, 0);
				  }
				else
				{
					Message("WARNING parsing file '%s'\n"
						"    line:        %i\n"
						"    description: 'ignored polygon (< 3 points)'\n",
						yyfilename, yylineno);
					DestroyObject(yyData, POLYGON_TYPE, Layer, Polygon, Polygon);
				}
			}
    break;

  case 91:
#line 933 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].flagtype);
			}
    break;

  case 92:
#line 941 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
						     yyvsp[-3].number*100, yyvsp[-2].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 93:
#line 950 "parse_y.y"
    {
				/* eliminate old-style rat-lines */
			if ((yyvsp[-1].number & RATFLAG) == 0)
				CreateNewLineOnLayer(Layer, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100,
					200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 94:
#line 998 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-1].flagtype);
			}
    break;

  case 95:
#line 1006 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number*100, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-3].number, yyvsp[-2].number,
						    yyvsp[-5].number*100, yyvsp[-4].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 96:
#line 1015 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-3].number, yyvsp[-2].number,
					yyvsp[-4].number*100, 200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 97:
#line 1052 "parse_y.y"
    {
					/* use a default scale of 100% */
				CreateNewText(Layer,yyFont,yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, 100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 98:
#line 1062 "parse_y.y"
    {
				if (yyvsp[-1].number & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[yyData->LayerN +
						((yyvsp[-1].number & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay ,yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 99:
#line 1080 "parse_y.y"
    {
				/* FIXME: shouldn't know about .f */
				/* I don't think this matters because anything with hi_format
				 * will have the silk on its own layer in the file rather
				 * than using the ONSILKFLAG and having it in a copper layer.
				 * Thus there is no need for anything besides the 'else'
				 * part of this code.
				 */
				if (yyvsp[-1].flagtype.f & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[yyData->LayerN +
						((yyvsp[-1].flagtype.f & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 102:
#line 1127 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 103:
#line 1131 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 110:
#line 1203 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, NoFlags(),
					yyvsp[-6].string, yyvsp[-5].string, NULL, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number, 100, NoFlags(), False);
				SaveFree(yyvsp[-6].string);
				SaveFree(yyvsp[-5].string);
				pin_num = 1;
			}
    break;

  case 111:
#line 1211 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 112:
#line 1221 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-9].number),
					yyvsp[-8].string, yyvsp[-7].string, NULL, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 113:
#line 1229 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 114:
#line 1239 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-10].number),
					yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-9].string);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 115:
#line 1248 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 116:
#line 1259 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-12].number),
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number)*100, (yyvsp[-7].number+yyvsp[-5].number)*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				yyElement->MarkX = yyvsp[-8].number*100;
				yyElement->MarkY = yyvsp[-7].number*100;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 117:
#line 1269 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 118:
#line 1280 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-12].flagtype,
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number), (yyvsp[-7].number+yyvsp[-5].number), yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].flagtype, False);
				yyElement->MarkX = yyvsp[-8].number;
				yyElement->MarkY = yyvsp[-7].number;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 119:
#line 1290 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 127:
#line 1370 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 128:
#line 1375 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 129:
#line 1380 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 130:
#line 1385 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 131:
#line 1390 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number;
				yyElement->MarkY = yyvsp[-1].number;
			}
    break;

  case 132:
#line 1395 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number*100;
				yyElement->MarkY = yyvsp[-1].number*100;
			}
    break;

  case 133:
#line 1399 "parse_y.y"
    { attr_list = & yyElement->Attributes; }
    break;

  case 141:
#line 1414 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number + yyElement->MarkX,
					yyvsp[-4].number + yyElement->MarkY, yyvsp[-3].number + yyElement->MarkX,
					yyvsp[-2].number + yyElement->MarkY, yyvsp[-1].number);
			}
    break;

  case 142:
#line 1420 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100 + yyElement->MarkX,
					yyvsp[-4].number*100 + yyElement->MarkY, yyvsp[-3].number*100 + yyElement->MarkX,
					yyvsp[-2].number*100 + yyElement->MarkY, yyvsp[-1].number*100);
			}
    break;

  case 143:
#line 1427 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number + yyElement->MarkX,
					yyvsp[-6].number + yyElement->MarkY, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 144:
#line 1432 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100 + yyElement->MarkX,
					yyvsp[-6].number*100 + yyElement->MarkY, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 145:
#line 1436 "parse_y.y"
    { attr_list = & yyElement->Attributes; }
    break;

  case 147:
#line 1478 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number + yyElement->MarkX,
					yyvsp[-8].number + yyElement->MarkY, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].string,
					yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 148:
#line 1490 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number*100 + yyElement->MarkX,
					yyvsp[-8].number*100 + yyElement->MarkY, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].string,
					yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 149:
#line 1502 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-5].number + 2*MASKFRAME)*100, yyvsp[-4].number*100, yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 150:
#line 1513 "parse_y.y"
    {
				char	p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].number*100, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));

				SaveFree(yyvsp[-2].string);
			}
    break;

  case 151:
#line 1529 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);
				char		p_number[8];

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 152:
#line 1583 "parse_y.y"
    {
				CreateNewPad(yyElement, yyvsp[-10].number + yyElement->MarkX,
					yyvsp[-9].number + yyElement->MarkY,
					yyvsp[-8].number + yyElement->MarkX,
					yyvsp[-7].number + yyElement->MarkY, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number,
					yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 153:
#line 1597 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-10].number*100 + yyElement->MarkX,
					yyvsp[-9].number*100 + yyElement->MarkY, yyvsp[-8].number*100 + yyElement->MarkX,
					yyvsp[-7].number*100 + yyElement->MarkY, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 154:
#line 1610 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-8].number*100,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].string,yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 155:
#line 1621 "parse_y.y"
    {
				char		p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPad(yyElement,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100,yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, yyvsp[-2].string,p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 156:
#line 1631 "parse_y.y"
    { yyval.flagtype = OldFlags(yyvsp[0].number); }
    break;

  case 157:
#line 1632 "parse_y.y"
    { yyval.flagtype = string_to_flags (yyvsp[0].string, yyerror); }
    break;

  case 160:
#line 1661 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number;
			}
    break;

  case 162:
#line 1678 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number*100;
			}
    break;

  case 171:
#line 1731 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 172:
#line 1738 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 180:
#line 1792 "parse_y.y"
    {
				Menu = CreateNewNet(&yyPCB->NetlistLib, yyvsp[-3].string, yyvsp[-2].string);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 186:
#line 1827 "parse_y.y"
    {
				CreateNewConnection(Menu, yyvsp[-1].string);
				SaveFree(yyvsp[-1].string);
			}
    break;

  case 189:
#line 1860 "parse_y.y"
    {
				CreateNewAttribute (attr_list, yyvsp[-2].string, yyvsp[-1].string);
				SaveFree (yyvsp[-2].string);
				SaveFree (yyvsp[-1].string);
			}
    break;

  case 190:
#line 1867 "parse_y.y"
    { yyval.string = yyvsp[0].string; }
    break;

  case 191:
#line 1868 "parse_y.y"
    { yyval.string = 0; }
    break;


    }

/* Line 991 of yacc.c.  */
#line 2563 "parse_y.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  MacOS 10.2.3's buggy "smart preprocessor"
     insists on the trailing semicolon.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__));
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1871 "parse_y.y"


/* ---------------------------------------------------------------------------
 * error routine called by parser library
 */
int yyerror(s)
const char *s;
{
	Message("ERROR parsing file '%s'\n"
		"    line:        %i\n"
		"    description: '%s'\n",
		yyfilename, yylineno, s);
	return(0);
}

int yywrap()
{
  return 1;
}


static int
check_file_version (int ver)
{
  if ( ver > PCB_FILE_VERSION ) {
    Message ("ERROR:  The file you are attempting to load is in a format\n"
	     "which is too new for this version of pcb.  To load this file\n"
	     "you need a version of pcb which is >= %d\n", ver);
    return 1;
  }
  
  return 0;
}


