/*
    scconfig - detection of standard library features: time/date/sleep related calls
    Copyright (C) 2011..2012  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"

int find_time_usleep(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "#include <unistd.h>"
		NL "int main() {"
		NL "	if (usleep(1) == 0)"
		NL "		puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for usleep()... ");
	logprintf(logdepth, "find_time_usleep: trying to find usleep...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/time/usleep", test_c, NULL, NULL, NULL))
		return 0;
	return try_fail(logdepth, "libs/time/usleep");
}

int find_time_Sleep(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "int main() {"
		NL "	Sleep(1);"
		NL "	puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for Sleep()... ");
	logprintf(logdepth, "find_time_Sleep: trying to find Sleep...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/time/Sleep", test_c, "#include <windows.h>", NULL, NULL))
		return 0;
	return try_fail(logdepth, "libs/time/Sleep");
}

int find_time_gettimeofday(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "#include <stdlib.h>"
		NL "int main() {"
		NL "	struct timeval tv;"
		NL "	if (gettimeofday(&tv, NULL) == 0)"
		NL "		puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for gettimeofday()... ");
	logprintf(logdepth, "find_time_gettimeofday: trying to find gettimeofday...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/time/gettimeofday", test_c, "#include <sys/time.h>", NULL, NULL))
		return 0;
	return try_fail(logdepth, "libs/time/gettimeofday");
}


int find_time_ftime(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "int main() {"
		NL "	struct timeb tb;"
		NL "	if (ftime(&tb) == 0)"
		NL "		puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for ftime()... ");
	logprintf(logdepth, "find_time_ftime: trying to find ftime...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/time/ftime", test_c, "#include <sys/timeb.h>", NULL, NULL))
		return 0;
	return try_fail(logdepth, "libs/time/ftime");
}

